% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{set_autonum_bookmark}
\alias{set_autonum_bookmark}
\title{Update bookmark of an autonumber run}
\usage{
set_autonum_bookmark(x, bkm = NULL)
}
\arguments{
\item{x}{an object of class \code{\link[=run_autonum]{run_autonum()}}}

\item{bkm}{bookmark id to associate with autonumber run.
Value can only be made of alpha numeric characters, ':', -' and '_'.}
}
\description{
This function lets recycling a object
made by \code{\link[=run_autonum]{run_autonum()}} by changing the bookmark value. This
is useful to avoid calling \code{run_autonum()} several times
because of many tables.
}
\examples{
z <- run_autonum(
  seq_id = "tab", pre_label = "Table ",
  bkm = "anytable"
)
set_autonum_bookmark(z, bkm = "anothertable")
}
\seealso{
\code{\link[=run_autonum]{run_autonum()}}
}
