# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING

from msrest import Serializer

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.arm_polling import ARMPolling

from .. import models as _models
from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Iterable, Optional, TypeVar, Union
    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_create_request_initial(
    registry_name,  # type: str
    name,  # type: str
    version,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/registries/{registryName}/{name}/versions/{version}")
    path_format_arguments = {
        "registryName": _SERIALIZER.url("registry_name", registry_name, 'str'),
        "name": _SERIALIZER.url("name", name, 'str', max_length=254, min_length=0, pattern=r'^[a-zA-Z0-9][a-zA-Z0-9-_]*$'),
        "version": _SERIALIZER.url("version", version, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_list_request(
    registry_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
    name = kwargs.pop('name', None)  # type: Optional[str]
    tags = kwargs.pop('tags', None)  # type: Optional[str]
    continuation_token_parameter = kwargs.pop('continuation_token_parameter', None)  # type: Optional[str]
    continuation_token_from_header = kwargs.pop('continuation_token_from_header', None)  # type: Optional[str]
    count = kwargs.pop('count', None)  # type: Optional[int]
    stage = kwargs.pop('stage', None)  # type: Optional[str]
    list_view_type = kwargs.pop('list_view_type', "ActiveOnly")  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/registries/{registryName}/deploymenttemplates")
    path_format_arguments = {
        "registryName": _SERIALIZER.url("registry_name", registry_name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if name is not None:
        _query_parameters['name'] = _SERIALIZER.query("name", name, 'str')
    if tags is not None:
        _query_parameters['tags'] = _SERIALIZER.query("tags", tags, 'str')
    if continuation_token_parameter is not None:
        _query_parameters['continuationToken'] = _SERIALIZER.query("continuation_token_parameter", continuation_token_parameter, 'str')
    if count is not None:
        _query_parameters['count'] = _SERIALIZER.query("count", count, 'int')
    if stage is not None:
        _query_parameters['stage'] = _SERIALIZER.query("stage", stage, 'str')
    if list_view_type is not None:
        _query_parameters['listViewType'] = _SERIALIZER.query("list_view_type", list_view_type, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if continuation_token_from_header is not None:
        _header_parameters['continuation-token-from-header'] = _SERIALIZER.header("continuation_token_from_header", continuation_token_from_header, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_get_request(
    registry_name,  # type: str
    name,  # type: str
    version,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
    asset_resource_tenant_id = kwargs.pop('asset_resource_tenant_id', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/registries/{registryName}/deploymenttemplates/{name}/versions/{version}")
    path_format_arguments = {
        "registryName": _SERIALIZER.url("registry_name", registry_name, 'str'),
        "name": _SERIALIZER.url("name", name, 'str', max_length=254, min_length=0, pattern=r'^[a-zA-Z0-9][a-zA-Z0-9-_]*$'),
        "version": _SERIALIZER.url("version", version, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if asset_resource_tenant_id is not None:
        _query_parameters['assetResourceTenantId'] = _SERIALIZER.query("asset_resource_tenant_id", asset_resource_tenant_id, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_delete_request(
    registry_name,  # type: str
    name,  # type: str
    version,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/registries/{registryName}/deploymenttemplates/{name}/versions/{version}")
    path_format_arguments = {
        "registryName": _SERIALIZER.url("registry_name", registry_name, 'str'),
        "name": _SERIALIZER.url("name", name, 'str', max_length=254, min_length=0, pattern=r'^[a-zA-Z0-9][a-zA-Z0-9-_]*$'),
        "version": _SERIALIZER.url("version", version, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )

# fmt: on
class DeploymentTemplatesOperations(object):
    """DeploymentTemplatesOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.mgmt.machinelearningservices.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    def _create_initial(
        self,
        endpoint,  # type: str
        subscription_id,  # type: str
        resource_group_name,  # type: str
        registry_name,  # type: str
        name,  # type: str
        version,  # type: str
        body,  # type: "_models.DeploymentTemplate"
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.LongRunningNullResponse"
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LongRunningNullResponse"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _json = self._serialize.body(body, 'DeploymentTemplate')
        _json["type"] = "deploymenttemplates"
        request = build_create_request_initial(
            registry_name=registry_name,
            name=name,
            version=version,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self._create_initial.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize('LongRunningNullResponse', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    _create_initial.metadata = {'url': "/registries/{registryName}/{name}/versions/{version}"}  # type: ignore


    @distributed_trace
    def begin_create(
        self,
        endpoint,  # type: str
        subscription_id,  # type: str
        resource_group_name,  # type: str
        registry_name,  # type: str
        name,  # type: str
        version,  # type: str
        body,  # type: "_models.DeploymentTemplate"
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller["_models.LongRunningNullResponse"]
        """Creates a deployment template version.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param registry_name: The name of the AzureML registry.
        :type registry_name: str
        :param name: Name of the deployment template.
        :type name: str
        :param version: Version of the deployment template.
        :type version: str
        :param body: Properties of a Deployment Template Version.
        :type body: ~azure.mgmt.machinelearningservices.models.DeploymentTemplate
        :keyword callable cls: A custom type or function that will be passed the direct response
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be ARMPolling. Pass in False for this
         operation to not poll, or pass in your own initialized polling object for a personal polling
         strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns either LongRunningNullResponse or the result of
         cls(response)
        :rtype:
         ~azure.core.polling.LROPoller[~azure.mgmt.machinelearningservices.models.LongRunningNullResponse]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        polling = kwargs.pop('polling', True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.LongRunningNullResponse"]
        lro_delay = kwargs.pop(
            'polling_interval',
            self._config.polling_interval
        )
        cont_token = kwargs.pop('continuation_token', None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._create_initial(
                endpoint=endpoint,
                subscription_id=subscription_id,
                resource_group_name=resource_group_name,
                registry_name=registry_name,
                name=name,
                version=version,
                body=body,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x,y,z: x,
                **kwargs
            )
        kwargs.pop('error_map', None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = self._deserialize('LongRunningNullResponse', pipeline_response)
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized


        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }

        if polling is True: polling_method = ARMPolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False: polling_method = NoPolling()
        else: polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    begin_create.metadata = {'url': "/registries/{registryName}/{name}/versions/{version}"}  # type: ignore

    @distributed_trace
    def list(
        self,
        endpoint,  # type: str
        subscription_id,  # type: str
        resource_group_name,  # type: str
        registry_name,  # type: str
        name=None,  # type: Optional[str]
        tags=None,  # type: Optional[str]
        continuation_token_parameter=None,  # type: Optional[str]
        continuation_token_from_header=None,  # type: Optional[str]
        count=None,  # type: Optional[int]
        stage=None,  # type: Optional[str]
        list_view_type="ActiveOnly",  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["_models.PagedDeploymentTemplate"]
        """List deployment templates.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param registry_name: The name of the AzureML registry.
        :type registry_name: str
        :param name: Filter by deployment template name.
        :type name: str
        :param tags: Comma-separated list of tag names (and optionally values). Example:
         tag1,tag2=value2.
        :type tags: str
        :param continuation_token_parameter: Continuation token for pagination.
        :type continuation_token_parameter: str
        :param continuation_token_from_header: Continuation token for pagination (from header).
        :type continuation_token_from_header: str
        :param count: Maximum number of items to return.
        :type count: int
        :param stage: Filter by deployment template stage.
        :type stage: str
        :param list_view_type: View type for including/excluding (for example) archived entities.
        :type list_view_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either PagedDeploymentTemplate or the result of
         cls(response)
        :rtype:
         ~azure.core.paging.ItemPaged[~azure.mgmt.machinelearningservices.models.PagedDeploymentTemplate]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        cls = kwargs.pop('cls', None)  # type: ClsType["_models.PagedDeploymentTemplate"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_request(
                    registry_name=registry_name,
                    api_version=api_version,
                    name=name,
                    tags=tags,
                    continuation_token_parameter=continuation_token_parameter,
                    continuation_token_from_header=continuation_token_from_header,
                    count=count,
                    stage=stage,
                    list_view_type=list_view_type,
                    template_url=self.list.metadata['url'],
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_list_request(
                    registry_name=registry_name,
                    api_version=api_version,
                    name=name,
                    tags=tags,
                    continuation_token_parameter=continuation_token_parameter,
                    continuation_token_from_header=continuation_token_from_header,
                    count=count,
                    stage=stage,
                    list_view_type=list_view_type,
                    template_url=next_link,
                )
                request = _convert_request(request)
                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
                    "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
                    "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize("PagedDeploymentTemplate", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
                request,
                stream=False,
                **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response


        return ItemPaged(
            get_next, extract_data
        )
    list.metadata = {'url': "/registries/{registryName}/deploymenttemplates"}  # type: ignore

    @distributed_trace
    def get(
        self,
        endpoint,  # type: str
        subscription_id,  # type: str
        resource_group_name,  # type: str
        registry_name,  # type: str
        name,  # type: str
        version,  # type: str
        asset_resource_tenant_id=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.DeploymentTemplate"
        """Get a specific version of a deployment template.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param registry_name: The name of the AzureML registry.
        :type registry_name: str
        :param name: Name of the deployment template.
        :type name: str
        :param version: Version of the deployment template.
        :type version: str
        :param asset_resource_tenant_id: Asset resource tenant ID.
        :type asset_resource_tenant_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeploymentTemplate, or the result of cls(response)
        :rtype: ~azure.mgmt.machinelearningservices.models.DeploymentTemplate
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.DeploymentTemplate"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        
        request = build_get_request(
            registry_name=registry_name,
            name=name,
            version=version,
            api_version=api_version,
            asset_resource_tenant_id=asset_resource_tenant_id,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize('DeploymentTemplate', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': "/registries/{registryName}/deploymenttemplates/{name}/versions/{version}"}  # type: ignore


    @distributed_trace
    def delete(  # pylint: disable=inconsistent-return-statements
        self,
        endpoint,  # type: str
        subscription_id,  # type: str
        resource_group_name,  # type: str
        registry_name,  # type: str
        name,  # type: str
        version,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Delete a specific version of a deployment template.

        :param endpoint: Supported Azure-AI asset endpoints.
        :type endpoint: str
        :param subscription_id: The ID of the target subscription.
        :type subscription_id: str
        :param resource_group_name: The name of the Resource Group.
        :type resource_group_name: str
        :param registry_name: The name of the AzureML registry.
        :type registry_name: str
        :param name: Name of the deployment template.
        :type name: str
        :param version: Version of the deployment template.
        :type version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2024-04-01-preview")  # type: str

        
        request = build_delete_request(
            registry_name=registry_name,
            name=name,
            version=version,
            api_version=api_version,
            template_url=self.delete.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("endpoint", endpoint, 'str', skip_quote=True),
            "subscriptionId": self._serialize.url("subscription_id", subscription_id, 'str'),
            "resourceGroupName": self._serialize.url("resource_group_name", resource_group_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.AzureCoreFoundationsErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {'url': "/registries/{registryName}/deploymenttemplates/{name}/versions/{version}"}  # type: ignore

