# pyOCD debugger
# Copyright (c) 2021 NXP
# SPDX-License-Identifier: Apache-2.0
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from ..family.target_kinetis import Kinetis
from ..family.flash_kinetis import Flash_Kinetis
from ...core.memory_map import (FlashRegion, RamRegion, MemoryMap)
from ...debug.svd.loader import SVDFile

FLASH_ALGO = {
    'load_address' : 0x1fffc000,

    # Flash algorithm as a hex string
    'instructions': [
    0xe00abe00,
    0xb5104945, 0x60084449, 0x21fe4843, 0x1d004448, 0x21ff7001, 0x70817041, 0x202f70c1, 0x0280493f,
    0x483f60c8, 0x064968c1, 0x29020f89, 0x68c1d106, 0x4011229f, 0x694160c1, 0xd1fc2901, 0x68014839,
    0xd5010489, 0xe0024938, 0x60414938, 0x60414938, 0x60814938, 0x60014938, 0x49384839, 0x60014448,
    0x04922201, 0x60822100, 0x77016041, 0x62011e49, 0xf91bf000, 0xd0002800, 0xbd102001, 0x47702000,
    0xb5084a30, 0x0349447a, 0x0c0a9200, 0x482c4601, 0x44482300, 0xfa09f000, 0xd0002800, 0xbd082001,
    0x4928b508, 0x48264479, 0x44483920, 0xf88bf000, 0xd10e2800, 0x44784823, 0x4b173832, 0x48209000,
    0x1d1b444b, 0x49202204, 0xf0004448, 0x2800f8f3, 0x2001d000, 0xb510bd08, 0x447b4b1a, 0x48184601,
    0x3b562201, 0x444802d2, 0xf890f000, 0xd0002800, 0xbd102001, 0x4613b508, 0x088a1cc9, 0x00924911,
    0x397c4479, 0x46019100, 0x4448480d, 0xf8d2f000, 0xd0002800, 0xbd082001, 0x00000004, 0xf0003000,
    0x4007e000, 0x40052000, 0xd928c520, 0x0000c520, 0x0000d928, 0x0000ffff, 0x00002020, 0x40020000,
    0x0000000c, 0x00000115, 0x0000040c, 0x4607b5f8, 0x20004614, 0x190a460d, 0x68799000, 0x42a9461e,
    0x68bbd803, 0x429118c9, 0x2101d203, 0x24000309, 0x21009100, 0xe00d6031, 0x68327829, 0x18511c40,
    0x1c6d1e64, 0x280a6031, 0x6a38d304, 0xd0001c41, 0x20004780, 0xd1ef2c00, 0xbdf89800, 0x4604b570,
    0x78016800, 0x43112280, 0x68257001, 0x6a21e003, 0xd0001c48, 0x78284788, 0xd5f80600, 0x78006820,
    0x40082131, 0x6802bd70, 0x70132331, 0x23446802, 0x470871d3, 0x23316802, 0x68027013, 0x71d32349,
    0xb5104708, 0x21006802, 0x06db7853, 0x7813d50c, 0x43232480, 0x68007013, 0x1c49e001, 0x7802b289,
    0xd5fa0612, 0xd8f82920, 0xbd102000, 0x460cb5ff, 0x68694605, 0xb0812000, 0x428c4616, 0x68aad307,
    0x42a21852, 0x1a64d903, 0x02ff2701, 0x2020e001, 0x1e792600, 0xd015420e, 0x03402001, 0x6828e012,
    0x70012131, 0x21096828, 0x682871c1, 0x71810c21, 0x0a216828, 0x68287141, 0x99047104, 0x47884628,
    0x19e41bf6, 0xd0012e00, 0xd0e82800, 0xbdf0b005, 0x780a6801, 0xd4070612, 0x2310784a, 0x704a431a,
    0x78016800, 0xd5fc0609, 0x47702000, 0x78806800, 0x0f920782, 0xd0062a02, 0x28020980, 0x2004d000,
    0x20007008, 0x20014770, 0x2100e7fa, 0x61816101, 0x47704608, 0x4604b5f8, 0x2000460d, 0x4616461f,
    0xd0020791, 0x03402001, 0x6861bdf8, 0xd305428d, 0x185268a2, 0xd90142aa, 0xe0201a6d, 0xe01e2020,
    0x21316820, 0x68207001, 0x71c12106, 0x0c296820, 0x68207181, 0x71410a29, 0x71056820, 0x46012000,
    0x31086822, 0x5c3a1851, 0x1c40700a, 0x2804b2c0, 0x9906d3f5, 0x47884620, 0x1f361d2d, 0x2e001d3f,
    0x2800d0d2, 0xbdf8d0dc, 0x4616b5f8, 0x4604461f, 0xd0020792, 0x03402001, 0x6862bdf8, 0x42919200,
    0x68a3d306, 0x428a189a, 0x9a00d902, 0xe02a1a8d, 0xbdf82020, 0x21316820, 0x68207001, 0x71c12102,
    0x0c296820, 0x68207181, 0x71410a29, 0x71056820, 0x99076820, 0x200072c1, 0x68224601, 0x1851310c,
    0x700a5c3a, 0xb2c01c40, 0xd3f52804, 0x46209908, 0x28004788, 0x9900d004, 0x9906186a, 0x600a2604,
    0x1f361d2d, 0x2e001d3f, 0xbdf8d1d4, 0x6804b430, 0x70252531, 0x25436804, 0x680471e5, 0x210071a1,
    0x6805460c, 0x192c3408, 0x70255c55, 0xb2c91c49, 0xd3f52904, 0x4718bc30, 0x4604b570, 0x68004615,
    0x70022231, 0x22416820, 0x682071c2, 0x46207181, 0x00024798, 0x2100d10a, 0x68234608, 0x18183008,
    0x54687800, 0xb2c91c49, 0xd3f52904, 0xbd704610, 0x4604b570, 0x68404615, 0x42819a04, 0x68a6d324,
    0x428e1836, 0x1a08d920, 0x26316821, 0x6821700e, 0x71ce2603, 0x0c066821, 0x6821718e, 0x714e0a06,
    0x71086821, 0x73c36820, 0x47904620, 0xd10a2800, 0x460a2100, 0x32086823, 0x7812189a, 0x1c49546a,
    0x2904b2c9, 0xbd70d3f5, 0xbd702020, 0x6803b430, 0x701c2431, 0x24456803, 0x230071dc, 0x6805461c,
    0x192c3408, 0x70255ccd, 0xb2db1c5b, 0xd3f52b08, 0x4710bc30, 0x6803b430, 0x701c2431, 0x24406803,
    0x680371dc, 0xbc307199, 0xb4f04710, 0x9d046844, 0xd31c42a1, 0x19366886, 0xd918428e, 0x68041b09,
    0x70262631, 0x26016804, 0x680471e6, 0x71a60c0e, 0x0a0e6804, 0x68047166, 0x68017121, 0x72cc0a14,
    0x728a6801, 0x724b6801, 0xbcf046ac, 0xbcf04760, 0x47702020, 0x6800b510, 0x7c847cc3, 0x7c007c42,
    0x0424061b, 0x02124323, 0x43034313, 0x600b2000, 0xb5f0bd10, 0x0e0c020a, 0x040a0e13, 0x25006806,
    0xb2c90e12, 0x7cf774f4, 0x74b36806, 0x46b47cb6, 0x74726806, 0x68007c76, 0x7c007401, 0xd10542a7,
    0xd103459c, 0xd1014296, 0xd0014288, 0x350125ff, 0xbdf04628, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000
    ],

    # Relative function addresses
    'pc_init': 0x1fffc005,
    'pc_unInit': 0x1fffc081,
    'pc_program_page': 0x1fffc0f9,
    'pc_erase_sector': 0x1fffc0db,
    'pc_eraseAll': 0x1fffc0a5,

    'static_base' : 0x1fffc000 + 0x00000004 + 0x00000554,
    'begin_stack' : 0x1fffc800,
    'begin_data' : 0x1fffc000 + 0x1000,
    'page_size' : 0x800,
    'analyzer_supported' : False,
    'analyzer_address' : 0x00000000,
    'page_buffers' : [0x1fffd000, 0x1fffd800],   # Enable double buffering
    'min_program_length' : 0x800,

    # Relative region addresses and sizes
    'ro_start': 0x0,
    'ro_size': 0x554,
    'rw_start': 0x554,
    'rw_size': 0xc,
    'zi_start': 0x560,
    'zi_size': 0x24,

    # Flash information
    'flash_start': 0x0,
    'flash_size': 0x40000,
    'sector_sizes': (
        (0x0, 0x800),
    )
}


class KE17Z7(Kinetis):

    MEMORY_MAP = MemoryMap(
        FlashRegion(    start=0,           length=0x040000,       blocksize=0x800, is_boot_memory=True,
            algo=FLASH_ALGO, flash_class=Flash_Kinetis),
        RamRegion(      start=0x1fffc000,  length=0xc000)
        )

    def __init__(self, session):
        super(KE17Z7, self).__init__(session, self.MEMORY_MAP)
        self._svd_location = SVDFile.from_builtin("MKE17Z7.xml")
