--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: api; Type: SCHEMA; Schema: -; Owner: admin
--

CREATE SCHEMA api;


ALTER SCHEMA api OWNER TO admin;

--
-- Name: fixcountry; Type: SCHEMA; Schema: -; Owner: admin
--

CREATE SCHEMA fixcountry;


ALTER SCHEMA fixcountry OWNER TO admin;

--
-- Name: SCHEMA fixcountry; Type: COMMENT; Schema: -; Owner: admin
--

COMMENT ON SCHEMA fixcountry IS 'Schema to hold contents of fixcountry';


--
-- Name: te; Type: SCHEMA; Schema: -; Owner: admin
--

CREATE SCHEMA te;


ALTER SCHEMA te OWNER TO admin;

--
-- Name: SCHEMA te; Type: COMMENT; Schema: -; Owner: admin
--

COMMENT ON SCHEMA te IS 'This file is part of the xTuple ERP: PostBooks Edition, a free and open source Enterprise Resource Planning software suite, Copyright (c) 1999-2010 by OpenMFG LLC, d/b/a xTuple. It is licensed to you under the Common Public Attribution License version 1.0, the full text of which (including xTuple-specific Exhibits) is available at www.xtuple.com/CPAL.  By using this software, you agree to be bound by its terms.';


--
-- Name: xtdesktop; Type: SCHEMA; Schema: -; Owner: admin
--

CREATE SCHEMA xtdesktop;


ALTER SCHEMA xtdesktop OWNER TO admin;

--
-- Name: SCHEMA xtdesktop; Type: COMMENT; Schema: -; Owner: admin
--

COMMENT ON SCHEMA xtdesktop IS 'Schema to hold contents of xtdesktop';


--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: admin
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO admin;

SET search_path = public, pg_catalog;

--
-- Name: achline; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE achline AS (
	achline_checkhead_id integer,
	achline_batch text,
	achline_type text,
	achline_value text
);


ALTER TYPE public.achline OWNER TO admin;

--
-- Name: apaging; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE apaging AS (
	apaging_docdate text,
	apaging_duedate date,
	apaging_ponumber text,
	apaging_reference text,
	apaging_invcnumber text,
	apaging_docnumber text,
	apaging_doctype text,
	apaging_vend_id integer,
	apaging_vend_number text,
	apaging_vend_name text,
	apaging_vend_vendtype_id integer,
	apaging_vendtype_code text,
	apaging_terms_descrip text,
	apaging_apopen_amount numeric,
	apaging_cur_val numeric,
	apaging_thirty_val numeric,
	apaging_sixty_val numeric,
	apaging_ninety_val numeric,
	apaging_plus_val numeric,
	apaging_total_val numeric,
	apaging_discdate date,
	apaging_disc_val numeric,
	apaging_discdays numeric,
	apaging_discprcnt numeric
);


ALTER TYPE public.apaging OWNER TO admin;

--
-- Name: araging; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE araging AS (
	araging_docdate date,
	araging_duedate date,
	araging_ponumber text,
	araging_docnumber text,
	araging_doctype text,
	araging_cust_id integer,
	araging_cust_number text,
	araging_cust_name text,
	araging_cust_custtype_id integer,
	araging_custtype_code text,
	araging_terms_descrip text,
	araging_aropen_amount numeric,
	araging_cur_val numeric,
	araging_thirty_val numeric,
	araging_sixty_val numeric,
	araging_ninety_val numeric,
	araging_plus_val numeric,
	araging_total_val numeric
);


ALTER TYPE public.araging OWNER TO admin;

--
-- Name: bomdata; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE bomdata AS (
	bomdata_bomwork_id integer,
	bomdata_bomwork_parent_id integer,
	bomdata_bomwork_level integer,
	bomdata_bomwork_seqnumber integer,
	bomdata_bomitem_id integer,
	bomdata_item_id integer,
	bomdata_item_number text,
	bomdata_uom_name text,
	bomdata_item_descrip1 text,
	bomdata_item_descrip2 text,
	bomdata_itemdescription text,
	bomdata_batchsize numeric,
	bomdata_qtyfxd numeric,
	bomdata_qtyper numeric,
	bomdata_qtyreq numeric,
	bomdata_scrap numeric,
	bomdata_createchild boolean,
	bomdata_issuemethod text,
	bomdata_effective date,
	bomdata_expires date,
	bomdata_expired boolean,
	bomdata_future boolean,
	bomdata_actunitcost numeric,
	bomdata_stdunitcost numeric,
	bomdata_actextendedcost numeric,
	bomdata_stdextendedcost numeric,
	bomdata_ecn text,
	bomdata_char_id integer,
	bomdata_value text,
	bomdata_notes text,
	bomdata_ref text
);


ALTER TYPE public.bomdata OWNER TO admin;

--
-- Name: checkdata; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE checkdata AS (
	checkdata_page integer,
	checkdata_checknumber text,
	checkdata_checkwords text,
	checkdata_checkdate text,
	checkdata_checkamount text,
	checkdata_checkcurrsymbol text,
	checkdata_checkcurrabbr text,
	checkdata_checkcurrname text,
	checkdata_checkpayto text,
	checkdata_checkaddress text,
	checkdata_checkmemo text,
	checkdata_docnumber text,
	checkdata_docreference text,
	checkdata_docdate text,
	checkdata_docamount text,
	checkdata_docdiscount text,
	checkdata_docnetamount text
);


ALTER TYPE public.checkdata OWNER TO admin;

--
-- Name: cntctdup; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE cntctdup AS (
	cntct_id integer,
	cntct_crmacct_id integer,
	cntct_addr_id integer,
	cntct_first_name text,
	cntct_last_name text,
	cntct_honorific text,
	cntct_initials text,
	cntct_active boolean,
	cntct_phone text,
	cntct_phone2 text,
	cntct_fax text,
	cntct_email text,
	cntct_webaddr text,
	cntct_notes text,
	cntct_title text,
	cntct_number text,
	cntct_middle text,
	cntct_suffix text,
	cntct_owner_username text,
	cntct_name text,
	crmacct_number text,
	crmacct_name text,
	addr_id integer,
	addr_active boolean,
	addr_line1 text,
	addr_line2 text,
	addr_line3 text,
	addr_city text,
	addr_state text,
	addr_postalcode text,
	addr_country text,
	addr_notes text,
	addr_number text,
	cntctdup_level integer
);


ALTER TYPE public.cntctdup OWNER TO admin;

--
-- Name: flcoldata; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE flcoldata AS (
	flcoldata_column integer,
	flcoldata_start date,
	flcoldata_end date
);


ALTER TYPE public.flcoldata OWNER TO admin;

--
-- Name: flstmthead; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE flstmthead AS (
	flstmthead_flhead_id integer,
	flstmthead_flcol_id integer,
	flstmthead_period_id integer,
	flstmthead_username text,
	flstmthead_typedescrip1 text,
	flstmthead_typedescrip2 text,
	flstmthead_flhead_name text,
	flstmthead_flcol_name text,
	flstmthead_month text,
	flstmthead_qtr text,
	flstmthead_year text,
	flstmthead_prmonth text,
	flstmthead_prqtr text,
	flstmthead_pryear text
);


ALTER TYPE public.flstmthead OWNER TO admin;

--
-- Name: flstmtitem; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE flstmtitem AS (
	flstmtitem_flhead_id integer,
	flstmtitem_period_id integer,
	flstmtitem_username text,
	flstmtitem_order integer,
	flstmtitem_level integer,
	flstmtitem_subgrp integer,
	flstmtitem_type text,
	flstmtitem_type_id integer,
	flstmtitem_parent_id integer,
	flstmtitem_accnt_id integer,
	flstmtitem_name text,
	flstmtitem_month numeric,
	flstmtitem_monthdb numeric,
	flstmtitem_monthcr numeric,
	flstmtitem_monthprcnt numeric,
	flstmtitem_monthbudget numeric,
	flstmtitem_monthbudgetprcnt numeric,
	flstmtitem_monthbudgetdiff numeric,
	flstmtitem_monthbudgetdiffprcnt numeric,
	flstmtitem_qtr numeric,
	flstmtitem_qtrdb numeric,
	flstmtitem_qtrcr numeric,
	flstmtitem_qtrprcnt numeric,
	flstmtitem_qtrbudget numeric,
	flstmtitem_qtrbudgetprcnt numeric,
	flstmtitem_qtrbudgetdiff numeric,
	flstmtitem_qtrbudgetdiffprcnt numeric,
	flstmtitem_year numeric,
	flstmtitem_yeardb numeric,
	flstmtitem_yearcr numeric,
	flstmtitem_yearprcnt numeric,
	flstmtitem_yearbudget numeric,
	flstmtitem_yearbudgetprcnt numeric,
	flstmtitem_yearbudgetdiff numeric,
	flstmtitem_yearbudgetdiffprcnt numeric,
	flstmtitem_prmonth numeric,
	flstmtitem_prmonthprcnt numeric,
	flstmtitem_prmonthdiff numeric,
	flstmtitem_prmonthdiffprcnt numeric,
	flstmtitem_prqtr numeric,
	flstmtitem_prqtrprcnt numeric,
	flstmtitem_prqtrdiff numeric,
	flstmtitem_prqtrdiffprcnt numeric,
	flstmtitem_pryear numeric,
	flstmtitem_pryearprcnt numeric,
	flstmtitem_pryeardiff numeric,
	flstmtitem_pryeardiffprcnt numeric
);


ALTER TYPE public.flstmtitem OWNER TO admin;

--
-- Name: fltrendhead; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE fltrendhead AS (
	fltrendhead_flhead_id integer,
	fltrendhead_username text,
	fltrendhead_typedescrip text,
	fltrendhead_flhead_name text,
	fltrendhead_fld1 text,
	fltrendhead_fld2 text,
	fltrendhead_fld3 text,
	fltrendhead_fld4 text,
	fltrendhead_fld5 text,
	fltrendhead_fld6 text,
	fltrendhead_fld7 text,
	fltrendhead_fld8 text,
	fltrendhead_fld9 text,
	fltrendhead_fld10 text,
	fltrendhead_fld11 text,
	fltrendhead_fld12 text,
	fltrendhead_grndttl text
);


ALTER TYPE public.fltrendhead OWNER TO admin;

--
-- Name: fltrenditem; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE fltrenditem AS (
	fltrenditem_flhead_id integer,
	fltrenditem_username text,
	fltrenditem_order integer,
	fltrenditem_level integer,
	fltrenditem_subgrp integer,
	fltrenditem_type text,
	fltrenditem_type_id integer,
	fltrenditem_parent_id integer,
	fltrenditem_accnt_id integer,
	fltrenditem_name text,
	fltrenditem_fld1 text,
	fltrenditem_fld2 text,
	fltrenditem_fld3 text,
	fltrenditem_fld4 text,
	fltrenditem_fld5 text,
	fltrenditem_fld6 text,
	fltrenditem_fld7 text,
	fltrenditem_fld8 text,
	fltrenditem_fld9 text,
	fltrenditem_fld10 text,
	fltrenditem_fld11 text,
	fltrenditem_fld12 text,
	fltrenditem_grndttl text
);


ALTER TYPE public.fltrenditem OWNER TO admin;

--
-- Name: freightdata; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE freightdata AS (
	freightdata_schedule text,
	freightdata_from text,
	freightdata_to text,
	freightdata_shipvia text,
	freightdata_freightclass text,
	freightdata_weight numeric,
	freightdata_uom text,
	freightdata_price numeric,
	freightdata_type text,
	freightdata_total numeric,
	freightdata_currency text
);


ALTER TYPE public.freightdata OWNER TO admin;

--
-- Name: itemprice; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE itemprice AS (
	itemprice_price numeric,
	itemprice_type character(1)
);


ALTER TYPE public.itemprice OWNER TO admin;

--
-- Name: orderitemtype; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE orderitemtype AS (
	orderitem_id integer,
	orderitem_orderhead_type text,
	orderitem_orderhead_id integer,
	orderitem_linenumber integer,
	orderitem_status text,
	orderitem_itemsite_id integer,
	orderitem_scheddate date,
	orderitem_qty_ordered numeric,
	orderitem_qty_shipped numeric,
	orderitem_qty_received numeric,
	orderitem_qty_uom_id integer,
	orderitem_qty_invuomratio numeric,
	orderitem_unitcost numeric,
	orderitem_unitcost_curr_id integer,
	orderitem_freight numeric,
	orderitem_freight_received numeric,
	orderitem_freight_curr_id integer
);


ALTER TYPE public.orderitemtype OWNER TO admin;

--
-- Name: ordhead; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE ordhead AS (
	orderhead_id integer,
	orderhead_type text,
	orderhead_number text,
	orderhead_status text,
	orderhead_orderdate date,
	orderhead_linecount integer,
	orderhead_from_id integer,
	orderhead_from text,
	orderhead_to_id integer,
	orderhead_to text,
	orderhead_curr_id integer,
	orderhead_agent_username text,
	orderhead_shipvia text
);


ALTER TYPE public.ordhead OWNER TO admin;

--
-- Name: orditem; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE orditem AS (
	orderitem_id integer,
	orderitem_orderhead_type text,
	orderitem_orderhead_id integer,
	orderitem_linenumber integer,
	orderitem_status text,
	orderitem_itemsite_id integer,
	orderitem_scheddate date,
	orderitem_qty_ordered numeric,
	orderitem_qty_shipped numeric,
	orderitem_qty_received numeric,
	orderitem_qty_uom_id integer,
	orderitem_qty_invuomratio numeric,
	orderitem_unitcost numeric,
	orderitem_unitcost_curr_id integer,
	orderitem_freight numeric,
	orderitem_freight_received numeric,
	orderitem_freight_curr_id integer
);


ALTER TYPE public.orditem OWNER TO admin;

--
-- Name: reordlvl; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE reordlvl AS (
	reordlvl_itemsite_id integer,
	reordlvl_item_id integer,
	reordlvl_warehous_code text,
	reordlvl_item_number text,
	reordlvl_item_descrip text,
	reordlvl_leadtime integer,
	reordlvl_daysofstock integer,
	reordlvl_curr_level numeric,
	reordlvl_total_days numeric,
	reordlvl_total_usage numeric,
	reordlvl_calc_level integer
);


ALTER TYPE public.reordlvl OWNER TO admin;

--
-- Name: seqiss; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE seqiss AS (
	seqiss_number integer,
	seqiss_time timestamp with time zone
);


ALTER TYPE public.seqiss OWNER TO admin;

--
-- Name: subtax; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE subtax AS (
	subtax_taxcode_id integer,
	subtax_taxcode_code text,
	subtax_taxcode_descrip text,
	subtax_taxcode_level integer
);


ALTER TYPE public.subtax OWNER TO admin;

--
-- Name: taxassign; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE taxassign AS (
	taxassign_taxzone_id integer,
	taxassign_taxtype_id integer,
	taxassign_level integer,
	taxassign_zone_code text,
	taxassign_type_descrip text,
	taxassign_taxclass_code text,
	taxassign_taxclass_sequence integer
);


ALTER TYPE public.taxassign OWNER TO admin;

--
-- Name: taxdetail; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE taxdetail AS (
	taxdetail_tax_id integer,
	taxdetail_tax_code text,
	taxdetail_tax_descrip text,
	taxdetail_tax_basis_tax_id integer,
	taxdetail_taxrate_percent numeric(10,6),
	taxdetail_taxrate_amount numeric(16,2),
	taxdetail_level integer,
	taxdetail_taxclass_id integer,
	taxdetail_taxclass_code text,
	taxdetail_taxclass_sequence integer,
	taxdetail_tax numeric(16,6),
	taxdetail_curr_id integer,
	taxdetail_curr_abbr text
);


ALTER TYPE public.taxdetail OWNER TO admin;

--
-- Name: wodata; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE wodata AS (
	wodata_id integer,
	wodata_id_type integer,
	wodata_number integer,
	wodata_subnumber integer,
	wodata_itemnumber text,
	wodata_descrip text,
	wodata_status character(1),
	wodata_startdate date,
	wodata_duedate date,
	wodata_adhoc boolean,
	wodata_itemsite_id integer,
	wodata_qoh numeric,
	wodata_short numeric,
	wodata_qtyper numeric,
	wodata_qtyiss numeric,
	wodata_qtyrcv numeric,
	wodata_qtyordreq numeric,
	wodata_qtyuom text,
	wodata_scrap numeric,
	wodata_setup numeric,
	wodata_run numeric,
	wodata_notes text,
	wodata_ref text,
	wodata_level integer
);


ALTER TYPE public.wodata OWNER TO admin;

--
-- Name: woinvav; Type: TYPE; Schema: public; Owner: admin
--

CREATE TYPE woinvav AS (
	woinvav_itemsite_id integer,
	woinvav_womatl_id integer,
	woinvav_type character(1),
	woinvav_item_wo_number text,
	woinvav_descrip text,
	woinvav_uomname text,
	woinvav_qoh numeric,
	woinvav_balance numeric,
	woinvav_allocated numeric,
	woinvav_ordered numeric,
	woinvav_woavail numeric,
	woinvav_totalavail numeric,
	woinvav_reorderlevel numeric,
	woinvav_level integer
);


ALTER TYPE public.woinvav OWNER TO admin;

SET search_path = api, pg_catalog;

--
-- Name: getcustnumberfrominfo(text, text, text, text, text, boolean); Type: FUNCTION; Schema: api; Owner: admin
--

CREATE FUNCTION getcustnumberfrominfo(text, text, text, text, text, boolean) RETURNS text
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _email	TEXT	:= COALESCE(UPPER($1), '');
  _company	TEXT	:= COALESCE(UPPER($2), '');
  _first	TEXT	:= COALESCE(UPPER($3), '');
  _last		TEXT	:= COALESCE(UPPER($4), '');
  _fullname	TEXT	:= COALESCE(UPPER($5), TRIM(_first || ' ' || _last));
  _generate	BOOLEAN	:= COALESCE($6, FALSE);
  _counter	INTEGER;
  _custcount	INTEGER	:= 0;
  _custnumber	TEXT;
  _candidate	TEXT	:= '';
  _loopmax	INTEGER := 0;
  _minlength	INTEGER := 5;
  _maxlength	INTEGER := 8;
  _numformat	TEXT	:= '';
  _testme	TEXT;
BEGIN
  IF (_email != '') THEN
    SELECT count(*), cust_number INTO _custcount, _custnumber
    FROM custinfo LEFT OUTER JOIN cntct ON (cust_cntct_id=cntct_id)
    WHERE (UPPER(cntct_email)=_email)
    GROUP BY cust_number;
    IF (NOT FOUND) THEN
      _custcount := 0;
    ELSIF(_custcount = 1) THEN
      RETURN _custnumber;
    END IF;
  END IF;

  IF (_company != '') THEN
    SELECT count(*), cust_number INTO _custcount, _custnumber
    FROM custinfo
    WHERE (UPPER(cust_name)=_company)
    GROUP BY cust_number;
    IF (NOT FOUND) THEN
      _custcount := 0;
    ELSIF(_custcount = 1) THEN
      RETURN _custnumber;
    END IF;
  END IF;

  IF (_fullname = '' AND (_first != '' OR _last != '')) THEN
    _fullname := TRIM(_first || ' ' || _last);
  END IF;

  IF (_custcount <= 0 AND _fullname != '') THEN
    SELECT count(*), cust_number INTO _custcount, _custnumber
    FROM custinfo
    WHERE (UPPER(cust_name)=_fullname)
    GROUP BY cust_number;
    IF (NOT FOUND) THEN
      _custcount := 0;
    ELSIF(_custcount = 1) THEN
      RETURN _custnumber;
    END IF;
  END IF;

  IF (_custcount > 1) THEN
    RAISE EXCEPTION 'Found % possible Customers for % and % and %',
		    _custcount, _email, _company, _fullname;
  END IF;

  IF (_custcount <= 0 AND _generate) THEN
    IF (_maxlength < _minlength) THEN
      RAISE EXCEPTION 'Fix getCustNumberFromInfo: max length < min length';
    END IF;

    IF (_company != '') THEN
      _candidate := _company;
    ELSIF (_email != '') THEN
      _candidate := SUBSTRING(_email FOR POSITION('@' IN _email) - 1);
    ELSIF (_last != '') THEN
      _candidate := _last;
      IF (_first != '') THEN
	_candidate := _candidate || _first;
      END IF;
    ELSIF (_fullname != '' AND (POSITION(' ' IN _fullname) > 0)) THEN
      _candidate := SUBSTRING(_fullname FROM POSITION(' ' IN _fullname) + 1) ||
		    SUBSTRING(_fullname FOR  POSITION(' ' IN _fullname) - 1);
    END IF;
    WHILE (POSITION(' ' IN _candidate) > 0) LOOP
      _candidate := SUBSTRING(_candidate FOR  POSITION(' ' IN _candidate) - 1) ||
		    SUBSTRING(_candidate FROM POSITION(' ' IN _candidate) + 1);
    END LOOP;
    FOR _counter IN _minlength.._maxlength LOOP
      _testme := SUBSTRING(_candidate FOR _counter);
      IF (NOT EXISTS(SELECT cust_number
		     FROM custinfo
		     WHERE (cust_number=_testme))) THEN
	_custnumber := _testme;
	EXIT;
      END IF;
    END LOOP;
    IF (_custnumber IS NULL OR _custnumber = '') THEN
      IF (LENGTH(_candidate) < _minlength) THEN
	_minlength := LENGTH(_candidate);
      END IF;
      FOR _counter IN _minlength.._maxlength LOOP
	_loopmax := _loopmax * 10 + 9;
	_numformat := _numformat || '0';
      END LOOP;
      FOR _counter IN 1.._loopmax LOOP
	_testme := SUBSTRING(_candidate FOR _minlength) ||
		   TRIM(TO_CHAR(_counter, _numformat));
	IF (NOT EXISTS(SELECT cust_number
		       FROM custinfo
		       WHERE (cust_number=_testme))) THEN
	  _custnumber := _testme;
	  EXIT;
	END IF;
      END LOOP;
    END IF;
    IF (_custnumber IS NULL OR _custnumber = '') THEN
      RAISE EXCEPTION 'Could not generate a new Customer Number';
    END IF;
  END IF;

  IF (_custnumber IS NULL OR _custnumber = '') THEN
    RAISE EXCEPTION 'Could not find Customer Number for % and % and %',
		    _email, _company, _fullname;
  END IF;

  RETURN _custnumber;
END;
$_$;


ALTER FUNCTION api.getcustnumberfrominfo(text, text, text, text, text, boolean) OWNER TO admin;

SET search_path = public, pg_catalog;

--
-- Name: formatlocationname(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION formatlocationname(integer) RETURNS text
    LANGUAGE plpgsql IMMUTABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pLocationid ALIAS FOR $1;
  _name TEXT;
  _r RECORD;

BEGIN

  SELECT location_aisle, location_rack,
         location_bin, location_name INTO _r
  FROM location
  WHERE (location_id=pLocationid);
  IF (FOUND) THEN
    IF (_r.location_aisle IS NOT NULL) THEN
      _name := _r.location_aisle;
    ELSE
      _name := '';
    END IF;

    IF (_r.location_rack IS NOT NULL) THEN
      _name := (_name || _r.location_rack);
    END IF;

    IF (_r.location_bin IS NOT NULL) THEN
      _name := (_name || _r.location_bin);
    END IF;

    IF (_r.location_name IS NOT NULL) THEN
      _name := (_name || _r.location_name);
    END IF;

    RETURN _name;
  ELSE
    RETURN 'N/A';
  END IF;

END;
$_$;


ALTER FUNCTION public.formatlocationname(integer) OWNER TO admin;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: cntslip; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE cntslip (
    cntslip_id integer DEFAULT nextval(('"cntslip_cntslip_id_seq"'::text)::regclass) NOT NULL,
    cntslip_cnttag_id integer,
    cntslip_entered timestamp with time zone,
    cntslip_posted boolean,
    cntslip_number text,
    cntslip_qty numeric(18,6),
    cntslip_comments text,
    cntslip_location_id integer,
    cntslip_lotserial text,
    cntslip_lotserial_expiration date,
    cntslip_lotserial_warrpurc date,
    cntslip_username text
);


ALTER TABLE public.cntslip OWNER TO admin;

--
-- Name: TABLE cntslip; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE cntslip IS 'Count Slip information';


--
-- Name: invcnt; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE invcnt (
    invcnt_id integer DEFAULT nextval(('invcnt_invcnt_id_seq'::text)::regclass) NOT NULL,
    invcnt_itemsite_id integer,
    invcnt_tagdate timestamp with time zone,
    invcnt_cntdate timestamp with time zone,
    invcnt_qoh_before numeric(18,6),
    invcnt_qoh_after numeric(18,6),
    invcnt_matcost numeric(16,6),
    invcnt_posted boolean,
    invcnt_postdate timestamp with time zone,
    invcnt_comments text,
    invcnt_priority boolean,
    invcnt_tagnumber text,
    invcnt_invhist_id integer,
    invcnt_location_id integer,
    invcnt_cnt_username text,
    invcnt_post_username text,
    invcnt_tag_username text
);


ALTER TABLE public.invcnt OWNER TO admin;

--
-- Name: TABLE invcnt; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE invcnt IS 'Count Tag information';


--
-- Name: item; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE item (
    item_id integer DEFAULT nextval(('item_item_id_seq'::text)::regclass) NOT NULL,
    item_number text NOT NULL,
    item_descrip1 text NOT NULL,
    item_descrip2 text NOT NULL,
    item_classcode_id integer NOT NULL,
    item_picklist boolean DEFAULT true NOT NULL,
    item_comments text,
    item_sold boolean NOT NULL,
    item_fractional boolean NOT NULL,
    item_active boolean NOT NULL,
    item_type character(1) DEFAULT 'R'::bpchar NOT NULL,
    item_prodweight numeric(16,2) DEFAULT 0 NOT NULL,
    item_packweight numeric(16,2) DEFAULT 0 NOT NULL,
    item_prodcat_id integer NOT NULL,
    item_exclusive boolean DEFAULT false NOT NULL,
    item_listprice numeric(16,4) NOT NULL,
    item_config boolean DEFAULT false,
    item_extdescrip text,
    item_upccode text,
    item_maxcost numeric(16,6) DEFAULT 0 NOT NULL,
    item_inv_uom_id integer NOT NULL,
    item_price_uom_id integer NOT NULL,
    item_warrdays integer DEFAULT 0,
    item_freightclass_id integer,
    item_tax_recoverable boolean DEFAULT false NOT NULL,
    item_listcost numeric(16,6) DEFAULT 0.0 NOT NULL,
    CONSTRAINT item_item_number_check CHECK ((item_number <> ''::text)),
    CONSTRAINT item_item_type_check CHECK (((((((((((((item_type = 'P'::bpchar) OR (item_type = 'M'::bpchar)) OR (item_type = 'F'::bpchar)) OR (item_type = 'O'::bpchar)) OR (item_type = 'R'::bpchar)) OR (item_type = 'S'::bpchar)) OR (item_type = 'T'::bpchar)) OR (item_type = 'B'::bpchar)) OR (item_type = 'L'::bpchar)) OR (item_type = 'Y'::bpchar)) OR (item_type = 'C'::bpchar)) OR (item_type = 'K'::bpchar))),
    CONSTRAINT item_sold_check CHECK ((NOT (item_sold AND (item_prodcat_id = (-1)))))
);


ALTER TABLE public.item OWNER TO admin;

--
-- Name: TABLE item; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE item IS 'Item information';


--
-- Name: COLUMN item.item_maxcost; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON COLUMN item.item_maxcost IS 'Maximum cost for item.  Used to constrain purchase order price.';


--
-- Name: COLUMN item.item_listcost; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON COLUMN item.item_listcost IS 'List cost for item.  Basis for markup pricing.';


--
-- Name: itemsite; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE itemsite (
    itemsite_id integer DEFAULT nextval(('itemsite_itemsite_id_seq'::text)::regclass) NOT NULL,
    itemsite_item_id integer NOT NULL,
    itemsite_warehous_id integer,
    itemsite_qtyonhand numeric(18,6) NOT NULL,
    itemsite_reorderlevel numeric(18,6) NOT NULL,
    itemsite_ordertoqty numeric(18,6) NOT NULL,
    itemsite_cyclecountfreq integer NOT NULL,
    itemsite_datelastcount date,
    itemsite_datelastused date,
    itemsite_loccntrl boolean NOT NULL,
    itemsite_safetystock numeric(18,6) NOT NULL,
    itemsite_minordqty numeric(18,6) NOT NULL,
    itemsite_multordqty numeric(18,6) NOT NULL,
    itemsite_leadtime integer NOT NULL,
    itemsite_abcclass character(1),
    itemsite_issuemethod character(1),
    itemsite_controlmethod character(1),
    itemsite_active boolean NOT NULL,
    itemsite_plancode_id integer NOT NULL,
    itemsite_costcat_id integer NOT NULL,
    itemsite_eventfence integer NOT NULL,
    itemsite_sold boolean NOT NULL,
    itemsite_stocked boolean NOT NULL,
    itemsite_freeze boolean DEFAULT false NOT NULL,
    itemsite_location_id integer NOT NULL,
    itemsite_useparams boolean NOT NULL,
    itemsite_useparamsmanual boolean NOT NULL,
    itemsite_soldranking integer DEFAULT 1,
    itemsite_createpr boolean,
    itemsite_location text,
    itemsite_location_comments text,
    itemsite_notes text,
    itemsite_perishable boolean NOT NULL,
    itemsite_nnqoh numeric(18,6) DEFAULT 0 NOT NULL,
    itemsite_autoabcclass boolean NOT NULL,
    itemsite_ordergroup integer DEFAULT 1 NOT NULL,
    itemsite_disallowblankwip boolean DEFAULT false NOT NULL,
    itemsite_maxordqty numeric(18,6) DEFAULT 0.0 NOT NULL,
    itemsite_mps_timefence integer DEFAULT 0 NOT NULL,
    itemsite_createwo boolean DEFAULT false NOT NULL,
    itemsite_warrpurc boolean DEFAULT false NOT NULL,
    itemsite_autoreg boolean DEFAULT false,
    itemsite_costmethod character(1) NOT NULL,
    itemsite_value numeric(12,2) NOT NULL,
    itemsite_ordergroup_first boolean DEFAULT false NOT NULL,
    itemsite_supply_itemsite_id integer,
    itemsite_planning_type character(1) DEFAULT 'M'::bpchar NOT NULL,
    itemsite_wosupply boolean DEFAULT false NOT NULL,
    itemsite_posupply boolean DEFAULT false NOT NULL,
    itemsite_lsseq_id integer,
    itemsite_cosdefault character(1),
    itemsite_createsopr boolean DEFAULT false,
    itemsite_createsopo boolean DEFAULT false,
    itemsite_dropship boolean DEFAULT false,
    itemsite_recvlocation_id integer DEFAULT (-1) NOT NULL,
    itemsite_issuelocation_id integer DEFAULT (-1) NOT NULL,
    itemsite_location_dist boolean DEFAULT false NOT NULL,
    itemsite_recvlocation_dist boolean DEFAULT false NOT NULL,
    itemsite_issuelocation_dist boolean DEFAULT false NOT NULL,
    CONSTRAINT itemsite_itemsite_abcclass_check CHECK (((((itemsite_abcclass = 'A'::bpchar) OR (itemsite_abcclass = 'B'::bpchar)) OR (itemsite_abcclass = 'C'::bpchar)) OR (itemsite_abcclass = 'T'::bpchar))),
    CONSTRAINT itemsite_itemsite_controlmethod_check CHECK (((((itemsite_controlmethod = 'N'::bpchar) OR (itemsite_controlmethod = 'R'::bpchar)) OR (itemsite_controlmethod = 'S'::bpchar)) OR (itemsite_controlmethod = 'L'::bpchar))),
    CONSTRAINT itemsite_itemsite_costmethod_check CHECK (((((itemsite_costmethod = 'N'::bpchar) OR (itemsite_costmethod = 'A'::bpchar)) OR (itemsite_costmethod = 'S'::bpchar)) OR (itemsite_costmethod = 'J'::bpchar))),
    CONSTRAINT itemsite_itemsite_ordergroup_check CHECK ((itemsite_ordergroup > 0))
);


ALTER TABLE public.itemsite OWNER TO admin;

--
-- Name: TABLE itemsite; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE itemsite IS 'Item Site information';


--
-- Name: COLUMN itemsite.itemsite_lsseq_id; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON COLUMN itemsite.itemsite_lsseq_id IS 'Foreign key reference for automatic lot/serial numbering';


--
-- Name: COLUMN itemsite.itemsite_createsopr; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON COLUMN itemsite.itemsite_createsopr IS 'Used to flag Sales items that create P/Rs';


--
-- Name: COLUMN itemsite.itemsite_createsopo; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON COLUMN itemsite.itemsite_createsopo IS 'Used to flag Sales items that create P/Os';


--
-- Name: COLUMN itemsite.itemsite_dropship; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON COLUMN itemsite.itemsite_dropship IS 'Used to flag Sales items to drop ship';


--
-- Name: whsinfo; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE whsinfo (
    warehous_id integer DEFAULT nextval(('warehous_warehous_id_seq'::text)::regclass) NOT NULL,
    warehous_code text NOT NULL,
    warehous_descrip text,
    warehous_fob text,
    warehous_active boolean,
    warehous_counttag_prefix text,
    warehous_counttag_number integer,
    warehous_bol_prefix text,
    warehous_bol_number integer,
    warehous_shipping boolean,
    warehous_useslips boolean,
    warehous_usezones boolean,
    warehous_aislesize integer,
    warehous_aislealpha boolean,
    warehous_racksize integer,
    warehous_rackalpha boolean,
    warehous_binsize integer,
    warehous_binalpha boolean,
    warehous_locationsize integer,
    warehous_locationalpha boolean,
    warehous_enforcearbl boolean,
    warehous_default_accnt_id integer,
    warehous_shipping_commission numeric(8,4) DEFAULT 0.00,
    warehous_cntct_id integer,
    warehous_addr_id integer,
    warehous_transit boolean DEFAULT false NOT NULL,
    warehous_shipform_id integer,
    warehous_shipvia_id integer,
    warehous_shipcomments text,
    warehous_costcat_id integer,
    warehous_sitetype_id integer,
    warehous_taxzone_id integer,
    warehous_sequence integer DEFAULT 0 NOT NULL,
    CONSTRAINT whsinfo_check CHECK (((warehous_transit AND (warehous_costcat_id IS NOT NULL)) OR (NOT warehous_transit))),
    CONSTRAINT whsinfo_warehous_code_check CHECK ((warehous_code <> ''::text))
);


ALTER TABLE public.whsinfo OWNER TO admin;

--
-- Name: TABLE whsinfo; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE whsinfo IS 'Warehouse information';


SET search_path = api, pg_catalog;

--
-- Name: physinvcount; Type: VIEW; Schema: api; Owner: admin
--

CREATE VIEW physinvcount AS
    SELECT whsinfo.warehous_code AS site, item.item_number, invcnt.invcnt_tagnumber AS tag_number, cntslip.cntslip_qty AS quantity, public.formatlocationname(cntslip.cntslip_location_id) AS location, cntslip.cntslip_lotserial AS lotserial, cntslip.cntslip_comments AS comment FROM ((((public.invcnt JOIN public.itemsite ON ((itemsite.itemsite_id = invcnt.invcnt_itemsite_id))) JOIN public.whsinfo ON ((whsinfo.warehous_id = itemsite.itemsite_warehous_id))) JOIN public.item ON ((item.item_id = itemsite.itemsite_item_id))) LEFT JOIN public.cntslip ON ((cntslip.cntslip_cnttag_id = invcnt.invcnt_id)));


ALTER TABLE api.physinvcount OWNER TO admin;

--
-- Name: VIEW physinvcount; Type: COMMENT; Schema: api; Owner: admin
--

COMMENT ON VIEW physinvcount IS 'Physical Inventory Count Tag and Slip';


--
-- Name: insertphysinvcount(physinvcount); Type: FUNCTION; Schema: api; Owner: admin
--

CREATE FUNCTION insertphysinvcount(physinvcount) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pNEW ALIAS FOR $1;
  _itemid INTEGER;
  _type TEXT;
  _siteid INTEGER;
  _itemsiteid INTEGER;
  _controlmethod TEXT;
  _loccntrl BOOLEAN;
  _locationid INTEGER;
  _lsid INTEGER;
  _invcntid INTEGER;
  _cntslipid INTEGER;
  _result INTEGER;

BEGIN

  -- Check Item
  SELECT item_id, item_type INTO _itemid, _type
  FROM item
  WHERE (item_number=UPPER(pNEW.item_number));
  IF (NOT FOUND OR _type IN ('F', 'R', 'L','J')) THEN
    SELECT item_id, item_type INTO _itemid, _type
    FROM item
    WHERE (item_upccode=pNEW.item_number);
    IF (NOT FOUND OR _type IN ('F', 'R', 'L','J')) THEN
      RAISE EXCEPTION 'Function insertPhysInvCount failed because Item % not found or invalid type', pNEW.item_number;
    END IF;
  END IF;

  -- Check Site
  SELECT warehous_id INTO _siteid
  FROM whsinfo
  WHERE (warehous_code=COALESCE(pNEW.site, (SELECT warehous_code
                                            FROM usrpref,whsinfo
                                            WHERE (usrpref_username=getEffectiveXtUser())
                                              AND (usrpref_name='PreferredWarehouse')
                                              AND (warehous_id=CAST(usrpref_value AS INTEGER)))));
  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Function insertPhysInvCount failed because Site % not found', pNEW.site;
  END IF;

  -- Check Itemsite
  SELECT itemsite_id, itemsite_controlmethod, itemsite_loccntrl INTO _itemsiteid, _controlmethod, _loccntrl
  FROM itemsite
  WHERE (itemsite_item_id=_itemid)
    AND (itemsite_warehous_id=_siteid);
  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Function insertPhysInvCount failed because Itemsite %, % not found', pNEW.site, pNEW.item_number;
  END IF;
  IF (_controlmethod = 'N') THEN
    RAISE EXCEPTION 'Function insertPhysInvCount failed because Itemsite %, % not inventory control method', pNEW.site, pNEW.item_number;
  END IF;
  IF (_controlmethod IN ('L', 'S') AND COALESCE(pNEW.lotserial, '') = '') THEN
    RAISE EXCEPTION 'Function insertPhysInvCount failed because Itemsite %, % lot/serial controlled and lotserial not provided', pNEW.site, pNEW.item_number;
  END IF;
  IF (_controlmethod = 'S') THEN
    -- Check for unique serial id
    SELECT ls_id INTO _lsid
    FROM ls
    WHERE (ls_number=pNEW.lotserial);
    IF (FOUND) THEN
      RAISE EXCEPTION 'Function insertPhysInvCount failed because Serial %, %, % not unique', pNEW.site, pNEW.item_number, pNEW.lotserial;
    END IF;
  END IF;
  IF (_loccntrl) THEN
    IF (pNEW.location IS NULL) THEN
      RAISE EXCEPTION 'Function insertPhysInvCount failed because Itemsite %, % multi location and location not provided', pNEW.site, pNEW.item_number;
    ELSE
      -- Check Location
      SELECT location_id INTO _locationid
      FROM location
      WHERE (location_id=getLocationId(pNEW.site, pNEW.location));
      IF (NOT FOUND) THEN
        RAISE EXCEPTION 'Function insertPhysInvCount failed because Location %, % not found', pNEW.site, pNEW.location;
      END IF;
    END IF;
  END IF;

  -- Create Count Tag
  SELECT CreateCountTag(_itemsiteid, pNEW.comment, FALSE, FALSE) INTO _invcntid;
  IF (_invcntid <= 0) THEN
    RAISE EXCEPTION 'Function insertPhysInvCount failed because CreateCountTag failed for Itemsite %, %', pNEW.site, pNEW.item_number;
  END IF;

  -- Create Count Slip
  INSERT INTO cntslip
  ( cntslip_cnttag_id,
    cntslip_username, cntslip_entered, cntslip_posted,
    cntslip_number, cntslip_qty,
    cntslip_location_id, cntslip_lotserial,
    cntslip_lotserial_expiration,
    cntslip_lotserial_warrpurc,
    cntslip_comments )
  VALUES
  ( _invcntid,
    getEffectiveXtUser(), CURRENT_TIMESTAMP, FALSE,
    'N/A', pNEW.quantity,
    COALESCE(_locationid, -1), pNEW.lotserial,
    NULL,
    NULL,
    pNEW.comment )
  RETURNING cntslip_id INTO _cntslipid;

  -- Post Count Slip
  SELECT postCountSlip(_cntslipid) INTO _result;
  IF (_result < 0) THEN
    RAISE EXCEPTION 'Function insertPhysInvCount failed because postCountSlip failed for Itemsite %, %, %', pNEW.site, pNEW.item_number, _result;
  END IF;

  RETURN TRUE;
END;
$_$;


ALTER FUNCTION api.insertphysinvcount(physinvcount) OWNER TO admin;

SET search_path = public, pg_catalog;

--
-- Name: basecurrid(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION basecurrid() RETURNS integer
    LANGUAGE plpgsql IMMUTABLE
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  returnVal INTEGER;
BEGIN
  SELECT curr_id INTO returnVal
    FROM curr_symbol
   WHERE curr_base = TRUE;
  IF NOT FOUND THEN
    RAISE EXCEPTION 'No base currency found';
  END IF;
  RETURN returnVal;
END;
$$;


ALTER FUNCTION public.basecurrid() OWNER TO admin;

--
-- Name: formatglaccount(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION formatglaccount(integer) RETURNS text
    LANGUAGE plpgsql IMMUTABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pAccntid ALIAS FOR $1;
  _accnt RECORD;

BEGIN

  SELECT COALESCE(accnt_company, '') AS accnt_company,
         COALESCE(accnt_profit, '') AS accnt_profit,
         accnt_number,
         COALESCE(accnt_sub, '') AS accnt_sub INTO _accnt
  FROM accnt
  WHERE (accnt_id=pAccntid);

  IF (NOT FOUND) THEN
    RETURN 'Error';
  END IF;

  RETURN formatGlAccount(_accnt.accnt_company, _accnt.accnt_profit, _accnt.accnt_number, _accnt.accnt_sub);

END;
$_$;


ALTER FUNCTION public.formatglaccount(integer) OWNER TO admin;

--
-- Name: formatsolinenumber(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION formatsolinenumber(integer) RETURNS text
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSoitemid ALIAS FOR $1;
  _r RECORD;

BEGIN

  SELECT coitem_linenumber, coitem_subnumber
    INTO _r
    FROM coitem
   WHERE(coitem_id=pSoitemid);

  IF(NOT FOUND) THEN
    RETURN NULL;
  END IF;

  IF(COALESCE(_r.coitem_subnumber, 0) > 0) THEN
    RETURN _r.coitem_linenumber || '.' || _r.coitem_subnumber;
  END IF;

  RETURN _r.coitem_linenumber; 
END;
$_$;


ALTER FUNCTION public.formatsolinenumber(integer) OWNER TO admin;

--
-- Name: geteffectivextuser(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION geteffectivextuser() RETURNS text
    LANGUAGE plpgsql STABLE
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
/*
  The default return value of this function is simply
  the user currently connected.
  
  Overload this function from another schema 
  to implement specific user handling from an external 
  application that uses connection pooling. 
  Use setEffectiveXtUser(text) to create a temporary table that 
  inserts user data that can in turn be used as a lookup 
  reference for an over loaded version of this function like so:
  
  SELECT effective_value
  FROM effective_user
  WHERE effective_key = 'username'
*/

  RETURN CURRENT_USER;

END;
$$;


ALTER FUNCTION public.geteffectivextuser() OWNER TO admin;

--
-- Name: getitemtaxtype(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION getitemtaxtype(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemid ALIAS FOR $1;
  pTaxzoneid ALIAS FOR $2;
  _taxtypeid INTEGER;
BEGIN
  SELECT itemtax_taxtype_id
    INTO _taxtypeid
    FROM itemtax
   WHERE ((itemtax_item_id=pItemid)
     AND  (itemtax_taxzone_id=pTaxzoneid));
  IF (NOT FOUND) THEN
    SELECT itemtax_taxtype_id
      INTO _taxtypeid
      FROM itemtax
     WHERE ((itemtax_item_id=pItemid)
       AND  (itemtax_taxzone_id IS NULL));
    IF (NOT FOUND) THEN
      RETURN NULL;
    END IF;
  END IF;

  RETURN _taxtypeid;
END;
$_$;


ALTER FUNCTION public.getitemtaxtype(integer, integer) OWNER TO admin;

--
-- Name: cohead; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE cohead (
    cohead_id integer DEFAULT nextval(('cohead_cohead_id_seq'::text)::regclass) NOT NULL,
    cohead_number text NOT NULL,
    cohead_cust_id integer NOT NULL,
    cohead_custponumber text,
    cohead_type character(1),
    cohead_orderdate date,
    cohead_warehous_id integer,
    cohead_shipto_id integer,
    cohead_shiptoname text,
    cohead_shiptoaddress1 text,
    cohead_shiptoaddress2 text,
    cohead_shiptoaddress3 text,
    cohead_shiptoaddress4 text,
    cohead_shiptoaddress5 text,
    cohead_salesrep_id integer NOT NULL,
    cohead_terms_id integer NOT NULL,
    cohead_fob text,
    cohead_shipvia text,
    cohead_shiptocity text,
    cohead_shiptostate text,
    cohead_shiptozipcode text,
    cohead_freight numeric(16,4) NOT NULL,
    cohead_misc numeric(16,4) DEFAULT 0 NOT NULL,
    cohead_imported boolean DEFAULT false,
    cohead_ordercomments text,
    cohead_shipcomments text,
    cohead_shiptophone text,
    cohead_shipchrg_id integer,
    cohead_shipform_id integer,
    cohead_billtoname text,
    cohead_billtoaddress1 text,
    cohead_billtoaddress2 text,
    cohead_billtoaddress3 text,
    cohead_billtocity text,
    cohead_billtostate text,
    cohead_billtozipcode text,
    cohead_misc_accnt_id integer,
    cohead_misc_descrip text,
    cohead_commission numeric(16,4),
    cohead_miscdate date,
    cohead_holdtype character(1),
    cohead_packdate date,
    cohead_prj_id integer,
    cohead_wasquote boolean DEFAULT false NOT NULL,
    cohead_lastupdated timestamp without time zone DEFAULT ('now'::text)::timestamp(6) with time zone NOT NULL,
    cohead_shipcomplete boolean DEFAULT false NOT NULL,
    cohead_created timestamp without time zone DEFAULT ('now'::text)::timestamp(6) with time zone,
    cohead_creator text DEFAULT geteffectivextuser(),
    cohead_quote_number text,
    cohead_billtocountry text,
    cohead_shiptocountry text,
    cohead_curr_id integer DEFAULT basecurrid(),
    cohead_calcfreight boolean DEFAULT false NOT NULL,
    cohead_shipto_cntct_id integer,
    cohead_shipto_cntct_honorific text,
    cohead_shipto_cntct_first_name text,
    cohead_shipto_cntct_middle text,
    cohead_shipto_cntct_last_name text,
    cohead_shipto_cntct_suffix text,
    cohead_shipto_cntct_phone text,
    cohead_shipto_cntct_title text,
    cohead_shipto_cntct_fax text,
    cohead_shipto_cntct_email text,
    cohead_billto_cntct_id integer,
    cohead_billto_cntct_honorific text,
    cohead_billto_cntct_first_name text,
    cohead_billto_cntct_middle text,
    cohead_billto_cntct_last_name text,
    cohead_billto_cntct_suffix text,
    cohead_billto_cntct_phone text,
    cohead_billto_cntct_title text,
    cohead_billto_cntct_fax text,
    cohead_billto_cntct_email text,
    cohead_taxzone_id integer,
    cohead_taxtype_id integer,
    cohead_ophead_id integer,
    cohead_status character(1) DEFAULT 'O'::bpchar NOT NULL,
    cohead_saletype_id integer,
    cohead_shipzone_id integer,
    CONSTRAINT cohead_check CHECK (((cohead_misc = (0)::numeric) OR ((cohead_misc <> (0)::numeric) AND (cohead_misc_accnt_id IS NOT NULL)))),
    CONSTRAINT cohead_cohead_number_check CHECK ((cohead_number <> ''::text))
);


ALTER TABLE public.cohead OWNER TO admin;

--
-- Name: TABLE cohead; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE cohead IS 'Sales Order header information';


--
-- Name: COLUMN cohead.cohead_saletype_id; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON COLUMN cohead.cohead_saletype_id IS 'Associated sale type for sales order.';


--
-- Name: COLUMN cohead.cohead_shipzone_id; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON COLUMN cohead.cohead_shipzone_id IS 'Associated shipping zone for sales order.';


--
-- Name: coitem; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE coitem (
    coitem_id integer DEFAULT nextval(('coitem_coitem_id_seq'::text)::regclass) NOT NULL,
    coitem_cohead_id integer,
    coitem_linenumber integer NOT NULL,
    coitem_itemsite_id integer,
    coitem_status character(1),
    coitem_scheddate date,
    coitem_promdate date,
    coitem_qtyord numeric(18,6) NOT NULL,
    coitem_unitcost numeric(16,6) NOT NULL,
    coitem_price numeric(16,4) NOT NULL,
    coitem_custprice numeric(16,4) NOT NULL,
    coitem_qtyshipped numeric(18,6) NOT NULL,
    coitem_order_id integer,
    coitem_memo text,
    coitem_imported boolean DEFAULT false,
    coitem_qtyreturned numeric(18,6),
    coitem_closedate timestamp with time zone,
    coitem_custpn text,
    coitem_order_type character(1),
    coitem_close_username text,
    coitem_lastupdated timestamp without time zone DEFAULT ('now'::text)::timestamp(6) with time zone NOT NULL,
    coitem_substitute_item_id integer,
    coitem_created timestamp without time zone DEFAULT ('now'::text)::timestamp(6) with time zone,
    coitem_creator text DEFAULT geteffectivextuser(),
    coitem_prcost numeric(16,6),
    coitem_qty_uom_id integer NOT NULL,
    coitem_qty_invuomratio numeric(20,10) NOT NULL,
    coitem_price_uom_id integer NOT NULL,
    coitem_price_invuomratio numeric(20,10) NOT NULL,
    coitem_warranty boolean DEFAULT false NOT NULL,
    coitem_cos_accnt_id integer,
    coitem_qtyreserved numeric(18,6) DEFAULT 0.0 NOT NULL,
    coitem_subnumber integer DEFAULT 0 NOT NULL,
    coitem_firm boolean DEFAULT false NOT NULL,
    coitem_taxtype_id integer,
    coitem_rev_accnt_id integer,
    coitem_pricemode character(1) DEFAULT 'D'::bpchar NOT NULL,
    CONSTRAINT coitem_coitem_status_check CHECK ((((coitem_status = 'O'::bpchar) OR (coitem_status = 'C'::bpchar)) OR (coitem_status = 'X'::bpchar))),
    CONSTRAINT valid_coitem_pricemode CHECK ((coitem_pricemode = ANY (ARRAY['D'::bpchar, 'M'::bpchar])))
);


ALTER TABLE public.coitem OWNER TO admin;

--
-- Name: TABLE coitem; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE coitem IS 'Sales Order Line Item information';


--
-- Name: COLUMN coitem.coitem_pricemode; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON COLUMN coitem.coitem_pricemode IS 'Pricing mode for sales order item.  Valid values are D-discount, and M-markup';


--
-- Name: pohead; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE pohead (
    pohead_id integer DEFAULT nextval(('pohead_pohead_id_seq'::text)::regclass) NOT NULL,
    pohead_status character(1),
    pohead_number text NOT NULL,
    pohead_orderdate date,
    pohead_vend_id integer,
    pohead_fob text,
    pohead_shipvia text,
    pohead_comments text,
    pohead_freight numeric(16,2) DEFAULT 0,
    pohead_printed boolean DEFAULT false,
    pohead_terms_id integer,
    pohead_warehous_id integer,
    pohead_vendaddr_id integer,
    pohead_agent_username text,
    pohead_curr_id integer DEFAULT basecurrid(),
    pohead_saved boolean DEFAULT true NOT NULL,
    pohead_taxzone_id integer,
    pohead_taxtype_id integer,
    pohead_dropship boolean DEFAULT false,
    pohead_vend_cntct_id integer,
    pohead_vend_cntct_honorific text,
    pohead_vend_cntct_first_name text,
    pohead_vend_cntct_middle text,
    pohead_vend_cntct_last_name text,
    pohead_vend_cntct_suffix text,
    pohead_vend_cntct_phone text,
    pohead_vend_cntct_title text,
    pohead_vend_cntct_fax text,
    pohead_vend_cntct_email text,
    pohead_vendaddress1 text,
    pohead_vendaddress2 text,
    pohead_vendaddress3 text,
    pohead_vendcity text,
    pohead_vendstate text,
    pohead_vendzipcode text,
    pohead_vendcountry text,
    pohead_shipto_cntct_id integer,
    pohead_shipto_cntct_honorific text,
    pohead_shipto_cntct_first_name text,
    pohead_shipto_cntct_middle text,
    pohead_shipto_cntct_last_name text,
    pohead_shipto_cntct_suffix text,
    pohead_shipto_cntct_phone text,
    pohead_shipto_cntct_title text,
    pohead_shipto_cntct_fax text,
    pohead_shipto_cntct_email text,
    pohead_shiptoaddress_id integer,
    pohead_shiptoaddress1 text,
    pohead_shiptoaddress2 text,
    pohead_shiptoaddress3 text,
    pohead_shiptocity text,
    pohead_shiptostate text,
    pohead_shiptozipcode text,
    pohead_shiptocountry text,
    pohead_cohead_id integer,
    pohead_released date,
    CONSTRAINT pohead_pohead_number_check CHECK ((pohead_number <> ''::text)),
    CONSTRAINT pohead_pohead_status_check CHECK ((((pohead_status = 'U'::bpchar) OR (pohead_status = 'O'::bpchar)) OR (pohead_status = 'C'::bpchar)))
);


ALTER TABLE public.pohead OWNER TO admin;

--
-- Name: TABLE pohead; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE pohead IS 'Purchase Order header information';


--
-- Name: poitem; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE poitem (
    poitem_id integer DEFAULT nextval(('poitem_poitem_id_seq'::text)::regclass) NOT NULL,
    poitem_status character(1),
    poitem_pohead_id integer,
    poitem_linenumber integer,
    poitem_duedate date,
    poitem_itemsite_id integer,
    poitem_vend_item_descrip text,
    poitem_vend_uom text,
    poitem_invvenduomratio numeric(20,10),
    poitem_qty_ordered numeric(18,6) NOT NULL,
    poitem_qty_received numeric(18,6) DEFAULT 0.0 NOT NULL,
    poitem_qty_returned numeric(18,6) DEFAULT 0.0 NOT NULL,
    poitem_qty_vouchered numeric(18,6) DEFAULT 0.0 NOT NULL,
    poitem_unitprice numeric(16,6),
    poitem_vend_item_number text,
    poitem_comments text,
    poitem_qty_toreceive numeric(18,6),
    poitem_expcat_id integer,
    poitem_itemsrc_id integer,
    poitem_freight numeric(16,4) DEFAULT 0.0 NOT NULL,
    poitem_freight_received numeric(16,4) DEFAULT 0.0 NOT NULL,
    poitem_freight_vouchered numeric(16,4) DEFAULT 0.0 NOT NULL,
    poitem_prj_id integer,
    poitem_stdcost numeric(16,6),
    poitem_bom_rev_id integer,
    poitem_boo_rev_id integer,
    poitem_manuf_name text,
    poitem_manuf_item_number text,
    poitem_manuf_item_descrip text,
    poitem_taxtype_id integer,
    poitem_tax_recoverable boolean DEFAULT true NOT NULL,
    poitem_rlsd_duedate date,
    poitem_order_id integer,
    poitem_order_type character(1),
    CONSTRAINT poitem_poitem_status_check CHECK ((((poitem_status = 'U'::bpchar) OR (poitem_status = 'O'::bpchar)) OR (poitem_status = 'C'::bpchar)))
);


ALTER TABLE public.poitem OWNER TO admin;

--
-- Name: TABLE poitem; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE poitem IS 'Purchase Order Line Item information';


--
-- Name: taxtype; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE taxtype (
    taxtype_id integer NOT NULL,
    taxtype_name text NOT NULL,
    taxtype_descrip text,
    taxtype_sys boolean DEFAULT false NOT NULL,
    CONSTRAINT taxtype_taxtype_name_check CHECK ((taxtype_name <> ''::text))
);


ALTER TABLE public.taxtype OWNER TO admin;

--
-- Name: TABLE taxtype; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE taxtype IS 'The list of Tax Types';


--
-- Name: uom; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE uom (
    uom_id integer NOT NULL,
    uom_name text NOT NULL,
    uom_descrip text,
    uom_item_weight boolean DEFAULT false NOT NULL,
    CONSTRAINT uom_uom_name_check CHECK ((uom_name <> ''::text))
);


ALTER TABLE public.uom OWNER TO admin;

--
-- Name: TABLE uom; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE uom IS 'Unit of Measure information';


SET search_path = api, pg_catalog;

--
-- Name: salesline; Type: VIEW; Schema: api; Owner: admin
--

CREATE VIEW salesline AS
    SELECT (cohead.cohead_number)::character varying AS order_number, (public.formatsolinenumber(coitem.coitem_id))::character varying AS line_number, l.item_number, coitem.coitem_custpn AS customer_pn, s.item_number AS substitute_for, whsinfo.warehous_code AS sold_from_site, coitem.coitem_status AS status, coitem.coitem_qtyord AS qty_ordered, q.uom_name AS qty_uom, coitem.coitem_price AS net_unit_price, p.uom_name AS price_uom, coitem.coitem_scheddate AS scheduled_date, coitem.coitem_promdate AS promise_date, coitem.coitem_warranty AS warranty, COALESCE((SELECT taxtype.taxtype_name FROM public.taxtype WHERE (taxtype.taxtype_id = public.getitemtaxtype(l.item_id, cohead.cohead_taxzone_id))), 'None'::text) AS tax_type, CASE WHEN (coitem.coitem_price = (0)::numeric) THEN '100'::text WHEN (coitem.coitem_custprice = (0)::numeric) THEN 'N/A'::text ELSE (round((((1)::numeric - (coitem.coitem_price / coitem.coitem_custprice)) * (100)::numeric), 4))::text END AS discount_pct_from_list, CASE WHEN (coitem.coitem_order_id = (-1)) THEN false ELSE true END AS create_order, CASE WHEN (coitem.coitem_order_id = (-1)) THEN ''::text ELSE ((pohead.pohead_number || '-'::text) || poitem.poitem_linenumber) END AS create_po, coitem.coitem_prcost AS overwrite_po_price, coitem.coitem_memo AS notes, CASE WHEN (coitem.coitem_cos_accnt_id IS NOT NULL) THEN public.formatglaccount(coitem.coitem_cos_accnt_id) ELSE NULL::text END AS alternate_cos_account, CASE WHEN (coitem.coitem_rev_accnt_id IS NOT NULL) THEN public.formatglaccount(coitem.coitem_rev_accnt_id) ELSE NULL::text END AS alternate_rev_account FROM public.cohead, (((public.coitem LEFT JOIN public.itemsite isb ON ((coitem.coitem_substitute_item_id = isb.itemsite_id))) LEFT JOIN public.item s ON ((isb.itemsite_item_id = s.item_id))) LEFT JOIN (public.poitem JOIN public.pohead ON ((poitem.poitem_pohead_id = pohead.pohead_id))) ON ((poitem.poitem_id = coitem.coitem_order_id))), public.itemsite il, public.item l, public.whsinfo, public.uom q, public.uom p WHERE ((((((cohead.cohead_id = coitem.coitem_cohead_id) AND (coitem.coitem_itemsite_id = il.itemsite_id)) AND (il.itemsite_item_id = l.item_id)) AND (il.itemsite_warehous_id = whsinfo.warehous_id)) AND (coitem.coitem_qty_uom_id = q.uom_id)) AND (coitem.coitem_price_uom_id = p.uom_id)) ORDER BY cohead.cohead_number, coitem.coitem_linenumber, coitem.coitem_subnumber;


ALTER TABLE api.salesline OWNER TO admin;

--
-- Name: VIEW salesline; Type: COMMENT; Schema: api; Owner: admin
--

COMMENT ON VIEW salesline IS 'Sales Order Line Item';


--
-- Name: insertsalesline(salesline); Type: FUNCTION; Schema: api; Owner: admin
--

CREATE FUNCTION insertsalesline(salesline) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pNEW ALIAS FOR $1;
  _r RECORD;

BEGIN

  IF (NOT EXISTS (SELECT cohead_id FROM cohead WHERE cohead_number=pNEW.order_number)) THEN
    RAISE EXCEPTION 'Function insertSalesLine failed because Sales Order % not found', pNEW.order_number;
  END IF;

  IF (NOT EXISTS (SELECT item_id FROM item WHERE item_number=pNEW.item_number)) THEN
    RAISE EXCEPTION 'Function insertSalesLine failed because Item Number % not found', pNEW.item_number;
  END IF;

  SELECT * INTO _r
  FROM cohead, itemsite, item, whsinfo
  WHERE ((cohead_number=pNEW.order_number)
  AND (itemsite_warehous_id=warehous_id
  AND (itemsite_item_id=item_id)
  AND (itemsite_active)
  AND (item_number=pNEW.item_number)
  AND (warehous_active)
  AND (warehous_id=COALESCE(getWarehousId(pNEW.sold_from_site,'ALL'),cohead_warehous_id,fetchprefwarehousid()))));

  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Function insertSalesLine failed with unknown failure to retrieve Sales Order';
  END IF;

  INSERT INTO coitem (
    coitem_cohead_id,
    coitem_linenumber,
    coitem_itemsite_id,
    coitem_status,
    coitem_scheddate,
    coitem_promdate,
    coitem_qtyord,
    coitem_qty_uom_id,
    coitem_qty_invuomratio,
    coitem_qtyshipped,
    coitem_unitcost,
    coitem_price,
    coitem_price_uom_id,
    coitem_price_invuomratio,
    coitem_custprice,
    coitem_order_id,
    coitem_memo,
    coitem_imported,
    coitem_qtyreturned,
    coitem_custpn,
    coitem_order_type,
    coitem_substitute_item_id,
    coitem_prcost,
    coitem_taxtype_id,
    coitem_warranty,
    coitem_cos_accnt_id,
    coitem_rev_accnt_id)
  VALUES (
    _r.cohead_id,
    pNEW.line_number::INTEGER,
    _r.itemsite_id,
    pNEW.status,
    pNEW.scheduled_date,
    pNEW.promise_date,
    pNEW.qty_ordered,
    COALESCE(getUomId(pNEW.qty_uom),_r.item_inv_uom_id),
    itemuomtouomratio(_r.item_id,COALESCE(getUomId(pNEW.qty_uom),_r.item_inv_uom_id),_r.item_inv_uom_id),
    0,
    stdCost(_r.item_id),
    COALESCE(pNEW.net_unit_price,itemPrice(_r.item_id,_r.cohead_cust_id,
             _r.cohead_shipto_id,pNEW.qty_ordered,_r.cohead_curr_id,_r.cohead_orderdate)),
    COALESCE(getUomId(pNEW.price_uom),_r.item_price_uom_id),
    itemuomtouomratio(_r.item_id,COALESCE(getUomId(pNEW.price_uom),_r.item_price_uom_id),_r.item_price_uom_id),
    itemPrice(_r.item_id, _r.cohead_cust_id, _r.cohead_shipto_id,
              pNEW.qty_ordered, _r.item_inv_uom_id, _r.item_price_uom_id,
              _r.cohead_curr_id,_r.cohead_orderdate,
              CASE WHEN (fetchMetricText('soPriceEffective') = 'ScheduleDate') THEN pNEW.scheduled_date
                   WHEN (fetchMetricText('soPriceEffective') = 'OrderDate') THEN _r.cohead_orderdate
                   ELSE CURRENT_DATE END,
              NULL)
    -1,
    pNEW.notes,
    true,
    0,
    pNEW.customer_pn,
    CASE
      WHEN ((pNEW.create_order  AND (_r.item_type = 'M')) OR 
           ((pNEW.create_order IS NULL) AND _r.itemsite_createwo)) THEN
        'W'
      WHEN ((pNEW.create_order AND (_r.item_type = 'P')) OR 
           ((pNEW.create_order IS NULL) AND _r.itemsite_createsopr)) THEN
        'R'
      WHEN ((pNEW.create_order AND (_r.item_type = 'P') AND (_r.itemsite_createsopo)) OR 
           ((pNEW.create_order IS NULL) AND _r.itemsite_createsopo)) THEN
        'P'
    END,
    getitemid(pNEW.substitute_for),
    pNEW.overwrite_po_price,
    COALESCE(getTaxTypeId(pNEW.tax_type), getItemTaxType(_r.itemsite_item_id, _r.cohead_taxzone_id)),
    pNEW.warranty,
    getGlAccntId(pNEW.alternate_cos_account),
    getGlAccntId(pNEW.alternate_rev_account)
    );

  RETURN TRUE;
END;
$_$;


ALTER FUNCTION api.insertsalesline(salesline) OWNER TO admin;

SET search_path = public, pg_catalog;

--
-- Name: _accntdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _accntdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _accntnum     TEXT := formatGLAccount(OLD.accnt_id);
  _check INTEGER;
BEGIN
-- This trigger is to protect against accounts that are in use

--  Check to see if the passed accnt is used in a Cost Category
  SELECT costcat_id INTO _check
  FROM costcat
  WHERE ( (costcat_asset_accnt_id=OLD.accnt_id)
     OR   (costcat_liability_accnt_id=OLD.accnt_id)
     OR   (costcat_adjustment_accnt_id=OLD.accnt_id)
     OR   (costcat_purchprice_accnt_id=OLD.accnt_id)
     OR   (costcat_laboroverhead_accnt_id=OLD.accnt_id)
     OR   (costcat_scrap_accnt_id=OLD.accnt_id)
     OR   (costcat_invcost_accnt_id=OLD.accnt_id)
     OR   (costcat_wip_accnt_id=OLD.accnt_id)
     OR   (costcat_shipasset_accnt_id=OLD.accnt_id)
     OR   (costcat_mfgscrap_accnt_id=OLD.accnt_id)
     OR   (costcat_transform_accnt_id=OLD.accnt_id)
     OR   (costcat_freight_accnt_id=OLD.accnt_id) )
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in Cost Category';
  END IF;

--  Check to see if the passed accnt is used in a Sales Account Assignment
  SELECT salesaccnt_id INTO _check
  FROM salesaccnt
  WHERE ( (salesaccnt_sales_accnt_id=OLD.accnt_id)
     OR   (salesaccnt_credit_accnt_id=OLD.accnt_id)
     OR   (salesaccnt_cos_accnt_id=OLD.accnt_id) )
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in Sales Account Assignment';
  END IF;

--  Check to see if the passed accnt is used in a A/R Account Assignment
  SELECT araccnt_id INTO _check
  FROM araccnt
  WHERE ( (araccnt_freight_accnt_id=OLD.accnt_id)
     OR   (araccnt_ar_accnt_id=OLD.accnt_id)
     OR   (araccnt_prepaid_accnt_id=OLD.accnt_id) )
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in A/R Account Assignment';
  END IF;

--  Check to see if the passed accnt is used in a Warehouse
  SELECT warehous_id INTO _check
  FROM whsinfo
  WHERE (warehous_default_accnt_id=OLD.accnt_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in Site';
  END IF;

--  Check to see if the passed accnt is used in a Bank Account
  SELECT bankaccnt_id INTO _check
  FROM bankaccnt
  WHERE (bankaccnt_accnt_id=OLD.accnt_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in Bank Account';
  END IF;

--  Check to see if the passed accnt is used in an Expense Category
  SELECT expcat_id INTO _check
  FROM expcat
  WHERE ( (expcat_exp_accnt_id=OLD.accnt_id)
     OR   (expcat_liability_accnt_id=OLD.accnt_id)
     OR   (expcat_purchprice_accnt_id=OLD.accnt_id)
     OR   (expcat_freight_accnt_id=OLD.accnt_id) )
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in Expense Category';
  END IF;

--  Check to see if the passed accnt is used in a Tax Code
  SELECT tax_id INTO _check
  FROM tax
  WHERE (tax_sales_accnt_id=OLD.accnt_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in Tax Code';
  END IF;

--  Check to see if the passed accnt is used in a Standard Journal Item
  SELECT stdjrnlitem_id INTO _check
  FROM stdjrnlitem
  WHERE (stdjrnlitem_accnt_id=OLD.accnt_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in Standard Journal Item';
  END IF;

--  Check to see if the passed accnt is used in a A/P Account Assignment
  SELECT apaccnt_ap_accnt_id INTO _check
  FROM apaccnt
  WHERE ( (apaccnt_ap_accnt_id=OLD.accnt_id)
     OR   (apaccnt_prepaid_accnt_id=OLD.accnt_id)
     OR   (apaccnt_discount_accnt_id=OLD.accnt_id) )
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in A/P Account Assignment';
  END IF;

--  Check to see if the passed accnt is used in an A/R Open Item record
  SELECT aropen_accnt_id INTO _check
    FROM aropen
   WHERE (aropen_accnt_id=OLD.accnt_id)
   LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in A/R Open Item';
  END IF;

--  Check to see if the passed accnt has been used in the G/L
  SELECT gltrans_accnt_id INTO _check
  FROM gltrans
  WHERE (gltrans_accnt_id=OLD.accnt_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in G/L Transaction';
  END IF;

  SELECT sltrans_accnt_id INTO _check
  FROM sltrans
  WHERE (sltrans_accnt_id=OLD.accnt_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in G/L Journal Transaction';
  END IF;

  SELECT glseries_accnt_id INTO _check
  FROM glseries
  WHERE (glseries_accnt_id=OLD.accnt_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in G/L Series';
  END IF;

  SELECT trialbal_accnt_id INTO _check
  FROM trialbal
  WHERE (trialbal_accnt_id=OLD.accnt_id)
    AND (trialbal_beginning != 0 OR trialbal_ending != 0)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in Trial Balance';
  END IF;

  SELECT cashrcptmisc_accnt_id INTO _check
  FROM cashrcptmisc
  WHERE (cashrcptmisc_accnt_id=OLD.accnt_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Can not delete, used in Cash Receipt Misc. Application';
  END IF;

  -- TODO: everything above here should be replaced by fkeys
  IF (OLD.accnt_id = fetchMetricValue('DefaultAPAccount')) THEN
    RAISE EXCEPTION 'Cannot delete the default A/P Account [xtuple: accnt, -1, %]',
                    _accntnum;
  ELSIF (OLD.accnt_id = fetchMetricValue('DefaultARAccount')) THEN
    RAISE EXCEPTION 'Cannot delete the default A/R Account [xtuple: accnt, -2, %]',
                    _accntnum;
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._accntdeletetrigger() OWNER TO admin;

--
-- Name: _accnttrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _accnttrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  ffSub BOOLEAN;
  ffProfit BOOLEAN;
  result INTEGER;
BEGIN
  SELECT (metric_value='t')
    INTO ffSub
    FROM metric
   WHERE(metric_name='GLFFSubaccounts')
   LIMIT 1;
  ffSub := COALESCE(ffSub, false);

  SELECT (metric_value='t')
    INTO ffProfit
    FROM metric
   WHERE(metric_name='GLFFProfitCenters')
   LIMIT 1;
  ffProfit := COALESCE(ffSub, false);

  IF (NEW.accnt_sub IS NOT NULL AND ffSub = false) THEN
    SELECT subaccnt_id
      INTO result
      FROM subaccnt
     WHERE(subaccnt_number=NEW.accnt_sub)
     LIMIT 1;
    IF (NOT FOUND) THEN
      RAISE EXCEPTION 'You must supply a valid Sub Account Number.';
    END IF;
  END IF;

  IF (NEW.accnt_profit IS NOT NULL AND ffProfit = false) THEN
    SELECT prftcntr_id
      INTO result
      FROM prftcntr
     WHERE(prftcntr_number=NEW.accnt_profit)
     LIMIT 1;
    IF (NOT FOUND) THEN
      RAISE EXCEPTION 'You must supply a valid Profit Center Number.';
    END IF;
  END IF;

  IF (TG_OP = 'UPDATE') THEN
    IF ((NEW.accnt_type != OLD.accnt_type) AND
        (SELECT (count(*) > 0) FROM gltrans WHERE (gltrans_accnt_id=NEW.accnt_id))) THEN
      RAISE EXCEPTION 'You may not change the account type of an account that has transaction history';
    END IF;
  END IF;

  NEW.accnt_name := formatGlAccount(NEW.accnt_company, NEW.accnt_profit, NEW.accnt_number, NEW.accnt_sub);

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._accnttrigger() OWNER TO admin;

--
-- Name: _accntuniquetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _accntuniquetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
BEGIN
  -- This trigger is to protect against id collision on inherited tables since there is no way 
  -- to enforce that with regular constraints.  It should be applied to accnt and any table that 
  -- inherits accnt.
  IF (SELECT (count(accnt_id) > 0) FROM accnt WHERE (accnt_id = NEW.accnt_id)) THEN
    RAISE EXCEPTION 'Can not create record on account with duplicate key %.', NEW.accnt_id;
  END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._accntuniquetrigger() OWNER TO admin;

--
-- Name: _addrtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _addrtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
  DECLARE
    _uses	INTEGER	:= 0;

  BEGIN

    IF (TG_OP = 'INSERT') THEN
      --- clear the number from the issue cache
      PERFORM clearNumberIssue('AddressNumber', NEW.addr_number);
    ELSE
      SELECT count(*) INTO _uses
      FROM cntct
      WHERE ((cntct_addr_id=OLD.addr_id)
        AND   cntct_active);
    END IF;

    IF (TG_OP = 'UPDATE') THEN
      IF (OLD.addr_active AND NOT NEW.addr_active AND _uses > 0) THEN
	RAISE EXCEPTION 'Cannot inactivate Address with Active Contacts (%)',
			_uses;
      END IF;
    ELSIF (TG_OP = 'DELETE') THEN
      IF (_uses > 0) THEN
	RAISE EXCEPTION 'Cannot Delete Address with Active Contacts (%)',
			_uses;
      END IF;

      UPDATE cntct SET cntct_addr_id = NULL
      WHERE ((cntct_addr_id=OLD.addr_id)
	AND  (NOT cntct_active));

      RETURN OLD;
    END IF;

    RETURN NEW;
  END;
$$;


ALTER FUNCTION public._addrtrigger() OWNER TO admin;

--
-- Name: _alarmbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _alarmbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
  BEGIN
    PERFORM clearNumberIssue('AlarmNumber', NEW.alarm_number);

    RETURN NEW;
  END;
$$;


ALTER FUNCTION public._alarmbeforetrigger() OWNER TO admin;

--
-- Name: _apapplytrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _apapplytrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _tpaid NUMERIC;

BEGIN

-- get the exchange rate for the doc date
  IF (TG_OP = 'INSERT') THEN
    SELECT currtocurr(NEW.apapply_curr_id,apopen_curr_id,NEW.apapply_amount,NEW.apapply_postdate) 
      INTO _tpaid
    FROM apopen
    WHERE ( apopen_id=NEW.apapply_target_apopen_id );
    IF (FOUND) THEN
      NEW.apapply_target_paid := _tpaid;
    ELSE
      RAISE EXCEPTION 'Error calculating paid amount on application';
    END IF;
  END IF;

  RETURN NEW;

END;

$$;


ALTER FUNCTION public._apapplytrigger() OWNER TO admin;

--
-- Name: _apopentrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _apopentrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _currrate NUMERIC;

BEGIN

-- get the base exchange rate for the doc date
  IF (TG_OP = 'INSERT' AND NEW.apopen_curr_rate IS NULL) THEN
    SELECT curr_rate INTO _currrate
    FROM curr_rate
    WHERE ( (NEW.apopen_curr_id=curr_id)
    AND ( NEW.apopen_docdate BETWEEN curr_effective 
                                 AND curr_expires) );
    IF (FOUND) THEN
      NEW.apopen_curr_rate := _currrate;
    ELSE
      RAISE EXCEPTION 'Currency exchange rate not found';
    END IF;
  END IF;

  NEW.apopen_open := NEW.apopen_amount > NEW.apopen_paid;

  IF (TG_OP = 'INSERT') THEN
    IF (NEW.apopen_open=FALSE) THEN
      NEW.apopen_status='C';
    ELSE
      NEW.apopen_status='O';
    END IF;

     --- clear the number from the issue cache
    PERFORM clearNumberIssue('APMemoNumber', NEW.apopen_docnumber);
  END IF;
  
  IF (TG_OP = 'UPDATE') THEN
    IF ((OLD.apopen_open=TRUE) AND (NEW.apopen_open=FALSE)) THEN
      NEW.apopen_status='C';
      IF (NEW.apopen_closedate IS NULL) THEN
        NEW.apopen_closedate=CURRENT_DATE;
      END IF;
    END IF;
    
    IF ((OLD.apopen_open=FALSE) AND (NEW.apopen_open=TRUE)) THEN
      NEW.apopen_status='O';
      NEW.apopen_closedate=NULL;
    END IF;
  END IF;

  RETURN NEW;

END;

$$;


ALTER FUNCTION public._apopentrigger() OWNER TO admin;

--
-- Name: _arapplytrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _arapplytrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _tpaid NUMERIC;

BEGIN

-- get the exchange rate for the doc date
  IF (TG_OP = 'INSERT') THEN
    IF (NEW.arapply_target_doctype != 'K') THEN 
      SELECT round(currtocurr(NEW.arapply_curr_id,aropen_curr_id,NEW.arapply_applied,NEW.arapply_postdate),2) 
        INTO NEW.arapply_target_paid
      FROM aropen
      WHERE ( aropen_id=NEW.arapply_target_aropen_id );
    ELSE
      SELECT round(currtocurr(NEW.arapply_curr_id,aropen_curr_id,NEW.arapply_applied,NEW.arapply_postdate),2) 
        INTO NEW.arapply_target_paid
      FROM aropen
      WHERE ( aropen_id=NEW.arapply_source_aropen_id );
    END IF;
    IF NOT FOUND THEN
      NEW.arapply_target_paid := NEW.arapply_applied;
    END IF;
  END IF;

  RETURN NEW;

END;

$$;


ALTER FUNCTION public._arapplytrigger() OWNER TO admin;

--
-- Name: _aropenaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _aropenaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _openAmount NUMERIC;
  _lateCount INTEGER := 0;
  _graceDays INTEGER;
  _checkLate BOOLEAN := false;
  _checkLimit BOOLEAN := false;
  _id INTEGER;
BEGIN

  IF (TG_OP = 'INSERT') THEN
    _id := NEW.aropen_id;
  ELSE
    _id := OLD.aropen_id;
  END IF;
-- If metric is set then auto close any associated incidents when AR is closed
  IF (fetchMetricBool('AutoCloseARIncident')) THEN
    IF (NEW.aropen_open = FALSE) THEN
      UPDATE incdt SET incdt_status='L' WHERE (incdt_aropen_id=_id);
    END IF;
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._aropenaftertrigger() OWNER TO admin;

--
-- Name: _aropentrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _aropentrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _openAmount NUMERIC;
  _p RECORD;
  _lateCount INTEGER := 0;
  _graceDays INTEGER;
  _checkLate BOOLEAN := false;
  _checkLimit BOOLEAN := false;
  _id INTEGER;
  _currRate NUMERIC;
BEGIN
  -- Checks
  -- Start with privileges
  IF ( (NOT checkPrivilege('MaintainARMemos')) AND
       (NOT checkPrivilege('PostMiscInvoices')) AND
       (NOT checkPrivilege('PostARDocuments')) ) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain A/R Memos.';
  END IF;

  IF ( (NEW.aropen_docnumber IS NULL) OR (LENGTH(NEW.aropen_docnumber) = 0) ) THEN
    RAISE EXCEPTION 'You must enter a valid Document # for this A/R Memo.';
  END IF;

  IF ( (NEW.aropen_amount IS NOT NULL) AND (NEW.aropen_amount < 0) ) THEN
    RAISE EXCEPTION 'You must enter a positive Amount for this A/R Memo.';
  END IF;

  IF (TG_OP IN ('INSERT', 'UPDATE') AND NEW.aropen_cust_id < 0) THEN
    RAISE NOTICE 'Fixing deprecated use of negative aropen_cust_id';
    NEW.aropen_cust_id := NULL;
  END IF;

  IF (TG_OP IN ('INSERT', 'UPDATE') AND NEW.aropen_salesrep_id < 0) THEN
    RAISE NOTICE 'Fixing deprecated use of negative aropen_salesrep_id';
    NEW.aropen_salesrep_id := NULL;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    SELECT aropen_id INTO _id
    FROM aropen
    WHERE ( (aropen_doctype=NEW.aropen_doctype)
      AND   (aropen_docnumber=NEW.aropen_docnumber) )
    LIMIT 1;
    IF (FOUND) THEN
      RAISE EXCEPTION 'This Document Type/Number already exists. You may not enter a duplicate A/R Memo.';
    END IF;

    --- clear the number from the issue cache if applicable
    PERFORM clearNumberIssue('ARMemoNumber', NEW.aropen_docnumber);
  END IF;

-- Determine the number of late invoices
  IF ( SELECT (metric_value='t')
         FROM metric
        WHERE(metric_name='AutoCreditWarnLateCustomers')) THEN
    _checkLate := true;

    SELECT COALESCE(metric_value::integer, _graceDays)
      INTO _graceDays
      FROM metric
     WHERE(metric_name='DefaultAutoCreditWarnGraceDays');
    IF (NOT FOUND) THEN
      _graceDays := 30;
    END IF;
    SELECT COALESCE(cust_gracedays, _graceDays)
      INTO _graceDays
      FROM custinfo
     WHERE(cust_id=NEW.aropen_cust_id);
    IF (NOT FOUND) THEN
      _graceDays := 30;
    END IF;

    SELECT count(aropen_id)
      INTO _lateCount
      FROM aropen
     WHERE((NEW.aropen_cust_id = aropen_cust_id)
       AND (aropen_open)
       AND (aropen_amount > aropen_paid)
       AND (aropen_doctype IN ('I', 'D'))
       AND (aropen_duedate < (CURRENT_DATE - _graceDays)));

  --  Adjust _lateCount if late invoice being paid
    IF ( (NEW.aropen_paid = NEW.aropen_amount)
     AND (NEW.aropen_doctype IN ('I', 'D'))
     AND (NEW.aropen_duedate < (CURRENT_DATE - _graceDays))) THEN
      _lateCount := _lateCount - 1;
    END IF;
  END IF;

-- get the base exchange rate for the doc date
  IF (TG_OP = 'INSERT' AND NEW.aropen_curr_rate IS NULL) THEN
    SELECT curr_rate INTO _currrate
      FROM curr_rate
    WHERE ( (NEW.aropen_curr_id=curr_id)
      AND ( NEW.aropen_docdate BETWEEN curr_effective 
                                   AND curr_expires) );
    IF (FOUND) THEN
      NEW.aropen_curr_rate := _currrate;
    ELSE
      RAISE EXCEPTION 'Currency exchange rate not found';
    END IF;
  END IF;

--  Close this aropen if it is paid
  IF (NEW.aropen_paid = NEW.aropen_amount) THEN
    NEW.aropen_open=FALSE;

--  Remove any aropenalloc regards that reference this aropen item
    DELETE FROM aropenalloc WHERE (aropenalloc_aropen_id=NEW.aropen_id);
  END IF;

  IF (TG_OP = 'INSERT') THEN
    IF (NEW.aropen_open=FALSE) 
    AND (NEW.aropen_closedate IS NULL) THEN
      NEW.aropen_closedate=current_date;
    END IF;
  END IF;
  
  IF (TG_OP = 'UPDATE') THEN
    IF ((OLD.aropen_open=TRUE) 
    AND (NEW.aropen_open=FALSE) 
    AND (NEW.aropen_closedate IS NULL)) THEN
      NEW.aropen_closedate=current_date;
    END IF;
  END IF;

--  Only check if the customer in question has a non-zero Credit Limit
  SELECT cust_id, cust_creditlmt, cust_creditstatus,
         cust_autoupdatestatus, cust_autoholdorders INTO _p
  FROM custinfo
  WHERE (cust_id=NEW.aropen_cust_id);
  IF (_p.cust_creditlmt > 0) THEN
    _checkLimit := true;

    SELECT COALESCE(SUM( CASE WHEN (aropen_doctype IN ('I', 'D')) THEN (aropen_amount - aropen_paid)
                     ELSE ((aropen_amount - aropen_paid) * -1)
                END ), 0.0) INTO _openAmount
    FROM aropen AS current
    WHERE ( (current.aropen_cust_id=NEW.aropen_cust_id)
     AND (current.aropen_open)
     AND (current.aropen_id <> NEW.aropen_id) );

--  Add in the value of the current aropen item
    IF (NEW.aropen_doctype IN ('I', 'D')) THEN
      _openAmount := (_openAmount + (NEW.aropen_amount - NEW.aropen_paid));
    ELSE
      _openAmount := (_openAmount - (NEW.aropen_amount - NEW.aropen_paid));
    END IF;
  ELSE
    _openAmount := 0;
  END IF;

  IF (_checkLimit OR _checkLate) THEN
--  Handle a Customer that is going under its credit limit
    IF ((_p.cust_creditlmt >= _openAmount) AND (_lateCount <= 0)) THEN

--  Handle the Customer Status
      IF ( (_p.cust_autoupdatestatus) AND (_p.cust_creditstatus='W') ) THEN
        UPDATE custinfo
        SET cust_creditstatus='G'
        WHERE (cust_id=NEW.aropen_cust_id);
      END IF;

--  Handle the open Sales Orders
      IF (_p.cust_autoholdorders) THEN
        UPDATE cohead
        SET cohead_holdtype='N'
        FROM coitem
        WHERE ( (coitem_cohead_id=cohead_id)
         AND (cohead_holdtype='C')
         AND (coitem_status='O')
         AND (cohead_cust_id=_p.cust_id) );
      END IF;

--  Handle a Customer that is going over its credit limit
    ELSIF ((_p.cust_creditlmt < _openAmount) OR (_lateCount > 0)) THEN

--  Handle the Customer Status
      IF ( (_p.cust_autoupdatestatus) AND (_p.cust_creditstatus = 'G') ) THEN
        UPDATE custinfo
        SET cust_creditstatus='W'
        WHERE (cust_id=NEW.aropen_cust_id);
      END IF;

--  Handle the open Sales Orders
      IF (_p.cust_autoholdorders) THEN
        UPDATE cohead
        SET cohead_holdtype='C'
        FROM coitem
        WHERE ( (coitem_cohead_id=cohead_id)
         AND (cohead_holdtype='N')
         AND (coitem_status='O')
         AND (cohead_cust_id=_p.cust_id) );
      END IF;

    END IF;

  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._aropentrigger() OWNER TO admin;

--
-- Name: _bomheadtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _bomheadtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _revid INTEGER;
  _check TEXT;
BEGIN
-- Privilege Checks
  IF (NOT checkPrivilege('MaintainBOMs')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Bills of Material.';
  END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._bomheadtrigger() OWNER TO admin;

--
-- Name: _bomitemaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _bomitemaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

BEGIN

  IF ( SELECT fetchMetricBool('ItemChangeLog') ) THEN
    IF (TG_OP = 'INSERT') THEN
      PERFORM postComment('ChangeLog', 'BMI', NEW.bomitem_id, ('Created BOM Item Sequence ' || NEW.bomitem_seqnumber::TEXT));

    ELSIF (TG_OP = 'UPDATE') THEN
      IF (NEW.bomitem_effective <> OLD.bomitem_effective) THEN
        PERFORM postComment( 'ChangeLog', 'BMI', NEW.bomitem_id,
                             ( 'Effective Date Changed from ' || formatDate(OLD.bomitem_effective, 'Always') ||
                               ' to ' || formatDate(NEW.bomitem_effective, 'Always' ) ) );
      END IF;

      IF (NEW.bomitem_expires <> OLD.bomitem_expires) THEN
        PERFORM postComment( 'ChangeLog', 'BMI', NEW.bomitem_id,
                             ( 'Expiration Date Changed from ' || formatDate(OLD.bomitem_expires, 'Never') ||
                               ' to ' || formatDate(NEW.bomitem_expires, 'Never' ) ) );
      END IF;

      IF (NEW.bomitem_qtyfxd <> OLD.bomitem_qtyfxd) THEN
        PERFORM postComment( 'ChangeLog', 'BMI', NEW.bomitem_id,
                             ( 'Fixed Qty. Changed from ' || formatQtyPer(OLD.bomitem_qtyfxd) ||
                               ' to ' || formatQtyPer(NEW.bomitem_qtyfxd ) ) );
      END IF;

      IF (NEW.bomitem_qtyper <> OLD.bomitem_qtyper) THEN
        PERFORM postComment( 'ChangeLog', 'BMI', NEW.bomitem_id,
                             ( 'Qty. Per Changed from ' || formatQtyPer(OLD.bomitem_qtyper) ||
                               ' to ' || formatQtyPer(NEW.bomitem_qtyper ) ) );
      END IF;

      IF (NEW.bomitem_scrap <> OLD.bomitem_scrap) THEN
        PERFORM postComment( 'ChangeLog', 'BMI', NEW.bomitem_id,
                             ( 'Scrap % Changed from ' || formatPrcnt(OLD.bomitem_scrap) ||
                               ' to ' || formatPrcnt(NEW.bomitem_scrap ) ) );
      END IF;

      IF (NEW.bomitem_issuemethod <> OLD.bomitem_issuemethod) THEN
        PERFORM postComment( 'ChangeLog', 'BMI', NEW.bomitem_id,
                             ( 'Issue Method Changed from ' || (CASE WHEN(OLD.bomitem_issuemethod='S') THEN 'Push'
                                                                     WHEN(OLD.bomitem_issuemethod='L') THEN 'Pull'
                                                                     WHEN(OLD.bomitem_issuemethod='M') THEN 'Mixed'
                                                                     ELSE OLD.bomitem_issuemethod END) ||
                               ' to ' || (CASE WHEN(NEW.bomitem_issuemethod='S') THEN 'Push'
                                               WHEN(NEW.bomitem_issuemethod='L') THEN 'Pull'
                                               WHEN(NEW.bomitem_issuemethod='M') THEN 'Mixed'
                                               ELSE NEW.bomitem_issuemethod END) ) );
      END IF;

      IF (NEW.bomitem_ecn <> OLD.bomitem_ecn) THEN
        PERFORM postComment( 'ChangeLog', 'BMI', NEW.bomitem_id,
                             ( 'ECN Changed from ' || OLD.bomitem_ecn ||
                               ' to ' || NEW.bomitem_ecn ) );
      END IF;

      IF (OLD.bomitem_createwo <> NEW.bomitem_createwo) THEN
        IF (NEW.bomitem_createwo) THEN
          PERFORM postComment('ChangeLog', 'BMI', NEW.bomitem_id, 'Create Child W/O activated');
        ELSE
          PERFORM postComment('ChangeLog', 'BMI', NEW.bomitem_id, 'Create Child W/O deactivated');
        END IF;
      END IF;

      IF (OLD.bomitem_issuewo <> NEW.bomitem_issuewo) THEN
        IF (NEW.bomitem_issuewo) THEN
          PERFORM postComment('ChangeLog', 'BMI', NEW.bomitem_id, 'Issue Child W/O activated');
        ELSE
          PERFORM postComment('ChangeLog', 'BMI', NEW.bomitem_id, 'Issue Child W/O deactivated');
        END IF;
      END IF;

    END IF;
  END IF;

  IF (TG_OP = 'DELETE') THEN
    DELETE FROM comment
     WHERE ( (comment_source='BMI')
       AND   (comment_source_id=OLD.bomitem_id) );

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._bomitemaftertrigger() OWNER TO admin;

--
-- Name: _bomitembeforedeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _bomitembeforedeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
BEGIN

  DELETE FROM comment
   WHERE ( (comment_source='BMI')
     AND   (comment_source_id=OLD.bomitem_id) );

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._bomitembeforedeletetrigger() OWNER TO admin;

--
-- Name: _bomitembeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _bomitembeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _bomworksetid INTEGER;
  _bomworkid INTEGER;
  _seqNumber INTEGER;
  _parentItem RECORD;
BEGIN

  -- Privilege Checks
  IF (NOT checkPrivilege('MaintainBOMs')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Bills of Material.';
  END IF;

  -- Cache Parent Item
   SELECT * INTO _parentItem
   FROM item
   WHERE (item_id=NEW.bomitem_parent_item_id);

  IF (TG_OP = 'INSERT') THEN
    --  Make sure that the parent and component are not the same
    IF (NEW.bomitem_parent_item_id = NEW.bomitem_item_id) THEN
      RAISE EXCEPTION 'BOM Item Parent and Component Item cannot be the same. [xtuple: createBOMItem, -1]';
    END IF;

    --  Make sure that the parent is not used in the component at some level
    IF ( SELECT (item_type IN ('M', 'F'))
         FROM item
         WHERE (item_id=NEW.bomitem_item_id) ) THEN
      SELECT indentedWhereUsed(NEW.bomitem_parent_item_id) INTO _bomworksetid;
      SELECT bomwork_id INTO _bomworkid
      FROM bomwork
      WHERE ((bomwork_set_id=_bomworksetid)
        AND  (bomwork_item_id=NEW.bomitem_item_id))
      LIMIT 1;
      IF (FOUND) THEN
        PERFORM deleteBOMWorkset(_bomworksetid);
        RAISE EXCEPTION 'BOM Item Parent is used by Component, BOM is recursive. [xtuple: createBOMItem, -2]';
      END IF;
    END IF;

    PERFORM deleteBOMWorkset(_bomworksetid);

    -- Set defaults
    NEW.bomitem_rev_id := COALESCE(NEW.bomitem_rev_id, -1);
    NEW.bomitem_booitem_seq_id := COALESCE(NEW.bomitem_booitem_seq_id, -1);
    NEW.bomitem_schedatwooper := COALESCE(NEW.bomitem_schedatwooper, FALSE);
    IF (NEW.bomitem_seqnumber IS NULL) THEN
      --  Grab the next Sequence Number, if any
      SELECT MAX(bomitem_seqnumber) INTO _seqNumber
      FROM bomitem(NEW.bomitem_parent_item_id,NEW.bomitem_rev_id);
      IF (_seqNumber IS NOT NULL) THEN
        NEW.bomitem_seqnumber := (_seqNumber + 10);
      ELSE
        NEW.bomitem_seqnumber := 10;
      END IF;
    END IF;
  END IF; -- end Insert specific

  IF (TG_OP = 'UPDATE') THEN
    -- Disallow changes that would compromise revision control integrity
    IF (NEW.bomitem_parent_item_id != OLD.bomitem_parent_item_id) THEN
      RAISE EXCEPTION 'Parent Item ID may not be changed.';
    END IF;

    IF (NEW.bomitem_item_id != OLD.bomitem_item_id) THEN
      RAISE EXCEPTION 'Item ID may not be changed.';
    END IF;

    IF ((fetchMetricBool('RevControl')) AND (OLD.bomitem_rev_id > -1)) THEN
      IF (SELECT (rev_status = 'I') FROM rev WHERE (rev_id=OLD.bomitem_rev_id)) THEN
        RAISE EXCEPTION 'Bill of material is Inactive and may not be modified';
      END IF;
    END IF;
  END IF; -- end Update specific

  -- Check for valid UOM
  IF (SELECT (count(*) != 1)
      FROM
             (SELECT uom_id
                FROM item JOIN uom ON (item_inv_uom_id=uom_id)
                WHERE(item_id=NEW.bomitem_item_id)
              UNION 
              SELECT uom_id
                FROM item JOIN itemuomconv ON (itemuomconv_item_id=item_id)
                          JOIN uom ON (itemuomconv_to_uom_id=uom_id),
                     itemuom, uomtype 
               WHERE((itemuomconv_from_uom_id=item_inv_uom_id)
                 AND (item_id=NEW.bomitem_item_id) 
                 AND (itemuom_itemuomconv_id=itemuomconv_id) 
                 AND (uomtype_id=itemuom_uomtype_id) 
                 AND (uomtype_name='MaterialIssue'))
              UNION 
              SELECT uom_id
                FROM item JOIN itemuomconv ON (itemuomconv_item_id=item_id)
                          JOIN uom ON (itemuomconv_from_uom_id=uom_id),
                     itemuom, uomtype 
               WHERE((itemuomconv_to_uom_id=item_inv_uom_id)
                 AND (item_id=NEW.bomitem_item_id) 
                 AND (itemuom_itemuomconv_id=itemuomconv_id) 
                 AND (uomtype_id=itemuom_uomtype_id) 
                 AND (uomtype_name='MaterialIssue'))) AS data
        WHERE (uom_id=NEW.bomitem_uom_id)) THEN
    RAISE EXCEPTION 'Unit of Measure Invalid for Material Issue.';
  END IF;

-- Disallow configuration parameters if parent is not a job item
   IF (NEW.bomitem_char_id IS NOT NULL) THEN
     IF (NOT _parentItem.item_config) THEN
       RAISE EXCEPTION 'Configuration characteristics may only be defined for Configured Items';
     END IF;
   END IF;

  -- Kit items must be sold and not kits themselves
  IF (_parentItem.item_type = 'K') THEN
    IF (SELECT (COUNT(item_id) = 0)
          FROM item
         WHERE ((item_id=NEW.bomitem_item_id)
           AND (item_sold)
           AND (item_type != 'K'))) THEN
       RAISE EXCEPTION 'Bill of Material Items for kits must be sold and not kits themselves';
     END IF;
   END IF;

  -- Over ride logic to disallow invalid data
  IF (NEW.bomitem_createwo) THEN
    IF (SELECT (item_type != 'M') 
          FROM item 
         WHERE (item_id=NEW.bomitem_item_id)) THEN
      NEW.bomitem_createwo := FALSE;
    END IF;
    IF (NEW.bomitem_booitem_seq_id = -1) THEN
      NEW.bomitem_schedatwooper := FALSE;
    END IF;
  END IF;

  NEW.bomitem_moddate := COALESCE(NEW.bomitem_moddate, CURRENT_DATE);

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._bomitembeforetrigger() OWNER TO admin;

--
-- Name: _bomitemsubtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _bomitemsubtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

-- Privilege Checks
  IF (NOT checkPrivilege('MaintainBOMs')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Bills of Material.';
  END IF;

  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  ELSE
    RETURN NEW;
  END IF;

END;
$$;


ALTER FUNCTION public._bomitemsubtrigger() OWNER TO admin;

--
-- Name: _cashrcptitemaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cashrcptitemaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _total      NUMERIC;

BEGIN

  -- Checks
  -- Total Over Application Warning
  SELECT (cashrcpt_amount - SUM(COALESCE(cashrcptitem_amount, 0))) INTO _total
  FROM cashrcptitem JOIN cashrcpt ON (cashrcpt_id=cashrcptitem_cashrcpt_id)
  WHERE (cashrcptitem_cashrcpt_id=NEW.cashrcptitem_cashrcpt_id)
  GROUP BY cashrcpt_amount;
  IF (_total < 0.0) THEN
    RAISE WARNING 'Warning -- the Cash Receipt has been over applied.';
  END IF;
  
  RETURN NEW;

END;
$$;


ALTER FUNCTION public._cashrcptitemaftertrigger() OWNER TO admin;

--
-- Name: _cashrcptitemtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cashrcptitemtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check      BOOLEAN;
  _openAmount NUMERIC;

BEGIN

  -- Checks
  -- Start with Privileges
  IF (TG_OP = 'INSERT') THEN
    SELECT checkPrivilege('MaintainCashReceipts') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to add a new Cash Receipt Application.';
    END IF;
  ELSE
    SELECT checkPrivilege('MaintainCashReceipts') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to alter a Cash Receipt Application.';
    END IF;
  END IF;

  -- Over Application
  SELECT round(currToCurr(aropen_curr_id, cashrcpt_curr_id,
               aropen_amount - aropen_paid, cashrcpt_distdate) -
               COALESCE((SELECT SUM(cashrcptitem_amount)
                           FROM cashrcptitem, cashrcpt
                           WHERE ((cashrcpt_id=cashrcptitem_cashrcpt_id)
                             AND  (NOT cashrcpt_void)
                             AND  (NOT cashrcpt_posted)
                             AND  (cashrcpt_id != NEW.cashrcptitem_cashrcpt_id)
                             AND  (cashrcptitem_aropen_id=NEW.cashrcptitem_aropen_id))), 0),2) INTO _openAmount
  FROM aropen, cashrcpt
  WHERE ( (aropen_id=NEW.cashrcptitem_aropen_id)
    AND   (cashrcpt_id=NEW.cashrcptitem_cashrcpt_id) );
  IF (NEW.cashrcptitem_amount > _openAmount) THEN
    RAISE EXCEPTION 'You may not apply more than the balance of this item.';
  END IF;


  RETURN NEW;

END;
$$;


ALTER FUNCTION public._cashrcptitemtrigger() OWNER TO admin;

--
-- Name: _cashrcptmisctrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cashrcptmisctrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check      BOOLEAN;

BEGIN

  -- Checks
  -- Start with Privileges
  IF (TG_OP = 'INSERT') THEN
    SELECT checkPrivilege('MaintainCashReceipts') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to add a new Cash Receipt Misc. Application.';
    END IF;
  ELSE
    SELECT checkPrivilege('MaintainCashReceipts') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to alter a Cash Receipt Misc. Application.';
    END IF;
  END IF;

  -- Account is required
  IF (NEW.cashrcptmisc_accnt_id IS NULL) THEN
    RAISE EXCEPTION 'You must supply a valid GL Account.';
  END IF;

  -- Amount is required
  IF (COALESCE(NEW.cashrcptmisc_amount, 0) = 0) THEN
    RAISE EXCEPTION 'You must supply a valid Amount.';
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._cashrcptmisctrigger() OWNER TO admin;

--
-- Name: _cashrcpttrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cashrcpttrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check      BOOLEAN;
  _checkId    INTEGER;
  _currId     INTEGER;
  _bankCurrId INTEGER;
  _evntType   TEXT;
  _whsId      INTEGER;
  _custNumber TEXT;
  _currrate   NUMERIC;

BEGIN

  -- Checks
  -- Start with privileges
  IF (TG_OP = 'INSERT') THEN
    SELECT checkPrivilege('MaintainCashReceipts') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to add new Cash Receipts.';
    END IF;
  ELSE
    SELECT checkPrivilege('MaintainCashReceipts') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to alter a Cash Receipt.';
    END IF;
  END IF;

  -- Currency must be same as Bank Currency
  IF (TG_OP = 'INSERT') THEN
    _currId = COALESCE(NEW.cashrcpt_curr_id, basecurrid());

     --- clear the number from the issue cache
    PERFORM clearNumberIssue('CashRcptNumber', NEW.cashrcpt_number);
  ELSE
    _currId = NEW.cashrcpt_curr_id;
  END IF;

-- get the base exchange rate for the dist date
  IF (NEW.cashrcpt_curr_rate IS NULL) THEN
    SELECT curr_rate INTO _currrate
    FROM curr_rate
    WHERE ( (NEW.cashrcpt_curr_id=curr_id)
      AND ( NEW.cashrcpt_distdate BETWEEN curr_effective 
                                 AND curr_expires) );
    IF (FOUND) THEN
      NEW.cashrcpt_curr_rate := _currrate;
    ELSE
      RAISE EXCEPTION 'Currency exchange rate not found';
    END IF;
  END IF;

  -- Create CashReceiptPosted Event
  IF (TG_OP = 'UPDATE') THEN
    IF (OLD.cashrcpt_posted=FALSE AND NEW.cashrcpt_posted=TRUE) THEN
      _evntType = 'CashReceiptPosted';
      -- Find the warehouse for which to create evntlog entries
      SELECT usrpref_value  INTO _whsId
      FROM usrpref
      WHERE usrpref_username = getEffectiveXtUser()
        AND usrpref_name = 'PreferredWarehouse';
      -- Find the Customer Number
      SELECT cust_number INTO _custNumber
      FROM custinfo
      WHERE (cust_id=NEW.cashrcpt_cust_id);

      INSERT INTO evntlog (evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                           evntlog_ord_id, evntlog_warehous_id, evntlog_number)
      SELECT DISTINCT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
                      NEW.cashrcpt_id, _whsId,
                     (_custNumber || '-' || NEW.cashrcpt_docnumber || ' ' || currConcat(NEW.cashrcpt_curr_id) || formatMoney(NEW.cashrcpt_amount))
      FROM evntnot, evnttype
      WHERE ((evntnot_evnttype_id=evnttype_id)
        AND  (evnttype_name=_evntType));
    END IF;
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._cashrcpttrigger() OWNER TO admin;

--
-- Name: _ccardtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _ccardtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

BEGIN

  New.ccard_lastupdated := current_timestamp;
  New.ccard_last_updated_by_username := getEffectiveXtUser();

  IF (TG_OP = 'UPDATE') THEN
    INSERT INTO ccardaud
         VALUES (nextval('ccardaud_ccardaud_id_seq'), NEW.ccard_id,
                 OLD.ccard_seq, NEW.ccard_seq, OLD.ccard_cust_id, NEW.ccard_cust_id,
                 OLD.ccard_active, NEW.ccard_active, OLD.ccard_name, NEW.ccard_name,
                 OLD.ccard_address1, NEW.ccard_address1, OLD.ccard_address2,
                 NEW.ccard_address2, OLD.ccard_city, NEW.ccard_city, OLD.ccard_state,
                 NEW.ccard_state, OLD.ccard_zip, NEW.ccard_zip, OLD.ccard_country,
                 NEW.ccard_country, OLD.ccard_number, NEW.ccard_number, OLD.ccard_debit,
                 NEW.ccard_debit, OLD.ccard_month_expired, NEW.ccard_month_expired,
                 OLD.ccard_year_expired, NEW.ccard_year_expired, OLD.ccard_type, NEW.ccard_type);
  ELSE
-- We are inserting a record, therefore no old values
    INSERT INTO ccardaud
         VALUES (nextval('ccardaud_ccardaud_id_seq'), NEW.ccard_id,
                 NULL, NEW.ccard_seq, NULL, NEW.ccard_cust_id, NULL,
                 NEW.ccard_active, NULL, NEW.ccard_name, NULL,
                 NEW.ccard_address1, NULL, NEW.ccard_address2, NULL,
                 NEW.ccard_city, NULL, NEW.ccard_state, NULL,
                 NEW.ccard_zip, NULL, NEW.ccard_country, NULL,
                 NEW.ccard_number, NULL, NEW.ccard_debit, NULL,
                 NEW.ccard_month_expired, NULL, NEW.ccard_year_expired, NULL,
                 NEW.ccard_type);
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._ccardtrigger() OWNER TO admin;

--
-- Name: _charasshistorytrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _charasshistorytrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF(TG_OP = 'DELETE') THEN
    IF (OLD.charass_target_type = 'INCDT') THEN
      INSERT INTO incdthist
            (incdthist_incdt_id, incdthist_descrip)
      VALUES(OLD.charass_target_id,
             ('Characteristic ' || 
               COALESCE((SELECT char_name 
                           FROM char
                          WHERE (char_id=OLD.charass_char_id)), '')
              || ' Deleted: "' || 
              COALESCE(OLD.charass_value,'')
              || '"') );
    END IF;
    RETURN OLD;
  ELSIF (NEW.charass_target_type = 'INCDT') THEN
    IF (TG_OP = 'INSERT') THEN
      INSERT INTO incdthist
            (incdthist_incdt_id, incdthist_descrip)
      VALUES(NEW.charass_target_id,
             ('Characteristic ' || 
               COALESCE((SELECT char_name 
                           FROM char
                          WHERE (char_id=NEW.charass_char_id)), '')
              || ' Added: "' || 
              COALESCE(NEW.charass_value,'')
              || '"') );
    ELSIF (TG_OP = 'UPDATE') THEN
      IF (COALESCE(NEW.charass_value,'') <> COALESCE(OLD.charass_value,'')) THEN
        INSERT INTO incdthist
              (incdthist_incdt_id, incdthist_descrip)
        VALUES(NEW.charass_target_id,
               ('Characteristic ' || 
                 COALESCE((SELECT char_name 
                             FROM char
                            WHERE (char_id=NEW.charass_char_id)), '')
                || ' Changed: "' || 
                COALESCE(OLD.charass_value,'')
                || '" -> "' ||
                COALESCE(NEW.charass_value,'')
                || '"') );
      END IF;
    END IF;
  END IF;
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._charasshistorytrigger() OWNER TO admin;

--
-- Name: _charasstrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _charasstrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

-- Privilege Checks
   IF (NEW.charass_target_type = 'I' AND NOT checkPrivilege('MaintainItemMasters')) THEN
     RAISE EXCEPTION 'You do not have privileges to maintain Items.';
   END IF;

   IF (NEW.charass_target_type = 'C' AND NOT checkPrivilege('MaintainCustomerMasters')) THEN
     RAISE EXCEPTION 'You do not have privileges to maintain Customers.';
   END IF;

-- Data check
  IF (NEW.charass_char_id IS NULL) THEN
	RAISE EXCEPTION 'You must supply a valid Characteristic ID.';
  END IF;

-- Default Logic
  IF (NEW.charass_default) THEN
    UPDATE charass
    SET charass_default = false 
    WHERE ((charass_target_id=NEW.charass_target_id)
    AND  (charass_target_type=NEW.charass_target_type)
    AND  (charass_char_id=NEW.charass_char_id)
    AND  (charass_id <> NEW.charass_ID));
  END IF;

-- Incident update
  IF (NEW.charass_target_type = 'INCDT') THEN
    UPDATE incdt SET incdt_updated = now() WHERE incdt_id = NEW.charass_target_id;
  END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._charasstrigger() OWNER TO admin;

--
-- Name: _charbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _charbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (NOT checkPrivilege('MaintainCharacteristics')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Characteristics.';
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._charbeforetrigger() OWNER TO admin;

--
-- Name: _charopttrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _charopttrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (NOT checkPrivilege('MaintainCharacteristics')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Characteristic options.';
  END IF;

  IF (TG_OP = 'UPDATE') THEN
    UPDATE charass SET
      charass_value = NEW.charopt_value
    WHERE ((charass_char_id=NEW.charopt_char_id)
      AND (charass_value=OLD.charopt_value));
  END IF;

  IF (TG_OP = 'DELETE') THEN
    IF (SELECT (count(charass_id) > 0)
        FROM charass
        WHERE ((charass_char_id=OLD.charopt_char_id)
         AND (charass_value=OLD.charopt_value))) THEN
       RAISE EXCEPTION 'This characteristic option value is in use and can not be deleted.';
    END IF;
  END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._charopttrigger() OWNER TO admin;

--
-- Name: _checkheadbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _checkheadbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE 
  _amount NUMERIC;
  _currrate NUMERIC;

BEGIN

-- get the base exchange rate for the check date
  IF (TG_OP = 'INSERT' AND NEW.checkhead_curr_rate IS NULL) THEN
    SELECT curr_rate INTO _currrate
    FROM curr_rate
    WHERE ( (NEW.checkhead_curr_id=curr_id)
      AND ( NEW.checkhead_checkdate BETWEEN curr_effective 
                                   AND curr_expires) );
    IF (FOUND) THEN
      NEW.checkhead_curr_rate := _currrate;
    ELSE
      RAISE EXCEPTION 'Currency exchange rate not found';
    END IF;
  END IF;

  IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN
    IF (NOT EXISTS (SELECT checkrecip_id
		    FROM checkrecip
		    WHERE ((checkrecip_type=NEW.checkhead_recip_type)
		      AND  (checkrecip_id=NEW.checkhead_recip_id)) )) THEN
      RAISE EXCEPTION 'Cannot verify recipient for check % (type %  id %)',
		      NEW.checkhead_number, NEW.checkhead_recip_type,
		      NEW.checkhead_recip_id;
    END IF;

    IF (NEW.checkhead_journalnumber IS NOT NULL
        AND NOT EXISTS (SELECT jrnluse_number
			FROM jrnluse
			WHERE (jrnluse_number=NEW.checkhead_journalnumber))
	) THEN
      RAISE EXCEPTION 'Journal Number % does not exist and cannot be used for check %.',
		      NEW.checkhead_journalnumber, NEW.checkhead_number;
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._checkheadbeforetrigger() OWNER TO admin;

--
-- Name: _cmheadbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cmheadbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check BOOLEAN;
  _id INTEGER;
BEGIN
  -- Checks
  -- Start with privileges
  SELECT checkPrivilege('MaintainCreditMemos') INTO _check;
  IF ( (TG_OP = 'INSERT') OR (TG_OP = 'DELETE') ) THEN
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to maintain Credit Memos.';
    END IF;
  END IF;
  IF (TG_OP = 'UPDATE') THEN
    IF ((OLD.cmhead_printed = NEW.cmhead_printed) AND NOT (_check) ) THEN
      RAISE EXCEPTION 'You do not have privileges to maintain Credit Memos.';
    END IF;
  END IF;

  IF (TG_OP = 'DELETE') THEN
    DELETE FROM cmheadtax
    WHERE (taxhist_parent_id=OLD.cmhead_id);

    RETURN OLD;
  END IF;

  IF ( (NEW.cmhead_number IS NULL) OR (LENGTH(NEW.cmhead_number) = 0) ) THEN
    RAISE EXCEPTION 'You must enter a valid Memo # for this Credit Memo.';
  END IF;

  IF (TG_OP = 'INSERT') THEN
    SELECT cmhead_id INTO _id
    FROM cmhead
    WHERE (cmhead_number=NEW.cmhead_number);
    IF (FOUND) THEN
      RAISE EXCEPTION 'The Memo # is already in use.';
    END IF;

    IF (fetchMetricText('CMNumberGeneration') IN ('A','O')) THEN
      --- clear the number from the issue cache
      PERFORM clearNumberIssue('CmNumber', NEW.cmhead_number);
    ELSIF (fetchMetricText('CMNumberGeneration') = 'S') THEN
      --- clear the number from the issue cache
      PERFORM clearNumberIssue('SoNumber', NEW.cmhead_number);
    END IF;
  END IF;

  IF (NEW.cmhead_cust_id IS NOT NULL) THEN
    SELECT cust_id INTO _id
    FROM custinfo
    WHERE (cust_id=NEW.cmhead_cust_id);
    IF (NOT FOUND) THEN
      RAISE EXCEPTION 'You must enter a valid Customer # for this Credit Memo.';
    END IF;
  END IF;

  IF ( (NEW.cmhead_misc > 0) AND (NEW.cmhead_misc_accnt_id = -1) ) THEN
    RAISE EXCEPTION 'You may not enter a Misc. Charge without indicating the G/L Sales Account.';
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._cmheadbeforetrigger() OWNER TO admin;

--
-- Name: _cmheadtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cmheadtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    -- If this was created by a return, then reset the return
    IF (OLD.cmhead_rahead_id IS NOT NULL) THEN
      UPDATE rahead SET
        rahead_headcredited=false
      WHERE (rahead_id=OLD.cmhead_rahead_id);
      DELETE FROM rahist
      WHERE ((rahist_rahead_id=OLD.cmhead_rahead_id)
      AND (rahist_source='CM')
      AND (rahist_source_id=OLD.cmhead_id));
    END IF;
    RETURN OLD;
  END IF;

-- Insert new row
  IF (TG_OP = 'INSERT') THEN

  -- Calculate Freight Tax
    IF (NEW.cmhead_freight <> 0) THEN
      PERFORM calculateTaxHist( 'cmheadtax',
                                NEW.cmhead_id,
                                NEW.cmhead_taxzone_id,
                                getFreightTaxtypeId(),
                                NEW.cmhead_docdate,
                                NEW.cmhead_curr_id,
                                NEW.cmhead_freight * -1 );
    END IF;
  END IF;

-- Update row
  IF (TG_OP = 'UPDATE') THEN

    IF ( (NEW.cmhead_freight <> OLD.cmhead_freight) OR
         (COALESCE(NEW.cmhead_taxzone_id,-1) <> COALESCE(OLD.cmhead_taxzone_id,-1)) OR
         (NEW.cmhead_docdate <> OLD.cmhead_docdate) OR
         (NEW.cmhead_curr_id <> OLD.cmhead_curr_id) ) THEN
  -- Calculate cmhead Tax
      PERFORM calculateTaxHist( 'cmheadtax',
                                NEW.cmhead_id,
                                NEW.cmhead_taxzone_id,
                                getFreightTaxtypeId(),
                                NEW.cmhead_docdate,
                                NEW.cmhead_curr_id,
                                NEW.cmhead_freight * -1 );
    END IF;

    IF ( (COALESCE(NEW.cmhead_taxzone_id,-1) <> COALESCE(OLD.cmhead_taxzone_id,-1)) OR
         (NEW.cmhead_docdate <> OLD.cmhead_docdate) OR
         (NEW.cmhead_curr_id <> OLD.cmhead_curr_id) ) THEN
  -- Calculate cmitem Tax
      IF (COALESCE(NEW.cmhead_taxzone_id,-1) <> COALESCE(OLD.cmhead_taxzone_id,-1)) THEN
    -- Cmitem trigger will calculate tax
        UPDATE cmitem SET cmitem_taxtype_id=getItemTaxType(itemsite_item_id,NEW.cmhead_taxzone_id)
        FROM itemsite 
        WHERE ((itemsite_id=cmitem_itemsite_id)
          AND (cmitem_cmhead_id=NEW.cmhead_id));
      ELSE
        PERFORM calculateTaxHist( 'cmitemtax',
                                  cmitem_id,
                                  NEW.cmhead_taxzone_id,
                                  cmitem_taxtype_id,
                                  NEW.cmhead_docdate,
                                  NEW.cmhead_curr_id,
                                  (cmitem_qtycredit * cmitem_qty_invuomratio) *
                                  (cmitem_unitprice / cmitem_price_invuomratio) * -1)
        FROM cmitem
        WHERE (cmitem_cmhead_id = NEW.cmhead_id);
      END IF;
    END IF;

  END IF;


  RETURN NEW;
END;
$$;


ALTER FUNCTION public._cmheadtrigger() OWNER TO admin;

--
-- Name: _cmitembeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cmitembeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check BOOLEAN;
  _id INTEGER;
BEGIN
  -- Checks
  -- Start with privileges
  SELECT checkPrivilege('MaintainCreditMemos') INTO _check;
  IF NOT (_check) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Credit Memos.';
  END IF;

  IF (TG_OP = 'DELETE') THEN
    DELETE FROM cmitemtax
    WHERE (taxhist_parent_id=OLD.cmitem_id);

    RETURN OLD;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    IF ( (NEW.cmitem_qtycredit IS NULL) OR (NEW.cmitem_qtycredit = 0) ) THEN
      RAISE EXCEPTION 'Quantity to Credit must be greater than zero.';
    END IF;
    SELECT cmitem_id INTO _id
    FROM cmitem
    WHERE ( (cmitem_cmhead_id=NEW.cmitem_cmhead_id) AND (cmitem_linenumber=NEW.cmitem_linenumber) );
    IF (FOUND) THEN
      RAISE EXCEPTION 'The Memo Line Number is already in use.';
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._cmitembeforetrigger() OWNER TO admin;

--
-- Name: _cmitemtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cmitemtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _ext NUMERIC;
  _r RECORD;

BEGIN
  IF (TG_OP = 'DELETE') THEN

--  If this was created by a return, reset return values
    IF (OLD.cmitem_raitem_id) IS NOT NULL THEN
      _ext := ROUND((OLD.cmitem_qtycredit * OLD.cmitem_qty_invuomratio) *  (OLD.cmitem_unitprice / OLD.cmitem_price_invuomratio),2);
      UPDATE raitem SET
        raitem_status = 'O',
        raitem_qtycredited = raitem_qtycredited-OLD.cmitem_qtycredit,
        raitem_amtcredited = raitem_amtcredited-_ext
      WHERE (raitem_id=OLD.cmitem_raitem_id);
    END IF;
    RETURN OLD;
  END IF;

-- Cache Credit Memo Head
  SELECT * INTO _r
  FROM cmhead
  WHERE (cmhead_id=NEW.cmitem_cmhead_id);
  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Credit Memo head not found';
  END IF;

-- Insert new row
  IF (TG_OP = 'INSERT') THEN

  -- Calculate Tax
      PERFORM calculateTaxHist( 'cmitemtax',
                                NEW.cmitem_id,
                                COALESCE(_r.cmhead_taxzone_id, -1),
                                NEW.cmitem_taxtype_id,
                                COALESCE(_r.cmhead_docdate, CURRENT_DATE),
                                COALESCE(_r.cmhead_curr_id, -1),
                                (NEW.cmitem_qtycredit * NEW.cmitem_qty_invuomratio) *
                                (NEW.cmitem_unitprice / NEW.cmitem_price_invuomratio) * -1);
  END IF;

-- Update row
  IF (TG_OP = 'UPDATE') THEN

  -- Calculate Tax
    IF ( (NEW.cmitem_qtycredit <> OLD.cmitem_qtycredit) OR
         (NEW.cmitem_qty_invuomratio <> OLD.cmitem_qty_invuomratio) OR
         (NEW.cmitem_unitprice <> OLD.cmitem_unitprice) OR
         (NEW.cmitem_price_invuomratio <> OLD.cmitem_price_invuomratio) OR
         (COALESCE(NEW.cmitem_taxtype_id, -1) <> COALESCE(OLD.cmitem_taxtype_id, -1)) ) THEN
      PERFORM calculateTaxHist( 'cmitemtax',
                                NEW.cmitem_id,
                                COALESCE(_r.cmhead_taxzone_id, -1),
                                NEW.cmitem_taxtype_id,
                                COALESCE(_r.cmhead_docdate, CURRENT_DATE),
                                COALESCE(_r.cmhead_curr_id, -1),
                                (NEW.cmitem_qtycredit * NEW.cmitem_qty_invuomratio) *
                                (NEW.cmitem_unitprice / NEW.cmitem_price_invuomratio) * -1);
    END IF;
  END IF;


  RETURN NEW;
END;
$$;


ALTER FUNCTION public._cmitemtrigger() OWNER TO admin;

--
-- Name: _cntcttrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cntcttrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  NEW.cntct_name := formatCntctName(NULL, NEW.cntct_first_name, NEW.cntct_middle, NEW.cntct_last_name, NEW.cntct_suffix);
  NEW.cntct_email := lower(NEW.cntct_email);

  IF (TG_OP = 'INSERT') THEN
    --- clear the number from the issue cache
    PERFORM clearNumberIssue('ContactNumber', NEW.cntct_number);
  END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._cntcttrigger() OWNER TO admin;

--
-- Name: _cntcttriggerafter(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cntcttriggerafter() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cntctemlid INTEGER;
  _rows INTEGER;
BEGIN
  IF (TG_OP = 'INSERT') THEN
    IF(length(coalesce(NEW.cntct_email,'')) > 0) THEN
      INSERT INTO cntcteml (
        cntcteml_cntct_id, cntcteml_primary, cntcteml_email )
      VALUES (
        NEW.cntct_id, true, NEW.cntct_email );
    END IF;
    PERFORM postComment('ChangeLog', 'T', NEW.cntct_id,
                        ('Created by ' || getEffectiveXtUser()));
  ELSIF (TG_OP = 'UPDATE') THEN
    IF (OLD.cntct_email != NEW.cntct_email) THEN
      SELECT cntcteml_id INTO _cntctemlid
      FROM cntcteml
      WHERE ((cntcteml_cntct_id=NEW.cntct_id)
        AND (cntcteml_email=NEW.cntct_email));

      GET DIAGNOSTICS _rows = ROW_COUNT;
      IF (_rows = 0) THEN
        UPDATE cntcteml SET
          cntcteml_primary=false
        WHERE ((cntcteml_cntct_id=NEW.cntct_id)
         AND (cntcteml_primary=true));
       
        INSERT INTO cntcteml (
          cntcteml_cntct_id, cntcteml_primary, cntcteml_email )
        VALUES (
          NEW.cntct_id, true, NEW.cntct_email ); 
      ELSE
        UPDATE cntcteml SET
          cntcteml_primary=false
        WHERE ((cntcteml_cntct_id=NEW.cntct_id)
         AND (cntcteml_primary=true));

        UPDATE cntcteml SET
          cntcteml_primary=true
        WHERE (cntcteml_id=_cntctemlid);
      END IF;
    END IF;
  ELSIF (TG_OP = 'DELETE') THEN
      DELETE FROM comment
       WHERE (comment_source_id=OLD.cntct_id AND comment_source = 'T');
      DELETE FROM docass
       WHERE (docass_source_id=OLD.cntct_id AND docass_source_type = 'T')
          OR (docass_target_id=OLD.cntct_id AND docass_target_type = 'T');
      
      RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._cntcttriggerafter() OWNER TO admin;

--
-- Name: _cntcttriggerbeforedelete(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cntcttriggerbeforedelete() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    DELETE FROM cntctaddr WHERE cntctaddr_cntct_id=OLD.cntct_id;
    DELETE FROM cntctdata WHERE cntctdata_cntct_id=OLD.cntct_id;
    DELETE FROM cntcteml  WHERE cntcteml_cntct_id=OLD.cntct_id;
    DELETE FROM docass WHERE docass_source_id = OLD.cntct_id AND docass_source_type = 'T';
    DELETE FROM docass WHERE docass_target_id = OLD.cntct_id AND docass_target_type = 'T';

    -- these have denormalized cntct info so it should be ok to update them
    UPDATE cohead SET cohead_billto_cntct_id=NULL
     WHERE cohead_billto_cntct_id=OLD.cntct_id;
    UPDATE cohead SET cohead_shipto_cntct_id=NULL
     WHERE cohead_shipto_cntct_id=OLD.cntct_id;

    UPDATE pohead SET pohead_vend_cntct_id=NULL
     WHERE pohead_vend_cntct_id=OLD.cntct_id;
    UPDATE pohead SET pohead_shipto_cntct_id=NULL
     WHERE pohead_shipto_cntct_id=OLD.cntct_id;

    UPDATE quhead SET quhead_billto_cntct_id=NULL
     WHERE quhead_billto_cntct_id=OLD.cntct_id;
    UPDATE quhead SET quhead_shipto_cntct_id=NULL
     WHERE quhead_shipto_cntct_id=OLD.cntct_id;

    IF (fetchMetricBool('MultiWhs')) THEN
      UPDATE tohead SET tohead_destcntct_id=NULL
       WHERE tohead_destcntct_id=OLD.cntct_id;
      UPDATE tohead SET tohead_srccntct_id=NULL
       WHERE tohead_srccntct_id=OLD.cntct_id;
    END IF;

  END IF;
  RETURN OLD;
END;
$$;


ALTER FUNCTION public._cntcttriggerbeforedelete() OWNER TO admin;

--
-- Name: _cntsliptrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cntsliptrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _p RECORD;
  _comments TEXT;
  _temp TEXT;

BEGIN
  IF (TG_OP = 'DELETE') THEN
    SELECT itemsite_loccntrl, itemsite_controlmethod,
           cntslip_posted, cntslip_lotserial, cntslip_comments,
           cntslip_number, cntslip_qty INTO _p
      FROM cntslip, invcnt, itemsite
     WHERE ( (cntslip_cnttag_id=invcnt_id)
       AND   (invcnt_itemsite_id=itemsite_id)
       AND   (cntslip_id=OLD.cntslip_id) );

    IF(_p.cntslip_posted) THEN
      SELECT ( '
Count Slip #' || _p.cntslip_number ||
             ' deleted ' || formatQty(_p.cntslip_qty) ) INTO _comments;

--  Add the Location name if the itemsite is MLC
      IF (_p.itemsite_loccntrl) THEN
        SELECT ( ', Location:' || location_name ) INTO _temp
          FROM location, cntslip
         WHERE ( (cntslip_location_id=location_id)
           AND   (cntslip_id=OLD.cntslip_id) );
  
        _comments := (_comments || _temp);
      END IF;
  
--  Add the Lot/Serial if the itemsite is Lot or Serial controlled
      IF (_p.itemsite_controlmethod = 'L') THEN
        _comments := (_comments || ( ', Lot #:' || _p.cntslip_lotserial));
      ELSIF (_p.itemsite_controlmethod = 'S') THEN
        _comments := (_comments || ( ', Serial #:' || _p.cntslip_lotserial));
      END IF;
  
      _comments := (_comments || ' ' || _p.cntslip_comments);
  
      UPDATE invcnt
         SET invcnt_qoh_after = ( COALESCE(invcnt_qoh_after, 0) - cntslip_qty),
             invcnt_comments = (invcnt_comments || _comments)
        FROM cntslip
       WHERE ( (cntslip_cnttag_id=invcnt_id)
         AND   (NOT invcnt_posted)
         AND   (cntslip_id=OLD.cntslip_id) );

    END IF;

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._cntsliptrigger() OWNER TO admin;

--
-- Name: _cobillbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cobillbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

BEGIN
  IF (TG_OP = 'DELETE') THEN
    DELETE FROM cobilltax
    WHERE (taxhist_parent_id=OLD.cobill_id);

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._cobillbeforetrigger() OWNER TO admin;

--
-- Name: _cobilltrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cobilltrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _r RECORD;

BEGIN
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

-- Cache Billing Head
  SELECT * INTO _r
  FROM cobmisc
  WHERE (cobmisc_id=NEW.cobill_cobmisc_id);
  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Billing head not found';
  END IF;

-- Insert new row
  IF (TG_OP = 'INSERT') THEN

  -- Calculate Tax
      PERFORM calculateTaxHist( 'cobilltax',
                                NEW.cobill_id,
                                COALESCE(_r.cobmisc_taxzone_id, -1),
                                NEW.cobill_taxtype_id,
                                COALESCE(_r.cobmisc_shipdate, CURRENT_DATE),
                                COALESCE(_r.cobmisc_curr_id, -1),
                                (NEW.cobill_qty * coitem_qty_invuomratio) *
                                (coitem_price / coitem_price_invuomratio) )
      FROM coitem
      WHERE (coitem_id=NEW.cobill_coitem_id);
  END IF;

-- Update row
  IF (TG_OP = 'UPDATE') THEN

  -- Calculate Tax
    IF ( (NEW.cobill_qty <> OLD.cobill_qty) OR
         (NEW.cobill_taxtype_id <> OLD.cobill_taxtype_id) ) THEN
      PERFORM calculateTaxHist( 'cobilltax',
                                NEW.cobill_id,
                                COALESCE(_r.cobmisc_taxzone_id, -1),
                                NEW.cobill_taxtype_id,
                                COALESCE(_r.cobmisc_shipdate, CURRENT_DATE),
                                COALESCE(_r.cobmisc_curr_id, -1),
                                (NEW.cobill_qty * coitem_qty_invuomratio) *
                                (coitem_price / coitem_price_invuomratio) )
      FROM coitem
      WHERE (coitem_id=NEW.cobill_coitem_id);
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._cobilltrigger() OWNER TO admin;

--
-- Name: _cobmiscbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cobmiscbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

BEGIN
  IF (TG_OP = 'DELETE') THEN
    DELETE FROM cobmisctax
    WHERE (taxhist_parent_id=OLD.cobmisc_id);

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._cobmiscbeforetrigger() OWNER TO admin;

--
-- Name: _cobmisctrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _cobmisctrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    -- Something can go here
    RETURN OLD;
  END IF;

-- Insert new row
  IF (TG_OP = 'INSERT') THEN

  -- Calculate Freight Tax
    IF (NEW.cobmisc_freight <> 0) THEN
      PERFORM calculateTaxHist( 'cobmisctax',
                                NEW.cobmisc_id,
                                NEW.cobmisc_taxzone_id,
                                getFreightTaxtypeId(),
                                NEW.cobmisc_invcdate,
                                NEW.cobmisc_curr_id,
                                NEW.cobmisc_freight );
    END IF;
  END IF;

-- Update row
  IF (TG_OP = 'UPDATE') THEN

  -- Calculate Tax
    IF (COALESCE(NEW.cobmisc_taxzone_id,-1) <> COALESCE(OLD.cobmisc_taxzone_id,-1)) THEN
      UPDATE cobill SET cobill_taxtype_id=getItemTaxType(itemsite_item_id,NEW.cobmisc_taxzone_id)
      FROM coitem
        JOIN itemsite ON (coitem_itemsite_id=itemsite_id)
      WHERE ((coitem_id=cobill_coitem_id)
       AND (cobill_cobmisc_id=NEW.cobmisc_id));
    END IF;
    
    IF ( (NEW.cobmisc_freight <> OLD.cobmisc_freight) OR
         (COALESCE(NEW.cobmisc_taxzone_id,-1) <> COALESCE(OLD.cobmisc_taxzone_id,-1)) OR
         (NEW.cobmisc_invcdate <> OLD.cobmisc_invcdate) OR
         (NEW.cobmisc_curr_id <> OLD.cobmisc_curr_id) ) THEN
      PERFORM calculateTaxHist( 'cobmisctax',
                                NEW.cobmisc_id,
                                NEW.cobmisc_taxzone_id,
                                getFreightTaxtypeId(),
                                NEW.cobmisc_invcdate,
                                NEW.cobmisc_curr_id,
                                NEW.cobmisc_freight );
      PERFORM calculateTaxHist( 'cobilltax',
                                cobill_id,
                                NEW.cobmisc_taxzone_id,
                                cobill_taxtype_id,
                                NEW.cobmisc_invcdate,
                                NEW.cobmisc_curr_id,
                                (cobill_qty * coitem_qty_invuomratio) *
                                (coitem_price / coitem_price_invuomratio) )
      FROM cobill JOIN coitem ON (coitem_id = cobill_coitem_id)
      WHERE (cobill_cobmisc_id = NEW.cobmisc_id);
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._cobmisctrigger() OWNER TO admin;

--
-- Name: _commenttrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _commenttrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (NEW.comment_cmnttype_id IS NULL) THEN
	RAISE EXCEPTION 'You must supply a valid Comment Type ID.';
  ELSIF (NEW.comment_source = 'INCDT') THEN
    UPDATE incdt SET incdt_updated = now() WHERE incdt_id = NEW.comment_source_id;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._commenttrigger() OWNER TO admin;

--
-- Name: _companytrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _companytrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _used	BOOLEAN := false;

BEGIN
  IF (NEW.company_external AND NOT OLD.company_external) THEN
    IF EXISTS(SELECT accnt_id
              FROM accnt, company, (
                  SELECT DISTINCT apaccnt_ap_accnt_id AS test_accnt_id FROM apaccnt
                  UNION SELECT DISTINCT apaccnt_discount_accnt_id FROM apaccnt
                  UNION SELECT DISTINCT apaccnt_prepaid_accnt_id FROM apaccnt
                  UNION SELECT DISTINCT apopen_accnt_id FROM apopen
                  UNION SELECT DISTINCT araccnt_ar_accnt_id FROM araccnt
                  UNION SELECT DISTINCT araccnt_deferred_accnt_id FROM araccnt
                  UNION SELECT DISTINCT araccnt_freight_accnt_id FROM araccnt
                  UNION SELECT DISTINCT araccnt_prepaid_accnt_id FROM araccnt
                  UNION SELECT DISTINCT aropen_accnt_id FROM aropen
                  UNION SELECT DISTINCT bankaccnt_accnt_id FROM bankaccnt
                  UNION SELECT DISTINCT bankaccnt_rec_accnt_id FROM bankaccnt
                  UNION SELECT DISTINCT budgitem_accnt_id FROM budgitem
                  UNION SELECT DISTINCT cashrcptmisc_accnt_id FROM cashrcptmisc
                  UNION SELECT DISTINCT cmhead_misc_accnt_id FROM cmhead
                  UNION SELECT DISTINCT cobmisc_misc_accnt_id FROM cobmisc
                  UNION SELECT DISTINCT cohead_misc_accnt_id FROM cohead
                  UNION SELECT DISTINCT coitem_cos_accnt_id FROM coitem
                  UNION SELECT DISTINCT costcat_adjustment_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_asset_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_freight_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_invcost_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_laboroverhead_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_liability_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_matusage_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_mfgscrap_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_purchprice_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_scrap_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_shipasset_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_toliability_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_transform_accnt_id FROM costcat
                  UNION SELECT DISTINCT costcat_wip_accnt_id FROM costcat
                  UNION SELECT DISTINCT costelem_exp_accnt_id FROM costelem
                  UNION SELECT DISTINCT expcat_exp_accnt_id FROM expcat
                  UNION SELECT DISTINCT expcat_freight_accnt_id FROM expcat
                  UNION SELECT DISTINCT expcat_liability_accnt_id FROM expcat
                  UNION SELECT DISTINCT expcat_purchprice_accnt_id FROM expcat
                  UNION SELECT DISTINCT glseries_accnt_id FROM glseries
                  UNION SELECT DISTINCT gltrans_accnt_id FROM gltrans
                  UNION SELECT DISTINCT invchead_misc_accnt_id FROM invchead
                  UNION SELECT DISTINCT quhead_misc_accnt_id FROM quhead
                  UNION SELECT DISTINCT salesaccnt_cor_accnt_id FROM salesaccnt
                  UNION SELECT DISTINCT salesaccnt_cos_accnt_id FROM salesaccnt
                  UNION SELECT DISTINCT salesaccnt_cow_accnt_id FROM salesaccnt
                  UNION SELECT DISTINCT salesaccnt_credit_accnt_id FROM salesaccnt
                  UNION SELECT DISTINCT salesaccnt_returns_accnt_id FROM salesaccnt
                  UNION SELECT DISTINCT salesaccnt_sales_accnt_id FROM salesaccnt
                  UNION SELECT DISTINCT salescat_ar_accnt_id FROM salescat
                  UNION SELECT DISTINCT salescat_prepaid_accnt_id FROM salescat
                  UNION SELECT DISTINCT salescat_sales_accnt_id FROM salescat
                  UNION SELECT DISTINCT stdjrnlitem_accnt_id FROM stdjrnlitem
                  UNION SELECT DISTINCT tax_sales_accnt_id FROM tax
                  UNION SELECT DISTINCT taxauth_accnt_id FROM taxauth
                  UNION SELECT DISTINCT vodist_accnt_id FROM vodist
                  UNION SELECT DISTINCT warehous_default_accnt_id FROM whsinfo
                ) AS dummy
              WHERE ((accnt_id=test_accnt_id)
                AND  (accnt_company=company_number)
                AND  (accnt_company=NEW.company_number))
    ) THEN
      RAISE EXCEPTION 'Cannot make Company % External because it is used in the local database.',
                      NEW.company_number;
    ELSIF (fetchMetricBool('EnableReturnAuth')) THEN
      IF EXISTS(SELECT accnt_id
              FROM accnt, company, (
                  SELECT DISTINCT rahead_misc_accnt_id AS test_accnt_id FROM rahead
                  UNION SELECT DISTINCT raitem_cos_accnt_id FROM raitem
                ) AS dummy
              WHERE ((accnt_id=test_accnt_id)
                AND  (accnt_company=company_number)
                AND  (accnt_company=NEW.company_number))
      ) THEN
        RAISE EXCEPTION 'Cannot make Company % External because it is used in the local database.',
                        NEW.company_number;
      END IF;
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._companytrigger() OWNER TO admin;

--
-- Name: _contrctaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _contrctaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

BEGIN

  -- synchronize contract effectivity with item source effectivity
  IF (NEW.contrct_effective <> OLD.contrct_effective) THEN
    UPDATE itemsrc SET itemsrc_effective=NEW.contrct_effective
    WHERE itemsrc_contrct_id=NEW.contrct_id;
  END IF;

  IF (NEW.contrct_expires <> OLD.contrct_expires) THEN
    UPDATE itemsrc SET itemsrc_expires=NEW.contrct_expires
    WHERE itemsrc_contrct_id=NEW.contrct_id;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._contrctaftertrigger() OWNER TO admin;

--
-- Name: _crmacctaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _crmacctaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;
  _gotpriv    BOOLEAN;

BEGIN
  /* update _number and _name separately to propagate just what changed.
     the priv manipulation allows targeted updates of crmaccount-maintained data
     (note: grantPriv() == false if the user already had the priv, true if this
     call granted the priv).
   */
  IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN
    IF (NEW.crmacct_cust_id IS NOT NULL) THEN
      _gotpriv := grantPriv(getEffectiveXtUser(), 'MaintainCustomerMasters');
      UPDATE custinfo SET cust_number = NEW.crmacct_number
      WHERE ((cust_id=NEW.crmacct_cust_id)
        AND  (cust_number!=NEW.crmacct_number));
      UPDATE custinfo SET cust_name = NEW.crmacct_name
      WHERE ((cust_id=NEW.crmacct_cust_id)
        AND  (cust_name!=NEW.crmacct_name));
      IF (_gotpriv) THEN
        PERFORM revokePriv(getEffectiveXtUser(), 'MaintainCustomerMasters');
      END IF;
    END IF;

    IF (NEW.crmacct_emp_id IS NOT NULL) THEN
      _gotpriv := grantPriv(getEffectiveXtUser(), 'MaintainEmployees');
      UPDATE emp SET emp_code = NEW.crmacct_number
      WHERE ((emp_id=NEW.crmacct_emp_id)
        AND  (emp_code!=NEW.crmacct_number));
      UPDATE emp SET emp_name = NEW.crmacct_name
      WHERE ((emp_id=NEW.crmacct_emp_id)
        AND  (emp_name!=NEW.crmacct_name));
      IF (_gotpriv) THEN
        PERFORM revokePriv(getEffectiveXtUser(), 'MaintainEmployees');
      END IF;
    END IF;

    IF (NEW.crmacct_prospect_id IS NOT NULL) THEN
      _gotpriv := grantPriv(getEffectiveXtUser(), 'MaintainProspectMasters');
      UPDATE prospect SET prospect_number = NEW.crmacct_number
      WHERE ((prospect_id=NEW.crmacct_prospect_id)
        AND  (prospect_number!=NEW.crmacct_number));
      UPDATE prospect SET prospect_name = NEW.crmacct_name
      WHERE ((prospect_id=NEW.crmacct_prospect_id)
        AND  (prospect_name!=NEW.crmacct_name));
      IF (_gotpriv) THEN
        PERFORM revokePriv(getEffectiveXtUser(), 'MaintainProspectMasters');
      END IF;
    END IF;

    IF (NEW.crmacct_salesrep_id IS NOT NULL) THEN
      _gotpriv := grantPriv(getEffectiveXtUser(), 'MaintainSalesReps');
      UPDATE salesrep SET salesrep_number = NEW.crmacct_number
      WHERE ((salesrep_id=NEW.crmacct_salesrep_id)
        AND  (salesrep_number!=NEW.crmacct_number));
      UPDATE salesrep SET salesrep_name = NEW.crmacct_name
      WHERE ((salesrep_id=NEW.crmacct_salesrep_id)
        AND  (salesrep_name!=NEW.crmacct_name));
      IF (_gotpriv) THEN
        PERFORM revokePriv(getEffectiveXtUser(), 'MaintainSalesReps');
      END IF;
    END IF;

    IF (NEW.crmacct_taxauth_id IS NOT NULL) THEN
      _gotpriv := grantPriv(getEffectiveXtUser(), 'MaintainTaxAuthorities');
      UPDATE taxauth SET taxauth_code = NEW.crmacct_number
      WHERE ((taxauth_id=NEW.crmacct_taxauth_id)
        AND  (taxauth_code!=NEW.crmacct_number));
      UPDATE taxauth SET taxauth_name = NEW.crmacct_name
      WHERE ((taxauth_id=NEW.crmacct_taxauth_id)
        AND  (taxauth_name!=NEW.crmacct_name));
      IF (_gotpriv) THEN
        PERFORM revokePriv(getEffectiveXtUser(), 'MaintainTaxAuthorities');
      END IF;
    END IF;

    IF (NEW.crmacct_vend_id IS NOT NULL) THEN
      _gotpriv := grantPriv(getEffectiveXtUser(), 'MaintainVendors');
      UPDATE vendinfo SET vend_number = NEW.crmacct_number
      WHERE ((vend_id=NEW.crmacct_vend_id)
        AND  (vend_number!=NEW.crmacct_number));
      UPDATE vendinfo SET vend_name = NEW.crmacct_name
      WHERE ((vend_id=NEW.crmacct_vend_id)
        AND  (vend_name!=NEW.crmacct_name));
      IF (_gotpriv) THEN
        PERFORM revokePriv(getEffectiveXtUser(), 'MaintainVendors');
      END IF;
    END IF;

    -- Link Primary and Secondary Contacts to this Account if they are not already
    IF (NEW.crmacct_cntct_id_1 IS NOT NULL) THEN
      _gotpriv := grantPriv(getEffectiveXtUser(), 'MaintainAllContacts');
      UPDATE cntct SET cntct_crmacct_id = NEW.crmacct_id
       WHERE cntct_id=NEW.crmacct_cntct_id_1;
      IF (_gotpriv) THEN
        PERFORM revokePriv(getEffectiveXtUser(), 'MaintainAllContacts');
      END IF;
    END IF;

    IF (NEW.crmacct_cntct_id_2 IS NOT NULL) THEN
      _gotpriv := grantPriv(getEffectiveXtUser(), 'MaintainAllContacts');
      UPDATE cntct SET cntct_crmacct_id = NEW.crmacct_id
       WHERE cntct_id=NEW.crmacct_cntct_id_2;
      IF (_gotpriv) THEN
        PERFORM revokePriv(getEffectiveXtUser(), 'MaintainAllContacts');
      END IF;
    END IF;

    -- cannot have fkey references to system catalogs so enforce them here
    IF (NEW.crmacct_usr_username IS NOT NULL) THEN
      IF (NOT EXISTS(SELECT usr_username
                       FROM usr
                      WHERE usr_username=NEW.crmacct_usr_username)) THEN
        RAISE EXCEPTION 'User % does not exist so this CRM Account Number is invalid.',
                        NEW.crmacct_usr_username;
      END IF;
      IF (TG_OP = 'UPDATE') THEN
        -- reminder: this evaluates to false if either is NULL
        IF (NEW.crmacct_usr_username != OLD.crmacct_usr_username) THEN
          RAISE EXCEPTION 'Cannot change the user name for %',
                          OLD.crmacct_usr_username;
        END IF;
      END IF;
      UPDATE usrpref SET usrpref_value = NEW.crmacct_name
      WHERE ((usrpref_username=NEW.crmacct_usr_username)
        AND  (usrpref_name='propername')
        AND  (usrpref_value!=NEW.crmacct_name));
    END IF;

  ELSIF (TG_OP = 'DELETE') THEN
    IF (OLD.crmacct_cust_id IS NOT NULL) THEN
      RAISE EXCEPTION 'Cannot delete CRM Account because it is a Customer [xtuple: deleteCrmAccount, -1]';
    END IF;

    IF (OLD.crmacct_emp_id IS NOT NULL) THEN
      RAISE EXCEPTION 'Cannot delete CRM Account because it is an Employee [xtuple: deleteCrmAccount, -7]';
    END IF;

    IF (OLD.crmacct_prospect_id IS NOT NULL) THEN
      RAISE EXCEPTION 'Cannot delete CRM Account because it is a Prospect [xtuple: deleteCrmAccount, -3]';
    END IF;

    DELETE FROM salesrep WHERE salesrep_id  = OLD.crmacct_salesrep_id;
    IF (OLD.crmacct_salesrep_id IS NOT NULL) THEN
      RAISE EXCEPTION 'Cannot delete CRM Account because it is a Sales Rep [xtuple: deleteCrmAccount, -6]';
    END IF;

    IF (OLD.crmacct_taxauth_id IS NOT NULL) THEN
      RAISE EXCEPTION 'Cannot delete CRM Account because it is a Tax Authority [xtuple: deleteCrmAccount, -5]';
    END IF;

    IF (EXISTS(SELECT usename
                 FROM pg_user
                WHERE usename=OLD.crmacct_usr_username)) THEN
      RAISE EXCEPTION 'Cannot delete CRM Account because it is a User [xtuple: deleteCrmAccount, -8]';
    END IF;

    IF (OLD.crmacct_vend_id IS NOT NULL) THEN
      RAISE EXCEPTION 'Cannot delete CRM Account because it is a Vendor [xtuple: deleteCrmAccount, -2]';
    END IF;

    DELETE FROM imageass
     WHERE (imageass_source_id=OLD.crmacct_id) AND (imageass_source='CRMA');
    DELETE FROM url
     WHERE (url_source_id=OLD.crmacct_id)      AND (url_source='CRMA');

  END IF;

  SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
   WHERE (cmnttype_name='ChangeLog');
  IF (_cmnttypeid IS NOT NULL) THEN
    IF (TG_OP = 'INSERT') THEN
      PERFORM postComment(_cmnttypeid, 'CRMA', NEW.crmacct_id,
                          ('Created by ' || getEffectiveXtUser()));

    ELSIF (TG_OP = 'DELETE') THEN
      PERFORM postComment(_cmnttypeid, 'CRMA', OLD.crmacct_id,
                          'Deleted "' || OLD.crmacct_number || '"');
    END IF;
  END IF;

  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._crmacctaftertrigger() OWNER TO admin;

--
-- Name: _crmacctbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _crmacctbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _count        INTEGER;
BEGIN
  -- disallow reusing crmacct_numbers
  IF (TG_OP IN ('INSERT', 'UPDATE')) THEN
    IF (TG_OP = 'INSERT' AND fetchMetricText('CRMAccountNumberGeneration') IN ('A','O')) THEN
      PERFORM clearNumberIssue('CRMAccountNumber', NEW.crmacct_number);
    END IF;

    NEW.crmacct_usr_username := LOWER(TRIM(NEW.crmacct_usr_username));
    IF (NEW.crmacct_usr_username = '') THEN
      NEW.crmacct_usr_username = NULL;
    END IF;

    NEW.crmacct_owner_username := LOWER(TRIM(NEW.crmacct_owner_username));
    IF (COALESCE(NEW.crmacct_owner_username, '') = '') THEN
      NEW.crmacct_owner_username = getEffectiveXtUser();
    END IF;

    IF (NEW.crmacct_competitor_id < 0) THEN
      NEW.crmacct_competitor_id := NULL;
    END IF;
    IF (NEW.crmacct_partner_id < 0) THEN
      NEW.crmacct_partner_id := NULL;
    END IF;

    NEW.crmacct_number = UPPER(NEW.crmacct_number);

    IF (TG_OP = 'UPDATE') THEN
      -- TODO: why not ALTER USER OLD.crmacct_number RENAME TO LOWER(NEW.crmacct_number)?
      IF (NEW.crmacct_number != UPPER(OLD.crmacct_number) AND
          NEW.crmacct_usr_username IS NOT NULL            AND
          UPPER(NEW.crmacct_usr_username) != NEW.crmacct_number) THEN
        RAISE EXCEPTION 'The CRM Account % is associated with a system User so the number cannot be changed.',
                        NEW.crmacct_number;
      END IF;
    END IF;

  ELSIF (TG_OP = 'DELETE') THEN
    UPDATE cntct SET cntct_crmacct_id = NULL
     WHERE cntct_crmacct_id = OLD.crmacct_id;

    DELETE FROM docass WHERE docass_source_id = OLD.crmacct_id AND docass_source_type = 'CRMA';
    DELETE FROM docass WHERE docass_target_id = OLD.crmacct_id AND docass_target_type = 'CRMA';

    GET DIAGNOSTICS _count = ROW_COUNT;
    RAISE DEBUG 'updated % contacts', _count;

    RETURN OLD;

  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._crmacctbeforetrigger() OWNER TO admin;

--
-- Name: _custaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _custaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;
  _whsId      INTEGER := -1;

BEGIN

  IF (TG_OP = 'INSERT') THEN
    -- http://www.postgresql.org/docs/current/static/plpgsql-control-structures.html#PLPGSQL-UPSERT-EXAMPLE
    LOOP
      UPDATE crmacct SET crmacct_cust_id=NEW.cust_id,
                         crmacct_name=NEW.cust_name,
                         crmacct_prospect_id=NULL
      WHERE crmacct_number=NEW.cust_number;
      IF (FOUND) THEN
        DELETE FROM prospect WHERE prospect_id=NEW.cust_id;
        EXIT;
      END IF;
      BEGIN
        INSERT INTO crmacct(crmacct_number,  crmacct_name,    crmacct_active,
                            crmacct_type,    crmacct_cust_id, crmacct_cntct_id_1,
                            crmacct_cntct_id_2
                  ) VALUES (NEW.cust_number, NEW.cust_name,   NEW.cust_active,
                            'O',             NEW.cust_id,     NEW.cust_cntct_id,
                            NEW.cust_corrcntct_id);
        EXIT;
      EXCEPTION WHEN unique_violation THEN
            -- do nothing, and loop to try the UPDATE again
      END;
    END LOOP;

    PERFORM updateCharAssignment('C', NEW.cust_id, char_id, charass_value)
       FROM custtype
       JOIN charass ON (custtype_id=charass_target_id AND charass_target_type='CT')
       JOIN char ON (charass_char_id=char_id)
       WHERE ((custtype_id=NEW.cust_custtype_id)
          AND (custtype_char)
          AND (charass_default));

  ELSIF (TG_OP = 'UPDATE') THEN
    UPDATE crmacct SET crmacct_number = NEW.cust_number
    WHERE ((crmacct_cust_id=NEW.cust_id)
      AND  (crmacct_number!=NEW.cust_number));

    UPDATE crmacct SET crmacct_name = NEW.cust_name
    WHERE ((crmacct_cust_id=NEW.cust_id)
      AND  (crmacct_name!=NEW.cust_name));
  END IF;

  IF (TG_OP = 'INSERT') THEN
  -- find the warehouse for which to create evntlog entries
    SELECT usrpref_value  INTO _whsId
    FROM usrpref
    WHERE usrpref_username = getEffectiveXtUser()
      AND usrpref_name = 'PreferredWarehouse';

    INSERT INTO evntlog (evntlog_evnttime, evntlog_username,
                         evntlog_evnttype_id, evntlog_ordtype,
                         evntlog_ord_id, evntlog_warehous_id, evntlog_number)
    SELECT DISTINCT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
                    'C', NEW.cust_id, _whsId, NEW.cust_number
    FROM evntnot, evnttype
    WHERE ((evntnot_evnttype_id=evnttype_id)
      AND  (evnttype_name='NewCustomer'));
  END IF;

  IF (fetchMetricBool('CustomerChangeLog')) THEN
    SELECT cmnttype_id INTO _cmnttypeid
      FROM cmnttype
     WHERE (cmnttype_name='ChangeLog');

    IF (_cmnttypeid IS NOT NULL) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'C', NEW.cust_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN

        IF (OLD.cust_number <> NEW.cust_number) THEN
          PERFORM postComment( _cmnttypeid, 'C', NEW.cust_id,
                              ('Number changed from "' || OLD.cust_number ||
                               '" to "' || NEW.cust_number || '"') );
        END IF;

        IF (OLD.cust_name <> NEW.cust_name) THEN
          PERFORM postComment( _cmnttypeid, 'C', NEW.cust_id,
                              ('Name changed from "' || OLD.cust_name ||
                               '" to "' || NEW.cust_name || '"') );
        END IF;

        IF (OLD.cust_active <> NEW.cust_active) THEN
          PERFORM postComment(_cmnttypeid, 'C', NEW.cust_id,
                              CASE WHEN NEW.cust_active THEN 'Activated'
                                   ELSE 'Deactivated' END);
        END IF;

        IF (OLD.cust_discntprcnt <> NEW.cust_discntprcnt) THEN
          PERFORM postComment(_cmnttypeid, 'C', NEW.cust_id,
                              ('Discount changed from "' ||
                               formatprcnt(OLD.cust_discntprcnt) || '%" to "' ||
                               formatprcnt(NEW.cust_discntprcnt) || '%"') );
        END IF;

        IF (OLD.cust_creditlmt <> NEW.cust_creditlmt) THEN
          PERFORM postComment(_cmnttypeid, 'C', NEW.cust_id,
                              ('Credit Limit changed from ' || formatMoney(OLD.cust_creditlmt) ||
                               ' to ' || formatMoney(NEW.cust_creditlmt)));
        END IF;

        IF (OLD.cust_creditstatus <> NEW.cust_creditstatus) THEN
          PERFORM postComment(_cmnttypeid, 'C', NEW.cust_id,
                              ('Credit Status Changed from "' ||
                               CASE OLD.cust_creditstatus
                                    WHEN 'G' THEN 'In Good Standing'
                                    WHEN 'W' THEN 'Credit Warning'
                                    WHEN 'H' THEN 'Credit Hold'
                                    ELSE 'Unknown/Error'
                               END || '" to "' ||
                               CASE NEW.cust_creditstatus
                                    WHEN 'G' THEN 'In Good Standing'
                                    WHEN 'W' THEN 'Credit Warning'
                                    WHEN 'H' THEN 'Credit Hold'
                                    ELSE 'Unknown/Error'
                               END || '"') );
        END IF;

        IF (OLD.cust_custtype_id <> NEW.cust_custtype_id) THEN
          PERFORM postComment(_cmnttypeid, 'C', NEW.cust_id,
                              ('Customer type changed from "' ||
                               (SELECT custtype_code FROM custtype
                                 WHERE custtype_id = OLD.cust_custtype_id) || '" to "' ||
                               (SELECT custtype_code FROM custtype
                                 WHERE custtype_id = NEW.cust_custtype_id) || '"') );
        END IF;

        IF (COALESCE(OLD.cust_gracedays,-1) <> COALESCE(NEW.cust_gracedays,-1)) THEN
          PERFORM postComment(_cmnttypeid, 'C', NEW.cust_id,
                              ('Grace Days changed from "' ||
                               COALESCE(TEXT(OLD.cust_gracedays), 'Default') ||
                               '" to "' ||
                               COALESCE(TEXT(NEW.cust_gracedays), 'Default') || '"'));
        END IF;

        IF (OLD.cust_terms_id <> NEW.cust_terms_id) THEN
          PERFORM postComment(_cmnttypeid, 'C', NEW.cust_id,
                              ('Terms changed from "' ||
                               (SELECT terms_code FROM terms
                                 WHERE terms_id = OLD.cust_terms_id) || '" to "' ||
                               (SELECT terms_code FROM terms
                                 WHERE terms_id = NEW.cust_terms_id) || '"'));
        END IF;

      END IF;
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._custaftertrigger() OWNER TO admin;

--
-- Name: _custinfoafterdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _custinfoafterdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  -- handle transitory state when converting customer to prospect
  IF EXISTS(SELECT quhead_id
              FROM quhead
             WHERE (quhead_cust_id=OLD.cust_id) AND
     NOT EXISTS(SELECT prospect_id
                  FROM prospect
                 WHERE prospect_id=OLD.cust_id)) THEN
    RAISE EXCEPTION '[xtuple: deleteCustomer, -8]';
  END IF;

  IF EXISTS(SELECT invchead_id
              FROM invchead
             WHERE (invchead_cust_id=OLD.cust_id)) THEN
    RAISE EXCEPTION '[xtuple: deleteCustomer, -7]';
  END IF;
  -- end TODO

  IF EXISTS(SELECT checkhead_recip_id
              FROM checkhead
             WHERE ((checkhead_recip_id=OLD.cust_id)
               AND  (checkhead_recip_type='C'))) THEN
    RAISE EXCEPTION '[xtuple: deleteCustomer, -6]';
  END IF;

  DELETE FROM taxreg
   WHERE ((taxreg_rel_type='C')
     AND  (taxreg_rel_id=OLD.cust_id));

  DELETE FROM ipsass
   WHERE (ipsass_cust_id=OLD.cust_id);

  DELETE FROM docass WHERE docass_source_id = OLD.cust_id AND docass_source_type = 'C';
  DELETE FROM docass WHERE docass_target_id = OLD.cust_id AND docass_target_type = 'C';

  IF (fetchMetricBool('CustomerChangeLog')) THEN
    PERFORM postComment(cmnttype_id, 'C', OLD.cust_id,
                        ('Deleted "' || OLD.cust_number || '"'))
      FROM cmnttype
     WHERE (cmnttype_name='ChangeLog');
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._custinfoafterdeletetrigger() OWNER TO admin;

--
-- Name: _custinfobeforedeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _custinfobeforedeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF NOT (checkPrivilege('MaintainCustomerMasters')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Customers.';
  END IF;

  UPDATE crmacct SET crmacct_cust_id = NULL
   WHERE crmacct_cust_id = OLD.cust_id;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._custinfobeforedeletetrigger() OWNER TO admin;

--
-- Name: _custtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _custtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF NOT (checkPrivilege('MaintainCustomerMasters') OR
          checkPrivilege('PostMiscInvoices')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Customers.';
  END IF;

  IF (NEW.cust_number IS NULL) THEN
        RAISE EXCEPTION 'You must supply a valid Customer Number.';
  END IF;

  IF (LENGTH(COALESCE(NEW.cust_name,''))=0) THEN
        RAISE EXCEPTION 'You must supply a valid Customer Name.';
  END IF;

  IF (NEW.cust_custtype_id IS NULL) THEN
        RAISE EXCEPTION 'You must supply a valid Customer Type ID.';
  END IF;

  IF (NEW.cust_salesrep_id IS NULL) THEN
        RAISE EXCEPTION 'You must supply a valid Sales Rep ID.';
  END IF;

  IF (NEW.cust_terms_id IS NULL) THEN
        RAISE EXCEPTION 'You must supply a valid Terms Code ID.';
  END IF;

  IF (TG_OP = 'INSERT' AND fetchMetricText('CRMAccountNumberGeneration') IN ('A','O')) THEN
    PERFORM clearNumberIssue('CRMAccountNumber', NEW.cust_number);
  END IF;

  NEW.cust_number := UPPER(NEW.cust_number);

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._custtrigger() OWNER TO admin;

--
-- Name: _custtypeafterdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _custtypeafterdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (SELECT fetchMetricValue('DefaultCustType') = OLD.custtype_id) THEN
    RAISE EXCEPTION 'Cannot delete the default Customer Type [xtuple: custtype, -1, %]',
                    OLD.custtype_code;
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._custtypeafterdeletetrigger() OWNER TO admin;

--
-- Name: _custtypetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _custtypetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check      BOOLEAN;
  _code       TEXT;

BEGIN

--  Checks
  IF (TG_OP IN ('INSERT','UPDATE')) THEN

    IF (LENGTH(COALESCE(NEW.custtype_code, ''))=0) THEN
      RAISE EXCEPTION 'You must supply a valid Customer Type Code.';
    END IF;

    SELECT custtype_code INTO _code
    FROM custtype
    WHERE ( (UPPER(custtype_code)=UPPER(NEW.custtype_code))
      AND (custtype_id<>NEW.custtype_id) );
    IF (FOUND) THEN
      RAISE EXCEPTION 'The Customer Type Code entered cannot be used as it is in use.';
    END IF;

  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._custtypetrigger() OWNER TO admin;

--
-- Name: _docasstrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _docasstrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (NEW.docass_source_type = 'INCDT') THEN
    UPDATE incdt SET incdt_updated = now() WHERE incdt_id = NEW.docass_source_id;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._docasstrigger() OWNER TO admin;

--
-- Name: _empafterdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _empafterdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (fetchMetricBool('EmployeeChangeLog')) THEN
    PERFORM postComment(cmnttype_id, 'EMP', OLD.emp_id,
                        ('Deleted "' || OLD.emp_code || '"'))
      FROM cmnttype
     WHERE (cmnttype_name='ChangeLog');
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._empafterdeletetrigger() OWNER TO admin;

--
-- Name: _empaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _empaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid     INTEGER;
  _newcrmacctname TEXT;

BEGIN

  IF (TG_OP = 'INSERT') THEN
    -- http://www.postgresql.org/docs/current/static/plpgsql-control-structures.html#PLPGSQL-UPSERT-EXAMPLE
    LOOP
      UPDATE crmacct SET crmacct_emp_id=NEW.emp_id,
                         crmacct_name=NEW.emp_name
       WHERE crmacct_number=NEW.emp_code;
      IF (FOUND) THEN
        EXIT;
      END IF;
      BEGIN
        INSERT INTO crmacct(crmacct_number,  crmacct_name,    crmacct_active,
                            crmacct_type,    crmacct_emp_id,  crmacct_cntct_id_1
                  ) VALUES (NEW.emp_code,    NEW.emp_name,    NEW.emp_active, 
                            'I',             NEW.emp_id,      NEW.emp_cntct_id);
        EXIT;
      EXCEPTION WHEN unique_violation THEN
            -- do nothing, and loop to try the UPDATE again
      END;
    END LOOP;

    /* TODO: default characteristic assignments based on empgrp? */

  ELSIF (TG_OP = 'UPDATE') THEN
    UPDATE crmacct SET crmacct_number = NEW.emp_code
    WHERE ((crmacct_emp_id=NEW.emp_id)
      AND  (crmacct_number!=NEW.emp_code));

    UPDATE crmacct SET crmacct_name = NEW.emp_name
    WHERE ((crmacct_emp_id=NEW.emp_id)
      AND  (crmacct_name!=NEW.emp_name));
  END IF;

  IF (fetchMetricBool('EmployeeChangeLog')) THEN
    SELECT cmnttype_id INTO _cmnttypeid
      FROM cmnttype
     WHERE (cmnttype_name='ChangeLog');

    IF (_cmnttypeid IS NOT NULL) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'EMP', NEW.emp_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN

        IF (OLD.emp_number <> NEW.emp_number) THEN
          PERFORM postComment(_cmnttypeid, 'EMP', NEW.emp_id,
                              ('Number Changed from "' || OLD.emp_number ||
                               '" to "' || NEW.emp_number || '"'));
        END IF;

        IF (OLD.emp_code <> NEW.emp_code) THEN
          PERFORM postComment(_cmnttypeid, 'EMP', NEW.emp_id,
                              ('Code Changed from "' || OLD.emp_code ||
                               '" to "' || NEW.emp_code || '"'));
        END IF;

        IF (OLD.emp_active <> NEW.emp_active) THEN
          PERFORM postComment(_cmnttypeid, 'EMP', NEW.emp_id,
                              CASE WHEN NEW.emp_active THEN 'Activated'
                                   ELSE 'Deactivated' END);
        END IF;

        IF (COALESCE(OLD.emp_dept_id, -1) <> COALESCE(NEW.emp_dept_id, -1)) THEN
          PERFORM postComment(_cmnttypeid, 'EMP', NEW.emp_id,
                              ('Department Changed from "' ||
                               COALESCE((SELECT dept_number FROM dept
                                          WHERE dept_id=OLD.emp_dept_id), '')
                               || '" to "' ||
                               COALESCE((SELECT dept_number FROM dept
                                          WHERE dept_id=NEW.emp_dept_id), '') || '"'));
        END IF;

        IF (COALESCE(OLD.emp_shift_id, -1) <> COALESCE(NEW.emp_shift_id, -1)) THEN
          PERFORM postComment(_cmnttypeid, 'EMP', NEW.emp_id,
                              ('Shift Changed from "' ||
                               COALESCE((SELECT shift_number FROM shift
                                          WHERE shift_id=OLD.emp_shift_id), '')
                               || '" to "' ||
                               COALESCE((SELECT shift_number FROM shift
                                          WHERE shift_id=NEW.emp_shift_id), '') || '"'));
        END IF;

      END IF;
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._empaftertrigger() OWNER TO admin;

--
-- Name: _empbeforedeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _empbeforedeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF NOT (checkPrivilege('MaintainEmployees')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Employees.';
  END IF;

  UPDATE crmacct SET crmacct_emp_id = NULL
   WHERE crmacct_emp_id = OLD.emp_id;

  UPDATE salesrep SET salesrep_emp_id = NULL
   WHERE salesrep_emp_id = OLD.emp_id;

  DELETE FROM docass WHERE docass_source_id = OLD.emp_id AND docass_source_type = 'EMP';
  DELETE FROM docass WHERE docass_target_id = OLD.emp_id AND docass_target_type = 'EMP';

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._empbeforedeletetrigger() OWNER TO admin;

--
-- Name: _empbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _empbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  IF NOT (checkPrivilege('MaintainEmployees')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Employees.';
  END IF;

  IF (NEW.emp_code IS NULL) THEN
    RAISE EXCEPTION 'You must supply a valid Employee Code.';
  END IF;

  IF (NEW.emp_number IS NULL) THEN
    RAISE EXCEPTION 'You must supply a valid Employee Number.';
  END IF;

  IF (NEW.emp_id = NEW.emp_mgr_emp_id) THEN
    RAISE EXCEPTION 'An Employee may not be his or her own Manager.';
  END IF;

  -- ERROR:  cannot use column references in default expression
  IF (NEW.emp_name IS NULL) THEN
    NEW.emp_name = COALESCE(formatCntctName(NEW.emp_cntct_id), NEW.emp_number);
  END IF;

  IF (TG_OP = 'INSERT' AND fetchMetricText('CRMAccountNumberGeneration') IN ('A','O')) THEN
    PERFORM clearNumberIssue('CRMAccountNumber', NEW.emp_number);
  END IF;

  NEW.emp_code := UPPER(NEW.emp_code);

  -- deprecated column emp_username
  IF (TG_OP = 'UPDATE' AND
      LOWER(NEW.emp_username) != LOWER(NEW.emp_code) AND
      EXISTS(SELECT 1
               FROM crmacct
              WHERE crmacct_emp_id = NEW.emp_id
                AND crmacct_usr_username IS NOT NULL)) THEN
    NEW.emp_username = LOWER(NEW.emp_code);
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._empbeforetrigger() OWNER TO admin;

--
-- Name: _gltransaltertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _gltransaltertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _externalCompany      BOOLEAN := false;
  _updated BOOLEAN := false;
BEGIN
  IF(TG_OP='DELETE') THEN
    RAISE EXCEPTION 'You may not delete G/L Transactions once they have been created.';
  ELSIF (TG_OP = 'UPDATE') THEN
    SELECT company_external INTO _externalCompany
    FROM company JOIN accnt ON (company_number=accnt_company)
    WHERE (accnt_id=NEW.gltrans_accnt_id);
    IF (_externalCompany) THEN
      RAISE EXCEPTION 'Transactions are not allowed for G/L Accounts with External Company segments.';
    END IF;

    IF(OLD.gltrans_id != NEW.gltrans_id) THEN
      _updated := true;
    ELSIF(OLD.gltrans_date != NEW.gltrans_date) THEN
      _updated := true;
    ELSIF(OLD.gltrans_accnt_id != NEW.gltrans_accnt_id) THEN
      _updated := true;
    ELSIF(OLD.gltrans_amount != NEW.gltrans_amount) THEN
      _updated := true;
    ELSIF(OLD.gltrans_username != NEW.gltrans_username) THEN
      _updated := true;
    ELSIF( (OLD.gltrans_sequence IS NULL     AND NEW.gltrans_sequence IS NOT NULL)
        OR (OLD.gltrans_sequence IS NOT NULL AND NEW.gltrans_sequence IS NULL)
        OR (COALESCE(OLD.gltrans_sequence,0) != COALESCE(NEW.gltrans_sequence,0)) ) THEN
      _updated := true;
    ELSIF( (OLD.gltrans_created IS NULL     AND NEW.gltrans_created IS NOT NULL)
        OR (OLD.gltrans_created IS NOT NULL AND NEW.gltrans_created IS NULL)
        OR (COALESCE(OLD.gltrans_created,now()) != COALESCE(NEW.gltrans_created,now())) ) THEN
      _updated := true;
    ELSIF( (OLD.gltrans_source IS NULL     AND NEW.gltrans_source IS NOT NULL)
        OR (OLD.gltrans_source IS NOT NULL AND NEW.gltrans_source IS NULL)
        OR (COALESCE(OLD.gltrans_source,'') != COALESCE(NEW.gltrans_source,'')) ) THEN
      _updated := true;
    ELSIF( (OLD.gltrans_docnumber IS NULL     AND NEW.gltrans_docnumber IS NOT NULL)
        OR (OLD.gltrans_docnumber IS NOT NULL AND NEW.gltrans_docnumber IS NULL)
        OR (COALESCE(OLD.gltrans_docnumber,'') != COALESCE(NEW.gltrans_docnumber,'')) ) THEN
      _updated := true;
    ELSIF( (OLD.gltrans_doctype IS NULL     AND NEW.gltrans_doctype IS NOT NULL)
        OR (OLD.gltrans_doctype IS NOT NULL AND NEW.gltrans_doctype IS NULL)
        OR (COALESCE(OLD.gltrans_doctype,'') != COALESCE(NEW.gltrans_doctype,'')) ) THEN
      _updated := true;
    END IF;

    IF(_updated) THEN
      RAISE EXCEPTION 'You may not alter some G/L Transaction fields once they have been created.';
    END IF;
  ELSE
    RAISE EXCEPTION 'trigger for gltrans table called in unexpected state.';
  END IF;
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._gltransaltertrigger() OWNER TO admin;

--
-- Name: _gltransinserttrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _gltransinserttrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _reqNotes BOOLEAN;
  _externalCompany      BOOLEAN := false;
BEGIN
  -- Checks
  -- Start with privileges
  IF ((NEW.gltrans_doctype='JE') AND (NOT checkPrivilege('PostJournalEntries'))) THEN
      RAISE EXCEPTION 'You do not have privileges to create a Journal Entry.';
  END IF;

  SELECT company_external INTO _externalCompany
  FROM company JOIN accnt ON (company_number=accnt_company)
  WHERE (accnt_id=NEW.gltrans_accnt_id);
  IF (_externalCompany) THEN
    RAISE EXCEPTION 'Transactions are not allowed for G/L Accounts with External Company segments.';
  END IF;
  -- RAISE NOTICE '_gltransInsertTrigger(): company_external = %', _externalCompany;

  SELECT metric_value='t'
    INTO _reqNotes
    FROM metric
   WHERE(metric_name='MandatoryGLEntryNotes');
  IF (_reqNotes IS NULL) THEN
    _reqNotes := false;
  END IF;
  IF ((NEW.gltrans_doctype='JE') AND _reqNotes AND (TRIM(BOTH FROM COALESCE(NEW.gltrans_notes,''))='')) THEN
      RAISE EXCEPTION 'Notes are required for Journal Entries.';
  END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._gltransinserttrigger() OWNER TO admin;

--
-- Name: _grpprivtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _grpprivtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check BOOLEAN;
  _returnVal INTEGER;
BEGIN
  -- This looks like a candidate for a foreign key but isn't.
  -- fkeys don't work if the foreign key value resides in a child of the 
  -- table and not the table itself.
  IF ((TG_OP = 'UPDATE' OR TG_OP = 'INSERT') AND
      (NOT EXISTS(SELECT priv_id
                  FROM priv
                  WHERE (priv_id=NEW.grppriv_priv_id)))) THEN
    RAISE EXCEPTION 'Privilege id % does not exist or is part of a disabled package.',
                NEW.grppriv_priv_id;
    RETURN OLD;

  ELSIF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._grpprivtrigger() OWNER TO admin;

--
-- Name: _imageasstrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _imageasstrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (NEW.imageass_source = 'INCDT') THEN
    UPDATE incdt SET incdt_updated = now() WHERE incdt_id = NEW.imageass_source_id;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._imageasstrigger() OWNER TO admin;

--
-- Name: _incdtbeforedeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _incdtbeforedeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _recurid     INTEGER;
  _newparentid INTEGER;
BEGIN
  IF (TG_OP = 'DELETE') THEN
    SELECT recur_id INTO _recurid
      FROM recur
     WHERE ((recur_parent_id=OLD.incdt_id)
        AND (recur_parent_type='INCDT'));

     IF (_recurid IS NOT NULL) THEN
       SELECT MIN(incdt_id) INTO _newparentid
         FROM incdt
        WHERE ((incdt_recurring_incdt_id=OLD.inctd_id)
           AND (incdt_id!=OLD.incdt_id));

      -- client is responsible for warning about deleting a recurring incdt
      IF (_newparentid IS NULL) THEN
        DELETE FROM recur WHERE recur_id=_recurid;
      ELSE
        UPDATE recur SET recur_parent_id=_newparentid
         WHERE recur_id=_recurid;
      END IF;
    END IF;

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._incdtbeforedeletetrigger() OWNER TO admin;

--
-- Name: _incdtbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _incdtbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _rec          RECORD;
  _check        BOOLEAN;
  _crmacct      INTEGER;

BEGIN

  IF(TG_OP = 'DELETE') THEN
    _rec := OLD;
  ELSE
    _rec := NEW;
  END IF;

  -- Set the incident number if blank
  IF (TG_OP = 'INSERT') THEN
    IF (NEW.incdt_number IS NULL) THEN
      SELECT fetchIncidentNumber() INTO NEW.incdt_number;
    END IF;

    --- clear the number from the issue cache
    PERFORM clearNumberIssue('IncidentNumber', NEW.incdt_number);
  END IF;

  -- Description is required
  IF (LENGTH(COALESCE(NEW.incdt_summary,''))=0) THEN
    RAISE EXCEPTION 'You must supply a valid Incident Description.';
  END IF;
  
  -- CRM Account is required
  IF (NEW.incdt_crmacct_id IS NULL) THEN
    RAISE EXCEPTION 'You must supply a valid CRM Account.';
  END IF;

  -- Contact is required
  IF (NEW.incdt_cntct_id IS NULL) THEN
    RAISE EXCEPTION 'You must supply a valid Contact.';
  END IF;

  NEW.incdt_updated := now();

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._incdtbeforetrigger() OWNER TO admin;

--
-- Name: _incdttrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _incdttrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _r		RECORD;
  _counter	INTEGER :=  0;
  _whsId	INTEGER := -1;
  _evntType	TEXT;
  _cmnttypeid   INTEGER := -1;
  _cmntid       INTEGER := -1;
BEGIN

  SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='Notes to Comment');
  IF NOT FOUND OR _cmnttypeid IS NULL THEN
    _cmnttypeid := -1;
  END IF;

  IF (TG_OP = 'DELETE') THEN
--  This should never happen
    RETURN OLD;
  ELSIF (TG_OP = 'INSERT') THEN
    INSERT INTO incdthist
	  (incdthist_incdt_id,
	   incdthist_change, incdthist_target_id,
	   incdthist_descrip)
    VALUES(NEW.incdt_id,
	   'N', NULL,
	   'Incident Added');

    _evntType = 'NewIncident';

    IF (_cmnttypeid <> -1 AND COALESCE(NEW.incdt_descrip, '') <> '') THEN
      PERFORM postComment(_cmnttypeid, 'INCDT', NEW.incdt_id, NEW.incdt_descrip);
    END IF;
  ELSIF (TG_OP = 'UPDATE') THEN
    _evntType = 'UpdatedIncident';

    IF (COALESCE(NEW.incdt_cntct_id,-1) <> COALESCE(OLD.incdt_cntct_id,-1)) THEN
      INSERT INTO incdthist
	    (incdthist_incdt_id,
	     incdthist_change, incdthist_target_id,
	     incdthist_descrip)
      VALUES(NEW.incdt_id,
	     'C', NEW.incdt_cntct_id,
	     ('Contact Changed: "' ||
	       COALESCE((SELECT cntct_first_name || ' ' || cntct_last_name
			   FROM cntct
			  WHERE (cntct_id=OLD.incdt_cntct_id)), '')
	      || '" -> "' ||
	       COALESCE((SELECT cntct_first_name || ' ' || cntct_last_name
			   FROM cntct
			  WHERE (cntct_id=NEW.incdt_cntct_id)), '')
	      || '"') );
    END IF;

    IF (COALESCE(NEW.incdt_summary,'') <> COALESCE(OLD.incdt_summary,'')) THEN
      INSERT INTO incdthist
	    (incdthist_incdt_id,
	     incdthist_descrip)
      VALUES(NEW.incdt_id,
	     ('Summary Updated: "' ||
	       COALESCE(OLD.incdt_summary, '') ||
	      '" -> "' ||
	       COALESCE(NEW.incdt_summary, '') ||
	      '"') );
    END IF;

    IF (COALESCE(NEW.incdt_descrip,'') <> COALESCE(OLD.incdt_descrip,'')) THEN
      INSERT INTO incdthist
	    (incdthist_incdt_id,
	     incdthist_descrip)
      VALUES(NEW.incdt_id,
	     ('Description Updated: "' ||
	       substr(COALESCE(OLD.incdt_descrip, ''), 1, 20) ||
	      '..." -> "' ||
	       substr(COALESCE(NEW.incdt_descrip, ''), 1, 20) ||
	      '..."') );

      IF (_cmnttypeid <> -1) THEN
        -- find an existing comment
        SELECT comment_id
          INTO _cmntid
          FROM comment
         WHERE comment_source = 'INCDT'
           AND comment_source_id = NEW.incdt_id
           AND comment_cmnttype_id = _cmnttypeid;
        IF FOUND THEN
          UPDATE comment SET comment_text = NEW.incdt_descrip WHERE comment_id = _cmntid;
        ELSE
          PERFORM postComment(_cmnttypeid, 'INCDT', NEW.incdt_id, NEW.incdt_descrip);
        END IF;
      END IF;
    END IF;

    IF (NEW.incdt_status <> OLD.incdt_status) THEN
      INSERT INTO incdthist
	    (incdthist_incdt_id,
	     incdthist_change, incdthist_target_id,
	     incdthist_descrip)
      VALUES(NEW.incdt_id,
	     'S', NULL,
	     ('Status Changed: ' ||
	      CASE WHEN(OLD.incdt_status='N') THEN 'New'
		   WHEN(OLD.incdt_status='F') THEN 'Feedback'
		   WHEN(OLD.incdt_status='C') THEN 'Confirmed'
		   WHEN(OLD.incdt_status='A') THEN 'Assigned'
		   WHEN(OLD.incdt_status='R') THEN 'Resolved'
		   WHEN(OLD.incdt_status='L') THEN 'Closed'
		   ELSE OLD.incdt_status
	      END
	      || ' -> ' ||
	      CASE WHEN(NEW.incdt_status='N') THEN 'New'
		   WHEN(NEW.incdt_status='F') THEN 'Feedback'
		   WHEN(NEW.incdt_status='C') THEN 'Confirmed'
		   WHEN(NEW.incdt_status='A') THEN 'Assigned'
		   WHEN(NEW.incdt_status='R') THEN 'Resolved'
		   WHEN(NEW.incdt_status='L') THEN 'Closed'
		   ELSE NEW.incdt_status
	      END
	      ) );
      IF (NEW.incdt_status = 'L') THEN
	_evntType = 'ClosedIncident';
      ELSIF (OLD.incdt_status = 'L') THEN
	_evntType = 'ReopenedIncident';
      END IF;
    END IF;

    IF (COALESCE(NEW.incdt_assigned_username,'') <> COALESCE(OLD.incdt_assigned_username,'')) THEN
      INSERT INTO incdthist
	    (incdthist_incdt_id,
	     incdthist_change, incdthist_target_id,
	     incdthist_descrip)
      VALUES(NEW.incdt_id,
	     'A', NULL,
	     ('Assigned to: "' ||
	       COALESCE(OLD.incdt_assigned_username, '') ||
	      '" -> "' ||
	       COALESCE(NEW.incdt_assigned_username, '') ||
	      '"') );
    END IF;

    IF (COALESCE(NEW.incdt_incdtcat_id,-1) <> COALESCE(OLD.incdt_incdtcat_id,-1)) THEN
      INSERT INTO incdthist
	    (incdthist_incdt_id,
	     incdthist_change, incdthist_target_id,
	     incdthist_descrip)
      VALUES(NEW.incdt_id,
	     'T', NEW.incdt_incdtcat_id,
	     ('Category Changed: ' ||
	       COALESCE((SELECT incdtcat_name
			   FROM incdtcat
			  WHERE (incdtcat_id=OLD.incdt_incdtcat_id)), '')
	      || ' -> ' ||
	       COALESCE((SELECT incdtcat_name
			   FROM incdtcat
			  WHERE (incdtcat_id=NEW.incdt_incdtcat_id)), '')
	      || '') );
    END IF;

    IF (COALESCE(NEW.incdt_incdtseverity_id,-1) <> COALESCE(OLD.incdt_incdtseverity_id,-1)) THEN
      INSERT INTO incdthist
	    (incdthist_incdt_id,
	     incdthist_change, incdthist_target_id,
	     incdthist_descrip)
      VALUES(NEW.incdt_id,
	     'V', NEW.incdt_incdtseverity_id,
	     ('Severity Changed: ' ||
	       COALESCE((SELECT incdtseverity_name
			   FROM incdtseverity
			  WHERE (incdtseverity_id=OLD.incdt_incdtseverity_id)), '')
	      || ' -> ' ||
	       COALESCE((SELECT incdtseverity_name
			   FROM incdtseverity
			  WHERE (incdtseverity_id=NEW.incdt_incdtseverity_id)), '')
	      || '') );
    END IF;

    IF (COALESCE(NEW.incdt_incdtpriority_id,-1) <> COALESCE(OLD.incdt_incdtpriority_id,-1)) THEN
      INSERT INTO incdthist
	    (incdthist_incdt_id,
	     incdthist_change, incdthist_target_id,
	     incdthist_descrip)
      VALUES(NEW.incdt_id,
	     'P', NEW.incdt_incdtpriority_id,
	     ('Priority Changed: ' ||
	       COALESCE((SELECT incdtpriority_name
			   FROM incdtpriority
			  WHERE (incdtpriority_id=OLD.incdt_incdtpriority_id)), '')
	      || ' -> ' ||
	       COALESCE((SELECT incdtpriority_name
			   FROM incdtpriority
			  WHERE (incdtpriority_id=NEW.incdt_incdtpriority_id)), '')
	      || '') );
    END IF;

    IF (COALESCE(NEW.incdt_incdtresolution_id,-1) <> COALESCE(OLD.incdt_incdtresolution_id,-1)) THEN
      INSERT INTO incdthist
	    (incdthist_incdt_id,
	     incdthist_change, incdthist_target_id,
	     incdthist_descrip)
      VALUES(NEW.incdt_id,
	     'E', NEW.incdt_incdtresolution_id,
	     ('Resolution Changed: ' ||
	       COALESCE((SELECT incdtresolution_name
			   FROM incdtresolution
			  WHERE (incdtresolution_id=OLD.incdt_incdtresolution_id)), '')
	      || ' -> ' ||
	       COALESCE((SELECT incdtresolution_name
			   FROM incdtresolution
			  WHERE (incdtresolution_id=NEW.incdt_incdtresolution_id)), '')
	      || '') );
    END IF;
  END IF;

  -- find the warehouse for which to create evntlog entries
    SELECT usrpref_value  INTO _whsId
    FROM usrpref
    WHERE usrpref_username = getEffectiveXtUser()
      AND usrpref_name = 'PreferredWarehouse';

  INSERT INTO evntlog (evntlog_evnttime, evntlog_username,
		       evntlog_evnttype_id, evntlog_ordtype,
		       evntlog_ord_id, evntlog_warehous_id, evntlog_number)
  SELECT DISTINCT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
		       'IC', NEW.incdt_id, _whsId, NEW.incdt_number
  FROM evntnot, evnttype
  WHERE ((evntnot_evnttype_id=evnttype_id)
    AND  (evnttype_name=_evntType));

  RETURN NEW;
  END;
$$;


ALTER FUNCTION public._incdttrigger() OWNER TO admin;

--
-- Name: _invcheadaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _invcheadaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
  DECLARE
    _cmnttypeid INTEGER;
    _cohead_id INTEGER;

  BEGIN
--  Create a comment entry when on a Sales Order when an Invoice is Posted for that order

--  Cache the cmnttype_id for ChangeLog
    SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
    IF (FOUND) THEN
      IF (TG_OP = 'UPDATE') THEN
	IF ((OLD.invchead_posted != NEW.invchead_posted) AND NEW.invchead_posted) THEN
	  SELECT cohead_id INTO _cohead_id
	  FROM cohead
	  WHERE (cohead_number = OLD.invchead_ordernumber);
	  IF (FOUND) THEN
            PERFORM postComment( _cmnttypeid, 'S', _cohead_id,
                                 ('Invoice, ' || NEW.invchead_invcnumber || ', posted for this order') );
          END IF;
	END IF;
      END IF;
    END IF;
  RETURN NEW;
  END;
$$;


ALTER FUNCTION public._invcheadaftertrigger() OWNER TO admin;

--
-- Name: _invcheadbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _invcheadbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _recurid     INTEGER;
  _newparentid INTEGER;

BEGIN
  IF (TG_OP = 'UPDATE') THEN
    IF (OLD.invchead_posted
      AND ((OLD.invchead_invcnumber != NEW.invchead_invcnumber)
        OR (OLD.invchead_invcdate != NEW.invchead_invcdate)
        OR (OLD.invchead_terms_id != NEW.invchead_terms_id)
        OR (OLD.invchead_salesrep_id != NEW.invchead_salesrep_id)
        OR (OLD.invchead_commission != NEW.invchead_commission)
        OR (OLD.invchead_taxzone_id != NEW.invchead_taxzone_id)
        OR (OLD.invchead_shipchrg_id != NEW.invchead_shipchrg_id)
        OR (OLD.invchead_prj_id != NEW.invchead_prj_id)
        OR (OLD.invchead_misc_accnt_id != NEW.invchead_misc_accnt_id)
        OR (OLD.invchead_misc_amount != NEW.invchead_misc_amount)
        OR (OLD.invchead_freight != NEW.invchead_freight))) THEN
      RAISE EXCEPTION 'Edit not allow on Posted Invoice.';
    END IF;
  END IF;
  
  IF (TG_OP = 'DELETE') THEN
    DELETE FROM invcheadtax
    WHERE (taxhist_parent_id=OLD.invchead_id);

    SELECT recur_id INTO _recurid
      FROM recur
     WHERE ((recur_parent_id=OLD.invchead_id)
        AND (recur_parent_type='I'));
    IF (_recurid IS NOT NULL) THEN
      SELECT invchead_id INTO _newparentid
        FROM invchead
       WHERE ((invchead_recurring_invchead_id=OLD.invchead_id)
          AND (invchead_id!=OLD.invchead_id))
       ORDER BY invchead_invcdate
       LIMIT 1;

      IF (_newparentid IS NULL) THEN
        DELETE FROM recur WHERE recur_id=_recurid;
      ELSE
        UPDATE recur SET recur_parent_id=_newparentid
         WHERE recur_id=_recurid;
        UPDATE invchead SET invchead_recurring_invchead_id=_newparentid
         WHERE invchead_recurring_invchead_id=OLD.invchead_id
           AND invchead_id!=OLD.invchead_id;
      END IF;
    END IF;

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._invcheadbeforetrigger() OWNER TO admin;

--
-- Name: _invcheadtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _invcheadtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    -- Something can go here
    RETURN OLD;
  END IF;

-- Insert new row
  IF (TG_OP = 'INSERT') THEN

  -- Calculate Freight Tax
    IF (NEW.invchead_freight <> 0) THEN
      PERFORM calculateTaxHist( 'invcheadtax',
                                NEW.invchead_id,
                                NEW.invchead_taxzone_id,
                                getFreightTaxtypeId(),
                                NEW.invchead_invcdate,
                                NEW.invchead_curr_id,
                                NEW.invchead_freight );
    END IF;

    --- clear the number from the issue cache
    PERFORM clearNumberIssue('InvcNumber', NEW.invchead_invcnumber);
  END IF;

-- Update row
  IF (TG_OP = 'UPDATE') THEN

    IF ( (NEW.invchead_freight <> OLD.invchead_freight) OR
         (COALESCE(NEW.invchead_taxzone_id,-1) <> COALESCE(OLD.invchead_taxzone_id,-1)) OR
         (NEW.invchead_invcdate <> OLD.invchead_invcdate) OR
         (NEW.invchead_curr_id <> OLD.invchead_curr_id) ) THEN
  -- Calculate invchead Tax
      PERFORM calculateTaxHist( 'invcheadtax',
                                NEW.invchead_id,
                                NEW.invchead_taxzone_id,
                                getFreightTaxtypeId(),
                                NEW.invchead_invcdate,
                                NEW.invchead_curr_id,
                                NEW.invchead_freight );
    END IF;

    IF ( (COALESCE(NEW.invchead_taxzone_id,-1) <> COALESCE(OLD.invchead_taxzone_id,-1)) OR
         (NEW.invchead_invcdate <> OLD.invchead_invcdate) OR
         (NEW.invchead_curr_id <> OLD.invchead_curr_id) ) THEN
  -- Calculate invcitem Tax
      IF (COALESCE(NEW.invchead_taxzone_id,-1) <> COALESCE(OLD.invchead_taxzone_id,-1)) THEN

        UPDATE invcitem SET invcitem_taxtype_id=getItemTaxType(invcitem_item_id,NEW.invchead_taxzone_id)
        WHERE (invcitem_invchead_id=NEW.invchead_id);

        PERFORM calculateTaxHist( 'invcitemtax',
                                  invcitem_id,
                                  NEW.invchead_taxzone_id,
                                  invcitem_taxtype_id,
                                  NEW.invchead_invcdate,
                                  NEW.invchead_curr_id,
                                  (invcitem_billed * invcitem_qty_invuomratio) *
                                  (invcitem_price / invcitem_price_invuomratio) )
        FROM invcitem
        WHERE (invcitem_invchead_id = NEW.invchead_id);
      END IF;
    END IF;

  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._invcheadtrigger() OWNER TO admin;

--
-- Name: _invcitembeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _invcitembeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _itemfractional BOOLEAN;

BEGIN
  IF (TG_OP = 'DELETE') THEN
    DELETE FROM invcitemtax
    WHERE (taxhist_parent_id=OLD.invcitem_id);

    RETURN OLD;
  END IF;

  IF (TG_OP IN ('UPDATE','DELETE')) THEN
    IF (SELECT COUNT(invchead_id) > 0
        FROM invchead
        WHERE ((invchead_id=OLD.invcitem_invchead_id)
          AND (invchead_posted))) THEN
      RAISE EXCEPTION 'Edit not allowed on Posted Invoices.';
    END IF;
  END IF;

  -- If regular Item then enforce item_fractional
  IF (COALESCE(NEW.invcitem_item_id, -1) <> -1) THEN
    SELECT itemuomfractionalbyuom(NEW.invcitem_item_id, NEW.invcitem_qty_uom_id) INTO _itemfractional;
    IF (NOT _itemfractional) THEN
      IF (TRUNC(NEW.invcitem_ordered) <> NEW.invcitem_ordered) THEN
        RAISE EXCEPTION 'Item does not support fractional quantities';
      END IF;
      IF (TRUNC(NEW.invcitem_billed) <> NEW.invcitem_billed) THEN
        RAISE EXCEPTION 'Item does not support fractional quantities';
      END IF;
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._invcitembeforetrigger() OWNER TO admin;

--
-- Name: _invcitemtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _invcitemtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _r RECORD;

BEGIN
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

-- Cache Invoice Head
  SELECT * INTO _r
  FROM invchead
  WHERE (invchead_id=NEW.invcitem_invchead_id);
  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Invoice head not found';
  END IF;

-- Insert new row
  IF (TG_OP = 'INSERT') THEN

  -- Calculate Tax
      PERFORM calculateTaxHist( 'invcitemtax',
                                NEW.invcitem_id,
                                COALESCE(_r.invchead_taxzone_id, -1),
                                NEW.invcitem_taxtype_id,
                                COALESCE(_r.invchead_invcdate, CURRENT_DATE),
                                COALESCE(_r.invchead_curr_id, -1),
                                (NEW.invcitem_billed * NEW.invcitem_qty_invuomratio) *
                                (NEW.invcitem_price / NEW.invcitem_price_invuomratio) );
  END IF;

-- Update row
  IF (TG_OP = 'UPDATE') THEN

  -- Calculate Tax
    IF ( (NEW.invcitem_billed <> OLD.invcitem_billed) OR
         (NEW.invcitem_qty_invuomratio <> OLD.invcitem_qty_invuomratio) OR
         (NEW.invcitem_price <> OLD.invcitem_price) OR
         (NEW.invcitem_price_invuomratio <> OLD.invcitem_price_invuomratio) OR
         (COALESCE(NEW.invcitem_taxtype_id, -1) <> COALESCE(OLD.invcitem_taxtype_id, -1)) ) THEN
      PERFORM calculateTaxHist( 'invcitemtax',
                                NEW.invcitem_id,
                                COALESCE(_r.invchead_taxzone_id, -1),
                                NEW.invcitem_taxtype_id,
                                COALESCE(_r.invchead_invcdate, CURRENT_DATE),
                                COALESCE(_r.invchead_curr_id, -1),
                                (NEW.invcitem_billed * NEW.invcitem_qty_invuomratio) *
                                (NEW.invcitem_price / NEW.invcitem_price_invuomratio) );
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._invcitemtrigger() OWNER TO admin;

--
-- Name: _ipsassbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _ipsassbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  --  Checks
  IF NOT (checkPrivilege('MaintainPricingSchedules')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Price Schedules.';
  END IF;

  -- Business logic, disallow invalid combinations
  IF (TG_OP IN ('INSERT','UPDATE')) THEN
    IF (LENGTH(COALESCE(NEW.ipsass_custtype_pattern,'')) != 0) THEN
      new.ipsass_cust_id 		= 	-1;
      new.ipsass_custtype_id 		= 	-1;
      new.ipsass_shipto_id		= 	-1;
      new.ipsass_shipto_pattern	=	'';
    ELSIF (COALESCE(NEW.ipsass_custtype_id,-1) > -1) THEN
      new.ipsass_cust_id 		= 	-1;
      new.ipsass_shipto_id		= 	-1;
      new.ipsass_shipto_pattern	=	'';
      new.ipsass_custtype_pattern	=	'';
    ELSIF (LENGTH(COALESCE(NEW.ipsass_shipto_pattern,'')) != 0) THEN
      new.ipsass_custtype_id 		= 	-1;
      new.ipsass_shipto_id		= 	-1;
      new.ipsass_custtype_pattern	=	'';
    ELSE
      new.ipsass_shipto_id		= 	COALESCE(NEW.ipsass_shipto_id,-1);
      new.ipsass_custtype_id 		= 	-1;
      new.ipsass_shipto_pattern	=	'';
      new.ipsass_custtype_pattern	=	'';
    END IF;

    RETURN NEW;
  ELSE
    RETURN OLD;
  END IF;
  
END;
$$;


ALTER FUNCTION public._ipsassbeforetrigger() OWNER TO admin;

--
-- Name: _ipsheadbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _ipsheadbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  --  Checks
  IF NOT (checkPrivilege('MaintainPricingSchedules')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Price Schedules.';
  END IF;

  IF (TG_OP IN ('INSERT','UPDATE')) THEN
    RETURN NEW;
  ELSE
    RETURN OLD;
  END IF;
END;
$$;


ALTER FUNCTION public._ipsheadbeforetrigger() OWNER TO admin;

--
-- Name: _ipsitemcharbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _ipsitemcharbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  --  Checks
  IF NOT (checkPrivilege('MaintainPricingSchedules')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Price Schedules.';
  END IF;
  
  IF (TG_OP IN ('INSERT','UPDATE')) THEN
    IF (SELECT (COUNT(item_id)=0)
        FROM ipsiteminfo JOIN item ON (item_id=ipsitem_item_id) 
        WHERE ((ipsitem_id=NEW.ipsitemchar_ipsitem_id)
        AND (item_config))) THEN
      RAISE EXCEPTION 'Characteristic prices may only be set on configured items.';
    ELSIF (SELECT (COUNT(item_id)=0)
        FROM ipsiteminfo JOIN item ON (item_id=ipsitem_item_id)
                         JOIN charass ON (charass_target_id=item_id AND charass_target_type='I') 
        WHERE ((ipsitem_id=NEW.ipsitemchar_ipsitem_id)
        AND (charass_char_id=NEW.ipsitemchar_char_id)
        AND (charass_value=NEW.ipsitemchar_value))) THEN
      RAISE EXCEPTION 'No characteristic with matching value exists for this item.';
    END IF;
    RETURN NEW;
  ELSE
    RETURN OLD;
  END IF;
END;
$$;


ALTER FUNCTION public._ipsitemcharbeforetrigger() OWNER TO admin;

--
-- Name: _ipsiteminfobeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _ipsiteminfobeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN

  --  Checks
  IF NOT (checkPrivilege('MaintainPricingSchedules')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Price Schedules.';
  END IF;
  
  IF (TG_OP IN ('INSERT','UPDATE')) THEN
    RETURN NEW;
  ELSE
    RETURN OLD;
  END IF;
END;
$$;


ALTER FUNCTION public._ipsiteminfobeforetrigger() OWNER TO admin;

--
-- Name: _itemaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;

BEGIN
-- Privilege Checks
   IF (NOT checkPrivilege('MaintainItemMasters')) THEN
     RAISE EXCEPTION 'You do not have privileges to maintain Items.';
   END IF;
   
-- Integrity checks
  IF (TG_OP = 'UPDATE') THEN
    IF ((OLD.item_type <> NEW.item_type) AND (NEW.item_type = 'L')) THEN
      IF (SELECT COUNT(*) != 0 FROM bomitem WHERE (bomitem_item_id = OLD.item_id)) THEN
        RAISE EXCEPTION 'This item is part of one or more Bills of Materials and cannot be a Planning Item.';
      END IF;
    END IF;

    IF ((OLD.item_type <> NEW.item_type) AND
       (NEW.item_type IN ('R','S','T'))) THEN
      IF (SELECT COUNT(*) != 0
        FROM itemsite
        WHERE ((itemsite_item_id=OLD.item_id)
        AND (itemsite_qtyonhand + qtyallocated(itemsite_id,startoftime(),endoftime()) +
	   qtyordered(itemsite_id,startoftime(),endoftime()) > 0 ))) THEN
          RAISE EXCEPTION 'Item type not allowed when there are itemsites with quantities with on hand quantities or pending inventory activity for this item.';
      END IF;
    END IF;
-- If type changed remove costs and deactivate item sites
    IF (NEW.item_type <> OLD.item_type) THEN
      PERFORM updateCost(itemcost_id, 0) FROM itemcost WHERE (itemcost_item_id=OLD.item_id);
      UPDATE itemsite SET itemsite_active=false WHERE (itemsite_item_id=OLD.item_id);
      IF (NEW.item_type = 'R') THEN
        UPDATE itemsite SET itemsite_controlmethod='N' WHERE (itemsite_item_id=OLD.item_id);
      END IF;
    END IF;
  END IF;

  IF ( SELECT (metric_value='t')
       FROM metric
       WHERE (metric_name='ItemChangeLog') ) THEN

--  Cache the cmnttype_id for ChangeLog
    SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
    IF (FOUND) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'I', NEW.item_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN
        IF (OLD.item_active <> NEW.item_active) THEN
          IF (NEW.item_active) THEN
            PERFORM postComment(_cmnttypeid, 'I', NEW.item_id, 'Activated');
          ELSE
            PERFORM postComment(_cmnttypeid, 'I', NEW.item_id, 'Deactivated');
          END IF;
        END IF;

        IF (OLD.item_descrip1 <> NEW.item_descrip1) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'Description 1 Changed from "' || OLD.item_descrip1 ||
                                 '" to "' || NEW.item_descrip1 || '"' ) );
        END IF;

        IF (OLD.item_descrip2 <> NEW.item_descrip2) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'Description 2 Changed from "' || OLD.item_descrip2 ||
                                 '" to "' || NEW.item_descrip2 || '"' ) );
        END IF;

        IF (OLD.item_inv_uom_id <> NEW.item_inv_uom_id) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'Inventory UOM Changed from "' ||
                                 (SELECT uom_name FROM uom WHERE uom_id=OLD.item_inv_uom_id) ||
                                 '" (' || CAST(OLD.item_inv_uom_id AS TEXT) ||
                                 ') to "' ||
                                 (SELECT uom_name FROM uom WHERE uom_id=NEW.item_inv_uom_id) ||
                                 '" (' || CAST(NEW.item_inv_uom_id AS TEXT) || ')' ) );
        END IF;

        IF (OLD.item_sold <> NEW.item_sold) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               CASE WHEN (NEW.item_sold) THEN 'Sold Changed from FALSE to TRUE'
                                    ELSE 'Sold Changed from TRUE to FALSE'
                               END );
        END IF;

        IF (OLD.item_picklist <> NEW.item_picklist) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               CASE WHEN (NEW.item_picklist) THEN 'Pick List Changed from FALSE to TRUE'
                                    ELSE 'Pick List Changed from TRUE to FALSE'
                               END );
        END IF;

        IF (OLD.item_fractional <> NEW.item_fractional) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               CASE WHEN (NEW.item_fractional) THEN 'Fractional Changed from FALSE to TRUE'
                                    ELSE 'Fractional Changed from TRUE to FALSE'
                               END );
        END IF;

        IF (OLD.item_exclusive <> NEW.item_exclusive) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               CASE WHEN (NEW.item_exclusive) THEN 'Exclusive Changed from FALSE to TRUE'
                                    ELSE 'Exclusive Changed from TRUE to FALSE'
                               END );
        END IF;
        IF (OLD.item_config <> NEW.item_config) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               CASE WHEN (NEW.item_config) THEN 'Configured Changed from FALSE to TRUE'
                                    ELSE 'Configured Changed from TRUE to FALSE'
                               END );
        END IF;

        IF (OLD.item_listprice <> NEW.item_listprice) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'List Price Changed from "' || formatSalesPrice(OLD.item_listprice) ||
                                 '" to "' || formatSalesPrice(NEW.item_listprice) || '"' ) );
        END IF;

-- Add New stuff

        IF (OLD.item_type <> NEW.item_type) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'Type Changed from "' || OLD.item_type ||
                                 '" to "' || NEW.item_type || '"' ) );
        END IF;

        IF (OLD.item_price_uom_id <> NEW.item_price_uom_id) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'Price UOM Changed from "' ||
                                 (SELECT uom_name FROM uom WHERE uom_id=OLD.item_price_uom_id) ||
                                 '" (' || CAST(OLD.item_price_uom_id AS TEXT) ||
                                 ') to "' ||
                                 (SELECT uom_name FROM uom WHERE uom_id=NEW.item_price_uom_id) ||
                                 '" (' || CAST(NEW.item_price_uom_id AS TEXT) || ')' ) );
        END IF;

        IF (OLD.item_classcode_id <> NEW.item_classcode_id) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'Class Code Changed from "' ||
                                 (SELECT classcode_code || '-' || classcode_descrip FROM classcode WHERE classcode_id=OLD.item_classcode_id) ||
                                 '" (' || CAST(OLD.item_classcode_id AS TEXT) ||
                                 ') to "' ||
                                 (SELECT classcode_code || '-' || classcode_descrip FROM classcode WHERE classcode_id=NEW.item_classcode_id) ||
                                 '" (' || CAST(NEW.item_classcode_id AS TEXT) || ')' ) );
        END IF;

        IF (OLD.item_freightclass_id <> NEW.item_freightclass_id) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'Freight Class Changed from "' ||
                                 (SELECT freightclass_code || '-' || freightclass_descrip FROM freightclass WHERE freightclass_id=OLD.item_freightclass_id) ||
                                 '" (' || CAST(OLD.item_freightclass_id AS TEXT) ||
                                 ') to "' ||
                                 (SELECT freightclass_code || '-' || freightclass_descrip FROM freightclass WHERE freightclass_id=NEW.item_freightclass_id) ||
                                 '" (' || CAST(NEW.item_freightclass_id AS TEXT) || ')' ) );
        END IF;

        IF (OLD.item_prodcat_id <> NEW.item_prodcat_id) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'Product Category Changed from "' ||
                                 (SELECT prodcat_code || '-' || prodcat_descrip FROM prodcat WHERE prodcat_id=OLD.item_prodcat_id) ||
                                 '" (' || CAST(OLD.item_prodcat_id AS TEXT) ||
                                 ') to "' ||
                                 (SELECT prodcat_code || '-' || prodcat_descrip FROM prodcat WHERE prodcat_id=NEW.item_prodcat_id) ||
                                 '" (' || CAST(NEW.item_prodcat_id AS TEXT) || ')' ) );
        END IF;

        IF (OLD.item_upccode <> NEW.item_upccode) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'UPC Code Changed from "' || OLD.item_upccode ||
                                 '" to "' || NEW.item_upccode || '"' ) );
        END IF;

        IF (OLD.item_prodweight <> NEW.item_prodweight) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'Product Weight Changed from "' || formatWeight(OLD.item_prodweight) ||
                                 '" to "' || formatWeight(NEW.item_prodweight) || '"' ) );
        END IF;

        IF (OLD.item_packweight <> NEW.item_packweight) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'Packaging Weight Changed from "' || formatWeight(OLD.item_packweight) ||
                                 '" to "' || formatWeight(NEW.item_packweight) || '"' ) );
        END IF;

        IF (OLD.item_maxcost <> NEW.item_maxcost) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'Maximum Desired Cost Changed from "' || formatCost(OLD.item_maxcost) ||
                                 '" to "' || formatCost(NEW.item_maxcost) || '"' ) );
        END IF;

        IF (OLD.item_listcost <> NEW.item_listcost) THEN
          PERFORM postComment( _cmnttypeid, 'I', NEW.item_id,
                               ( 'List Cost Changed from "' || formatCost(OLD.item_listcost) ||
                                 '" to "' || formatCost(NEW.item_listcost) || '"' ) );
        END IF;
-- End changes

      END IF;
    END IF;
  END IF;

  IF (TG_OP = 'DELETE') THEN
    DELETE FROM imageass WHERE ((imageass_source_id=OLD.item_id) AND (imageass_source='I'));
    DELETE FROM url WHERE ((url_source_id=OLD.item_id) AND (url_source='I'));
    DELETE FROM docass WHERE docass_source_id = OLD.item_id AND docass_source_type = 'I';
    DELETE FROM docass WHERE docass_target_id = OLD.item_id AND docass_target_type = 'I';

    RETURN OLD;
  END IF;
  
  RETURN NEW;

END;
$$;


ALTER FUNCTION public._itemaftertrigger() OWNER TO admin;

--
-- Name: _itemaliastrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemaliastrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

-- Privilege Checks
   IF (NOT checkPrivilege('MaintainItemMasters')) THEN
     RAISE EXCEPTION 'You do not have privileges to maintain Item Aliases.';
   END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._itemaliastrigger() OWNER TO admin;

--
-- Name: _itemcostaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemcostaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _itemNumber TEXT;
  _maxCost NUMERIC;
  _oldStdCost NUMERIC;
  _oldActCost NUMERIC;
  _actualCost NUMERIC;
  _standardCost NUMERIC;
  
BEGIN

--  Create Event if Standard or Actual Cost is greater than Max Cost

IF NOT EXISTS(SELECT 1 
     FROM evntnot
       JOIN evnttype ON (evnttype_id = evntnot_evnttype_id)
       JOIN usrpref ON (evntnot_username = usrpref_username)
     WHERE
          evnttype_name = 'CostExceedsMaxDesired'
          AND usrpref_name = 'active' 
          AND usrpref_value = 't')     
   THEN
     RETURN NEW;     
END IF; 

  SELECT item_number, item_maxcost, actcost(item_id), stdcost(item_id) INTO _itemNumber, _maxCost, _actualCost, _standardCost
  FROM item
  WHERE (item_id=NEW.itemcost_item_id);

  IF (_maxCost > 0.0) THEN
   -- IF (_standardCost > _maxCost) 
      IF NOT EXISTS(SELECT 1 --COUNT(evntlog_id) 
                    FROM
                      evntlog, evnttype
                      WHERE evntlog_evnttype_id = evnttype_id 
                      AND evntlog_number LIKE 
                          (_itemNumber || ' -Standard- New:' || '%')
                   
                      AND (evntlog_dispatched IS NULL)
                      AND CAST(evntlog_evnttime AS DATE) = current_date
                     
                      ) 
                      AND (_standardCost > _maxCost) THEN
                               
                       
      IF (TG_OP = 'INSERT') THEN
        _oldStdCost := 0;
        _oldActCost := 0;
      ELSE
        _oldStdCost := OLD.itemcost_stdcost;
        _oldActCost := OLD.itemcost_stdcost;
      END IF; 
      INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                            evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number,
                            evntlog_newvalue, evntlog_oldvalue )
      SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
             '', NEW.itemcost_item_id, itemsite_warehous_id,
               (_itemNumber || ' -Standard- ' || 
               'New: ' || formatCost(_standardCost) ||
               ' Max: '|| formatCost(_MaxCost)),
               NEW.itemcost_stdcost, _oldStdCost
      FROM evntnot, evnttype, itemsite, usrpref
      WHERE ( (evntnot_evnttype_id=evnttype_id)
        AND   (itemsite_item_id=NEW.itemcost_item_id)
        AND   (evntnot_warehous_id=itemsite_warehous_id)
        AND   (evnttype_name='CostExceedsMaxDesired') 
        AND   (itemsite_active)
        AND   (usrpref_username = evntnot_username)
        AND   (usrpref_name = 'active')
        AND   (usrpref_value = 't'));
       -- LIMIT 1;
    END IF;
       IF NOT EXISTS(
                     SELECT 1 FROM
                      evntlog, evnttype
                      WHERE evntlog_evnttype_id = evnttype_id 
                      AND evntlog_number LIKE 
                          (_itemNumber || ' -Actual- New:' || '%')

                      AND (evntlog_dispatched IS NULL)
                      AND CAST(evntlog_evnttime AS DATE) = current_date
                      )

                 AND  (_actualCost > _maxCost)
          THEN
                            
      INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                            evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number,
                            evntlog_newvalue, evntlog_oldvalue )
      SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
             '', NEW.itemcost_item_id, itemsite_warehous_id,
               (_itemNumber || ' -Actual- ' || 
               'New: ' || formatCost(_actualCost) ||
               ' Max: '|| formatCost(_MaxCost)),
             NEW.itemcost_actcost, _oldActCost
      FROM evntnot, evnttype, itemsite, usrpref
      WHERE ( (evntnot_evnttype_id=evnttype_id)
        AND   (itemsite_item_id=NEW.itemcost_item_id)
        AND   (evntnot_warehous_id=itemsite_warehous_id)
        AND   (evnttype_name='CostExceedsMaxDesired') 
        AND   (itemsite_active)
        AND   (usrpref_username = evntnot_username)
        AND   (usrpref_name = 'active')
        AND   (usrpref_value = 't')
        ); --LIMIT 1;
    END IF;
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._itemcostaftertrigger() OWNER TO admin;

--
-- Name: _itemcosttrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemcosttrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  --Privilege Checks
  IF ( (TG_OP = 'INSERT') AND (NOT checkPrivilege('CreateCosts')) AND (NOT checkPrivilege('PostVouchers')) ) THEN
    RAISE EXCEPTION 'You do not have privileges to enter Item Costs.';
  END IF;

  IF ( (TG_OP = 'UPDATE') AND (NOT checkPrivilege('EnterActualCosts')) AND (NOT checkPrivilege('PostVouchers')) AND (NOT checkPrivilege('UpdateActualCosts')) AND (NOT checkPrivilege('PostActualCosts')) AND (NOT checkPrivilege('PostStandardCosts')) ) THEN
    RAISE EXCEPTION 'You do not have privileges to update Item Costs.';
  END IF;

  IF ( (TG_OP = 'DELETE') AND (NOT checkPrivilege('DeleteCosts')) ) THEN
    RAISE EXCEPTION 'You do not have privileges to delete Item Costs.';
  END IF;

  IF (TG_OP = 'UPDATE') THEN
    IF (NEW.itemcost_actcost <> OLD.itemcost_actcost OR
        NEW.itemcost_curr_id <> OLD.itemcost_curr_id) THEN
      INSERT INTO costhist
      ( costhist_item_id, costhist_costelem_id, costhist_type,
        costhist_lowlevel, costhist_username, costhist_date,
        costhist_oldcost, costhist_newcost,
        costhist_oldcurr_id, costhist_newcurr_id )
      VALUES
      ( NEW.itemcost_item_id, NEW.itemcost_costelem_id, 'A',
        NEW.itemcost_lowlevel, getEffectiveXtUser(), CURRENT_TIMESTAMP,
        OLD.itemcost_actcost, NEW.itemcost_actcost,
        OLD.itemcost_curr_id, NEW.itemcost_curr_id );
    END IF;

    IF (NEW.itemcost_stdcost <> OLD.itemcost_stdcost) THEN
      INSERT INTO costhist
      ( costhist_item_id, costhist_costelem_id, costhist_type,
        costhist_lowlevel, costhist_username, costhist_date,
        costhist_oldcost, costhist_newcost,
        costhist_oldcurr_id, costhist_newcurr_id )
      VALUES
      ( NEW.itemcost_item_id, NEW.itemcost_costelem_id, 'S',
        NEW.itemcost_lowlevel, getEffectiveXtUser(), CURRENT_TIMESTAMP,
        OLD.itemcost_stdcost, NEW.itemcost_stdcost,
        baseCurrId(), baseCurrId() );
    END IF;

    RETURN NEW;

  ELSIF (TG_OP = 'INSERT') THEN
    INSERT INTO costhist
    ( costhist_item_id, costhist_costelem_id, costhist_type,
      costhist_lowlevel, costhist_username, costhist_date,
      costhist_oldcost, costhist_newcost,
      costhist_oldcurr_id, costhist_newcurr_id )
    VALUES
    ( NEW.itemcost_item_id, NEW.itemcost_costelem_id, 'N',
      NEW.itemcost_lowlevel, getEffectiveXtUser(), CURRENT_TIMESTAMP,
      0, NEW.itemcost_actcost,
      baseCurrId(), NEW.itemcost_curr_id );

    RETURN NEW;

  ELSIF (TG_OP = 'DELETE') THEN
    INSERT INTO costhist
    ( costhist_item_id, costhist_costelem_id, costhist_type,
      costhist_lowlevel, costhist_username, costhist_date,
      costhist_oldcost, costhist_newcost,
      costhist_oldcurr_id, costhist_newcurr_id )
    VALUES
    ( OLD.itemcost_item_id, OLD.itemcost_costelem_id, 'D',
      OLD.itemcost_lowlevel, getEffectiveXtUser(), CURRENT_TIMESTAMP,
      OLD.itemcost_stdcost, 0,
      OLD.itemcost_curr_id, baseCurrId() );

    RETURN OLD;
  END IF;

END;
$$;


ALTER FUNCTION public._itemcosttrigger() OWNER TO admin;

--
-- Name: _itemsiteaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemsiteaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _state INTEGER;
  _wasLocationControl BOOLEAN;
  _isLocationControl BOOLEAN;
  _wasLotSerial BOOLEAN;
  _isLotSerial BOOLEAN;
  _wasPerishable BOOLEAN;
  _isPerishable BOOLEAN;
  _qty NUMERIC;
  _maint BOOLEAN;
  _cost NUMERIC;
  _variance NUMERIC;
  _application TEXT;

BEGIN
-- Cache Application
  SELECT fetchMetricText('Application') INTO _application;

-- Check if we are doing maintenance
  IF (TG_OP = 'INSERT') THEN
    _maint := TRUE;
  ELSIF (TG_OP = 'UPDATE') THEN
    IF ((OLD.itemsite_item_id           != NEW.itemsite_item_id)
     OR (OLD.itemsite_warehous_id       != NEW.itemsite_warehous_id)
     OR (OLD.itemsite_reorderlevel      != NEW.itemsite_reorderlevel)
     OR (OLD.itemsite_ordertoqty        != NEW.itemsite_ordertoqty)
     OR (OLD.itemsite_cyclecountfreq    != NEW.itemsite_cyclecountfreq)
     OR (OLD.itemsite_planning_type     != NEW.itemsite_planning_type)
     OR (OLD.itemsite_posupply          != NEW.itemsite_posupply)
     OR (OLD.itemsite_wosupply          != NEW.itemsite_wosupply)
     OR (OLD.itemsite_loccntrl          != NEW.itemsite_loccntrl)
     OR (OLD.itemsite_safetystock       != NEW.itemsite_safetystock)
     OR (OLD.itemsite_minordqty         != NEW.itemsite_minordqty)
     OR (OLD.itemsite_multordqty        != NEW.itemsite_multordqty)
     OR (OLD.itemsite_leadtime          != NEW.itemsite_leadtime)
     OR (OLD.itemsite_abcclass          != NEW.itemsite_abcclass)
     OR (OLD.itemsite_controlmethod     != NEW.itemsite_controlmethod)
     OR (OLD.itemsite_active            != NEW.itemsite_active)
     OR (OLD.itemsite_plancode_id       != NEW.itemsite_plancode_id)
     OR (OLD.itemsite_costcat_id        != NEW.itemsite_costcat_id)
     OR (OLD.itemsite_eventfence        != NEW.itemsite_eventfence)
     OR (OLD.itemsite_sold              != NEW.itemsite_sold)
     OR (OLD.itemsite_stocked           != NEW.itemsite_stocked)
     OR (OLD.itemsite_location_id       != NEW.itemsite_location_id)
     OR (OLD.itemsite_useparams         != NEW.itemsite_useparams)
     OR (OLD.itemsite_useparamsmanual   != NEW.itemsite_useparamsmanual)
     OR (OLD.itemsite_soldranking       != NEW.itemsite_soldranking)
     OR (OLD.itemsite_createpr          != NEW.itemsite_createpr)
     OR (OLD.itemsite_location          != NEW.itemsite_location)
     OR (OLD.itemsite_location_comments != NEW.itemsite_location_comments)
     OR (OLD.itemsite_notes             != NEW.itemsite_notes)
     OR (OLD.itemsite_perishable        != NEW.itemsite_perishable)
     OR (OLD.itemsite_autoabcclass      != NEW.itemsite_autoabcclass)
     OR (OLD.itemsite_ordergroup        != NEW.itemsite_ordergroup)
     OR (OLD.itemsite_disallowblankwip  != NEW.itemsite_disallowblankwip)
     OR (OLD.itemsite_maxordqty         != NEW.itemsite_maxordqty)
     OR (OLD.itemsite_mps_timefence     != NEW.itemsite_mps_timefence)
     OR (OLD.itemsite_createwo          != NEW.itemsite_createwo)
     OR (OLD.itemsite_warrpurc          != NEW.itemsite_warrpurc)
     OR (OLD.itemsite_costmethod        != NEW.itemsite_costmethod)
     OR (OLD.itemsite_autoreg           != NEW.itemsite_autoreg)
     OR (OLD.itemsite_lsseq_id          != NEW.itemsite_lsseq_id) ) THEN
      IF (OLD.itemsite_item_id != NEW.itemsite_item_id) THEN
        RAISE EXCEPTION 'The item number on an itemsite may not be changed.';
      ELSIF (OLD.itemsite_warehous_id != NEW.itemsite_warehous_id) THEN
        RAISE EXCEPTION 'The warehouse code on an itemsite may not be changed.';
      END IF;
      _maint := TRUE;
    END IF;
  ELSE
    _maint := FALSE;
  END IF;

  IF (_maint) THEN -- Begin Maintenance
-- Privilege Checks
    IF ( NOT checkPrivilege('MaintainItemSites') ) THEN
       RAISE EXCEPTION 'You do not have privileges to maintain Item Sites.';
    END IF;
    
-- Override values to avoid invalid data combinations
    IF (NOT NEW.itemsite_posupply) THEN
      UPDATE itemsite SET
        itemsite_createpr = FALSE
      WHERE (itemsite_id=NEW.itemsite_id);
    END IF;
    IF (NOT NEW.itemsite_wosupply) THEN
      UPDATE itemsite SET
        itemsite_createwo = FALSE
      WHERE (itemsite_id=NEW.itemsite_id);
    END IF;

    IF (NEW.itemsite_controlmethod NOT IN ('S','L')) THEN
      UPDATE itemsite SET
        itemsite_perishable = FALSE,
        itemsite_warrpurc = FALSE,
        itemsite_autoreg = FALSE,
        itemsite_lsseq_id = NULL
      WHERE (itemsite_id=NEW.itemsite_id);
    END IF;

    IF (NOT NEW.itemsite_loccntrl) THEN
      UPDATE itemsite SET
        itemsite_disallowblankwip = FALSE
      WHERE (itemsite_id=NEW.itemsite_id);
    END IF;

    IF (NOT NEW.itemsite_useparams) THEN
      UPDATE itemsite SET
        itemsite_reorderlevel    = 0,
        itemsite_ordertoqty      = 0,
        itemsite_minordqty       = 0,
        itemsite_maxordqty       = 0,
        itemsite_multordqty      = 0,
        itemsite_useparamsmanual = FALSE
      WHERE (itemsite_id = NEW.itemsite_id);
    END IF;
    
-- Integrity check
    IF (TG_OP = 'INSERT') THEN
      -- Handle MLC logic
      IF ( (NEW.itemsite_loccntrl) AND (NEW.itemsite_warehous_id IS NOT NULL) ) THEN
        IF (SELECT count(*)=0
            FROM location
            WHERE ((location_warehous_id=NEW.itemsite_warehous_id)
            AND ( (NOT location_restrict) OR
                ( (location_restrict) AND
                (location_id IN ( SELECT locitem_location_id
                                  FROM locitem
                                  WHERE (locitem_item_id=NEW.itemsite_item_id) ) ) ) ))) THEN
          RAISE EXCEPTION 'You must first create at least one valid
	    		  Location for this Item Site before it may be
	   	          multiply located.';
        END IF;
      END IF;

      --This could be made a table constraint later, but do not want to create a big problem
      --for users with problematic legacy data over a relatively trivial problem for now,
      --so we will just check moving forword.
      IF (NEW.itemsite_stocked AND NEW.itemsite_reorderlevel<=0) THEN
        RAISE EXCEPTION 'Stocked items must have postive reorder level specified.';
      END IF;
    END IF;

    IF (TG_OP = 'UPDATE') THEN
      --This could be made a table constraint later, but do not want to create a big problem
      --for users with problematic legacy data over a relatively trivial problem for now,
      --so we will just check moving forword.
      IF ((NEW.itemsite_stocked)
        AND (NEW.itemsite_stocked != OLD.itemsite_stocked) --Avoid checking unless explicitly changed
        AND (NEW.itemsite_reorderlevel<=0)) THEN
        RAISE EXCEPTION 'Stocked items must have postive reorder level specified.';
      END IF;
    END IF;
  
    IF (TG_OP = 'UPDATE') THEN
  
-- Integrity check
      IF (NOT OLD.itemsite_loccntrl AND NEW.itemsite_loccntrl) THEN
        IF (SELECT count(*)=0
          FROM location
          WHERE ((location_warehous_id=NEW.itemsite_warehous_id)
          AND ( (NOT location_restrict) OR
              ( (location_restrict) AND
              (location_id IN ( SELECT locitem_location_id
                                FROM locitem
                                WHERE (locitem_item_id=NEW.itemsite_item_id) ) ) ) ))) THEN
           RAISE EXCEPTION 'You must first create at least one valid
			  Location for this Item Site before it may be
		          multiply located.';
        END IF;
      END IF;
   
-- Update detail records based on control method changes 
      _wasLocationControl := OLD.itemsite_loccntrl;
      _isLocationControl := NEW.itemsite_loccntrl;
      _wasLotSerial := OLD.itemsite_controlmethod IN ('S','L');
      _isLotSerial := NEW.itemsite_controlmethod IN ('S','L'); 
      _wasPerishable := OLD.itemsite_perishable;
      _isPerishable := NEW.itemsite_perishable;
      _state := 0;
    
      IF ( (_wasLocationControl) AND (_isLocationControl) ) THEN
        _state := 10;
      ELSIF ( (NOT _wasLocationControl) AND (NOT _isLocationControl) ) THEN
        _state := 20;
      ELSIF ( (NOT _wasLocationControl) AND (_isLocationControl) ) THEN
        _state := 30;
      ELSIF ( (_wasLocationControl) AND (NOT _isLocationControl) ) THEN
        _state := 40;
      END IF;

      IF ( (_wasLotSerial) AND (_isLotSerial) ) THEN
        _state := _state + 1;
      ELSIF ( (NOT _wasLotSerial) AND (NOT _isLotSerial) ) THEN
        _state := _state + 2;
      ELSIF ( (NOT _wasLotSerial) AND (_isLotSerial) ) THEN
        _state := _state + 3;
      ELSIF ( (_wasLotSerial) AND (NOT _isLotSerial) ) THEN
        _state := _state + 4;
      END IF;

      IF ( (_application = 'Standard') AND (_state IN (41, 43, 14, 34, 24, 42, 44)) ) THEN
        -- Check for Reservations
        IF (SELECT COUNT(*) > 0
            FROM itemloc JOIN itemlocrsrv ON (itemlocrsrv_itemloc_id=itemloc_id)
            WHERE (itemloc_itemsite_id=OLD.itemsite_id)) THEN
          RAISE EXCEPTION 'Sales Order Reservations by Location exist for this Item Site';
        END IF;
      END IF;

      IF (_state IN (41, 43)) THEN
        PERFORM consolidateLotSerial(OLD.itemsite_id);
      ELSIF (_state IN (14, 34)) THEN
        PERFORM consolidateLocations(OLD.itemsite_id);
      ELSIF (_state IN (24, 42, 44)) THEN

        RAISE NOTICE 'Deleting item site detail records,';

        SELECT SUM(itemloc_qty) INTO _qty
        FROM itemloc, location
        WHERE ((itemloc_location_id=location_id)
        AND (NOT location_netable) 
        AND (itemloc_itemsite_id=OLD.itemsite_id));

        IF (_qty != 0) THEN
          UPDATE itemsite
          SET itemsite_qtyonhand = itemsite_qtyonhand + _qty,
            itemsite_nnqoh = itemsite_nnqoh - _qty
          WHERE (itemsite_id=OLD.itemsite_id);
        END IF;

        DELETE FROM itemloc
        WHERE (itemloc_itemsite_id=OLD.itemsite_id);
      END IF;

     IF (NEW.itemsite_qtyonhand != 0) THEN
--  Handle detail creation
--  Create itemloc records if they do not exist
       IF (_state IN (23, 32, 33)) THEN
          INSERT INTO itemloc 
            ( itemloc_itemsite_id, itemloc_location_id,
              itemloc_expiration, itemloc_qty )
            VALUES
            ( NEW.itemsite_id, -1,
              endOfTime(), NEW.itemsite_qtyonhand );
        END IF;

--  Handle Location distribution
        IF (_state IN (31, 32, 33, 34)) THEN
          IF (SELECT (COUNT(*)=1)
              FROM location
              WHERE ((location_id=NEW.itemsite_location_id)
              AND (location_warehous_id=NEW.itemsite_warehous_id)
              AND ( (NOT location_restrict) OR
                  ( (location_restrict) AND
                  (location_id IN ( SELECT locitem_location_id
                                    FROM locitem
                                    WHERE (locitem_item_id=NEW.itemsite_item_id) ) ) ) ))) THEN
           PERFORM initialDistribution(NEW.itemsite_id, NEW.itemsite_location_id);
          ELSE
            RAISE EXCEPTION 'A valid default location must be selected to distribute existing inventory to.';
          END IF;
        END IF;

--  Handle Lot/Serial distribution
        IF ( (_state = 13) OR (_state = 23) OR (_state = 33) OR (_state = 43) ) THEN
          RAISE NOTICE 'You should now use the Reassign Lot/Serial # window to assign Lot/Serial #s.';
        END IF;
      END IF;  
      IF (OLD.itemsite_costmethod='A' AND NEW.itemsite_costmethod='S') THEN
        -- TODO: Average costing cost method change
        SELECT stdcost(NEW.itemsite_item_id) * NEW.itemsite_qtyonhand
          INTO _cost;
        _variance := _cost - NEW.itemsite_value;
        NEW.itemsite_value := _cost;
        IF(_variance <> 0.0) THEN
          PERFORM insertGLTransaction( 'P/D', '', '', 'Itemsite converted from Average to Standard cost.',
                                       costcat_invcost_accnt_id, costcat_asset_accnt_id, NEW.itemsite_id,
                                      _variance, CURRENT_DATE )
             FROM costcat
            WHERE(costcat_id=NEW.itemsite_costcat_id);
          UPDATE itemsite SET itemsite_value = _cost WHERE (itemsite_id = NEW.itemsite_id);
        END IF;
      END IF;
    END IF;

--  Handle Perishable
    IF ( (_application = 'Standard') AND (_wasPerishable) AND (NOT _isPerishable) ) THEN
      UPDATE itemloc SET itemloc_expiration = endOfTime()
      WHERE (itemloc_itemsite_id = OLD.itemsite_id);
      PERFORM consolidateLotSerial(OLD.itemsite_id);
    END IF;

--  If Planning Type changed to None then delete all Planned Orders
    IF ( (_application = 'Standard') AND (TG_OP = 'UPDATE') ) THEN
      IF (NEW.itemsite_planning_type = 'N' AND OLD.itemsite_planning_type <> 'N') THEN
        PERFORM deletePlannedOrder(planord_id, TRUE)
        FROM planord
        WHERE (planord_itemsite_id=NEW.itemsite_id);
      END IF;
    END IF;
    
  END IF;  -- End Maintenance

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._itemsiteaftertrigger() OWNER TO admin;

--
-- Name: _itemsitetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemsitetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;
  _r RECORD;

BEGIN

  -- Cache some information
  SELECT item_type INTO _r
  FROM item
  WHERE (item_id=NEW.itemsite_item_id);
 
-- Override values to avoid invalid data combinations
  IF (_r.item_type IN ('J','R','S')) THEN
    NEW.itemsite_planning_type := 'N';
  END IF;

  IF (_r.item_type = 'L') THEN
    NEW.itemsite_planning_type := 'S';
  END IF;

  IF (TG_OP = 'UPDATE') THEN
    IF ( (NEW.itemsite_qtyonhand <> OLD.itemsite_qtyonhand) ) THEN
      IF (OLD.itemsite_freeze) THEN
        NEW.itemsite_qtyonhand := OLD.itemsite_qtyonhand;
      ELSE
        NEW.itemsite_datelastused := CURRENT_DATE;
      END IF;

      IF ( (NEW.itemsite_qtyonhand < 0) AND (OLD.itemsite_qtyonhand >= 0) AND (NEW.itemsite_eventfence > 0) ) THEN
        INSERT INTO evntlog
        ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
          evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id,
          evntlog_number )
        SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
               'I', NEW.itemsite_id, warehous_id,
               (item_number || '/' || warehous_code)
        FROM evntnot, evnttype, item, whsinfo
        WHERE ( (evntnot_evnttype_id=evnttype_id)
         AND (evntnot_warehous_id=NEW.itemsite_warehous_id)
         AND (NEW.itemsite_item_id=item_id)
         AND (NEW.itemsite_warehous_id=warehous_id)
         AND (evnttype_name='QOHBelowZero') );
      END IF;
    END IF;
    IF ( (NEW.itemsite_value <> OLD.itemsite_value) AND (OLD.itemsite_freeze) ) THEN
      NEW.itemsite_value := OLD.itemsite_value;
    END IF;
  END IF;

  IF (NEW.itemsite_qtyonhand < 0 AND NEW.itemsite_costmethod = 'A') THEN
    RAISE EXCEPTION 'Itemsite (%) is set to use average costing and is not allowed to have a negative quantity on hand.', NEW.itemsite_id;
  ELSIF (NEW.itemsite_value < 0 AND NEW.itemsite_costmethod = 'A') THEN
    RAISE EXCEPTION 'This transaction results in a negative itemsite value.  Itemsite (%) is set to use average costing and is not allowed to have a negative value.', NEW.itemsite_id;
  END IF;

--  Handle the ChangeLog
  IF ( SELECT (metric_value='t')
       FROM metric
       WHERE (metric_name='ItemSiteChangeLog') ) THEN

--  Cache the cmnttype_id for ChangeLog
    SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
    IF (FOUND) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'IS', NEW.itemsite_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN

        IF (OLD.itemsite_plancode_id <> NEW.itemsite_plancode_id) THEN
          PERFORM postComment( _cmnttypeid, 'IS', NEW.itemsite_id,
                               ( 'Planner Code Changed from "' || oldplancode.plancode_code ||
                                 '" to "' || newplancode.plancode_code || '"' ) )
          FROM plancode AS oldplancode, plancode AS newplancode
          WHERE ( (oldplancode.plancode_id=OLD.itemsite_plancode_id)
           AND (newplancode.plancode_id=NEW.itemsite_plancode_id) );
        END IF;

        IF (NEW.itemsite_reorderlevel <> OLD.itemsite_reorderlevel) THEN
          PERFORM postComment( _cmnttypeid, 'IS', NEW.itemsite_id,
                               ( 'Reorder Level Changed from ' || formatQty(OLD.itemsite_reorderlevel) ||
                                 ' to ' || formatQty(NEW.itemsite_reorderlevel ) ) );
        END IF;

        IF (NEW.itemsite_ordertoqty <> OLD.itemsite_ordertoqty) THEN
          PERFORM postComment( _cmnttypeid, 'IS', NEW.itemsite_id,
                               ( 'Order Up To Changed from ' || formatQty(OLD.itemsite_ordertoqty) ||
                                 ' to ' || formatQty(NEW.itemsite_ordertoqty ) ) );
        END IF;

        IF (NEW.itemsite_leadtime <> OLD.itemsite_leadtime) THEN
          PERFORM postComment( _cmnttypeid, 'IS', NEW.itemsite_id,
                               ( 'Itemsite Leadtime Changed from ' || formatQty(OLD.itemsite_leadtime) ||
                                 ' to ' || formatQty(NEW.itemsite_leadtime ) ) );
        END IF;

        IF (NEW.itemsite_abcclass <> OLD.itemsite_abcclass) THEN
          PERFORM postComment( _cmnttypeid, 'IS', NEW.itemsite_id,
                               ( 'Itemsite ABC Class Changed from ' || COALESCE(OLD.itemsite_abcclass, 'None') ||
                                 ' to ' || COALESCE(NEW.itemsite_abcclass,'None') ) );
        END IF;

        IF (NEW.itemsite_controlmethod <> OLD.itemsite_controlmethod) THEN
          PERFORM postComment( _cmnttypeid, 'IS', NEW.itemsite_id,
                               ( 'Itemsite Control Method Changed from ' || COALESCE(OLD.itemsite_controlmethod,'None') ||
                                 ' to ' || COALESCE(NEW.itemsite_controlmethod,'None') ) );
        END IF;

        IF (OLD.itemsite_sold <> NEW.itemsite_sold) THEN
          PERFORM postComment( _cmnttypeid, 'IS', NEW.itemsite_id,
            CASE WHEN (NEW.itemsite_sold) THEN 'Sold Changed from FALSE to TRUE'
                                          ELSE 'Sold Changed from TRUE to FALSE'
            END );
        END IF;

        IF (OLD.itemsite_active <> NEW.itemsite_active) THEN
          IF (NEW.itemsite_active) THEN
            PERFORM postComment(_cmnttypeid, 'IS', NEW.itemsite_id, 'Activated');
          ELSE
            PERFORM postComment(_cmnttypeid, 'IS', NEW.itemsite_id, 'Deactivated');
          END IF;
        END IF;

      END IF;
    END IF;
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._itemsitetrigger() OWNER TO admin;

--
-- Name: _itemsrcaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemsrcaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

-- Privilege Checks
  IF (NOT checkPrivilege('MaintainItemSources')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Item Sources.';
  END IF;

-- Set default to false for other item sources of this item
  IF (COALESCE(NEW.itemsrc_default, FALSE) = TRUE) THEN
    UPDATE itemsrc SET itemsrc_default = FALSE
    WHERE ( (itemsrc_item_id = NEW.itemsrc_item_id)
      AND (itemsrc_id <> NEW.itemsrc_id) );
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._itemsrcaftertrigger() OWNER TO admin;

--
-- Name: _itemsrcptrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemsrcptrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

-- Privilege Checks
   IF (NOT checkPrivilege('MaintainItemSources')) THEN
     RAISE EXCEPTION 'You do not have privileges to maintain Item Sources.';
   END IF;

-- Set defaults
   NEW.itemsrcp_curr_id	:= COALESCE(NEW.itemsrcp_curr_id,basecurrid());
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._itemsrcptrigger() OWNER TO admin;

--
-- Name: _itemsrctrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemsrctrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

-- Privilege Checks
   IF (NOT checkPrivilege('MaintainItemSources')) THEN
     RAISE EXCEPTION 'You do not have privileges to maintain Item Sources.';
   END IF;

-- Set defaults
   NEW.itemsrc_invvendoruomratio	:= COALESCE(NEW.itemsrc_invvendoruomratio,1);
   NEW.itemsrc_minordqty		:= COALESCE(NEW.itemsrc_minordqty,0);
   NEW.itemsrc_multordqty		:= COALESCE(NEW.itemsrc_multordqty,0);
   NEW.itemsrc_active			:= COALESCE(NEW.itemsrc_active,true);
   NEW.itemsrc_leadtime			:= COALESCE(NEW.itemsrc_leadtime,0);
   NEW.itemsrc_ranking			:= COALESCE(NEW.itemsrc_ranking,1);
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._itemsrctrigger() OWNER TO admin;

--
-- Name: _itemsubtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemsubtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

-- Privilege Checks
   IF (NOT checkPrivilege('MaintainItemMasters')) THEN
     RAISE EXCEPTION 'You do not have privileges to maintain Item Substitutes.';
   END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._itemsubtrigger() OWNER TO admin;

--
-- Name: _itemtaxtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemtaxtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

-- Privilege Checks
   IF (NOT checkPrivilege('MaintainItemMasters')) THEN
     RAISE EXCEPTION 'You do not have privileges to maintain Items.';
   END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._itemtaxtrigger() OWNER TO admin;

--
-- Name: _itemtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
 
-- Override values to avoid invalid data combinations
  IF (NEW.item_type IN ('R','S','O','L','B')) THEN
    NEW.item_picklist := FALSE;
  END IF;

  IF (NEW.item_type IN ('F','S','O','L','B')) THEN
    NEW.item_picklist := FALSE;
    NEW.item_sold := FALSE;
    NEW.item_prodcat_id := -1;
    NEW.item_exclusive := false;
    NEW.item_listprice := 0;
    NEW.item_upccode := '';
    NEW.item_prodweight := 0;
    NEW.item_packweight := 0;
  END IF;

  IF (NEW.item_type NOT IN ('M','R')) THEN
    NEW.item_config := false;
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._itemtrigger() OWNER TO admin;

--
-- Name: _itemuomconvtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _itemuomconvtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

-- Privilege Checks
   IF (NOT checkPrivilege('MaintainItemMasters')) THEN
     RAISE EXCEPTION 'You do not have privileges to maintain Items.';
   END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._itemuomconvtrigger() OWNER TO admin;

--
-- Name: _locationaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _locationaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _itemloc    RECORD;

BEGIN

  -- Maintain itemsite_qtyonhand and itemsite_nnqoh when location_netable changes
  IF (TG_OP = 'UPDATE') THEN
    IF (OLD.location_netable <> NEW.location_netable) THEN
      FOR _itemloc IN SELECT * FROM itemloc WHERE (itemloc_location_id=NEW.location_id) LOOP
        IF (NEW.location_netable) THEN
          UPDATE itemsite SET itemsite_qtyonhand = itemsite_qtyonhand + _itemloc.itemloc_qty,
                              itemsite_nnqoh = itemsite_nnqoh - _itemloc.itemloc_qty
          WHERE (itemsite_id=_itemloc.itemloc_itemsite_id);
        ELSE
          UPDATE itemsite SET itemsite_qtyonhand = itemsite_qtyonhand - _itemloc.itemloc_qty,
                              itemsite_nnqoh = itemsite_nnqoh + _itemloc.itemloc_qty
          WHERE (itemsite_id=_itemloc.itemloc_itemsite_id);
        END IF;
      END LOOP;
    END IF;
  END IF;
  
  RETURN NEW;

END;
$$;


ALTER FUNCTION public._locationaftertrigger() OWNER TO admin;

--
-- Name: _locationtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _locationtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check      BOOLEAN;
  _checkId    INTEGER;

BEGIN

  -- Checks
  -- Start with privileges
  IF (TG_OP = 'INSERT') THEN
    SELECT checkPrivilege('MaintainLocations') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to add new Locations.';
    END IF;
  ELSE
    SELECT checkPrivilege('MaintainLocations') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to alter a Location.';
    END IF;
  END IF;

  -- Code is required
  IF ( (LENGTH(COALESCE(NEW.location_name,''))=0) AND
       (LENGTH(COALESCE(NEW.location_aisle,''))=0) AND
       (LENGTH(COALESCE(NEW.location_rack,''))=0) AND
       (LENGTH(COALESCE(NEW.location_bin,''))=0) ) THEN
    RAISE EXCEPTION 'You must supply a valid Location Identifier.';
  END IF;
  
  -- Site is required
  IF (NEW.location_warehous_id IS NULL) THEN
    RAISE EXCEPTION 'You must supply a valid Site.';
  END IF;

  -- Location Identifier must be unique
  SELECT location_id INTO _checkId
  FROM location
  WHERE ( (UPPER(location_name)=UPPER(NEW.location_name))
    AND   (UPPER(location_aisle)=UPPER(NEW.location_aisle))
    AND   (UPPER(location_rack)=UPPER(NEW.location_rack))
    AND   (UPPER(location_bin)=UPPER(NEW.location_bin))
    AND   (location_warehous_id=NEW.location_warehous_id)
    AND   (location_id<>NEW.location_id) );
  IF (FOUND) THEN
    RAISE EXCEPTION 'You must supply a unique Location Identifier for this Site.';
  END IF;
  
  RETURN NEW;

END;
$$;


ALTER FUNCTION public._locationtrigger() OWNER TO admin;

--
-- Name: _metasqlaltertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _metasqlaltertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (NOT (isDBA() OR checkPrivilege('MaintainMetaSQL'))) THEN
    RAISE EXCEPTION '% does not have privileges to maintain MetaSQL statements in %.%',
                getEffectiveXtUser(), TG_TABLE_SCHEMA, TG_TABLE_NAME;
  END IF;

  IF ((TG_OP = 'UPDATE' OR TG_OP = 'DELETE')
      AND NEW.metasql_grade <= 0
      AND NOT isDBA()) THEN
    RAISE EXCEPTION 'You may not alter grade 0 metasql queries except using the xTuple Updater utility';
  END IF;

  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;

$$;


ALTER FUNCTION public._metasqlaltertrigger() OWNER TO admin;

--
-- Name: _metasqltrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _metasqltrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  NEW.metasql_lastuser 		:= getEffectiveXtUser();
  NEW.metasql_lastupdate 	:= current_date;
  RETURN NEW;

END;

$$;


ALTER FUNCTION public._metasqltrigger() OWNER TO admin;

--
-- Name: _opheadaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _opheadaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;
BEGIN
  IF (TG_OP = 'DELETE') THEN
    DELETE FROM docass WHERE docass_source_id = OLD.ophead_id AND docass_source_type = 'OPP';
    DELETE FROM docass WHERE docass_target_id = OLD.ophead_id AND docass_target_type = 'OPP';
  END IF;
  
  --  Comments
  IF ( SELECT (metric_value='t') FROM metric WHERE (metric_name='OpportunityChangeLog') ) THEN

    --  Cache the cmnttype_id for ChangeLog
    SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
    IF (FOUND) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'OPP', NEW.ophead_id, 'Created');

        --- clear the number from the issue cache
        PERFORM clearNumberIssue('OpportunityNumber', NEW.ophead_number);
      ELSIF (TG_OP = 'UPDATE') THEN
        IF (OLD.ophead_active <> NEW.ophead_active) THEN
          IF (NEW.ophead_active) THEN
            PERFORM postComment(_cmnttypeid, 'OPP', NEW.ophead_id, 'Activated');
          ELSE
            PERFORM postComment(_cmnttypeid, 'OPP', NEW.ophead_id, 'Deactivated');
          END IF;
        END IF;

        IF (OLD.ophead_name <> NEW.ophead_name) THEN
          PERFORM postComment( _cmnttypeid, 'OPP', NEW.ophead_id,
                               ( 'Name Changed from "' || OLD.ophead_name ||
                                 '" to "' || NEW.ophead_name || '"' ) );
        END IF;

        IF (OLD.ophead_owner_username <> NEW.ophead_owner_username) THEN
          PERFORM postComment( _cmnttypeid, 'OPP', NEW.ophead_id,
                               ( 'Owner Name Changed from "' || OLD.ophead_owner_username ||
                                 '" to "' || NEW.ophead_owner_username || '"' ) );
        END IF;

        IF (OLD.ophead_probability_prcnt <> NEW.ophead_probability_prcnt) THEN
          PERFORM postComment( _cmnttypeid, 'OPP', NEW.ophead_id,
                               ( 'Probability % Changed from "' || OLD.ophead_probability_prcnt ||
                                 '" to "' || NEW.ophead_probability_prcnt || '"' ) );
        END IF;

        IF (OLD.ophead_amount <> NEW.ophead_amount) THEN
          PERFORM postComment( _cmnttypeid, 'OPP', NEW.ophead_id,
                               ( 'Amount Changed from "' || OLD.ophead_amount ||
                                 '" to "' || NEW.ophead_amount || '"' ) );
        END IF;

        IF (OLD.ophead_target_date <> NEW.ophead_target_date) THEN
          PERFORM postComment( _cmnttypeid, 'OPP', NEW.ophead_id,
                               ( 'Target Date Changed from "' || OLD.ophead_target_date ||
                                 '" to "' || NEW.ophead_target_date || '"' ) );
        END IF;

        IF (OLD.ophead_actual_date <> NEW.ophead_actual_date) THEN
          PERFORM postComment( _cmnttypeid, 'OPP', NEW.ophead_id,
                               ( 'Actual Date Changed from "' || OLD.ophead_actual_date ||
                                 '" to "' || NEW.ophead_actual_date || '"' ) );
        END IF;

        IF (OLD.ophead_crmacct_id <> NEW.ophead_crmacct_id) THEN
          PERFORM postComment( _cmnttypeid, 'OPP', NEW.ophead_id,
                               ( 'CRM Account Changed from "' ||
                                 (SELECT crmacct_name FROM crmacct WHERE crmacct_id=OLD.ophead_crmacct_id) ||
                                 '" (' || OLD.ophead_crmacct_id ||
                                 ') to "' ||
                                 (SELECT crmacct_name FROM crmacct WHERE crmacct_id=NEW.ophead_crmacct_id) ||
                                 '" (' || NEW.ophead_crmacct_id || ')' ) );
        END IF;

        IF (OLD.ophead_curr_id <> NEW.ophead_curr_id) THEN
          PERFORM postComment( _cmnttypeid, 'OPP', NEW.ophead_id,
                               ( 'Currency Changed from "' ||
                                 (SELECT curr_name FROM curr_symbol WHERE curr_id=OLD.ophead_curr_id) ||
                                 '" (' || OLD.ophead_curr_id ||
                                 ') to "' ||
                                 (SELECT curr_name FROM curr_symbol WHERE curr_id=NEW.ophead_curr_id) ||
                                 '" (' || NEW.ophead_curr_id || ')' ) );
        END IF;

        IF (OLD.ophead_opstage_id <> NEW.ophead_opstage_id) THEN
          PERFORM postComment( _cmnttypeid, 'OPP', NEW.ophead_id,
                               ( 'Stage Changed from "' ||
                                 (SELECT opstage_name FROM opstage WHERE opstage_id=OLD.ophead_opstage_id) ||
                                 '" (' || OLD.ophead_opstage_id ||
                                 ') to "' ||
                                 (SELECT opstage_name FROM opstage WHERE opstage_id=NEW.ophead_opstage_id) ||
                                 '" (' || NEW.ophead_opstage_id || ')' ) );
        END IF;

        IF (OLD.ophead_opsource_id <> NEW.ophead_opsource_id) THEN
          PERFORM postComment( _cmnttypeid, 'OPP', NEW.ophead_id,
                               ( 'Source Changed from "' ||
                                 (SELECT opsource_name FROM opsource WHERE opsource_id=OLD.ophead_opsource_id) ||
                                 '" (' || OLD.ophead_opsource_id ||
                                 ') to "' ||
                                 (SELECT opsource_name FROM opsource WHERE opsource_id=NEW.ophead_opsource_id) ||
                                 '" (' || NEW.ophead_opsource_id || ')' ) );
        END IF;

        IF (OLD.ophead_optype_id <> NEW.ophead_optype_id) THEN
          PERFORM postComment( _cmnttypeid, 'OPP', NEW.ophead_id,
                               ( 'Type Changed from "' ||
                                 (SELECT optype_name FROM optype WHERE optype_id=OLD.ophead_optype_id) ||
                                 '" (' || OLD.ophead_optype_id ||
                                 ') to "' ||
                                 (SELECT optype_name FROM optype WHERE optype_id=NEW.ophead_optype_id) ||
                                 '" (' || NEW.ophead_optype_id || ')' ) );
        END IF;

      END IF;
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._opheadaftertrigger() OWNER TO admin;

--
-- Name: _opheadbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _opheadbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _rec record;
  _check boolean;
  _test text;
BEGIN

  IF(TG_OP = 'DELETE') THEN
    _rec := OLD;
  ELSE
    _rec := NEW;
  END IF;

  --  Auto inactivate
  IF (TG_OP = 'UPDATE') THEN
    IF ( (NEW.ophead_opstage_id != OLD.ophead_opstage_id) AND
         (SELECT opstage_opinactive FROM opstage WHERE opstage_id=NEW.ophead_opstage_id) ) THEN
      NEW.ophead_active := FALSE;
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._opheadbeforetrigger() OWNER TO admin;

--
-- Name: _packbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _packbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;
BEGIN
  SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
  IF (FOUND) THEN
    IF ((TG_OP = 'INSERT') AND (NEW.pack_head_id) IS NOT NULL)THEN
      PERFORM postComment(_cmnttypeid, 'S', NEW.pack_head_id, 'Added to Packing List Batch');
    END IF;
  END IF;
  IF ((TG_OP = 'INSERT') OR (TG_OP = 'UPDATE')) THEN
    IF (NEW.pack_shiphead_id IS NOT NULL
	 AND NEW.pack_shiphead_id NOT IN (SELECT shiphead_id
			       FROM shiphead
			       WHERE (shiphead_order_id=NEW.pack_head_id)
				 AND (shiphead_order_type=NEW.pack_head_type))) THEN
      RAISE EXCEPTION 'Shipment does not exist for % id %',
		      NEW.pack_head_type, NEW.pack_head_id;
      RETURN OLD;
    END IF;

    IF (NEW.pack_head_type = 'SO'
	AND NEW.pack_head_id   IN (SELECT cohead_id FROM cohead)) THEN
      RETURN NEW;

    ELSEIF (NEW.pack_head_type = 'TO') THEN
      IF (NOT fetchMetricBool('MultiWhs')) THEN
	RAISE EXCEPTION 'Transfer Orders are not supported by this version of the application';
      ELSEIF (NEW.pack_head_id IN (SELECT tohead_id FROM tohead)) THEN
	RETURN NEW;
      END IF;
    END IF;

    RAISE EXCEPTION '% with id % does not exist',
		    NEW.pack_head_type, NEW.pack_head_id;
    RETURN OLD;

  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._packbeforetrigger() OWNER TO admin;

--
-- Name: _periodaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _periodaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _idoffirst INTEGER;
  _test      INTEGER;
BEGIN
  -- This trigger can easily cause an infinite loop
  -- because of this we have to be very careful to not
  -- do an update on the period table if no updates
  -- are absolutely needed so we don't just keep
  -- trigger ourselves again and again

  -- Figure out which period is the first one
  SELECT period_id
    INTO _idoffirst
    FROM period
   ORDER BY period_start
   LIMIT 1;

  -- If we didn't find anything there is nothing to do
  IF( NOT FOUND ) THEN
    RETURN NEW;
  END IF;

  -- do a select to see if there is at least one record that needs to be
  -- updated. If we do not find any then we can just leave without
  -- causing a retrigger of ourselves
  SELECT period_id
    INTO _test
    FROM period
   WHERE((COALESCE(period_initial, true) AND (NOT period_id=_idoffirst))
      OR ((NOT COALESCE(period_initial, false)) AND (period_id=_idoffirst)))
   LIMIT 1;

  -- Nothing to update - get out of here
  IF( NOT FOUND ) THEN
    RETURN NEW;
  END IF;

  -- Update all the period records that already have the initial flag
  -- set and the one that we know should be the first.
  -- We don't have to be as careful here since we have already ruled
  -- out if don't need to update already.
  UPDATE period
     SET period_initial = (_idoffirst=period_id)
   WHERE((COALESCE(period_initial, true))
      OR (period_id=_idoffirst));

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._periodaftertrigger() OWNER TO admin;

--
-- Name: _pkgcmdaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgcmdaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgcmdaftertrigger() OWNER TO admin;

--
-- Name: _pkgcmdaltertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgcmdaltertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (pkgMayBeModified(TG_TABLE_SCHEMA)) THEN
    IF (TG_OP = 'DELETE') THEN
      RETURN OLD;
    ELSE
      RETURN NEW;
    END IF;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    RAISE EXCEPTION 'You may not create custom commands in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'UPDATE') THEN
    RAISE EXCEPTION 'You may not alter custom commands in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'DELETE') THEN
    RAISE EXCEPTION 'You may not delete custom commands from packages. Try deleting or disabling the package.';

  END IF;

  RETURN NEW;
END;

$$;


ALTER FUNCTION public._pkgcmdaltertrigger() OWNER TO admin;

--
-- Name: _pkgcmdargaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgcmdargaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgcmdargaftertrigger() OWNER TO admin;

--
-- Name: _pkgcmdargaltertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgcmdargaltertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (pkgMayBeModified(TG_TABLE_SCHEMA)) THEN
    IF (TG_OP = 'DELETE') THEN
      RETURN OLD;
    ELSE
      RETURN NEW;
    END IF;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    RAISE EXCEPTION 'You may not create command arguments in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'UPDATE') THEN
    RAISE EXCEPTION 'You may not alter command arguments in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'DELETE') THEN
    RAISE EXCEPTION 'You may not delete command arguments from packages. Try deleting or disabling the package.';

  END IF;

  RETURN NEW;
END;

$$;


ALTER FUNCTION public._pkgcmdargaltertrigger() OWNER TO admin;

--
-- Name: _pkgcmdargbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgcmdargbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmdargid     INTEGER;
  _debug        BOOL := false;

BEGIN
  IF (TG_OP = 'UPDATE') THEN
    RETURN NEW;

  ELSIF (TG_OP = 'INSERT') THEN
    RETURN NEW;

  ELSIF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgcmdargbeforetrigger() OWNER TO admin;

--
-- Name: _pkgcmdbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgcmdbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmdid       INTEGER;
  _debug        BOOL := false;

BEGIN
    IF (TG_OP = 'UPDATE') THEN
      IF (_debug) THEN
        RAISE NOTICE 'OLD.cmd_name %, NEW.cmd_name %',
                     OLD.cmd_name, NEW.cmd_name;
      END IF;

      IF (NEW.cmd_name != OLD.cmd_name) THEN
        SELECT cmd_id INTO _cmdid FROM cmd WHERE cmd_name=NEW.cmd_name;
        IF (FOUND) THEN
          RAISE EXCEPTION 'Cannot change command name % because another command with that name already exists.', NEW.cmd_name;
        END IF;
      END IF;

    ELSIF (TG_OP = 'INSERT') THEN
      IF (_debug) THEN
        RAISE NOTICE 'inserting NEW.cmd_name %', NEW.cmd_name;
      END IF;
      SELECT cmd_id INTO _cmdid FROM cmd WHERE cmd_name=NEW.cmd_name;
      IF (FOUND) THEN
        RAISE EXCEPTION 'Cannot create new command % because another command with that name already exists.', NEW.cmd_name;
      END IF;

    ELSIF (TG_OP = 'DELETE') THEN
      DELETE FROM cmdarg WHERE cmdarg_cmd_id=OLD.cmd_id;

      RETURN OLD;
    END IF;

    RETURN NEW;
  END;
$$;


ALTER FUNCTION public._pkgcmdbeforetrigger() OWNER TO admin;

--
-- Name: _pkgheadbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgheadbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
  DECLARE
    _r    RECORD;

  BEGIN
    IF (TG_OP = 'UPDATE') THEN
      NEW.pkghead_created := OLD.pkghead_created;
      NEW.pkghead_updated := CURRENT_TIMESTAMP;
      IF (NEW.pkghead_indev AND NOT userCanCreateUsers(getEffectiveXtUser())) THEN
        NEW.pkghead_indev = FALSE;
      END IF;

    ELSIF (TG_OP = 'INSERT') THEN
      NEW.pkghead_created := CURRENT_TIMESTAMP;
      NEW.pkghead_updated := NEW.pkghead_created;
      IF (NEW.pkghead_indev AND NOT userCanCreateUsers(getEffectiveXtUser())) THEN
        NEW.pkghead_indev = FALSE;
      END IF;

    ELSIF (TG_OP = 'DELETE') THEN
      DELETE FROM pkgdep WHERE pkgdep_pkghead_id=OLD.pkghead_id;

      EXECUTE 'DROP SCHEMA ' || OLD.pkghead_name || ' CASCADE';

      RETURN OLD;
    END IF;

    RETURN NEW;
  END;
$$;


ALTER FUNCTION public._pkgheadbeforetrigger() OWNER TO admin;

--
-- Name: _pkgimageaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgimageaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgimageaftertrigger() OWNER TO admin;

--
-- Name: _pkgimagealtertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgimagealtertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (pkgMayBeModified(TG_TABLE_SCHEMA)) THEN
    IF (TG_OP = 'DELETE') THEN
      RETURN OLD;
    ELSE
      RETURN NEW;
    END IF;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    RAISE EXCEPTION 'You may not create images in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'UPDATE') THEN
    RAISE EXCEPTION 'You may not alter images in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'DELETE') THEN
    RAISE EXCEPTION 'You may not delete images from packages. Try deleting or disabling the package.';

  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgimagealtertrigger() OWNER TO admin;

--
-- Name: _pkgimagebeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgimagebeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _imageid     INTEGER;
  _debug       BOOL := false;

BEGIN
  IF (TG_OP = 'UPDATE') THEN
    IF (_debug) THEN
      RAISE NOTICE 'OLD.image_name %, NEW.image_name %',
                   OLD.image_name, NEW.image_name;
    END IF;

    IF (NEW.image_name != OLD.image_name) THEN
      SELECT image_id INTO _imageid FROM image WHERE image_name=NEW.image_name;
      IF (FOUND) THEN
        RAISE EXCEPTION 'Cannot change image named % because another image with that name already exists.', NEW.image_name;
      END IF;
    END IF;

  ELSIF (TG_OP = 'INSERT') THEN
    IF (_debug) THEN
      RAISE NOTICE 'inserting NEW.image_name %', NEW.image_name;
    END IF;
    SELECT image_id INTO _imageid FROM image WHERE image_name=NEW.image_name;
    IF (FOUND) THEN
      RAISE EXCEPTION 'Cannot create new image % because another image with that name already exists.', NEW.image_name;
    END IF;

  ELSIF (TG_OP = 'DELETE') THEN
    RETURN OLD;

  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgimagebeforetrigger() OWNER TO admin;

--
-- Name: _pkgitembeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgitembeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
  DECLARE
    _functionargs TEXT;
    _group        TEXT;
    _object       TEXT;
    _schema       TEXT;
    _debug        BOOL := false;
  BEGIN
    IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN
      _object = NEW.pkgitem_name;

      SELECT LOWER(pkghead_name) INTO _schema
      FROM pkghead
      WHERE (pkghead_id=NEW.pkgitem_pkghead_id);
      IF (NOT FOUND) THEN
        _schema := 'public';
      END IF;

      IF (NEW.pkgitem_type = 'F') THEN
        _object := SPLIT_PART(_object, '(', 1);
      ELSIF (NEW.pkgitem_type = 'M') THEN
        _group  := SPLIT_PART(_object, '-', 1);
        _object := SPLIT_PART(_object, '-', 2);
      END IF;
      IF _debug THEN
        RAISE NOTICE '_schema % and _object %', _schema, _object;
      END IF;

      IF (NEW.pkgitem_type = 'C') THEN
        IF (NOT EXISTS(SELECT script_id
                       FROM script
                       WHERE ((script_id=NEW.pkgitem_item_id)
                          AND (script_name=NEW.pkgitem_name)))) THEN
          RAISE EXCEPTION 'Cannot create Script % as a Package Item without a corresponding script record.',
            NEW.pkgitem_name;
        END IF;

      ELSIF (NEW.pkgitem_type = 'D') THEN
        IF (NOT EXISTS(SELECT cmd_id
                       FROM cmd
                       WHERE ((cmd_id=NEW.pkgitem_item_id)
                          AND (cmd_name=NEW.pkgitem_name)))) THEN
          RAISE EXCEPTION 'Cannot create Custom Command % as a Package Item without a corresponding cmd record.',
            NEW.pkgitem_name;
        END IF;

      ELSIF (NEW.pkgitem_type = 'F') THEN
        IF (NOT EXISTS(SELECT pg_proc.oid
                       FROM pg_proc, pg_namespace
                       WHERE ((pg_proc.oid=NEW.pkgitem_item_id)
                          AND (proname = (_object))
                          AND (pronamespace=pg_namespace.oid)
                          AND (nspname=_schema)) )) THEN
          RAISE EXCEPTION 'Cannot create Function % (oid %) as a Package Item without a corresponding function in the database.',
                          NEW.pkgitem_name, NEW.pkgitem_item_id;
        END IF;

      ELSIF (NEW.pkgitem_type = 'G') THEN
        IF (NOT EXISTS(SELECT pg_class.oid
                     FROM pg_trigger, pg_class, pg_namespace
                     WHERE ((tgname=_object)
                        AND (tgrelid=pg_class.oid)
                        AND (relnamespace=pg_namespace.oid)
                        AND (nspname=_schema)))) THEN
          RAISE EXCEPTION 'Cannot create Trigger % as a Package Item without a corresponding trigger in the database.',
            NEW.pkgitem_name;
        END IF;

      ELSIF (NEW.pkgitem_type = 'I') THEN
        IF (NOT EXISTS(SELECT image_id
                       FROM image
                       WHERE ((image_id=NEW.pkgitem_item_id)
                          AND (image_name=NEW.pkgitem_name)))) THEN
          RAISE EXCEPTION 'Cannot create Image % as a Package Item without a corresponding image record.',
            NEW.pkgitem_name;
        END IF;

      ELSIF (NEW.pkgitem_type = 'M') THEN
        IF (NOT EXISTS(SELECT metasql_id
                       FROM metasql
                       WHERE ((metasql_id=NEW.pkgitem_item_id)
                          AND (metasql_group=_group)
                          AND (metasql_name=_object)))) THEN
          RAISE EXCEPTION 'Cannot create MetaSQL statement % as a Package Item without a corresponding metasql record.',
            NEW.pkgitem_name;
        END IF;

      ELSIF (NEW.pkgitem_type = 'P') THEN
        IF (NOT EXISTS(SELECT priv_id
                       FROM priv
                       WHERE ((priv_id=NEW.pkgitem_item_id)
                          AND (priv_name=NEW.pkgitem_name)))) THEN
          RAISE EXCEPTION 'Cannot create Privilege % as a Package Item without a corresponding priv record.',
            NEW.pkgitem_name;
        END IF;

      ELSIF (NEW.pkgitem_type = 'R') THEN
        IF (NOT EXISTS(SELECT report_id
                       FROM report
                       WHERE ((report_id=NEW.pkgitem_item_id)
                          AND (report_name=NEW.pkgitem_name)))) THEN
          RAISE EXCEPTION 'Cannot create Report % as a Package Item without a corresponding report record.',
            NEW.pkgitem_name;
        END IF;

      ELSIF (NEW.pkgitem_type = 'S') THEN
        IF (NOT EXISTS(SELECT oid
                       FROM pg_namespace
                       WHERE (LOWER(nspname)=LOWER(NEW.pkgitem_name)))) THEN
          RAISE EXCEPTION 'Cannot create Schema % as a Package Item without a corresponding schema in the database.',
            NEW.pkgitem_name;
        END IF;

      ELSIF (NEW.pkgitem_type = 'T') THEN
        IF (NOT EXISTS(SELECT pg_class.oid
                     FROM pg_class, pg_namespace
                     WHERE ((relname=_object)
                        AND (relnamespace=pg_namespace.oid)
                        AND (relkind='r')
                        AND (nspname=_schema)))) THEN
          RAISE EXCEPTION 'Cannot create Table % as a Package Item without a corresponding table in the database.',
            NEW.pkgitem_name;
        END IF;

      ELSIF (NEW.pkgitem_type = 'U') THEN
        IF (NOT EXISTS(SELECT uiform_id
                       FROM uiform
                       WHERE ((uiform_id=NEW.pkgitem_item_id)
                          AND (uiform_name=NEW.pkgitem_name)))) THEN
          RAISE EXCEPTION 'Cannot create User Interface Form % as a Package Item without a corresponding uiform record.',
            NEW.pkgitem_name;
        END IF;

      ELSIF (NEW.pkgitem_type = 'V') THEN
        IF (NOT EXISTS(SELECT pg_class.oid
                     FROM pg_class, pg_namespace
                     WHERE ((relname=_object)
                        AND (relnamespace=pg_namespace.oid)
                        AND (relkind='v')
                        AND (nspname=_schema)))) THEN
          RAISE EXCEPTION 'Cannot create View % as a Package Item without a corresponding view in the database.',
            NEW.pkgitem_name;
        END IF;

      ELSE
        RAISE EXCEPTION '"%" is not a valid type of package item.',
          NEW.pkgitem_type;
      END IF;

    ELSIF (TG_OP = 'DELETE') THEN
      IF _debug THEN RAISE NOTICE 'Deleting % % %', OLD.pkgitem_item_id, OLD.pkgitem_name, OLD.pkgitem_type; END IF;

      _object = OLD.pkgitem_name;

      SELECT pkghead_name INTO _schema
      FROM pkghead
      WHERE (pkghead_id=OLD.pkgitem_pkghead_id);
      IF (NOT FOUND) THEN
        _schema := 'public';
      END IF;

      IF (OLD.pkgitem_type = 'F') THEN
        _object := SPLIT_PART(_object, '(', 1);
      ELSIF (OLD.pkgitem_type = 'M') THEN
        _group  := SPLIT_PART(_object, '-', 1);
        _object := SPLIT_PART(_object, '-', 2);
      END IF;
      IF _debug THEN
        RAISE NOTICE '_schema % and _object %', _schema, _object;
      END IF;

      IF (OLD.pkgitem_type = 'C') THEN
        DELETE FROM script WHERE ((script_id=OLD.pkgitem_item_id)
                              AND (script_name=OLD.pkgitem_name));

      ELSIF (OLD.pkgitem_type = 'D') THEN
        DELETE FROM cmd
          WHERE ((cmd_id=OLD.pkgitem_item_id)
            AND  (cmd_name=OLD.pkgitem_name));

      ELSIF (OLD.pkgitem_type = 'F') THEN
        -- SELECT dropIfExists('FUNCTION', CAST (oid::regprocedure AS TEXT), _schema)
        PERFORM dropIfExists('FUNCTION',
                            proname || '(' ||
                            oidvectortypes(proargtypes) || ')',
                            _schema)
        FROM pg_proc
        WHERE (oid=OLD.pkgitem_item_id);

      ELSIF (OLD.pkgitem_type = 'G') THEN
        PERFORM dropIfExists('TRIGGER', _object, _schema);

      ELSIF (OLD.pkgitem_type = 'I') THEN
        DELETE FROM image WHERE ((image_id=OLD.pkgitem_item_id)
                             AND (image_name=OLD.pkgitem_name));

      ELSIF (OLD.pkgitem_type = 'M') THEN
        DELETE FROM metasql WHERE ((metasql_id=OLD.pkgitem_item_id)
                               AND (metasql_group=_group)
                               AND (metasql_name=_object));

      ELSIF (OLD.pkgitem_type = 'P') THEN
        DELETE FROM priv
        WHERE ((priv_id=OLD.pkgitem_item_id) 
           AND (priv_name=OLD.pkgitem_name));

      ELSIF (OLD.pkgitem_type = 'R') THEN
        DELETE FROM report
        WHERE ((report_id=OLD.pkgitem_item_id)
           AND (report_name=OLD.pkgitem_name));

      ELSIF (OLD.pkgitem_type = 'S') THEN
        PERFORM dropIfExists('SCHEMA', OLD.pkgitem_name, OLD.pkgitem_name);

      ELSIF (OLD.pkgitem_type = 'T') THEN
        PERFORM dropIfExists('TABLE', _object, _schema, true);

      ELSIF (OLD.pkgitem_type = 'U') THEN
        DELETE FROM uiform
        WHERE ((uiform_id=OLD.pkgitem_item_id)
           AND (uiform_name=OLD.pkgitem_name));

      ELSIF (OLD.pkgitem_type = 'V') THEN
        PERFORM dropIfExists('VIEW', _object, _schema, true);

      ELSE
        RAISE EXCEPTION '"%" is not a valid type of package item.',
          OLD.pkgitem_type;
      END IF;
      RETURN OLD;
    END IF;

    RETURN NEW;
  END;
$$;


ALTER FUNCTION public._pkgitembeforetrigger() OWNER TO admin;

--
-- Name: _pkgmetasqlaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgmetasqlaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgmetasqlaftertrigger() OWNER TO admin;

--
-- Name: _pkgmetasqlaltertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgmetasqlaltertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _isdba        BOOLEAN := false;

BEGIN
  SELECT rolsuper INTO _isdba FROM pg_roles WHERE (rolname=getEffectiveXtUser());

  IF (pkgMayBeModified(TG_TABLE_SCHEMA)) THEN
    IF (TG_OP = 'DELETE') THEN
      RETURN OLD;
    ELSE
      RETURN NEW;
    END IF;
  END IF;

  -- cannot combine IF's because plpgsql does not always evaluate left-to-right
  IF (TG_OP = 'INSERT') THEN
    IF (NEW.metasql_grade <= 0 AND NOT _isdba) THEN
      RAISE EXCEPTION 'You may not create grade 0 MetaSQL statements in packages except using the xTuple Updater utility';
    END IF;

  ELSIF (TG_OP = 'UPDATE') THEN
    IF (NEW.metasql_grade <= 0 AND NOT _isdba) THEN
      RAISE EXCEPTION 'You may not alter grade 0 MetaSQL statements in packages except using the xTuple Updater utility';
    END IF;

  ELSIF (TG_OP = 'DELETE') THEN
    IF (OLD.metasql_grade <= 0 AND NOT _isdba) THEN
      RAISE EXCEPTION 'You may not delete grade 0 MetaSQL statements from packages. Try deleting or disabling the package.';
    ELSE
      RETURN OLD;
    END IF;

  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgmetasqlaltertrigger() OWNER TO admin;

--
-- Name: _pkgmetasqlbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgmetasqlbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _metasqlid    INTEGER;
  _isdba        BOOLEAN := false;

BEGIN
  SELECT rolsuper INTO _isdba FROM pg_roles WHERE (rolname=getEffectiveXtUser());

  IF (NOT (_isdba OR checkPrivilege('MaintainMetaSQL'))) THEN
    RAISE EXCEPTION '% does not have privileges to maintain MetaSQL statements in %.% (DBA=%)',
                getEffectiveXtUser(), TG_TABLE_SCHEMA, TG_TABLE_NAME, _isdba;
  END IF;

  IF (TG_OP = 'UPDATE') THEN
    RAISE DEBUG 'update OLD %-%-%, NEW %-%-%',
                 OLD.metasql_group, OLD.metasql_name, OLD.metasql_grade,
                 NEW.metasql_group, NEW.metasql_name, NEW.metasql_grade;

    IF (NEW.metasql_name != OLD.metasql_name OR NEW.metasql_group != OLD.metasql_group OR NEW.metasql_grade != OLD.metasql_grade) THEN
      SELECT metasql_id INTO _metasqlid
      FROM metasql
      WHERE metasql_name=NEW.metasql_name AND metasql_group=NEW.metasql_group AND metasql_grade=NEW.metasql_grade;
      IF (FOUND) THEN
        RAISE EXCEPTION 'Cannot change the MetaSQL statement named %-%-% because another MetaSQL statement with that group, name and grade already exists.', NEW.metasql_group, NEW.metasql_name, NEW.metasql_grade;
      END IF;
    END IF;

  ELSIF (TG_OP = 'INSERT') THEN
    RAISE DEBUG 'insert NEW %-% %',
                 NEW.metasql_group, NEW.metasql_name, NEW.metasql_grade;
    SELECT metasql_id INTO _metasqlid
    FROM metasql
    WHERE metasql_name=NEW.metasql_name AND metasql_group=NEW.metasql_group AND metasql_grade=NEW.metasql_grade;
    IF (FOUND) THEN
      RAISE EXCEPTION 'The new MetaSQL statement %-% % conflicts with an existing statement.',
                      NEW.metasql_group, NEW.metasql_name, NEW.metasql_grade;
    END IF;

  ELSIF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgmetasqlbeforetrigger() OWNER TO admin;

--
-- Name: _pkgprivaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgprivaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgprivaftertrigger() OWNER TO admin;

--
-- Name: _pkgprivaltertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgprivaltertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (pkgMayBeModified(TG_TABLE_SCHEMA)) THEN
    IF (TG_OP = 'DELETE') THEN
      RETURN OLD;
    ELSE
      RETURN NEW;
    END IF;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    RAISE EXCEPTION 'You may not create privileges in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'UPDATE') THEN
    RAISE EXCEPTION 'You may not alter privileges in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'DELETE') THEN
    RAISE EXCEPTION 'You may not delete privileges from packages. Try deleting or disabling the package.';

  END IF;

  RETURN NEW;
END;

$$;


ALTER FUNCTION public._pkgprivaltertrigger() OWNER TO admin;

--
-- Name: _pkgprivbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgprivbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _privid       INTEGER;
  _debug        BOOL := false;

BEGIN
  IF (TG_OP = 'UPDATE') THEN
    IF (_debug) THEN
      RAISE NOTICE 'OLD.priv_name %, NEW.priv_name %',
                   OLD.priv_name, NEW.priv_name;
    END IF;

    IF (NEW.priv_name != OLD.priv_name) THEN
      SELECT priv_id INTO _privid FROM priv WHERE priv_name=NEW.priv_name;
      IF (FOUND) THEN
        RAISE EXCEPTION 'Cannot change privilege name % because another privilege with that name already exists.', NEW.priv_name;
      END IF;
    END IF;

  ELSIF (TG_OP = 'INSERT') THEN
    IF (_debug) THEN
      RAISE NOTICE 'inserting NEW.priv_name %', NEW.priv_name;
    END IF;
    SELECT priv_id INTO _privid FROM priv WHERE priv_name=NEW.priv_name;
    IF (FOUND) THEN
      RAISE EXCEPTION 'Cannot create new privilege % because another privilege with that name already exists.', NEW.priv_name;
    END IF;

  ELSIF (TG_OP = 'DELETE') THEN
    IF (_debug) THEN RAISE NOTICE 'deleting pkgpriv_id %', OLD.priv_id; END IF;
    DELETE FROM usrpriv WHERE usrpriv_priv_id=OLD.priv_id;
    DELETE FROM grppriv WHERE grppriv_priv_id=OLD.priv_id;

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgprivbeforetrigger() OWNER TO admin;

--
-- Name: _pkgreportaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgreportaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgreportaftertrigger() OWNER TO admin;

--
-- Name: _pkgreportaltertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgreportaltertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (pkgMayBeModified(TG_TABLE_SCHEMA)) THEN
    IF (TG_OP = 'DELETE') THEN
      RETURN OLD;
    ELSE
      RETURN NEW;
    END IF;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    RAISE EXCEPTION 'You may not create report definitions in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'UPDATE') THEN
    RAISE EXCEPTION 'You may not alter report definitions in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'DELETE') THEN
    RAISE EXCEPTION 'You may not delete report definitions from packages. Try deleting or disabling the package.';

  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgreportaltertrigger() OWNER TO admin;

--
-- Name: _pkgreportbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgreportbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _reportid     INTEGER;
  _debug        BOOL := false;

BEGIN
  IF (TG_OP = 'UPDATE') THEN
    IF (_debug) THEN
      RAISE NOTICE 'update OLD % %, NEW % %',
                   OLD.report_name, OLD.report_grade, NEW.report_name, NEW.report_grade;
    END IF;

    IF (NEW.report_name != OLD.report_name) THEN
      SELECT report_id INTO _reportid
      FROM report
      WHERE ((report_name=NEW.report_name)
        AND  (report_grade=NEW.report_grade));
      IF (FOUND) THEN
        RAISE EXCEPTION 'Cannot change report % % because another report with that name and grade already exists.', NEW.report_name, NEW.report_grade;
      END IF;
    END IF;

  ELSIF (TG_OP = 'INSERT') THEN
    IF (_debug) THEN
      RAISE NOTICE 'insert NEW % %', NEW.report_name, NEW.report_grade;
    END IF;
    SELECT report_id INTO _reportid
    FROM report
    WHERE ((report_name=NEW.report_name)
      AND  (report_grade=NEW.report_grade));
    IF (FOUND) THEN
      RAISE EXCEPTION 'Cannot create new report % % because another report with that name and grade already exists.', NEW.report_name, NEW.report_grade;
    END IF;

  ELSIF (TG_OP = 'DELETE') THEN

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgreportbeforetrigger() OWNER TO admin;

--
-- Name: _pkgscriptaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgscriptaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgscriptaftertrigger() OWNER TO admin;

--
-- Name: _pkgscriptaltertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgscriptaltertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (pkgMayBeModified(TG_TABLE_SCHEMA)) THEN
    IF (TG_OP = 'DELETE') THEN
      RETURN OLD;
    ELSE
      RETURN NEW;
    END IF;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    RAISE EXCEPTION 'You may not create scripts in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'UPDATE') THEN
    RAISE EXCEPTION 'You may not alter scripts in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'DELETE') THEN
    RAISE EXCEPTION 'You may not delete scripts from packages. Try deleting or disabling the package.';

  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgscriptaltertrigger() OWNER TO admin;

--
-- Name: _pkgscriptbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkgscriptbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _scriptid     INTEGER;
  _debug        BOOL := false;

BEGIN
  IF (TG_OP = 'UPDATE') THEN
    RETURN NEW;

  ELSIF (TG_OP = 'INSERT') THEN
    RETURN NEW;

  ELSIF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkgscriptbeforetrigger() OWNER TO admin;

--
-- Name: _pkguiformaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkguiformaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkguiformaftertrigger() OWNER TO admin;

--
-- Name: _pkguiformaltertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkguiformaltertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (pkgMayBeModified(TG_TABLE_SCHEMA)) THEN
    IF (TG_OP = 'DELETE') THEN
      RETURN OLD;
    ELSE
      RETURN NEW;
    END IF;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    RAISE EXCEPTION 'You may not create forms in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'UPDATE') THEN
    RAISE EXCEPTION 'You may not alter forms in packages except using the xTuple Updater utility';

  ELSIF (TG_OP = 'DELETE') THEN
    RAISE EXCEPTION 'You may not delete forms from packages. Try deleting or disabling the package.';

  END IF;

  RETURN NEW;
END;

$$;


ALTER FUNCTION public._pkguiformaltertrigger() OWNER TO admin;

--
-- Name: _pkguiformbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _pkguiformbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _uiformid     INTEGER;
  _debug        BOOL := false;

BEGIN
  IF (TG_OP = 'UPDATE') THEN
    RETURN NEW;

  ELSIF (TG_OP = 'INSERT') THEN
    RETURN NEW;

  ELSIF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._pkguiformbeforetrigger() OWNER TO admin;

--
-- Name: _poheadtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _poheadtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid 	INTEGER;
  _check	BOOLEAN;
  _maint        BOOLEAN := TRUE;

BEGIN

-- Check if we are doing maintenance
  IF (TG_OP = 'UPDATE') THEN
    IF ( (OLD.pohead_status           != NEW.pohead_status) OR
         (OLD.pohead_printed          != NEW.pohead_printed) ) THEN
      _maint := FALSE;
    END IF;
  END IF;

  -- Check
  IF ( (NOT _maint) AND (NOT checkPrivilege('MaintainPurchaseOrders'))
                    AND (NOT checkPrivilege('PostPurchaseOrders'))
                    AND (NOT checkPrivilege('PrintPurchaseOrders'))
                    AND (NOT checkPrivilege('PostVouchers')) ) THEN
    RAISE EXCEPTION 'You do not have privileges to alter a Purchase Order.';
  END IF;

  IF ( _maint AND (NOT checkPrivilege('MaintainPurchaseOrders')) ) THEN
    RAISE EXCEPTION 'You do not have privileges to alter a Purchase Order.';
  END IF;

  IF (TG_OP = 'INSERT') THEN
    --- clear the number from the issue cache
    PERFORM clearNumberIssue('PoNumber', NEW.pohead_number);
  END IF;

  IF ( (TG_OP = 'INSERT') OR (TG_op = 'UPDATE') ) THEN
    IF (NOT ISNUMERIC(NEW.pohead_number) AND NEW.pohead_saved) THEN
      RAISE EXCEPTION 'Purchase Order Number must be numeric.';
    END IF;
  END IF;

  IF ( SELECT (metric_value='t')
       FROM metric
       WHERE (metric_name='POChangeLog') ) THEN

--  Cache the cmnttype_id for ChangeLog
    SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
    IF (FOUND) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'P', NEW.pohead_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN
        IF (OLD.pohead_terms_id <> NEW.pohead_terms_id) THEN
          PERFORM postComment( _cmnttypeid, 'P', NEW.pohead_id,
                               ('Terms Changed from "' || oldterms.terms_code || '" to "' || newterms.terms_code || '"') )
          FROM terms AS oldterms, terms AS newterms
          WHERE ( (oldterms.terms_id=OLD.pohead_terms_id)
           AND (newterms.terms_id=NEW.pohead_terms_id) );
        END IF;

      ELSIF (TG_OP = 'DELETE') THEN
        DELETE FROM docass WHERE docass_source_id = OLD.pohead_id AND docass_source_type = 'P';
        DELETE FROM docass WHERE docass_target_id = OLD.pohead_id AND docass_target_type = 'P';
        
        DELETE FROM comment
        WHERE ( (comment_source='P')
         AND (comment_source_id=OLD.pohead_id) );
      END IF;
    END IF;
  END IF;

  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  ELSE
    RETURN NEW;
  END IF;

END;
$$;


ALTER FUNCTION public._poheadtrigger() OWNER TO admin;

--
-- Name: _poheadtriggerafter(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _poheadtriggerafter() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (COALESCE(NEW.pohead_taxzone_id,-1) <> COALESCE(OLD.pohead_taxzone_id,-1)) THEN
    UPDATE poitem SET poitem_taxtype_id=getItemTaxType(itemsite_item_id,NEW.pohead_taxzone_id)
    FROM itemsite 
    WHERE ((itemsite_id=poitem_itemsite_id)
     AND (poitem_pohead_id=NEW.pohead_id));
  END IF;

  -- Do not update closed poitems
  IF (TG_OP = 'UPDATE') THEN
    IF (OLD.pohead_status != NEW.pohead_status) THEN
      UPDATE poitem
      SET poitem_status=NEW.pohead_status
      WHERE ( (poitem_pohead_id=NEW.pohead_id)
        AND   (poitem_status <> 'C') );
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._poheadtriggerafter() OWNER TO admin;

--
-- Name: _poitemtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _poitemtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid 	INTEGER;
  _status      	CHAR(1);
  _check      	BOOLEAN;
  _cnt     	INTEGER;
  _s 		RECORD;
BEGIN

  -- Check
  IF ( (TG_OP = 'UPDATE') AND
       (NOT checkPrivilege('MaintainPurchaseOrders')) AND
       (NOT checkPrivilege('ChangePurchaseOrderQty')) AND
       (NOT checkPrivilege('EnterReceipts')) AND
       (NOT checkPrivilege('PostVouchers')) ) THEN
    RAISE EXCEPTION 'You do not have privileges to alter a Purchase Order.';
  END IF;
  IF ( ( (TG_OP = 'INSERT') OR (TG_OP = 'DELETE') ) AND (NOT checkPrivilege('MaintainPurchaseOrders')) ) THEN
    RAISE EXCEPTION 'You do not have privileges to alter a Purchase Order.';
  END IF;

  IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN
    SELECT pohead_status INTO _status
    FROM pohead
    WHERE (pohead_id=NEW.poitem_pohead_id);

    IF (NEW.poitem_itemsite_id=-1) THEN
      NEW.poitem_itemsite_id := NULL;
    END IF;
    IF (NEW.poitem_expcat_id=-1) THEN
      NEW.poitem_expcat_id := NULL;
    END IF;

    IF (NEW.poitem_itemsite_id IS NOT NULL AND NEW.poitem_expcat_id IS NOT NULL) THEN
      RAISE EXCEPTION 'A purchase order line may not include both an inventory and non-inventory item';
    ELSIF (NEW.poitem_itemsite_id IS NULL AND NEW.poitem_expcat_id IS NULL) THEN
      RAISE EXCEPTION 'A purchase order line must specify either an inventory item or a non-inventory expense category';
    ELSIF (NEW.poitem_qty_ordered IS NULL) THEN
      RAISE EXCEPTION 'A purchase order line must specify a quantity';
    ELSIF (COALESCE(NEW.poitem_itemsite_id,-1) != -1) THEN
      SELECT (COUNT(item_id)=1) INTO _check
      FROM itemsite, item
      WHERE ((itemsite_id=NEW.poitem_itemsite_id)
      AND (itemsite_item_id=item_id)
      AND (item_type IN ('P','O','M','T')));
      IF NOT (_check) THEN
        RAISE EXCEPTION 'The item is not a purchasable item type';
      END IF;
    END IF;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    IF (_status='C') THEN
      RAISE EXCEPTION 'New lines may not be inserted into a closed purchase order';
    END IF;
    
    --Fetch and apply default item source data if applicable    
    IF ((NEW.poitem_itemsrc_id IS NULL) AND (NEW.poitem_itemsite_id IS NOT NULL)) THEN
      IF (NEW.poitem_itemsrc_id IS NULL) THEN
        SELECT COUNT(itemsrc_id)  INTO _cnt
        FROM pohead,itemsrc,itemsite
        WHERE ((pohead_id=NEW.poitem_pohead_id)
        AND (pohead_vend_id=itemsrc_vend_id)
        AND (itemsite_id=NEW.poitem_itemsite_id)
        AND (itemsite_item_id=itemsrc_item_id));

        IF (_cnt = 1) THEN
          -- We found the one and only item source, so populate data for it
          SELECT itemsrc.* INTO _s
          FROM pohead,itemsrc,itemsite
          WHERE ((pohead_id=NEW.poitem_pohead_id)
          AND (pohead_vend_id=itemsrc_vend_id)
          AND (itemsite_id=NEW.poitem_itemsite_id)
          AND (itemsite_item_id=itemsrc_item_id));
          IF (FOUND) THEN
            NEW.poitem_itemsrc_id 		:= _s.itemsrc_id;
            NEW.poitem_vend_uom            	:= _s.itemsrc_vend_uom;
            NEW.poitem_invvenduomratio    	:= _s.itemsrc_invvendoruomratio;
            NEW.poitem_duedate			:= COALESCE(NEW.poitem_duedate, CURRENT_DATE + _s.itemsrc_leadtime);
            NEW.poitem_vend_item_number 	:= COALESCE(NEW.poitem_vend_item_number,_s.itemsrc_vend_item_number);
            NEW.poitem_vend_item_descrip   	:= COALESCE(NEW.poitem_vend_item_descrip,_s.itemsrc_vend_item_descrip);
            NEW.poitem_manuf_name		:= COALESCE(NEW.poitem_manuf_name,_s.itemsrc_manuf_name);
            NEW.poitem_manuf_item_number	:= COALESCE(NEW.poitem_manuf_item_number, _s.itemsrc_manuf_item_number);
            NEW.poitem_manuf_item_descrip	:= COALESCE(NEW.poitem_manuf_item_descrip, _s.itemsrc_manuf_item_descrip);
          END IF;
        ELSIF (_cnt > 1) THEN
          -- There are multiple sources, see if there is an exact match with provided vendor info.
          SELECT itemsrc.* INTO _s
          FROM pohead,itemsrc,itemsite
          WHERE ((pohead_id=NEW.poitem_pohead_id)
          AND (pohead_vend_id=itemsrc_vend_id)
          AND (itemsite_id=NEW.poitem_itemsite_id)
          AND (itemsite_item_id=itemsrc_item_id)
          AND (NEW.poitem_vend_item_number=itemsrc_vend_item_number)
          AND (COALESCE(NEW.poitem_manuf_name,'')=COALESCE(itemsrc_manuf_name,''))
          AND (COALESCE(NEW.poitem_manuf_item_number,'')=COALESCE(itemsrc_manuf_item_number,'')));
          IF (FOUND) THEN
            NEW.poitem_itemsrc_id 		:= _s.itemsrc_id;
            NEW.poitem_vend_uom            	:= _s.itemsrc_vend_uom;
            NEW.poitem_invvenduomratio    	:= _s.itemsrc_invvendoruomratio;
            NEW.poitem_duedate			:= COALESCE(NEW.poitem_duedate, CURRENT_DATE + _s.itemsrc_leadtime);
            NEW.poitem_vend_item_descrip   	:= COALESCE(NEW.poitem_vend_item_descrip,_s.itemsrc_vend_item_descrip);
            NEW.poitem_manuf_item_descrip	:= COALESCE(NEW.poitem_manuf_item_descrip, _s.itemsrc_manuf_item_descrip);
          END IF;
        END IF;
      END IF;
    END IF;

    IF (NEW.poitem_duedate IS NULL) THEN
      RAISE EXCEPTION  'A due date is required';
    END IF;
    
    --Set defaults
    NEW.poitem_linenumber    		:= COALESCE(NEW.poitem_linenumber,(
						SELECT COALESCE(MAX(poitem_linenumber),0) + 1
						FROM poitem
						WHERE (poitem_pohead_id=NEW.poitem_pohead_id)));
    NEW.poitem_status                  := _status;
    NEW.poitem_invvenduomratio 	:= COALESCE(NEW.poitem_invvenduomratio,1);
    IF (NEW.poitem_invvenduomratio = 0.0) THEN
      NEW.poitem_invvenduomratio = 1.0;
    END IF;
    NEW.poitem_vend_item_number 	:= COALESCE(NEW.poitem_vend_item_number,'');
    NEW.poitem_vend_item_descrip   	:= COALESCE(NEW.poitem_vend_item_descrip,'');
    NEW.poitem_unitprice       	:= COALESCE(NEW.poitem_unitprice,(
                                                SELECT itemsrcPrice(NEW.poitem_itemsrc_id, COALESCE(itemsite_warehous_id, -1), pohead_dropship,
                                                       NEW.poitem_qty_ordered, pohead_curr_id, CURRENT_DATE)
                                                FROM itemsite, pohead
                                                WHERE ( (itemsite_id=NEW.poitem_itemsite_id)
                                                AND (pohead_id=NEW.poitem_pohead_id) )), 0.0);
    NEW.poitem_stdcost			:= COALESCE(NEW.poitem_stdcost,(
						SELECT stdcost(itemsite_item_id)
						FROM itemsite
						WHERE (itemsite_id=NEW.poitem_itemsite_id)));
    NEW.poitem_bom_rev_id		:= COALESCE(NEW.poitem_bom_rev_id,(
						SELECT getActiveRevId('BOM',itemsite_item_id)
						FROM itemsite
						WHERE (itemsite_id=NEW.poitem_itemsite_id)));
    NEW.poitem_boo_rev_id		:= COALESCE(NEW.poitem_boo_rev_id,(
						SELECT getActiveRevId('BOO',itemsite_item_id)
						FROM itemsite
						WHERE (itemsite_id=NEW.poitem_itemsite_id)));
    NEW.poitem_comments		:= COALESCE(NEW.poitem_comments,'');
    NEW.poitem_freight			:= COALESCE(NEW.poitem_freight,0);
    NEW.poitem_qty_received		:= 0;
    NEW.poitem_qty_returned		:= 0;
    NEW.poitem_qty_vouchered		:= 0;
      
--   Insert Event Start
       
    INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                          evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number )
    SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
                     'P', NEW.poitem_id, itemsite_warehous_id, (pohead_number || '-' || NEW.poitem_linenumber || ': ' || item_number)
    FROM evntnot, evnttype, itemsite, item, pohead
     WHERE ( (evntnot_evnttype_id=evnttype_id)
     AND (evntnot_warehous_id=itemsite_warehous_id)
     AND (itemsite_id=NEW.poitem_itemsite_id)
     AND (itemsite_item_id=item_id)
     AND (NEW.poitem_pohead_id=pohead_id)
     AND (NEW.poitem_duedate <= (CURRENT_DATE + itemsite_eventfence))
     AND (evnttype_name='POitemCreate') );

--   Insert Event End

  END IF;

  IF ( SELECT (metric_value='t')
       FROM metric
       WHERE (metric_name='POChangeLog') ) THEN

--  Cache the cmnttype_id for ChangeLog
    SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
    IF (FOUND) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'P', NEW.poitem_pohead_id, ('Created Line #' || NEW.poitem_linenumber::TEXT));
        PERFORM postComment(_cmnttypeid, 'PI', NEW.poitem_id, 'Created');
      ELSIF (TG_OP = 'UPDATE') THEN
        IF (NEW.poitem_qty_ordered <> OLD.poitem_qty_ordered) THEN
          PERFORM postComment( _cmnttypeid, 'PI', NEW.poitem_id,
                               ( 'Qty. Ordered Changed from ' || formatQty(OLD.poitem_qty_ordered) ||
                                 ' to ' || formatQty(NEW.poitem_qty_ordered ) ) );
        END IF;
        IF (NEW.poitem_unitprice <> OLD.poitem_unitprice) THEN
          PERFORM postComment( _cmnttypeid, 'PI', NEW.poitem_id,
                               ( 'Unit Price Changed from ' || formatPurchPrice(OLD.poitem_unitprice) ||
                                 ' to ' || formatPurchPrice(NEW.poitem_unitprice ) ) );
        END IF;
        IF (NEW.poitem_duedate <> OLD.poitem_duedate) THEN
          PERFORM postComment( _cmnttypeid, 'PI', NEW.poitem_id,
                               ( 'Due Date Changed from ' || formatDate(OLD.poitem_duedate) ||
                                 ' to ' || formatDate(NEW.poitem_duedate ) ) );
        END IF;
        IF (COALESCE(OLD.poitem_taxtype_id, -1) <> COALESCE(NEW.poitem_taxtype_id, -1)) THEN
          PERFORM postComment( _cmnttypeid, 'PI', NEW.poitem_id,
                               ( 'Tax Type Changed from "' ||
                                 COALESCE((SELECT taxtype_name FROM taxtype WHERE taxtype_id=OLD.poitem_taxtype_id), 'None') ||
                                 '" (' || COALESCE(OLD.poitem_taxtype_id, 0) ||
                                 ') to "' ||
                                 COALESCE((SELECT taxtype_name FROM taxtype WHERE taxtype_id=NEW.poitem_taxtype_id), 'None') ||
                                 '" (' || COALESCE(NEW.poitem_taxtype_id, 0) || ')' ) );
        END IF;
        IF (NEW.poitem_status <> OLD.poitem_status) THEN
          IF (NEW.poitem_status = 'C') THEN
            PERFORM postComment(_cmnttypeid, 'PI', NEW.poitem_id, 'Closed');
          ELSIF (NEW.poitem_status = 'O') THEN
            PERFORM postComment(_cmnttypeid, 'PI', NEW.poitem_id, 'Opened');
          END IF;
        END IF;

      ELSIF (TG_OP = 'DELETE') THEN
        PERFORM postComment(_cmnttypeid, 'P', OLD.poitem_pohead_id, ('Deleted Line #' || OLD.poitem_linenumber::TEXT));
      END IF;
    END IF;
  END IF;

  IF (TG_OP = 'DELETE') THEN
    IF (EXISTS(SELECT recv_id
               FROM recv
               WHERE ((recv_order_type='PO')
                  AND (recv_orderitem_id=OLD.poitem_id)
                  AND (recv_qty>0)))) THEN
      RAISE EXCEPTION 'Cannot delete an P/O Item which has been received';
    END IF;

    DELETE FROM comment
     WHERE ( (comment_source='PI')
       AND   (comment_source_id=OLD.poitem_id) );

    DELETE FROM charass
     WHERE ((charass_target_type='PI')
       AND  (charass_target_id=OLD.poitem_id));

    IF (OLD.poitem_status = 'O') THEN
      IF ( (SELECT (count(*) < 1)
              FROM poitem
             WHERE ((poitem_pohead_id=OLD.poitem_pohead_id)
               AND  (poitem_id != OLD.poitem_id)
               AND  (poitem_status <> 'C')) ) ) THEN
        UPDATE pohead SET pohead_status = 'C'
         WHERE ((pohead_id=OLD.poitem_pohead_id)
           AND  (pohead_status='O'));
      END IF;
    END IF;

    RETURN OLD;
  ELSE
    IF (TG_OP = 'UPDATE') THEN

      IF (NEW.poitem_itemsite_id != OLD.poitem_itemsite_id) THEN
        RAISE EXCEPTION 'You may not change the item site for a line item.';
      ELSIF (NEW.poitem_expcat_id != OLD.poitem_expcat_id) THEN
        RAISE EXCEPTION 'You may not change the expense category for a line item.';
      END IF;
    
      IF (OLD.poitem_status <> NEW.poitem_status) THEN
        IF ( (SELECT (count(*) < 1)
                FROM poitem
               WHERE ((poitem_pohead_id=NEW.poitem_pohead_id)
                 AND  (poitem_id != NEW.poitem_id)
                 AND  (poitem_status<>'C')) ) AND (NEW.poitem_status='C') ) THEN
          UPDATE pohead SET pohead_status = 'C'
           WHERE ((pohead_id=NEW.poitem_pohead_id)
             AND  (pohead_status='O'));
        ELSE
          UPDATE pohead SET pohead_status = 'O'
           WHERE ((pohead_id=NEW.poitem_pohead_id)
             AND  (pohead_status='C'));
        END IF;
      END IF;
    END IF;

    RETURN NEW;
  END IF;

END;
$$;


ALTER FUNCTION public._poitemtrigger() OWNER TO admin;

--
-- Name: _prjaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _prjaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;
BEGIN

--  Cache the cmnttype_id for ChangeLog
  SELECT cmnttype_id INTO _cmnttypeid
  FROM cmnttype
  WHERE (cmnttype_name='ChangeLog');
  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Comment type ChangeLog not found';
  END IF;

  IF (TG_OP = 'INSERT') THEN
    PERFORM postComment(_cmnttypeid, 'J', NEW.prj_id, 'Created');
  ELSIF (TG_OP = 'UPDATE') THEN
    IF (OLD.prj_start_date <> NEW.prj_start_date) THEN
      PERFORM postComment( _cmnttypeid, 'J', NEW.prj_id,
                           ('Start Date Changed from ' || formatDate(OLD.prj_start_date) || ' to ' || formatDate(NEW.prj_start_date)) );
    END IF;
    IF (OLD.prj_due_date <> NEW.prj_due_date) THEN
      PERFORM postComment( _cmnttypeid, 'J', NEW.prj_id,
                           ('Due Date Changed from ' || formatDate(OLD.prj_due_date) || ' to ' || formatDate(NEW.prj_due_date)) );
    END IF;
    IF (OLD.prj_assigned_date <> NEW.prj_assigned_date) THEN
      PERFORM postComment( _cmnttypeid, 'J', NEW.prj_id,
                           ('Assigned Date Changed from ' || formatDate(OLD.prj_assigned_date) || ' to ' || formatDate(NEW.prj_assigned_date)) );
    END IF;
    IF (OLD.prj_completed_date <> NEW.prj_completed_date) THEN
      PERFORM postComment( _cmnttypeid, 'J', NEW.prj_id,
                           ('Completed Date Changed from ' || formatDate(OLD.prj_completed_date) || ' to ' || formatDate(NEW.prj_completed_date)) );
    END IF;

  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._prjaftertrigger() OWNER TO admin;

--
-- Name: _prjbeforedeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _prjbeforedeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _recurid     INTEGER;
  _newparentid INTEGER;
BEGIN

  IF (TG_OP = 'DELETE') THEN
    DELETE FROM docass WHERE docass_source_id = OLD.prj_id AND docass_source_type = 'J';
    DELETE FROM docass WHERE docass_target_id = OLD.prj_id AND docass_target_type = 'J';
    
    SELECT recur_id INTO _recurid
      FROM recur
     WHERE ((recur_parent_id=OLD.prj_id)
        AND (recur_parent_type='J'));

    IF (_recurid IS NOT NULL) THEN
      SELECT MIN(prj_id) INTO _newparentid
        FROM prj
       WHERE ((prj_recurring_prj_id=OLD.prj_id)
          AND (prj_id!=OLD.prj_id));

      -- client is responsible for warning about deleting a recurring prj
      IF (_newparentid IS NULL) THEN
        DELETE FROM recur WHERE recur_id=_recurid;
      ELSE
        UPDATE recur SET recur_parent_id=_newparentid
         WHERE recur_id=_recurid;
      END IF;

    END IF;

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._prjbeforedeletetrigger() OWNER TO admin;

--
-- Name: _prjtaskaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _prjtaskaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;
BEGIN

  SELECT cmnttype_id INTO _cmnttypeid
  FROM cmnttype
  WHERE (cmnttype_name='ChangeLog');
  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Comment type ChangeLog not found';
  END IF;

  IF (TG_OP = 'INSERT') THEN
    PERFORM postComment(_cmnttypeid, 'TA', NEW.prjtask_id, 'Created');

  ELSIF (TG_OP = 'UPDATE') THEN
    IF (OLD.prjtask_start_date <> NEW.prjtask_start_date) THEN
      PERFORM postComment( _cmnttypeid, 'TA', NEW.prjtask_id,
                           ('Start Date Changed from ' || formatDate(OLD.prjtask_start_date) || ' to ' || formatDate(NEW.prjtask_start_date)) );
    END IF;
    IF (OLD.prjtask_due_date <> NEW.prjtask_due_date) THEN
      PERFORM postComment( _cmnttypeid, 'TA', NEW.prjtask_id,
                           ('Due Date Changed from ' || formatDate(OLD.prjtask_due_date) || ' to ' || formatDate(NEW.prjtask_due_date)) );
    END IF;
    IF (OLD.prjtask_assigned_date <> NEW.prjtask_assigned_date) THEN
      PERFORM postComment( _cmnttypeid, 'TA', NEW.prjtask_id,
                           ('Assigned Date Changed from ' || formatDate(OLD.prjtask_assigned_date) || ' to ' || formatDate(NEW.prjtask_assigned_date)) );
    END IF;
    IF (OLD.prjtask_completed_date <> NEW.prjtask_completed_date) THEN
      PERFORM postComment( _cmnttypeid, 'TA', NEW.prjtask_id,
                           ('Completed Date Changed from ' || formatDate(OLD.prjtask_completed_date) || ' to ' || formatDate(NEW.prjtask_completed_date)) );
    END IF;
    IF (OLD.prjtask_hours_actual != NEW.prjtask_hours_actual) THEN
      PERFORM postComment(_cmnttypeid, 'TA', NEW.prjtask_id, 
          'Actual Hours changed from ' || formatQty(OLD.prjtask_hours_actual) || ' to ' || formatQty(NEW.prjtask_hours_actual));
    END IF;
    IF (OLD.prjtask_exp_actual != NEW.prjtask_exp_actual) THEN
      PERFORM postComment(_cmnttypeid, 'TA', NEW.prjtask_id, 
          'Actual Expense changed from ' || formatQty(OLD.prjtask_exp_actual) || ' to ' || formatQty(NEW.prjtask_exp_actual));
    END IF;

  END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._prjtaskaftertrigger() OWNER TO admin;

--
-- Name: _prjtasktrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _prjtasktrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  --  Checks
  IF (NEW.prjtask_owner_username=getEffectiveXtUser()) THEN
    IF (NOT checkPrivilege('MaintainAllProjects') AND NOT checkPrivilege('MaintainPersonalProjects')) THEN
      RAISE EXCEPTION 'You do not have privileges to maintain Projects.';
    END IF;
  ELSIF (NOT checkPrivilege('MaintainAllProjects')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Projects.';
  ELSIF (LENGTH(COALESCE(NEW.prjtask_number,'')) = 0) THEN
    RAISE EXCEPTION 'You must ender a valid number.';
  ELSIF (LENGTH(COALESCE(NEW.prjtask_name,'')) = 0) THEN
    RAISE EXCEPTION 'You must ender a valid name.';	
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._prjtasktrigger() OWNER TO admin;

--
-- Name: _prospectafterdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _prospectafterdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF EXISTS(SELECT 1 FROM quhead WHERE quhead_cust_id = OLD.prospect_id) AND
     NOT EXISTS (SELECT 1 FROM custinfo WHERE cust_id = OLD.prospect_id) THEN
    RAISE EXCEPTION '[xtuple: deleteProspect, -1]';
  END IF;

  IF (fetchMetricBool('ProspectChangeLog')) THEN
    PERFORM postComment(cmnttype_id, 'PSPCT', OLD.prospect_id,
                        'Deleted "' || OLD.prospect_number || '"')
      FROM cmnttype
     WHERE (cmnttype_name='ChangeLog');
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._prospectafterdeletetrigger() OWNER TO admin;

--
-- Name: _prospectaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _prospectaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid   INTEGER;
  _custid       INTEGER;
  _prospectid   INTEGER;

BEGIN

  IF (TG_OP = 'INSERT') THEN
    SELECT crmacct_cust_id, crmacct_prospect_id INTO _custid, _prospectid
      FROM crmacct
     WHERE crmacct_number=NEW.prospect_number;

    IF (_custid > 0 AND _custid != _prospectid) THEN
      RAISE EXCEPTION '[xtuple: createProspect, -2]';
    END IF;

    IF (_prospectid > 0) THEN
      RAISE EXCEPTION '[xtuple: createProspect, -3]';
    END IF;

    -- http://www.postgresql.org/docs/current/static/plpgsql-control-structures.html#PLPGSQL-UPSERT-EXAMPLE
    LOOP
      UPDATE crmacct SET crmacct_prospect_id=NEW.prospect_id,
                         crmacct_cust_id=NULL,
                         crmacct_name=NEW.prospect_name
       WHERE crmacct_number=NEW.prospect_number;
      IF (FOUND) THEN
        EXIT;
      END IF;
      BEGIN
        INSERT INTO crmacct(crmacct_number,      crmacct_name,
                            crmacct_active,      crmacct_type,
                            crmacct_prospect_id, crmacct_cntct_id_1
                  ) VALUES (NEW.prospect_number, NEW.prospect_name,
                            NEW.prospect_active, 'O',
                            NEW.prospect_id,     NEW.prospect_cntct_id);
        EXIT;
      EXCEPTION WHEN unique_violation THEN
            -- do nothing, and loop to try the UPDATE again
      END;
    END LOOP;

    /* TODO: default characteristic assignments based on what? */

  ELSIF (TG_OP = 'UPDATE') THEN
    UPDATE crmacct SET crmacct_number = NEW.prospect_number
    WHERE ((crmacct_prospect_id=NEW.prospect_id)
      AND  (crmacct_number!=NEW.prospect_number));

    UPDATE crmacct SET crmacct_name = NEW.prospect_name
    WHERE ((crmacct_prospect_id=NEW.prospect_id)
      AND  (crmacct_name!=NEW.prospect_name));

  END IF;

  IF (fetchMetricBool('ProspectChangeLog')) THEN
    SELECT cmnttype_id INTO _cmnttypeid
      FROM cmnttype
     WHERE (cmnttype_name='ChangeLog');

    IF (_cmnttypeid IS NOT NULL) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'PSPCT', NEW.prospect_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN
        IF (OLD.prospect_active <> NEW.prospect_active) THEN
          PERFORM postComment(_cmnttypeid, 'PSPCT', NEW.prospect_id,
                              CASE WHEN NEW.prospect_active THEN 'Activated'
                                   ELSE 'Deactivated' END);
        END IF;

        IF (OLD.prospect_number <> NEW.prospect_number) THEN
          PERFORM postComment(_cmnttypeid, 'PSPCT', NEW.prospect_id,
                              'Number changed from "' || OLD.prospect_number ||
                              '" to "' || NEW.prospect_number || '"');
        END IF;

        IF (OLD.prospect_name <> NEW.prospect_name) THEN
          PERFORM postComment(_cmnttypeid, 'PSPCT', NEW.prospect_id,
                              'Name changed from "' || OLD.prospect_name ||
                              '" to "' || NEW.prospect_name || '"');
        END IF;

        IF (OLD.prospect_cntct_id <> NEW.prospect_cntct_id) THEN
          PERFORM postComment(_cmnttypeid, 'PSPCT', NEW.prospect_id,
                              'Contact changed from "' ||
                              formatCntctName(OLD.prospect_cntct_id) || '" to "' ||
                              formatCntctName(NEW.prospect_cntct_id) || '"');
        END IF;

        IF (OLD.prospect_taxauth_id <> NEW.prospect_taxauth_id) THEN
          PERFORM postComment(_cmnttypeid, 'PSPCT', NEW.prospect_id,
                              'Tax Authority changed from "' ||
                              (SELECT taxauth_code FROM taxauth
                                WHERE taxauth_id=OLD.prospect_taxauth_id) ||
                              '" to "' ||
                              (SELECT taxauth_code FROM taxauth
                                WHERE taxauth_id=NEW.prospect_taxauth_id) || '"');
        END IF;

        IF (OLD.prospect_salesrep_id <> NEW.prospect_salesrep_id) THEN
          PERFORM postComment(_cmnttypeid, 'PSPCT', NEW.prospect_id,
                              'Sales Rep changed from "' ||
                              (SELECT salesrep_number FROM salesrep
                               WHERE salesrep_id=OLD.prospect_salesrep_id) ||
                              '" to "' ||
                              (SELECT salesrep_number FROM salesrep
                               WHERE salesrep_id=NEW.prospect_salesrep_id) || '"');
        END IF;

        IF (OLD.prospect_warehous_id <> NEW.prospect_warehous_id) THEN
          PERFORM postComment(_cmnttypeid, 'PSPCT', NEW.prospect_id,
                              'Warehouse changed from "' ||
                              (SELECT warehous_code FROM whsinfo
                                WHERE warehous_id=OLD.prospect_warehous_id) ||
                              '" to "' ||
                              (SELECT warehous_code FROM whsinfo
                                WHERE warehous_id=NEW.prospect_warehous_id) || '"');
        END IF;

        IF (OLD.prospect_taxzone_id <> NEW.prospect_taxzone_id) THEN
          PERFORM postComment(_cmnttypeid, 'PSPCT', NEW.prospect_id,
                              'Tax Zone changed from "' ||
                              (SELECT taxzone_code FROM taxzone
                                WHERE taxzone_id=OLD.prospect_taxzone_id) || '" to "' ||
                              (SELECT taxzone_code FROM taxzone
                                WHERE taxzone_id=NEW.prospect_taxzone_id) || '"');
        END IF;

      END IF;
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._prospectaftertrigger() OWNER TO admin;

--
-- Name: _prospectbeforedeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _prospectbeforedeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (NOT checkPrivilege('MaintainProspectMasters')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Prospects.';
  END IF;

  UPDATE crmacct SET crmacct_prospect_id = NULL
   WHERE crmacct_prospect_id = OLD.prospect_id;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._prospectbeforedeletetrigger() OWNER TO admin;

--
-- Name: _prospecttrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _prospecttrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (NOT checkPrivilege('MaintainProspectMasters')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Prospects.';
  END IF;

  IF (NEW.prospect_number IS NULL) THEN
    RAISE EXCEPTION 'You must supply a valid Prospect Number.';
  END IF;

  NEW.prospect_number := UPPER(NEW.prospect_number);

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._prospecttrigger() OWNER TO admin;

--
-- Name: _prtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _prtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/EULA for the full text of the software license.
BEGIN
  --- clear the number from the issue cache
  PERFORM clearNumberIssue('PrNumber', NEW.pr_number);

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._prtrigger() OWNER TO admin;

--
-- Name: _quheadtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _quheadtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;
  _oldHoldType TEXT;
  _newHoldType TEXT;
  _p RECORD;
  _a RECORD;
  _w RECORD;
  _shiptoId INTEGER;
  _addrId INTEGER;
  _prjId INTEGER;
  _check BOOLEAN;
  _numGen CHAR(1);

BEGIN

  --  Checks
  SELECT checkPrivilege('MaintainQuotes') INTO _check;
  IF NOT (_check) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Quotes.';
  END IF;

  -- If this is imported, check the quote number
  IF (TG_OP = 'INSERT') THEN
    IF (NEW.quhead_imported) THEN
      SELECT fetchMetricText('QUNumberGeneration') INTO _numGen;
      IF ((NEW.quhead_number IS NULL) AND (_numGen='M')) THEN
        RAISE EXCEPTION 'You must supply a Quote Number.';
      ELSE
        IF ((NEW.quhead_number IS NOT NULL) AND (_numGen='A')) THEN
          RAISE EXCEPTION 'You may not supply a new Quote Number xTuple will generate the number.';
        ELSE
          IF ((NEW.quhead_number IS NULL) AND (_numGen='O')) THEN
            SELECT fetchqunumber() INTO NEW.quhead_number;
          ELSE
            IF (NEW.quhead_number IS NULL) THEN
              SELECT fetchsonumber() INTO NEW.quhead_number;
            END IF;
          END IF;
        END IF;
      END IF;
    END IF;
    
    IF (fetchMetricText('QUNumberGeneration') IN ('A','O')) THEN
      --- clear the number from the issue cache
      PERFORM clearNumberIssue('QuNumber', NEW.quhead_number);
    ELSIF (fetchMetricText('QUNumberGeneration') = 'S') THEN
      --- clear the number from the issue cache
      PERFORM clearNumberIssue('SoNumber', NEW.quhead_number);
    END IF;
    
  ELSE
    IF (TG_OP = 'UPDATE') THEN
       IF (NEW.quhead_number <> OLD.quhead_number) THEN
         RAISE EXCEPTION 'The order number may not be changed.';
       END IF;
    END IF;
  END IF;

  IF (TG_OP IN ('INSERT','UPDATE')) THEN
    -- Get Customer data
    IF (NEW.quhead_shipto_id IS NULL) THEN
      SELECT * INTO _p FROM (
      SELECT cust_number,cust_usespos,cust_blanketpos,cust_ffbillto,
	     cust_ffshipto,cust_name,cust_salesrep_id,cust_terms_id,cust_shipvia,
	     cust_commprcnt,cust_curr_id,cust_taxzone_id,
  	     addr_line1,addr_line2,addr_line3,addr_city,addr_state,addr_postalcode,addr_country,
	     shipto_id,shipto_addr_id,shipto_name,shipto_salesrep_id,shipto_shipvia,
	     shipto_shipchrg_id,shipto_shipform_id,shipto_commission,shipto_taxzone_id
      FROM custinfo
        LEFT OUTER JOIN cntct ON (cust_cntct_id=cntct_id)
        LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)
        LEFT OUTER JOIN shiptoinfo ON ((cust_id=shipto_cust_id) AND shipto_default)
      WHERE (cust_id=NEW.quhead_cust_id)
      UNION
      SELECT prospect_number,false,false,true,
	     true,prospect_name,prospect_salesrep_id,null,null,
	     null,null,prospect_taxzone_id,
  	     addr_line1,addr_line2,addr_line3,addr_city,addr_state,addr_postalcode,addr_country,
	     null,null,null,null,null,
	     null,null,null,null
      FROM prospect
        LEFT OUTER JOIN cntct ON (prospect_cntct_id=cntct_id)
        LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)
      WHERE (prospect_id=NEW.quhead_cust_id)) AS data;
    ELSE
      SELECT cust_creditstatus,cust_number,cust_usespos,cust_blanketpos,cust_ffbillto,
	     cust_ffshipto,cust_name,cust_salesrep_id,cust_terms_id,cust_shipvia,
	     cust_shipchrg_id,cust_shipform_id,cust_commprcnt,cust_curr_id,cust_taxzone_id,
  	     addr_line1,addr_line2,addr_line3,addr_city,addr_state,addr_postalcode,addr_country,
	     shipto_id,shipto_addr_id,shipto_name,shipto_salesrep_id,shipto_shipvia,
	     shipto_shipchrg_id,shipto_shipform_id,shipto_commission,shipto_taxzone_id INTO _p
      FROM shiptoinfo,custinfo
        LEFT OUTER JOIN cntct ON (cust_cntct_id=cntct_id)
        LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)
      WHERE ((cust_id=NEW.quhead_cust_id)
      AND (shipto_id=shipto_id));
    END IF;

    -- If there is customer data, then we can get to work
    IF (FOUND) THEN
      -- Only check PO number for imports because UI checks when whole quote is saved
      IF (TG_OP = 'INSERT') THEN
          -- Set to defaults if values not provided
          NEW.quhead_shipto_id		:= COALESCE(NEW.quhead_shipto_id,_p.shipto_id);
	  NEW.quhead_salesrep_id 	:= COALESCE(NEW.quhead_salesrep_id,_p.shipto_salesrep_id,_p.cust_salesrep_id);
          NEW.quhead_terms_id		:= COALESCE(NEW.quhead_terms_id,_p.cust_terms_id);
          NEW.quhead_shipvia		:= COALESCE(NEW.quhead_shipvia,_p.shipto_shipvia,_p.cust_shipvia);
          NEW.quhead_commission		:= COALESCE(NEW.quhead_commission,_p.shipto_commission,_p.cust_commprcnt);
          NEW.quhead_quotedate		:= COALESCE(NEW.quhead_quotedate,current_date);
          NEW.quhead_packdate		:= COALESCE(NEW.quhead_packdate,NEW.quhead_quotedate);
          NEW.quhead_curr_id		:= COALESCE(NEW.quhead_curr_id,_p.cust_curr_id,basecurrid());
          NEW.quhead_taxzone_id		:= COALESCE(NEW.quhead_taxzone_id,_p.shipto_taxzone_id,_p.cust_taxzone_id);
          NEW.quhead_freight		:= COALESCE(NEW.quhead_freight,0);
          NEW.quhead_custponumber	:= COALESCE(NEW.quhead_custponumber,'');
          NEW.quhead_ordercomments	:= COALESCE(NEW.quhead_ordercomments,'');
          NEW.quhead_shipcomments	:= COALESCE(NEW.quhead_shipcomments,'');
          NEW.quhead_shiptophone	:= COALESCE(NEW.quhead_shiptophone,'');
          NEW.quhead_misc		:= COALESCE(NEW.quhead_misc,0);
          NEW.quhead_misc_descrip	:= COALESCE(NEW.quhead_misc_descrip,'');

          IF ((NEW.quhead_warehous_id IS NULL) OR (NEW.quhead_fob IS NULL)) THEN
            IF (NEW.quhead_warehous_id IS NULL) THEN
              SELECT warehous_id,warehous_fob INTO _w
              FROM usrpref, whsinfo
              WHERE ((warehous_id=CAST(usrpref_value AS INTEGER))
                AND (warehous_shipping)
                AND (warehous_active)
                AND (usrpref_username=getEffectiveXtUser())
                AND (usrpref_name='PreferredWarehouse'));
            ELSE
              SELECT warehous_id,warehous_fob INTO _w
              FROM whsinfo
              WHERE (warehous_id=NEW.quhead_warehous_id);
            END IF;
            
            IF (FOUND) THEN
              NEW.quhead_warehous_id 	:= COALESCE(NEW.quhead_warehous_id,_w.warehous_id);
              NEW.quhead_fob		:= COALESCE(NEW.quhead_fob,_w.warehous_fob);
            END IF;
          END IF;
      END IF;
      
      --Auto create project if applicable
      IF ((TG_OP = 'INSERT') AND (NEW.quhead_prj_id=-1)) THEN
        SELECT fetchMetricBool('AutoCreateProjectsForOrders') INTO _check;
        IF (_check) THEN
          SELECT NEXTVAL('prj_prj_id_seq') INTO _prjId;
          NEW.quhead_prj_id := _prjId;
          INSERT INTO prj (prj_id, prj_number, prj_name, prj_descrip, prj_so, prj_wo, prj_po)
               VALUES(_prjId, NEW.quhead_number, NEW.quhead_number, 'Auto Generated Project from Quote.', TRUE, TRUE, TRUE);
        END IF;
      END IF;

      -- Deal with Billing Address
      IF (TG_OP = 'INSERT') THEN
        IF (_p.cust_ffbillto) THEN
          -- If they didn't supply data, we'll put in the bill to address
          NEW.quhead_billtoname=COALESCE(NEW.quhead_billtoname,_p.cust_name,'');
          NEW.quhead_billtoaddress1=COALESCE(NEW.quhead_billtoaddress1,_p.addr_line1,'');
          NEW.quhead_billtoaddress2=COALESCE(NEW.quhead_billtoaddress2,_p.addr_line2,'');
          NEW.quhead_billtoaddress3=COALESCE(NEW.quhead_billtoaddress3,_p.addr_line3,'');    
          NEW.quhead_billtocity=COALESCE(NEW.quhead_billtocity,_p.addr_city,''); 
          NEW.quhead_billtostate=COALESCE(NEW.quhead_billtostate,_p.addr_state,'');
          NEW.quhead_billtozip=COALESCE(NEW.quhead_billtozip,_p.addr_postalcode,'');
          NEW.quhead_billtocountry=COALESCE(NEW.quhead_billtocountry,_p.addr_country,'');   
        ELSE
          -- Free form not allowed, we're going to put in the address regardless
          NEW.quhead_billtoname=COALESCE(_p.cust_name,'');
          NEW.quhead_billtoaddress1=COALESCE(_p.addr_line1,'');
          NEW.quhead_billtoaddress2=COALESCE(_p.addr_line2,'');
          NEW.quhead_billtoaddress3=COALESCE(_p.addr_line3,'');    
          NEW.quhead_billtocity=COALESCE(_p.addr_city,''); 
          NEW.quhead_billtostate=COALESCE(_p.addr_state,'');
          NEW.quhead_billtozip=COALESCE(_p.addr_postalcode,'');
          NEW.quhead_billtocountry=COALESCE(_p.addr_country,'');
        END IF;
      END IF;

      -- Now let's look at Shipto Address
      -- If there's nothing in the address fields and there is a shipto id 
      -- or there is a default address available, let's put in some shipto address data
      IF ((TG_OP = 'INSERT') 
       AND NOT ((NEW.quhead_shipto_id IS NULL) AND NOT _p.cust_ffshipto)
       AND (NEW.quhead_shiptoname IS NULL)
       AND (NEW.quhead_shiptoaddress1 IS NULL)
       AND (NEW.quhead_shiptoaddress2 IS NULL)
       AND (NEW.quhead_shiptoaddress3 IS NULL)
       AND (NEW.quhead_shiptocity IS NULL)
       AND (NEW.quhead_shiptostate IS NULL)
       AND (NEW.quhead_shiptocountry IS NULL)) THEN
        IF ((NEW.quhead_shipto_id IS NULL) AND (_p.shipto_id IS NOT NULL)) THEN
          _shiptoId := _p.shipto_addr_id;
        ELSE
          _shiptoId := NEW.quhead_shipto_id;
        END IF;

        SELECT * INTO _a 
        FROM shiptoinfo, addr 
        WHERE ((shipto_id=_shiptoId)
        AND (addr_id=shipto_addr_id));

        NEW.quhead_shiptoname := COALESCE(_p.shipto_name,'');
        NEW.quhead_shiptoaddress1 := COALESCE(_a.addr_line1,'');
        NEW.quhead_shiptoaddress2 := COALESCE(_a.addr_line2,'');
        NEW.quhead_shiptoaddress3 := COALESCE(_a.addr_line3,'');    
        NEW.quhead_shiptocity := COALESCE(_a.addr_city,''); 
        NEW.quhead_shiptostate := COALESCE(_a.addr_state,'');
        NEW.quhead_shiptozipcode := COALESCE(_a.addr_postalcode,'');
        NEW.quhead_shiptocountry := COALESCE(_a.addr_country,'');
      ELSE
        IF (_p.cust_ffshipto) THEN
          -- Use Address Save function to see if the new address entered matches
          -- data for the shipto number.  If not that will insert new address for CRM
          SELECT SaveAddr(
            NULL,
            NULL,
            NEW.quhead_shiptoaddress1,
            NEW.quhead_shiptoaddress2,
            NEW.quhead_shiptoaddress3,
            NEW.quhead_shiptocity,
            NEW.quhead_shiptostate,
            NEW.quhead_shiptozipcode,
            NEW.quhead_shiptocountry,
            'CHANGEONE') INTO _addrId;
          SELECT shipto_addr_id INTO _shiptoid FROM shiptoinfo WHERE (shipto_id=NEW.quhead_shipto_id);
           -- If the address passed doesn't match shipto address, then it's something else
           IF (_shiptoid <> _addrId) THEN
             NEW.quhead_shipto_id := NULL;
           END IF;
        ELSE
          SELECT quhead_shipto_id INTO _shiptoid FROM quhead WHERE (quhead_id=NEW.quhead_id);
          -- Get the shipto address
            IF (COALESCE(NEW.quhead_shipto_id,-1) <> COALESCE(_shiptoid,-1)) THEN
            SELECT * INTO _a 
            FROM shiptoinfo
            LEFT OUTER JOIN cntct ON (shipto_cntct_id=cntct_id)
            LEFT OUTER JOIN addr ON (shipto_addr_id=addr_id)
            WHERE (shipto_id=NEW.quhead_shipto_id);
            IF (FOUND) THEN
              -- Free form not allowed so we're going to make sure address matches Shipto data
              NEW.quhead_shiptoname := COALESCE(_a.shipto_name,'');
              NEW.quhead_shiptophone := COALESCE(_a.cntct_phone,'');
              NEW.quhead_shiptoaddress1 := COALESCE(_a.addr_line1,'');
              NEW.quhead_shiptoaddress2 := COALESCE(_a.addr_line2,'');
              NEW.quhead_shiptoaddress3 := COALESCE(_a.addr_line3,'');    
              NEW.quhead_shiptocity := COALESCE(_a.addr_city,''); 
              NEW.quhead_shiptostate := COALESCE(_a.addr_state,'');
              NEW.quhead_shiptozipcode := COALESCE(_a.addr_postalcode,'');
              NEW.quhead_shiptocountry := COALESCE(_a.addr_country,''); 
            ELSE
              -- If no shipto data and free form not allowed, this won't work
              RAISE EXCEPTION 'Free form Shipto is not allowed on this Customer. You must supply a valid Shipto ID.';
            END IF;
          END IF;
        END IF;
      END IF;
    END IF;
  END IF;

  IF ( SELECT (metric_value='t')
       FROM metric
       WHERE (metric_name='SalesOrderChangeLog') ) THEN

--  Cache the cmnttype_id for ChangeLog
    SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
    IF (FOUND) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'Q', NEW.quhead_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN

        IF (OLD.quhead_terms_id <> NEW.quhead_terms_id) THEN
          PERFORM postComment( _cmnttypeid, 'Q', NEW.quhead_id,
                               ('Terms Changed from "' || oldterms.terms_code || '" to "' || newterms.terms_code || '"') )
          FROM terms AS oldterms, terms AS newterms
          WHERE ( (oldterms.terms_id=OLD.quhead_terms_id)
           AND (newterms.terms_id=NEW.quhead_terms_id) );
        END IF;

      ELSIF (TG_OP = 'DELETE') THEN
        DELETE FROM comment
        WHERE ( (comment_source='Q')
         AND (comment_source_id=OLD.quhead_id) );
      END IF;
    END IF;
  END IF;

  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  ELSE
    RETURN NEW;
  END IF;

END;
$$;


ALTER FUNCTION public._quheadtrigger() OWNER TO admin;

--
-- Name: _quitemaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _quitemaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check NUMERIC;
BEGIN

  --If auto calculate freight, recalculate quhead_freight
  IF (SELECT quhead_calcfreight FROM quhead WHERE (quhead_id=NEW.quitem_quhead_id)) THEN
    UPDATE quhead SET quhead_freight =
      (SELECT SUM(freightdata_total) FROM freightDetail('QU',
                                                        quhead_id,
                                                        quhead_cust_id,
                                                        quhead_shipto_id,
                                                        quhead_quotedate,
                                                        quhead_shipvia,
                                                        quhead_curr_id))
    WHERE quhead_id=NEW.quitem_quhead_id;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._quitemaftertrigger() OWNER TO admin;

--
-- Name: _quitembeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _quitembeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check NUMERIC;
  _itemNumber TEXT;
BEGIN
  -- Check
  IF (NEW.quitem_scheddate IS NULL) THEN
  	RAISE EXCEPTION 'A schedule date is required.';
  END IF;

  -- If this is imported, go ahead and insert default characteristics
   IF ((TG_OP = 'INSERT') AND NEW.quitem_imported) THEN
     PERFORM updateCharAssignment('SI', NEW.quitem_id, char_id, charass_value) 
     FROM (
       SELECT DISTINCT char_id, char_name, charass_value
       FROM charass, char, itemsite, item
       WHERE ((itemsite_id=NEW.quitem_itemsite_id)
       AND (itemsite_item_id=item_id)
       AND (charass_target_type='I') 
       AND (charass_target_id=item_id)
       AND (charass_default)
       AND (char_id=charass_char_id))
       ORDER BY char_name) AS data;
   END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._quitembeforetrigger() OWNER TO admin;

--
-- Name: _quitemtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _quitemtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;
  _check BOOLEAN;

BEGIN
  --  Checks
  SELECT checkPrivilege('MaintainQuotes') INTO _check;
  IF NOT (_check) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Quotes.';
  END IF;

  IF ( SELECT (metric_value='t')
       FROM metric
       WHERE (metric_name='SalesOrderChangeLog') ) THEN
--  Cache the cmnttype_id for ChangeLog
    SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
  ELSE
    _cmnttypeid := -1;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    IF (_cmnttypeid <> -1) THEN
      PERFORM postComment(_cmnttypeid, 'QI', NEW.quitem_id, 'Created');
    END IF;

    RETURN NEW;

  ELSE
    IF (TG_OP = 'DELETE') THEN
      DELETE FROM comment
      WHERE ( (comment_source='QI')
       AND (comment_source_id=OLD.quitem_id) );

      DELETE FROM charass
       WHERE ((charass_target_type='QI')
         AND  (charass_target_id=OLD.quitem_id));
 
      RETURN OLD;

    ELSE
      IF (TG_OP = 'UPDATE') THEN

        IF (NEW.quitem_qtyord <> OLD.quitem_qtyord) THEN
          IF (_cmnttypeid <> -1) THEN
            PERFORM postComment( _cmnttypeid, 'QI', NEW.quitem_id,
                                 ( 'Changed Qty. Ordered from ' || formatQty(OLD.quitem_qtyord) ||
                                   ' to ' || formatQty(NEW.quitem_qtyord) ) );
          END IF;

        END IF;

        IF (NEW.quitem_scheddate <> OLD.quitem_scheddate) THEN
          IF (_cmnttypeid <> -1) THEN
            PERFORM postComment( _cmnttypeid, 'QI', NEW.quitem_id,
                                 ( 'Changed Sched. Date from ' || formatDate(OLD.quitem_scheddate) ||
                                   ' to ' || formatDate(NEW.quitem_scheddate)) );
          END IF;

        END IF;

      END IF; 
    END IF;
  END IF;

--  NEW.quitem_lastupdated = CURRENT_TIMESTAMP;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._quitemtrigger() OWNER TO admin;

--
-- Name: _recuraftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _recuraftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _parentid   INTEGER;
  _parenttype TEXT;
BEGIN
  IF (TG_OP = 'DELETE') THEN
    IF (UPPER(OLD.recur_parent_type) = 'TODO') THEN
      UPDATE todoitem SET todoitem_recurring_todoitem_id=NULL
       WHERE (todoitem_recurring_todoitem_id=OLD.recur_parent_id);
    END IF;

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._recuraftertrigger() OWNER TO admin;

--
-- Name: _reporttrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _reporttrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  NEW.report_loaddate = CURRENT_TIMESTAMP;
  RETURN NEW;

END;
$$;


ALTER FUNCTION public._reporttrigger() OWNER TO admin;

--
-- Name: _salesrepafterdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _salesrepafterdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
BEGIN
  IF (SELECT fetchMetricValue('DefaultSalesRep') = OLD.salesrep_id) THEN
    RAISE EXCEPTION 'Cannot delete the default Sales Rep [xtuple: salesrep, -1, %]',
                    OLD.salesrep_number;
  END IF;

  PERFORM postComment('ChangeLog', 'SR', OLD.salesrep_id,
                      'Deleted "' || OLD.salesrep_number || '"');

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._salesrepafterdeletetrigger() OWNER TO admin;

--
-- Name: _salesrepaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _salesrepaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

BEGIN

  IF (TG_OP = 'INSERT') THEN
    -- http://www.postgresql.org/docs/current/static/plpgsql-control-structures.html#PLPGSQL-UPSERT-EXAMPLE
    LOOP
      UPDATE crmacct SET crmacct_salesrep_id=NEW.salesrep_id,
                         crmacct_name=NEW.salesrep_name
      WHERE crmacct_number=NEW.salesrep_number;
      IF (FOUND) THEN
        EXIT;
      END IF;
      BEGIN
        INSERT INTO crmacct(crmacct_number,      crmacct_name,      crmacct_active,
                            crmacct_type,        crmacct_salesrep_id
                  ) VALUES (NEW.salesrep_number, NEW.salesrep_name, NEW.salesrep_active,
                            'I',                 NEW.salesrep_id);
        EXIT;
      EXCEPTION WHEN unique_violation THEN
            -- do nothing, and loop to try the UPDATE again
      END;
    END LOOP;

    -- TODO: default characteristic assignments?

  ELSIF (TG_OP = 'UPDATE') THEN
    UPDATE crmacct SET crmacct_number = NEW.salesrep_number
    WHERE ((crmacct_salesrep_id=NEW.salesrep_id)
      AND  (crmacct_number!=NEW.salesrep_number));

    UPDATE crmacct SET crmacct_name = NEW.salesrep_name
    WHERE ((crmacct_salesrep_id=NEW.salesrep_id)
      AND  (crmacct_name!=NEW.salesrep_name));
  END IF;

  IF (fetchMetricBool('SalesRepChangeLog')) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment('ChangeLog', 'SR', NEW.salesrep_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN
        IF (OLD.salesrep_active <> NEW.salesrep_active) THEN
          PERFORM postComment('ChangeLog', 'SR', NEW.salesrep_id,
                              CASE WHEN NEW.salesrep_active THEN 'Activated'
                                   ELSE 'Deactivated' END);
        END IF;

        IF (OLD.salesrep_number <> NEW.salesrep_number) THEN
          PERFORM postComment('ChangeLog', 'SR', NEW.salesrep_id,
                              'Number changed from "' || OLD.salesrep_number ||
                              '" to "' || NEW.salesrep_number || '"');
        END IF;

        IF (OLD.salesrep_name <> NEW.salesrep_name) THEN
          PERFORM postComment('ChangeLog', 'SR', NEW.salesrep_id,
                              'Name changed from "' || OLD.salesrep_name ||
                              '" to "' || NEW.salesrep_name || '"');
        END IF;

        IF (OLD.salesrep_commission <> NEW.salesrep_commission) THEN
          PERFORM postComment('ChangeLog', 'SR', NEW.salesrep_id,
                              'Commission changed from "' || OLD.salesrep_commission ||
                              '" to "' || NEW.salesrep_commission || '"');
        END IF;

        IF (OLD.salesrep_method <> NEW.salesrep_method) THEN
          PERFORM postComment('ChangeLog', 'SR', NEW.salesrep_id,
                              'Method changed from "' || OLD.salesrep_method ||
                              '" to "' || NEW.salesrep_method || '"');
        END IF;

    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._salesrepaftertrigger() OWNER TO admin;

--
-- Name: _salesrepbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _salesrepbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  IF NOT (checkPrivilege('MaintainSalesReps')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Sales Reps.';
  END IF;

  IF (TG_OP IN ('INSERT', 'UPDATE')) THEN
    IF (NEW.salesrep_number IS NULL) THEN
      RAISE EXCEPTION 'You must supply a valid Sales Rep Number.';
    END IF;

    IF (NEW.salesrep_commission IS NULL) THEN
      RAISE EXCEPTION 'You must supply a Commission Rate for this Sales Rep.';
    END IF;

    IF (TG_OP = 'INSERT' AND fetchMetricText('CRMAccountNumberGeneration') IN ('A','O') AND isNumeric(NEW.salesrep_number)) THEN
      --- clear the number from the issue cache
      PERFORM clearNumberIssue('CRMAccountNumber', NEW.salesrep_number);
    END IF;

    NEW.salesrep_number = UPPER(NEW.salesrep_number);

    -- deprecated column salesrep_emp_id
    -- TODO: will this prevent breaking the crmacct-emp relationship?
    IF (TG_OP = 'UPDATE') THEN
      SELECT crmacct_emp_id INTO NEW.salesrep_emp_id
        FROM crmacct
       WHERE crmacct_salesrep_id = NEW.salesrep_id;
    END IF;

  ELSIF (TG_OP = 'DELETE') THEN
    UPDATE crmacct SET crmacct_salesrep_id = NULL
     WHERE crmacct_salesrep_id = OLD.salesrep_id;
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._salesrepbeforetrigger() OWNER TO admin;

--
-- Name: _saletypebeforedeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _saletypebeforedeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check TEXT;

BEGIN
--  Check to see if any sales orders are assigned to the passed saletype
  SELECT cohead_number INTO _check
  FROM cohead
  WHERE (cohead_saletype_id=OLD.saletype_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Assigned to Sales Order % and possibly more. [xtuple: deletesaletype, -1]', _check;
  END IF;

--  Check to see if any quotes are assigned to the passed saletype
  SELECT quhead_number INTO _check
  FROM quhead
  WHERE (quhead_saletype_id=OLD.saletype_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Assigned to Quote % and possibly more. [xtuple: deletesaletype, -2]', _check;
  END IF;

--  Check to see if any invoice are assigned to the passed saletype
  SELECT invchead_invcnumber INTO _check
  FROM invchead
  WHERE (invchead_saletype_id=OLD.saletype_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Assigned to Invoice % and possibly more. [xtuple: deletesaletype, -3]', _check;
  END IF;

--  Check to see if any credit memos are assigned to the passed saletype
  SELECT cmhead_number INTO _check
  FROM cmhead
  WHERE (cmhead_saletype_id=OLD.saletype_id)
  LIMIT 1;
  IF (FOUND) THEN
    RAISE EXCEPTION 'Assigned to Credit Memo % and possibly more. [xtuple: deletesaletype, -4]', _check;
  END IF;

--  Check to see if any return ruthorizations are assigned to the passed saletype
  IF (fetchMetricBool('EnableReturnAuth')) THEN
    SELECT rahead_number INTO _check
    FROM rahead
    WHERE (rahead_saletype_id=OLD.saletype_id)
    LIMIT 1;
    IF (FOUND) THEN
      RAISE EXCEPTION 'Assigned to Return Authorization % and possibly more returns. [xtuple: deleteSaleType, -5]', _check;
    END IF;
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._saletypebeforedeletetrigger() OWNER TO admin;

--
-- Name: _shipdatasumtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _shipdatasumtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  IF (LENGTH(TRIM(NEW.shipdatasum_shiphead_number)) = 0) THEN
    NEW.shipdatasum_shiphead_number = NULL;
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._shipdatasumtrigger() OWNER TO admin;

--
-- Name: _shipdatatrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _shipdatatrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _newShipdata_cohead_number 	INTEGER;
  _shipdatasum_shipper 		TEXT;
  _rows				INTEGER;
  _cohead_id 			INTEGER;
  _shiphead_number 		TEXT;
  _headcount			INTEGER;

BEGIN
  --  This is where the shipper is identified and may need to be changed
  NEW.shipdata_cohead_number := TRIM(NEW.shipdata_cohead_number);

  IF (substring(NEW.shipdata_cosmisc_tracknum from 1 for 2) = '1Z') THEN
    _shipdatasum_shipper := 'UPS';
  ELSE
    _shipdatasum_shipper := 'UNKNOWN';
  END IF;

  IF (LENGTH(TRIM(NEW.shipdata_shiphead_number)) = 0) THEN
    NEW.shipdata_shiphead_number := NULL;
  END IF;

  IF (NEW.shipdata_cosmisc_tracknum = NEW.shipdata_cosmisc_packnum_tracknum) THEN
    IF (NEW.shipdata_void_ind = 'Y') THEN
      --  Delete the current shipdatasum
      DELETE FROM shipdatasum
      WHERE ((shipdatasum_cohead_number = NEW.shipdata_cohead_number)
	AND  (shipdatasum_cosmisc_tracknum = NEW.shipdata_cosmisc_tracknum));

    ELSIF (TG_OP = 'INSERT') THEN

--      RAISE NOTICE 'Getting cohead_id (%)', NEW.shipdata_cohead_number;
      IF (NEW.shipdata_shiphead_number IS NULL) THEN
        SELECT cohead_id INTO _cohead_id FROM cohead WHERE cohead_number = NEW.shipdata_cohead_number;

        IF (FOUND) THEN

--          RAISE NOTICE 'Getting shiphead number (%)', _cohead_id;
          SELECT count(shiphead_order_id), MAX(shiphead_number) INTO _headcount, _shiphead_number 
          FROM shiphead 
          WHERE ((shiphead_tracknum IS NULL OR shiphead_tracknum = '') 
          AND ( shiphead_order_type = 'SO' and shiphead_order_id = _cohead_id) );
          
          IF (_headcount = 1) THEN
--            RAISE NOTICE 'Updating Shiphead Number (%)', _shiphead_number;
            NEW.shipdata_shiphead_number = _shiphead_number;
            
          ELSIF (_headcount > 1) THEN
            -- Trap for potential workflow problem.  Can only infer shiphead from sales order number 
            -- if shipping one at a time
            RAISE EXCEPTION 'Multiple shipments exist for this order.  Please provide a specific a shipment number.';
          END IF;
        END IF;
      END IF;

      INSERT INTO shipdatasum
	      (shipdatasum_cohead_number, shipdatasum_cosmisc_tracknum,
	       shipdatasum_cosmisc_packnum_tracknum, shipdatasum_weight,
	       shipdatasum_base_freight, shipdatasum_total_freight,
	       shipdatasum_base_freight_curr_id, shipdatasum_total_freight_curr_id,
	       shipdatasum_shipper, shipdatasum_billing_option,
	       shipdatasum_package_type, shipdatasum_shiphead_number)
       VALUES (NEW.shipdata_cohead_number, NEW.shipdata_cosmisc_tracknum,
	       NEW.shipdata_cosmisc_packnum_tracknum, NEW.shipdata_weight,
	       NEW.shipdata_base_freight, NEW.shipdata_total_freight,
	       NEW.shipdata_base_freight_curr_id, NEW.shipdata_total_freight_curr_id,
	       _shipdatasum_shipper, NEW.shipdata_billing_option,
	       NEW.shipdata_package_type, NEW.shipdata_shiphead_number);

    ELSIF (TG_OP = 'UPDATE') THEN
       UPDATE shipdatasum SET
	      shipdatasum_cohead_number=NEW.shipdata_cohead_number,
	      shipdatasum_cosmisc_tracknum=NEW.shipdata_cosmisc_tracknum,
	      shipdatasum_cosmisc_packnum_tracknum=NEW.shipdata_cosmisc_packnum_tracknum,
	      shipdatasum_weight=NEW.shipdata_weight,
	      shipdatasum_base_freight=NEW.shipdata_base_freight,
	      shipdatasum_total_freight=NEW.shipdata_total_freight,
	      shipdatasum_base_freight_curr_id=NEW.shipdata_base_freight_curr_id,
	      shipdatasum_total_freight_curr_id=NEW.shipdata_total_freight_curr_id,
	      shipdatasum_shipper=_shipdatasum_shipper,
	      shipdatasum_billing_option=NEW.shipdata_billing_option,
	      shipdatasum_package_type=NEW.shipdata_package_type,
	      shipdatasum_shiphead_number=NEW.shipdata_shiphead_number
       WHERE ((TRIM(shipdatasum_cohead_number)=TRIM(OLD.shipdata_cohead_number))
	  AND (TRIM(shipdatasum_cosmisc_tracknum)=TRIM(OLD.shipdata_cosmisc_tracknum))
	  AND (TRIM(shipdatasum_cosmisc_packnum_tracknum)=TRIM(OLD.shipdata_cosmisc_packnum_tracknum)));

       GET DIAGNOSTICS _rows = ROW_COUNT;
       IF (_rows <= 0) THEN
	 INSERT INTO shipdatasum
		(shipdatasum_cohead_number, shipdatasum_cosmisc_tracknum,
		 shipdatasum_cosmisc_packnum_tracknum, shipdatasum_weight,
		 shipdatasum_base_freight, shipdatasum_total_freight,
		 shipdatasum_base_freight_curr_id, shipdatasum_total_freight_curr_id,
		 shipdatasum_shipper, shipdatasum_billing_option,
		 shipdatasum_package_type, shipdatasum_shiphead_number)
	 VALUES (NEW.shipdata_cohead_number, NEW.shipdata_cosmisc_tracknum,
		 NEW.shipdata_cosmisc_packnum_tracknum, NEW.shipdata_weight,
		 NEW.shipdata_base_freight, NEW.shipdata_total_freight,
		 NEW.shipdata_base_freight_curr_id, NEW.shipdata_total_freight_curr_id,
		 _shipdatasum_shipper, NEW.shipdata_billing_option,
		 NEW.shipdata_package_type, NEW.shipdata_shiphead_number);
       END IF;
    END IF;
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._shipdatatrigger() OWNER TO admin;

--
-- Name: _shipformafterdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _shipformafterdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (fetchMetricValue('DefaultShipFormId') = OLD.shipform_id) THEN
    RAISE EXCEPTION 'Cannot delete the default Shipping Form [xtuple: shipform, -1, %, %]',
                    OLD.shipform_name, OLD.shipform_report_name;
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._shipformafterdeletetrigger() OWNER TO admin;

--
-- Name: _shipheadbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _shipheadbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF ((TG_OP = 'INSERT') OR (TG_OP = 'UPDATE')) THEN

    IF (NEW.shiphead_order_type = 'SO'
	AND NEW.shiphead_order_id   IN (SELECT cohead_id FROM cohead)) THEN
      RETURN NEW;

    ELSEIF (NEW.shiphead_order_type = 'TO'
	AND NEW.shiphead_order_id   IN (SELECT tohead_id FROM tohead)) THEN
      RETURN NEW;

    END IF;

    RAISE EXCEPTION '% with id % does not exist',
		    NEW.shiphead_order_type, NEW.shiphead_order_id;
    RETURN OLD;

  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._shipheadbeforetrigger() OWNER TO admin;

--
-- Name: _shiptoinfoaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _shiptoinfoaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;

BEGIN
  IF (NEW.shipto_default) THEN
    UPDATE shiptoinfo
    SET shipto_default = false
    WHERE ((shipto_cust_id=NEW.shipto_cust_id)
    AND (shipto_id <> NEW.shipto_id));
  END IF;

  IF (SELECT fetchMetricBool('CustomerChangeLog')) THEN
--  Cache the cmnttype_id for ChangeLog
    SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
    IF (FOUND) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'C', NEW.shipto_cust_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN
        IF (OLD.shipto_name <> NEW.shipto_name) THEN
          PERFORM postComment( _cmnttypeid, 'C', NEW.shipto_cust_id,
                               ( NEW.shipto_name || ': Ship To Name Changed from "' || COALESCE(OLD.shipto_name, '') ||
                                 '" to "' || COALESCE(NEW.shipto_name, '') || '"' ) );
        END IF;
        IF (OLD.shipto_shipvia <> NEW.shipto_shipvia) THEN
          PERFORM postComment( _cmnttypeid, 'C', NEW.shipto_cust_id,
                               ( NEW.shipto_name || ': Ship To ShipVia Changed from "' || COALESCE(OLD.shipto_shipvia, '') ||
                                 '" to "' || COALESCE(NEW.shipto_shipvia, '') || '"' ) );
        END IF;
        IF (COALESCE(OLD.shipto_taxzone_id, -1) <> COALESCE(NEW.shipto_taxzone_id, -1)) THEN
          PERFORM postComment( _cmnttypeid, 'C', NEW.shipto_cust_id,
                               ( NEW.shipto_name || ': Ship To Tax Zone Changed from "' || COALESCE((SELECT taxzone_code
                                                                                            FROM taxzone
                                                                                            WHERE taxzone_id=OLD.shipto_taxzone_id), 'None') ||
                                 '" to "' || COALESCE((SELECT taxzone_code
                                              FROM taxzone
                                              WHERE taxzone_id=NEW.shipto_taxzone_id), 'None') || '"' ) );
        END IF;
        IF (OLD.shipto_shipzone_id <> NEW.shipto_shipzone_id) THEN
          PERFORM postComment( _cmnttypeid, 'C', NEW.shipto_cust_id,
                               ( NEW.shipto_name || ': Ship To Shipping Zone Changed from "' || (SELECT shipzone_name
                                                                                                 FROM shipzone
                                                                                                 WHERE shipzone_id=OLD.shipto_shipzone_id) ||
                                 '" to "' || (SELECT shipzone_name
                                              FROM shipzone
                                              WHERE shipzone_id=NEW.shipto_shipzone_id) || '"' ) );
        END IF;
        IF (OLD.shipto_salesrep_id <> NEW.shipto_salesrep_id) THEN
          PERFORM postComment( _cmnttypeid, 'C', NEW.shipto_cust_id,
                               ( NEW.shipto_name || ': Ship To Sales Rep Changed from "' || (SELECT salesrep_name
                                                                                             FROM salesrep
                                                                                             WHERE salesrep_id=OLD.shipto_salesrep_id) ||
                                 '" to "' || (SELECT salesrep_name
                                              FROM salesrep
                                              WHERE salesrep_id=NEW.shipto_salesrep_id) || '"' ) );
        END IF;
        IF (OLD.shipto_active <> NEW.shipto_active) THEN
          IF (NEW.shipto_active) THEN
            PERFORM postComment(_cmnttypeid, 'C', NEW.shipto_cust_id, (NEW.shipto_name || ': Ship To Activated'));
          ELSE
            PERFORM postComment(_cmnttypeid, 'C', NEW.shipto_cust_id, (NEW.shipto_name || ': Ship To Deactivated'));
          END IF;
        END IF;
      END IF;
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._shiptoinfoaftertrigger() OWNER TO admin;

--
-- Name: _shipviaafterdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _shipviaafterdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (SELECT fetchMetricValue('DefaultShipViaId') = OLD.shipvia_id) THEN
    RAISE EXCEPTION 'Cannot delete the default Ship-Via [xtuple: shipvia, -1, %]',
                    OLD.shipvia_code;
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._shipviaafterdeletetrigger() OWNER TO admin;

--
-- Name: _sltransaltertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _sltransaltertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _externalCompany      BOOLEAN := false;
  _updated BOOLEAN := false;
BEGIN
  IF(TG_OP='DELETE') THEN
    RAISE EXCEPTION 'You may not delete Journal Transactions once they have been created.';
  ELSIF (TG_OP = 'UPDATE') THEN	
    IF(OLD.sltrans_id != NEW.sltrans_id) THEN
      _updated := true;
    ELSIF(OLD.sltrans_date != NEW.sltrans_date) THEN
      _updated := true;
    ELSIF(OLD.sltrans_accnt_id != NEW.sltrans_accnt_id) THEN
      _updated := true;
    ELSIF(OLD.sltrans_amount != NEW.sltrans_amount) THEN
      _updated := true;
    ELSIF(OLD.sltrans_username != NEW.sltrans_username) THEN
      _updated := true;
    ELSIF( (OLD.sltrans_sequence IS NULL     AND NEW.sltrans_sequence IS NOT NULL)
        OR (OLD.sltrans_sequence IS NOT NULL AND NEW.sltrans_sequence IS NULL)
        OR (COALESCE(OLD.sltrans_sequence,0) != COALESCE(NEW.sltrans_sequence,0)) ) THEN
      _updated := true;
    ELSIF( (OLD.sltrans_created IS NULL     AND NEW.sltrans_created IS NOT NULL)
        OR (OLD.sltrans_created IS NOT NULL AND NEW.sltrans_created IS NULL)
        OR (COALESCE(OLD.sltrans_created,now()) != COALESCE(NEW.sltrans_created,now())) ) THEN
      _updated := true;
    ELSIF( (OLD.sltrans_source IS NULL     AND NEW.sltrans_source IS NOT NULL)
        OR (OLD.sltrans_source IS NOT NULL AND NEW.sltrans_source IS NULL)
        OR (COALESCE(OLD.sltrans_source,'') != COALESCE(NEW.sltrans_source,'')) ) THEN
      _updated := true;
    ELSIF( (OLD.sltrans_docnumber IS NULL     AND NEW.sltrans_docnumber IS NOT NULL)
        OR (OLD.sltrans_docnumber IS NOT NULL AND NEW.sltrans_docnumber IS NULL)
        OR (COALESCE(OLD.sltrans_docnumber,'') != COALESCE(NEW.sltrans_docnumber,'')) ) THEN
      _updated := true;
    ELSIF( (OLD.sltrans_doctype IS NULL     AND NEW.sltrans_doctype IS NOT NULL)
        OR (OLD.sltrans_doctype IS NOT NULL AND NEW.sltrans_doctype IS NULL)
        OR (COALESCE(OLD.sltrans_doctype,'') != COALESCE(NEW.sltrans_doctype,'')) ) THEN
      _updated := true;
    END IF;

    IF(_updated) THEN
      RAISE EXCEPTION 'You may not alter some Journal Transaction fields once they have been created.';
    END IF;
  ELSE
    RAISE EXCEPTION 'trigger for sltrans table called in unexpected state.';
  END IF;
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._sltransaltertrigger() OWNER TO admin;

--
-- Name: _sltransinserttrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _sltransinserttrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _reqNotes BOOLEAN;
  _externalCompany      BOOLEAN := false;
BEGIN
  -- Checks
  SELECT company_external INTO _externalCompany
  FROM company JOIN accnt ON (company_number=accnt_company)
  WHERE (accnt_id=NEW.sltrans_accnt_id);
  IF (_externalCompany) THEN
    RAISE EXCEPTION 'Transactions are not allowed for G/L Accounts with External Company segments.';
  END IF;
  
  RETURN NEW;
END;
$$;


ALTER FUNCTION public._sltransinserttrigger() OWNER TO admin;

--
-- Name: _soheadtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _soheadtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _p RECORD;
  _a RECORD;
  _w RECORD;
  _shiptoId INTEGER;
  _addrId INTEGER;
  _prjId INTEGER;
  _check BOOLEAN;
  _numGen CHAR(1);

BEGIN

  -- Checks
  -- Start with privileges
  IF (TG_OP = 'INSERT') THEN
    IF ( (NOT checkPrivilege('MaintainSalesOrders')) AND
       (NOT checkPrivilege('EnterReceipts')) ) THEN
      RAISE EXCEPTION 'You do not have privileges to create a Sales Order.';
    END IF;
  ELSIF (TG_OP = 'UPDATE') THEN
    IF ( (NOT checkPrivilege('MaintainSalesOrders')) AND
         (NOT checkPrivilege('IssueStockToShipping')) AND
         (NEW.cohead_holdtype = OLD.cohead_holdtype) ) THEN
      RAISE EXCEPTION 'You do not have privileges to alter a Sales Order.';
    END IF;
  ELSE
    IF ( (NOT checkPrivilege('MaintainSalesOrders')) AND
         (NOT checkPrivilege('IssueStockToShipping')) ) THEN
      RAISE EXCEPTION 'You do not have privileges to alter a Sales Order.';
    END IF;
  END IF;

  -- If this is imported, check the order number
  IF (TG_OP = 'INSERT') THEN
    IF (NEW.cohead_imported) THEN
      SELECT fetchMetricText('CONumberGeneration') INTO _numGen;
      IF ((NEW.cohead_number IS NULL) AND (_numGen='M')) THEN
        RAISE EXCEPTION 'You must supply an Order Number.';
      ELSE
        IF (NEW.cohead_number IS NULL) THEN
          SELECT fetchsonumber() INTO NEW.cohead_number;
        END IF;
      END IF;
    END IF;

    IF (fetchMetricText('CONumberGeneration') IN ('A','O')) THEN
      --- clear the number from the issue cache
      PERFORM clearNumberIssue('SoNumber', NEW.cohead_number);
    END IF;
  ELSE
    IF (TG_OP = 'UPDATE') THEN
      IF (NEW.cohead_number <> OLD.cohead_number) THEN
        RAISE EXCEPTION 'The order number may not be changed.';
      END IF;
    END IF;
  END IF;

  IF (TG_OP IN ('INSERT','UPDATE')) THEN

    -- Get Customer data
    IF (NEW.cohead_shipto_id IS NULL) THEN
      SELECT cust_creditstatus,cust_number,cust_usespos,cust_blanketpos,cust_ffbillto,
	     cust_ffshipto,cust_name,cust_salesrep_id,cust_terms_id,cust_shipvia,
	     cust_shipchrg_id,cust_shipform_id,cust_commprcnt,cust_curr_id,cust_taxzone_id,
  	     cntct.*,addr.*,
	     shipto_id,shipto_addr_id,shipto_name,shipto_salesrep_id,shipto_shipvia,
	     shipto_shipchrg_id,shipto_shipform_id,shipto_commission,shipto_taxzone_id INTO _p
      FROM custinfo
        LEFT OUTER JOIN cntct ON (cust_cntct_id=cntct_id)
        LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)
        LEFT OUTER JOIN shiptoinfo ON ((cust_id=shipto_cust_id) AND shipto_default)
      WHERE (cust_id=NEW.cohead_cust_id);
    ELSE
      SELECT cust_creditstatus,cust_number,cust_usespos,cust_blanketpos,cust_ffbillto,
	     cust_ffshipto,cust_name,cust_salesrep_id,cust_terms_id,cust_shipvia,
	     cust_shipchrg_id,cust_shipform_id,cust_commprcnt,cust_curr_id,cust_taxzone_id,
  	     cntct.*,addr.*,
	     shipto_id,shipto_addr_id,shipto_name,shipto_salesrep_id,shipto_shipvia,
	     shipto_shipchrg_id,shipto_shipform_id,shipto_commission,shipto_taxzone_id INTO _p
      FROM shiptoinfo,custinfo
        LEFT OUTER JOIN cntct ON (cust_cntct_id=cntct_id)
        LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)
      WHERE ((cust_id=NEW.cohead_cust_id)
        AND  (shipto_id=NEW.cohead_shipto_id));
    END IF;

    -- If there is customer data, then we can get to work
    IF (FOUND) THEN

      -- Check Credit
      IF (TG_OP = 'INSERT') THEN
          IF (_p.cust_creditstatus = 'H') THEN
            SELECT checkPrivilege('CreateSOForHoldCustomer') INTO _check;
            IF NOT (_check) THEN
              RAISE EXCEPTION 'Customer % has been placed 
                               on a Credit Hold and you do not have 
                               privilege to create Sales Orders for 
                               Customers on Credit Hold.  The selected 
                               Customer must be taken off of Credit Hold 
                               before you may create a new Sales Order 
                               for the Customer.',_p.cust_number;
            ELSE
              NEW.cohead_holdtype='C';
            END IF;
          END IF;
          IF (_p.cust_creditstatus = 'W') THEN
            SELECT checkPrivilege('CreateSOForWarnCustomer') INTO _check;
            IF NOT (_check) THEN
              RAISE EXCEPTION 'Customer % has been placed on 
                              a Credit Warning and you do not have 
                              privilege to create Sales Orders for 
                              Customers on Credit Warning.  The 
                              selected Customer must be taken off of 
                              Credit Warning before you may create a 
                              new Sales Order for the Customer.',_p.cust_number;
            ELSE
              NEW.cohead_holdtype='C';
            END IF;
          END IF;

          -- Set to defaults if values not provided
          NEW.cohead_shipto_id 	:= COALESCE(NEW.cohead_shipto_id,_p.shipto_id);
          NEW.cohead_terms_id		:= COALESCE(NEW.cohead_terms_id,_p.cust_terms_id);
          NEW.cohead_orderdate		:= COALESCE(NEW.cohead_orderdate,current_date);
          NEW.cohead_packdate		:= COALESCE(NEW.cohead_packdate,NEW.cohead_orderdate);
          NEW.cohead_curr_id		:= COALESCE(NEW.cohead_curr_id,_p.cust_curr_id,basecurrid());
          NEW.cohead_freight		:= COALESCE(NEW.cohead_freight,0);
          NEW.cohead_custponumber	:= COALESCE(NEW.cohead_custponumber,'');
          NEW.cohead_ordercomments	:= COALESCE(NEW.cohead_ordercomments,'');
          NEW.cohead_shipcomments	:= COALESCE(NEW.cohead_shipcomments,'');
          NEW.cohead_shiptophone	:= COALESCE(NEW.cohead_shiptophone,'');
          NEW.cohead_misc		:= COALESCE(NEW.cohead_misc,0);
          NEW.cohead_misc_descrip	:= COALESCE(NEW.cohead_misc_descrip,'');
          NEW.cohead_shipcomplete	:= COALESCE(NEW.cohead_shipcomplete,false);

          IF (_p.shipto_id IS NOT NULL) THEN -- Pull in over ride values
	    NEW.cohead_salesrep_id 	:= COALESCE(NEW.cohead_salesrep_id,_p.shipto_salesrep_id);
	    NEW.cohead_shipvia		:= COALESCE(NEW.cohead_shipvia,_p.shipto_shipvia);
	    NEW.cohead_shipchrg_id	:= COALESCE(NEW.cohead_shipchrg_id,_p.shipto_shipchrg_id);
	    NEW.cohead_shipform_id	:= COALESCE(NEW.cohead_shipform_id,_p.shipto_shipform_id);
	    NEW.cohead_commission	:= COALESCE(NEW.cohead_commission,_p.shipto_commission);
	    IF (NEW.cohead_taxzone_id=-1) THEN
	      NEW.cohead_taxzone_id 	:= NULL;
	    ELSE
	      NEW.cohead_taxzone_id	:= COALESCE(NEW.cohead_taxzone_id,_p.shipto_taxzone_id);
	    END IF;
	  ELSE
	    NEW.cohead_salesrep_id 	:= COALESCE(NEW.cohead_salesrep_id,_p.cust_salesrep_id);
	    NEW.cohead_shipvia		:= COALESCE(NEW.cohead_shipvia,_p.cust_shipvia);
	    NEW.cohead_shipchrg_id	:= COALESCE(NEW.cohead_shipchrg_id,_p.cust_shipchrg_id);
	    NEW.cohead_shipform_id	:= COALESCE(NEW.cohead_shipform_id,_p.cust_shipform_id);
	    NEW.cohead_commission	:= COALESCE(NEW.cohead_commission,_p.cust_commprcnt);
	    IF (NEW.cohead_taxzone_id=-1) THEN
	      NEW.cohead_taxzone_id 	:= NULL;
	    ELSE
	      NEW.cohead_taxzone_id	:= COALESCE(NEW.cohead_taxzone_id,_p.cust_taxzone_id);
	    END IF;
          END IF;

          IF ((NEW.cohead_warehous_id IS NULL) OR (NEW.cohead_fob IS NULL)) THEN
            IF (NEW.cohead_warehous_id IS NULL) THEN
              SELECT warehous_id,warehous_fob INTO _w
              FROM usrpref, whsinfo
              WHERE ((warehous_id=CAST(usrpref_value AS INTEGER))
                AND (warehous_shipping)
                AND (warehous_active)
                AND (usrpref_username=getEffectiveXtUser())
                AND (usrpref_name='PreferredWarehouse'));
            ELSE
              SELECT warehous_id,warehous_fob INTO _w
              FROM whsinfo
              WHERE (warehous_id=NEW.cohead_warehous_id);
            END IF;
            
            IF (FOUND) THEN
              NEW.cohead_warehous_id 	:= COALESCE(NEW.cohead_warehous_id,_w.warehous_id);
              NEW.cohead_fob		:= COALESCE(NEW.cohead_fob,_w.warehous_fob);
            END IF;
          END IF;
          
      END IF;

      -- Only Check P/O logic for imports, because UI checks when entire order is saved
      IF (NEW.cohead_imported) THEN

        -- Check for required Purchase Order
        IF (_p.cust_usespos AND ((NEW.cohead_custponumber IS NULL) OR (TRIM(BOTH FROM NEW.cohead_custponumber)=''))) THEN
            RAISE EXCEPTION 'You must enter a Customer P/O for this Sales Order.';
        END IF;
 
        -- Check for duplicate Purchase Orders if not allowed
        IF (_p.cust_usespos AND NOT (_p.cust_blanketpos)) THEN
          SELECT cohead_id INTO _a
          FROM cohead
          WHERE ((cohead_cust_id=NEW.cohead_cust_id)
          AND  (cohead_id<>NEW.cohead_id)
          AND  (UPPER(cohead_custponumber) = UPPER(NEW.cohead_custponumber)) )
          UNION
          SELECT quhead_id
          FROM quhead
          WHERE ((quhead_cust_id=NEW.cohead_cust_id)
          AND  (quhead_id<>NEW.cohead_id)
          AND  (UPPER(quhead_custponumber) = UPPER(NEW.cohead_custponumber)) );
          IF (FOUND) THEN
	    RAISE EXCEPTION 'This Customer does not use Blanket P/O
                            Numbers and the P/O Number you entered has 
                            already been used for another Sales Order.
                            Please verify the P/O Number and either
                            enter a new P/O Number or add to the
                            existing Sales Order.';
         END IF;
        END IF;
      END IF;

      --Auto create project if applicable
      IF ((TG_OP = 'INSERT') AND (NEW.cohead_prj_id IS NULL)) THEN
        SELECT fetchMetricBool('AutoCreateProjectsForOrders') INTO _check;
        IF (_check) THEN
          SELECT NEXTVAL('prj_prj_id_seq') INTO _prjId;
          NEW.cohead_prj_id := _prjId;
          INSERT INTO prj (prj_id, prj_number, prj_name, prj_descrip, prj_status, prj_so, prj_wo, prj_po)
               VALUES(_prjId, NEW.cohead_number, NEW.cohead_number, 'Auto Generated Project from Sales Order.', 'O', TRUE, TRUE, TRUE);
        END IF;
      END IF;

      IF (TG_OP = 'UPDATE') THEN
        SELECT true INTO _check
        FROM coitem
        WHERE ( (coitem_status='C')
        AND (coitem_cohead_id=NEW.cohead_id) ) 
        LIMIT 1;

        IF (NOT FOUND) THEN

        --Update project references on supply
        UPDATE pr SET pr_prj_id=NEW.cohead_prj_id
                   FROM coitem
                   WHERE ((coitem_cohead_id=NEW.cohead_id) 
                   AND  (coitem_order_type='R') 
                   AND  (coitem_order_id=pr_id));

        PERFORM changeWoProject(coitem_order_id, NEW.cohead_prj_id, TRUE)
                    FROM coitem
                    WHERE ((coitem_cohead_id=NEW.cohead_id)
                    AND  (coitem_order_type='W'));
        ELSE
          IF NEW.cohead_prj_id <> COALESCE(OLD.cohead_prj_id,-1) THEN
            RAISE EXCEPTION 'You can not change the project ID on orders with closed lines.';
          END IF;
        END IF;
      END IF;

      -- Deal with Billing Address
      IF (TG_OP = 'INSERT') THEN
        IF (_p.cust_ffbillto) THEN
          -- If they didn't supply data, we'll put in the bill to contact and address
          NEW.cohead_billto_cntct_id=COALESCE(NEW.cohead_billto_cntct_id,_p.cntct_id);
          NEW.cohead_billto_cntct_honorific=COALESCE(NEW.cohead_billto_cntct_honorific,_p.cntct_honorific,'');
          NEW.cohead_billto_cntct_first_name=COALESCE(NEW.cohead_billto_cntct_first_name,_p.cntct_first_name,'');
          NEW.cohead_billto_cntct_middle=COALESCE(NEW.cohead_billto_cntct_middle,_p.cntct_middle,'');    
          NEW.cohead_billto_cntct_last_name=COALESCE(NEW.cohead_billto_cntct_last_name,_p.cntct_last_name,''); 
          NEW.cohead_billto_cntct_phone=COALESCE(NEW.cohead_billto_cntct_phone,_p.cntct_phone,'');
          NEW.cohead_billto_cntct_title=COALESCE(NEW.cohead_billto_cntct_title,_p.cntct_title,'');
          NEW.cohead_billto_cntct_fax=COALESCE(NEW.cohead_billto_cntct_fax,_p.cntct_fax,''); 
          NEW.cohead_billto_cntct_email=COALESCE(NEW.cohead_billto_cntct_email,_p.cntct_email,''); 
          NEW.cohead_billtoname=COALESCE(NEW.cohead_billtoname,_p.cust_name,'');
          NEW.cohead_billtoaddress1=COALESCE(NEW.cohead_billtoaddress1,_p.addr_line1,'');
          NEW.cohead_billtoaddress2=COALESCE(NEW.cohead_billtoaddress2,_p.addr_line2,'');
          NEW.cohead_billtoaddress3=COALESCE(NEW.cohead_billtoaddress3,_p.addr_line3,'');    
          NEW.cohead_billtocity=COALESCE(NEW.cohead_billtocity,_p.addr_city,''); 
          NEW.cohead_billtostate=COALESCE(NEW.cohead_billtostate,_p.addr_state,'');
          NEW.cohead_billtozipcode=COALESCE(NEW.cohead_billtozipcode,_p.addr_postalcode,'');
          NEW.cohead_billtocountry=COALESCE(NEW.cohead_billtocountry,_p.addr_country,'');   
        ELSE
          -- Free form not allowed, we're going to put in the address regardless
          NEW.cohead_billto_cntct_id=_p.cntct_id;
          NEW.cohead_billto_cntct_honorific=COALESCE(_p.cntct_honorific,'');
          NEW.cohead_billto_cntct_first_name=COALESCE(_p.cntct_first_name,'');
          NEW.cohead_billto_cntct_middle=COALESCE(_p.cntct_middle,'');    
          NEW.cohead_billto_cntct_last_name=COALESCE(_p.cntct_last_name,''); 
          NEW.cohead_billto_cntct_phone=COALESCE(_p.cntct_phone,'');
          NEW.cohead_billto_cntct_title=COALESCE(_p.cntct_title,'');
          NEW.cohead_billto_cntct_fax=COALESCE(_p.cntct_fax,''); 
          NEW.cohead_billto_cntct_email=COALESCE(_p.cntct_email,''); 
          NEW.cohead_billtoname=COALESCE(_p.cust_name,'');
          NEW.cohead_billtoaddress1=COALESCE(_p.addr_line1,'');
          NEW.cohead_billtoaddress2=COALESCE(_p.addr_line2,'');
          NEW.cohead_billtoaddress3=COALESCE(_p.addr_line3,'');    
          NEW.cohead_billtocity=COALESCE(_p.addr_city,''); 
          NEW.cohead_billtostate=COALESCE(_p.addr_state,'');
          NEW.cohead_billtozipcode=COALESCE(_p.addr_postalcode,'');
          NEW.cohead_billtocountry=COALESCE(_p.addr_country,'');
        END IF;
      END IF;

      -- Now let's look at Shipto Address
      -- If there's nothing in the address fields and there is a shipto id 
      -- or there is a default address available, let's put in some shipto address data
      IF ((TG_OP = 'INSERT') 
        AND NOT ((NEW.cohead_shipto_id IS NULL) AND NOT _p.cust_ffshipto)
        AND (NEW.cohead_shipto_cntct_id IS NULL)
        AND (NEW.cohead_shipto_cntct_honorific IS NULL)
        AND (NEW.cohead_shipto_cntct_first_name IS NULL)
        AND (NEW.cohead_shipto_cntct_middle IS NULL)
        AND (NEW.cohead_shipto_cntct_last_name IS NULL)
        AND (NEW.cohead_shipto_cntct_suffix IS NULL)
        AND (NEW.cohead_shipto_cntct_phone IS NULL)
        AND (NEW.cohead_shipto_cntct_title IS NULL)
        AND (NEW.cohead_shipto_cntct_fax IS NULL)
        AND (NEW.cohead_shipto_cntct_email IS NULL)
        AND (NEW.cohead_shiptoname IS NULL)
        AND (NEW.cohead_shiptoaddress1 IS NULL)
        AND (NEW.cohead_shiptoaddress2 IS NULL)
        AND (NEW.cohead_shiptoaddress3 IS NULL)
        AND (NEW.cohead_shiptocity IS NULL)
        AND (NEW.cohead_shiptostate IS NULL)
        AND (NEW.cohead_shiptocountry IS NULL)) THEN
        IF ((NEW.cohead_shipto_id IS NULL) AND (_p.shipto_id IS NOT NULL)) THEN
          _shiptoId := _p.shipto_addr_id;
        ELSE
          _shiptoId := NEW.cohead_shipto_id;
        END IF;

        SELECT * INTO _a 
        FROM shiptoinfo
          LEFT OUTER JOIN addr ON (addr_id=shipto_addr_id)
          LEFT OUTER JOIN cntct ON (cntct_id=shipto_cntct_id)
        WHERE (shipto_id=_shiptoId);

        NEW.cohead_shipto_cntct_id := _a.cntct_id;
        NEW.cohead_shipto_cntct_honorific := COALESCE(_a.cntct_honorific,'');
        NEW.cohead_shipto_cntct_first_name := COALESCE(_a.cntct_first_name,'');
        NEW.cohead_shipto_cntct_middle := COALESCE(_a.cntct_middle,'');
        NEW.cohead_shipto_cntct_last_name := COALESCE(_a.cntct_last_name,'');
	NEW.cohead_shipto_cntct_suffix := COALESCE(_a.cntct_suffix,'');
	NEW.cohead_shipto_cntct_phone := COALESCE(_a.cntct_phone,'');
	NEW.cohead_shipto_cntct_title := COALESCE(_a.cntct_title,'');
	NEW.cohead_shipto_cntct_fax := COALESCE(_a.cntct_fax,'');
	NEW.cohead_shipto_cntct_email := COALESCE(_a.cntct_email,'');
        NEW.cohead_shiptoname := COALESCE(_p.shipto_name,'');
        NEW.cohead_shiptoaddress1 := COALESCE(_a.addr_line1,'');
        NEW.cohead_shiptoaddress2 := COALESCE(_a.addr_line2,'');
        NEW.cohead_shiptoaddress3 := COALESCE(_a.addr_line3,'');    
        NEW.cohead_shiptocity := COALESCE(_a.addr_city,''); 
        NEW.cohead_shiptostate := COALESCE(_a.addr_state,'');
        NEW.cohead_shiptozipcode := COALESCE(_a.addr_postalcode,'');
        NEW.cohead_shiptocountry := COALESCE(_a.addr_country,'');
      ELSE
        IF (_p.cust_ffshipto) THEN
          -- Use Address Save function to see if the new address entered matches
          -- data for the shipto number.  If not that will insert new address for CRM
          SELECT SaveAddr(
            NULL,
            NULL,
            NEW.cohead_shiptoaddress1,
            NEW.cohead_shiptoaddress2,
            NEW.cohead_shiptoaddress3,
            NEW.cohead_shiptocity,
            NEW.cohead_shiptostate,
            NEW.cohead_shiptozipcode,
            NEW.cohead_shiptocountry,
            'CHANGEONE') INTO _addrId;
          SELECT shipto_addr_id INTO _shiptoid FROM shiptoinfo WHERE (shipto_id=NEW.cohead_shipto_id);
          -- If the address passed doesn't match shipto address, then it's something else
          IF (_shiptoid <> _addrId) THEN
            NEW.cohead_shipto_id := NULL;
          END IF;
        ELSE
          SELECT cohead_shipto_id INTO _shiptoid FROM cohead WHERE (cohead_id=NEW.cohead_id);
          -- Get the shipto address
          IF (COALESCE(NEW.cohead_shipto_id,-1) <> COALESCE(_shiptoid,-1)) THEN
            SELECT * INTO _a 
            FROM shiptoinfo
              LEFT OUTER JOIN cntct ON (shipto_cntct_id=cntct_id)
              LEFT OUTER JOIN addr ON (shipto_addr_id=addr_id)
            WHERE (shipto_id=NEW.cohead_shipto_id);
            IF (FOUND) THEN
              -- Free form not allowed so we're going to make sure address matches Shipto data
              NEW.cohead_shipto_cntct_id=_a.cntct_id;
              NEW.cohead_shipto_cntct_honorific=COALESCE(_a.cntct_honorific,'');
              NEW.cohead_shipto_cntct_first_name=COALESCE(_a.cntct_first_name,'');
              NEW.cohead_shipto_cntct_middle=COALESCE(_a.cntct_middle,'');    
              NEW.cohead_shipto_cntct_last_name=COALESCE(_a.cntct_last_name,''); 
              NEW.cohead_shipto_cntct_phone=COALESCE(_a.cntct_phone,'');
              NEW.cohead_shipto_cntct_title=COALESCE(_a.cntct_title,'');
              NEW.cohead_shipto_cntct_fax=COALESCE(_a.cntct_fax,''); 
              NEW.cohead_shipto_cntct_email=COALESCE(_a.cntct_email,''); 
              NEW.cohead_shiptoname := COALESCE(_a.shipto_name,'');
              NEW.cohead_shiptophone := COALESCE(_a.cntct_phone,'');
              NEW.cohead_shiptoaddress1 := COALESCE(_a.addr_line1,'');
              NEW.cohead_shiptoaddress2 := COALESCE(_a.addr_line2,'');
              NEW.cohead_shiptoaddress3 := COALESCE(_a.addr_line3,'');    
              NEW.cohead_shiptocity := COALESCE(_a.addr_city,''); 
              NEW.cohead_shiptostate := COALESCE(_a.addr_state,'');
              NEW.cohead_shiptozipcode := COALESCE(_a.addr_postalcode,'');
              NEW.cohead_shiptocountry := COALESCE(_a.addr_country,''); 
            ELSE
              -- If no shipto data and free form not allowed, this won't work
              RAISE EXCEPTION 'Free form Shipto is not allowed on this Customer. You must supply a valid Shipto ID.';
            END IF;
          END IF;
        END IF;
      END IF;
    END IF;
  END IF;

  IF ( SELECT (metric_value='t')
       FROM metric
       WHERE (metric_name='SalesOrderChangeLog') ) THEN

    IF (TG_OP = 'INSERT') THEN
      PERFORM postComment('ChangeLog', 'S', NEW.cohead_id, 'Created');

    ELSIF (TG_OP = 'UPDATE') THEN

      IF (OLD.cohead_terms_id <> NEW.cohead_terms_id) THEN
        PERFORM postComment( 'ChangeLog', 'S', NEW.cohead_id,
                             ('Terms Changed from "' || oldterms.terms_code || '" to "' || newterms.terms_code || '"') )
        FROM terms AS oldterms, terms AS newterms
        WHERE ( (oldterms.terms_id=OLD.cohead_terms_id)
         AND (newterms.terms_id=NEW.cohead_terms_id) );
      END IF;

      IF (OLD.cohead_shipvia <> NEW.cohead_shipvia) THEN
        PERFORM postComment ('ChangeLog', 'S', New.cohead_id, ('Shipvia Changed from "' || OLD.cohead_shipvia || '" to "' || NEW.cohead_shipvia || '"'));
      END IF;

      IF (OLD.cohead_holdtype <> NEW.cohead_holdtype) THEN
        PERFORM postComment( 'ChangeLog', 'S', NEW.cohead_id,
                             ( 'Hold Type Changed from ' || (CASE OLD.cohead_holdtype WHEN('N') THEN 'No Hold'
                                                                                      WHEN('C') THEN 'Credit Hold'
                                                                                      WHEN('P') THEN 'Packing Hold'
                                                                                      WHEN('S') THEN 'Shipping Hold'
                                                                                      ELSE 'Unknown/Error' END) ||
                               ' to ' || (CASE NEW.cohead_holdtype WHEN('N') THEN 'No Hold'
                                                                   WHEN('C') THEN 'Credit Hold'
                                                                   WHEN('P') THEN 'Packing Hold'
                                                                   WHEN('S') THEN 'Shipping Hold'
                                                                   ELSE 'Unknown/Error' END) ) );
      END IF;

    ELSIF (TG_OP = 'DELETE') THEN
      DELETE FROM docass WHERE docass_source_id = OLD.cohead_id AND docass_source_type = 'S';
      DELETE FROM docass WHERE docass_target_id = OLD.cohead_id AND docass_target_type = 'S';
      
      DELETE FROM comment
      WHERE ( (comment_source='S')
       AND (comment_source_id=OLD.cohead_id) );
    END IF;
  END IF;

  IF (TG_OP = 'UPDATE') THEN
    IF ( (NOT (OLD.cohead_holdtype = 'N')) AND
         (NEW.cohead_holdtype='N') ) THEN
      INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                            evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number )
      SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
             'S', NEW.cohead_id, NEW.cohead_warehous_id, NEW.cohead_number::TEXT
      FROM evntnot, evnttype
      WHERE ( (evntnot_evnttype_id=evnttype_id)
       AND (evntnot_warehous_id=NEW.cohead_warehous_id)
       AND (evnttype_name='SoReleased') );
    END IF;

    IF (OLD.cohead_ordercomments <> NEW.cohead_ordercomments) THEN
      INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                            evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number )
      SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
             'S', NEW.cohead_id, NEW.cohead_warehous_id, NEW.cohead_number::TEXT
      FROM evntnot, evnttype
      WHERE ( (evntnot_evnttype_id=evnttype_id)
       AND (evntnot_warehous_id=NEW.cohead_warehous_id)
       AND (evnttype_name='SoNotesChanged') );
    END IF;

    IF ((OLD.cohead_shipchrg_id != NEW.cohead_shipchrg_id)
        OR (OLD.cohead_freight != NEW.cohead_freight)
        OR (OLD.cohead_shipvia != NEW.cohead_shipvia)) THEN
      UPDATE shiphead SET 
        shiphead_shipchrg_id=NEW.cohead_shipchrg_id,
        shiphead_freight=NEW.cohead_freight,
        shiphead_shipvia=NEW.cohead_shipvia
      WHERE ((shiphead_order_type='SO')
      AND  (shiphead_order_id=NEW.cohead_id)
      AND  (NOT shiphead_shipped));
    END IF;
  END IF;

  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  ELSE
    NEW.cohead_lastupdated = CURRENT_TIMESTAMP;

    RETURN NEW;
  END IF;

END;
$$;


ALTER FUNCTION public._soheadtrigger() OWNER TO admin;

--
-- Name: _soheadtriggerafter(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _soheadtriggerafter() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (COALESCE(NEW.cohead_taxzone_id,-1) <> COALESCE(OLD.cohead_taxzone_id,-1)) THEN
    UPDATE coitem SET coitem_taxtype_id=getItemTaxType(itemsite_item_id,NEW.cohead_taxzone_id)
    FROM itemsite 
    WHERE ((itemsite_id=coitem_itemsite_id)
     AND (coitem_cohead_id=NEW.cohead_id));
  END IF;

  -- update comments on any associated drop ship POs
  IF (COALESCE(NEW.cohead_shipcomments, TEXT('')) <> COALESCE(OLD.cohead_shipcomments, TEXT(''))) THEN
    UPDATE pohead SET pohead_comments=NEW.cohead_shipcomments
    FROM poitem JOIN coitem ON (coitem_cohead_id=NEW.cohead_id AND coitem_order_type='P' AND coitem_order_id=poitem_id)
    WHERE (pohead_id=poitem_pohead_id);
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._soheadtriggerafter() OWNER TO admin;

--
-- Name: _soitemafterdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _soitemafterdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

BEGIN

  IF (OLD.coitem_status = 'O') THEN
    IF ( (SELECT (count(*) < 1)
            FROM coitem
           WHERE ((coitem_cohead_id=OLD.coitem_cohead_id)
             AND  (coitem_id != OLD.coitem_id)
             AND  (coitem_status = 'O')) ) ) THEN
      UPDATE cohead SET cohead_status = 'C'
       WHERE ((cohead_id=OLD.coitem_cohead_id)
         AND  (cohead_status='O'));
    END IF;
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._soitemafterdeletetrigger() OWNER TO admin;

--
-- Name: _soitemaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _soitemaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check NUMERIC;
  _r RECORD;
  _kit BOOLEAN;
  _fractional BOOLEAN;
  _rec RECORD;
  _kstat TEXT;
  _pstat TEXT;
  _result INTEGER;
  _coitemid INTEGER;
  _itemsrcid INTEGER;
  _orderid INTEGER;

BEGIN

  _rec := NEW;

  --Cache some information
  SELECT * INTO _r
  FROM cohead
  WHERE (cohead_id=_rec.coitem_cohead_id);

  --Determine if this is a kit for later processing
  SELECT COALESCE(item_type,'')='K', item_fractional
    INTO _kit, _fractional
    FROM itemsite, item
   WHERE((itemsite_item_id=item_id)
     AND (itemsite_id=_rec.coitem_itemsite_id));
  _kit := COALESCE(_kit, false);
  _fractional := COALESCE(_fractional, false);

  IF (_kit) THEN
  -- Kit Processing
    IF (TG_OP = 'INSERT') THEN
  -- Create Sub Lines for Kit Components
      PERFORM explodeKit(NEW.coitem_cohead_id, NEW.coitem_linenumber, 0, NEW.coitem_itemsite_id,
                         NEW.coitem_qtyord, NEW.coitem_scheddate, NEW.coitem_promdate, NEW.coitem_memo);
      IF (fetchMetricBool('KitComponentInheritCOS')) THEN
  -- Update kit line item COS
        UPDATE coitem
        SET coitem_cos_accnt_id = CASE WHEN (COALESCE(NEW.coitem_cos_accnt_id, -1) != -1)
                                         THEN NEW.coitem_cos_accnt_id
                                       WHEN (NEW.coitem_warranty)
                                         THEN resolveCOWAccount(NEW.coitem_itemsite_id, _r.cohead_cust_id, _r.cohead_saletype_id, _r.cohead_shipzone_id)
                                       ELSE resolveCOSAccount(NEW.coitem_itemsite_id, _r.cohead_cust_id, _r.cohead_saletype_id, _r.cohead_shipzone_id)
                                  END
        WHERE((coitem_cohead_id=NEW.coitem_cohead_id)
          AND (coitem_linenumber = NEW.coitem_linenumber)
          AND (coitem_subnumber > 0));
      END IF;
    END IF;
    IF (TG_OP = 'UPDATE') THEN
      IF (NEW.coitem_qtyord <> OLD.coitem_qtyord) THEN
  -- Recreate Sub Lines for Kit Components
      FOR _coitemid IN
        SELECT coitem_id
        FROM coitem
        WHERE ( (coitem_cohead_id=OLD.coitem_cohead_id)
          AND   (coitem_linenumber=OLD.coitem_linenumber)
          AND   (coitem_subnumber > 0) )
        LOOP
          SELECT deleteSoItem(_coitemid) INTO _result;
          IF (_result < 0) THEN
             RAISE EXCEPTION 'Error deleting kit components: deleteSoItem(integer) Error:%', _result;
          END IF;
        END LOOP;

        PERFORM explodeKit(NEW.coitem_cohead_id, NEW.coitem_linenumber, 0, NEW.coitem_itemsite_id,
                           NEW.coitem_qtyord, NEW.coitem_scheddate, NEW.coitem_promdate);
      END IF;
      IF ( (NEW.coitem_qtyord <> OLD.coitem_qtyord) OR
           (NEW.coitem_cos_accnt_id <> OLD.coitem_cos_accnt_id) ) THEN
        IF (fetchMetricBool('KitComponentInheritCOS')) THEN
  -- Update kit line item COS
          UPDATE coitem
          SET coitem_cos_accnt_id = CASE WHEN (COALESCE(NEW.coitem_cos_accnt_id, -1) != -1)
                                           THEN NEW.coitem_cos_accnt_id
                                         WHEN (NEW.coitem_warranty)
                                           THEN resolveCOWAccount(NEW.coitem_itemsite_id, _r.cohead_cust_id, _r.cohead_saletype_id, _r.cohead_shipzone_id)
                                         ELSE resolveCOSAccount(NEW.coitem_itemsite_id, _r.cohead_cust_id, _r.cohead_saletype_id, _r.cohead_shipzone_id)
                                    END
          WHERE((coitem_cohead_id=NEW.coitem_cohead_id)
            AND (coitem_linenumber = NEW.coitem_linenumber)
            AND (coitem_subnumber > 0));
        END IF;
      END IF;
      IF (NEW.coitem_scheddate <> OLD.coitem_scheddate) THEN
  -- Update kit line item Schedule Date
        UPDATE coitem
        SET coitem_scheddate = NEW.coitem_scheddate
        WHERE((coitem_cohead_id=NEW.coitem_cohead_id)
          AND (coitem_linenumber = NEW.coitem_linenumber)
          AND (coitem_subnumber > 0));
      END IF;
    END IF;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    -- Create Purchase Request if flagged to do so
    IF ((NEW.coitem_order_type='R') AND (NEW.coitem_order_id=-1)) THEN
      SELECT createpr(CAST(cohead_number AS INTEGER), 'S', NEW.coitem_id) INTO _orderid
      FROM cohead
      WHERE (cohead_id=NEW.coitem_cohead_id);
      IF (_orderid > 0) THEN
        UPDATE coitem SET coitem_order_id=_orderid
        WHERE (coitem_id=NEW.coitem_id);
      END IF;
    END IF;

    -- Create Purchase Order if flagged to do so
    IF ((NEW.coitem_order_type='P') AND (NEW.coitem_order_id=-1)) THEN
      SELECT itemsrc_id INTO _itemsrcid
      FROM itemsite JOIN itemsrc ON (itemsrc_item_id=itemsite_item_id AND itemsrc_default)
      WHERE (itemsite_id=NEW.coitem_itemsite_id);
      IF (FOUND) THEN
        SELECT createPurchaseToSale(NEW.coitem_id,
                                    _itemsrcid,
                                    itemsite_dropship,
                                    CASE WHEN (NEW.coitem_prcost=0.0) THEN NULL
                                         ELSE NEW.coitem_prcost
                                    END) INTO _orderid
        FROM itemsite
        WHERE (itemsite_id=NEW.coitem_itemsite_id);
        IF (_orderid > 0) THEN
          UPDATE coitem SET coitem_order_id=_orderid
          WHERE (coitem_id=NEW.coitem_id);
        END IF;
      END IF;
    END IF;
  END IF;

  IF (TG_OP = 'UPDATE') THEN
    IF (NEW.coitem_order_type = 'P') THEN
      --If soitem is cancelled
      IF ((NEW.coitem_status = 'X') AND (OLD.coitem_status <> 'X')) THEN
        --Generate the PoItemSoCancelled event
        INSERT INTO evntlog
                    ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                      evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id,
                      evntlog_number )
        SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
        'P', poitem_id, itemsite_warehous_id,
        (pohead_number || '-' || poitem_linenumber || ': ' || item_number)
        FROM evntnot JOIN evnttype ON (evntnot_evnttype_id=evnttype_id)
             JOIN itemsite ON (evntnot_warehous_id=itemsite_warehous_id)
             JOIN item ON (itemsite_item_id=item_id)
             JOIN poitem ON (poitem_itemsite_id=itemsite_id)
             JOIN pohead ON( poitem_pohead_id=pohead_id)
        WHERE( (poitem_id=OLD.coitem_order_id)
        AND (poitem_duedate <= (CURRENT_DATE + itemsite_eventfence))
        AND (evnttype_name='PoItemSoCancelled') );
      END IF;
    END IF;
  END IF;

  IF (_rec.coitem_subnumber > 0) THEN
    SELECT coitem_status
      INTO _kstat
      FROM coitem
     WHERE((coitem_cohead_id=_rec.coitem_cohead_id)
       AND (coitem_linenumber=_rec.coitem_linenumber)
       AND (coitem_subnumber = 0));
    IF ((SELECT count(*)
           FROM coitem
          WHERE((coitem_cohead_id=_rec.coitem_cohead_id)
            AND (coitem_linenumber=_rec.coitem_linenumber)
            AND (coitem_subnumber <> _rec.coitem_subnumber)
            AND (coitem_subnumber > 0)
            AND (coitem_status = 'O'))) > 0) THEN
      _pstat := 'O';
    ELSE
      _pstat := _rec.coitem_status;
    END IF;
  END IF;

  IF(TG_OP = 'INSERT') THEN
    IF (_rec.coitem_subnumber > 0 AND _rec.coitem_status = 'O') THEN
      _pstat := 'O';
    END IF;
  ELSIF (TG_OP = 'UPDATE') THEN
    IF (_rec.coitem_subnumber > 0 AND _rec.coitem_status = 'O') THEN
      _pstat := 'O';
    END IF;

    IF ((NEW.coitem_status = 'C') AND (OLD.coitem_status <> 'C')) THEN
      IF(_kit) THEN
        UPDATE coitem
           SET coitem_status='C'
         WHERE((coitem_cohead_id=OLD.coitem_cohead_id)
           AND (coitem_linenumber=OLD.coitem_linenumber)
           AND (coitem_status='O')
           AND (coitem_subnumber > 0));
      END IF;
    END IF;

    IF ((NEW.coitem_status = 'X') AND (OLD.coitem_status <> 'X')) THEN
      IF(_kit) THEN
        UPDATE coitem
           SET coitem_status='X'
         WHERE((coitem_cohead_id=OLD.coitem_cohead_id)
           AND (coitem_linenumber=OLD.coitem_linenumber)
           AND (coitem_status='O')
           AND (coitem_subnumber > 0));
      END IF;
    END IF;

    IF(NEW.coitem_status = 'O' AND OLD.coitem_status <> 'O') THEN
      IF(_kit) THEN
        UPDATE coitem
           SET coitem_status='O'
         WHERE((coitem_cohead_id=OLD.coitem_cohead_id)
           AND (coitem_linenumber=OLD.coitem_linenumber)
           AND ((coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) > 0)
           AND (coitem_subnumber > 0));
      END IF;
    END IF;

  END IF;

  IF ((_kstat IS NOT NULL) AND (_pstat IS NOT NULL) AND (_rec.coitem_subnumber > 0) AND (_kstat <> _pstat)) THEN
    UPDATE coitem
       SET coitem_status = _pstat
     WHERE((coitem_cohead_id=_rec.coitem_cohead_id)
       AND (coitem_linenumber=_rec.coitem_linenumber)
       AND (coitem_subnumber = 0));
  END IF;

  --If auto calculate freight, recalculate cohead_freight
  IF (SELECT cohead_calcfreight FROM cohead WHERE (cohead_id=NEW.coitem_cohead_id)) THEN
    UPDATE cohead SET cohead_freight = COALESCE(
      (SELECT SUM(freightdata_total) FROM freightDetail('SO',
                                                        cohead_id,
                                                        cohead_cust_id,
                                                        cohead_shipto_id,
                                                        cohead_orderdate,
                                                        cohead_shipvia,
                                                        cohead_curr_id)), 0)
    WHERE cohead_id=NEW.coitem_cohead_id;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._soitemaftertrigger() OWNER TO admin;

--
-- Name: _soitembeforedeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _soitembeforedeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

  _r              RECORD;
  _kit            BOOLEAN := FALSE;
  _shipped        BOOLEAN := FALSE;
  _coitemid       INTEGER := 0;
  _result         INTEGER := 0;

BEGIN

  -- Check Priv
  IF NOT (checkPrivilege('MaintainSalesOrders')) THEN
    RAISE EXCEPTION 'You do not have privileges to alter a Sales Order.';
  END IF;

  -- Cache some information
  SELECT * INTO _r
    FROM cohead, itemsite, item
   WHERE ( (cohead_id=OLD.coitem_cohead_id)
     AND   (itemsite_id=OLD.coitem_itemsite_id)
     AND   (item_id=itemsite_item_id) );

  _kit := (COALESCE(_r.item_type,'')='K');

  -- Check for shipped kit components
  IF(_kit AND OLD.coitem_status <> 'C' AND OLD.coitem_status <> 'X') THEN
    IF (EXISTS (SELECT coitem_id
                  FROM coitem JOIN shipitem ON (shipitem_orderitem_id=coitem_id)
                              JOIN shiphead ON (shiphead_id=shipitem_shiphead_id AND shiphead_order_type='SO')
                 WHERE ((coitem_cohead_id=OLD.coitem_cohead_id)
                   AND  (coitem_linenumber=OLD.coitem_linenumber)
                   AND (coitem_subnumber > 0))
              GROUP BY coitem_id
                HAVING (SUM(shipitem_qty) > 0)
                 LIMIT 1) ) THEN
      _shipped := TRUE;
    END IF;
  END IF;

  IF(_kit AND _shipped) THEN
    RAISE EXCEPTION 'You can not delete this Sales Order Line as it has several sub components that have already been shipped.';
  END IF;

  DELETE FROM comment
   WHERE ( (comment_source='SI')
     AND   (comment_source_id=OLD.coitem_id) );

  DELETE FROM charass
   WHERE ((charass_target_type='SI')
     AND  (charass_target_id=OLD.coitem_id));

  -- Delete Sub Lines for Kit Components
  IF (OLD.coitem_subnumber = 0) THEN
    FOR _coitemid IN
      SELECT coitem_id
        FROM coitem
       WHERE ( (coitem_cohead_id=OLD.coitem_cohead_id)
         AND   (coitem_linenumber=OLD.coitem_linenumber)
         AND   (coitem_subnumber > 0) )
      LOOP
      SELECT deleteSoItem(_coitemid) INTO _result;
      IF (_result < 0) THEN
        IF NOT (_r.itemsite_createsopo AND (_result = -10 OR _result = -20)) THEN
          RAISE EXCEPTION 'Error deleting kit components: deleteSoItem(integer) Error:%', _result;
        END IF;
      END IF;
    END LOOP;
  END IF;

  INSERT INTO evntlog ( evntlog_evnttime, evntlog_username,
                        evntlog_evnttype_id, evntlog_ordtype,
                        evntlog_ord_id, evntlog_warehous_id, evntlog_number )
  SELECT CURRENT_TIMESTAMP, evntnot_username,
	   evnttype_id, 'S',
	   OLD.coitem_id, _r.itemsite_warehous_id,
	   (_r.cohead_number || '-' || OLD.coitem_linenumber)
    FROM evntnot, evnttype
   WHERE ( (evntnot_evnttype_id=evnttype_id)
     AND   (evntnot_warehous_id=_r.itemsite_warehous_id)
     AND   (OLD.coitem_scheddate <= (CURRENT_DATE + _r.itemsite_eventfence))
     AND   (evnttype_name='SoitemCancelled') );

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._soitembeforedeletetrigger() OWNER TO admin;

--
-- Name: _soitembeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _soitembeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check NUMERIC;
  _itemNumber TEXT;
  _r RECORD;
  _kit BOOLEAN;

BEGIN

  --Determine if this is a kit for later processing
  SELECT COALESCE(item_type,'')='K'
  INTO _kit
  FROM itemsite, item
  WHERE((itemsite_item_id=item_id)
  AND (itemsite_id=NEW.coitem_itemsite_id));
  _kit := COALESCE(_kit, false);
  
  IF (TG_OP = 'INSERT') THEN

    -- If this is imported, go ahead and insert default characteristics
    IF (NEW.coitem_imported) THEN
      INSERT INTO charass (charass_target_type, charass_target_id, charass_char_id, charass_value, charass_price)
      SELECT 'SI', NEW.coitem_id, char_id, charass_value,
             itemcharprice(item_id,char_id,charass_value,cohead_cust_id,cohead_shipto_id,NEW.coitem_qtyord,cohead_curr_id,cohead_orderdate) 
        FROM (
           SELECT DISTINCT char_id, char_name, charass_value, item_id, cohead_cust_id, cohead_shipto_id, cohead_curr_id, cohead_orderdate
             FROM cohead, charass, char, itemsite, item
            WHERE((itemsite_id=NEW.coitem_itemsite_id)
              AND (itemsite_item_id=item_id)
              AND (charass_target_type='I') 
              AND (charass_target_id=item_id)
              AND (charass_default)
              AND (char_id=charass_char_id)
              AND (cohead_id=NEW.coitem_cohead_id))
           ORDER BY char_name) AS data;
    END IF;
  END IF;

  -- Create work order and process if flagged to do so
  IF ((NEW.coitem_order_type='W') AND (NEW.coitem_order_id=-1)) THEN
    SELECT createwo(CAST(cohead_number AS INTEGER),
                    NEW.coitem_itemsite_id,
                    1, -- priority
		    validateOrderQty(NEW.coitem_itemsite_id, NEW.coitem_qtyord, TRUE),
                    itemsite_leadtime,
                    NEW.coitem_scheddate,
		    NEW.coitem_memo,
                    'S',
                    NEW.coitem_id,
		    cohead_prj_id) INTO NEW.coitem_order_id
    FROM cohead, itemsite 
    WHERE ((cohead_id=NEW.coitem_cohead_id)
    AND (itemsite_id=NEW.coitem_itemsite_id));

    INSERT INTO charass
      (charass_target_type, charass_target_id,
       charass_char_id, charass_value) 
       SELECT 'W', NEW.coitem_order_id, charass_char_id, charass_value
       FROM charass
       WHERE ((charass_target_type='SI')
       AND  (charass_target_id=NEW.coitem_id));
  END IF;
   
  IF (TG_OP = 'UPDATE') THEN
--  Update P/R date if applicable

    IF (NEW.coitem_scheddate <> OLD.coitem_scheddate AND NEW.coitem_order_type='R' AND NEW.coitem_order_id > 1) THEN
      UPDATE pr SET pr_duedate = NEW.coitem_scheddate WHERE (pr_order_id=NEW.coitem_id AND pr_order_type='S');
    END IF;
    
--  If closing or cancelling and there is a job item work order, then close job and distribute remaining costs
    IF ((NEW.coitem_status = 'C' AND OLD.coitem_status <> 'C')
     OR (NEW.coitem_status = 'X' AND OLD.coitem_status <> 'X'))
     AND (OLD.coitem_order_id > -1) THEN

      SELECT wo_id, wo_wipvalue INTO _r
       FROM wo,itemsite,item
      WHERE ((wo_ordtype='S')
      AND (wo_ordid=OLD.coitem_id)
      AND (itemsite_id=wo_itemsite_id)
      AND (item_id=itemsite_item_id)
      AND (itemsite_costmethod = 'J'));

      IF (FOUND) THEN
        IF (_r.wo_wipvalue > 0) THEN
        --  Distribute to G/L, debit Cost of Sales, credit WIP
          PERFORM MIN(insertGLTransaction( 'W/O', 'WO', formatWoNumber(NEW.coitem_order_id), 'Job Closed Incomplete',
                                           costcat_wip_accnt_id,
                                           CASE WHEN (COALESCE(NEW.coitem_cos_accnt_id, -1) != -1)
                                                  THEN NEW.coitem_cos_accnt_id
                                                WHEN (NEW.coitem_warranty=TRUE)
                                                  THEN resolveCOWAccount(itemsite_id, cohead_cust_id, cohead_saletype_id, cohead_shipzone_id)
                                                ELSE resolveCOSAccount(itemsite_id, cohead_cust_id, cohead_saletype_id, cohead_shipzone_id)
                                           END,
                                           -1,  _r.wo_wipvalue, current_date ))
          FROM itemsite, costcat, cohead
          WHERE ((itemsite_id=NEW.coitem_itemsite_id)
           AND (itemsite_costcat_id=costcat_id)
           AND (cohead_id=NEW.coitem_cohead_id));
        END IF;

        UPDATE wo SET
          wo_status = 'C',
          wo_wipvalue = 0
        WHERE (wo_id = _r.wo_id);

      END IF;
    END IF;

--  Likewise, reopen the job if line reopened
    IF ((NEW.coitem_status != 'C' AND OLD.coitem_status = 'C')
     OR (NEW.coitem_status != 'X' AND OLD.coitem_status = 'X'))
     AND (OLD.coitem_order_id > -1) THEN
        UPDATE wo SET
          wo_status = 'I'
        FROM itemsite, item
        WHERE ((wo_ordtype = 'S')
         AND (wo_ordid=NEW.coitem_id)
         AND (wo_itemsite_id=itemsite_id)
         AND (itemsite_item_id=item_id)
         AND (itemsite_costmethod='J'));
    END IF;

--  Handle links to Return Authorization
    IF (fetchMetricBool('EnableReturnAuth')) THEN 
      SELECT * INTO _r 
      FROM raitem,rahead 
      WHERE ((raitem_new_coitem_id=NEW.coitem_id)
      AND (rahead_id=raitem_rahead_id));
      IF (FOUND) THEN
        IF ((_r.raitem_qtyauthorized <> NEW.coitem_qtyord OR
            _r.raitem_qty_uom_id <> NEW.coitem_qty_uom_id OR
            _r.raitem_qty_invuomratio <> NEW.coitem_qty_invuomratio OR
            _r.raitem_price_uom_id <> NEW.coitem_price_uom_id OR
            _r.raitem_price_invuomratio <> NEW.coitem_price_invuomratio)
            AND NOT (NEW.coitem_status = 'X' AND _r.raitem_qtyauthorized = 0)) THEN
          RAISE EXCEPTION 'Quantities for line item % may only be changed on the Return Authorization that created it.',NEW.coitem_linenumber;
        END IF;
        IF (OLD.coitem_warranty <> NEW.coitem_warranty) THEN
          UPDATE raitem SET raitem_warranty = NEW.coitem_warranty
           WHERE((raitem_new_coitem_id=NEW.coitem_id)
             AND (raitem_warranty != NEW.coitem_warranty));
        END IF;
        IF (OLD.coitem_cos_accnt_id <> NEW.coitem_cos_accnt_id) THEN
          UPDATE raitem SET raitem_cos_accnt_id = NEW.coitem_cos_accnt_id
           WHERE((raitem_new_coitem_id=NEW.coitem_id)
             AND (COALESCE(raitem_cos_accnt_id,-1) != COALESCE(NEW.coitem_cos_accnt_id,-1)));
        END IF;
        IF (OLD.coitem_taxtype_id <> NEW.coitem_taxtype_id) THEN
          UPDATE raitem SET raitem_taxtype_id = NEW.coitem_taxtype_id
           WHERE((raitem_new_coitem_id=NEW.coitem_id)
             AND (COALESCE(raitem_taxtype_id,-1) != COALESCE(NEW.coitem_taxtype_id,-1)));
        END IF;
        IF (OLD.coitem_scheddate <> NEW.coitem_scheddate) THEN
          UPDATE raitem SET raitem_scheddate = NEW.coitem_scheddate
           WHERE((raitem_new_coitem_id=NEW.coitem_id)
             AND (raitem_scheddate != NEW.coitem_scheddate));
        END IF;
        IF (OLD.coitem_memo <> NEW.coitem_memo) THEN
          UPDATE raitem SET raitem_notes = NEW.coitem_memo
           WHERE((raitem_new_coitem_id=NEW.coitem_id)
             AND (raitem_notes != NEW.coitem_memo));
        END IF;
        IF ((OLD.coitem_qtyshipped <> NEW.coitem_qtyshipped) AND 
           (NEW.coitem_qtyshipped >= _r.raitem_qtyauthorized) AND
           ((_r.raitem_disposition = 'S') OR
           (_r.raitem_status = 'O') AND
           (_r.raitem_disposition IN ('P','V')) AND
           (_r.raitem_qtyreceived >= _r.raitem_qtyauthorized))) THEN
          UPDATE raitem SET raitem_status = 'C' 
          WHERE (raitem_new_coitem_id=NEW.coitem_id);
        END IF;
      END IF;
    END IF; 
  END IF; 

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._soitembeforetrigger() OWNER TO admin;

--
-- Name: _soitemtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _soitemtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _changelog BOOLEAN := FALSE;
  _check BOOLEAN;
  _kit BOOLEAN;
  _shipped BOOLEAN;
  _atShipping NUMERIC;
  _tmp INTEGER;
  _rec RECORD;
BEGIN
  -- Check
  SELECT checkPrivilege('MaintainSalesOrders') OR checkPrivilege('ShipOrders') OR checkPrivilege('IssueStockToShipping') INTO _check;
  IF NOT (_check) THEN
    RAISE EXCEPTION 'You do not have privileges to alter a Sales Order.';
  END IF;

  IF ( SELECT fetchMetricBool('SalesOrderChangeLog') ) THEN
    _changelog := TRUE;
  END IF;

  IF (TG_OP IN ('INSERT','UPDATE')) THEN
    IF (NEW.coitem_scheddate IS NULL) THEN
      IF (fetchmetricbool('AllowASAPShipSchedules')) THEN
        NEW.coitem_scheddate := current_date;
      ELSE
        RAISE EXCEPTION 'A schedule date is required.';
      END IF;
    END IF;
  END IF;

  _rec := NEW;

  SELECT COALESCE(item_type,'')='K'
    INTO _kit
    FROM itemsite, item
   WHERE((itemsite_item_id=item_id)
     AND (itemsite_id=_rec.coitem_itemsite_id));
  _kit := COALESCE(_kit, false);
  _shipped := false;
  IF(_kit AND _rec.coitem_status <> 'C' AND _rec.coitem_status <> 'X') THEN
    SELECT coitem_id
      INTO _tmp
      FROM coitem JOIN shipitem ON (shipitem_orderitem_id=coitem_id)
                  JOIN shiphead ON (shiphead_id=shipitem_shiphead_id AND shiphead_order_type='SO')
     WHERE((coitem_cohead_id=_rec.coitem_cohead_id)
       AND (coitem_linenumber=_rec.coitem_linenumber)
       AND (coitem_subnumber > 0))
     GROUP BY coitem_id
    HAVING (SUM(shipitem_qty) > 0)
     LIMIT 1;
    IF (FOUND) THEN
      _shipped := true;
    END IF;
  END IF;
  
  IF (TG_OP ='UPDATE') THEN
    IF ((OLD.coitem_status <> 'C') AND (NEW.coitem_status = 'C')) THEN
      SELECT qtyAtShipping(NEW.coitem_id) INTO _atShipping;
      IF (_atShipping > 0) THEN
        RAISE EXCEPTION 'Line % cannot be Closed at this time as there is inventory at shipping.',NEW.coitem_linenumber;
      END IF;
    END IF;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                          evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number )
    SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
           'S', NEW.coitem_id, itemsite_warehous_id, (cohead_number || '-' || NEW.coitem_linenumber)
    FROM evntnot, evnttype, itemsite, item, cohead
    WHERE ( (evntnot_evnttype_id=evnttype_id)
     AND (evntnot_warehous_id=itemsite_warehous_id)
     AND (itemsite_id=NEW.coitem_itemsite_id)
     AND (itemsite_item_id=item_id)
     AND (NEW.coitem_cohead_id=cohead_id)
     AND (NEW.coitem_scheddate <= (CURRENT_DATE + itemsite_eventfence))
     AND (evnttype_name='SoitemCreated') );

    IF (_changelog) THEN
      PERFORM postComment('ChangeLog', 'SI', NEW.coitem_id, 'Created');
    END IF;

    --Set defaults if no values passed
    NEW.coitem_linenumber	:= COALESCE(NEW.coitem_linenumber,
                                          (SELECT (COALESCE(MAX(coitem_linenumber), 0) + 1)
                                           FROM coitem
                                           WHERE (coitem_cohead_id=NEW.coitem_cohead_id)));
    NEW.coitem_status		:= COALESCE(NEW.coitem_status,'O');
    NEW.coitem_scheddate	:= COALESCE(NEW.coitem_scheddate,
					   (SELECT MIN(coitem_scheddate)
					    FROM coitem
					    WHERE (coitem_cohead_id=NEW.coitem_cohead_id)));
    NEW.coitem_memo		:= COALESCE(NEW.coitem_memo,'');
    NEW.coitem_prcost		:= COALESCE(NEW.coitem_prcost,0);
    NEW.coitem_warranty	:= COALESCE(NEW.coitem_warranty,false);

    IF (NEW.coitem_status='O') THEN
      UPDATE cohead SET cohead_status = 'O'
       WHERE ((cohead_id=NEW.coitem_cohead_id)
         AND  (cohead_status='C'));
    END IF;

    RETURN NEW;

  ELSIF (TG_OP = 'UPDATE') THEN
    IF (NEW.coitem_qtyord <> OLD.coitem_qtyord) THEN
      IF(_kit) THEN
        IF(_shipped) THEN
          RAISE EXCEPTION 'You can not change the qty ordered for a Kit item when one or more of its components have shipped inventory.';
        END IF;
      END IF;
      INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
			    evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number,
			    evntlog_oldvalue, evntlog_newvalue )
      SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
	     'S', NEW.coitem_id, itemsite_warehous_id, (cohead_number || '-' || NEW.coitem_linenumber),
	     OLD.coitem_qtyord, NEW.coitem_qtyord
      FROM evntnot, evnttype, itemsite, item, cohead
      WHERE ( (evntnot_evnttype_id=evnttype_id)
       AND (evntnot_warehous_id=itemsite_warehous_id)
       AND (itemsite_id=NEW.coitem_itemsite_id)
       AND (itemsite_item_id=item_id)
       AND (NEW.coitem_cohead_id=cohead_id)
       AND ( (NEW.coitem_scheddate <= (CURRENT_DATE + itemsite_eventfence))
	OR   (OLD.coitem_scheddate <= (CURRENT_DATE + itemsite_eventfence)) )
       AND (evnttype_name='SoitemQtyChanged') );

      IF (_changelog) THEN
	PERFORM postComment( 'ChangeLog', 'SI', NEW.coitem_id,
			     ( 'Changed Qty. Ordered from ' || formatQty(OLD.coitem_qtyord) ||
			       ' to ' || formatQty(NEW.coitem_qtyord) ) );
      END IF;

    END IF;

    IF (NEW.coitem_scheddate <> OLD.coitem_scheddate) THEN
      INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
			    evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number,
			    evntlog_olddate, evntlog_newdate )
      SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
	     'S', NEW.coitem_id, itemsite_warehous_id, (cohead_number || '-' || NEW.coitem_linenumber),
	     OLD.coitem_scheddate, NEW.coitem_scheddate
      FROM evntnot, evnttype, itemsite, item, cohead
      WHERE ( (evntnot_evnttype_id=evnttype_id)
       AND (evntnot_warehous_id=itemsite_warehous_id)
       AND (itemsite_id=NEW.coitem_itemsite_id)
       AND (itemsite_item_id=item_id)
       AND (NEW.coitem_cohead_id=cohead_id)
       AND ( (NEW.coitem_scheddate <= (CURRENT_DATE + itemsite_eventfence))
	OR   (OLD.coitem_scheddate <= (CURRENT_DATE + itemsite_eventfence)) )
       AND (evnttype_name='SoitemSchedDateChanged') );

      IF (_changelog) THEN
	PERFORM postComment( 'ChangeLog', 'SI', NEW.coitem_id,
			     ( 'Changed Sched. Date from ' || formatDate(OLD.coitem_scheddate) ||
			       ' to ' || formatDate(NEW.coitem_scheddate)) );
      END IF;

    END IF;

    IF ((NEW.coitem_status = 'C') AND (OLD.coitem_status <> 'C')) THEN
      NEW.coitem_closedate = CURRENT_TIMESTAMP;
      NEW.coitem_close_username = getEffectiveXtUser();
      NEW.coitem_qtyreserved := 0;

      IF (_changelog) THEN
	PERFORM postComment('ChangeLog', 'SI', NEW.coitem_id, 'Closed');
      END IF;
    END IF;

    IF ((NEW.coitem_status <> 'C') AND (OLD.coitem_status = 'C')) THEN
      NEW.coitem_closedate = NULL;
      NEW.coitem_close_username = NULL;

      IF (_changelog) THEN
	PERFORM postComment('ChangeLog', 'SI', NEW.coitem_id, 'Reopened');
      END IF;
    END IF;

    IF ((NEW.coitem_status = 'X') AND (OLD.coitem_status <> 'X')) THEN
      IF ((OLD.coitem_order_type = 'W') AND
	  (SELECT wo_status IN ('O', 'E', 'R')
	    FROM wo
	    WHERE (wo_id=OLD.coitem_order_id))) THEN
      -- Close any associated W/O
        PERFORM closeWo(OLD.coitem_order_id, FALSE, CURRENT_DATE);
      ELSIF (OLD.coitem_order_type = 'R') THEN 
      -- Delete any associated P/R
        PERFORM deletePr(OLD.coitem_order_id);
      END IF;

      NEW.coitem_qtyreserved := 0;

      IF (_changelog) THEN
	PERFORM postComment('ChangeLog', 'SI', NEW.coitem_id, 'Canceled');
	PERFORM postComment('ChangeLog', 'S', NEW.coitem_cohead_id, 'Line # '|| NEW.coitem_linenumber ||' Canceled');
      END IF;

      INSERT INTO evntlog ( evntlog_evnttime, evntlog_username,
			    evntlog_evnttype_id, evntlog_ordtype,
			    evntlog_ord_id, evntlog_warehous_id, evntlog_number )
      SELECT CURRENT_TIMESTAMP, evntnot_username,
	     evnttype_id, 'S',
	     OLD.coitem_id, itemsite_warehous_id,
	     (cohead_number || '-' || OLD.coitem_linenumber)
      FROM evntnot, evnttype, itemsite, item, cohead
      WHERE ( (evntnot_evnttype_id=evnttype_id)
       AND (evntnot_warehous_id=itemsite_warehous_id)
       AND (itemsite_id=OLD.coitem_itemsite_id)
       AND (itemsite_item_id=item_id)
       AND (OLD.coitem_cohead_id=cohead_id)
       AND (OLD.coitem_scheddate <= (CURRENT_DATE + itemsite_eventfence))
       AND (evnttype_name='SoitemCancelled') );

    END IF;

    IF ((NEW.coitem_qtyreserved <> OLD.coitem_qtyreserved) AND (_changelog)) THEN
      PERFORM postComment('ChangeLog', 'SI', NEW.coitem_id, 'Changed Qty Reserved to '|| NEW.coitem_qtyreserved);
    END IF;

  END IF;

  NEW.coitem_lastupdated = CURRENT_TIMESTAMP;

  -- Handle status for header
  IF (TG_OP = 'UPDATE') THEN
    IF (OLD.coitem_status <> NEW.coitem_status) THEN
      IF ( (SELECT (count(*) < 1)
              FROM coitem
             WHERE ((coitem_cohead_id=NEW.coitem_cohead_id)
               AND  (coitem_id != NEW.coitem_id)
               AND  (coitem_status='O')) ) AND (NEW.coitem_status<>'O') ) THEN
        UPDATE cohead SET cohead_status = 'C'
         WHERE ((cohead_id=NEW.coitem_cohead_id)
           AND  (cohead_status='O'));
      ELSE
        UPDATE cohead SET cohead_status = 'O'
         WHERE ((cohead_id=NEW.coitem_cohead_id)
           AND  (cohead_status='C'));
      END IF;
    END IF;
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._soitemtrigger() OWNER TO admin;

--
-- Name: _taxauthafterdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _taxauthafterdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (EXISTS(SELECT 1
               FROM checkhead
              WHERE checkhead_recip_id = OLD.taxauth_id
                AND checkhead_recip_type='T')) THEN
    RAISE EXCEPTION 'Cannot delete the tax authority % because checks have been written to it [xtuple: deleteTaxAuthority, -7, %]',
                    OLD.taxauth_number, OLD.taxauth_number;
  END IF;

  IF (fetchMetricValue('DefaultTaxAuthority') = OLD.taxauth_id) THEN
    RAISE EXCEPTION 'Cannot delete the default Tax Authority [xtuple: deleteTaxAuthority, -8, %]',
                    OLD.taxauth_code;
  END IF;

  IF (fetchMetricBool('TaxAuthChangeLog')) THEN
    PERFORM postComment(cmnttype_id, 'TAXAUTH', OLD.taxauth_id,
                        'Deleted "' || OLD.taxauth_number || '"')
      FROM cmnttype
     WHERE (cmnttype_name='ChangeLog');
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._taxauthafterdeletetrigger() OWNER TO admin;

--
-- Name: _taxauthaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _taxauthaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;

BEGIN
  IF (TG_OP = 'INSERT') THEN
    -- http://www.postgresql.org/docs/current/static/plpgsql-control-structures.html#PLPGSQL-UPSERT-EXAMPLE
    LOOP
      UPDATE crmacct SET crmacct_taxauth_id=NEW.taxauth_id,
                         crmacct_name=NEW.taxauth_name
       WHERE crmacct_number=NEW.taxauth_code;
      IF (FOUND) THEN
        EXIT;
      END IF;
      BEGIN
        INSERT INTO crmacct(crmacct_number,   crmacct_name,     crmacct_active,
                            crmacct_type,     crmacct_taxauth_id
                  ) VALUES (NEW.taxauth_code, NEW.taxauth_name, TRUE, 
                            'O',              NEW.taxauth_id);
        EXIT;
      EXCEPTION WHEN unique_violation THEN
            -- do nothing, and loop to try the UPDATE again
      END;
    END LOOP;

    /* TODO: default characteristic assignments based on what? */

  ELSIF (TG_OP = 'UPDATE') THEN
    UPDATE crmacct SET crmacct_number = NEW.taxauth_code
    WHERE ((crmacct_taxauth_id=NEW.taxauth_id)
      AND  (crmacct_number!=NEW.taxauth_code));

    UPDATE crmacct SET crmacct_name = NEW.taxauth_name
    WHERE ((crmacct_taxauth_id=NEW.taxauth_id)
      AND  (crmacct_name!=NEW.taxauth_name));

  END IF;

  IF (fetchMetricBool('TaxAuthChangeLog')) THEN
    SELECT cmnttype_id INTO _cmnttypeid
      FROM cmnttype
     WHERE (cmnttype_name='ChangeLog');

    IF (_cmnttypeid IS NOT NULL) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'TAXAUTH', NEW.taxauth_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN
        IF (OLD.taxauth_code <> NEW.taxauth_code) THEN
          PERFORM postComment(_cmnttypeid, 'TAXAUTH', NEW.taxauth_id,
                              'Code changed from "' || OLD.taxauth_code ||
                              '" to "' || NEW.taxauth_code || '"');
        END IF;

        IF (OLD.taxauth_name <> NEW.taxauth_name) THEN
          PERFORM postComment(_cmnttypeid, 'TAXAUTH', NEW.taxauth_id,
                              'Name changed from "' || OLD.taxauth_name ||
                              '" to "' || NEW.taxauth_name || '"');
        END IF;

        IF (OLD.taxauth_extref <> NEW.taxauth_extref) THEN
          PERFORM postComment(_cmnttypeid, 'TAXAUTH', NEW.taxauth_id,
                              'External Ref. changed from "' || OLD.taxauth_extref ||
                              '" to "' || NEW.taxauth_extref || '"');
        END IF;

        IF (OLD.taxauth_addr_id <> NEW.taxauth_addr_id) THEN
          PERFORM postComment(_cmnttypeid, 'TAXAUTH', NEW.taxauth_id,
                              'Address changed from ' || formatAddr(OLD.taxauth_addr_id)
                              || ' to ' || formatAddr(NEW.taxauth_addr_id));
        END IF;

        IF (OLD.taxauth_curr_id <> NEW.taxauth_curr_id) THEN
          PERFORM postComment(_cmnttypeid, 'TAXAUTH', NEW.taxauth_id,
                              'Currency changed from "' ||
                              currConcat(OLD.taxauth_curr_id) || '" to "' ||
                              currConcat(NEW.taxauth_curr_id) || '"');
        END IF;

        IF (OLD.taxauth_county <> NEW.taxauth_county) THEN
          PERFORM postComment(_cmnttypeid, 'TAXAUTH', NEW.taxauth_id,
                              'County changed from "' || OLD.taxauth_county ||
                              '" to "' || NEW.taxauth_county || '"');
        END IF;

        IF (OLD.taxauth_accnt_id <> NEW.taxauth_accnt_id) THEN
          PERFORM postComment(_cmnttypeid, 'TAXAUTH', NEW.taxauth_id,
                              'Account changed from "' ||
                              formatGLAccount(OLD.taxauth_accnt_id) || '" to "' ||
                              formatGLAccount(NEW.taxauth_accnt_id) || '"');
        END IF;

      END IF;
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._taxauthaftertrigger() OWNER TO admin;

--
-- Name: _taxauthbeforedeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _taxauthbeforedeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (NOT checkPrivilege('MaintainTaxAuthorities')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Tax Authorities.';
  END IF;

  UPDATE crmacct SET crmacct_taxauth_id = NULL
   WHERE crmacct_taxauth_id = OLD.taxauth_id;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._taxauthbeforedeletetrigger() OWNER TO admin;

--
-- Name: _taxauthbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _taxauthbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (NOT checkPrivilege('MaintainTaxAuthorities')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Tax Authorities.';
  END IF;

  IF (NEW.taxauth_code IS NULL) THEN
    RAISE EXCEPTION 'You must supply a Tax Authority Code.';
  END IF;

  IF (TG_OP = 'INSERT' AND
      fetchMetricText('CRMAccountNumberGeneration') IN ('A','O')) THEN
    PERFORM clearNumberIssue('CRMAccountNumber', NEW.taxauth_code);
  END IF;

  NEW.taxauth_code := UPPER(NEW.taxauth_code);

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._taxauthbeforetrigger() OWNER TO admin;

--
-- Name: _termsafterdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _termsafterdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (fetchMetricValue('DefaultTerms') = OLD.terms_id) THEN
    RAISE EXCEPTION 'Cannot delete the default Terms [xtuple: terms, -1, %]',
                    OLD.terms_code;
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._termsafterdeletetrigger() OWNER TO admin;

--
-- Name: _todoitemtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _todoitemtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _recurid     INTEGER;
  _newparentid INTEGER;

BEGIN
  IF (TG_OP = 'DELETE') THEN
    SELECT recur_id INTO _recurid
      FROM recur
     WHERE ((recur_parent_id=OLD.todoitem_id)
       AND  (recur_parent_type='TODO'));

    IF (_recurid IS NOT NULL) THEN
      RAISE DEBUG 'recur_id for deleted todoitem = %', _recurid;

      SELECT todoitem_id INTO _newparentid
        FROM todoitem
       WHERE ((todoitem_recurring_todoitem_id=OLD.todoitem_id)
          AND (todoitem_id!=OLD.todoitem_id))
       ORDER BY todoitem_due_date
       LIMIT 1;

      RAISE DEBUG '_newparentid for deleted todoitem = %', COALESCE(_newparentid, NULL);

      -- client is responsible for warning about deleting a recurring todoitem
      IF (_newparentid IS NULL) THEN
        DELETE FROM recur WHERE recur_id=_recurid;
      ELSE
        UPDATE recur SET recur_parent_id=_newparentid
         WHERE recur_id=_recurid;

        UPDATE todoitem SET todoitem_recurring_todoitem_id=_newparentid
         WHERE todoitem_recurring_todoitem_id=OLD.todoitem_id
           AND todoitem_id != OLD.todoitem_id;

        RAISE DEBUG 'reparented recurrence';
      END IF;
    END IF;

    DELETE FROM alarm
     WHERE ((alarm_source='TODO')
        AND (alarm_source_id=OLD.todoitem_id));

    DELETE FROM docass WHERE docass_source_id = OLD.todoitem_id AND docass_source_type = 'TODO';
    DELETE FROM docass WHERE docass_target_id = OLD.todoitem_id AND docass_target_type = 'TODO';

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._todoitemtrigger() OWNER TO admin;

--
-- Name: _uomconvupdate(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _uomconvupdate() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
 
  UPDATE itemuomconv
  SET itemuomconv_to_value = NEW.uomconv_to_value,
  itemuomconv_from_value = NEW.uomconv_from_value,
  itemuomconv_fractional = NEW.uomconv_fractional
  WHERE((itemuomconv_from_uom_id = NEW.uomconv_from_uom_id)
  AND (itemuomconv_to_uom_id = NEW.uomconv_to_uom_id));

RETURN NEW;

END; 
$$;


ALTER FUNCTION public._uomconvupdate() OWNER TO admin;

--
-- Name: _usrprefaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _usrprefaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  IF (TG_OP = 'INSERT' OR TG_OP = 'UPDATE') THEN
    -- http://www.postgresql.org/docs/current/static/plpgsql-control-structures.html#PLPGSQL-UPSERT-EXAMPLE
    IF (NEW.usrpref_name='active') THEN
      LOOP
        UPDATE crmacct SET crmacct_usr_username=NEW.usrpref_username
         WHERE crmacct_number=UPPER(NEW.usrpref_username);
        IF (FOUND) THEN
          EXIT;
        END IF;
        BEGIN
          INSERT INTO crmacct(crmacct_number,        crmacct_active,
                              crmacct_type,          crmacct_usr_username
                    ) VALUES (NEW.usrpref_username,  NEW.usrpref_value::BOOL,
                              'I',                   NEW.usrpref_username);
          EXIT;
        EXCEPTION WHEN unique_violation THEN
            -- do nothing, and loop to try the UPDATE again
        END;
      END LOOP;

    ELSIF (NEW.usrpref_name='propername') THEN
      LOOP
        UPDATE crmacct SET crmacct_name=NEW.usrpref_value
         WHERE crmacct_number=UPPER(NEW.usrpref_username);
        IF (FOUND) THEN
          EXIT;
        END IF;
        BEGIN
          INSERT INTO crmacct(crmacct_number,        crmacct_active,
                              crmacct_name,
                              crmacct_type,          crmacct_usr_username
                    ) VALUES (UPPER(NEW.usrpref_username), TRUE,
                              NEW.usrpref_value,
                              'I',                   NEW.usrpref_username);
          EXIT;
        EXCEPTION WHEN unique_violation THEN
            -- do nothing, and loop to try the UPDATE again
        END;
      END LOOP;

    END IF;

  ELSIF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._usrprefaftertrigger() OWNER TO admin;

--
-- Name: _usrprefbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _usrprefbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF NOT (checkPrivilege('MaintainUsers') OR
          checkPrivilege('MaintainPreferencesOthers') OR
          (checkPrivilege('MaintainPreferencesSelf'))) THEN
    -- 2 IFs because plpgsql doesn't always evaluate boolean exprs left-to-right
    IF (TG_OP = 'DELETE') THEN
      IF NOT (OLD.usrpref_name LIKE '%/checked' OR OLD.usrpref_name LIKE '%/columnsShown') THEN
        RAISE EXCEPTION 'You do not have privileges to change this User Preference.';
      END IF;
    ELSIF (NEW.usrpref_username = getEffectiveXtUser()) THEN
      IF NOT (NEW.usrpref_name LIKE '%/checked' OR NEW.usrpref_name LIKE '%/columnsShown') THEN
        RAISE EXCEPTION 'You do not have privileges to change this User Preference.';
      END IF;
    END IF;
  END IF;

  IF (TG_OP IN ('INSERT', 'UPDATE')) THEN
    IF (NEW.usrpref_name = 'locale') THEN
      IF NOT EXISTS(SELECT locale_id
                      FROM locale
                     WHERE locale_id = NEW.usrpref_value::INTEGER) THEN
        RAISE EXCEPTION 'You must supply a valid Locale.';
      END IF;

    ELSIF (NEW.usrpref_name IN ('agent', 'active')) THEN
      IF (NEW.usrpref_value NOT IN ('t', 'f')) THEN
        RAISE EXCEPTION '% must be either "t" or "f"', NEW.usrpref_name;
      END IF;
    END IF;

  ELSIF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._usrprefbeforetrigger() OWNER TO admin;

--
-- Name: _usrprivtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _usrprivtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check BOOLEAN;
  _returnVal INTEGER;
BEGIN
  -- This looks like a candidate for a foreign key but isn't.
  -- fkeys don't work if the foreign key value resides in a child of the 
  -- table and not the table itself.
  IF ((TG_OP = 'UPDATE' OR TG_OP = 'INSERT') AND
      (NOT EXISTS(SELECT priv_id
                  FROM priv
                  WHERE (priv_id=NEW.usrpriv_priv_id)))) THEN
    RAISE EXCEPTION 'Privilege id % does not exist or is part of a disabled package.',
                NEW.usrpriv_priv_id;
    RETURN OLD;

  ELSIF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._usrprivtrigger() OWNER TO admin;

--
-- Name: _vendaddrtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _vendaddrtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check      BOOLEAN;
  _vendname   TEXT;

BEGIN

--  Checks
  SELECT checkPrivilege('MaintainVendors') INTO _check;
  IF NOT (_check) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Vendors.';
  END IF;

  IF (TG_OP IN ('INSERT','UPDATE')) THEN

    IF (LENGTH(COALESCE(NEW.vendaddr_code, ''))=0) THEN
      RAISE EXCEPTION 'You must supply a valid Vendor Address Number.';
    END IF;

    IF (LENGTH(COALESCE(NEW.vendaddr_name, ''))=0) THEN
      RAISE EXCEPTION 'You must supply a valid Vendor Address Name.';
    END IF;

    IF (NEW.vendaddr_vend_id IS NULL) THEN
      RAISE EXCEPTION 'You must supply a valid Vendor ID.';
    END IF;

    SELECT vendaddr_code INTO _vendname
    FROM vendaddrinfo
    WHERE ( (vendaddr_vend_id=NEW.vendaddr_vend_id)
      AND (UPPER(vendaddr_code)=UPPER(NEW.vendaddr_code))
      AND (vendaddr_id<>NEW.vendaddr_id) );
    IF (FOUND) THEN
      RAISE EXCEPTION 'The Vendor Address Number entered cannot be used as it is in use.';
    END IF;

  END IF;
  
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._vendaddrtrigger() OWNER TO admin;

--
-- Name: _vendaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _vendaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid   INTEGER;

BEGIN

  IF (TG_OP = 'INSERT') THEN
    -- http://www.postgresql.org/docs/current/static/plpgsql-control-structures.html#PLPGSQL-UPSERT-EXAMPLE
    LOOP
      UPDATE crmacct SET crmacct_vend_id=NEW.vend_id,
                         crmacct_name=NEW.vend_name
       WHERE crmacct_number=NEW.vend_number;
      IF (FOUND) THEN
        EXIT;
      END IF;
      BEGIN
        INSERT INTO crmacct(crmacct_number,     crmacct_name,    crmacct_active,
                            crmacct_type,       crmacct_vend_id,
                            crmacct_cntct_id_1, crmacct_cntct_id_2
                  ) VALUES (NEW.vend_number,    NEW.vend_name,   NEW.vend_active,
                            'O',                NEW.vend_id,
                            NEW.vend_cntct1_id, NEW.vend_cntct2_id);
        EXIT;
      EXCEPTION WHEN unique_violation THEN
            -- do nothing, and loop to try the UPDATE again
      END;
    END LOOP;

    /* TODO: default characteristic assignments based on vendgrp? */

  ELSIF (TG_OP = 'UPDATE') THEN
    UPDATE crmacct SET crmacct_number = NEW.vend_number
    WHERE ((crmacct_vend_id=NEW.vend_id)
      AND  (crmacct_number!=NEW.vend_number));

    UPDATE crmacct SET crmacct_name = NEW.vend_name
    WHERE ((crmacct_vend_id=NEW.vend_id)
      AND  (crmacct_name!=NEW.vend_name));

  END IF;

  IF (fetchMetricBool('VendorChangeLog')) THEN
    SELECT cmnttype_id INTO _cmnttypeid
      FROM cmnttype
     WHERE (cmnttype_name='ChangeLog');

    IF (_cmnttypeid IS NOT NULL) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'V', NEW.vend_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN

        IF (OLD.vend_number <> NEW.vend_number) THEN
          PERFORM postComment(_cmnttypeid, 'V', NEW.vend_id,
                              ('Number Changed from "' || OLD.vend_number ||
                               '" to "' || NEW.vend_number || '"') );
        END IF;

        IF (OLD.vend_name <> NEW.vend_name) THEN
          PERFORM postComment( _cmnttypeid, 'V', NEW.vend_id,
                              ('Name Changed from "' || OLD.vend_name ||
                               '" to "' || NEW.vend_name || '"') );
        END IF;

        IF (OLD.vend_active <> NEW.vend_active) THEN
          PERFORM postComment(_cmnttypeid, 'V', NEW.vend_id,
                              CASE WHEN NEW.vend_active THEN 'Activated'
                                   ELSE 'Deactivated' END);
        END IF;

      END IF;
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._vendaftertrigger() OWNER TO admin;

--
-- Name: _vendinfoafterdeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _vendinfoafterdeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF EXISTS(SELECT 1
              FROM checkhead
             WHERE ((checkhead_recip_id=OLD.vend_id)
                AND (checkhead_recip_type='V'))) THEN
    RAISE EXCEPTION '[xtuple: deleteVendor, -7]';
  END IF;

  DELETE FROM taxreg
   WHERE ((taxreg_rel_type='V')
      AND (taxreg_rel_id=OLD.vend_id));

  IF (fetchMetricBool('VendorChangeLog')) THEN
    PERFORM postComment(cmnttype_id, 'V', OLD.vend_id,
                        ('Deleted "' || OLD.vend_number || '"'))
      FROM cmnttype
     WHERE (cmnttype_name='ChangeLog');
  END IF;

  RETURN OLD;
END;
$$;


ALTER FUNCTION public._vendinfoafterdeletetrigger() OWNER TO admin;

--
-- Name: _vendinfobeforedeletetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _vendinfobeforedeletetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF NOT (checkPrivilege('MaintainVendors')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Vendors.';
  END IF;

  DELETE FROM itemsrcp
   WHERE itemsrcp_itemsrc_id IN (SELECT itemsrc_id
                                   FROM itemsrc
                                  WHERE itemsrc_vend_id=OLD.vend_id);

  DELETE FROM itemsrc WHERE (itemsrc_vend_id=OLD.vend_id);

  DELETE FROM vendaddrinfo WHERE (vendaddr_vend_id=OLD.vend_id);

  DELETE FROM docass WHERE docass_source_id = OLD.vend_id AND docass_source_type = 'V';
  DELETE FROM docass WHERE docass_target_id = OLD.vend_id AND docass_target_type = 'V';

  UPDATE crmacct SET crmacct_vend_id = NULL
   WHERE crmacct_vend_id = OLD.vend_id;
  RETURN OLD;
END;
$$;


ALTER FUNCTION public._vendinfobeforedeletetrigger() OWNER TO admin;

--
-- Name: _vendtrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _vendtrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  IF NOT (checkPrivilege('MaintainVendors')) THEN
    RAISE EXCEPTION 'You do not have privileges to maintain Vendors.';
  END IF;

  IF (LENGTH(COALESCE(NEW.vend_number, ''))=0) THEN
    RAISE EXCEPTION 'You must supply a valid Vendor Number.';
  END IF;

  IF (LENGTH(COALESCE(NEW.vend_name, ''))=0) THEN
    RAISE EXCEPTION 'You must supply a valid Vendor Name.';
  END IF;

  IF (NEW.vend_vendtype_id IS NULL) THEN
    RAISE EXCEPTION 'You must supply a valid Vendor Type ID.';
  END IF;

  IF (NEW.vend_terms_id IS NULL) THEN
    RAISE EXCEPTION 'You must supply a valid Terms Code ID.';
  END IF;

  IF (TG_OP = 'INSERT' AND fetchMetricText('CRMAccountNumberGeneration') IN ('A','O')) THEN
    PERFORM clearNumberIssue('CRMAccountNumber', NEW.vend_number);
  END IF;

  NEW.vend_number := UPPER(NEW.vend_number);

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._vendtrigger() OWNER TO admin;

--
-- Name: _vodistaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _vodistaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _r RECORD;

BEGIN
  IF ( (TG_OP = 'UPDATE') OR (TG_OP = 'DELETE') ) THEN
    IF (OLD.vodist_tax_id <> -1) THEN
    -- Delete any existing voheadtax adjustment records
      DELETE FROM voheadtax
      WHERE ( (taxhist_parent_id=OLD.vodist_vohead_id)
        AND   (taxhist_tax_id=OLD.vodist_tax_id)
        AND   (taxhist_taxtype_id=getAdjustmentTaxTypeId()) );
    END IF;
  END IF;

  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

-- Cache Voucher Head
  SELECT * INTO _r
  FROM vohead
  WHERE (vohead_id=NEW.vodist_vohead_id);
  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Voucher head not found';
  END IF;

  IF (NEW.vodist_tax_id <> -1) THEN
  -- Insert adjustment voheadtax
    INSERT INTO voheadtax
      ( taxhist_parent_id,
        taxhist_taxtype_id,
        taxhist_tax_id,
        taxhist_basis,
        taxhist_basis_tax_id,
        taxhist_sequence,
        taxhist_percent,
        taxhist_amount,
        taxhist_tax,
        taxhist_docdate )
    VALUES
      ( NEW.vodist_vohead_id,
        getAdjustmentTaxTypeId(),
        NEW.vodist_tax_id,
        0,
        NULL,
        1,
        0,
        0,
        (NEW.vodist_amount * -1),
        _r.vohead_docdate );
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._vodistaftertrigger() OWNER TO admin;

--
-- Name: _vodistbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _vodistbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

BEGIN
  IF (TG_OP = 'DELETE') THEN
    IF (OLD.vodist_tax_id <> -1) THEN
    -- Delete any existing voheadtax adjustment records
      DELETE FROM voheadtax
      WHERE ( (taxhist_parent_id=OLD.vodist_vohead_id)
        AND   (taxhist_tax_id=OLD.vodist_tax_id)
        AND   (taxhist_taxtype_id=getAdjustmentTaxTypeId()) );
    END IF;

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._vodistbeforetrigger() OWNER TO admin;

--
-- Name: _voheadaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _voheadaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  IF (TG_OP = 'DELETE') THEN
    PERFORM releaseVoNumber(CAST(OLD.vohead_number AS INTEGER));
    RETURN OLD;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    PERFORM clearNumberIssue('VcNumber', NEW.vohead_number);
    RETURN NEW;
  END IF;

  IF (TG_OP = 'UPDATE') THEN
    IF ( (COALESCE(NEW.vohead_taxzone_id,-1) <> COALESCE(OLD.vohead_taxzone_id,-1)) OR
         (NEW.vohead_docdate <> OLD.vohead_docdate) OR
         (NEW.vohead_curr_id <> OLD.vohead_curr_id) ) THEN
      PERFORM calculateTaxHist( 'voitemtax',
                                voitem_id,
                                NEW.vohead_taxzone_id,
                                voitem_taxtype_id,
                                NEW.vohead_docdate,
                                NEW.vohead_curr_id,
                                (vodist_amount * -1) )
      FROM voitem JOIN vodist ON ( (vodist_vohead_id=voitem_vohead_id) AND
                                   (vodist_poitem_id=voitem_poitem_id) )
      WHERE (voitem_vohead_id = NEW.vohead_id);
    END IF;

    -- Touch any Misc Tax Distributions so voheadtax is recalculated
    IF (NEW.vohead_docdate <> OLD.vohead_docdate) THEN
      UPDATE vodist SET vodist_vohead_id=NEW.vohead_id
      WHERE ( (vodist_vohead_id=OLD.vohead_id)
        AND   (vodist_tax_id <> -1) );
    END IF;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._voheadaftertrigger() OWNER TO admin;

--
-- Name: _voheadbeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _voheadbeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _recurid     INTEGER;
  _newparentid INTEGER;

BEGIN
  IF (TG_OP = 'DELETE') THEN
    IF (OLD.vohead_posted) THEN
      -- Cannot delete a posted voucher
      RAISE EXCEPTION 'Cannot delete a posted voucher';
    END IF;

    /* TODO: is setting recv_invoiced and poreject_invoiced to FALSE correct?
             this behavior is inherited from the now-defunct deleteVoucher.
     */
    UPDATE recv SET recv_vohead_id = NULL,
                    recv_voitem_id = NULL,
                    recv_invoiced  = FALSE
     WHERE recv_vohead_id = OLD.vohead_id;

    UPDATE poreject SET poreject_vohead_id = NULL,
                        poreject_voitem_id = NULL,
                        poreject_invoiced  = FALSE
     WHERE poreject_vohead_id = OLD.vohead_id;

    DELETE FROM vodist    WHERE vodist_vohead_id  = OLD.vohead_id;
    DELETE FROM voheadtax WHERE taxhist_parent_id = OLD.vohead_id;
    DELETE FROM voitem    WHERE voitem_vohead_id  = OLD.vohead_id;

    SELECT recur_id INTO _recurid
      FROM recur
     WHERE ((recur_parent_id=OLD.vohead_id)
        AND (recur_parent_type='V'));
    IF (_recurid IS NOT NULL) THEN
      SELECT vohead_id INTO _newparentid
        FROM vohead
       WHERE ((vohead_recurring_vohead_id=OLD.vohead_id)
          AND (vohead_id!=OLD.vohead_id))
       ORDER BY vohead_docdate
       LIMIT 1;

      IF (_newparentid IS NULL) THEN
        DELETE FROM recur WHERE recur_id=_recurid;
      ELSE
        UPDATE recur SET recur_parent_id=_newparentid
         WHERE recur_id=_recurid;
        UPDATE vohead SET vohead_recurring_vohead_id=_newparentid
         WHERE vohead_recurring_vohead_id=OLD.vohead_id
           AND vohead_id!=OLD.vohead_id;
      END IF;
    END IF;

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._voheadbeforetrigger() OWNER TO admin;

--
-- Name: _voitemaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _voitemaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _r RECORD;

BEGIN
  IF (TG_OP = 'DELETE') THEN
    RETURN OLD;
  END IF;

-- Cache Voucher Head
  SELECT * INTO _r
  FROM vohead
  WHERE (vohead_id=NEW.voitem_vohead_id);
  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Voucher head not found';
  END IF;

-- Calculate Tax
  PERFORM calculateTaxHist( 'voitemtax',
                            NEW.voitem_id,
                            COALESCE(_r.vohead_taxzone_id, -1),
                            NEW.voitem_taxtype_id,
                            COALESCE(_r.vohead_docdate, CURRENT_DATE),
                            COALESCE(_r.vohead_curr_id, -1),
                            COALESCE(SUM(vodist_amount * -1), 0) )
  FROM vodist
  WHERE ( (vodist_vohead_id=_r.vohead_id)
    AND   (vodist_poitem_id=NEW.voitem_poitem_id) );

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._voitemaftertrigger() OWNER TO admin;

--
-- Name: _voitembeforetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _voitembeforetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

BEGIN
  IF (TG_OP = 'DELETE') THEN
    DELETE FROM voitemtax
    WHERE (taxhist_parent_id=OLD.voitem_id);

    RETURN OLD;
  END IF;

  RETURN NEW;
END;
$$;


ALTER FUNCTION public._voitembeforetrigger() OWNER TO admin;

--
-- Name: _warehoustrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _warehoustrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;
  _check      BOOLEAN;
  _checkId    INTEGER;

BEGIN

  -- Checks
  -- Start with privileges
  IF (TG_OP = 'INSERT') THEN
    SELECT checkPrivilege('MaintainWarehouses') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to add new Sites.';
    END IF;
  ELSE
    SELECT checkPrivilege('MaintainWarehouses') OR checkPrivilege('IssueCountTags') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to alter a Site.';
    END IF;
  END IF;

  -- Code is required
  IF (LENGTH(COALESCE(NEW.warehous_code,''))=0) THEN
    RAISE EXCEPTION 'You must supply a valid Site Code.';
  END IF;
  
  -- Sitetype is required
  IF (NEW.warehous_sitetype_id IS NULL) THEN
    RAISE EXCEPTION 'You must supply a valid Site Type.';
  END IF;

  -- Cost Category is required for Transit types
  IF ((NEW.warehous_transit) AND (NEW.warehous_costcat_id IS NULL)) THEN
    RAISE EXCEPTION 'You must supply a valid Cost Category for Transit Sites.';
  END IF;

  -- Code must be unique
  SELECT warehous_id INTO _checkId
  FROM whsinfo
  WHERE ( (UPPER(warehous_code)=UPPER(NEW.warehous_code))
    AND   (warehous_id<>NEW.warehous_id) );
  IF (FOUND) THEN
    RAISE EXCEPTION 'You must supply a unique Site Code.';
  END IF;
  
  -- Count Tag Prefix must be unique
  IF (TG_OP = 'INSERT') THEN
    SELECT warehous_id INTO _checkId
    FROM whsinfo
    WHERE (warehous_counttag_prefix=NEW.warehous_counttag_prefix);
  ELSE
    SELECT warehous_id INTO _checkId
    FROM whsinfo
    WHERE ( (warehous_counttag_prefix=NEW.warehous_counttag_prefix)
      AND   (warehous_id<>NEW.warehous_id) );
  END IF;
  IF (FOUND) THEN
    RAISE EXCEPTION 'You must supply a unique Count Tag Prefix.';
  END IF;
  
  -- Check Complete
  -- Change Log
  IF ( SELECT (metric_value='t')
       FROM metric
       WHERE (metric_name='WarehouseChangeLog') ) THEN

--  Cache the cmnttype_id for ChangeLog
    SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
    IF (FOUND) THEN
      IF (TG_OP = 'INSERT') THEN
        PERFORM postComment(_cmnttypeid, 'WH', NEW.warehous_id, 'Created');

      ELSIF (TG_OP = 'UPDATE') THEN
        IF (OLD.warehous_code <> NEW.warehous_code) THEN
          PERFORM postComment( _cmnttypeid, 'WH', NEW.warehous_id,
                               ('Code Changed from "' || OLD.warehous_code || '" to "' || NEW.warehous_code || '"') );
        END IF;

        IF (OLD.warehous_descrip <> NEW.warehous_descrip) THEN
          PERFORM postComment( _cmnttypeid, 'WH', NEW.warehous_id,
                               ( 'Description Changed from "' || OLD.warehous_descrip ||
                                 '" to "' || NEW.warehous_descrip || '"' ) );
        END IF;

        IF (OLD.warehous_active <> NEW.warehous_active) THEN
          IF (NEW.warehous_active) THEN
            PERFORM postComment(_cmnttypeid, 'WH', NEW.warehous_id, 'Activated');
          ELSE
            PERFORM postComment(_cmnttypeid, 'WH', NEW.warehous_id, 'Deactivated');
          END IF;
        END IF;

      END IF;
    END IF;
  END IF;
  
  RETURN NEW;

END;
$$;


ALTER FUNCTION public._warehoustrigger() OWNER TO admin;

--
-- Name: _whsezonetrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _whsezonetrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _check      BOOLEAN;
  _checkId    INTEGER;

BEGIN

  -- Checks
  -- Start with privileges
  IF (TG_OP = 'INSERT') THEN
    SELECT checkPrivilege('MaintainWarehouses') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to add new Site Zones.';
    END IF;
  ELSE
    SELECT checkPrivilege('MaintainWarehouses') INTO _check;
    IF NOT (_check) THEN
      RAISE EXCEPTION 'You do not have privileges to alter a Site Zone.';
    END IF;
  END IF;

  -- Name is required
  IF (LENGTH(COALESCE(NEW.whsezone_name,''))=0) THEN
    RAISE EXCEPTION 'You must supply a valid Site Zone Name.';
  END IF;
  
  -- Site is required
  IF (NEW.whsezone_warehous_id IS NULL) THEN
    RAISE EXCEPTION 'You must supply a valid Site.';
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._whsezonetrigger() OWNER TO admin;

--
-- Name: _womatlaftertrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _womatlaftertrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

BEGIN

  IF (TG_OP = 'INSERT') THEN

  --  Create any required P/R's
    PERFORM createPr('W', NEW.womatl_id)
       FROM itemsite 
      WHERE ((itemsite_id=NEW.womatl_itemsite_id)
        AND  (itemsite_createpr));

  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._womatlaftertrigger() OWNER TO admin;

--
-- Name: _wotrigger(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION _wotrigger() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _cmnttypeid INTEGER;

BEGIN

  IF ( SELECT (metric_value='t')
       FROM metric
       WHERE (metric_name='WorkOrderChangeLog') ) THEN
--  Cache the cmnttype_id for ChangeLog
    SELECT cmnttype_id INTO _cmnttypeid
    FROM cmnttype
    WHERE (cmnttype_name='ChangeLog');
  ELSE
    _cmnttypeid := -1;
  END IF;

  IF (TG_OP = 'INSERT') THEN
    INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                         evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number )
    SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
           'W', NEW.wo_id, itemsite_warehous_id, (NEW.wo_number || '-' || NEW.wo_subnumber) 
    FROM evntnot, evnttype, itemsite, item
    WHERE ( (evntnot_evnttype_id=evnttype_id)
     AND (evntnot_warehous_id=itemsite_warehous_id)
     AND (itemsite_id=NEW.wo_itemsite_id)
     AND (itemsite_item_id=item_id)
     AND (NEW.wo_duedate <= (CURRENT_DATE + itemsite_eventfence))
     AND (evnttype_name='WoCreated') );

     IF (_cmnttypeid <> -1) THEN
       PERFORM postComment(_cmnttypeid, 'W', NEW.wo_id, 'Created');
     END IF;

     IF (fetchMetricText('WONumberGeneration') IN ('A','O')) THEN
       --- clear the number from the issue cache
       PERFORM clearNumberIssue('WoNumber', NEW.wo_number);
     END IF;

     RETURN NEW;

  ELSE
    IF (TG_OP = 'DELETE') THEN
      INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                            evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number )
      SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
             'W', OLD.wo_id, itemsite_warehous_id, (OLD.wo_number || '-' || OLD.wo_subnumber) 
      FROM evntnot, evnttype, itemsite, item
      WHERE ( (evntnot_evnttype_id=evnttype_id)
       AND (evntnot_warehous_id=itemsite_warehous_id)
       AND (itemsite_id=OLD.wo_itemsite_id)
       AND (itemsite_item_id=item_id)
       AND (OLD.wo_duedate <= (CURRENT_DATE + itemsite_eventfence))
       AND (evnttype_name='WoCancelled') );

      DELETE FROM docass WHERE docass_source_id = OLD.wo_id AND docass_source_type = 'W';
      DELETE FROM docass WHERE docass_target_id = OLD.wo_id AND docass_target_type = 'W';

      DELETE FROM comment
      WHERE ( (comment_source='W')
       AND (comment_source_id=OLD.wo_id) );

      DELETE FROM charass
       WHERE ((charass_target_type='W')
         AND  (charass_target_id=OLD.wo_id));

       RETURN OLD;

    ELSE
      IF (TG_OP = 'UPDATE') THEN

        IF (NEW.wo_qtyord <> OLD.wo_qtyord) THEN
          INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                                evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number,
                                evntlog_oldvalue, evntlog_newvalue )
          SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
                 'W', NEW.wo_id, itemsite_warehous_id, (NEW.wo_number || '-' || NEW.wo_subnumber),
                 OLD.wo_qtyord, NEW.wo_qtyord
          FROM evntnot, evnttype, itemsite, item
          WHERE ( (evntnot_evnttype_id=evnttype_id)
           AND (evntnot_warehous_id=itemsite_warehous_id)
           AND (itemsite_id=NEW.wo_itemsite_id)
           AND (itemsite_item_id=item_id)
           AND ( (NEW.wo_duedate <= (CURRENT_DATE + itemsite_eventfence))
            OR   (OLD.wo_duedate <= (CURRENT_DATE + itemsite_eventfence)) )
           AND (evnttype_name='WoQtyChanged') );

          IF (_cmnttypeid <> -1) THEN
            PERFORM postComment( _cmnttypeid, 'W', NEW.wo_id,
                                 ( 'Qty. Ordered Changed from ' || formatQty(OLD.wo_qtyord) ||
                                   ' to ' || formatQty(NEW.wo_qtyord ) ) );
          END IF;
        END IF;

        IF (NEW.wo_duedate <> OLD.wo_duedate) THEN
          INSERT INTO evntlog ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                                evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number,
                                evntlog_olddate, evntlog_newdate )
          SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
                 'W', NEW.wo_id, itemsite_warehous_id, (NEW.wo_number || '-' || NEW.wo_subnumber),
                 OLD.wo_duedate, NEW.wo_duedate
          FROM evntnot, evnttype, itemsite, item
          WHERE ( (evntnot_evnttype_id=evnttype_id)
           AND (evntnot_warehous_id=itemsite_warehous_id)
           AND (itemsite_id=NEW.wo_itemsite_id)
           AND (itemsite_item_id=item_id)
           AND ( (NEW.wo_duedate <= (CURRENT_DATE + itemsite_eventfence))
            OR   (OLD.wo_duedate <= (CURRENT_DATE + itemsite_eventfence)) )
           AND (evnttype_name='WoDueDateChanged') );

          IF (_cmnttypeid <> -1) THEN
            PERFORM postComment( _cmnttypeid, 'W', NEW.wo_id,
                                 ( 'Due Date Changed from ' || formatDate(OLD.wo_duedate) ||
                                   ' to ' || formatDate(NEW.wo_duedate ) ) );
          END IF;
        END IF;

        IF (NEW.wo_status <> OLD.wo_status) THEN
          IF (_cmnttypeid <> -1) THEN
            PERFORM postComment( _cmnttypeid, 'W', NEW.wo_id,
                                 ('Status Changed from ' || OLD.wo_status || ' to ' || NEW.wo_status) );
          END IF;
        END IF;

      END IF; 
    END IF;
  END IF;

  RETURN NEW;

END;
$$;


ALTER FUNCTION public._wotrigger() OWNER TO admin;

--
-- Name: acknowledgemessage(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION acknowledgemessage(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pMsgid ALIAS FOR $1;

BEGIN

  UPDATE msguser
  SET msguser_viewed=CURRENT_TIMESTAMP
  WHERE ( (msguser_msg_id=pMsgid)
   AND (msguser_username=getEffectiveXtUser()) );

  RETURN TRUE;

END;
$_$;


ALTER FUNCTION public.acknowledgemessage(integer) OWNER TO admin;

--
-- Name: actcost(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION actcost(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  RETURN actCost($1, NULL, baseCurrId());
END;
$_$;


ALTER FUNCTION public.actcost(integer) OWNER TO admin;

--
-- Name: actcost(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION actcost(integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  RETURN actCost($1, $2, baseCurrId());
END;
$_$;


ALTER FUNCTION public.actcost(integer, integer) OWNER TO admin;

--
-- Name: actcost(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION actcost(integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemid ALIAS FOR $1;
  pBomitemid ALIAS FOR $2;
  pCurrid ALIAS FOR $3;
  _cost NUMERIC;

BEGIN

  -- Return actual cost in the given currency at the current conversion rate
  SELECT SUM(CASE WHEN (bomitemcost_id IS NOT NULL) THEN
                  ROUND(currToCurr(bomitemcost_curr_id, pCurrid, bomitemcost_actcost, CURRENT_DATE), 6)
                  ELSE
                  ROUND(currToCurr(itemcost_curr_id, pCurrid, itemcost_actcost, CURRENT_DATE), 6)
             END) INTO _cost
  FROM itemcost
    LEFT OUTER JOIN bomitemcost ON (bomitemcost_bomitem_id=pBomitemid AND bomitemcost_costelem_id=itemcost_costelem_id)
  WHERE (itemcost_item_id=pItemid);

  IF (_cost IS NULL) THEN
    RETURN 0;
  ELSE
    RETURN _cost;
  END IF;

END;
$_$;


ALTER FUNCTION public.actcost(integer, integer, integer) OWNER TO admin;

--
-- Name: addrusecount(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION addrusecount(integer) RETURNS integer
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pAddrId ALIAS FOR $1;
  _fk RECORD;
  _r RECORD;
  _seq INTEGER;
  _col TEXT;
  _qry TEXT;
  _count INTEGER = 0;

BEGIN
  -- Determine where this address is used by analyzing foreign key linkages
  -- TO DO: Can this be rationalized with cntctused(int)?
  FOR _fk IN
    SELECT pg_namespace.nspname AS schemaname, con.relname AS tablename, conkey AS seq, conrelid AS class_id 
    FROM pg_constraint, pg_class f, pg_class con, pg_namespace
    WHERE confrelid=f.oid
    AND conrelid=con.oid
    AND f.relname = 'addr'
    AND con.relnamespace=pg_namespace.oid
    AND con.relname NOT IN ('pohead') -- exception(s) where address key doesn't actually drive document information
  LOOP
    -- Validate
    IF (ARRAY_UPPER(_fk.seq,1) > 1) THEN
      RAISE EXCEPTION 'Checks to tables where the address is one of multiple foreign key columns is not supported. Error on Table: %',
        pg_namespace.nspname || '.' || con.relname;
    END IF;
    
    _seq := _fk.seq[1];

    -- Get the specific column name
    SELECT attname INTO _col
    FROM pg_attribute, pg_class
    WHERE ((attrelid=pg_class.oid)
    AND (pg_class.oid=_fk.class_id)
    AND (attnum=_seq));

    -- See if there are dependencies
    _qry := 'SELECT * 
            FROM ' || _fk.schemaname || '.' || _fk.tablename || '
            WHERE ('|| _col || '=' || pAddrId || ');';

    FOR _r IN 
      EXECUTE _qry
    LOOP
      _count := _count + 1;
    END LOOP;
         
  END LOOP;

  RETURN _count;

END;
$_$;


ALTER FUNCTION public.addrusecount(integer) OWNER TO admin;

--
-- Name: addtaxtoglseries(integer, text, text, text, integer, date, date, text, integer, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION addtaxtoglseries(integer, text, text, text, integer, date, date, text, integer, text) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSequence	ALIAS FOR $1;
  pSource	ALIAS FOR $2;
  pDocType	ALIAS FOR $3;
  pDocNumber	ALIAS FOR $4;
  pCurrId     ALIAS FOR $5;
  pExchDate	ALIAS FOR $6;
  pDistDate	ALIAS FOR $7;
  pTableName	ALIAS FOR $8;
  pParentId	ALIAS FOR $9;
  pNotes	ALIAS FOR $10;

  _count	INTEGER := 0;
  _baseTax	NUMERIC := 0;
  _returnVal	NUMERIC := 0;
  _t		RECORD;
  _test	INTEGER := 0;

BEGIN

-- This is just a fancy select statement on taxhist.
-- Because all tax records tables inherit from taxhist,
-- we can use the same select statement for all.
-- https://www.postgresql.org/docs/8.1/static/ddl-inherit.html
-- pTableName in the where clause narrows down the selection
-- to the correct sub table.

  FOR _t IN SELECT *
            FROM taxhist JOIN tax ON (tax_id = taxhist_tax_id)
                         JOIN pg_class ON (pg_class.oid = taxhist.tableoid)
            WHERE ( (taxhist_parent_id = pParentId)
              AND   (relname = pTableName) ) LOOP

    _count := _count + 1;
    _baseTax := currToBase(pCurrId, _t.taxhist_tax, pExchDate);
    _returnVal := _returnVal + _baseTax;
    PERFORM insertIntoGLSeries( pSequence, pSource, pDocType, pDocNumber,
                                _t.tax_sales_accnt_id, _baseTax,
                                pDistDate, pNotes );
                                
    UPDATE taxhist SET 
      taxhist_docdate=pExchDate,
      taxhist_distdate=pDistDate,
      taxhist_curr_id=pCurrId,
      taxhist_curr_rate=curr_rate
    FROM curr_rate
    WHERE ((taxhist_id=_t.taxhist_id)
      AND (pCurrId=curr_id)
      AND ( pExchDate BETWEEN curr_effective 
                          AND curr_expires) );

  END LOOP;

  RETURN _returnVal;
END;
$_$;


ALTER FUNCTION public.addtaxtoglseries(integer, text, text, text, integer, date, date, text, integer, text) OWNER TO admin;

--
-- Name: addtopackinglistbatch(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION addtopackinglistbatch(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSoheadid	ALIAS FOR $1;
  returnVal	INTEGER;
BEGIN

  -- MIN because error codes are negative
  SELECT MIN(addToPackingListBatch('SO', pSoheadid, shiphead_id)) INTO returnVal
  FROM shiphead
  WHERE ((shiphead_order_id=pSoheadid)
    AND  (NOT shiphead_shipped)
    AND  (shiphead_order_type='SO'));
  IF (NOT FOUND OR returnVal IS NULL) THEN
    returnVal := addToPackingListBatch('SO', pSoheadid, NULL);
  END IF;

  RETURN returnVal;
END;
$_$;


ALTER FUNCTION public.addtopackinglistbatch(integer) OWNER TO admin;

--
-- Name: addtopackinglistbatch(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION addtopackinglistbatch(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  RETURN addToPackingListBatch('SO', $1, $2);
END;
$_$;


ALTER FUNCTION public.addtopackinglistbatch(integer, integer) OWNER TO admin;

--
-- Name: addtopackinglistbatch(text, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION addtopackinglistbatch(text, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pheadtype	ALIAS FOR $1;
  pheadid	ALIAS FOR $2;
  returnVal	INTEGER;
BEGIN
  -- MIN because error codes are negative
  SELECT MIN(addToPackingListBatch(pheadtype, pheadid, shiphead_id)) INTO returnVal
  FROM shiphead
  WHERE ((shiphead_order_id=pheadid)
    AND  (NOT shiphead_shipped)
    AND  (shiphead_order_type=pheadtype));

  IF (NOT FOUND OR returnVal IS NULL) THEN
    returnVal := addToPackingListBatch(pheadtype, pheadid, NULL);
  END IF;

  RETURN returnVal;
END;
$_$;


ALTER FUNCTION public.addtopackinglistbatch(text, integer) OWNER TO admin;

--
-- Name: addtopackinglistbatch(text, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION addtopackinglistbatch(text, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pheadtype	ALIAS FOR $1;
  pheadid	ALIAS FOR $2;
  pshipheadid	ALIAS FOR $3;
  _check INTEGER;

BEGIN
  SELECT pack_id INTO _check
  FROM pack
  WHERE ((pack_head_id=pheadid)
    AND  ((pack_shiphead_id=pshipheadid) OR 
	  (pshipheadid IS NULL AND pack_shiphead_id IS NULL))
    AND  (pack_head_type=pheadtype)
	);

  IF (NOT FOUND) THEN
    INSERT INTO pack
    ( pack_head_type, pack_head_id, pack_shiphead_id, pack_printed )
    VALUES
    ( pheadtype, pheadid, pshipheadid, FALSE );
    -- Auto Firm Sales Orders conditionally based on metric
    IF ( (pheadtype = 'SO') AND (fetchMetricBool('FirmSalesOrderPackingList')) ) THEN
      UPDATE coitem SET coitem_firm=TRUE
      WHERE (coitem_cohead_id=pheadid);
    END IF; 
  END IF;

  RETURN pheadid;

END;
$_$;


ALTER FUNCTION public.addtopackinglistbatch(text, integer, integer) OWNER TO admin;

--
-- Name: adjustinvvalue(integer, numeric, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION adjustinvvalue(integer, numeric, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid     ALIAS FOR $1;
  pNewValue       ALIAS FOR $2;
  pAccountid      ALIAS FOR $3;
  _delta          NUMERIC;
  _glreturn       INTEGER;
  _invhistid      INTEGER;
  _itemlocSeries  INTEGER;

BEGIN

  SELECT pNewValue - itemsite_value INTO _delta
  FROM itemsite
  WHERE (itemsite_id=pItemsiteid)
  FOR UPDATE;

  IF (NOT FOUND) THEN
    RETURN -1;
  END IF;

  SELECT insertGLTransaction('I/M', '', 'Post Value',
         'Inventory Value Adjustment for ' || item_number,
         COALESCE (pAccountid, costcat_adjustment_accnt_id),
         costcat_asset_accnt_id, -1,
         _delta, CURRENT_DATE) INTO _glreturn
  FROM itemsite
   JOIN costcat ON (itemsite_costcat_id=costcat_id)
   JOIN item ON (itemsite_item_id=item_id)
  WHERE (itemsite_id=pItemsiteid);

--  Create the AD transaction
  INSERT INTO invhist
   ( invhist_itemsite_id,
     invhist_transdate, invhist_transtype, invhist_invqty,
     invhist_qoh_before, invhist_qoh_after,
     invhist_docnumber, invhist_comments,
     invhist_invuom, invhist_unitcost, invhist_hasdetail,
     invhist_costmethod, invhist_value_before, invhist_value_after,
     invhist_series )
  SELECT itemsite_id,
         CURRENT_TIMESTAMP, 'AD', 0.0,
         itemsite_qtyonhand, itemsite_qtyonhand,
         '', 'Inventory Value Adjustment',
         uom_name, _delta, FALSE,
         itemsite_costmethod, itemsite_value, pNewValue,
         0
  FROM itemsite, item, uom
  WHERE ( (itemsite_item_id=item_id)
   AND (item_inv_uom_id=uom_id)
   AND (itemsite_id=pItemsiteid) );

  UPDATE itemsite SET itemsite_value=pNewValue
  WHERE (itemsite_id=pItemsiteid);

  RETURN 0;

END;
$_$;


ALTER FUNCTION public.adjustinvvalue(integer, numeric, integer) OWNER TO admin;

--
-- Name: adjustments(text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION adjustments(text) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pTransType ALIAS FOR $1;

BEGIN
  IF (pTransType IN ('CC', 'AD')) THEN
    RETURN TRUE;
  ELSE
    RETURN FALSE;
  END IF;

END;
$_$;


ALTER FUNCTION public.adjustments(text) OWNER TO admin;

--
-- Name: allocatedforso(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION allocatedforso(integer, date) RETURNS numeric
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid ALIAS FOR $1;
  pDate ALIAS FOR $2;

BEGIN

  RETURN allocatedForSo(pItemsiteid, startOfTime(), pDate);

END;
$_$;


ALTER FUNCTION public.allocatedforso(integer, date) OWNER TO admin;

--
-- Name: allocatedforso(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION allocatedforso(integer, integer) RETURNS numeric
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid ALIAS FOR $1;
  pDate ALIAS FOR $2;

BEGIN

  RETURN allocatedForSo(pItemsiteid, startOfTime(), (CURRENT_DATE + pDate));

END;
$_$;


ALTER FUNCTION public.allocatedforso(integer, integer) OWNER TO admin;

--
-- Name: allocatedforso(integer, date, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION allocatedforso(integer, date, date) RETURNS numeric
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid ALIAS FOR $1;
  pStartDate ALIAS FOR $2;
  pEndDate ALIAS FOR $3;
  _qty NUMERIC;

BEGIN

  SELECT COALESCE(SUM(noNeg(itemuomtouom(itemsite_item_id, coitem_qty_uom_id, NULL, coitem_qtyord - (coitem_qtyshipped + qtyAtShipping(coitem_id)) + coitem_qtyreturned))), 0.0) INTO _qty
  FROM coitem, itemsite, item
  WHERE ( (coitem_itemsite_id=itemsite_id)
    AND (itemsite_item_id=item_id)
    AND (coitem_status='O')
    AND (coitem_itemsite_id=pItemsiteid)
    AND (coitem_scheddate BETWEEN pStartDate AND pEndDate) );

  RETURN _qty;

END;
$_$;


ALTER FUNCTION public.allocatedforso(integer, date, date) OWNER TO admin;

--
-- Name: allocatedforwo(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION allocatedforwo(integer, date) RETURNS numeric
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid ALIAS FOR $1;
  pDate ALIAS FOR $2;

BEGIN

  RETURN allocatedForWo(pItemsiteid, startOfTime(), pDate);

END;
$_$;


ALTER FUNCTION public.allocatedforwo(integer, date) OWNER TO admin;

--
-- Name: allocatedforwo(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION allocatedforwo(integer, integer) RETURNS numeric
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid ALIAS FOR $1;
  pLookAheadDays ALIAS FOR $2;

BEGIN

  RETURN allocatedForWo(pItemsiteid, startOfTime(), (CURRENT_DATE + pLookaheadDays));

END;
$_$;


ALTER FUNCTION public.allocatedforwo(integer, integer) OWNER TO admin;

--
-- Name: allocatedforwo(integer, date, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION allocatedforwo(integer, date, date) RETURNS numeric
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid ALIAS FOR $1;
  pStartDate ALIAS FOR $2;
  pEndDate ALIAS FOR $3;
  _itemtype TEXT;
  _qty NUMERIC;

BEGIN

  SELECT item_type INTO _itemtype
  FROM itemsite JOIN item ON (item_id=itemsite_item_id)
  WHERE (itemsite_id=pItemsiteid);

  IF (_itemtype != 'T') THEN
    SELECT
      COALESCE(SUM(noNeg(itemuomtouom(itemsite_item_id, womatl_uom_id, NULL, womatl_qtyreq - womatl_qtyiss))), 0.0) INTO _qty
    FROM womatl JOIN wo ON (wo_id=womatl_wo_id AND wo_status IN ('E','I','R'))
                JOIN itemsite ON (itemsite_id=womatl_itemsite_id)
    WHERE (womatl_itemsite_id=pItemsiteid)
      AND (womatl_duedate BETWEEN pStartDate AND pEndDate);
  ELSE
    SELECT
      COALESCE(SUM(noNeg(itemuomtouom(itemsite_item_id, womatl_uom_id, NULL, womatl_qtyreq))), 0.0)  -
	(
		SELECT COALESCE(SUM(invhist_invqty),0) 
		FROM itemsite, item, wo, womatl
			LEFT OUTER JOIN womatlpost ON (womatl_id=womatlpost_womatl_id)
			LEFT OUTER JOIN invhist ON ((womatlpost_invhist_id=invhist_id)
                            AND (invhist_invqty > 0))
		WHERE ( (womatl_itemsite_id=pItemsiteid)
		AND (womatl_itemsite_id=itemsite_id)
		AND (itemsite_item_id=item_id)
		AND (womatl_duedate BETWEEN pStartDate AND pEndDate) 
		AND (wo_id=womatl_wo_id)
		AND (wo_status IN ('E','I','R')) )
	) INTO _qty
    FROM womatl JOIN wo ON (wo_id=womatl_wo_id AND wo_status IN ('E','I','R'))
                JOIN itemsite ON (itemsite_id=womatl_itemsite_id)
    WHERE (womatl_itemsite_id=pItemsiteid)
      AND (womatl_duedate BETWEEN pStartDate AND pEndDate);
  END IF;

  RETURN COALESCE(_qty,0);

END;
$_$;


ALTER FUNCTION public.allocatedforwo(integer, date, date) OWNER TO admin;

--
-- Name: alterencrypt(text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION alterencrypt(text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pOldKey ALIAS FOR $1;
  pNewKey ALIAS FOR $2;
  _cc RECORD;
  _ccaud RECORD;
  _metricenc RECORD;
  num_updated INTEGER;

BEGIN

  num_updated := 0;

-- Update ccard

  FOR _cc IN SELECT ccard_id, 
             decrypt(setbytea(ccard_name), setbytea(pOldKey), 'bf') AS ccard_name,
             decrypt(setbytea(ccard_address1), setbytea(pOldKey), 'bf') AS ccard_address1,
             decrypt(setbytea(ccard_address2), setbytea(pOldKey), 'bf') AS ccard_address2,
             decrypt(setbytea(ccard_city), setbytea(pOldKey), 'bf') AS ccard_city,
             decrypt(setbytea(ccard_state), setbytea(pOldKey), 'bf') AS ccard_state,
             decrypt(setbytea(ccard_zip), setbytea(pOldKey), 'bf') AS ccard_zip,
             decrypt(setbytea(ccard_country), setbytea(pOldKey), 'bf') AS ccard_country,
             decrypt(setbytea(ccard_number), setbytea(pOldKey), 'bf') AS ccard_number,
             decrypt(setbytea(ccard_month_expired), setbytea(pOldKey), 'bf') AS ccard_month_expired,
             decrypt(setbytea(ccard_year_expired), setbytea(pOldKey), 'bf') AS ccard_year_expired
      FROM ccard LOOP

      UPDATE ccard
             set ccard_name = encrypt(setbytea(_cc.ccard_name), setbytea(pNewKey), 'bf'),
                 ccard_address1 = encrypt(setbytea(_cc.ccard_address1), setbytea(pNewKey), 'bf'),
                 ccard_address2 = encrypt(setbytea(_cc.ccard_address2), setbytea(pNewKey), 'bf'),
                 ccard_city = encrypt(setbytea(_cc.ccard_city), setbytea(pNewKey), 'bf'),
                 ccard_state = encrypt(setbytea(_cc.ccard_state), setbytea(pNewKey), 'bf'),
                 ccard_zip = encrypt(setbytea(_cc.ccard_zip), setbytea(pNewKey), 'bf'),
                 ccard_country = encrypt(setbytea(_cc.ccard_country), setbytea(pNewKey), 'bf'),
                 ccard_number = encrypt(setbytea(_cc.ccard_number), setbytea(pNewKey), 'bf'),
                 ccard_month_expired = encrypt(setbytea(_cc.ccard_month_expired), setbytea(pNewKey), 'bf'),
                 ccard_year_expired = encrypt(setbytea(_cc.ccard_year_expired), setbytea(pNewKey), 'bf')
      WHERE ccard_id = _cc.ccard_id;

      num_updated := num_updated + 1;

  END LOOP;

-- Update ccardaud

  FOR _ccaud IN SELECT ccardaud_id, 
             decrypt(setbytea(ccardaud_ccard_name_old), setbytea(pOldKey), 'bf') AS ccardaud_ccard_name_old,
             decrypt(setbytea(ccardaud_ccard_name_new), setbytea(pOldKey), 'bf') AS ccardaud_ccard_name_new,
             decrypt(setbytea(ccardaud_ccard_address1_old), setbytea(pOldKey), 'bf') AS ccardaud_ccard_address1_old,
             decrypt(setbytea(ccardaud_ccard_address1_new), setbytea(pOldKey), 'bf') AS ccardaud_ccard_address1_new,
             decrypt(setbytea(ccardaud_ccard_address2_old), setbytea(pOldKey), 'bf') AS ccardaud_ccard_address2_old,
             decrypt(setbytea(ccardaud_ccard_address2_new), setbytea(pOldKey), 'bf') AS ccardaud_ccard_address2_new,
             decrypt(setbytea(ccardaud_ccard_city_old), setbytea(pOldKey), 'bf') AS ccardaud_ccard_city_old,
             decrypt(setbytea(ccardaud_ccard_city_new), setbytea(pOldKey), 'bf') AS ccardaud_ccard_city_new,
             decrypt(setbytea(ccardaud_ccard_state_old), setbytea(pOldKey), 'bf') AS ccardaud_ccard_state_old,
             decrypt(setbytea(ccardaud_ccard_state_new), setbytea(pOldKey), 'bf') AS ccardaud_ccard_state_new,
             decrypt(setbytea(ccardaud_ccard_zip_old), setbytea(pOldKey), 'bf') AS ccardaud_ccard_zip_old,
             decrypt(setbytea(ccardaud_ccard_zip_new), setbytea(pOldKey), 'bf') AS ccardaud_ccard_zip_new,
             decrypt(setbytea(ccardaud_ccard_country_old), setbytea(pOldKey), 'bf') AS ccardaud_ccard_country_old,
             decrypt(setbytea(ccardaud_ccard_country_new), setbytea(pOldKey), 'bf') AS ccardaud_ccard_country_new,
             decrypt(setbytea(ccardaud_ccard_number_old), setbytea(pOldKey), 'bf') AS ccardaud_ccard_number_old,
             decrypt(setbytea(ccardaud_ccard_number_new), setbytea(pOldKey), 'bf') AS ccardaud_ccard_number_new,
             decrypt(setbytea(ccardaud_ccard_month_expired_old), setbytea(pOldKey), 'bf') AS ccardaud_ccard_month_expired_old,
             decrypt(setbytea(ccardaud_ccard_month_expired_new), setbytea(pOldKey), 'bf') AS ccardaud_ccard_month_expired_new,
             decrypt(setbytea(ccardaud_ccard_year_expired_old), setbytea(pOldKey), 'bf') AS ccardaud_ccard_year_expired_old,
             decrypt(setbytea(ccardaud_ccard_year_expired_new), setbytea(pOldKey), 'bf') AS ccardaud_ccard_year_expired_new
      FROM ccardaud LOOP

      UPDATE ccardaud
             set ccardaud_ccard_name_old = encrypt(setbytea(_ccaud.ccardaud_ccard_name_old), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_name_new = encrypt(setbytea(_ccaud.ccardaud_ccard_name_new), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_address1_old = encrypt(setbytea(_ccaud.ccardaud_ccard_address1_old), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_address1_new = encrypt(setbytea(_ccaud.ccardaud_ccard_address1_new), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_address2_old = encrypt(setbytea(_ccaud.ccardaud_ccard_address2_old), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_address2_new = encrypt(setbytea(_ccaud.ccardaud_ccard_address2_new), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_city_old = encrypt(setbytea(_ccaud.ccardaud_ccard_city_old), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_city_new = encrypt(setbytea(_ccaud.ccardaud_ccard_city_new), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_state_old = encrypt(setbytea(_ccaud.ccardaud_ccard_state_old), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_state_new = encrypt(setbytea(_ccaud.ccardaud_ccard_state_new), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_zip_old = encrypt(setbytea(_ccaud.ccardaud_ccard_zip_old), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_zip_new = encrypt(setbytea(_ccaud.ccardaud_ccard_zip_new), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_country_old = encrypt(setbytea(_ccaud.ccardaud_ccard_country_old), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_country_new = encrypt(setbytea(_ccaud.ccardaud_ccard_country_new), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_number_old = encrypt(setbytea(_ccaud.ccardaud_ccard_number_old), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_number_new = encrypt(setbytea(_ccaud.ccardaud_ccard_number_new), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_month_expired_old = encrypt(setbytea(_ccaud.ccardaud_ccard_month_expired_old), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_month_expired_new = encrypt(setbytea(_ccaud.ccardaud_ccard_month_expired_new), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_year_expired_old = encrypt(setbytea(_ccaud.ccardaud_ccard_year_expired_old), setbytea(pNewKey), 'bf'),
                 ccardaud_ccard_year_expired_new = encrypt(setbytea(_ccaud.ccardaud_ccard_year_expired_new), setbytea(pNewKey), 'bf')
      WHERE ccardaud_id = _ccaud.ccardaud_id;

      num_updated := num_updated + 1;

  END LOOP;

-- Update metricenc

  FOR _metricenc IN SELECT metricenc_id, 
             decrypt(setbytea(metricenc_value), setbytea(pOldKey), 'bf') AS metricenc_value
      FROM metricenc LOOP

      UPDATE metricenc
             set metricenc_value = encrypt(setbytea(_metricenc.metricenc_value), setbytea(pNewKey), 'bf')
      WHERE metricenc_id = _metricenc.metricenc_id;

      num_updated := num_updated + 1;

  END LOOP;


  RETURN num_updated;

END;
$_$;


ALTER FUNCTION public.alterencrypt(text, text) OWNER TO admin;

--
-- Name: apaging(date, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION apaging(date, boolean) RETURNS SETOF apaging
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pAsOfDate ALIAS FOR $1;
  pUseDocDate ALIAS FOR $2;
  _row apaging%ROWTYPE;
  _x RECORD;
  _returnVal INTEGER;
  _asOfDate DATE;
BEGIN

  _asOfDate := COALESCE(pAsOfDate,current_date);

  FOR _x IN
        SELECT
        --report uses currency rate snapshot to convert all amounts to base based on apopen_docdate to ensure the same exchange rate

        --today and greater base:
        CASE WHEN((apopen_duedate >= DATE(_asOfDate)))
        THEN (((apopen_amount-apopen_paid+COALESCE(SUM(apapply_target_paid),0)))/apopen_curr_rate *
        CASE WHEN (apopen_doctype IN ('D', 'V')) THEN 1 ELSE -1 END) ELSE 0 END AS cur_val,

        --0 to 30 base
        CASE WHEN((apopen_duedate >= DATE(_asOfDate)-30) AND (apopen_duedate < DATE(_asOfDate)))
        THEN (((apopen_amount-apopen_paid+COALESCE(SUM(apapply_target_paid),0)))/apopen_curr_rate *
        CASE WHEN (apopen_doctype IN ('D', 'V')) THEN 1 ELSE -1 END) ELSE 0 END AS thirty_val,

        --30-60 base
        CASE WHEN((apopen_duedate >= DATE(_asOfDate)-60) AND (apopen_duedate < DATE(_asOfDate) - 30 ))
        THEN (((apopen_amount-apopen_paid+COALESCE(SUM(apapply_target_paid),0)))/apopen_curr_rate *
        CASE WHEN (apopen_doctype IN ('D', 'V')) THEN 1 ELSE -1 END) ELSE 0 END AS sixty_val,

        --60-90 base
        CASE WHEN((apopen_duedate >= DATE(_asOfDate)-90) AND (apopen_duedate < DATE(_asOfDate) - 60))
        THEN (((apopen_amount-apopen_paid+COALESCE(SUM(apapply_target_paid),0)))/apopen_curr_rate *
        CASE WHEN (apopen_doctype IN ('D', 'V')) THEN 1 ELSE -1 END) ELSE 0 END AS ninety_val,

        --greater than 90 base:
        CASE WHEN((apopen_duedate > DATE(_asOfDate)-10000) AND (apopen_duedate < DATE(_asOfDate) - 90))
        THEN (((apopen_amount-apopen_paid + COALESCE(SUM(apapply_target_paid),0)))/apopen_curr_rate *
        CASE WHEN (apopen_doctype IN ('D', 'V')) THEN 1 ELSE -1 END) ELSE 0 END AS plus_val,

        --total amount base:
        CASE WHEN((apopen_duedate > DATE(_asOfDate)-10000))
        THEN (((apopen_amount-apopen_paid+COALESCE(SUM(apapply_target_paid),0)))/apopen_curr_rate *
        CASE WHEN (apopen_doctype IN ('D', 'V')) THEN 1 ELSE -1 END) ELSE 0 END AS total_val,

        --AP Open Amount base
        CASE WHEN apopen_doctype IN ('C', 'R') 
        THEN (apopen_amount * -1) / apopen_curr_rate
        ELSE apopen_amount / apopen_curr_rate END AS apopen_amount,
        
        apopen_docdate,
        apopen_duedate,
        apopen_ponumber,
        apopen_invcnumber,
        apopen_docnumber,
        apopen_doctype,
        vend_id,
        vend_name,
        vend_number,
        vend_vendtype_id,
        vendtype_code,
        terms_descrip,
        determineDiscountDate(terms_id, apopen_docdate) AS discdate,
        noNeg(apopen_discountable_amount *
                     CASE WHEN (CURRENT_DATE <= determineDiscountDate(terms_id, apopen_docdate)) THEN terms_discprcnt
                     ELSE 0.0 END) AS disc_val,
        terms_discdays AS discdays,
        (terms_discprcnt * 100.0) AS discprcnt

        FROM vendinfo, vendtype, apopen
          LEFT OUTER JOIN terms ON (apopen_terms_id=terms_id)
          LEFT OUTER JOIN apapply ON (((apopen_id=apapply_target_apopen_id)
                                    OR (apopen_id=apapply_source_apopen_id))
                                   AND (apapply_postdate >_asOfDate))
        WHERE ( (apopen_vend_id = vend_id)
        AND (vend_vendtype_id=vendtype_id)
        AND (CASE WHEN (pUseDocDate) THEN apopen_docdate ELSE apopen_distdate END <= _asOfDate)
        AND (COALESCE(apopen_closedate,_asOfDate+1)>_asOfDate) )
        GROUP BY apopen_id,apopen_docdate,apopen_duedate,apopen_ponumber, apopen_invcnumber, apopen_docnumber,apopen_doctype,apopen_paid,
                 apopen_curr_id,apopen_amount,vend_id,vend_name,vend_number,vend_vendtype_id,vendtype_code,terms_descrip,
                 apopen_curr_rate, terms_id, terms_discdays, terms_discprcnt, apopen_discountable_amount
        ORDER BY vend_number, apopen_duedate
  LOOP
        _row.apaging_docdate := _x.apopen_docdate;
        _row.apaging_duedate := _x.apopen_duedate;
        _row.apaging_ponumber := _x.apopen_ponumber;
        _row.apaging_invcnumber := _x.apopen_invcnumber;
        _row.apaging_docnumber := _x.apopen_docnumber;
        _row.apaging_doctype := _x.apopen_doctype;
        _row.apaging_vend_id := _x.vend_id;
        _row.apaging_vend_number := _x.vend_number;
        _row.apaging_vend_name := _x.vend_name;
        _row.apaging_vend_vendtype_id := _x.vend_vendtype_id;
        _row.apaging_vendtype_code := _x.vendtype_code;
        _row.apaging_terms_descrip := _x.terms_descrip;
        _row.apaging_apopen_amount := _x.apopen_amount;
        _row.apaging_cur_val := _x.cur_val;
        _row.apaging_thirty_val := _x.thirty_val;
        _row.apaging_sixty_val := _x.sixty_val;
        _row.apaging_ninety_val := _x.ninety_val;
        _row.apaging_plus_val := _x.plus_val;
        _row.apaging_total_val := _x.total_val;
        _row.apaging_discdate := _x.discdate;
        _row.apaging_disc_val := _x.disc_val;
        _row.apaging_discdays := _x.discdays;
        _row.apaging_discprcnt := _x.discprcnt;
        RETURN NEXT _row;
  END LOOP;
  RETURN;
END;
$_$;


ALTER FUNCTION public.apaging(date, boolean) OWNER TO admin;

--
-- Name: apapplied(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION apapplied(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pApopenid ALIAS FOR $1;
  pDate ALIAS FOR $2;
  _amount NUMERIC;

BEGIN

  -- Return amount applied to an apopen in base currency as of apapply_postdate
  SELECT SUM(currtobase(apapply_curr_id,apapply_amount,apapply_postdate)) INTO _amount
  FROM apapply
  WHERE (((apapply_target_apopen_id = pApopenid) OR (apapply_source_apopen_id = pApopenid))
  AND (((apapply_journalnumber=0) AND (apapply_postdate <= pDate))
  OR EXISTS(SELECT * 
             FROM gltrans 
             WHERE ((gltrans_journalnumber=apapply_journalnumber)
             AND (gltrans_date <= pDate)))));

  IF (_amount IS NULL) THEN
    RETURN 0;
  ELSE
    RETURN _amount;
  END IF;

END;
$_$;


ALTER FUNCTION public.apapplied(integer, date) OWNER TO admin;

--
-- Name: apcheckpending(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION apcheckpending(integer) RETURNS numeric
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pApopenid	ALIAS FOR $1;
  _qty NUMERIC  := 0.0;

BEGIN

  SELECT SUM(checkitem_amount + checkitem_discount) INTO _qty
    FROM checkitem JOIN checkhead ON (checkitem_checkhead_id=checkhead_id)
   WHERE ((checkitem_apopen_id=pApopenid)
     AND (NOT checkhead_deleted)
     AND (NOT checkhead_replaced)
     AND (NOT checkhead_posted));

  RETURN COALESCE(_qty, 0.0);

END;
$_$;


ALTER FUNCTION public.apcheckpending(integer) OWNER TO admin;

--
-- Name: apcurrgain(integer, integer, numeric, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION apcurrgain(integer, integer, numeric, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pApopenId ALIAS FOR $1;
  pCurrId ALIAS FOR $2;
  pValue ALIAS FOR $3;
  pDate ALIAS FOR $4;
  _start DATE;
  _end DATE;
  _gain NUMERIC;
  _r RECORD;

BEGIN
  IF (pApopenId IS NULL OR pValue = 0) THEN
    RETURN 0;
  END IF;

  SELECT apopen_docdate, apopen_curr_rate
    INTO _r
  FROM apopen
  WHERE (apopen_id=pApopenId);

  IF (_r.apopen_docdate > pDate) THEN
    _gain := (currToBase(pCurrId, pValue, pDate) - (pValue / _r.apopen_curr_rate)) * -1;
  ELSE
    _gain := (pValue / _r.apopen_curr_rate) - currToBase(pCurrId, pValue, pDate);
  END IF;
  
  IF (_gain IS NULL) THEN
    RAISE EXCEPTION 'Error processing currency gain/loss.';
  END IF;

  RETURN _gain;
END;
$_$;


ALTER FUNCTION public.apcurrgain(integer, integer, numeric, date) OWNER TO admin;

--
-- Name: applyapcreditmemotobalance(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION applyapcreditmemotobalance(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pApopenid ALIAS FOR $1;
  _amount NUMERIC;
  _curr_id INTEGER;
  _curr_rate NUMERIC;
  _docdate DATE;
  _applyAmount NUMERIC;
  _r RECORD;
  _p RECORD;

BEGIN

--  Find the balance to apply
  SELECT (apopen_amount - apopen_paid - COALESCE(prepared,0.0) - COALESCE(selected,0.0) - COALESCE(SUM(currToCurr(apcreditapply_curr_id,
                                                  apopen_curr_id,
                                                  apcreditapply_amount,
                                                  apopen_docdate)), 0)),
          apopen_curr_id, apopen_curr_rate, apopen_docdate INTO _amount, _curr_id, _curr_rate, _docdate
  FROM apopen 
    LEFT OUTER JOIN apcreditapply ON (apcreditapply_source_apopen_id=apopen_id)
    LEFT OUTER JOIN (SELECT apopen_id AS selected_apopen_id,
                       SUM(currToCurr(apselect_curr_id, apopen_curr_id, apselect_amount + apselect_discount, apselect_date)) AS selected
                     FROM apselect JOIN apopen ON (apselect_apopen_id=apopen_id)
                     GROUP BY apopen_id) AS sub1 ON (apopen_id=selected_apopen_id)
    LEFT OUTER JOIN (SELECT apopen_id AS prepared_apopen_id,
                       SUM(checkitem_amount + checkitem_discount) AS prepared
                     FROM checkhead 
                       JOIN checkitem ON (checkitem_checkhead_id=checkhead_id)
                       JOIN apopen ON (checkitem_apopen_id=apopen_id)
                     WHERE ((NOT checkhead_posted)
                       AND  (NOT checkhead_void))
                     GROUP BY apopen_id) AS sub2 ON (prepared_apopen_id=apopen_id)
  WHERE (apopen_id=pApopenid)
  GROUP BY apopen_amount, apopen_paid, apopen_curr_id, apopen_curr_rate, apopen_docdate, prepared, selected;

  IF (_amount < 0) THEN
    RETURN -1;
  END IF;

--  Loop through the apopen items in order of due date
  FOR _r IN SELECT target.apopen_id AS apopenid,
                   currToCurr(target.apopen_curr_id,source.apopen_curr_id, 
                     target.apopen_amount - target.apopen_paid - COALESCE(prepared,0.0) - COALESCE(selected,0.0) - COALESCE(applied,0.0),
                     current_date) AS balance
           FROM apopen AS source, apopen AS target
             LEFT OUTER JOIN (SELECT apcreditapply_target_apopen_id AS applied_apopen_id,
                                     SUM(currToCurr(apcreditapply_curr_id, apopen_curr_id, apcreditapply_amount, apopen_docdate)) AS applied
                              FROM apcreditapply JOIN apopen ON (apopen_id=apcreditapply_source_apopen_id)
                              GROUP BY apcreditapply_target_apopen_id) AS sub3
                              ON (target.apopen_id=applied_apopen_id)
             LEFT OUTER JOIN (SELECT apopen_id AS selected_apopen_id,
                                SUM(currToCurr(apselect_curr_id, apopen_curr_id, apselect_amount + apselect_discount, apselect_date)) AS selected
                                    FROM apselect JOIN apopen ON (apselect_apopen_id=apopen_id)
                                GROUP BY apopen_id) AS sub1
                                ON (target.apopen_id=selected_apopen_id)
             LEFT OUTER JOIN (SELECT apopen_id AS prepared_apopen_id,
                                SUM(checkitem_amount + checkitem_discount) AS prepared
                              FROM checkhead 
                                JOIN checkitem ON (checkitem_checkhead_id=checkhead_id)
                                JOIN apopen ON (checkitem_apopen_id=apopen_id)
                              WHERE ((NOT checkhead_posted)
                               AND  (NOT checkhead_void))
                              GROUP BY apopen_id) AS sub2 ON (prepared_apopen_id=target.apopen_id)
            WHERE ( (source.apopen_vend_id=target.apopen_vend_id)
             AND (target.apopen_doctype IN ('V', 'D'))
             AND (target.apopen_open)
             AND (source.apopen_id=pApopenid) )
            ORDER BY target.apopen_duedate, (target.apopen_amount - target.apopen_paid) LOOP

--  Determine the amount to apply
    IF (_r.balance <= 0.0) THEN
      CONTINUE;
    ELSEIF (_r.balance > _amount) THEN
      _applyAmount := _amount;
    ELSE
      _applyAmount := _r.balance;
    END IF;

--  Does an apcreditapply record already exist?
    SELECT apcreditapply_id, 
              apcreditapply_amount * _curr_rate / 
                 currRate(apcreditapply_curr_id,_docdate) AS apcreditapply_amount
      INTO _p
    FROM apcreditapply
    WHERE ( (apcreditapply_target_apopen_id=_r.apopenid)
     AND (apcreditapply_source_apopen_id=pApopenid) );

    IF (FOUND) THEN
--  The following is depreciated, just skip the record
--  Recalculate the amount to apply
--      IF ((_r.balance - _p.apcreditapply_amount) > _amount) THEN
--        _applyAmount := _amount;
--      ELSE
--        _applyAmount := (_r.balance - _p.apcreditapply_amount);
--      END IF;

--  Update the apcreditapply with the new amount to apply
--      UPDATE apcreditapply
--      SET apcreditapply_amount = (apcreditapply_amount + 
--          _applyAmount *  currRate(apcreditapply_curr_id,_docdate) / _curr_rate)
--      WHERE (apcreditapply_id=_p.apcreditapply_id);

      CONTINUE;
    ELSE
--  Create a new apcreditapply record
      INSERT INTO apcreditapply
      ( apcreditapply_source_apopen_id, apcreditapply_target_apopen_id,
        apcreditapply_amount, apcreditapply_curr_id )
      VALUES
      ( pApopenid, _r.apopenid, _applyAmount, _curr_id );
    END IF;

    _amount := (_amount - _applyAmount);
    IF (_amount = 0) THEN
      EXIT;
    END IF;

  END LOOP;

  RETURN 1;

END;
$_$;


ALTER FUNCTION public.applyapcreditmemotobalance(integer) OWNER TO admin;

--
-- Name: applyapcredits(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION applyapcredits(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendId   ALIAS FOR $1;
  _result   INTEGER;
  _apopenid INTEGER;
  _r        RECORD;

BEGIN

  -- Fetch credit memo(s) for the vendor
  FOR _r IN SELECT apopen_id, apopen_duedate
            FROM apopen JOIN vendinfo ON (apopen_vend_id = vend_id)
            WHERE ((apopen_doctype = 'C')
               AND (apopen_status = 'O')
               AND (vend_id = pVendId))
            ORDER BY apopen_duedate
  LOOP
    -- Apply credit memo(s) according to due date
    SELECT applyapcreditmemotobalance(_r.apopen_id) INTO _result;

    -- Post the credit memo if applied
    IF (_result = 1) THEN
      SELECT postapcreditmemoapplication(_r.apopen_id) INTO _apopenid;
      IF (_apopenid < 0) THEN
        RETURN -1;
      END IF;
    ELSE
      RETURN -1;
    END IF;

  END LOOP;

RETURN 1;

END;
$_$;


ALTER FUNCTION public.applyapcredits(integer) OWNER TO admin;

--
-- Name: applyarcreditmemotobalance(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION applyarcreditmemotobalance(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pAropenid ALIAS FOR $1;

BEGIN

  RETURN applyARCreditMemoToBalance(pAropenid, NULL);

END;
$_$;


ALTER FUNCTION public.applyarcreditmemotobalance(integer) OWNER TO admin;

--
-- Name: applyarcreditmemotobalance(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION applyarcreditmemotobalance(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSourceAropenid ALIAS FOR $1;
  pTargetAropenid ALIAS FOR $2;
  _amount NUMERIC;
  _amountcurrid INTEGER;
  _applyAmount NUMERIC;
  _applycurrid  INTEGER;
  _curr_rate NUMERIC;
  _r RECORD;
  _p RECORD;

BEGIN

--  Find the balance to apply
  SELECT (aropen_amount - COALESCE(SUM(currToCurr(arcreditapply_curr_id,
                                                  aropen_curr_id,
                                                  arcreditapply_amount,
                                                  aropen_docdate)), 0) - aropen_paid - COALESCE(prepared,0.0) - COALESCE(cashapplied,0.0)),
         aropen_curr_id, aropen_curr_rate INTO _amount, _amountcurrid, _curr_rate
  FROM aropen LEFT OUTER JOIN arcreditapply ON (arcreditapply_source_aropen_id=aropen_id)
	      LEFT OUTER JOIN (SELECT aropen_id AS prepared_aropen_id,
                                SUM(checkitem_amount + checkitem_discount) AS prepared
                               FROM checkhead JOIN checkitem ON (checkitem_checkhead_id=checkhead_id)
                                              JOIN aropen ON (checkitem_aropen_id=aropen_id)
                               WHERE ((NOT checkhead_posted)
                                AND  (NOT checkhead_void))
                               GROUP BY aropen_id) AS sub1
                      ON (prepared_aropen_id=aropen_id)
             LEFT OUTER JOIN (SELECT aropen_id AS cash_aropen_id,
                                     SUM(cashrcptitem_amount + cashrcptitem_discount) * -1.0 AS cashapplied
                                FROM cashrcpt JOIN cashrcptitem ON (cashrcptitem_cashrcpt_id=cashrcpt_id)
                                              JOIN aropen ON (cashrcptitem_aropen_id=aropen_id)
                               WHERE (NOT cashrcpt_posted) AND (NOT cashrcpt_void)
                               GROUP BY aropen_id ) AS sub2
                      ON (cash_aropen_id=aropen_id)
  WHERE (aropen_id=pSourceAropenid)
  GROUP BY aropen_amount, aropen_paid, aropen_curr_id, aropen_curr_rate, prepared, cashapplied;

  IF (_amount < 0) THEN
    RETURN -1;
  END IF;

--  Loop through the aropen items in order of due date
  FOR _r IN SELECT target.aropen_id AS aropenid,
                   currToCurr(target.aropen_curr_id,source.aropen_curr_id,
                              (target.aropen_amount - target.aropen_paid - calcpendingarapplications(target.aropen_id)),
                              current_date) AS balance,
                   target.aropen_curr_id AS curr_id,
                   target.aropen_docdate AS docdate
            FROM aropen AS target, aropen AS source
            WHERE ( (source.aropen_cust_id=target.aropen_cust_id)
             AND (target.aropen_doctype IN ('D', 'I'))
             AND (target.aropen_open)
             AND (source.aropen_id=pSourceAropenid)
             AND ((pTargetAropenid IS NULL) OR (target.aropen_id=pTargetAropenid)) )
            ORDER BY target.aropen_duedate, target.aropen_docnumber LOOP

--  Determine the amount to apply
    IF (_r.balance > _amount) THEN
      _applyAmount := _amount;
    ELSE
      _applyAmount := _r.balance;
    END IF;
    _applycurrid := _amountcurrid;

--  Does an arcreditapply record already exist?
    SELECT arcreditapply_id,
           arcreditapply_amount,
           arcreditapply_amount * _curr_rate / 
                 currRate(arcreditapply_curr_id,_r.docdate) AS
                      arcreditapply_amount_applycurr INTO _p
    FROM arcreditapply
    WHERE ( (arcreditapply_target_aropen_id=_r.aropenid)
     AND (arcreditapply_source_aropen_id=pSourceAropenid) );

    IF (FOUND) THEN
--  Offset the amount to apply by the amount already applied
      _applyAmount := (_applyAmount - _p.arcreditapply_amount_applycurr);
      IF (_applyAmount < 0) THEN
        _applyAmount := 0;
      END IF;

--  Update the arcreditapply with the new amount to apply
      UPDATE arcreditapply
      SET arcreditapply_amount = (arcreditapply_amount + 
          _applyAmount *  currRate(arcreditapply_curr_id,_r.docdate) / _curr_rate)
      WHERE (arcreditapply_id=_p.arcreditapply_id);

    ELSE
--  Create a new arcreditapply record
      INSERT INTO arcreditapply
      ( arcreditapply_source_aropen_id, arcreditapply_target_aropen_id,
        arcreditapply_amount, arcreditapply_curr_id )
      VALUES
      ( pSourceAropenid, _r.aropenid, _applyAmount, _applycurrid );
    END IF;

    _amount := _amount - currToCurr(_applycurrid, _amountcurrid, _applyAmount, _r.docdate);
    IF (_amount = 0) THEN
      EXIT;
    END IF;

  END LOOP;

  RETURN 1;

END;
$_$;


ALTER FUNCTION public.applyarcreditmemotobalance(integer, integer) OWNER TO admin;

--
-- Name: applycashreceiptlinebalance(integer, integer, numeric, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION applycashreceiptlinebalance(integer, integer, numeric, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCashrcptId ALIAS FOR $1;
  pAropenid ALIAS FOR $2;
  pAmount ALIAS FOR $3;
  pCurrId ALIAS FOR $4;
  _balance NUMERIC;
  _amount NUMERIC;
  _applyAmount NUMERIC := 0;
  _discount NUMERIC := 0;
  _discprct NUMERIC;
  _docDate DATE;
  _r RECORD;
  _doctype CHAR(1);

BEGIN

--  All calculations performed in currency of Cash Receipt

--  Clear previously applied
  DELETE FROM cashrcptitem WHERE ((cashrcptitem_cashrcpt_id=pCashrcptId) AND (cashrcptitem_aropen_id=pAropenId));

--  Find the balance to apply
  SELECT (pAmount - (COALESCE(SUM(cashrcptitem_amount), 0) ) ),
    COALESCE(cashrcpt_docdate, current_date)
    INTO _amount, _docDate
  FROM cashrcpt LEFT OUTER JOIN cashrcptitem ON (cashrcptitem_cashrcpt_id = cashrcpt_id)
  WHERE (cashrcpt_id=pCashrcptid)
  GROUP BY cashrcpt_curr_id, cashrcpt_distdate, cashrcpt_docdate;

  SELECT (_amount - COALESCE(SUM(cashrcptmisc_amount), 0)) INTO _amount
  FROM cashrcptmisc
  WHERE (cashrcptmisc_cashrcpt_id=pCashrcptid);

  SELECT aropen_doctype INTO _doctype
  FROM aropen
  WHERE (aropen_id=pAropenId);
  
  RAISE DEBUG 'Amount (%) DocType (%)', _amount, _doctype;

  IF (_amount <= 0 AND _doctype IN ('I','D')) THEN
    RETURN 0;
  END IF;

--  Determine Line balance
  SELECT currToCurr(aropen_curr_id, cashrcpt_curr_id,
         aropen_amount - aropen_paid, cashrcpt_distdate) -
         COALESCE((SELECT (SUM(cashrcptitem_amount) + SUM(cashrcptitem_discount))
                   FROM cashrcptitem, cashrcpt
                   WHERE ((cashrcpt_id=cashrcptitem_cashrcpt_id)
                     AND  (NOT cashrcpt_void)
                     AND  (NOT cashrcpt_posted)
                     AND  (cashrcpt_id != pCashrcptId)
                     AND  (cashrcptitem_aropen_id=pAropenId))), 0)
         INTO _balance
         FROM aropen, cashrcpt
           WHERE ((aropen_id=pAropenId)
           AND (cashrcpt_id=pCashrcptId));

  RAISE DEBUG 'Balance (%)', _balance;
            
--  If Invoice or Debit Memo, determine Max Discount as per Terms
  IF (_doctype IN ('I','D')) THEN
    SELECT  round(noNeg(_balance * 
            CASE WHEN (_docDate <= determineDiscountDate(terms_id, aropen_docdate)) THEN COALESCE(terms_discprcnt, 0.0) 
            ELSE 0.00 END - applied),2),
            CASE WHEN (_docDate <= determineDiscountDate(terms_id, aropen_docdate)) THEN COALESCE(terms_discprcnt, 0.0) 
            ELSE 0.00 END INTO _discount, _discprct
    FROM aropen LEFT OUTER JOIN terms ON (terms_id=aropen_terms_id), 
         (SELECT COALESCE(SUM(arapply_applied), 0.00) AS applied  
	  FROM arapply, aropen 
          WHERE ((arapply_target_aropen_id=pAropenId) 
           AND (arapply_source_aropen_id=pAropenId) 
           AND  (aropen_discount) )
             ) AS data 
    WHERE (aropen_id=pAropenId);

--  Determine the amount to apply
    IF (_balance <= _amount + _discount) THEN
      _applyAmount := _balance - _discount;
    ELSE
      _discount := round((_amount / (1 - _discprct)) - _amount, 2);
      _applyAmount := _amount;
    END IF;
  ELSIF (_doctype IN ('C', 'R')) THEN
  -- Handle Credits, discounts don't apply here
    _applyAmount := _balance * -1;
  ELSE
    _applyAmount := _amount;
  END IF;

  IF (_applyAmount != 0) THEN
--  Create a new cashrcptitem
      INSERT INTO cashrcptitem
      ( cashrcptitem_aropen_id, cashrcptitem_cashrcpt_id,
        cashrcptitem_amount,cashrcptitem_discount )
      VALUES
      ( pAropenid, pCashrcptid, round(_applyAmount, 2), round(_discount, 2) );
  END IF;

  RETURN abs(_applyAmount);

END;
$_$;


ALTER FUNCTION public.applycashreceiptlinebalance(integer, integer, numeric, integer) OWNER TO admin;

--
-- Name: applycashreceipttobalance(integer, numeric); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION applycashreceipttobalance(integer, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCashrcptid ALIAS FOR $1;
  pAmount ALIAS FOR $2;

BEGIN
  RETURN applyCashReceiptToBalance(pCashrcptid, pAmount, baseCurrId() );
END;
$_$;


ALTER FUNCTION public.applycashreceipttobalance(integer, numeric) OWNER TO admin;

--
-- Name: applycashreceipttobalance(integer, numeric, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION applycashreceipttobalance(integer, numeric, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCashrcptid ALIAS FOR $1;
  pAmount ALIAS FOR $2;
  pCurrId ALIAS FOR $3;

BEGIN

  RETURN applyCashReceiptToBalance(pCashrcptid, pAmount, pCurrId, false);

END;
$_$;


ALTER FUNCTION public.applycashreceipttobalance(integer, numeric, integer) OWNER TO admin;

--
-- Name: applycashreceipttobalance(integer, numeric, integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION applycashreceipttobalance(integer, numeric, integer, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCashrcptid ALIAS FOR $1;
  pAmount ALIAS FOR $2;
  pCurrId ALIAS FOR $3;
  pInclCredits ALIAS FOR $4;
  _amount NUMERIC;
  _applied NUMERIC := 0;
  _applyAmount NUMERIC;
  _discount NUMERIC;
  _discprct NUMERIC;
  _docDate DATE;
  _r RECORD;
  _toApply NUMERIC;

BEGIN

--  Apply open credits first if applicable
  IF (pInclCredits) THEN
    -- First find total debits unaccounted for by this receipt so we can apply as much credit 
    -- as possible to clear, but no more
    SELECT coalesce(noNeg(sum(currToCurr(aropen_curr_id, cashrcpt_curr_id,
         aropen_amount - aropen_paid, cashrcpt_distdate) -
         COALESCE((SELECT (SUM(cashrcptitem_amount) + SUM(cashrcptitem_discount))
                   FROM cashrcptitem, cashrcpt
                   WHERE ((cashrcpt_id=cashrcptitem_cashrcpt_id)
                     AND  (NOT cashrcpt_void)
                     AND  (NOT cashrcpt_posted)
                     AND  (cashrcpt_id != pCashrcptid)
                     AND  (cashrcptitem_aropen_id=aropen_id))), 0)) - pAmount),0)
    INTO _toApply
    FROM cashrcpt
      JOIN custinfo ON (cashrcpt_cust_id=cust_id)
      JOIN aropen ON (cust_id=aropen_cust_id)
    WHERE ((cashrcpt_id=pCashrcptid)
      AND (aropen_open)
      AND (aropen_doctype IN ('I','D')));
           
    -- Loop through and apply credits until we account for all remaining debits we can
    FOR _r IN 
      SELECT aropen_id
      FROM cashrcpt
        JOIN custinfo ON (cashrcpt_cust_id=cust_id)
        JOIN aropen ON (cust_id=aropen_cust_id)
      WHERE ((cashrcpt_id=pCashrcptid)
        AND (aropen_open)
        AND (aropen_doctype IN ('C','R')))
      ORDER BY aropen_duedate, aropen_docnumber
    LOOP
     EXIT WHEN _toApply <= 0;
      _toApply := _toApply - applyCashReceiptLineBalance(pCashrcptid, _r.aropen_id, _toApply, pCurrId);
    END LOOP;
  END IF;

--  Find the balance to apply
  SELECT (currToCurr(pCurrId, cashrcpt_curr_id, pAmount, cashrcpt_distdate) -
              (COALESCE(SUM(cashrcptitem_amount), 0) ) ),
              COALESCE(cashrcpt_docdate, current_date) 
              INTO _amount, _docDate
  FROM cashrcpt LEFT OUTER JOIN cashrcptitem ON (cashrcptitem_cashrcpt_id = cashrcpt_id)
  WHERE (cashrcpt_id=pCashrcptid)
  GROUP BY cashrcpt_curr_id, cashrcpt_distdate, cashrcpt_docdate;

  SELECT (_amount - COALESCE(SUM(cashrcptmisc_amount), 0)) INTO _amount
  FROM cashrcptmisc
  WHERE (cashrcptmisc_cashrcpt_id=pCashrcptid);

  IF (_amount = 0) THEN
    RETURN 1;
  END IF;

--  Loop through the aropen item in order of due date, searching only for
--  aropen items that are open, for the current customer and have an outstanding balance
  FOR _r IN SELECT aropen_id,
               currToCurr(aropen_curr_id, cashrcpt_curr_id,
               aropen_amount - aropen_paid, cashrcpt_distdate) -
               COALESCE((SELECT SUM(cashrcptitem_amount) + SUM(cashrcptitem_discount)
                           FROM cashrcptitem, cashrcpt
                           WHERE ((cashrcpt_id=cashrcptitem_cashrcpt_id)
                             AND  (NOT cashrcpt_void)
                             AND  (NOT cashrcpt_posted)
                             AND  (cashrcpt_id != pCashrcptId)
                             AND  (cashrcptitem_aropen_id=aropen_id))), 0) AS balance,
                   s.cashrcptitem_id AS cashrcptitem_id
            FROM cashrcpt, aropen LEFT OUTER JOIN
                 cashrcptitem s ON (s.cashrcptitem_aropen_id=aropen_id AND s.cashrcptitem_cashrcpt_id=pCashrcptId)
                 LEFT OUTER JOIN terms ON (aropen_terms_id=terms_id),
                 (SELECT COALESCE(SUM(arapply_applied), 0.00) AS applied  
                  FROM arapply, aropen 
                  WHERE ((arapply_target_aropen_id=aropen_id) 
                    AND (arapply_source_aropen_id=aropen_id) 
                    AND  (aropen_discount) )
                 ) AS data

            WHERE ( (aropen_cust_id=cashrcpt_cust_id)
             AND (aropen_doctype IN ('I', 'D'))
             AND (aropen_open)
             AND (cashrcpt_id=pCashrcptid) )
            ORDER BY aropen_duedate, aropen_amount, balance LOOP

--  Determine Max Discount as per Terms
    SELECT  round(noNeg(_r.balance * 
            CASE WHEN (_docDate <= determineDiscountDate(terms_id, aropen_docdate)) THEN terms_discprcnt 
            ELSE 0.00 END - applied),2),
            CASE WHEN (_docDate <= determineDiscountDate(terms_id, aropen_docdate)) THEN terms_discprcnt 
            ELSE 0.00 END INTO _discount, _discprct
            FROM aropen LEFT OUTER JOIN terms ON (terms_id=aropen_terms_id), 
                 (SELECT COALESCE(SUM(arapply_applied), 0.00) AS applied  
		          FROM arapply, aropen 
                  WHERE ((arapply_target_aropen_id=_r.aropen_id) 
                  AND (arapply_source_aropen_id=_r.aropen_id) 
                  AND  (aropen_discount) )
                 ) AS data 
            WHERE (aropen_id=_r.aropen_id);

--  Determine the amount to apply
    IF (_r.balance <= _amount + _discount) THEN
      _applyAmount := _r.balance - _discount;
    ELSE
      _discount := round((_amount / (1 - _discprct)) - _amount, 2);
      _applyAmount := _amount;
    END IF;

    IF (_applyAmount > 0) THEN
--  Does an cashrcptitem already exist?
      IF (_r.cashrcptitem_id IS NOT NULL) THEN
--  Update the cashrcptitem with the new amount to apply
        UPDATE cashrcptitem
        SET cashrcptitem_amount = round(cashrcptitem_amount + _applyAmount, 2),
            cashrcptitem_discount = round(_discount, 2)
        WHERE (cashrcptitem_id=_r.cashrcptitem_id);
      ELSE
--  Create a new cashrcptitem
        INSERT INTO cashrcptitem
        ( cashrcptitem_aropen_id, cashrcptitem_cashrcpt_id,
          cashrcptitem_amount, cashrcptitem_discount )
        VALUES
        ( _r.aropen_id, pCashrcptid, round(_applyAmount, 2), round(_discount, 2) );
      END IF;

      _amount := (_amount - _applyAmount);
      IF (round(_amount, 2) = 0) THEN
        EXIT;
      END IF;

    END IF;
  END LOOP;

  RETURN 1;

END;
$_$;


ALTER FUNCTION public.applycashreceipttobalance(integer, numeric, integer, boolean) OWNER TO admin;

--
-- Name: araging(date, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION araging(date, boolean) RETURNS SETOF araging
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pAsOfDate ALIAS FOR $1;
  pUseDocDate ALIAS FOR $2;
  _row araging%ROWTYPE;

BEGIN

  FOR _row IN SELECT *
            FROM araging(pAsOfDate, pUseDocDate, true)
  LOOP
    RETURN NEXT _row;
  END LOOP;

  RETURN;
END;
$_$;


ALTER FUNCTION public.araging(date, boolean) OWNER TO admin;

--
-- Name: araging(date, boolean, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION araging(date, boolean, boolean) RETURNS SETOF araging
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pAsOfDate ALIAS FOR $1;
  pUseDocDate ALIAS FOR $2;
  pConvBaseCurr ALIAS FOR $3;
  _row araging%ROWTYPE;
  _x RECORD;
  _returnVal INTEGER;
  _asOfDate DATE;
BEGIN

  _asOfDate := COALESCE(pAsOfDate,current_date);

  FOR _x IN
        SELECT
        aropen_docdate,
        aropen_duedate,
        aropen_ponumber,
        aropen_docnumber,
        aropen_doctype,
        cust_id,
        cust_name,
        cust_number,
        cust_custtype_id,
        custtype_code,
        terms_descrip,

        --if pConvBaseCurr is true then use currtobase to convert all amounts to base based on aropen_docdate to ensure the same exchange rate
        --otherwise use currtocurr to convert all amounts to customer's currency based on aropen_docdate to ensure the same exchange rate

        --today and greater:
        CASE WHEN((aropen_duedate >= DATE(_asOfDate))) THEN balance
             ELSE 0.0 END AS cur_val,

        --0 to 30
        CASE WHEN((aropen_duedate >= DATE(_asOfDate)-30) AND (aropen_duedate < DATE(_asOfDate))) THEN balance
             ELSE 0.0 END AS thirty_val,

        --30-60
        CASE WHEN((aropen_duedate >= DATE(_asOfDate)-60) AND (aropen_duedate < DATE(_asOfDate) - 30 )) THEN balance
             ELSE 0.0 END AS sixty_val,

        --60-90
        CASE WHEN((aropen_duedate >= DATE(_asOfDate)-90) AND (aropen_duedate < DATE(_asOfDate) - 60)) THEN balance
             ELSE 0.0 END AS ninety_val,

        --greater than 90:
        CASE WHEN((aropen_duedate > DATE(_asOfDate)-10000) AND (aropen_duedate < DATE(_asOfDate) - 90)) THEN balance
             ELSE 0.0 END AS plus_val,

        --total amount:
        CASE WHEN((aropen_duedate > DATE(_asOfDate)-10000)) THEN balance
             ELSE 0.0 END AS total_val,

        --AR Open Amount base
        aropen_amount

        FROM (
          SELECT
          (((aropen_amount - aropen_paid + COALESCE(SUM(arapply_target_paid),0))) /
             CASE WHEN (pConvBaseCurr) THEN aropen_curr_rate
                  ELSE currRate(aropen_curr_id, cust_curr_id, aropen_docdate)
             END *
             CASE WHEN (aropen_doctype IN ('C', 'R')) THEN -1.0
                  ELSE 1.0
             END) AS balance,
          ((aropen_amount) /
             CASE WHEN (pConvBaseCurr) THEN aropen_curr_rate
                  ELSE currRate(aropen_curr_id, cust_curr_id, aropen_docdate)
             END *
             CASE WHEN (aropen_doctype IN ('C', 'R')) THEN -1.0
                  ELSE 1.0
             END) AS aropen_amount,
          aropen_docdate,
          aropen_duedate,
          aropen_ponumber,
          aropen_docnumber,
          aropen_doctype,
          cust_id,
          cust_name,
          cust_number,
          cust_custtype_id,
          custtype_code,
          COALESCE(arterms.terms_descrip, custterms.terms_descrip, '') AS terms_descrip

          FROM aropen
            JOIN custinfo ON (cust_id=aropen_cust_id)
            JOIN custtype ON (custtype_id=cust_custtype_id)
            LEFT OUTER JOIN terms arterms ON (arterms.terms_id=aropen_terms_id)
            LEFT OUTER JOIN terms custterms ON (custterms.terms_id=cust_terms_id)
            LEFT OUTER JOIN arapply ON (((aropen_id=arapply_target_aropen_id)
                                      OR (aropen_id=arapply_source_aropen_id))
                                     AND (arapply_distdate>_asOfDate))
          WHERE ( (CASE WHEN (pUseDocDate) THEN aropen_docdate ELSE aropen_distdate END <= _asOfDate)
          AND (COALESCE(aropen_closedate,_asOfDate+1)>_asOfDate) )
          GROUP BY aropen_id,aropen_docdate,aropen_duedate,aropen_ponumber,aropen_docnumber,aropen_doctype,aropen_paid,
                   aropen_curr_id,aropen_amount,cust_id,cust_name,cust_number,cust_custtype_id,custtype_code,
                   arterms.terms_descrip,custterms.terms_descrip, aropen_curr_rate, aropen_curr_id, cust_curr_id
          ORDER BY cust_number, aropen_duedate ) AS data
  LOOP
        _row.araging_docdate := _x.aropen_docdate;
        _row.araging_duedate := _x.aropen_duedate;
        _row.araging_ponumber := _x.aropen_ponumber;
        _row.araging_docnumber := _x.aropen_docnumber;
        _row.araging_doctype := _x.aropen_doctype;
        _row.araging_cust_id := _x.cust_id;
        _row.araging_cust_number := _x.cust_number;
        _row.araging_cust_name := _x.cust_name;
        _row.araging_cust_custtype_id := _x.cust_custtype_id;
        _row.araging_custtype_code := _x.custtype_code;
        _row.araging_terms_descrip := _x.terms_descrip;
        _row.araging_aropen_amount := _x.aropen_amount;
        _row.araging_cur_val := _x.cur_val;
        _row.araging_thirty_val := _x.thirty_val;
        _row.araging_sixty_val := _x.sixty_val;
        _row.araging_ninety_val := _x.ninety_val;
        _row.araging_plus_val := _x.plus_val;
        _row.araging_total_val := _x.total_val;
        RETURN NEXT _row;
  END LOOP;
  RETURN;
END;
$_$;


ALTER FUNCTION public.araging(date, boolean, boolean) OWNER TO admin;

--
-- Name: arapplied(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION arapplied(integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pAropenid ALIAS FOR $1;
  pDate ALIAS FOR $2;
  _amount NUMERIC;

BEGIN

  -- Return amount applied to an aropen in base currency item as of the parameter date
  SELECT SUM(currtobase(arapply_curr_id,arapply_applied,pDate)) INTO _amount
  FROM arapply
  WHERE (((arapply_target_aropen_id = pAropenid) OR (arapply_source_aropen_id = pAropenid))
  AND (((arapply_journalnumber=0) AND (arapply_postdate <= pDate))
  OR EXISTS(SELECT * 
             FROM gltrans 
             WHERE ((gltrans_journalnumber=arapply_journalnumber)
             AND (gltrans_date <= pDate)))));

  IF (_amount IS NULL) THEN
    RETURN 0;
  ELSE
    RETURN _amount;
  END IF;

END;
$_$;


ALTER FUNCTION public.arapplied(integer, date) OWNER TO admin;

--
-- Name: archivesaleshistory(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION archivesaleshistory(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSohistid ALIAS FOR $1;

BEGIN

  INSERT INTO asohist ( asohist_id,
                        asohist_cust_id,
                        asohist_itemsite_id,
                        asohist_shipdate,
                        asohist_invcdate,
                        asohist_duedate,
                        asohist_promisedate,
                        asohist_ordernumber,
                        asohist_invcnumber,
                        asohist_qtyshipped,
                        asohist_unitprice,
                        asohist_unitcost,
                        asohist_billtoname,
                        asohist_billtoaddress1,
                        asohist_billtoaddress2,
                        asohist_billtoaddress3,
                        asohist_billtocity,
                        asohist_billtostate,
                        asohist_billtozip,
                        asohist_shiptoname,
                        asohist_shiptoaddress1,
                        asohist_shiptoaddress2,
                        asohist_shiptoaddress3,
                        asohist_shiptocity,
                        asohist_shiptostate,
                        asohist_shiptozip,
                        asohist_shipto_id,
                        asohist_shipvia,
                        asohist_salesrep_id,
                        asohist_misc_type,
                        asohist_misc_descrip,
                        asohist_misc_id,
                        asohist_commission,
                        asohist_commissionpaid,
                        asohist_doctype,
                        asohist_orderdate,
                        asohist_imported,
			asohist_ponumber,
                        asohist_curr_id,
                        asohist_taxtype_id,
                        asohist_taxzone_id )
  SELECT cohist_id,
         cohist_cust_id,
         cohist_itemsite_id,
         cohist_shipdate,
         cohist_invcdate,
         cohist_duedate,
         cohist_promisedate,
         cohist_ordernumber,
         cohist_invcnumber,
         cohist_qtyshipped,
         cohist_unitprice,
         cohist_unitcost,
         cohist_billtoname,
         cohist_billtoaddress1,
         cohist_billtoaddress2,
         cohist_billtoaddress3,
         cohist_billtocity,
         cohist_billtostate,
         cohist_billtozip,
         cohist_shiptoname,
         cohist_shiptoaddress1,
         cohist_shiptoaddress2,
         cohist_shiptoaddress3,
         cohist_shiptocity,
         cohist_shiptostate,
         cohist_shiptozip,
         cohist_shipto_id,
         cohist_shipvia,
         cohist_salesrep_id,
         cohist_misc_type,
         cohist_misc_descrip,
         cohist_misc_id,
         cohist_commission,
         cohist_commissionpaid,
         cohist_doctype,
         cohist_orderdate,
         cohist_imported,
         cohist_ponumber,
	 cohist_curr_id,
         cohist_taxtype_id,
         cohist_taxzone_id
  FROM cohist
  WHERE (cohist_id=pSohistid);

  INSERT INTO asohisttax ( taxhist_id,
                           taxhist_parent_id,
                           taxhist_taxtype_id,
                           taxhist_tax_id,
                           taxhist_basis,
                           taxhist_basis_tax_id,
                           taxhist_sequence,
                           taxhist_percent,
                           taxhist_amount,
                           taxhist_tax,
                           taxhist_docdate,
                           taxhist_distdate,
                           taxhist_curr_id,
                           taxhist_curr_rate,
                           taxhist_journalnumber )
  SELECT taxhist_id,
         taxhist_parent_id,
         taxhist_taxtype_id,
         taxhist_tax_id,
         taxhist_basis,
         taxhist_basis_tax_id,
         taxhist_sequence,
         taxhist_percent,
         taxhist_amount,
         taxhist_tax,
         taxhist_docdate,
         taxhist_distdate,
         taxhist_curr_id,
         taxhist_curr_rate,
         taxhist_journalnumber
  FROM cohisttax
  WHERE (taxhist_parent_id=pSohistid);

  DELETE FROM cohisttax
  WHERE (taxhist_parent_id=pSohistid);

  DELETE FROM cohist
  WHERE (cohist_id=pSohistid);

  RETURN pSohistid;

END;
$_$;


ALTER FUNCTION public.archivesaleshistory(integer) OWNER TO admin;

--
-- Name: arcurrgain(integer, integer, numeric, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION arcurrgain(integer, integer, numeric, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pAropenId ALIAS FOR $1;
  pCurrId ALIAS FOR $2;
  pValue ALIAS FOR $3;
  pDate ALIAS FOR $4;
  _start DATE;
  _end DATE;
  _gain NUMERIC;
  _r RECORD;

BEGIN
  IF (pAropenId IS NULL OR pValue = 0) THEN
    RETURN 0;
  END IF;

  SELECT aropen_docdate, aropen_curr_id, aropen_curr_rate
    INTO _r
  FROM aropen
  WHERE (aropen_id=pAropenId);

  IF (_r.aropen_docdate > pDate) THEN
    _gain := (currToBase(pCurrId, pValue, pDate) - currToCurr(pCurrId,_r.aropen_curr_id, pValue, pDate) / _r.aropen_curr_rate) * -1;
  ELSE
    _gain := currToCurr(pCurrId,_r.aropen_curr_id, pValue, pDate) / _r.aropen_curr_rate - currToBase(pCurrId, pValue, pDate);
  END IF;

  IF (_gain IS NULL) THEN
    RAISE EXCEPTION 'Error processing currency gain/loss.';
  END IF;

  RETURN _gain;
END;
$_$;


ALTER FUNCTION public.arcurrgain(integer, integer, numeric, date) OWNER TO admin;

--
-- Name: armor(bytea); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION armor(bytea) RETURNS text
    LANGUAGE c IMMUTABLE STRICT
    AS '$libdir/pgcrypto', 'pg_armor';


ALTER FUNCTION public.armor(bytea) OWNER TO admin;

--
-- Name: invbal; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE invbal (
    invbal_id integer NOT NULL,
    invbal_period_id integer,
    invbal_itemsite_id integer,
    invbal_qoh_beginning numeric(18,6) NOT NULL,
    invbal_qoh_ending numeric(18,6) NOT NULL,
    invbal_qty_in numeric(18,6) NOT NULL,
    invbal_qty_out numeric(18,6) NOT NULL,
    invbal_value_beginning numeric(12,2) NOT NULL,
    invbal_value_ending numeric(12,2) NOT NULL,
    invbal_value_in numeric(12,2) NOT NULL,
    invbal_value_out numeric(12,2) NOT NULL,
    invbal_nn_beginning numeric(18,6) NOT NULL,
    invbal_nn_ending numeric(18,6) NOT NULL,
    invbal_nn_in numeric(18,6) NOT NULL,
    invbal_nn_out numeric(18,6) NOT NULL,
    invbal_nnval_beginning numeric(12,2) NOT NULL,
    invbal_nnval_ending numeric(12,2) NOT NULL,
    invbal_nnval_in numeric(12,2) NOT NULL,
    invbal_nnval_out numeric(12,2) NOT NULL,
    invbal_dirty boolean DEFAULT true NOT NULL
);


ALTER TABLE public.invbal OWNER TO admin;

--
-- Name: asofinvbal(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION asofinvbal(integer, date) RETURNS SETOF invbal
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteId ALIAS FOR $1;
  pAsofDate ALIAS FOR $2;
  _result invbal%ROWTYPE;
  _i RECORD;
  _h RECORD;
  _r RECORD;
  _prevCostmethod TEXT := 'A';
  _prevDate TIMESTAMP WITH TIME ZONE;
  _runningQty NUMERIC := 0;
  _runningNn NUMERIC := 0;
  _runningValue NUMERIC := 0;
  _runningNnval NUMERIC := 0;

BEGIN
  /* This is a base function to gather data.  Because it is STABLE it should only need
  to be calculated once, even though it is likely to be called several times by other
  functions in parent query to present the various data.
  */
  
  -- First make sure inventory balance is forward updated
  PERFORM forwardUpdateItemsite(pItemsiteId);

  -- Next find the previous period balace to use as a starting point
  SELECT invbal.*, period_start, itemsite_costmethod INTO _i
  FROM invbal 
    JOIN itemsite ON (invbal_itemsite_id=itemsite_id) 
    JOIN period ON (invbal_period_id=period_id)
  WHERE ((invbal_itemsite_id=pItemsiteId)
    AND  (pAsofDate >= period_start))
  ORDER BY period_start DESC
  LIMIT 1;

  _runningQty := _i.invbal_qoh_beginning;
  _runningNn := _i.invbal_nn_beginning;
  _runningValue := _i.invbal_value_beginning;
  _runningNnval := _i.invbal_nnval_beginning;
  _prevDate := _i.period_start;
  _prevCostmethod := _i.itemsite_costmethod;

  FOR _r IN 
    SELECT invhist_id, invhist_created, invhist_invqty, invhist_transtype, invhist_unitcost,
      invhist_costmethod, itemsite_item_id, invhistSense(invhist_id) AS sense
    FROM invhist
      JOIN itemsite ON (itemsite_id=invhist_itemsite_id)
    WHERE ((invhist_itemsite_id=pItemsiteId)
    AND (invhist_transdate::date BETWEEN _i.period_start AND pAsofdate))
    ORDER BY invhist_created, invhist_id
  LOOP
    -- Update balances changed by any standard cost update between transactions
    IF (_prevCostmethod = 'S' AND _runningQty != 0) THEN
      FOR _h IN
        SELECT costhist_oldcost, costhist_newcost
        FROM costhist
          JOIN item ON (costhist_item_id=item_id)
          JOIN itemsite ON (itemsite_item_id=item_id)
        WHERE ((itemsite_id=pItemsiteId)
          AND (costhist_date BETWEEN _prevDate AND _r.invhist_created)
          AND (costhist_type IN ('S','D')))
      LOOP
        _runningValue := _runningValue + round((_h.costhist_newcost-_h.costhist_oldcost) * _runningQty,2);
        _runningNnval := _runningNnval + round((_h.costhist_newcost-_h.costhist_oldcost) * _runningNn,2);
      END LOOP;
    END IF;

    _prevDate := _r.invhist_created;
    _prevCostmethod := _r.invhist_costmethod;
    _runningQty := _runningQty + _r.invhist_invqty * _r.sense;
    _runningValue := _runningValue + round( _r.invhist_invqty * _r.sense * _r.invhist_unitcost,2);
    IF (_r.invhist_transtype = 'NN') THEN
      _runningNn := _runningNn + _r.invhist_invqty * -1;
      _runningNnval := _runningNnval + round( _r.invhist_invqty * -1 * _r.invhist_unitcost,2);
    END IF;
    
  END LOOP;

  _prevDate := COALESCE(_prevDate, _i.period_start);
  _prevCostmethod := COALESCE(_r.invhist_costmethod, _i.itemsite_costmethod);
  
  IF (_prevCostmethod = 'S' AND _runningQty != 0) THEN
    FOR _h IN
      SELECT costhist_oldcost, costhist_newcost
      FROM costhist
        JOIN item ON (costhist_item_id=item_id)
        JOIN itemsite ON (itemsite_item_id=item_id)
      WHERE ((itemsite_id=pItemsiteId)
        AND (costhist_date BETWEEN _prevDate AND CAST(pAsofDate + 1 AS TIMESTAMP WITH TIME ZONE))
        AND (costhist_type IN ('S','D')))
    LOOP
      _runningValue := _runningValue + round((_h.costhist_newcost-_h.costhist_oldcost) * _runningQty,2);
      _runningNnval := _runningNnval + round((_h.costhist_newcost-_h.costhist_oldcost) * _runningNn,2);
    END LOOP;
  END IF;

  _result := _i;
  _result.invbal_qoh_ending := _runningQty;
  _result.invbal_value_ending := _runningValue;
  _result.invbal_nn_ending := _runningNn;
  _result.invbal_nnval_ending := _runningNnval;

  RETURN NEXT _result;

  RETURN;
  
END;
$_$;


ALTER FUNCTION public.asofinvbal(integer, date) OWNER TO admin;

--
-- Name: asofinvnn(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION asofinvnn(integer, date) RETURNS numeric
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteId ALIAS FOR $1;
  pAsofDate ALIAS FOR $2;
  _result NUMERIC;

BEGIN

  SELECT invbal_nn_ending INTO _result
  FROM asofinvbal(pItemsiteId, pAsofDate);

  RETURN COALESCE(_result, 0);
  
END;
$_$;


ALTER FUNCTION public.asofinvnn(integer, date) OWNER TO admin;

--
-- Name: asofinvqty(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION asofinvqty(integer, date) RETURNS numeric
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteId ALIAS FOR $1;
  pAsofDate ALIAS FOR $2;
  _result NUMERIC;

BEGIN

  SELECT invbal_qoh_ending INTO _result
  FROM asofinvbal(pItemsiteId, pAsofDate);

  RETURN COALESCE(_result, 0);
  
END;
$_$;


ALTER FUNCTION public.asofinvqty(integer, date) OWNER TO admin;

--
-- Name: attachcontact(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION attachcontact(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pcntctId    ALIAS FOR $1;
  pcrmacctId  ALIAS FOR $2;
BEGIN
  UPDATE cntct SET cntct_crmacct_id = pcrmacctId
  WHERE cntct_id = pcntctId;

  RETURN 0;
END;
$_$;


ALTER FUNCTION public.attachcontact(integer, integer) OWNER TO admin;

--
-- Name: attachquotetoopportunity(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION attachquotetoopportunity(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pQuheadid	ALIAS FOR $1;
  pOpheadid	ALIAS FOR $2;
BEGIN

-- Check Quote
  IF (NOT EXISTS(SELECT quhead_id
                 FROM quhead
                 WHERE (quhead_id=pQuheadid))) THEN
    RETURN -1;
  END IF;

-- Check Opportunity
  IF (NOT EXISTS(SELECT ophead_id
                 FROM ophead
                 WHERE (ophead_id=pOpheadid))) THEN
    RETURN -2;
  END IF;

-- Cannot attach if already attached
  IF (EXISTS(SELECT quhead_id
	     FROM quhead
	     WHERE ((quhead_id=pQuheadid)
	       AND  (quhead_ophead_id IS NOT NULL)))) THEN
    RETURN -3;
  END IF;

  UPDATE quhead SET quhead_ophead_id=pOpheadid
  WHERE (quhead_id=pQuheadid);

  RETURN 0;

END;
$_$;


ALTER FUNCTION public.attachquotetoopportunity(integer, integer) OWNER TO admin;

--
-- Name: attachsalesordertoopportunity(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION attachsalesordertoopportunity(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSoheadid	ALIAS FOR $1;
  pOpheadid	ALIAS FOR $2;
BEGIN

-- Check Sales Order
  IF (NOT EXISTS(SELECT cohead_id
                 FROM cohead
                 WHERE (cohead_id=pSoheadid))) THEN
    RETURN -1;
  END IF;

-- Check Opportunity
  IF (NOT EXISTS(SELECT ophead_id
                 FROM ophead
                 WHERE (ophead_id=pOpheadid))) THEN
    RETURN -2;
  END IF;

-- Cannot attach if already attached
  IF (EXISTS(SELECT cohead_id
	     FROM cohead
	     WHERE ((cohead_id=pSoheadid)
	       AND  (cohead_ophead_id IS NOT NULL)))) THEN
    RETURN -3;
  END IF;

  UPDATE cohead SET cohead_ophead_id=pOpheadid
  WHERE (cohead_id=pSoheadid);

  RETURN 0;

END;
$_$;


ALTER FUNCTION public.attachsalesordertoopportunity(integer, integer) OWNER TO admin;

--
-- Name: averagesalesprice(integer, date, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION averagesalesprice(integer, date, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid ALIAS FOR $1;
  pStartDate ALIAS FOR $2;
  pEndDate ALIAS FOR $3;
  _p RECORD;

BEGIN
-- Returns value in base currency
-- ToDo: is cohist_shipdate the right DATE to use?
  SELECT SUM(cohist_qtyshipped * currToBase(cohist_curr_id, cohist_unitprice,
                                            cohist_shipdate)) AS totalsales,
         SUM(cohist_qtyshipped) AS totalship INTO _p
  FROM cohist
  WHERE ( (cohist_itemsite_id=pItemsiteid)
   AND (cohist_invcdate BETWEEN pStartDate AND pEndDate) );

  IF ( (_p.totalship IS NULL) OR
       (_p.totalship = 0) ) THEN
    RETURN 0;
  ELSE
    RETURN (_p.totalsales / _p.totalship);
  END IF;

END;
$_$;


ALTER FUNCTION public.averagesalesprice(integer, date, date) OWNER TO admin;

--
-- Name: avgcost(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION avgcost(pitemsiteid integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _value NUMERIC;
  _qoh NUMERIC;
  _qohnn NUMERIC;
BEGIN
  SELECT itemsite_value, itemsite_qtyonhand, itemsite_nnqoh
    INTO _value, _qoh, _qohnn
    FROM itemsite
   WHERE(itemsite_id=pItemsiteid);
  IF (_qoh = 0.0 AND _qohnn = 0.0) THEN
    RETURN 0.0;
  END IF;
  RETURN _value / (_qoh + _qohnn);
END;
$$;


ALTER FUNCTION public.avgcost(pitemsiteid integer) OWNER TO admin;

--
-- Name: balanceitemsite(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION balanceitemsite(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid ALIAS FOR $1;
  _itemlocseries INTEGER;
  _balanced NUMERIC;
  _qoh NUMERIC;
  _nnQoh NUMERIC;

BEGIN

--  Make sure that that passed Itemsite is MLC or Lot/Serial controlled
  IF ( ( SELECT (NOT ( (itemsite_loccntrl) OR (itemsite_controlmethod IN ('L', 'S')) ))
         FROM itemsite
         WHERE (itemsite_id=pItemsiteid) ) ) THEN
    RETURN 0;
  END IF;

  IF ( ( SELECT itemsite_freeze
           FROM itemsite
          WHERE(itemsite_id=pItemsiteid) ) ) THEN
    RETURN -1;
  END IF;

--  Calculate the Netable portion
  SELECT COALESCE(SUM(itemloc_qty), 0) INTO _balanced
  FROM itemloc LEFT OUTER JOIN location ON (itemloc_location_id=location_id)
  WHERE ( ( (location_id IS NULL) OR (location_netable) )
   AND (itemloc_itemsite_id=pItemsiteid) );

--  Post an AD Transaction for the Netable portion
  SELECT invAdjustment( itemsite_id, (_balanced - itemsite_qtyonhand),
                        'Balance', 'Inventory Balance' ) INTO _itemlocseries
  FROM itemsite
  WHERE (itemsite_id=pItemsiteid);

--  Post the invtrans records associated with the itemlocdist records
  PERFORM postInvhist(itemlocdist_invhist_id)
     FROM itemlocdist
    WHERE(itemlocdist_series=_itemlocseries);

--  Kill the resultant distribution records
  DELETE FROM itemlocdist
  WHERE (itemlocdist_series=_itemlocseries);

--  Calculate and write the Non-Netable portion directly
  SELECT COALESCE(SUM(itemloc_qty), 0) INTO _nnQoh
  FROM itemloc, location
  WHERE ( (itemloc_location_id=location_id)
   AND (NOT location_netable)
   AND (itemloc_itemsite_id=pItemsiteid) );

  UPDATE itemsite
  SET itemsite_nnqoh = _nnQoh
  WHERE (itemsite_id=pItemsiteid);

  RETURN 1;

END;
$_$;


ALTER FUNCTION public.balanceitemsite(integer) OWNER TO admin;

--
-- Name: bomcontains(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION bomcontains(integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pparentitemid	ALIAS FOR $1;
  pchilditemid	ALIAS FOR $2;
  _bomworksetid	INTEGER;
  _result	BOOLEAN;

BEGIN
  _bomworksetid := indentedWhereUsed(pchilditemid);
  _result := EXISTS(SELECT bomwork_id
		    FROM bomwork
		    WHERE ((bomwork_set_id=_bomworksetid)
		      AND  (bomwork_item_id=pparentitemid) ));

  PERFORM deleteBOMWorkset(_bomworksetid);

  RETURN _result;
END;
$_$;


ALTER FUNCTION public.bomcontains(integer, integer) OWNER TO admin;

--
-- Name: bomhistsequence(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION bomhistsequence(integer) RETURNS text
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pHistid ALIAS FOR $1;
  _wid INTEGER;
  _seqnum TEXT;
  _bomhist RECORD;

BEGIN
  _wid := pHistid;

  SELECT bomhist_parent_id AS parent,
         to_char(bomhist_seqnumber, '00009') AS seq INTO _bomhist
    FROM bomhist
   WHERE bomhist_seq_id=_wid;

  IF (FOUND) THEN
    _seqnum := _bomhist.seq;
    _wid := _bomhist.parent;

    WHILE (_wid != -1) LOOP
      SELECT bomhist_parent_id AS parent,
             to_char(bomhist_seqnumber, '00009') AS seq INTO _bomhist
      FROM bomhist
      WHERE bomhist_seq_id=_wid;

      IF (FOUND) THEN
        _seqnum := _bomhist.seq || '-' || _seqnum;
        _wid    := _bomhist.parent;
      ELSE
        _wid := -1;
      END IF;
    END LOOP;
  ELSE
    _seqnum := ''::TEXT;
  END IF;

  RETURN _seqnum;
END;
$_$;


ALTER FUNCTION public.bomhistsequence(integer) OWNER TO admin;

--
-- Name: bomitem; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE bomitem (
    bomitem_id integer DEFAULT nextval(('bomitem_bomitem_id_seq'::text)::regclass) NOT NULL,
    bomitem_parent_item_id integer NOT NULL,
    bomitem_seqnumber integer,
    bomitem_item_id integer NOT NULL,
    bomitem_qtyper numeric(20,8) NOT NULL,
    bomitem_scrap numeric(8,4) NOT NULL,
    bomitem_status character(1),
    bomitem_effective date NOT NULL,
    bomitem_expires date NOT NULL,
    bomitem_createwo boolean NOT NULL,
    bomitem_issuemethod character(1) NOT NULL,
    bomitem_schedatwooper boolean NOT NULL,
    bomitem_ecn text,
    bomitem_moddate date,
    bomitem_subtype character(1) NOT NULL,
    bomitem_uom_id integer NOT NULL,
    bomitem_rev_id integer DEFAULT (-1),
    bomitem_booitem_seq_id integer DEFAULT (-1),
    bomitem_char_id integer,
    bomitem_value text,
    bomitem_notes text,
    bomitem_ref text,
    bomitem_qtyfxd numeric(20,8) DEFAULT 0 NOT NULL,
    bomitem_issuewo boolean DEFAULT false NOT NULL,
    CONSTRAINT bomitem_bomitem_issuemethod_check CHECK ((((bomitem_issuemethod = 'M'::bpchar) OR (bomitem_issuemethod = 'S'::bpchar)) OR (bomitem_issuemethod = 'L'::bpchar))),
    CONSTRAINT bomitem_bomitem_subtype_check CHECK ((((bomitem_subtype = 'N'::bpchar) OR (bomitem_subtype = 'I'::bpchar)) OR (bomitem_subtype = 'B'::bpchar)))
);


ALTER TABLE public.bomitem OWNER TO admin;

--
-- Name: TABLE bomitem; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE bomitem IS 'Bill of Materials (BOM) component Items information';


--
-- Name: COLUMN bomitem.bomitem_qtyfxd; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON COLUMN bomitem.bomitem_qtyfxd IS 'The fixed quantity required';


--
-- Name: bomitem(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION bomitem(integer) RETURNS SETOF bomitem
    LANGUAGE sql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
  SELECT * FROM bomitem WHERE ((bomitem_parent_item_id=$1) AND (bomitem_rev_id=getActiveRevId('BOM',$1)));
$_$;


ALTER FUNCTION public.bomitem(integer) OWNER TO admin;

--
-- Name: bomitem(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION bomitem(integer, integer) RETURNS SETOF bomitem
    LANGUAGE sql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
  SELECT * FROM bomitem WHERE ((bomitem_parent_item_id=$1) AND (bomitem_rev_id=$2));
$_$;


ALTER FUNCTION public.bomitem(integer, integer) OWNER TO admin;

--
-- Name: bomlevelbyitem(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION bomlevelbyitem(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemid ALIAS FOR $1;
  _cnt INTEGER;
  _result INTEGER;
  _bomitem RECORD;

BEGIN
  _cnt := 0;

  BEGIN
  FOR _bomitem IN SELECT bomitem_parent_item_id
                    FROM bomitem
                   WHERE ((bomitem_item_id=pItemid)
                     AND  (bomitem_rev_id=getActiveRevId('BOM',bomitem_parent_item_id))
                     AND  (CURRENT_DATE BETWEEN bomitem_effective AND (bomitem_expires - 1)))
  LOOP
    SELECT bomLevelByItem(_bomitem.bomitem_parent_item_id) + 1 INTO _result;
    IF (_result > _cnt) THEN
      _cnt := _result;
    END IF;
  END LOOP;
  EXCEPTION WHEN statement_too_complex THEN
      RAISE EXCEPTION 'potential recursive BOM found for item_id %', pItemid;
  END;

  return _cnt;
END;
$_$;


ALTER FUNCTION public.bomlevelbyitem(integer) OWNER TO admin;

--
-- Name: bomlevelbyitem(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION bomlevelbyitem(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemid ALIAS FOR $1;
  pBomrevid ALIAS FOR $2;
  _cnt INTEGER;
  _result INTEGER;
  _bomitem RECORD;

BEGIN
  _cnt := 0;

  BEGIN
  FOR _bomitem IN SELECT bomitem_parent_item_id
                    FROM bomitem
                   WHERE ((bomitem_item_id=pItemid)
                     AND  (bomitem_rev_id=pBomrevid)
                     AND  (CURRENT_DATE BETWEEN bomitem_effective AND (bomitem_expires - 1)))
  LOOP
    SELECT bomLevelByItem(_bomitem.bomitem_parent_item_id, pBomrevid) + 1 INTO _result;
    IF (_result > _cnt) THEN
      _cnt := _result;
    END IF;
  END LOOP;
  EXCEPTION WHEN statement_too_complex THEN
      RAISE EXCEPTION 'potential recursive BOM found for item_id %', pItemid;
  END;

  return _cnt;
END;
$_$;


ALTER FUNCTION public.bomlevelbyitem(integer, integer) OWNER TO admin;

--
-- Name: bomworkeffective(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION bomworkeffective(integer, date) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
    workid ALIAS FOR $1;
    effdate ALIAS FOR $2;
    _wid INTEGER;
    _bomwork RECORD;
BEGIN
    _wid := workid;
    WHILE (_wid != -1) LOOP
        SELECT bomwork_parent_id AS parent,
               bomwork_effective AS effective
          INTO _bomwork
          FROM bomwork
         WHERE bomwork_id=_wid;

         IF (FOUND) THEN
             _wid := _bomwork.parent;
             IF (_bomwork.effective > effdate) THEN
                 RETURN FALSE;
             END IF;
         ELSE
             _wid := -1;
         END IF;
    END LOOP;
    RETURN TRUE;
END;
$_$;


ALTER FUNCTION public.bomworkeffective(integer, date) OWNER TO admin;

--
-- Name: bomworkexpired(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION bomworkexpired(integer, date) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
    workid ALIAS FOR $1;
    expdate ALIAS FOR $2;
    _wid INTEGER;
    _bomwork RECORD;
BEGIN
    _wid := workid;
    WHILE (_wid != -1) LOOP
        SELECT bomwork_parent_id AS parent,
               bomwork_expires AS expires
          INTO _bomwork
          FROM bomwork
         WHERE bomwork_id=_wid;

         IF (FOUND) THEN
             _wid := _bomwork.parent;
             IF (_bomwork.expires <= expdate) THEN
                 RETURN TRUE;
             END IF;
         ELSE
             _wid := -1;
         END IF;
    END LOOP;
    RETURN FALSE;
END;
$_$;


ALTER FUNCTION public.bomworkexpired(integer, date) OWNER TO admin;

--
-- Name: bomworkitemsequence(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION bomworkitemsequence(integer) RETURNS text
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWorkid ALIAS FOR $1;
  _wid INTEGER;
  _seqnum TEXT;
  _bomwork RECORD;

BEGIN
  _wid := pWorkid;

  SELECT bomwork_parent_id AS parent,
         item_number AS seq INTO _bomwork
    FROM bomwork, item
   WHERE ((bomwork_id=_wid)
   AND (bomwork_item_id=item_id));

  IF (FOUND) THEN
    _seqnum := _bomwork.seq;
    _wid := _bomwork.parent;

    WHILE (_wid != -1) LOOP
      SELECT bomwork_parent_id AS parent,
             item_number AS seq INTO _bomwork
      FROM bomwork, item
      WHERE ((bomwork_id=_wid)
      AND (bomwork_item_id=item_id));

      IF (FOUND) THEN
        _seqnum := _bomwork.seq || '-' || _seqnum;
        _wid    := _bomwork.parent;
      ELSE
        _wid := -1;
      END IF;
    END LOOP;
  ELSE
    _seqnum := ''::TEXT;
  END IF;

  RETURN _seqnum;
END;
$_$;


ALTER FUNCTION public.bomworkitemsequence(integer) OWNER TO admin;

--
-- Name: bomworksequence(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION bomworksequence(integer) RETURNS text
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWorkid ALIAS FOR $1;
  _wid INTEGER;
  _seqnum TEXT;
  _bomwork RECORD;

BEGIN
  _wid := pWorkid;

  SELECT bomwork_parent_id AS parent,
         to_char(bomwork_seqnumber, '00009') AS seq INTO _bomwork
    FROM bomwork
   WHERE bomwork_id=_wid;

  IF (FOUND) THEN
    _seqnum := _bomwork.seq;
    _wid := _bomwork.parent;

    WHILE (_wid != -1) LOOP
      SELECT bomwork_parent_id AS parent,
             to_char(bomwork_seqnumber, '00009') AS seq INTO _bomwork
      FROM bomwork
      WHERE bomwork_id=_wid;

      IF (FOUND) THEN
        _seqnum := _bomwork.seq || '-' || _seqnum;
        _wid    := _bomwork.parent;
      ELSE
        _wid := -1;
      END IF;
    END LOOP;
  ELSE
    _seqnum := ''::TEXT;
  END IF;

  RETURN _seqnum;
END;
$_$;


ALTER FUNCTION public.bomworksequence(integer) OWNER TO admin;

--
-- Name: buildinvbal(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION buildinvbal(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteId ALIAS FOR $1;
  _r RECORD;
  _prevCostmethod TEXT := 'A';
  _prevDate TIMESTAMP WITH TIME ZONE;
  _runningQty NUMERIC := 0;
  _runningNn NUMERIC := 0;

BEGIN
  -- Validate
  IF (SELECT (count(invhist_id) > 0)
      FROM invhist
      WHERE ((invhist_itemsite_id=pItemsiteId)
      AND (NOT invhist_posted))) THEN

    SELECT item_number, warehous_code INTO _r
    FROM itemsite
      JOIN item ON (item_id=itemsite_item_id)
      JOIN whsinfo ON (itemsite_warehous_id=warehous_id)
    WHERE (itemsite_id=pItemsiteId);
    
    RAISE EXCEPTION 'Unposted inventory transactions exist for % at % [xtuple: buildInvBal, -1, %, %]',
                    _r.item_number, _r.warehous_code,
                    _r.item_number, _r.warehous_code;
  END IF;

  -- Remove any old records
  DELETE FROM invbal WHERE invbal_itemsite_id=pItemsiteId;

  FOR _r IN 
    SELECT invhist.*,
      itemsite_item_id, invhistSense(invhist_id) AS sense,
      item_number, warehous_code
    FROM invhist
      JOIN itemsite ON (itemsite_id=invhist_itemsite_id)
      JOIN item ON (itemsite_item_id=item_id)
      JOIN whsinfo ON (itemsite_warehous_id=warehous_id)
    WHERE (invhist_itemsite_id=pItemsiteId)
    ORDER BY invhist_created, invhist_id
  LOOP
    RAISE NOTICE 'Calculating balances for Item % at Site % against transaction %, transtype %, sense %, qty %, %', _r.item_number, _r.warehous_code, _r.invhist_id, _r.invhist_transtype, _r.sense, _r.invhist_invqty, _r.invhist_comments;
    -- Update balances changed by any standard cost update between transactions
    IF (_prevCostmethod = 'S' AND _runningQty != 0) THEN
      PERFORM postValueintoInvBalance(pItemsiteid, costhist_date::date, _runningQty, _runningNn, costhist_oldcost, costhist_newcost )
      FROM costhist
      WHERE ((costhist_item_id=_r.itemsite_item_id)
        AND (costhist_date BETWEEN _prevDate AND _r.invhist_created)
        AND (costhist_type IN ('S','D')));
    END IF;

    -- Post transaction into inventory balance table
    PERFORM postIntoInvBalance(_r.invhist_id);

    _prevDate := _r.invhist_created;
    _prevCostmethod := _r.invhist_costmethod;
    _runningQty := _runningQty + _r.invhist_invqty * _r.sense;
    IF (_r.invhist_transtype = 'NN') THEN
      _runningNn := _runningNn + _r.invhist_invqty * -1;
    END IF;
    
  END LOOP;

  -- Update balances changed by any standard cost since last transaction
  IF (_prevCostmethod = 'S' AND _runningQty != 0) THEN
    PERFORM postValueintoInvBalance(pItemsiteid, costhist_date::date, _runningQty, _runningNn, costhist_oldcost, costhist_newcost )
    FROM costhist
    WHERE ((costhist_item_id=_r.itemsite_item_id)
      AND (costhist_date > _prevDate)
      AND (costhist_type IN ('S','D')));
  END IF;

  -- Forward update changes through all the balances
  PERFORM forwardupdateitemsite(pItemsiteId);
  
  RETURN 1;
END;
$_$;


ALTER FUNCTION public.buildinvbal(integer) OWNER TO admin;

--
-- Name: buildsearchpath(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION buildsearchpath() RETURNS text
    LANGUAGE plpgsql
    AS $_$
DECLARE
  _path   TEXT    := '';
  _schema TEXT;
  _seq    INTEGER;
BEGIN
  -- get the schemas as ordered by the administrator
  SELECT concatagg(quote_ident(schemaord_name) || ',') INTO _path
    FROM (SELECT schemaord_name
            FROM schemaord
            LEFT OUTER JOIN pkghead ON (schemaord_name=pkghead_name)
           WHERE (pkghead_id IS NULL
               OR (pkghead_id IS NOT NULL AND packageisenabled(pkghead_id)))
           ORDER BY schemaord_order
         ) AS xtspq;

  -- add others that we think/know we need
  -- TODO: is there a reason not to include public, api, or packages?
  FOR _schema, _seq IN
      SELECT pkghead_name AS schema, 0 AS seq
        FROM pkghead
       WHERE packageisenabled(pkghead_id)
      UNION ALL
      SELECT 'public', 1
      UNION ALL
      SELECT 'api', 2
      ORDER BY seq, schema
  LOOP
    IF (_path !~* (E'(^|\\W)' || _schema || E'(\\W|$)')) THEN
      _path := _path || ',' || quote_ident(_schema);
    END IF;
  END LOOP;

  -- remove extraneous spaces and commas
  _path = BTRIM(REGEXP_REPLACE(_path, '( ?, ?)+', ',', 'g'),
                ', ');

  RAISE DEBUG 'buildSearchPath() returning %', _path;

  RETURN _path;
END;
$_$;


ALTER FUNCTION public.buildsearchpath() OWNER TO admin;

--
-- Name: FUNCTION buildsearchpath(); Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON FUNCTION buildsearchpath() IS 'buildSearchPath() examines the schemaord and pkghead tables to build a search
path string. It ensures that public, api, and all enabled packages are included
even if they are not listed in the schemaord table.
It returns the constructed search_path but does not set it.';


--
-- Name: calccashbudget(integer, integer, character); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calccashbudget(integer, integer, character) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pAccntId ALIAS FOR $1;
  pPeriodId ALIAS FOR $2;
  pInterval ALIAS FOR $3;
  _accntType CHAR;
  _currentBudget NUMERIC;
  _priorBudget NUMERIC;
  _result NUMERIC;
BEGIN

        SELECT accnt_type INTO _accntType
        FROM accnt
        WHERE (accnt_id=pAccntId);

        SELECT COALESCE(SUM(budget_amount),0) INTO _currentBudget
        FROM budget
        WHERE ((budget_accnt_id=pAccntId)
        AND (budget_period_id=pPeriodId));

        IF (pInterval='M') THEN
        SELECT (COALESCE(SUM(budget_amount),0)) INTO _priorBudget
                FROM budget,
                (SELECT COALESCE(pp.period_id,-1) AS prior_period_id
                        FROM period cp, period pp
                        WHERE ((cp.period_id=pPeriodId)
                        AND (cp.period_start > pp.period_start))
                        ORDER BY pp.period_start DESC LIMIT 1) AS data
                WHERE ((budget_accnt_id=pAccntId)
                AND (budget_period_id=prior_period_id));

                ELSE IF (pInterval='Q') THEN
                        SELECT (COALESCE(SUM(budget_amount),0)) INTO _priorBudget
                        FROM budget,
                                (SELECT COALESCE(pp.period_id,-1) AS prior_period_id
                                FROM period cp, period pp
                                WHERE ((cp.period_id=pPeriodId)
                                AND (cp.period_start > pp.period_start)
                                AND (pp.period_quarter=
                                CASE WHEN cp.period_quarter > 1 THEN
                                        cp.period_quarter - 1
                                ELSE 4 END)
                                AND (pp.period_start >= cp.period_start - interval '1 year'))
                                ORDER BY pp.period_start DESC LIMIT 1) AS data
                        WHERE ((budget_accnt_id=pAccntId)
                        AND (budget_period_id=prior_period_id));


                ELSE
                        SELECT (COALESCE(SUM(budget_amount),0)) INTO _priorBudget
                        FROM budget,
                                (SELECT pp.period_id AS prior_period_id
                        FROM period cp, period pp, yearperiod cy, yearperiod py
                        WHERE ((cp.period_id=pPeriodId)
                        AND (cp.period_yearperiod_id=cy.yearperiod_id)
                        AND (pp.period_yearperiod_id=py.yearperiod_id)
                        AND (cy.yearperiod_start > py.yearperiod_start))
                        ORDER BY pp.period_start DESC LIMIT 1) AS data
                        WHERE ((budget_accnt_id=pAccntId)
                        AND (budget_period_id=prior_period_id));

                END IF;
        END IF;

        IF _accntType='A' THEN
                _result := ((_priorBudget-_currentBudget) * -1 );

        ELSE IF (_accntType IN ('L','Q')) THEN
                _result := ((_priorBudget-_currentBudget) *-1);

        ELSE RETURN -1;
        END IF;
  END IF;


  RETURN _result;


END;
$_$;


ALTER FUNCTION public.calccashbudget(integer, integer, character) OWNER TO admin;

--
-- Name: calccmheadamt(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calccmheadamt(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCmheadid ALIAS FOR $1;
  _amount NUMERIC := 0;

BEGIN

  SELECT SUM(COALESCE(extprice, 0)) INTO _amount
  FROM cmhead JOIN creditmemoitem ON (cmhead_id=cmitem_cmhead_id)
  WHERE (cmhead_id=pCmheadid);

  RETURN _amount;

END;
$_$;


ALTER FUNCTION public.calccmheadamt(integer) OWNER TO admin;

--
-- Name: calccmheadtax(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calccmheadtax(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCmheadid ALIAS FOR $1;
  _headamount NUMERIC := 0;
  _itemamount NUMERIC := 0;
  _amount NUMERIC := 0;

BEGIN

  SELECT COALESCE(SUM(taxhist_tax), 0) INTO _headamount
  FROM cmhead JOIN cmheadtax ON (taxhist_parent_id=cmhead_id)
  WHERE (cmhead_id=pCmheadid);

  SELECT SUM(COALESCE(tax, 0)) INTO _itemamount
  FROM cmhead JOIN creditmemoitem ON (cmhead_id=cmitem_cmhead_id)
  WHERE (cmhead_id=pCmheadid);

  _amount := _headamount + _itemamount;
  RETURN (_amount * -1.0);

END;
$_$;


ALTER FUNCTION public.calccmheadtax(integer) OWNER TO admin;

--
-- Name: calccobillamt(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calccobillamt(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCobillid ALIAS FOR $1;
  _amount NUMERIC := 0;

BEGIN

  SELECT COALESCE(round((cobill_qty * coitem_qty_invuomratio) *
                        (coitem_price / coitem_price_invuomratio), 2), 0) INTO _amount
  FROM cobill JOIN coitem ON (coitem_id=cobill_coitem_id)
  WHERE (cobill_id=pCobillid);

  RETURN _amount;

END;
$_$;


ALTER FUNCTION public.calccobillamt(integer) OWNER TO admin;

--
-- Name: calccobilltax(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calccobilltax(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCobillid ALIAS FOR $1;
  _amount NUMERIC := 0;

BEGIN

  SELECT COALESCE(calculateTax(cobmisc_taxzone_id,
                               cobill_taxtype_id,
                               cobmisc_shipdate,
                               cobmisc_curr_id,
                               calcCobillAmt(cobill_id)), 0) INTO _amount
  FROM cobill JOIN coitem ON (coitem_id=cobill_coitem_id)
              JOIN cobmisc ON (cobmisc_id=cobill_cobmisc_id)
  WHERE (cobill_id=pCobillid);

  RETURN _amount;

END;
$_$;


ALTER FUNCTION public.calccobilltax(integer) OWNER TO admin;

--
-- Name: calccobmiscamt(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calccobmiscamt(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCobmiscid ALIAS FOR $1;
  _amount NUMERIC := 0;

BEGIN

  SELECT SUM(COALESCE(calcCobillAmt(cobill_id), 0)) INTO _amount
  FROM cobmisc JOIN cobill ON (cobmisc_id=cobill_cobmisc_id)
  WHERE (cobmisc_id=pCobmiscid);

  RETURN _amount;

END;
$_$;


ALTER FUNCTION public.calccobmiscamt(integer) OWNER TO admin;

--
-- Name: calccobmisctax(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calccobmisctax(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCobmiscid ALIAS FOR $1;
  _amount NUMERIC := 0;

BEGIN

  SELECT SUM(
         COALESCE(calculateTax(cobmisc_taxzone_id,
                               cobill_taxtype_id,
                               cobmisc_shipdate,
                               cobmisc_curr_id,
                               COALESCE(round((cobill_qty * coitem_qty_invuomratio) * (coitem_price / coitem_price_invuomratio), 2), 0))
                 , 0)
            ) INTO _amount
  FROM cobmisc JOIN cobill ON (cobmisc_id=cobill_cobmisc_id)
               JOIN coitem ON (coitem_id=cobill_coitem_id)
  WHERE (cobmisc_id=pCobmiscid);

  RETURN _amount;

END;
$_$;


ALTER FUNCTION public.calccobmisctax(integer) OWNER TO admin;

--
-- Name: calcpendingarapplications(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calcpendingarapplications(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  paropenid     ALIAS FOR $1;
  _arcreditsum  NUMERIC;
  _aropencurrid INTEGER;
  _cashrcptsum  NUMERIC;
  _sense INTEGER;

BEGIN
  SELECT aropen_curr_id,
    (CASE WHEN aropen_doctype IN ('I','D') THEN 1 ELSE -1 END) 
    INTO _aropencurrid, _sense
  FROM aropen
  WHERE (aropen_id=paropenid);

  SELECT SUM(currToCurr(cashrcpt_curr_id, _aropencurrid,
                        cashrcptitem_amount + cashrcptitem_discount, coalesce(cashrcpt_applydate, cashrcpt_distdate))) * _sense INTO _cashrcptsum
  FROM cashrcptitem, cashrcpt
  WHERE ((cashrcptitem_cashrcpt_id=cashrcpt_id)
    AND  (NOT cashrcpt_posted)
    AND  (NOT cashrcpt_void)
    AND  (cashrcptitem_aropen_id=paropenid)
    );

  SELECT SUM(currToCurr(arcreditapply_curr_id, _aropencurrid,
                        arcreditapply_amount, CURRENT_DATE)) INTO _arcreditsum
  FROM arcreditapply
  WHERE ((arcreditapply_target_aropen_id=paropenid)
    );

  RETURN round(COALESCE(_cashrcptsum, 0) + COALESCE(_arcreditsum, 0),2);
END;
$_$;


ALTER FUNCTION public.calcpendingarapplications(integer) OWNER TO admin;

--
-- Name: calcquoteamt(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calcquoteamt(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pQuheadid ALIAS FOR $1;
  _subtotal NUMERIC := 0;
  _tax NUMERIC := 0;
  _freight NUMERIC := 0;
  _misc NUMERIC := 0;
  _amount NUMERIC := 0;

BEGIN

  SELECT COALESCE(SUM(ROUND((quitem_qtyord * quitem_qty_invuomratio) *
                            (quitem_price / quitem_price_invuomratio), 2)), 0) INTO _subtotal
  FROM quitem
  WHERE (quitem_quhead_id=pQuheadid);

  SELECT COALESCE(SUM(tax), 0) INTO _tax
  FROM ( SELECT ROUND(SUM(taxdetail_tax), 2) AS tax
         FROM tax JOIN calculateTaxDetailSummary('Q', pQuheadid, 'T') ON (taxdetail_tax_id=tax_id)
         GROUP BY tax_id ) AS data;

  SELECT COALESCE(quhead_freight, 0), COALESCE(quhead_misc, 0) INTO _freight, _misc
  FROM quhead
  WHERE (quhead_id=pQuheadid);

  _amount := _subtotal + _tax + _freight + _misc;

  RETURN _amount;

END;
$_$;


ALTER FUNCTION public.calcquoteamt(integer) OWNER TO admin;

--
-- Name: calcsalesorderamt(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calcsalesorderamt(pcoheadid integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  RETURN calcSalesOrderAmt(pCoheadid, 'T');

END;
$$;


ALTER FUNCTION public.calcsalesorderamt(pcoheadid integer) OWNER TO admin;

--
-- Name: calcsalesorderamt(integer, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calcsalesorderamt(pcoheadid integer, ptype text) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _subtotal NUMERIC := 0;
  _tax NUMERIC := 0;
  _freight NUMERIC := 0;
  _misc NUMERIC := 0;
  _credit NUMERIC := 0;
  _amount NUMERIC := 0;

BEGIN

  -- pType: S = line item subtotal
  --        T = total
  --        B = balance due
  --        C = allocated credits
  --        X = tax

  SELECT COALESCE(SUM(ROUND((coitem_qtyord * coitem_qty_invuomratio) *
                            (coitem_price / coitem_price_invuomratio), 2)), 0) INTO _subtotal
  FROM coitem
  WHERE (coitem_cohead_id=pCoheadid)
    AND (coitem_status != 'X');

  SELECT COALESCE(SUM(tax), 0) INTO _tax
  FROM ( SELECT ROUND(SUM(taxdetail_tax), 2) AS tax
         FROM tax JOIN calculateTaxDetailSummary('S', pCoheadid, 'T') ON (taxdetail_tax_id=tax_id)
         GROUP BY tax_id ) AS data;

  SELECT COALESCE(cohead_freight, 0), COALESCE(cohead_misc, 0),
         COALESCE(SUM(currToCurr(aropenalloc_curr_id, cohead_curr_id,
                                 aropenalloc_amount, CURRENT_DATE)),0)
         INTO _freight, _misc, _credit
  FROM cohead
       LEFT OUTER JOIN aropenalloc ON (aropenalloc_doctype='S' AND aropenalloc_doc_id=cohead_id)
  WHERE (cohead_id=pCoheadid)
  GROUP BY cohead_freight, cohead_misc, cohead_curr_id;

  _amount := CASE pType WHEN 'S' THEN (_subtotal)
                        WHEN 'T' THEN (_subtotal + _tax + _freight + _misc)
                        WHEN 'B' THEN (_subtotal + _tax + _freight + _misc - _credit)
                        WHEN 'C' THEN (_credit)
                        WHEN 'X' THEN (_tax)
                        ELSE 0.0
             END;

  RETURN _amount;

END;
$$;


ALTER FUNCTION public.calcsalesorderamt(pcoheadid integer, ptype text) OWNER TO admin;

--
-- Name: calcshipfreight(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calcshipfreight(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pShipheadId ALIAS FOR $1;
  _result NUMERIC := 0;
  _order RECORD;
  _shipment RECORD;
  _weights RECORD;
  _price RECORD;
  _sales RECORD;
  _freightid INTEGER;
  _totalprice NUMERIC;
  _includepkgweight BOOLEAN := FALSE;
  _freight RECORD;
  _debug BOOLEAN := false;
BEGIN
  --Get shipment
  SELECT shiphead_order_id, shiphead_order_type, shiphead_freight 
  INTO _shipment
  FROM shiphead
  WHERE (shiphead_id=pShipheadId);

  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Shipment not found';
  END IF;

  IF (_shipment.shiphead_order_type = 'SO') THEN
  --Sales Orders
  
  --Get the order header information
    SELECT cust_id AS cust_id,
           custtype_id,
           custtype_code,
           shipto_id,
           shipto_num,
           cohead_orderdate AS orderdate,
           cohead_shipvia AS shipvia,
           shipto_shipzone_id AS shipzone_id,
           cohead_curr_id AS curr_id,
           currConcat(cohead_curr_id) AS currAbbr,
           cohead_calcfreight,
           cohead_freight
    INTO _order
    FROM cohead 
      JOIN custinfo ON (cust_id=cohead_cust_id)
      JOIN custtype ON (custtype_id=cust_custtype_id)
      LEFT OUTER JOIN shiptoinfo ON (shipto_id=cohead_shipto_id)
    WHERE (cohead_id=_shipment.shiphead_order_id);

    IF (NOT FOUND) THEN
      RAISE EXCEPTION 'Order not found';
    END IF;

    IF (_debug) THEN
      RAISE NOTICE 'cust_id = %', _order.cust_id;
      RAISE NOTICE 'custtype_id = %', _order.custtype_id;
      RAISE NOTICE 'shipto_id = %', _order.shipto_id;
      RAISE NOTICE 'shipto_num = %', _order.shipto_num;
      RAISE NOTICE 'orderdate = %', _order.orderdate;
      RAISE NOTICE 'shipvia = %', _order.shipvia;
      RAISE NOTICE 'shipzone_id = %', _order.shipzone_id;
      RAISE NOTICE 'curr_id = %', _order.curr_id;
      RAISE NOTICE 'currAbbr = %', _order.currAbbr;
      RAISE NOTICE 'calcfreight = %', _order.cohead_calcfreight;
      RAISE NOTICE 'freight = %', _order.cohead_freight;
    END IF;

    IF (NOT _order.cohead_calcfreight) THEN
      SELECT noNeg( _order.cohead_freight -
                    COALESCE((SELECT SUM(shiphead_freight)
                              FROM shiphead
                              WHERE (shiphead_order_id = _shipment.shiphead_order_id)
                                AND (shiphead_shipped='true')), 0) ) INTO _result;
      RETURN _result;
    END IF;

    SELECT fetchMetricBool('IncludePackageWeight') INTO _includepkgweight;

    --Calculate Sales Order freight
    --Get a list of aggregated weights from sites and
    --freight classes used on order lines
    FOR _weights IN
      SELECT CASE WHEN (_includePkgWeight) THEN
                        SUM(shipitem_qty * (item_prodweight + item_packweight))
                  ELSE  SUM(shipitem_qty * item_prodweight)
             END AS weight,
             itemsite_warehous_id, item_freightclass_id
      FROM shiphead
        JOIN shipitem ON (shipitem_shiphead_id=shiphead_id)
        JOIN coitem ON (shipitem_orderitem_id=coitem_id)
        JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
        JOIN item ON (item_id=itemsite_item_id)
      WHERE ( (shiphead_id=pShipheadId)
        AND   (item_freightclass_id IS NOT NULL) )
      GROUP BY itemsite_warehous_id, item_freightclass_id LOOP

    IF (_debug) THEN
      RAISE NOTICE '_weights.weight - %', _weights.weight;
      RAISE NOTICE '_weights.itemsite_warehous_id = %', _weights.itemsite_warehous_id;
      RAISE NOTICE '_weights.item_freightclass_id = %', _weights.item_freightclass_id;
    END IF;

    -- First get a sales price if any so we when we find other prices
    -- we can determine if we want that price or this price.
    --  Check for a Sale Price
    SELECT ipsfreight_id,
           CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, _order.curr_id,
                                                           ipsfreight_price, _order.orderdate)
                ELSE currToCurr(ipshead_curr_id, _order.curr_id,
                                (_weights.weight * ipsfreight_price), _order.orderdate)
           END AS price
           INTO _sales
    FROM ipsfreight JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
                    JOIN sale ON (sale_ipshead_id=ipshead_id)
    WHERE ( (ipsfreight_qtybreak <= _weights.weight)
      AND   ((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=_weights.itemsite_warehous_id))
      AND   ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=_weights.item_freightclass_id))
      AND   ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=_order.shipzone_id))
      AND   ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=_order.shipvia))
      AND   (CURRENT_DATE BETWEEN sale_startdate AND sale_enddate) )
    ORDER BY ipsfreight_qtybreak DESC, price ASC
    LIMIT 1;

    IF (_debug) THEN
      IF (_sales.price IS NOT NULL) THEN
        RAISE NOTICE 'Sales Price found, %', _sales.price;
      END IF;
    END IF;

    --  Check for a Customer Shipto Price
    SELECT ipsfreight_id,
           CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, _order.curr_id,
                                                           ipsfreight_price, _order.orderdate)
                ELSE currToCurr(ipshead_curr_id, _order.curr_id,
                                (_weights.weight * ipsfreight_price), _order.orderdate)
           END AS price
           INTO _price
    FROM ipsfreight JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
                    JOIN ipsass ON (ipsass_ipshead_id=ipshead_id)
    WHERE ( (ipsfreight_qtybreak <= _weights.weight)
      AND   ((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=_weights.itemsite_warehous_id))
      AND   ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=_weights.item_freightclass_id))
      AND   ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=_order.shipzone_id))
      AND   ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=_order.shipvia))
      AND   (CURRENT_DATE BETWEEN ipshead_effective AND (ipshead_expires - 1))
      AND   (ipsass_cust_id=_order.cust_id)
      AND   (ipsass_shipto_id != -1)
      AND   (ipsass_shipto_id=_order.shipto_id) )
    ORDER BY ipsfreight_qtybreak DESC, price ASC
    LIMIT 1;

    IF (_debug) THEN
      IF (_price.price IS NOT NULL) THEN
        RAISE NOTICE 'Customer Shipto Price found, %', _price.price;
      END IF;
    END IF;

    IF (_price.price IS NULL) THEN
    --  Check for a Customer Shipto Pattern Price
      SELECT ipsfreight_id,
             CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, _order.curr_id,
                                                             ipsfreight_price, _order.orderdate)
                  ELSE currToCurr(ipshead_curr_id, _order.curr_id,
                                  (_weights.weight * ipsfreight_price), _order.orderdate)
             END AS price
             INTO _price
      FROM ipsfreight JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
                      JOIN ipsass ON (ipsass_ipshead_id=ipshead_id)
      WHERE ( (ipsfreight_qtybreak <= _weights.weight)
        AND   (CURRENT_DATE BETWEEN ipshead_effective AND (ipshead_expires - 1))
        AND   (ipsass_cust_id=_order.cust_id)
        AND   (COALESCE(LENGTH(ipsass_shipto_pattern), 0) > 0)
        AND   (_order.shipto_num ~ ipsass_shipto_pattern)
        AND   ((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=_weights.itemsite_warehous_id))
        AND   ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=_weights.item_freightclass_id))
        AND   ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=_order.shipzone_id))
        AND   ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=_order.shipvia)) )
      ORDER BY ipsfreight_qtybreak DESC, price ASC
      LIMIT 1;

      IF (_debug) THEN
        IF (_price.price IS NOT NULL) THEN
          RAISE NOTICE 'Customer Shipto Pattern Price found, %', _price.price;
        END IF;
      END IF;

    END IF;

    IF (_price.price IS NULL) THEN
    --  Check for a Customer Price
      SELECT ipsfreight_id,
             CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, _order.curr_id,
                                                             ipsfreight_price, _order.orderdate)
                  ELSE currToCurr(ipshead_curr_id, _order.curr_id,
                                  (_weights.weight * ipsfreight_price), _order.orderdate)
             END AS price
             INTO _price
      FROM ipsfreight JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
                      JOIN ipsass ON (ipsass_ipshead_id=ipshead_id)
      WHERE ( (ipsfreight_qtybreak <= _weights.weight)
        AND   ((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=_weights.itemsite_warehous_id))
        AND   ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=_weights.item_freightclass_id))
        AND   ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=_order.shipzone_id))
        AND   ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=_order.shipvia))
        AND   (CURRENT_DATE BETWEEN ipshead_effective AND (ipshead_expires - 1))
        AND   (ipsass_cust_id=_order.cust_id)
        AND   (COALESCE(LENGTH(ipsass_shipto_pattern), 0) = 0) )
      ORDER BY ipsfreight_qtybreak DESC, price ASC
      LIMIT 1;

      IF (_debug) THEN
        IF (_price.price IS NOT NULL) THEN
          RAISE NOTICE 'Customer Price found, %', _price.price;
        END IF;
      END IF;

    END IF;

    IF (_price.price IS NULL) THEN
    --  Check for a Customer Type Price
      SELECT ipsfreight_id,
             CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, _order.curr_id,
                                                             ipsfreight_price, _order.orderdate)
                  ELSE currToCurr(ipshead_curr_id, _order.curr_id,
                                  (_weights.weight * ipsfreight_price), _order.orderdate)
             END AS price
             INTO _price
      FROM ipsfreight JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
                      JOIN ipsass ON (ipsass_ipshead_id=ipshead_id)
      WHERE ( (ipsfreight_qtybreak <= _weights.weight)
        AND   ((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=_weights.itemsite_warehous_id))
        AND   ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=_weights.item_freightclass_id))
        AND   ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=_order.shipzone_id))
        AND   ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=_order.shipvia))
        AND   (CURRENT_DATE BETWEEN ipshead_effective AND (ipshead_expires - 1))
        AND   (ipsass_custtype_id=_order.custtype_id) )
      ORDER BY ipsfreight_qtybreak DESC, price ASC
      LIMIT 1;

      IF (_debug) THEN
        IF (_price.price IS NOT NULL) THEN
          RAISE NOTICE 'Customer Type Price found, %', _price.price;
        END IF;
      END IF;

    END IF;

    IF (_price.price IS NULL) THEN
    --  Check for a Customer Type Pattern Price
      SELECT ipsfreight_id,
             CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, _order.curr_id,
                                                             ipsfreight_price, _order.orderdate)
                  ELSE currToCurr(ipshead_curr_id, _order.curr_id,
                                  (_weights.weight * ipsfreight_price), _order.orderdate)
             END AS price
             INTO _price
      FROM ipsfreight JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
                      JOIN ipsass ON (ipsass_ipshead_id=ipshead_id)
      WHERE ( (ipsfreight_qtybreak <= _weights.weight)
        AND   ((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=_weights.itemsite_warehous_id))
        AND   ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=_weights.item_freightclass_id))
        AND   ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=_order.shipzone_id))
        AND   ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=_order.shipvia))
        AND   (CURRENT_DATE BETWEEN ipshead_effective AND (ipshead_expires - 1))
        AND   (COALESCE(LENGTH(ipsass_custtype_pattern), 0) > 0)
        AND   (_order.custtype_code ~ ipsass_custtype_pattern) )
      ORDER BY ipsfreight_qtybreak DESC, price ASC
      LIMIT 1;

      IF (_debug) THEN
        IF (_price.price IS NOT NULL) THEN
          RAISE NOTICE 'Customer Type Pattern Price found, %', _price.price;
        END IF;
      END IF;

    END IF;

    -- Select the lowest price  
    IF ( (_price.price IS NOT NULL) AND ((_sales.price IS NULL) OR (_price.price < _sales.price)) ) THEN
      _freightid := _price.ipsfreight_id;
      _totalprice := _price.price;
    ELSE
      IF ( (_sales.price IS NOT NULL) AND ((_price.price IS NULL) OR (_sales.price <= _price.price)) ) THEN
        _freightid := _sales.ipsfreight_id;
        _totalprice := _sales.price;
      END IF;
    END IF;

    -- Total
    IF (_freightid IS NOT NULL) THEN
      _result := _result + _totalprice;
    END IF;

    END LOOP;
    RETURN ROUND(_result,2);
  END IF;

  IF (_shipment.shiphead_order_type = 'TO') THEN
  --Transfer Orders
  
    SELECT noNeg( (SELECT SUM(toitem_freight) + tohead_freight
                   FROM tohead, toitem
                   WHERE (toitem_tohead_id=tohead_id)
                     AND (tohead_id = _shipment.shiphead_order_id)
                   GROUP BY tohead_freight) -
                  COALESCE((SELECT SUM(shiphead_freight)
                            FROM shiphead
                            WHERE (shiphead_order_id = _shipment.shiphead_order_id)
                              AND (shiphead_shipped='true')), 0) ) INTO _result;
    RETURN _result;
  END IF;

  RETURN _result;

END;
$_$;


ALTER FUNCTION public.calcshipfreight(integer) OWNER TO admin;

--
-- Name: calctotalslipqty(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calctotalslipqty(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pTagid ALIAS FOR $1;
  _qty NUMERIC := 0;

BEGIN

  SELECT SUM(COALESCE(cntslip_qty, 0.0)) INTO _qty
  FROM cntslip
  WHERE (cntslip_cnttag_id=pTagid);

  RETURN _qty;

END;
$_$;


ALTER FUNCTION public.calctotalslipqty(integer) OWNER TO admin;

--
-- Name: calculatefreightdetail(integer, integer, text, integer, integer, text, date, text, integer, character varying, integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calculatefreightdetail(integer, integer, text, integer, integer, text, date, text, integer, character varying, integer, integer, numeric) RETURNS SETOF freightdata
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple.
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCustId ALIAS FOR $1;
  pCustTypeId ALIAS FOR $2;
  pCustTypeCode ALIAS FOR $3;
  pShiptoId ALIAS FOR $4;
  pShipZoneId ALIAS FOR $5;
  pShiptoNum ALIAS FOR $6;
  pOrderDate ALIAS FOR $7;
  pShipVia ALIAS FOR $8;
  pCurrId ALIAS FOR $9;
  pCurrAbbr ALIAS FOR $10;
  pItemSiteWhsId ALIAS FOR $11;
  pItemFreightclassId ALIAS FOR $12;
  pWeight ALIAS FOR $13;

  _row freightData%ROWTYPE;
  _price RECORD;
  _sales RECORD;
  _freightid INTEGER;
  _totalprice NUMERIC;
  _asof DATE;
  _debug BOOLEAN := FALSE;

BEGIN

  --Get pricing effectivity metric
  IF (SELECT fetchMetricText('soPriceEffective') = 'OrderDate') THEN
    _asof := pOrderDate;
  ELSE
    _asof := CURRENT_DATE;
  END IF;

  _freightid := NULL;
  _totalprice := 0.0;

  IF (_debug) THEN
    RAISE NOTICE 'pWeight - %', pWeight;
    RAISE NOTICE 'pItemSiteWhsId = %', pItemSiteWhsId;
    RAISE NOTICE 'pItemFreightclassId = %', pItemFreightclassId;
  END IF;

-- First get a sales price if any so when we find other prices
-- we can determine if we want that price or this sales price.
--  Check for a Sale Price
  SELECT ipsfreight_id,
    CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, pCurrId,
        ipsfreight_price, pOrderDate)
      ELSE currToCurr(ipshead_curr_id, pCurrId,
        (pWeight * ipsfreight_price), pOrderDate)
    END AS price
  INTO _sales
  FROM ipsfreight
  JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
  JOIN sale ON (sale_ipshead_id=ipshead_id)
  WHERE ( (ipsfreight_qtybreak <= pWeight)
    AND ((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=pItemSiteWhsId))
    AND ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=pItemFreightclassId))
    AND ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=pShipZoneId))
    AND ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=pShipVia))
    AND (_asof BETWEEN sale_startdate AND sale_enddate)
    AND (pCustId IS NOT NULL) )
  ORDER BY ipsfreight_qtybreak DESC, price ASC
  LIMIT 1;

  IF (_debug) THEN
    IF (_sales.price IS NOT NULL) THEN
      RAISE NOTICE 'Sales Price found, %', _sales.price;
    END IF;
  END IF;

--  Check for a Customer Shipto Price
  SELECT ipsfreight_id,
    CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, pCurrId,
        ipsfreight_price, pOrderDate)
      ELSE currToCurr(ipshead_curr_id, pCurrId,
        (pWeight * ipsfreight_price), pOrderDate)
    END AS price
  INTO _price
  FROM ipsfreight
  JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
  JOIN ipsass ON (ipsass_ipshead_id=ipshead_id)
  WHERE ( (ipsfreight_qtybreak <= pWeight)
    AND ((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=pItemSiteWhsId))
    AND ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=pItemFreightclassId))
    AND ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=pShipZoneId))
    AND ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=pShipVia))
    AND (_asof BETWEEN ipshead_effective AND (ipshead_expires - 1))
    AND   (ipsass_shipto_id != -1)
    AND   (ipsass_shipto_id=pShiptoId) )
  ORDER BY ipsfreight_qtybreak DESC, price ASC
  LIMIT 1;

  IF (_debug) THEN
    IF (_price.price IS NOT NULL) THEN
      RAISE NOTICE 'Customer Shipto Price found, %', _price.price;
    END IF;
  END IF;

  IF (_price.price IS NULL) THEN
--  Check for a Customer Shipto Pattern Price
  SELECT ipsfreight_id,
    CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, pCurrId,
        ipsfreight_price, pOrderDate)
      ELSE currToCurr(ipshead_curr_id, pCurrId,
        (pWeight * ipsfreight_price), pOrderDate)
    END AS price
  INTO _price
  FROM ipsfreight
  JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
  JOIN ipsass ON (ipsass_ipshead_id=ipshead_id)
  WHERE ( (ipsfreight_qtybreak <= pWeight)
    AND (_asof BETWEEN ipshead_effective AND (ipshead_expires - 1))
    AND (ipsass_cust_id=pCustId)
    AND (COALESCE(LENGTH(ipsass_shipto_pattern), 0) > 0)
    AND (pShiptoNum ~ ipsass_shipto_pattern)
    AND ((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=pItemSiteWhsId))
    AND ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=pItemFreightclassId))
    AND ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=pShipZoneId))
    AND ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=pShipVia)) )
  ORDER BY ipsfreight_qtybreak DESC, price ASC
  LIMIT 1;

  IF (_debug) THEN
    IF (_price.price IS NOT NULL) THEN
      RAISE NOTICE 'Customer Shipto Pattern Price found, %', _price.price;
    END IF;
  END IF;

  END IF;

  IF (_price.price IS NULL) THEN
--  Check for a Customer Price
  SELECT ipsfreight_id,
    CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, pCurrId,
        ipsfreight_price, pOrderDate)
      ELSE currToCurr(ipshead_curr_id, pCurrId,
        (pWeight * ipsfreight_price), pOrderDate)
    END AS price
  INTO _price
  FROM ipsfreight
  JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
  JOIN ipsass ON (ipsass_ipshead_id=ipshead_id)
  WHERE ( (ipsfreight_qtybreak <= pWeight)
    AND((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=pItemSiteWhsId))
    AND ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=pItemFreightclassId))
    AND ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=pShipZoneId))
    AND ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=pShipVia))
    AND (_asof BETWEEN ipshead_effective AND (ipshead_expires - 1))
    AND (ipsass_cust_id=pCustId)
    AND (COALESCE(LENGTH(ipsass_shipto_pattern), 0) = 0) )
  ORDER BY ipsfreight_qtybreak DESC, price ASC
  LIMIT 1;

  IF (_debug) THEN
    IF (_price.price IS NOT NULL) THEN
      RAISE NOTICE 'Customer Price found, %', _price.price;
    END IF;
  END IF;

  END IF;

  IF (_price.price IS NULL) THEN
--  Check for a Customer Type Price
  SELECT ipsfreight_id,
    CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, pCurrId,
        ipsfreight_price, pOrderDate)
      ELSE currToCurr(ipshead_curr_id, pCurrId,
        (pWeight * ipsfreight_price), pOrderDate)
    END AS price
  INTO _price
  FROM ipsfreight JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
                  JOIN ipsass ON (ipsass_ipshead_id=ipshead_id)
  WHERE ( (ipsfreight_qtybreak <= pWeight)
    AND ((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=pItemSiteWhsId))
    AND ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=pItemFreightclassId))
    AND ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=pShipZoneId))
    AND ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=pShipVia))
    AND (_asof BETWEEN ipshead_effective AND (ipshead_expires - 1))
    AND (ipsass_custtype_id=pCustTypeId) )
  ORDER BY ipsfreight_qtybreak DESC, price ASC
  LIMIT 1;

  IF (_debug) THEN
    IF (_price.price IS NOT NULL) THEN
      RAISE NOTICE 'Customer Type Price found, %', _price.price;
    END IF;
  END IF;

  END IF;

  IF (_price.price IS NULL) THEN
--  Check for a Customer Type Pattern Price
  SELECT ipsfreight_id,
    CASE WHEN (ipsfreight_type='F') THEN currToCurr(ipshead_curr_id, pCurrId,
        ipsfreight_price, pOrderDate)
      ELSE currToCurr(ipshead_curr_id, pCurrId,
        (pWeight * ipsfreight_price), pOrderDate)
    END AS price
  INTO _price
  FROM ipsfreight JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
                  JOIN ipsass ON (ipsass_ipshead_id=ipshead_id)
  WHERE ( (ipsfreight_qtybreak <= pWeight)
    AND ((ipsfreight_warehous_id IS NULL) OR (ipsfreight_warehous_id=pItemSiteWhsId))
    AND ((ipsfreight_freightclass_id IS NULL) OR (ipsfreight_freightclass_id=pItemFreightclassId))
    AND ((ipsfreight_shipzone_id IS NULL) OR (ipsfreight_shipzone_id=pShipZoneId))
    AND ((ipsfreight_shipvia IS NULL) OR (ipsfreight_shipvia=pShipVia))
    AND (_asof BETWEEN ipshead_effective AND (ipshead_expires - 1))
    AND (COALESCE(LENGTH(ipsass_custtype_pattern), 0) > 0)
    AND (pCustTypeCode ~ ipsass_custtype_pattern) )
  ORDER BY ipsfreight_qtybreak DESC, price ASC
  LIMIT 1;

  IF (_debug) THEN
    IF (_price.price IS NOT NULL) THEN
      RAISE NOTICE 'Customer Type Pattern Price found, %', _price.price;
    END IF;
  END IF;

  END IF;

  -- Select the lowest price
  IF ( (_price.price IS NOT NULL) AND ((_sales.price IS NULL) OR (_price.price < _sales.price)) ) THEN
    _freightid := _price.ipsfreight_id;
    _totalprice := _price.price;
  ELSE
    IF ( (_sales.price IS NOT NULL) AND ((_price.price IS NULL) OR (_sales.price <= _price.price)) ) THEN
      _freightid := _sales.ipsfreight_id;
      _totalprice := _sales.price;
    END IF;
  END IF;

  IF (_debug) THEN
    RAISE NOTICE '_freightid = %', _freightid;
    RAISE NOTICE '_totalprice = %', _totalprice;
  END IF;

  -- Get information for the selected ipsfreight
  -- and return
  IF (_freightid IS NULL) THEN
    _row.freightdata_schedule := 'N/A';
    _row.freightdata_from := '';
    _row.freightdata_to := '';
    _row.freightdata_shipvia := '';
    _row.freightdata_freightclass := '';
    _row.freightdata_weight := 0;
    _row.freightdata_uom := '';
    _row.freightdata_price := 0;
    _row.freightdata_type := '';
    _row.freightdata_total := 0;
    _row.freightdata_currency := '';
    RETURN NEXT _row;
  ELSE
    SELECT ipshead_name AS freightdata_schedule,
      COALESCE(warehous_code, 'Any') AS freightdata_from,
      COALESCE(shipzone_name, 'Any') AS freightdata_to,
      COALESCE(ipsfreight_shipvia, 'Any') AS freightdata_shipvia,
      COALESCE(freightclass_code, 'Any') AS freightdata_freightclass,
      pWeight AS freightdata_weight,
      uom_name AS freightdata_uom,
      currToCurr(ipshead_curr_id, pCurrId, ipsfreight_price, pOrderDate) AS freightdata_price,
      CASE WHEN (ipsfreight_type='F') THEN 'Flat Rate'
        ELSE 'Per UOM'
      END AS freightdata_type,
      _totalprice AS freightdata_total,
      pCurrAbbr AS freightdata_currency
    INTO _row
    FROM ipsfreight
      JOIN ipshead ON (ipshead_id=ipsfreight_ipshead_id)
      LEFT OUTER JOIN uom ON (uom_item_weight)
      LEFT OUTER JOIN whsinfo ON (warehous_id=ipsfreight_warehous_id)
      LEFT OUTER JOIN shipzone ON (shipzone_id=ipsfreight_shipzone_id)
      LEFT OUTER JOIN freightclass ON (freightclass_id=ipsfreight_freightclass_id)
    WHERE (ipsfreight_id=_freightid);

    RETURN NEXT _row;
  END IF;

  RETURN;
END;
$_$;


ALTER FUNCTION public.calculatefreightdetail(integer, integer, text, integer, integer, text, date, text, integer, character varying, integer, integer, numeric) OWNER TO admin;

--
-- Name: calculatesubtax(integer, date, integer, numeric, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calculatesubtax(integer, date, integer, numeric, integer) RETURNS SETOF taxdetail
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pTaxCodeId ALIAS FOR $1;
  pDate ALIAS FOR $2;
  pCurrId ALIAS FOR $3;
  pAmount ALIAS FOR $4;
  pLevel ALIAS FOR $5;
  _row taxdetail%ROWTYPE;
  _rownumber INTEGER := 1;
  _calc_tax Numeric :=0;
  _x RECORD;
  _y RECORD;

BEGIN
  FOR _x IN 

  SELECT tax_id, tax_code, tax_descrip, tax_basis_tax_id,
    taxrate_id, taxrate_percent, taxrate_curr_id, taxrate_amount,  
    taxclass_id, taxclass_code, COALESCE(taxclass_sequence,0) AS taxclass_sequence,
    curr_id, curr_abbr
  FROM tax, taxrate, taxclass, curr_symbol
  WHERE ((tax_id = taxrate_tax_id)
  AND (tax_taxclass_id = taxclass_id)
  AND (taxrate_curr_id = curr_id)
  AND (tax_basis_tax_id = pTaxCodeId)
  AND (pDate BETWEEN taxrate_effective AND taxrate_expires)
  AND (taxrate_curr_id = pCurrId))
  
  LOOP
    SELECT 
      ROUND((_x.taxrate_percent * pAmount + currToCurr(_x.curr_id, pCurrId, _x.taxrate_amount, pDate)), 6) 
    INTO _calc_tax;

    _row.taxdetail_tax_id = _x.tax_id;
    _row.taxdetail_tax_code = _x.tax_code;
    _row.taxdetail_tax_descrip = _x.tax_descrip;
    _row.taxdetail_tax_basis_tax_id = _x.tax_basis_tax_id ;
    _row.taxdetail_taxrate_percent = _x.taxrate_percent;
    _row.taxdetail_taxrate_amount = _x.taxrate_amount;
    _row.taxdetail_level = pLevel + 1;
    _row.taxdetail_taxclass_id = _x.taxclass_id ; 
    _row.taxdetail_taxclass_code = _x.taxclass_code;
    _row.taxdetail_taxclass_sequence = _x.taxclass_sequence;
    _row.taxdetail_tax = _calc_tax;
    _row.taxdetail_curr_id = _x.curr_id;
    _row.taxdetail_curr_abbr = _x.curr_abbr;

    RETURN NEXT _row;
    _rownumber := _rownumber + 1;

    FOR _y IN  
    SELECT * 
    FROM calculateSubTax( _x.tax_id, pDate, pCurrId, _calc_tax, pLevel + 1)
    LOOP
      _row.taxdetail_tax_id = _y.taxdetail_tax_id;
      _row.taxdetail_tax_code = _y.taxdetail_tax_code;
      _row.taxdetail_tax_descrip = _y.taxdetail_tax_descrip;
      _row.taxdetail_tax_basis_tax_id = _y.taxdetail_tax_basis_tax_id ;
      _row.taxdetail_taxrate_percent = _y.taxdetail_taxrate_percent;
      _row.taxdetail_taxrate_amount = _y.taxdetail_taxrate_amount;
      _row.taxdetail_level = _y.taxdetail_level + 1;
      _row.taxdetail_taxclass_id = _y.taxdetail_taxclass_id ; 
      _row.taxdetail_taxclass_code = _y.taxdetail_taxclass_code;
      _row.taxdetail_taxclass_sequence = _y.taxdetail_taxclass_sequence;
      _row.taxdetail_tax = _y.taxdetail_tax;
      _row.taxdetail_curr_id = _y.taxdetail_curr_id;
      _row.taxdetail_curr_abbr = _y.taxdetail_curr_abbr;
      
      RETURN NEXT _row;
      _rownumber := _rownumber + 1;

    END LOOP;

  END LOOP;

END;
$_$;


ALTER FUNCTION public.calculatesubtax(integer, date, integer, numeric, integer) OWNER TO admin;

--
-- Name: calculatetax(integer, integer, date, integer, numeric); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calculatetax(integer, integer, date, integer, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pTaxZoneId ALIAS FOR  $1;
  pTaxTypeId ALIAS FOR  $2;
  pDate ALIAS FOR  $3;
  pCurrId ALIAS FOR $4;
  pAmount ALIAS FOR $5;
  _tottax numeric := 0;  -- total tax
  
BEGIN

  SELECT COALESCE(ROUND(SUM(taxdetail_tax),6),0)
    INTO _tottax 
  FROM calculateTaxDetail(pTaxZoneId, pTaxTypeId, pDate, pCurrId, pAmount);

  RETURN _tottax;
  
END;
$_$;


ALTER FUNCTION public.calculatetax(integer, integer, date, integer, numeric) OWNER TO admin;

--
-- Name: calculatetaxdetail(integer, integer, date, integer, numeric); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calculatetaxdetail(integer, integer, date, integer, numeric) RETURNS SETOF taxdetail
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pTaxZoneId ALIAS FOR  $1;
  pTaxTypeId ALIAS FOR  $2;
  pDate ALIAS FOR  $3;
  pCurrId ALIAS FOR $4;
  pAmount ALIAS FOR $5;
  _row taxdetail%ROWTYPE;
  _x RECORD;
  _y RECORD;
  _z RECORD;
  _currcum numeric := 0;  -- Current cumulative tax
  _currseq numeric := 0;  -- Current group sequence
  _prevcum numeric := 0;  -- Previous cumulative tax
  _tax numeric := 0;      -- Calculated tax amount
  _taxbasis numeric := 0;  -- Used for calculating sub taxes

BEGIN

  IF ((COALESCE(pTaxTypeId,-1) = -1) OR (COALESCE(pTaxZoneId,-1) = -1)) THEN
    RETURN;
  END IF;

  SELECT DISTINCT
    COALESCE(taxass_taxzone_id, -1) AS taxzone_id,
    COALESCE(taxass_taxtype_id, -1) AS taxtype_id,
    taxass_tax_id,
    CASE
      WHEN ((taxass_taxzone_id IS NOT NULL) AND (taxass_taxtype_id IS NOT NULL)) THEN
        0
      WHEN ((taxass_taxzone_id IS NOT NULL) AND (taxass_taxtype_id IS NULL)) THEN
        1
      WHEN ((taxass_taxzone_id IS NULL) AND (taxass_taxtype_id IS NOT NULL)) THEN
        2
      ELSE
        3
    END AS sequence
    INTO _x
  FROM taxass
  WHERE  ((COALESCE(taxass_taxzone_id, pTaxZoneId, -1) = COALESCE(pTaxZoneId,-1))
  AND    (COALESCE(taxass_taxtype_id, pTaxTypeId, -1) = COALESCE(pTaxTypeId,-1)))
  ORDER BY sequence LIMIT 1;

  --Now loop through each tax detail record and return calculated result
  FOR _y IN
    SELECT  --the data required by taxdetail type.  Coalesce group sequence to 0 if no class.
    tax_id
    ,tax_code
    ,tax_descrip
    ,tax_basis_tax_id
    ,taxrate_percent
    ,taxrate_amount
    ,0 as taxdetail_level 
    ,taxclass_id
    ,taxclass_code
    ,COALESCE(taxclass_sequence, 0) AS taxclass_sequence
    ,0 as taxdetail_tax
    ,curr_id
    ,curr_abbr	
    FROM taxass, taxclass RIGHT OUTER JOIN tax  
      LEFT OUTER JOIN taxrate ON (taxrate_tax_id=tax_id)
    ON (tax_taxclass_id=taxclass_id),
    curr_symbol 
    WHERE 
    taxass_tax_id=tax_id
    AND taxrate_curr_id=curr_id
    AND COALESCE(taxass_taxzone_id, -1) = _x.taxzone_id
    AND COALESCE(taxass_taxtype_id, -1) = _x.taxtype_id
    AND pDate BETWEEN COALESCE(taxrate_effective, startoftime()) AND COALESCE(taxrate_expires, endoftime())
    ORDER BY COALESCE(taxclass_sequence, 0)
  LOOP
    -- If sequence has changed, cache the previous cumulative tax
    IF (_currseq != _x.sequence) THEN
      _prevcum := _currcum;
    END IF;

    -- Calculate the tax amount.  Convert currency for flat rate amounts
    SELECT 
    ROUND((_y.taxrate_percent * (pAmount + _prevcum) + currToCurr(_y.curr_id, pCurrId, _y.taxrate_amount, pDate)), 6) 
    INTO _tax
    FROM tax JOIN  taxrate ON (tax_id = taxrate_tax_id)
    WHERE (tax_id=_x.taxass_tax_id)
    AND (pDate BETWEEN COALESCE(taxrate_effective, startoftime()) AND COALESCE(taxrate_expires, endoftime()));

    --Map fields to _row

    _row.taxdetail_tax_id := _y.tax_id;
    _row.taxdetail_tax_code := _y.tax_code;
    _row.taxdetail_tax_descrip := _y.tax_descrip;
    _row.taxdetail_tax_basis_tax_id := _y.tax_basis_tax_id;
    _row.taxdetail_taxrate_percent := _y.taxrate_percent;
    _row.taxdetail_taxrate_amount := _y.taxrate_amount;
    _row.taxdetail_level := _y.taxdetail_level;
    _row.taxdetail_taxclass_id := _y.taxclass_id;
    _row.taxdetail_taxclass_code := _y.taxclass_code;
    _row.taxdetail_taxclass_sequence := _y.taxclass_sequence;
    _row.taxdetail_tax := _tax;
    _row.taxdetail_curr_id := _y.curr_id;
    _row.taxdetail_curr_abbr := _y.curr_abbr;
  
    RETURN NEXT _row;

    -- Increment cumulative balance and sequence number
    IF(_y.taxclass_sequence <> 0) THEN
      _currcum := _currcum + _tax;
    END IF;
    _currseq := _y.taxclass_sequence;

    -- Loop to Calculate sub taxes
    FOR _z IN
    SELECT *
    FROM calculateSubTax(_y.tax_id,pDate, pCurrId, _tax, 0)
    LOOP
     --Mapping of data
    _row.taxdetail_tax_id := _z.taxdetail_tax_id;
    _row.taxdetail_tax_code := _z.taxdetail_tax_code;
    _row.taxdetail_tax_descrip := _z.taxdetail_tax_descrip;
    _row.taxdetail_tax_basis_tax_id := _z.taxdetail_tax_basis_tax_id;
    _row.taxdetail_taxrate_percent := _z.taxdetail_taxrate_percent;
    _row.taxdetail_taxrate_amount := _z.taxdetail_taxrate_amount;
    _row.taxdetail_level := _z.taxdetail_level;
    _row.taxdetail_taxclass_id := _z.taxdetail_taxclass_id;
    _row.taxdetail_taxclass_code := _z.taxdetail_taxclass_code;
    _row.taxdetail_taxclass_sequence := _z.taxdetail_taxclass_sequence;
    _row.taxdetail_tax := _z.taxdetail_tax;
    _row.taxdetail_curr_id := _z.taxdetail_curr_id;
    _row.taxdetail_curr_abbr := _z.taxdetail_curr_abbr;

     RETURN NEXT _row;
     --Add to cumulative counter (_curcum)
     _currcum := _currcum + _z.taxdetail_tax ;

    END LOOP;

   END LOOP;
 
END;
 $_$;


ALTER FUNCTION public.calculatetaxdetail(integer, integer, date, integer, numeric) OWNER TO admin;

--
-- Name: calculatetaxdetailline(text, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calculatetaxdetailline(text, integer) RETURNS SETOF taxdetail
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pOrderType ALIAS FOR $1;
  pOrderId ALIAS FOR $2;
  _row taxdetail%ROWTYPE;
  _qry text;
  _totaltax numeric;
  _y RECORD;
  _table text;
  
BEGIN
   _totaltax=0.0;

   IF pOrderType = 'II' THEN
     _table := 'invcitemtax';
   ELSIF pOrderType = 'BI' THEN
     _table := 'cobilltax';
   ELSIF pOrderType = 'CI' THEN
     _table := 'cmitemtax';
   ELSIF pOrderType = 'VI' THEN
     _table := 'voitemtax';
   ELSIF pOrderType = 'TI' THEN
     _table := 'toitemtax';
   ELSIF pOrderType = 'AR' THEN
     _table := 'aropentax';
   ELSIF pOrderType = 'AP' THEN
     _table := 'apopentax';
   END IF;
     
   _qry := 'SELECT taxhist_tax_id as tax_id, tax_code, tax_descrip, taxhist_tax, COALESCE(taxhist_sequence,0) AS taxhist_sequence
            FROM taxhist 
             JOIN tax ON (taxhist_tax_id=tax_id) 
             JOIN pg_class ON (pg_class.oid=taxhist.tableoid) 
            WHERE ( (taxhist_parent_id = ' || pOrderId || ')
             AND (relname=''' || _table || ''') );';
    
   FOR _y IN  EXECUTE _qry
   LOOP
     _row.taxdetail_tax_id=_y.tax_id;
     _row.taxdetail_tax_code = _y.tax_code;
     _row.taxdetail_tax_descrip = _y.tax_descrip;
     _row.taxdetail_tax = _y.taxhist_tax;
     _row.taxdetail_level= 0 ;
     _row.taxdetail_taxclass_sequence= _y.taxhist_sequence;
     _totaltax = _totaltax + _y.taxhist_tax;
     RETURN NEXT _row;
   END LOOP;
 END;
$_$;


ALTER FUNCTION public.calculatetaxdetailline(text, integer) OWNER TO admin;

--
-- Name: calculatetaxdetailsummary(text, integer, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calculatetaxdetailsummary(text, integer, text) RETURNS SETOF taxdetail
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pOrderType ALIAS FOR $1;
  pOrderId ALIAS FOR $2;
  pDisplayType ALIAS FOR $3;
  _row taxdetail%ROWTYPE;
  _qry text := '';
  _qry1 text;
  _totaltax numeric;
  _x RECORD;
  _y RECORD;
  _table text;
  
BEGIN
 _totaltax=0.0;
 IF pOrderType IN ('S','Q','RA','PO') THEN
   
   IF pOrderType = 'S' THEN
     _qry := 'SELECT ' || 'COALESCE(cohead_taxzone_id, -1) AS taxzone_id, cohead_orderdate AS order_date,
                cohead_curr_id AS curr_id, COALESCE(coitem_taxtype_id, -1) AS taxtype_id,
                ROUND((coitem_qtyord * coitem_qty_invuomratio) * (coitem_price / coitem_price_invuomratio),2) AS amount
              FROM cohead, coitem
              WHERE ( (coitem_cohead_id = ' || pOrderId || ')
               AND (' || 'cohead_id = coitem_cohead_id) 
               AND ( coitem_status != ''X'') )';
   ELSEIF  pOrderType = 'Q' THEN
     _qry := 'SELECT ' || 'COALESCE(quhead_taxzone_id, -1) AS taxzone_id, quhead_quotedate AS order_date,
                quhead_curr_id AS curr_id, COALESCE(quitem_taxtype_id, -1) AS taxtype_id, 
                ROUND((quitem_qtyord * quitem_qty_invuomratio) * (quitem_price / quitem_price_invuomratio),2) AS amount
              FROM quhead, quitem 
              WHERE ( (quitem_quhead_id = ' || pOrderId || ')
               AND (quhead_id = quitem_quhead_id) )'; 
   ELSEIF  pOrderType = 'RA' THEN
     _qry := 'SELECT ' || 'COALESCE(rahead_taxzone_id, -1) AS taxzone_id, rahead_authdate AS order_date,
                rahead_curr_id AS curr_id, COALESCE(raitem_taxtype_id, -1) AS taxtype_id, 
                ROUND((raitem_qtyauthorized * raitem_qty_invuomratio) * (raitem_unitprice / raitem_price_invuomratio),2) AS amount
              FROM rahead, raitem 
              WHERE ( (raitem_rahead_id = ' || pOrderId || ')
               AND (rahead_id = raitem_rahead_id) )';
   ELSEIF  pOrderType = 'PO' THEN
     _qry := 'SELECT ' || 'COALESCE(pohead_taxzone_id, -1) AS taxzone_id, pohead_orderdate AS order_date,
                pohead_curr_id AS curr_id, COALESCE(poitem_taxtype_id, -1) AS taxtype_id, 
                ROUND(poitem_qty_ordered * poitem_unitprice, 2) AS amount
              FROM pohead, poitem 
              WHERE ( (poitem_pohead_id = ' || pOrderId || ')
               AND (pohead_id = poitem_pohead_id) )'; 
  END IF;

  FOR _x IN EXECUTE _qry
  LOOP  
    _qry1 := 'SELECT * from calculatetaxdetail(' || _x.taxzone_id || ',' || _x.taxtype_id || ',''' || _x.order_date || ''',' || _x.curr_id  || ',' || _x.amount || ')';
    FOR _y IN  EXECUTE _qry1
    LOOP
      _row.taxdetail_tax_id=_y.taxdetail_tax_id;
      _row.taxdetail_tax_code = _y.taxdetail_tax_code;
      _row.taxdetail_tax_descrip = _y.taxdetail_tax_descrip;
      _row.taxdetail_tax = _y.taxdetail_tax;
      _row.taxdetail_level=_y.taxdetail_level;
      _row.taxdetail_taxclass_sequence= _y.taxdetail_taxclass_sequence;
      _totaltax = _totaltax + _y.taxdetail_tax;
      RETURN NEXT _row;
    END LOOP;
  END LOOP;

  IF pDisplayType = 'T' AND pOrderType <> 'PO' THEN
   IF pOrderType = 'S' THEN 
    _qry := 'SELECT COALESCE(cohead_taxzone_id, -1) AS taxzone_id, cohead_orderdate AS order_date,
               cohead_curr_id AS curr_id, cohead_freight AS freight
             FROM cohead WHERE cohead_id = ' || pOrderId ;
   ELSEIF  pOrderType = 'Q' THEN 
    _qry := 'SELECT COALESCE(quhead_taxzone_id, -1) AS taxzone_id, quhead_quotedate AS order_date,
               quhead_curr_id AS curr_id, COALESCE(quhead_freight,0) AS freight
             FROM quhead WHERE quhead_id = ' || pOrderId;
   ELSEIF pOrderType = 'RA' THEN
    _qry := 'SELECT COALESCE(rahead_taxzone_id, -1) AS taxzone_id, COALESCE(rahead_authdate,CURRENT_DATE) AS order_date,
               rahead_curr_id AS curr_id, COALESCE(rahead_freight,0) AS freight
             FROM rahead WHERE rahead_id = ' || pOrderId;
   END IF;

  FOR _x IN EXECUTE _qry
  LOOP
     _qry1 := 'SELECT * from calculatetaxdetail(' || _x.taxzone_id || ', getfreighttaxtypeid(),''' || _x.order_date || ''',' || _x.curr_id  || ',' || _x.freight || ')';
    FOR _y IN  EXECUTE _qry1
    LOOP
       _row.taxdetail_tax_id=_y.taxdetail_tax_id;
       _row.taxdetail_tax_code = _y.taxdetail_tax_code;
       _row.taxdetail_tax_descrip = _y.taxdetail_tax_descrip;
       _row.taxdetail_tax = _y.taxdetail_tax;
       _row.taxdetail_level=_y.taxdetail_level;
       _row.taxdetail_taxclass_sequence= _y.taxdetail_taxclass_sequence;
       _totaltax = _totaltax + _y.taxdetail_tax;
       RETURN NEXT _row;
     END LOOP;
   END LOOP;
  END IF;
  
 ELSEIF pOrderType IN ('I','B','CM', 'VO','TO') THEN
   IF (pOrderType='I') THEN
     _table := 'invcheadtax';
   ELSIF (pOrderType='B') THEN
     _table := 'cobmisctax';
   ELSIF (pOrderType='CM') THEN
     _table := 'cmheadtax';
   ELSIF (pOrderType='VO') THEN
     _table := 'voheadtax';
   ELSIF (pOrderType='TO') THEN
     _table := 'tohead';
   END IF;
   
   IF pOrderType = 'I' AND (pDisplayType IN ('L','T')) THEN
     _qry := 'SELECT taxhist_tax_id as tax_id, tax_code, tax_descrip, taxhist_tax, taxhist_sequence
              FROM invchead, invcitemtax LEFT OUTER JOIN tax ON (taxhist_tax_id=tax_id)
               LEFT OUTER JOIN invcitem ON (invcitem_id=taxhist_parent_id) 
              WHERE invcitem_invchead_id = ' || pOrderId || ' 
               AND invchead_id = invcitem_invchead_id ';
   ELSIF pOrderType = 'B' AND (pDisplayType IN ('L','T')) THEN
    _qry := 'SELECT taxhist_tax_id as tax_id, tax_code, tax_descrip, taxhist_tax, taxhist_sequence
             FROM cobmisc, cobilltax LEFT OUTER JOIN tax ON (taxhist_tax_id=tax_id)
             LEFT OUTER JOIN cobill ON (cobill_id=taxhist_parent_id)
             WHERE cobill_cobmisc_id = ' || pOrderId || ' 
             AND cobmisc_id = cobill_cobmisc_id ';
   ELSIF pOrderType = 'CM' AND (pDisplayType IN ('L','T')) THEN
    _qry := 'SELECT taxhist_tax_id as tax_id, tax_code, tax_descrip, taxhist_tax, taxhist_sequence
             FROM cmhead, cmitemtax LEFT OUTER JOIN tax ON (taxhist_tax_id=tax_id)
             LEFT OUTER JOIN cmitem ON (cmitem_id=taxhist_parent_id)
             WHERE cmitem_cmhead_id = ' || pOrderId || ' 
             AND cmhead_id = cmitem_cmhead_id ';
   ELSIF pOrderType = 'VO' AND (pDisplayType IN ('L','T')) THEN
    _qry := 'SELECT taxhist_tax_id as tax_id, tax_code, tax_descrip, taxhist_tax, taxhist_sequence
             FROM vohead, voitemtax LEFT OUTER JOIN tax ON (taxhist_tax_id=tax_id)
             LEFT OUTER JOIN voitem ON (voitem_id=taxhist_parent_id)
             WHERE voitem_vohead_id = ' || pOrderId || ' 
             AND vohead_id = voitem_vohead_id ';
   ELSIF pOrderType = 'TO' AND (pDisplayType IN ('L','T')) THEN
    _qry := 'SELECT taxhist_tax_id as tax_id, tax_code, tax_descrip, taxhist_tax, taxhist_sequence
             FROM tohead, toitemtax LEFT OUTER JOIN tax ON (taxhist_tax_id=tax_id)
             LEFT OUTER JOIN toitem ON (toitem_id=taxhist_parent_id)
             WHERE toitem_tohead_id = ' || pOrderId || ' 
             AND tohead_id = toitem_tohead_id ';
   END IF;
   IF pDisplayType IN ('F','T') AND pOrderType <> 'VO' THEN
     IF (length(_qry) > 0) THEN
       _qry := _qry || ' UNION ALL ';
     END IF;
     _qry := _qry || 'SELECT taxhist_tax_id as tax_id, tax_code, tax_descrip, taxhist_tax, taxhist_sequence
              FROM taxhist 
               JOIN tax ON (taxhist_tax_id=tax_id)
               JOIN pg_class ON (pg_class.oid=taxhist.tableoid)
              WHERE ( (taxhist_parent_id = ' || pOrderId || ') 
               AND (taxhist_taxtype_id=getfreighttaxtypeid())
               AND (relname=''' || _table || ''') )';
   END IF;
   IF pDisplayType IN ('A','T') THEN
     IF (length(_qry) > 0) THEN
       _qry := _qry || ' UNION ALL ';
     END IF;
     _qry := _qry || 'SELECT taxhist_tax_id as tax_id, tax_code, tax_descrip, taxhist_tax, taxhist_sequence
              FROM taxhist 
               JOIN tax ON (taxhist_tax_id=tax_id)
               JOIN pg_class ON (pg_class.oid=taxhist.tableoid)
              WHERE ( (taxhist_parent_id = ' || pOrderId || ') 
               AND (taxhist_taxtype_id=getadjustmenttaxtypeid())
               AND (relname=''' || _table || ''') )';

   END IF;
   FOR _y IN  EXECUTE _qry
   LOOP
     _row.taxdetail_tax_id=_y.tax_id;
     _row.taxdetail_tax_code = _y.tax_code;
     _row.taxdetail_tax_descrip = _y.tax_descrip;
     _row.taxdetail_tax = _y.taxhist_tax;
     _row.taxdetail_level= 0 ;
     _row.taxdetail_taxclass_sequence= COALESCE(_y.taxhist_sequence,0);
     _totaltax = _totaltax + _y.taxhist_tax;
     RETURN NEXT _row;
   END LOOP;
 END IF;
 END;
$_$;


ALTER FUNCTION public.calculatetaxdetailsummary(text, integer, text) OWNER TO admin;

--
-- Name: calculatetaxhist(text, integer, integer, integer, date, integer, numeric); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calculatetaxhist(text, integer, integer, integer, date, integer, numeric) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pTableName ALIAS FOR $1;
  pParentId  ALIAS FOR $2;
  pTaxZoneId ALIAS FOR $3;
  pTaxTypeId ALIAS FOR $4;
  pDate      ALIAS FOR $5;
  pCurrId    ALIAS FOR $6;
  pAmount    ALIAS FOR $7;
  _qry TEXT;
  
BEGIN
  IF (pTableName IS NULL) THEN
    RAISE EXCEPTION 'A table name is required to calculate tax history';
  ELSEIF (pParentId IS NULL) THEN
    RAISE EXCEPTION 'A parent ID is required to calculate tax history';
  ELSEIF (pDate IS NULL) THEN
    RAISE EXCEPTION 'A date is required to calculate tax history';
  ELSEIF (pAmount IS NULL) THEN
     RAISE EXCEPTION 'An amount is required to calculate tax history';
  END IF;

  -- Build a query that deletes any previous tax history for this document record
  _qry := 'DELETE FROM ' || pTableName || ' WHERE taxhist_parent_id = ' || pParentId || ' AND taxhist_taxtype_id <> getadjustmenttaxtypeid();';
  EXECUTE _qry;

  -- Next, build and execute query that inserts new rows.
  _qry := 'INSERT INTO ' || pTableName || ' (
             taxhist_parent_id, taxhist_taxtype_id, taxhist_tax_id, taxhist_basis,
             taxhist_basis_tax_id, taxhist_sequence, taxhist_percent, 
             taxhist_amount, taxhist_tax, taxhist_docdate)
           SELECT ' || pParentId || ',';
  IF (pTaxTypeId IS NULL) THEN
    _qry := _qry || 'NULL';
  ELSE
    _qry := _qry || pTaxTypeId;
  END If;
  _qry := _qry || ', taxdetail_tax_id,' || pAmount || ', 
             taxdetail_tax_basis_tax_id, taxdetail_taxclass_sequence, taxdetail_taxrate_percent,
             taxdetail_taxrate_amount, taxdetail_tax, ''' || pDate || '''
           FROM calculatetaxdetail(' || COALESCE(pTaxZoneId,-1) || ',' || COALESCE(pTaxTypeId,-1) ||',''' || pDate || ''',' || pCurrId || ',' || pAmount || ');';
  EXECUTE _qry;

  RETURN true;
END;
$_$;


ALTER FUNCTION public.calculatetaxhist(text, integer, integer, integer, date, integer, numeric) OWNER TO admin;

--
-- Name: calcvoucheramt(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calcvoucheramt(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVoucherid ALIAS FOR $1;
  _amount NUMERIC := 0;

BEGIN

  SELECT SUM(COALESCE(vodist_amount, 0)) INTO _amount
  FROM vodist
  WHERE (vodist_vohead_id=pVoucherid);

  RETURN _amount;

END;
$_$;


ALTER FUNCTION public.calcvoucheramt(integer) OWNER TO admin;

--
-- Name: calcvoucherfreight(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calcvoucherfreight(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVoucherid ALIAS FOR $1;
  _amount NUMERIC := 0;

BEGIN

  SELECT SUM(COALESCE(voitem_freight, 0)) INTO _amount
  FROM voitem
  WHERE (voitem_vohead_id=pVoucherid);

  RETURN _amount;

END;
$_$;


ALTER FUNCTION public.calcvoucherfreight(integer) OWNER TO admin;

--
-- Name: calcvouchertax(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calcvouchertax(integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVoucherid ALIAS FOR $1;
  _amount NUMERIC := 0;

BEGIN

  SELECT COALESCE(calculateTax(vohead_taxzone_id,
                               vohead_taxtype_id,
                               vohead_docdate,
                               vohead_curr_id,
                               calcVoucherAmt(vohead_id)), 0) INTO _amount
  FROM vohead
  WHERE (vohead_id=pVoucherid);

  RETURN _amount;

END;
$_$;


ALTER FUNCTION public.calcvouchertax(integer) OWNER TO admin;

--
-- Name: calcwooperstartstub(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION calcwooperstartstub(integer, integer) RETURNS date
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWoId         ALIAS FOR $1;
  pBooitemSeqId ALIAS FOR $2;
  _result       DATE;
BEGIN

  IF ( SELECT ((metric_value='t') AND packageIsEnabled('xtmfg'))
         FROM metric
        WHERE(metric_name='Routings') ) THEN
    RETURN xtmfg.calcWooperStart(pWoId, pBooitemSeqId);
  END IF;
  RETURN null;
END;
$_$;


ALTER FUNCTION public.calcwooperstartstub(integer, integer) OWNER TO admin;

--
-- Name: cancelbillingselection(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION cancelbillingselection(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCobmiscid ALIAS FOR $1;

BEGIN

  IF ( ( SELECT cobmisc_posted
         FROM cobmisc
         WHERE (cobmisc_id=pCobmiscid) ) ) THEN
    RETURN -1;
  END IF;

  DELETE FROM cobill
  WHERE (cobill_cobmisc_id=pCobmiscid); 

  DELETE FROM cobmisc
  WHERE (cobmisc_id=pCobmiscid);

  RETURN 1;

END;
$_$;


ALTER FUNCTION public.cancelbillingselection(integer) OWNER TO admin;

--
-- Name: changeaccountingperioddates(integer, date, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changeaccountingperioddates(integer, date, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pPeriodid ALIAS FOR $1;
  pStartDate ALIAS FOR $2;
  pEndDate ALIAS FOR $3;
  _check INTEGER;
  _r RECORD;

BEGIN

--  Check to make sure that the passed period is not closed
  IF ( ( SELECT period_closed
         FROM period
         WHERE (period_id=pPeriodid) ) ) THEN
    RETURN -1;
  END IF;

--  Check to make sure that the passed start date does not fall
--  into another period
  SELECT period_id INTO _check
  FROM period
  WHERE ( (pStartDate BETWEEN period_start AND period_end)
    AND (period_id <> pPeriodid) )
  LIMIT 1;
  IF (FOUND) THEN
    RETURN -2;
  END IF;

--  Check to make sure that the passed end date does not fall
--  into another period
  SELECT period_id INTO _check
  FROM period
  WHERE ( (pEndDate BETWEEN period_start AND period_end)
    AND (period_id <> pPeriodid) )
  LIMIT 1;
  IF (FOUND) THEN
    RETURN -3;
  END IF;

--  Check to make sure that the new passed start and end dates do not
--  orphan a posted G/L Transaction
  SELECT gltrans_id INTO _check
  FROM gltrans, period
  WHERE ( (gltrans_date BETWEEN period_start AND period_end)
   AND (gltrans_posted)
   AND (NOT (gltrans_date BETWEEN pStartDate AND pEndDate))
   AND (period_id=pPeriodid) )
  LIMIT 1;
  IF (FOUND) THEN
    RETURN -4;
  END IF;

--  Alter the start and end dates of the pass period
  UPDATE period
  SET period_start=pStartDate, period_end=pEndDate
  WHERE (period_id=pPeriodid);

--  Post any unposted G/L Transactions into the period
  FOR _r IN SELECT DISTINCT gltrans_sequence
            FROM gltrans
            WHERE ( (NOT gltrans_posted)
             AND (gltrans_date BETWEEN pStartDate AND pEndDate) ) LOOP
    PERFORM postIntoTrialBalance(_r.gltrans_sequence);
  END LOOP;

--  All done
  RETURN 1;

END;
$_$;


ALTER FUNCTION public.changeaccountingperioddates(integer, date, date) OWNER TO admin;

--
-- Name: changeaccountingyearperioddates(integer, date, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changeaccountingyearperioddates(integer, date, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pPeriodid ALIAS FOR $1;
  pStartDate ALIAS FOR $2;
  pEndDate ALIAS FOR $3;
  _check INTEGER;
  _checkBool BOOLEAN;
  _r RECORD;

BEGIN

--  Check to make sure that the passed yearperiod is not closed
  IF ( ( SELECT yearperiod_closed
         FROM yearperiod
         WHERE (yearperiod_id=pPeriodid) ) ) THEN
    RETURN -1;
  END IF;

--  Check to make sure that the passed start date does not fall
--  into another yearperiod
  SELECT yearperiod_id INTO _check
  FROM yearperiod
  WHERE ( (pStartDate BETWEEN yearperiod_start AND yearperiod_end)
    AND (yearperiod_id <> pPeriodid) )
  LIMIT 1;
  IF (FOUND) THEN
    RETURN -2;
  END IF;

--  Check to make sure that the passed end date does not fall
--  into another yearperiod
  SELECT yearperiod_id INTO _check
  FROM yearperiod
  WHERE ( (pEndDate BETWEEN yearperiod_start AND yearperiod_end)
    AND (yearperiod_id <> pPeriodid) )
  LIMIT 1;
  IF (FOUND) THEN
    RETURN -3;
  END IF;

--  Check to make sure that the passed yearperiod is not closed
  IF ( ( SELECT (count(period_id) > 0)
         FROM period
         WHERE ((period_yearperiod_id=pPeriodid)
          AND (period_start < pStartDate OR period_end > pEndDate)) ) ) THEN
    RETURN -4;
  END IF;

--  Make sure that the passed start is prior to the end date
  SELECT (pStartDate > pEndDate) INTO _checkBool;
  IF (_checkBool) THEN
    RETURN -5;
  END IF;


--  Alter the start and end dates of the pass period
  UPDATE yearperiod
  SET yearperiod_start=pStartDate, yearperiod_end=pEndDate
  WHERE (yearperiod_id=pPeriodid);

--  All done
  RETURN 1;

END;
$_$;


ALTER FUNCTION public.changeaccountingyearperioddates(integer, date, date) OWNER TO admin;

--
-- Name: changefkeypointers(text, text, integer, integer, text[], boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changefkeypointers(text, text, integer, integer, text[], boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSchema       ALIAS FOR $1;
  pTable        ALIAS FOR $2;
  pSourceId     ALIAS FOR $3;
  pTargetId     ALIAS FOR $4;
  pIgnore       ALIAS FOR $5;
  _purge        BOOLEAN := COALESCE($6, FALSE);

  _counter      INTEGER := 0;
  _count1       INTEGER := 0;
  _fk           RECORD;
  _pk           TEXT[];

BEGIN
  -- for all foreign keys that point to pSchema.pTable
  FOR _fk IN
    EXECUTE 'SELECT fkeyns.nspname AS schemaname, fkeytab.relname AS tablename,
                    conkey, attname, typname
               FROM pg_constraint
               JOIN pg_class     basetab ON (confrelid=basetab.oid)
               JOIN pg_namespace basens  ON (basetab.relnamespace=basens.oid)
               JOIN pg_class     fkeytab ON (conrelid=fkeytab.oid)
               JOIN pg_namespace fkeyns  ON (fkeytab.relnamespace=fkeyns.oid)
               JOIN pg_attribute         ON (attrelid=conrelid AND attnum=conkey[1])
               JOIN pg_type              ON (atttypid=pg_type.oid)
              WHERE basetab.relname = ' || quote_literal(pTable)  || '
                AND basens.nspname  = ' || quote_literal(pSchema) || '
                AND fkeytab.relname NOT IN (''' || ARRAY_TO_STRING(pIgnore, ''', ''') || ''')'
  LOOP
    IF (ARRAY_UPPER(_fk.conkey, 1) > 1) THEN
      RAISE EXCEPTION 'Cannot change the foreign key in %.% that refers to %.% because the foreign key constraint has multiple columns. [xtuple: changefkeypointers, -1, %.%, %.%]',
        _fk.schemaname, _fk.tablename, pSchema, pTable,
        _fk.schemaname, _fk.tablename, pSchema, pTable;
    END IF;
    
    -- optionally make a backup copy of the data
    IF (NOT _purge) THEN
      -- determine the primary key column of the fkey table
      _pk := primaryKeyFields(_fk.schemaname, _fk.tablename);
      IF (ARRAY_UPPER(_pk, 1) > 1) THEN
        RAISE EXCEPTION 'Cannot change foreign key references in %.% because it has a composite primary key. Try setting the purge option. [xtuple: changefkeypointers, -4, %.%]',
                        _fk.schemaname, _fk.tablename, _fk.schemaname, _fk.tablename;
      END IF;

      -- make the backup copy
      EXECUTE 'INSERT INTO mrgundo (
                     mrgundo_schema,      mrgundo_table,
                     mrgundo_pkey_col,    mrgundo_pkey_id,
                     mrgundo_col,         mrgundo_value,      mrgundo_type,
                     mrgundo_base_schema, mrgundo_base_table, mrgundo_base_id
             ) SELECT ' || quote_literal(_fk.schemaname) || ', '
                        || quote_literal(_fk.tablename)  || ', '
                        || quote_literal(_pk[1])         || ', ' 
                        || _pk[1]                        || ', '
                        || quote_literal(_fk.attname)    || ', ' 
                        || _fk.attname                   || ', ' 
                        || quote_literal(_fk.typname)    || ', '
                        || quote_literal(pSchema)        || ', '
                        || quote_literal(pTable)         || ', '
                        || pTargetId                     || '
                 FROM ' || _fk.schemaname || '.' || _fk.tablename ||
              ' WHERE ('|| _fk.attname    || '=' || pSourceId || ');';
    END IF;

    -- actually change the foreign keys to point to the desired base table record
    EXECUTE 'UPDATE '  || _fk.schemaname || '.' || _fk.tablename ||
              ' SET '  || _fk.attname    || '=' || pTargetId ||
            ' WHERE (' || _fk.attname    || '=' || pSourceId || ');';

    GET DIAGNOSTICS _count1 = ROW_COUNT;
    _counter := _counter + _count1;
  END LOOP;

  RETURN _counter;
END;
$_$;


ALTER FUNCTION public.changefkeypointers(text, text, integer, integer, text[], boolean) OWNER TO admin;

--
-- Name: FUNCTION changefkeypointers(text, text, integer, integer, text[], boolean); Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON FUNCTION changefkeypointers(text, text, integer, integer, text[], boolean) IS 'Change the data in all tables with foreign key relationships so they point to the pSchema.pTable record with primary key pTargetId instead of the record with primary key pSourceId. Ignore any tables listed in pIgnore. If the final arg is TRUE, make a backup copy of the original data in the mrgundo table.';


--
-- Name: changepoitemduedate(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changepoitemduedate(ppoitemid integer, pdate date) RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  RETURN changePoitemDueDate(pPoitemid, pDate, false);

END;
$$;


ALTER FUNCTION public.changepoitemduedate(ppoitemid integer, pdate date) OWNER TO admin;

--
-- Name: changepoitemduedate(integer, date, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changepoitemduedate(ppoitemid integer, pdate date, pbyso boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  IF ( ( SELECT (poitem_status IN ('C'))
         FROM poitem
         WHERE (poitem_id=pPoitemid) ) ) THEN
    RETURN -1;
  END IF;

  UPDATE poitem
  SET poitem_duedate=pDate
  WHERE (poitem_id=pPoitemid);

  IF (pBySO) THEN
    --Generate the PoItemUpdatedBySo event
    INSERT INTO evntlog
                ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                  evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id,
                  evntlog_number )
    SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
           'P', poitem_id, itemsite_warehous_id,
            (pohead_number || '-'|| poitem_linenumber || ': ' || item_number)
    FROM evntnot JOIN evnttype ON (evntnot_evnttype_id=evnttype_id)
                 JOIN itemsite ON (evntnot_warehous_id=itemsite_warehous_id)
                 JOIN item ON (itemsite_item_id=item_id)
                 JOIN poitem ON (poitem_itemsite_id=itemsite_id)
                 JOIN pohead ON (poitem_pohead_id=pohead_id)
            WHERE( (poitem_id=pPoitemid)
            AND (poitem_duedate <= (CURRENT_DATE + itemsite_eventfence))
            AND (evnttype_name='PoItemUpdatedBySo') );
  END IF;

  RETURN pPoitemid;

END;
$$;


ALTER FUNCTION public.changepoitemduedate(ppoitemid integer, pdate date, pbyso boolean) OWNER TO admin;

--
-- Name: changepoitemqty(integer, numeric); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changepoitemqty(ppoitemid integer, pqty numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN

  RETURN changePoitemQty(pPoitemid, pQty, false);

END;
$$;


ALTER FUNCTION public.changepoitemqty(ppoitemid integer, pqty numeric) OWNER TO admin;

--
-- Name: changepoitemqty(integer, numeric, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changepoitemqty(ppoitemid integer, pqty numeric, pbyso boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE

BEGIN

  IF ( ( SELECT (poitem_status IN ('C'))
         FROM poitem
         WHERE (poitem_id=pPoitemid) ) ) THEN
    RETURN -1;
  END IF;

  UPDATE poitem
  SET poitem_qty_ordered=pQty
  WHERE (poitem_id=pPoitemid);

  IF (pBySO) THEN
    --Generate the PoItemUpdatedBySo event
    INSERT INTO evntlog
                ( evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                  evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id,
                  evntlog_number )
    SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
           'P', poitem_id, itemsite_warehous_id,
            (pohead_number || '-'|| poitem_linenumber || ': ' || item_number)
    FROM evntnot JOIN evnttype ON (evntnot_evnttype_id=evnttype_id)
                 JOIN itemsite ON (evntnot_warehous_id=itemsite_warehous_id)
                 JOIN item ON (itemsite_item_id=item_id)
                 JOIN poitem ON (poitem_itemsite_id=itemsite_id)
                 JOIN pohead ON (poitem_pohead_id=pohead_id)
            WHERE( (poitem_id=pPoitemid)
            AND (poitem_duedate <= (CURRENT_DATE + itemsite_eventfence))
            AND (evnttype_name='PoItemUpdatedBySo') );
  END IF;

  RETURN pPoitemid;

END;
$$;


ALTER FUNCTION public.changepoitemqty(ppoitemid integer, pqty numeric, pbyso boolean) OWNER TO admin;

--
-- Name: changeprdate(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changeprdate(integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pPrid ALIAS FOR $1;
  pDueDate ALIAS FOR $2;

BEGIN

  UPDATE pr
  SET pr_duedate=pDueDate
  WHERE (pr_id=pPrid);

  RETURN 0;

END;
$_$;


ALTER FUNCTION public.changeprdate(integer, date) OWNER TO admin;

--
-- Name: changeprqty(integer, numeric); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changeprqty(integer, numeric) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pPrid ALIAS FOR $1;
  pQty ALIAS FOR $2;

BEGIN

  UPDATE pr
  SET pr_qtyreq=pQty
  WHERE (pr_id=pPrid);

  RETURN TRUE;

END;
$_$;


ALTER FUNCTION public.changeprqty(integer, numeric) OWNER TO admin;

--
-- Name: changeprqty(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changeprqty(integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
  pPrid ALIAS FOR $1;
  pDueDate ALIAS FOR $2;

BEGIN

  UPDATE pr
  SET pr_duedate=pDueDate
  WHERE (pr_id=pPrid);

  RETURN 0;

END;
$_$;


ALTER FUNCTION public.changeprqty(integer, date) OWNER TO admin;

--
-- Name: changepseudofkeypointers(text, text, text, integer, text, text, integer, text, text, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changepseudofkeypointers(text, text, text, integer, text, text, integer, text, text, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSchema       ALIAS FOR $1;
  pTable        ALIAS FOR $2;
  pFkeyCol      ALIAS FOR $3;
  pSourceId     ALIAS FOR $4;
  pBaseSchema   ALIAS FOR $5;
  pBaseTable    ALIAS FOR $6;
  pTargetId     ALIAS FOR $7;
  pTypeCol      ALIAS FOR $8;
  pType         ALIAS FOR $9;
  _purge        BOOLEAN := COALESCE($10, FALSE);

  _counter      INTEGER := 0;
  _coltype      TEXT;
  _pk           TEXT[];

BEGIN
  IF (NOT _purge) THEN
    EXECUTE 'SELECT typname
               FROM pg_type
               JOIN pg_attribute ON (pg_type.oid=atttypid)
               JOIN pg_class     ON (attrelid=pg_class.oid)
               JOIN pg_namespace ON (relnamespace=pg_namespace.oid)
              WHERE (relname=' || quote_literal(pTable)   || ')
                AND (nspname=' || quote_literal(pSchema)  || ')
                AND (attname=' || quote_literal(pFkeyCol) || ')' INTO _coltype;

    _pk := primaryKeyFields(pSchema, pTable);
    IF (ARRAY_UPPER(_pk, 1) > 1) THEN
       RAISE EXCEPTION 'Cannot change pseudo-foreign key references in %.% because it has a composite primary key. Try setting the purge option. [xtuple: changepseudofkeypointers, -1, %.%',
                        pSchema, pTable, pSchema, pTable;
    END IF;

    EXECUTE 'INSERT INTO mrgundo (
                     mrgundo_schema,      mrgundo_table,
                     mrgundo_pkey_col,    mrgundo_pkey_id,
                     mrgundo_col,         mrgundo_value,      mrgundo_type,
                     mrgundo_base_schema, mrgundo_base_table, mrgundo_base_id
           ) SELECT ' || quote_literal(pSchema)     || ', '
                      || quote_literal(pTable)      || ', '
                      || quote_literal(_pk[1])      || ', ' 
                      || quote_ident(_pk[1])        || ', '
                      || quote_literal(pFkeyCol)    || ', ' 
                      || quote_ident(pFkeyCol)      || ', ' 
                      || quote_literal(_coltype)    || ', '
                      || quote_literal(pBaseSchema) || ', '
                      || quote_literal(pBaseTable)  || ', '
                      || pTargetId                  || '
               FROM '  || quote_ident(pSchema)  || '.' || quote_ident(pTable) || '
              WHERE (('|| quote_ident(pFkeyCol) || '=' || pSourceId || ')
                 AND ('|| quote_ident(pTypeCol) || '=' || quote_literal(pType) || '));';
  END IF;

  -- actually change the foreign keys to point to the desired base table record
  EXECUTE 'UPDATE '  || quote_ident(pSchema)  || '.' || quote_ident(pTable) ||
            ' SET '  || quote_ident(pFkeyCol) || '=' || pTargetId ||
          ' WHERE ((' || quote_ident(pFkeyCol) || '=' || pSourceId || ')
               AND (' || quote_ident(pTypeCol) || '=' || quote_literal(pType) || '));';

  GET DIAGNOSTICS _counter = ROW_COUNT;

  RETURN _counter;
END;
$_$;


ALTER FUNCTION public.changepseudofkeypointers(text, text, text, integer, text, text, integer, text, text, boolean) OWNER TO admin;

--
-- Name: FUNCTION changepseudofkeypointers(text, text, text, integer, text, text, integer, text, text, boolean); Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON FUNCTION changepseudofkeypointers(text, text, text, integer, text, text, integer, text, text, boolean) IS 'Change the data in pSchema.pTable with a pseudo-foreign key relationship to another (unnamed) table. Make pSchema.pTable point to the record with primary key pTargetId instead of the record with primary key pSourceId. pSchema.pTable cannot have a true foreign key relationship because it holds data that can point to any of several tables. The pType value in the pTypeCol column describes which table the data refer to (e.g. "T" may indicate that the current record refers to a "cntct"). If the final arg is TRUE, make a backup copy of the data in the mrgundo table.';


--
-- Name: changewodates(integer, date, date, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changewodates(integer, date, date, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE 
  pWoid ALIAS FOR $1;
  pStartDate ALIAS FOR $2;
  pDueDate ALIAS FOR $3;
  changeChildren ALIAS FOR $4;
  _p RECORD;
  returnCode INTEGER;
  _vtemp NUMERIC;

BEGIN

  SELECT wo_status, wo_startdate, itemsite_warehous_id INTO _p
  FROM wo
  Inner Join itemsite on
      wo_itemsite_id=itemsite_id
  WHERE (wo_id=pWoid);

  IF (_p.wo_status = 'C') THEN 
    returnCode := 0;

  ELSIF (_p.wo_status IN ('R','I')) THEN
    INSERT INTO evntlog (evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                         evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number,
                         evntlog_olddate, evntlog_newdate)
    SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
           'W', wo_id, itemsite_warehous_id, formatWoNumber(wo_id),
           wo_duedate, pDueDate
    FROM evntnot, evnttype, itemsite, item, wo
    WHERE ( (evntnot_evnttype_id=evnttype_id)
     AND (evntnot_warehous_id=itemsite_warehous_id)
     AND (wo_itemsite_id=itemsite_id)
     AND (itemsite_item_id=item_id)
     AND (evnttype_name='RWoDueDateRequestChange')
     AND (wo_id=pWoid) );

     returnCode := 0;

  END IF;
  
--  Reschedule operations if routings enabled
  IF (fetchMetricBool('Routings')) THEN

--    Reschedule wooper
    IF (fetchMetricBool('UseSiteCalendar')) THEN
      UPDATE xtmfg.wooper
      SET wooper_scheduled = calculatenextworkingdate(itemsite_warehous_id,DATE(pStartDate),
                             CAST(calculateworkdays(itemsite_warehous_id, DATE(wo_startdate), DATE(wooper_scheduled)) as INTEGER))
      FROM wo JOIN itemsite ON (wo_itemsite_id=itemsite_id)
      WHERE ( (wooper_wo_id=wo_id)
        AND   (wo_id=pWoid) );
    ELSE
      UPDATE xtmfg.wooper
      SET wooper_scheduled = (wooper_scheduled::DATE + (pStartDate - wo_startdate))
      FROM wo
      WHERE ( (wooper_wo_id=wo_id)
        AND   (wo_id=pWoid) );
    END IF;

--    Reschedule any womatl that is linked to wooper items
--    and is set to be scheduled with the wooper in question
    UPDATE womatl
    SET womatl_duedate=wooper_scheduled
    FROM xtmfg.wooper
    WHERE ( (womatl_schedatwooper)
     AND (womatl_wooper_id=wooper_id)
     AND (womatl_wo_id=pWoid) );

  END IF;

-- Reschedule any womatl that is not linked to wooper items
  UPDATE womatl
  SET womatl_duedate=pStartDate
  WHERE ( (NOT womatl_schedatwooper)
   AND (womatl_wo_id=pWoid) );

--  Reschedule the W/O
  UPDATE wo
  SET wo_startdate=pStartDate,
      wo_duedate=pDueDate
  WHERE (wo_id=pWoid);

--  Do the same for the children
  IF (changeChildren) THEN
    SELECT MAX(changeWoDates(wo_id, (pStartDate - itemsite_leadtime), pStartDate, TRUE)) INTO returnCode
    FROM wo, itemsite
    WHERE ( (wo_itemsite_id=itemsite_id)
     AND (wo_ordtype='W')
     AND (wo_ordid=pWoid) );
  END IF;

  IF (returnCode IS NULL) THEN
    returnCode := 0;
  END IF;

  RETURN returnCode;

END;
$_$;


ALTER FUNCTION public.changewodates(integer, date, date, boolean) OWNER TO admin;

--
-- Name: changewoproject(integer, integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changewoproject(integer, integer, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWoid ALIAS FOR $1;
  pPrjid ALIAS FOR $2;
  changeChildren ALIAS FOR $3;
  woStatus CHAR(1);
  _result INTEGER;

BEGIN

  SELECT wo_status INTO woStatus
  FROM wo
  WHERE (wo_id=pWoid);

  UPDATE wo
  SET wo_prj_id=pPrjid
  WHERE (wo_id=pWoid);

  IF (woStatus = 'E' AND changeChildren) THEN
    _result := ( SELECT MIN(changeWoProject(wo_id, pPrjid, TRUE))
                   FROM womatl, wo
                  WHERE ((womatl_itemsite_id=wo_itemsite_id)
                    AND (wo_ordtype='W')
                    AND (womatl_wo_id=pWoid)
                    AND (wo_ordid=pWoid)) );

    UPDATE pr SET pr_prj_id=pPrjid
      FROM womatl
     WHERE ((womatl_wo_id=pWoid)
       AND  (pr_order_type='W')
       AND  (pr_order_id=womatl_id));
  ELSE
    _result = 1;
  END IF;

  RETURN _result;
END;
$_$;


ALTER FUNCTION public.changewoproject(integer, integer, boolean) OWNER TO admin;

--
-- Name: changewoqty(integer, numeric, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION changewoqty(integer, numeric, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWoid ALIAS FOR $1;
  pQty ALIAS FOR $2;
  changeChildren ALIAS FOR $3;
  _r RECORD;
  _result INTEGER := 1;

BEGIN

  SELECT wo_qtyord, wo_status, item_fractional INTO _r
  FROM wo JOIN itemsite ON (itemsite_id=wo_itemsite_id)
          JOIN item ON (item_id=itemsite_item_id)
  WHERE (wo_id=pWoid);

  IF (_r.wo_qtyord = pQty) THEN
    RETURN 0;
  END IF;

  IF (NOT _r.wo_status IN ('O','E','R','I')) THEN
    RETURN 1;
  END IF;

  IF (_r.wo_status IN ('R','I')) THEN
    INSERT INTO evntlog (evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                         evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number,
                         evntlog_oldvalue, evntlog_newvalue)
    SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
           'W', wo_id, itemsite_warehous_id, formatWoNumber(wo_id),
           wo_qtyord, pQty
    FROM evntnot, evnttype, itemsite, item, wo
    WHERE ( (evntnot_evnttype_id=evnttype_id)
     AND (evntnot_warehous_id=itemsite_warehous_id)
     AND (wo_itemsite_id=itemsite_id)
     AND (itemsite_item_id=item_id)
     AND (evnttype_name='RWoQtyRequestChange')
     AND (wo_id=pWoid) );

     _result = 0;
  END IF;

  UPDATE wo
  SET wo_qtyord=roundQty(_r.item_fractional, pQty)
  WHERE (wo_id=pWoid);

  UPDATE womatl
  SET womatl_qtyreq=(womatl_qtyfxd + wo_qtyord * womatl_qtyper) * (1 + womatl_scrap)
  FROM wo, itemsite
  WHERE ((womatl_wo_id=wo_id)
    AND  (womatl_itemsite_id=itemsite_id)
    AND  (wo_id=pWoid));

  IF (fetchMetricBool('Routings')) THEN

      UPDATE xtmfg.wooper
         SET wooper_rntime = CASE WHEN ((booitem_rnqtyper = 0) OR (booitem_invproduomratio = 0)) THEN 0
                                  WHEN (NOT booitem_rnrpt) THEN 0
                                  ELSE ( ( booitem_rntime /
                                           booitem_rnqtyper /
                                           booitem_invproduomratio ) * wo_qtyord )
                             END
        FROM xtmfg.booitem, wo
       WHERE ((wooper_wo_id=wo_id)
         AND  (wooper_booitem_id=booitem_id)
         AND  (wo_id=pWoid));
  END IF;

  IF (changeChildren) THEN
    _result := ( SELECT MIN(changeWoQty(wo_id, womatl_qtyreq, TRUE))
                 FROM womatl, wo
                 WHERE ((womatl_itemsite_id=wo_itemsite_id)
                  AND (wo_ordtype='W')
                  AND (womatl_wo_id=pWoid)
                  AND (wo_ordid=pWoid)) );
  END IF;

  RETURN _result;
END;
$_$;


ALTER FUNCTION public.changewoqty(integer, numeric, boolean) OWNER TO admin;

--
-- Name: characteristicstostring(text, integer, text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION characteristicstostring(text, integer, text, text) RETURNS text
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pTargetType ALIAS FOR $1;
  pTargetId ALIAS FOR $2;
  pValKeySep ALIAS FOR $3;
  pPairSep ALIAS FOR $4;
  _string TEXT := '';
  _extra BOOLEAN := false;
  _r RECORD;
BEGIN
  FOR _r IN SELECT char_name, charass_value
              FROM charass, char
             WHERE ((charass_char_id=char_id)
               AND  (charass_target_type=pTargetType)
               AND  (charass_target_id=pTargetId)) LOOP
    IF(_extra) THEN
      _string := _string || pPairSep;
    END IF;
    _extra := true;

    _string := _string || _r.char_name || pValKeySep || _r.charass_value;
  END LOOP;

  RETURN _string;
END;
$_$;


ALTER FUNCTION public.characteristicstostring(text, integer, text, text) OWNER TO admin;

--
-- Name: checkcreditmemositeprivs(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION checkcreditmemositeprivs(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCmheadid ALIAS FOR $1;
  _check    BOOLEAN;
  _result   INTEGER;

BEGIN

  IF (NOT fetchMetricBool('MultiWhs')) THEN
    RETURN true;
  END IF;

  IF (NOT fetchUsrPrefBool('selectedSites')) THEN
    RETURN true;
  END IF;

  SELECT COALESCE(COUNT(*), 0) INTO _result
    FROM ( SELECT cmitem_id
             FROM cmitem JOIN itemsite ON (itemsite_id=cmitem_itemsite_id)
            WHERE ( (cmitem_cmhead_id=pCmheadid)
              AND   (itemsite_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                    FROM usrsite
                                                   WHERE (usrsite_username=getEffectiveXtUser()))) )
         ) AS data;
  IF (_result > 0) THEN
    RETURN false;
  END IF;

  RETURN true;
END;
$_$;


ALTER FUNCTION public.checkcreditmemositeprivs(integer) OWNER TO admin;

--
-- Name: checkdetailformatted(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION checkdetailformatted(integer, integer) RETURNS SETOF checkdata
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCheckheadid ALIAS FOR $1;
  pMaxLines ALIAS FOR $2;
  _row checkdata%ROWTYPE;
  _checkhead RECORD;
  _checkdetail RECORD;
  _rowcount INTEGER := 0;
  _page INTEGER := 1;
  _docnumber TEXT := '';
  _docreference TEXT := '';
  _docdate TEXT := '';
  _docamount TEXT := '';
  _docdiscount TEXT := '';
  _docnetamount TEXT := '';
BEGIN

-- Check header information
  SELECT checkhead_number AS checknumber,
         INITCAP(spellAmount(checkhead_amount, curr_id)) AS checkwords,
         formatDate(checkhead_checkdate) AS checkdate,
         formatMoney(checkhead_amount) AS checkamount,
         curr_symbol AS checkcurrsymbol,
         curr_abbr AS checkcurrabbr,
         curr_name AS checkcurrname,
         CASE WHEN checkhead_recip_type = 'C' THEN (SELECT cust_name
                                                      FROM custinfo
                                                     WHERE cust_id=checkhead_recip_id)
              WHEN checkhead_recip_type = 'T' THEN (SELECT taxauth_name
                                                      FROM taxauth
                                                     WHERE taxauth_id=checkhead_recip_id)
              WHEN checkhead_recip_type = 'V' THEN
                                  COALESCE((SELECT vendaddr_name
                                              FROM vendaddrinfo
                                             WHERE((UPPER(vendaddr_code)='REMIT')
                                               AND (vendaddr_vend_id=checkhead_recip_id))),
                                           (SELECT vend_name
                                              FROM vendinfo
                                             WHERE(vend_id=checkhead_recip_id)))
         END AS checkpayto,
         formatAddr(CASE WHEN checkhead_recip_type = 'C' THEN
                                                  (SELECT cntct_addr_id
                                                   FROM cntct, custinfo
                                                    WHERE((cust_cntct_id=cntct_id)
                                                      AND (cust_id=checkhead_recip_id)))
                         WHEN checkhead_recip_type = 'T' THEN 
                                                  (SELECT taxauth_addr_id
                                                     FROM taxauth
                                                    WHERE(taxauth_id=checkhead_recip_id))
                         WHEN checkhead_recip_type = 'V' THEN
                                 COALESCE((SELECT vendaddr_addr_id
                                             FROM vendaddrinfo
                                            WHERE((UPPER(vendaddr_code)='REMIT')
                                              AND (vendaddr_vend_id=checkhead_recip_id))),
                                          (SELECT vend_addr_id
                                             FROM vendinfo
                                            WHERE(vend_id=checkhead_recip_id)))
                    END) AS checkaddress,
         checkhead_for AS checkmemo
    INTO _checkhead
    FROM checkhead, curr_symbol
   WHERE((checkhead_curr_id = curr_id)
     AND (checkhead_id=pCheckheadid) );
  IF (NOT FOUND) THEN
    RETURN;
  END IF;

  _row.checkdata_page := _page;
  _row.checkdata_checknumber := _checkhead.checknumber;
  _row.checkdata_checkwords := _checkhead.checkwords;
  _row.checkdata_checkdate := _checkhead.checkdate;
  _row.checkdata_checkamount := _checkhead.checkamount;
  _row.checkdata_checkcurrsymbol := _checkhead.checkcurrsymbol;
  _row.checkdata_checkcurrabbr := _checkhead.checkcurrabbr;
  _row.checkdata_checkcurrname := _checkhead.checkcurrname;
  _row.checkdata_checkpayto := _checkhead.checkpayto;
  _row.checkdata_checkaddress := _checkhead.checkaddress;
  _row.checkdata_checkmemo := _checkhead.checkmemo;

-- Check item details
  FOR _checkdetail IN 
  SELECT  --VOUCHER-------------
    1 AS ord,
    1 AS sequence_value,
    checkitem_invcnumber,
    checkitem_ponumber,
    formatMoney(checkitem_amount) AS docnetamount,
    'Invoice#: ' || vohead_invcnumber AS docnumber,
    formatDate(vohead_docdate) AS docdate,
    vohead_reference AS docreference,
    'Voucher: ' || checkitem_vouchernumber AS vouchernumber,
    formatMoney(apopen_amount) AS docamount,
    formatMoney(checkitem_discount) AS docdiscount
  FROM checkitem, vohead, apopen
  WHERE ((checkitem_checkhead_id=pCheckheadid)
    AND  (checkitem_vouchernumber = vohead_number)
    AND  (apopen_docnumber = checkitem_vouchernumber)
    AND  (apopen_doctype = 'V'))
  
  UNION
  
  SELECT --DEBIT MEMO -------------------------
    2 AS ord,
    1 AS sequence_value,
    checkitem_invcnumber,
    checkitem_ponumber,
    formatMoney(checkitem_amount) AS f_amount,
    'Debit Memo PO#: ' || checkitem_ponumber AS doc_number,
    ''  AS f_docdate,
    'Debit Memo: ' || checkitem_vouchernumber AS doc_reference,
    checkitem_vouchernumber AS vouchernumber,
    formatMoney(apopen_amount) AS amount,
    formatMoney(checkitem_discount) AS disc_cred
  FROM checkitem, apopen
  WHERE ((checkitem_checkhead_id=pCheckheadid)
    AND  (checkitem_vouchernumber = apopen_docnumber)
    AND  (apopen_doctype = 'D'))
  
  UNION
  
  SELECT --CREDITs--------------------------
    3 AS ord,
    1 AS sequence_value,
    checkitem_invcnumber,
    checkitem_ponumber,
    formatMoney(checkitem_amount) AS f_amount,
    'Invoice#: ' || vohead_invcnumber AS doc_number,
    formatDate(vohead_docdate) AS f_docdate,
    'Credit Applied: ' || apapply_source_doctype || ' ' ||
                          apapply_source_docnumber AS doc_reference,
    'Voucher ' || checkitem_vouchernumber AS vouchernumber,
    '' AS amount,
    formatMoney((apapply_amount)) AS disc_cred
  FROM checkitem, vohead, apapply
  WHERE ((checkitem_checkhead_id=pCheckheadid)
    AND  (checkitem_vouchernumber = vohead_number)
    AND  (apapply_target_docnumber = checkitem_vouchernumber ))
  
  UNION 
  
  SELECT --NON-VENDOR-----------------------
    4 AS ord,
    1 AS sequence_value,
    checkitem_invcnumber,
    checkitem_ponumber,
    formatMoney(checkitem_amount) AS f_amount,
    checkitem_invcnumber AS doc_number,
    formatDate(checkitem_docdate) AS f_docdate,
    '' AS doc_reference,
    '' AS vouchernumber,
    '' AS amount,
    '' AS disc_cred
  FROM checkhead LEFT OUTER JOIN
       checkitem ON (checkitem_checkhead_id=checkhead_id)
  WHERE ((checkhead_id=pCheckheadid) 
    AND  (checkhead_recip_type != 'V')) LOOP
    IF (_rowcount = pMaxLines) THEN
      _row.checkdata_docnumber := _docnumber;
      _row.checkdata_docreference := _docreference;
      _row.checkdata_docdate := _docdate;
      _row.checkdata_docamount := _docamount;
      _row.checkdata_docdiscount := _docdiscount;
      _row.checkdata_docnetamount := _docnetamount;
      RETURN NEXT _row;

-- update/reset some variables
      _rowcount = 0;
      _page := _page + 1;
      _docnumber := '';
      _docreference := '';
      _docdate := '';
      _docamount := '';
      _docdiscount := '';
      _docnetamount := '';

      _row.checkdata_page := _page;
      _row.checkdata_checknumber := _checkhead.checknumber;
      _row.checkdata_checkwords := 'VOID VOID PAGE '||_page||' OF CHECK #'||_checkhead.checknumber||' VOID VOID';
      _row.checkdata_checkdate := 'VOID VOID VOID';
      _row.checkdata_checkamount := 'VOID VOID VOID';
      --_row.checkdata_checkcurrsymbol := _checkhead.checkcurrsymbol;
      --_row.checkdata_checkcurrabbr := _checkhead.checkcurrabbr;
      --_row.checkdata_checkcurrname := _checkhead.checkcurrname;
      _row.checkdata_checkpayto := 'VOID VOID VOID';
      --_row.checkdata_checkaddress := _checkhead.checkaddress;
      _row.checkdata_checkmemo := 'VOID VOID PAGE '||_page||' OF CHECK #'||_checkhead.checknumber||' VOID VOID';
    END IF;

    _rowcount := _rowcount + 1;
    _docnumber := _docnumber || _checkdetail.docnumber || E'\n';
    _docreference := _docreference || _checkdetail.docreference || E'\n';
    _docdate := _docdate || _checkdetail.docdate || E'\n';
    _docamount := _docamount || _checkdetail.docamount || E'\n';
    _docdiscount := _docdiscount || _checkdetail.docdiscount || E'\n';
    _docnetamount := _docnetamount || _checkdetail.docnetamount || E'\n';
  END LOOP;

  _row.checkdata_docnumber := _docnumber;
  _row.checkdata_docreference := _docreference;
  _row.checkdata_docdate := _docdate;
  _row.checkdata_docamount := _docamount;
  _row.checkdata_docdiscount := _docdiscount;
  _row.checkdata_docnetamount := _docnetamount;

  RETURN NEXT _row;
  RETURN;
END;
$_$;


ALTER FUNCTION public.checkdetailformatted(integer, integer) OWNER TO admin;

--
-- Name: checkinvoicesiteprivs(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION checkinvoicesiteprivs(integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pInvcheadid ALIAS FOR $1;
  _check    BOOLEAN;
  _result   INTEGER;

BEGIN

  IF (NOT fetchMetricBool('MultiWhs')) THEN
    RETURN true;
  END IF;

  IF (NOT fetchUsrPrefBool('selectedSites')) THEN
    RETURN true;
  END IF;

  SELECT COALESCE(COUNT(*), 0) INTO _result
    FROM ( SELECT invcitem_id
             FROM invcitem
            WHERE ( (invcitem_invchead_id=pInvcheadid)
              AND   (invcitem_warehous_id <> -1)
              AND   (invcitem_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                    FROM usrsite
                                                   WHERE (usrsite_username=getEffectiveXtUser()))) )
         ) AS data;
  IF (_result > 0) THEN
    RETURN false;
  END IF;

  RETURN true;
END;
$_$;


ALTER FUNCTION public.checkinvoicesiteprivs(integer) OWNER TO admin;

--
-- Name: checkpositeprivs(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION checkpositeprivs(integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pPoheadid ALIAS FOR $1;
  _check    BOOLEAN;
  _result   INTEGER;

BEGIN

  IF (NOT fetchMetricBool('MultiWhs')) THEN
    RETURN true;
  END IF;

  IF (NOT fetchUsrPrefBool('selectedSites')) THEN
    RETURN true;
  END IF;

  SELECT COALESCE(COUNT(*), 0) INTO _result
    FROM ( SELECT poitem_id
             FROM poitem, itemsite
            WHERE ( (poitem_pohead_id=pPoheadid)
              AND   (poitem_itemsite_id=itemsite_id)
              AND   (itemsite_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                    FROM usrsite
                                                   WHERE (usrsite_username=getEffectiveXtUser()))) )
           UNION
           SELECT pohead_warehous_id
             FROM pohead
            WHERE ( (pohead_id=pPoheadid)
              AND   (pohead_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                  FROM usrsite
                                                 WHERE (usrsite_username=getEffectiveXtUser()))) )
         ) AS data;
  IF (_result > 0) THEN
    RETURN false;
  END IF;

  RETURN true;
END;
$_$;


ALTER FUNCTION public.checkpositeprivs(integer) OWNER TO admin;

--
-- Name: checkprivilege(text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION checkprivilege(text) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pPrivilege ALIAS FOR $1;
  _result TEXT;
BEGIN
  SELECT priv_id INTO _result
    FROM priv, grppriv, usrgrp
   WHERE((usrgrp_grp_id=grppriv_grp_id)
     AND (grppriv_priv_id=priv_id)
     AND (priv_name=pPrivilege)
     AND (usrgrp_username=getEffectiveXtUser()));
  IF (FOUND) THEN
    RETURN true;
  END IF;

  SELECT priv_id INTO _result
  FROM priv, usrpriv
  WHERE ((priv_id=usrpriv_priv_id)
  AND (priv_name=pPrivilege)
  AND (usrpriv_username=getEffectiveXtUser()));
  
  IF (FOUND) THEN
    RETURN true;
  ELSE
    RETURN false;
  END IF;
END;
$_$;


ALTER FUNCTION public.checkprivilege(text) OWNER TO admin;

--
-- Name: checkquotesiteprivs(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION checkquotesiteprivs(integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pQuheadid ALIAS FOR $1;

BEGIN

  RETURN checkQuoteSitePrivs(pQuheadid, NULL);

END;
$_$;


ALTER FUNCTION public.checkquotesiteprivs(integer) OWNER TO admin;

--
-- Name: checkquotesiteprivs(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION checkquotesiteprivs(integer, integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pQuheadid ALIAS FOR $1;
  pWarehousid ALIAS FOR $2;
  _result   INTEGER := 0;

BEGIN

--  RAISE NOTICE 'checkQuoteSitePrivs, pQuheadid = %', pQuheadid;
--  RAISE NOTICE 'checkQuoteSitePrivs, pWarehousid = %', pWarehousid;

  IF (NOT fetchMetricBool('MultiWhs')) THEN
    RETURN true;
  END IF;

  IF ( (NOT fetchUsrPrefBool('selectedSites')) AND (pWarehousid IS NULL) ) THEN
    RETURN true;
  END IF;

  IF (pWarehousid IS NULL) THEN
    SELECT COALESCE(COUNT(*), 0) INTO _result
    FROM quitem JOIN itemsite ON (itemsite_id=quitem_itemsite_id)
                JOIN site() ON (warehous_id=itemsite_warehous_id)
    WHERE (quitem_quhead_id=pQuheadid);
  ELSE
    SELECT COALESCE(COUNT(*), 0) INTO _result
    FROM quitem JOIN itemsite ON (itemsite_id=quitem_itemsite_id)
                JOIN site() ON (warehous_id=itemsite_warehous_id)
    WHERE ( (quitem_quhead_id=pQuheadid)
      AND   (itemsite_warehous_id=pWarehousid) );
  END IF;

  IF (_result > 0) THEN
    RETURN true;
  END IF;

  RETURN false;

END;
$_$;


ALTER FUNCTION public.checkquotesiteprivs(integer, integer) OWNER TO admin;

--
-- Name: checkrasiteprivs(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION checkrasiteprivs(integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pRaheadid ALIAS FOR $1;
  _check    BOOLEAN;
  _result   INTEGER;

BEGIN

  IF (NOT fetchMetricBool('MultiWhs')) THEN
    RETURN true;
  END IF;

  IF (NOT fetchUsrPrefBool('selectedSites')) THEN
    RETURN true;
  END IF;

  SELECT COALESCE(COUNT(*), 0) INTO _result
    FROM ( SELECT raitem_id
             FROM raitem, itemsite
            WHERE ( (raitem_rahead_id=pRaheadid)
              AND   (raitem_itemsite_id=itemsite_id)
              AND   (itemsite_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                    FROM usrsite
                                                   WHERE (usrsite_username=getEffectiveXtUser()))) )
           UNION
           SELECT raitem_id
             FROM raitem, itemsite
            WHERE ( (raitem_rahead_id=pRaheadid)
              AND   (raitem_coitem_itemsite_id=itemsite_id)
              AND   (itemsite_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                  FROM usrsite
                                                 WHERE (usrsite_username=getEffectiveXtUser()))) )
         ) AS data;
  IF (_result > 0) THEN
    RETURN false;
  END IF;

  RETURN true;
END;
$_$;


ALTER FUNCTION public.checkrasiteprivs(integer) OWNER TO admin;

--
-- Name: checkshipmentsiteprivs(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION checkshipmentsiteprivs(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pShipheadid ALIAS FOR $1;
  _check    BOOLEAN;
  _result   INTEGER;

BEGIN

  IF (NOT fetchMetricBool('MultiWhs')) THEN
    RETURN true;
  END IF;

  IF (NOT fetchUsrPrefBool('selectedSites')) THEN
    RETURN true;
  END IF;

  SELECT COALESCE(COUNT(*), 0) INTO _result
    FROM ( SELECT coitem_id
             FROM shipitem, coitem, itemsite
            WHERE ( (shipitem_shiphead_id=pShipheadid)
              AND   (coitem_id=shipitem_orderitem_id)
              AND   (coitem_itemsite_id=itemsite_id)
              AND   (itemsite_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                    FROM usrsite
                                                   WHERE (usrsite_username=getEffectiveXtUser()))) )
           UNION
           SELECT cohead_warehous_id
             FROM shipitem, coitem, cohead
            WHERE ( (shipitem_shiphead_id=pShipheadid)
              AND   (coitem_id=shipitem_orderitem_id)
              AND   (cohead_id=coitem_cohead_id)
              AND   (cohead_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                  FROM usrsite
                                                 WHERE (usrsite_username=getEffectiveXtUser()))) )
         ) AS data;
  IF (_result > 0) THEN
    RETURN false;
  END IF;

  RETURN true;
END;
$_$;


ALTER FUNCTION public.checkshipmentsiteprivs(integer) OWNER TO admin;

--
-- Name: checksositeprivs(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION checksositeprivs(integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSoheadid ALIAS FOR $1;
  _check    BOOLEAN;
  _result   INTEGER;

BEGIN

  IF (NOT fetchMetricBool('MultiWhs')) THEN
    RETURN true;
  END IF;

  IF (NOT fetchUsrPrefBool('selectedSites')) THEN
    RETURN true;
  END IF;

  SELECT COALESCE(COUNT(*), 0) INTO _result
    FROM ( SELECT coitem_id
             FROM coitem, itemsite
            WHERE ( (coitem_cohead_id=pSoheadid)
              AND   (coitem_itemsite_id=itemsite_id)
              AND   (itemsite_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                    FROM usrsite
                                                   WHERE (usrsite_username=getEffectiveXtUser()))) )
           UNION
           SELECT cohead_warehous_id
             FROM cohead
            WHERE ( (cohead_id=pSoheadid)
              AND   (cohead_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                  FROM usrsite
                                                 WHERE (usrsite_username=getEffectiveXtUser()))) )
         ) AS data;
  IF (_result > 0) THEN
    RETURN false;
  END IF;

  RETURN true;
END;
$_$;


ALTER FUNCTION public.checksositeprivs(integer) OWNER TO admin;

--
-- Name: checkvouchersiteprivs(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION checkvouchersiteprivs(integer) RETURNS boolean
    LANGUAGE plpgsql STABLE
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVoheadid ALIAS FOR $1;
  _check    BOOLEAN;
  _result   INTEGER;

BEGIN

  IF (NOT fetchMetricBool('MultiWhs')) THEN
    RETURN true;
  END IF;

  IF (NOT fetchUsrPrefBool('selectedSites')) THEN
    RETURN true;
  END IF;

  SELECT COALESCE(COUNT(*), 0) INTO _result
    FROM ( SELECT voitem_id
             FROM voitem, poitem, itemsite
            WHERE ( (voitem_vohead_id=pVoheadid)
              AND   (poitem_id=voitem_poitem_id)
              AND   (poitem_itemsite_id=itemsite_id)
              AND   (itemsite_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                    FROM usrsite
                                                   WHERE (usrsite_username=getEffectiveXtUser()))) )
           UNION
           SELECT pohead_warehous_id
             FROM vohead, pohead
            WHERE ( (vohead_id=pVoheadid)
              AND   (pohead_id=vohead_pohead_id)
              AND   (pohead_warehous_id NOT IN (SELECT usrsite_warehous_id
                                                  FROM usrsite
                                                 WHERE (usrsite_username=getEffectiveXtUser()))) )
         ) AS data;
  IF (_result > 0) THEN
    RETURN false;
  END IF;

  RETURN true;
END;
$_$;


ALTER FUNCTION public.checkvouchersiteprivs(integer) OWNER TO admin;

--
-- Name: clearnumberissue(text, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION clearnumberissue(psequence text, pnumber integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  __seqiss	seqiss[];
  __newiss	seqiss[] := ARRAY[]::seqiss[];
  _i		INTEGER;
  _result	BOOLEAN := FALSE;
  _interval	TEXT := fetchMetricText('NumberIssueResetIntervalDays') || ' day';
  _number	INTEGER;
BEGIN
  -- get the sequence to update
  SELECT orderseq_seqiss INTO __seqiss
  FROM orderseq
  WHERE (orderseq_name=psequence);

  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Invalid orderseq_name %', psequence;
  END IF;

  IF(ARRAY_LENGTH(COALESCE(__seqiss,__newiss),1) IS NULL) THEN
    RETURN FALSE;
  END IF;

  -- build a new array sans the number we are releasing
  FOR _i IN 1..ARRAY_LENGTH(__seqiss,1)
  LOOP
    IF((__seqiss[_i]).seqiss_number = pnumber) THEN
      _result = TRUE;
    -- don't bother re-adding stale numbers
    ELSIF (now() - _interval::INTERVAL > (__seqiss[_i]).seqiss_time) THEN
      IF (_number IS NULL) THEN
        _number := (__seqiss[_i]).seqiss_number;
      ELSE 
        _number := LEAST((__seqiss[_i]).seqiss_number, _number);
      END IF;
    ELSE
      __newiss := __newiss || __seqiss[_i];
    END IF;
  END LOOP;

  -- update the order sequence with the result
  UPDATE orderseq SET
    orderseq_seqiss = __newiss
  WHERE (orderseq_name=psequence);

  -- reset to any cleared stale number
  IF(_number IS NOT NULL) THEN
    UPDATE orderseq SET
      orderseq_number = _number
    WHERE (orderseq_name=psequence);
  END IF;
  
  RETURN _result;
END;
$$;


ALTER FUNCTION public.clearnumberissue(psequence text, pnumber integer) OWNER TO admin;

--
-- Name: clearnumberissue(text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION clearnumberissue(psequence text, pnumber text) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _castpnumber  INTEGER;
BEGIN
  -- for now, order numbers in the database are text but usually
  -- string representations of integers. allow for the occasional non-integer.
  BEGIN
    _castpnumber  := CAST(pnumber AS INTEGER);
  EXCEPTION WHEN cannot_coerce OR
                 invalid_text_representation
  THEN
    RAISE DEBUG 'clearNumberIssue(%, %) received an unexpected pnumber',
                  psequence, pnumber;
    RETURN FALSE;
  END;

  RETURN clearNumberIssue(psequence, _castpnumber);
END;
$$;


ALTER FUNCTION public.clearnumberissue(psequence text, pnumber text) OWNER TO admin;

--
-- Name: clearpayment(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION clearpayment(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pApselectid ALIAS FOR $1;

BEGIN

  DELETE FROM apselect
  WHERE (apselect_id=pApselectid);

  RETURN 1;

END;
$_$;


ALTER FUNCTION public.clearpayment(integer) OWNER TO admin;

--
-- Name: closeaccountingperiod(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION closeaccountingperiod(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pPeriodid ALIAS FOR $1;
  _r RECORD;
  _nextPeriodid INTEGER;
  _trialbalid INTEGER;
  _ending NUMERIC;
  _currYear INTEGER;
  _nextYear INTEGER;
BEGIN

--  Bypass error checking is this the the initial period
  IF ( NOT ( SELECT period_initial
             FROM period
             WHERE (period_id=pPeriodid) ) ) THEN

--  Check to make use that the period is not already closed
    IF ( ( SELECT period_closed
           FROM period
           WHERE (period_id=pPeriodid) ) ) THEN
      RETURN -1;
    END IF;

--  Make sure that the day before this period belongs to another period
    SELECT prev.period_id AS periodid, prev.period_closed AS closed INTO _r
    FROM period AS prev, period AS curr
    WHERE ( (prev.period_end = (curr.period_start - 1))
     AND (curr.period_id=pPeriodid) );
    IF (NOT FOUND) THEN
      RETURN -2;
    END IF;

--  Make sure that the previous period is closed
    IF (NOT _r.closed) THEN
      RETURN -3;
    END IF;

  END IF;

--  Make sure that there the next period is defined
  SELECT next.period_id INTO _nextPeriodid
  FROM period AS next, period AS curr
  WHERE ( (next.period_start = (curr.period_end + 1))
   AND (curr.period_id=pPeriodid) );
  IF (NOT FOUND) THEN
    RETURN -4;
  END IF;

--  Make sure that the user is not trying to prematurely close the Period
  IF ( ( SELECT (period_end >= CURRENT_DATE)
         FROM period
         WHERE (period_id=pPeriodid) ) ) THEN
    RETURN -5;
  END IF;

  SELECT yearperiod_id INTO _currYear
    FROM yearperiod, period
   WHERE ((period_end BETWEEN yearperiod_start and yearperiod_end)
     AND  (period_id=pPeriodid));
  IF (NOT FOUND) THEN
    _currYear := -1;
  END IF;

  SELECT yearperiod_id INTO _nextYear
    FROM yearperiod, period
   WHERE ((period_end BETWEEN yearperiod_start and yearperiod_end)
     AND  (period_id=_nextPeriodid));
  IF (NOT FOUND) THEN
    RETURN -6;
  END IF;

--  Walk through the entire COA, calculating the ending balance and pushing
--  it to the beginning balance for the next period
  FOR _r IN SELECT accnt_id, accnt_type IN ('E', 'R') AS revexp,
                   trialbal_id, trialbal_beginning,
                   trialbal_credits, trialbal_debits
            FROM accnt LEFT OUTER JOIN trialbal ON ( (trialbal_accnt_id=accnt_id) AND (trialbal_period_id=pPeriodid) )
            ORDER BY accnt_id LOOP
    IF (_r.trialbal_id IS NULL) THEN
      _ending = 0;

      INSERT INTO trialbal
      ( trialbal_period_id, trialbal_accnt_id,
        trialbal_beginning, trialbal_ending, trialbal_dirty,
        trialbal_credits, trialbal_debits )
      VALUES
      ( pPeriodid, _r.accnt_id,
        0, 0, FALSE,
        0, 0 );
    ELSE
      _ending = (_r.trialbal_beginning - _r.trialbal_debits + _r.trialbal_credits);

      UPDATE trialbal
      SET trialbal_ending=_ending,
          trialbal_dirty = FALSE
      WHERE (trialbal_id=_r.trialbal_id);

      PERFORM forwardUpdateTrialBalance(_r.trialbal_id);
    END IF;

    IF (_r.revexp AND _currYear != _nextYear) THEN
      _ending := 0;
    END IF;

--  Find the trialbal record for the next period
    SELECT trialbal_id INTO _trialbalid
    FROM trialbal
    WHERE ( (trialbal_period_id=_nextPeriodid)
     AND (trialbal_accnt_id=_r.accnt_id) );
    IF (FOUND) THEN
      UPDATE trialbal
      SET trialbal_beginning = (_ending + trialbal_yearend),
          trialbal_ending = (_ending + trialbal_yearend - trialbal_debits + trialbal_credits)
      WHERE (trialbal_id=_trialbalid);
    ELSE
      INSERT INTO trialbal
      ( trialbal_period_id, trialbal_accnt_id,
        trialbal_beginning, trialbal_ending, trialbal_dirty,
        trialbal_credits, trialbal_debits )
      VALUES(_nextPeriodid, _r.accnt_id,
             _ending, _ending, TRUE,
             0, 0 );
    END IF;

  END LOOP;

--  Set the period_closed flag
  UPDATE period
  SET period_closed=TRUE
  WHERE (period_id=pPeriodid);

  RETURN pPeriodid;

END;
$_$;


ALTER FUNCTION public.closeaccountingperiod(integer) OWNER TO admin;

--
-- Name: closeaccountingyearperiod(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION closeaccountingyearperiod(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pYearPeriodid ALIAS FOR $1;
  _result INTEGER;
BEGIN

--  Check to make sure that the yearperiod is not already closed
  IF ( ( SELECT yearperiod_closed
           FROM yearperiod
          WHERE (yearperiod_id=pYearPeriodid) ) ) THEN
    RETURN -1;
  END IF;

  IF ( ( SELECT (count(period_id) > 0)
           FROM period
          WHERE ((period_yearperiod_id=pYearPeriodid)
           AND (NOT period_closed)) ) ) THEN
    RETURN -10;
  END IF;

  IF ( ( SELECT (count(yearperiod_id) > 0)
           FROM yearperiod
          WHERE ((yearperiod_end< (
            SELECT yearperiod_end 
            FROM yearperiod 
            WHERE (yearperiod_id=pYearPeriodId))
          )
           AND (NOT yearperiod_closed)) ) ) THEN
    RETURN -11;
  END IF;

--  Should we check for a previous yearperiod existing already ?
--  If so then we should return -2 if one does not.

--  If we did the previous yearperiod we should check to make sure that
--  it is also closed. Returning -3 if it is not.

--  Make sure that the user is not trying to prematurely close the YearPeriod
  IF ( ( SELECT (yearperiod_end >= CURRENT_DATE)
           FROM yearperiod
          WHERE (yearperiod_id=pYearPeriodid) ) ) THEN
    RETURN -5;
  END IF;

--  Update the year end Retained Earnings
  SELECT updateRetainedEarnings(pYearPeriodid) INTO _result;
  IF (_result < 0) THEN
    RETURN _result;
  END IF;

  UPDATE yearperiod
    SET yearperiod_closed = TRUE
  WHERE yearperiod_id = pYearPeriodid;

  RETURN 0;

END;
$_$;


ALTER FUNCTION public.closeaccountingyearperiod(integer) OWNER TO admin;

--
-- Name: closepo(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION closepo(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pPoheadid ALIAS FOR $1;

BEGIN

  UPDATE poitem
  SET poitem_status='C'
  WHERE (poitem_pohead_id=pPoheadid);

-- _poitemTrigger will close pohead when the last poitem is closed
--  UPDATE pohead
--  SET pohead_status='C'
--  WHERE (pohead_id=pPoheadid);

  RETURN 1;

END;
$_$;


ALTER FUNCTION public.closepo(integer) OWNER TO admin;

--
-- Name: closewo(integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION closewo(integer, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWoid ALIAS FOR $1;
  pPostMaterialVariances ALIAS FOR $2;

BEGIN
  
  RETURN closeWo(pWoid, pPostMaterialVariances, CURRENT_DATE);
END;
$_$;


ALTER FUNCTION public.closewo(integer, boolean) OWNER TO admin;

--
-- Name: closewo(integer, boolean, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION closewo(integer, boolean, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWoid ALIAS FOR $1;
  pPostMaterialVariances ALIAS FOR $2;
  pTransDate ALIAS FOR $3;
  _woNumber TEXT;
  _check CHAR;
  _itemlocSeries INTEGER := 0;

BEGIN

  --If this is item type Job then we cannot close here
  SELECT itemsite_costmethod INTO _check
  FROM wo,itemsite
  WHERE ((wo_id=pWoid)
  AND (wo_itemsite_id=itemsite_id)
  AND (itemsite_costmethod = 'J'));
  IF (FOUND) THEN
    RAISE EXCEPTION 'Work orders for Job items are closed when all quantities are shipped';
  END IF;

  SELECT formatWoNumber(pWoid) INTO _woNumber;

-- If there are any tools issued on this job then we cannot close here
  IF ( SELECT (count(*) > 0)
       FROM womatl
       JOIN itemsite ON (womatl_itemsite_id=itemsite_id)
       JOIN item ON ((itemsite_item_id=item_id) AND (item_type='T'))
       WHERE ((womatl_wo_id=pWoid)
         AND  (womatl_qtyiss > 0)) ) THEN
    RAISE EXCEPTION 'All Tools must be returned before the W/O can be closed';
  END IF;

--  Distribute any remaining wo_wipvalue to G/L - debit Inventory Cost, credit WIP
  PERFORM insertGLTransaction( 'W/O', 'WO', _woNumber, ('Manufacturing Inventory Cost Variance for ' || item_number),
                               getPrjAccntId(wo_prj_id, costcat_wip_accnt_id), 
                               getPrjAccntId(wo_prj_id, costcat_invcost_accnt_id), -1,
                               COALESCE(wo_wipvalue, 0), pTransDate )
  FROM wo, itemsite, item, costcat
  WHERE ( (wo_itemsite_id=itemsite_id)
   AND (itemsite_item_id=item_id)
   AND (itemsite_costcat_id=costcat_id)
   AND (wo_id=pWoid) );

--  Distribute any remaining wo_brdvalue to G/L - debit Inventory Cost, credit WIP
  PERFORM insertGLTransaction( 'W/O', 'WO', _woNumber, ('Breeder Inventory Cost Variance for ' || item_number),
                               getPrjAccntId(wo_prj_id, costcat_wip_accnt_id),
                               CASE WHEN(itemsite_costmethod='A') THEN costcat_asset_accnt_id
                                    ELSE getPrjAccntId(wo_prj_id, costcat_invcost_accnt_id)
                               END,
                               -1,
                               COALESCE(wo_brdvalue, 0), pTransDate )
  FROM wo, itemsite, item, costcat
  WHERE ( (wo_itemsite_id=itemsite_id)
   AND (itemsite_item_id=item_id)
   AND (itemsite_costcat_id=costcat_id)
   AND (wo_id=pWoid) );

--  Don't bother with posting variances if the qtyrcv is 0 as
--  they are meaningless.
  IF ( ( SELECT wo_qtyrcv
         FROM wo
         WHERE (wo_id=pWoid) ) > 0 ) THEN

    IF (pPostMaterialVariances) THEN
--  Post womatl variances
    INSERT INTO womatlvar ( womatlvar_number, womatlvar_subnumber, womatlvar_posted,
        womatlvar_parent_itemsite_id, womatlvar_component_itemsite_id,
        womatlvar_qtyord, womatlvar_qtyrcv,
        womatlvar_qtyiss, womatlvar_qtyfxd, womatlvar_qtyper,
        womatlvar_scrap, womatlvar_wipscrap, womatlvar_bomitem_id,
        womatlvar_notes, womatlvar_ref )
      SELECT wo_number, wo_subnumber, pTransDate,
             wo_itemsite_id, womatl_itemsite_id,
             wo_qtyord, wo_qtyrcv,
             itemuomtouom(itemsite_item_id, womatl_uom_id, NULL, womatl_qtyiss),
             itemuomtouom(itemsite_item_id, womatl_uom_id, NULL, womatl_qtyfxd),
             itemuomtouom(itemsite_item_id, womatl_uom_id, NULL, womatl_qtyper),
             womatl_scrap,
             itemuomtouom(itemsite_item_id, womatl_uom_id, NULL, womatl_qtywipscrap),
             womatl_bomitem_id,
             womatl_notes, womatl_ref             
      FROM wo, womatl, itemsite, item
      WHERE ((womatl_wo_id=wo_id)
       AND (womatl_itemsite_id=itemsite_id)
       AND (itemsite_item_id=item_id)
       AND (item_type <> 'T')      
       AND (wo_id=pWoid));
    END IF;
  END IF;

--  Delete any P/R's created for this W/O
  PERFORM deletePr('W', womatl_id)
  FROM womatl
  WHERE (womatl_wo_id=pWoid);

  UPDATE wo
  SET wo_wipvalue = 0, wo_brdvalue=0,
      wo_status='C'
  WHERE (wo_id=pWoid);

  RETURN 1;
END;
$_$;


ALTER FUNCTION public.closewo(integer, boolean, date) OWNER TO admin;

--
-- Name: cntct; Type: TABLE; Schema: public; Owner: admin; Tablespace: 
--

CREATE TABLE cntct (
    cntct_id integer NOT NULL,
    cntct_crmacct_id integer,
    cntct_addr_id integer,
    cntct_first_name text,
    cntct_last_name text,
    cntct_honorific text,
    cntct_initials text,
    cntct_active boolean DEFAULT true,
    cntct_phone text,
    cntct_phone2 text,
    cntct_fax text,
    cntct_email text,
    cntct_webaddr text,
    cntct_notes text,
    cntct_title text,
    cntct_number text NOT NULL,
    cntct_middle text,
    cntct_suffix text,
    cntct_owner_username text,
    cntct_name text
);


ALTER TABLE public.cntct OWNER TO admin;

--
-- Name: TABLE cntct; Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON TABLE cntct IS 'Contact - information on how to reach a living person';


--
-- Name: cntct(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION cntct() RETURNS SETOF cntct
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _row cntct%ROWTYPE;
  _priv TEXT;
  _grant BOOLEAN;

BEGIN
  -- This query will give us the most permissive privilege the user has been granted
  SELECT privilege, granted INTO _priv, _grant
  FROM privgranted 
  WHERE privilege IN ('MaintainAllContacts','ViewAllContacts','MaintainPersonalContacts','ViewPersonalContacts')
  ORDER BY granted DESC, sequence
  LIMIT 1;

  -- If have an 'All' privilege return all results
  IF (_priv ~ 'All' AND _grant) THEN
    FOR _row IN 
      SELECT * FROM cntct
    LOOP
      RETURN NEXT _row;
    END LOOP;
  -- Otherwise if have any other grant, must be personal privilege.
  ELSIF (_grant) THEN
    FOR _row IN 
      SELECT * FROM cntct 
      WHERE cntct_owner_username = getEffectiveXtUser()
    LOOP
      RETURN NEXT _row;
    END LOOP;
  END IF;

  RETURN;

END;
$$;


ALTER FUNCTION public.cntct() OWNER TO admin;

--
-- Name: FUNCTION cntct(); Type: COMMENT; Schema: public; Owner: admin
--

COMMENT ON FUNCTION cntct() IS 'A table function that returns Contact results according to privilege settings.';


--
-- Name: cntctdups(text, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION cntctdups(text, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean) RETURNS SETOF cntctdup
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSearchText ALIAS FOR $1;
  pSearchContactName ALIAS FOR $2;
  pSearchPhone ALIAS FOR $3;
  pSearchEmail ALIAS FOR $4;
  pSearchNumber ALIAS FOR $5;
  pSearchName ALIAS FOR $6;
  pShowInactive ALIAS FOR $7;
  pIgnoreBlanks ALIAS FOR $8;
  pIndentedDups ALIAS FOR $9;
  pCheckHnfc ALIAS FOR $10;
  pCheckFirst ALIAS FOR $11;
  pCheckMiddle ALIAS FOR $12;
  pCheckLast ALIAS FOR $13;
  pCheckSuffix ALIAS FOR $14;
  pCheckPhone ALIAS FOR $15;
  pCheckEmail ALIAS FOR $16;
  _cntct cntctdup%ROWTYPE;
  _cntctdup cntctdup%ROWTYPE;
  _rec RECORD;
  _operator TEXT := '';
  _clause TEXT;
  _qry  TEXT := '';
  _return BOOLEAN := true;
  _text TEXT;
  _first BOOLEAN := true;

BEGIN
  -- Validate
  IF (pIndentedDups AND NOT pCheckHnfc AND NOT pCheckFirst AND NOT pCheckMiddle AND 
      NOT pCheckLast AND NOT pCheckSuffix AND NOT pCheckEmail AND NOT pCheckPhone) THEN
    RETURN;
  END IF;

  _text = quote_literal(pSearchText);

  IF (pIndentedDups) THEN
    _qry := 'SELECT 
	-1 AS cntct_id,
	-1 AS cntct_crmacct_id,
	-1 AS cntct_addr_id,';
    IF (NOT pCheckFirst) THEN
      _qry := _qry || ''''' AS ';
    END IF;
    _qry := _qry || ' cntct_first_name,';
    IF (NOT pCheckLast) THEN
      _qry := _qry || ''''' AS ';
    END IF;
    _qry := _qry || ' cntct_last_name,';
    IF (NOT pCheckHnfc) THEN
      _qry := _qry || ''''' AS ';
    END IF;
    _qry := _qry || ' cntct_honorific,';
    _qry := _qry || ' '''' AS cntct_initials,';
    _qry := _qry || ' NULL AS cntct_active,';
    IF (NOT pCheckPhone) THEN
      _qry := _qry || ''''' AS ';
    END IF;
    _qry := _qry || ' cntct_phone,';
    IF (NOT pCheckPhone) THEN
      _qry := _qry || ''''' AS ';
    END IF;
    _qry := _qry || ' cntct_phone2,';
    _qry := _qry || ' '''' AS cntct_fax,';
    IF (NOT pCheckEmail) THEN
      _qry := _qry || ''''' AS ';
    END IF;
    _qry := _qry || ' cntct_email,';
    _qry := _qry || ' '''' AS cntct_webaddr,';
    _qry := _qry || ' '''' AS cntct_notes,';
    _qry := _qry || ' '''' AS cntct_title,';
    _qry := _qry || ' '''' AS cntct_number,';
    IF (NOT pCheckMiddle) THEN
      _qry := _qry || ''''' AS ';
    END IF;
    _qry := _qry || ' cntct_middle,';
    IF (NOT pCheckSuffix) THEN
      _qry := _qry || ''''' AS ';
    END IF;
    _qry := _qry || ' cntct_suffix,';
    _qry := _qry || ' '''' AS cntct_owner_username,';
    _qry := _qry || ' '''' AS cntct_name,';
    _qry := _qry || ' '''' AS crmacct_number, ';
    _qry := _qry || ' '''' AS crmacct_name, ';
    _qry := _qry || ' NULL AS addr_id,
		NULL AS addr_active,
		'''' AS addr_line1,
		'''' AS addr_line2,
		'''' AS addr_line3,
		'''' AS addr_city,
		'''' AS addr_state,
		'''' AS addr_postalcode,
		'''' AS addr_country,
		'''' AS addr_notes,
		'''' AS addr_number,
		cntctdup_level FROM (';
  END IF;
    _clause := 'SELECT 
		cntct_id,
		cntct_crmacct_id,
		cntct_addr_id,
		UPPER(cntct_first_name) AS cntct_first_name,
		UPPER(cntct_last_name) AS cntct_last_name,
		UPPER(cntct_honorific) AS cntct_honorific,
		cntct_initials,
		cntct_active,
		cntct_phone,
		cntct_phone2,
		cntct_fax,
		UPPER(cntct_email) AS cntct_email,
		cntct_webaddr,
		cntct_notes,
		cntct_title,
		cntct_number,
		UPPER(cntct_middle) AS cntct_middle,
		UPPER(cntct_suffix) AS cntct_suffix,
		cntct_owner_username,
                cntct_name,
		crmacct_number, 
		crmacct_name,
		addr.*,
		0 AS cntctdup_level
             FROM cntct()
               LEFT OUTER JOIN crmacct ON (cntct_crmacct_id=crmacct_id) 
               LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id) 
	     WHERE ';

  IF (NOT pIndentedDups) THEN
    WHILE position('UPPER' in _clause) > 0
    LOOP
      _clause := regexp_replace(_clause, 'UPPER', '');
    END LOOP;
  END IF;

  _qry := _qry || _clause;
  	   
  IF (NOT pShowInactive) THEN
    _qry := _qry || ' cntct_active AND ';
  END IF;

  IF (pIgnoreBlanks) THEN
    _qry := _qry || ' (COALESCE(LENGTH(cntct_first_name || cntct_last_name),0) > 0) AND ';
  END IF;

    _qry := _qry || '(false ';

  IF (pSearchNumber) THEN
    _qry := _qry || ' OR (crmacct_number ~* ' || quote_literal(pSearchText) || ') ';
  END IF;

  IF (pSearchName) THEN
    _qry := _qry || ' OR (crmacct_name ~* ' || quote_literal(pSearchText) || ') ';
  END IF;

  IF (pSearchContactName) THEN
    _qry := _qry || ' OR (cntct_first_name || '' '' || cntct_last_name ~* ' || quote_literal(pSearchText) || ') ';
  END IF;
  
  IF (pSearchPhone) THEN
    _qry := _qry || ' OR (cntct_phone || '' '' || cntct_phone2 || '' '' || cntct_fax ~* ' || quote_literal(pSearchText) || ') ';
  END IF;

  IF (pSearchEmail) THEN
    _qry := _qry || ' OR (cntct_email ~* ' || quote_literal(pSearchText) || ') ';
  END IF;

  _qry := _qry || ' ) ';
  
  IF (pIndentedDups) THEN
    _qry := _qry || ') data';
    _clause := ' GROUP BY cntctdup_level';
    IF (pCheckHnfc) THEN
      _clause := _clause || ',cntct_honorific';
    END IF;
    IF (pCheckFirst) THEN
      _clause := _clause || ',cntct_first_name';
    END IF;
    IF (pCheckMiddle) THEN
      _clause := _clause || ',cntct_middle';
    END IF;
    IF (pCheckLast) THEN
      _clause := _clause || ',cntct_last_name';
    END IF;
    IF (pCheckSuffix) THEN
      _clause := _clause || ',cntct_suffix';
    END IF;
    IF (pCheckEmail) THEN
      _clause := _clause || ',cntct_email';
    END IF;
    IF (pCheckPhone) THEN
      _clause := _clause || ',cntct_phone';
      _clause := _clause || ',cntct_phone2';
    END IF;

    _qry := _qry || _clause; 

    _clause := ' HAVING(';
    IF (pCheckHnfc) THEN
      _clause := _clause || 'OR COUNT(cntct_honorific) > 1 ';
    END IF;
    IF (pCheckFirst) THEN
      _clause := _clause || 'OR COUNT(cntct_first_name) > 1 ';
    END IF;
    IF (pCheckMiddle) THEN
      _clause := _clause || 'OR COUNT(cntct_middle) > 1 ';
    END IF;
    IF (pCheckLast) THEN
      _clause := _clause || 'OR COUNT(cntct_last_name) > 1 ';
    END IF;
    IF (pCheckSuffix) THEN
      _clause := _clause || 'OR COUNT(cntct_suffix) > 1 ';
    END IF;
    IF (pCheckEmail) THEN
      _clause := _clause || 'OR COUNT(cntct_email) > 1 ';
    END IF;
    IF (pCheckPhone) THEN
      _clause := _clause || 'OR (COUNT(cntct_phone) > 1 AND LENGTH(cntct_phone) > 0) ';
      _clause := _clause || 'OR (COUNT(cntct_phone2) > 1 AND LENGTH(cntct_phone2) > 0) ';
    END IF;
    _clause := _clause || ') ';
    _clause := overlay(_clause placing '' from 9 for 2);

    IF (pCheckHnfc) THEN
      _clause := _clause || 'AND LENGTH(cntct_honorific) > 0 ';
    END IF;
    IF (pCheckFirst) THEN
      _clause := _clause || 'AND LENGTH(cntct_first_name) > 0  ';
    END IF;
    IF (pCheckMiddle) THEN
      _clause := _clause || 'AND LENGTH(cntct_middle) > 0  ';
    END IF;
    IF (pCheckLast) THEN
      _clause := _clause || 'AND LENGTH(cntct_last_name) > 0  ';
    END IF;
    IF (pCheckSuffix) THEN
      _clause := _clause || 'AND LENGTH(cntct_suffix) > 0  ';
    END IF;
    IF (pCheckEmail) THEN
      _clause := _clause || 'AND LENGTH(cntct_email) > 0  ';
    END IF;
    
    _qry := _qry || _clause;
  END IF;

  _qry := _qry || ' ORDER BY cntct_last_name, cntct_first_name;'; 

-- raise exception '%',_qry;
  FOR _cntct IN
    EXECUTE _qry
  LOOP

    RETURN NEXT _cntct;

    -- If duplicates, get duplicates
    IF (pIndentedDups) THEN
    
      _qry := 'SELECT                
                 cntct.*,
                 crmacct_number, 
                 crmacct_name,
                 addr.*,
                 1 AS cntctdup_level
               FROM cntct()
                 LEFT OUTER JOIN crmacct ON (cntct_crmacct_id=crmacct_id) 
                 LEFT OUTER JOIN addr ON (cntct_addr_id=addr_id)
               WHERE (true) ';

      IF (pCheckHnfc) THEN
        _qry := _qry || ' AND (UPPER(cntct_honorific)=' || quote_literal(_cntct.cntct_honorific) || ')';
      END IF;

      IF (pCheckFirst) THEN
        _qry := _qry || ' AND (UPPER(cntct_first_name)=' || quote_literal(_cntct.cntct_first_name) || ')';
      END IF;

      IF (pCheckMiddle) THEN
        _qry := _qry || ' AND (UPPER(cntct_middle)=' || quote_literal(_cntct.cntct_middle) || ')';
      END IF;

      IF (pCheckLast) THEN
        _qry := _qry || ' AND (UPPER(cntct_last_name)=' || quote_literal(_cntct.cntct_last_name) || ')';
      END IF;

      IF (pCheckSuffix) THEN
        _qry := _qry || ' AND (UPPER(cntct_suffix)=' ||  quote_literal(_cntct.cntct_suffix) || ')';
      END IF;

      IF (pCheckPhone) THEN
        _qry := _qry || ' AND (cntct_phone=' || quote_literal(_cntct.cntct_phone)  || ')';
      END IF;

      IF (pCheckEmail) THEN
        _qry := _qry || ' AND (UPPER(cntct_email)=' || quote_literal(_cntct.cntct_email) || ')';
      END IF;

-- raise exception '%',_qry;
      FOR _cntctdup IN
        EXECUTE _qry
      LOOP
        RETURN NEXT _cntctdup;
      END LOOP;

    END IF;
    
  END LOOP;

  RETURN;
END;
$_$;


ALTER FUNCTION public.cntctdups(text, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean, boolean) OWNER TO admin;

--
-- Name: cntctmerge(integer, integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION cntctmerge(integer, integer, boolean) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSourceCntctId ALIAS FOR $1;
  pTargetCntctId ALIAS FOR $2;
  pPurge ALIAS FOR $3;
  _fk		RECORD;
  _pk   	RECORD;
  _sel		RECORD;
  _seq  	INTEGER;
  _col		TEXT;
  _pkcol  	TEXT;
  _qry  	TEXT;
  _multi	BOOLEAN;

BEGIN
  -- Validate
  IF (pSourceCntctId IS NULL) THEN
    RAISE EXCEPTION 'Source contact id can not be null';
  ELSIF (pTargetCntctId IS NULL) THEN
    RAISE EXCEPTION 'Target contact id can not be null';
  ELSIF (pPurge IS NULL) THEN
    RAISE EXCEPTION 'Purge flag can not be null';
  END IF;
  
  -- Determine where this contact is used by analyzing foreign key linkages and update each
  FOR _fk IN
    SELECT pg_namespace.nspname AS schemaname, con.relname AS tablename, conkey AS seq, conrelid AS class_id 
    FROM pg_constraint, pg_class f, pg_class con, pg_namespace
    WHERE confrelid=f.oid
    AND conrelid=con.oid
    AND f.relname = 'cntct'
    AND con.relnamespace=pg_namespace.oid
    AND con.relname NOT IN ('cntctsel', 'cntctmrgd', 'mrghist','trgthist')
  LOOP
    -- Validate
    IF (ARRAY_UPPER(_fk.seq,1) > 1) THEN
      RAISE EXCEPTION 'Updates to tables where the contact is one of multiple foreign key columns is not supported. Error on Table: %',
        pg_namespace.nspname || '.' || con.relname;
    END IF;
    
    _seq := _fk.seq[1];

    -- Get the specific column name
    SELECT attname INTO _col
    FROM pg_attribute, pg_class
    WHERE ((attrelid=pg_class.oid)
    AND (pg_class.oid=_fk.class_id)
    AND (attnum=_seq));

    IF (NOT pPurge) THEN
    -- Cache what we're going to do so we can restore if need be.
    -- Start by determining the primary key column for this table.
      _multi := false;
      _qry := 'SELECT pg_attribute.attname AS key
               FROM pg_attribute, pg_class 
               WHERE pg_class.relnamespace = (
                 SELECT oid 
                 FROM pg_namespace 
                 WHERE pg_namespace.nspname = ''' || _fk.schemaname || ''') 
                AND  pg_class.oid IN (
                 SELECT indexrelid 
                 FROM pg_index 
                 WHERE indisprimary = true 
                  AND indrelid IN (
                    SELECT oid 
                    FROM pg_class 
                    WHERE lower(relname) = ''' || _fk.tablename || ''')) 
                AND pg_attribute.attrelid = pg_class.oid 
                AND pg_attribute.attisdropped = false 
               ORDER BY pg_attribute.attnum;';

      FOR _pk IN 
        EXECUTE _qry
      LOOP
        IF (_multi) THEN
          RAISE EXCEPTION 'Reference tables with composite primary keys not supported.  Try the merge and purge option.';
        END IF;
        _pkcol := _pk.key;
        _multi := true;
      END LOOP;

      -- Gather and store the history
      _qry := 'INSERT INTO mrghist 
               SELECT ' || pSourceCntctId || ', ''' 
                        || _fk.schemaname || '.' || _fk.tablename || ''', ''' 
                        || _pkcol || ''', ' 
                        || _pkcol || ', '''
                        || _col || ''' 
               FROM ' || _fk.schemaname || '.' || _fk.tablename || '
               WHERE (' || _col || '=' || pSourceCntctId || ');';
                   --           raise exception '%',_qry;
      EXECUTE _qry;
      
    END IF;

    -- Merge references
    _qry := 'UPDATE ' || _fk.schemaname || '.' || _fk.tablename ||
            ' SET ' || _col || '=' || pTargetCntctId ||
            ' WHERE (' || _col || '=' || pSourceCntctId || ');';
            
    EXECUTE _qry;
         
  END LOOP;

  -- Merge cases with no foreign key
  IF (NOT pPurge) THEN
    INSERT INTO mrghist 
    SELECT pSourceCntctId,
      'comment',
      'comment_id', 
      comment_id,
      'comment_source_id'
    FROM comment
    WHERE ((comment_source_id= pSourceCntctId)
    AND (comment_source='T'));

    INSERT INTO mrghist 
    SELECT pSourceCntctId,
      'docass',
      'docass_id', 
      docass_id,
      'docass_source_id'
    FROM docass
    WHERE ((docass_source_id= pSourceCntctId)
    AND (docass_source_type='T'));

    INSERT INTO mrghist 
    SELECT pSourceCntctId,
      'docass',
      'docass_id', 
      docass_id,
      'docass_target_id'
    FROM docass
    WHERE ((docass_target_id= pSourceCntctId)
    AND (docass_target_type='T'));

    INSERT INTO mrghist 
    SELECT pSourceCntctId,
      'vendinfo',
      'vend_id', 
      vend_id,
      'vend_cntct1_id'
    FROM vendinfo
    WHERE (vend_cntct1_id=pSourceCntctId);

    INSERT INTO mrghist 
    SELECT pSourceCntctId,
      'vendinfo',
      'vend_id', 
      vend_id,
      'vend_cntct2_id'
    FROM vendinfo
    WHERE (vend_cntct2_id=pSourceCntctId);

    IF (fetchMetricBool('EnableBatchManager') AND packageIsEnabled('xtbatch')) THEN
      INSERT INTO mrghist 
      SELECT pSourceCntctId,
      'xtbatch.emlassc',
      'emlassc_id', 
      emlassc_id,
      'emlassc_assc_id'
      FROM xtbatch.emlassc
      WHERE ((emlassc_assc_id= pSourceCntctId)
      AND (emlassc_type='T'));
    END IF;
  END IF;

  UPDATE comment
  SET comment_source_id = pTargetCntctId
  WHERE ((comment_source = 'T')
   AND (comment_source_id = pSourceCntctId));

  UPDATE docass
  SET docass_source_id = pTargetCntctId
  WHERE ((docass_source_type = 'T')
   AND (docass_source_id = pSourceCntctId));

  UPDATE docass
  SET docass_target_id = pTargetCntctId
  WHERE ((docass_target_type = 'T')
   AND (docass_target_id = pSourceCntctId));

  UPDATE vendinfo
  SET vend_cntct1_id = pTargetCntctId
  WHERE (vend_cntct1_id = pSourceCntctId);

  UPDATE vendinfo
  SET vend_cntct2_id = pTargetCntctId
  WHERE (vend_cntct2_id = pSourceCntctId);

  IF (fetchMetricBool('EnableBatchManager') AND packageIsEnabled('xtbatch')) THEN
    UPDATE xtbatch.emlassc
    SET emlassc_assc_id = pTargetCntctId
    WHERE ((emlassc_type = 'T')
     AND (emlassc_assc_id = pSourceCntctId));
  END IF;

  IF (NOT pPurge) THEN
  -- Record that this has been merged if not already
    IF (SELECT (COUNT(cntctmrgd_cntct_id) = 0) 
        FROM cntctmrgd
        WHERE (cntctmrgd_cntct_id=pSourceCntctId)) THEN
      INSERT INTO cntctmrgd VALUES (pSourceCntctId,false);
    END IF;
  END IF;

 -- Merge field detail to target
  SELECT * INTO _sel 
  FROM cntctsel 
    JOIN cntct ON (cntctsel_cntct_id=cntct_id)
  WHERE (cntctsel_cntct_id=pSourceCntctId);
  
  IF (FOUND) THEN
    IF (_sel.cntctsel_mrg_crmacct_id) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_crmacct_id', cntct_crmacct_id::text || '::integer'
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_crmacct_id=_sel.cntct_crmacct_id WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_addr_id) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_addr_id', cntct_addr_id::text || '::integer'
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_addr_id=_sel.cntct_addr_id WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_first_name) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_first_name', '''' || cntct_first_name || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_first_name=_sel.cntct_first_name WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_last_name) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_last_name', '''' || cntct_last_name || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_last_name=_sel.cntct_last_name WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_honorific) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_honorific', '''' || cntct_honorific || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_honorific=_sel.cntct_honorific WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_initials) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_initials', '''' || cntct_initials || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_initials=_sel.cntct_initials WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_phone) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_phone', '''' || cntct_phone || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_phone=_sel.cntct_phone WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_phone2) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_phone2', '''' || cntct_phone2 || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_phone2=_sel.cntct_phone2 WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_fax)  THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_fax', '''' || cntct_fax || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_fax=_sel.cntct_fax WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_email)  THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_email', '''' || cntct_email || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_email=_sel.cntct_email WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_webaddr) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_webaddr', '''' || cntct_webaddr || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_webaddr=_sel.cntct_webaddr WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_notes) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_notes', '''' || cntct_notes || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_notes=cntct_notes || '

      ' || _sel.cntct_notes WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_title) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_title', '''' || cntct_title || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_title=_sel.cntct_title WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_middle) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_middle', '''' || cntct_middle || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_middle=_sel.cntct_middle WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_suffix) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_suffix', '''' || cntct_suffix || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_suffix=_sel.cntct_suffix WHERE (cntct_id=pTargetCntctId);
    END IF;
    IF (_sel.cntctsel_mrg_owner_username) THEN
      IF (NOT pPurge) THEN
        INSERT INTO trgthist
        SELECT pSourceCntctId,pTargetCntctId,'cntct_owner_username', '''' || cntct_owner_username || ''''
        FROM cntct
        WHERE (cntct_id=pTargetCntctId);
      END IF;
      UPDATE cntct SET cntct_owner_username=_sel.cntct_owner_username WHERE (cntct_id=pTargetCntctId);
    END IF;
  ELSE
    RAISE EXCEPTION 'Source Contact not Found';
  END IF;

  -- Disposition source contact
  IF (pPurge) THEN
    DELETE FROM cntct WHERE cntct_id = pSourceCntctId;
  END IF;

  -- Deactivate contact
  UPDATE cntct SET cntct_active = false WHERE (cntct_id=pSourceCntctId);
  
  -- Clean up
  DELETE FROM cntctsel WHERE (cntctsel_cntct_id=pSourceCntctId);

  RETURN true;
END;
$_$;


ALTER FUNCTION public.cntctmerge(integer, integer, boolean) OWNER TO admin;

--
-- Name: cntctrestore(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION cntctrestore(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCntctId ALIAS FOR $1;
  _r RECORD;
  _qry TEXT;

BEGIN
  -- Validate
  SELECT * INTO _r FROM cntctmrgd WHERE (cntctmrgd_cntct_id=pCntctId);
  IF (NOT FOUND) THEN
    RETURN false;
  END IF;
  
  -- Gather the list of affected records
  FOR _r IN
    SELECT * FROM mrghist
    WHERE (mrghist_cntct_id=pCntctId)
  LOOP
    -- Restore the old references
    _qry := 'UPDATE ' || _r.mrghist_table ||
            ' SET ' || _r.mrghist_cntct_col || '=' || pCntctId ||
            ' WHERE (' || _r.mrghist_pkey_col || '=' || _r.mrghist_pkey_id || ');';
    
   EXECUTE _qry;
         
  END LOOP;

  -- Gather the list of affected fields
  FOR _r IN
    SELECT * FROM trgthist
    WHERE (trgthist_src_cntct_id=pCntctId)
  LOOP
    -- Restore the old values
    _qry := 'UPDATE cntct
              SET ' || _r.trgthist_col || '=' || _r.trgthist_value ||
            ' WHERE (cntct_id=' || _r.trgthist_trgt_cntct_id || ');';
    
   EXECUTE _qry;
         
  END LOOP;

  -- Clean up
  UPDATE cntct SET cntct_active=true WHERE (cntct_id=pCntctId);
  DELETE FROM mrghist WHERE (mrghist_cntct_id=pCntctId);
  DELETE FROM trgthist WHERE (trgthist_src_cntct_id=pCntctId);
  DELETE FROM cntctmrgd WHERE (cntctmrgd_cntct_id=pCntctId);

  RETURN true;

END;
$_$;


ALTER FUNCTION public.cntctrestore(integer) OWNER TO admin;

--
-- Name: cntctselect(integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION cntctselect(integer, boolean) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCntctId ALIAS FOR $1;
  pTarget ALIAS FOR $2;

BEGIN
  -- If target, delete any other targets
  IF (pTarget) THEN
    DELETE FROM cntctsel WHERE cntctsel_target;
  END IF;
  
  -- Delete any previous selection of this contact
  DELETE FROM cntctsel WHERE cntctsel_cntct_id=pCntctId;

  -- Add this contact in appropriate selection state
  INSERT INTO cntctsel VALUES (pCntctId,pTarget);

  RETURN true;
END;
$_$;


ALTER FUNCTION public.cntctselect(integer, boolean) OWNER TO admin;

--
-- Name: cntctselectcol(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION cntctselectcol(integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCntctId ALIAS FOR $1;
  pColNumber ALIAS FOR $2;

BEGIN

  IF (pColNumber = 2 OR pColNumber = 3) THEN
    UPDATE cntctsel SET cntctsel_mrg_crmacct_id=false WHERE (cntctsel_mrg_crmacct_id AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_crmacct_id=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 4) THEN
    UPDATE cntctsel SET cntctsel_mrg_honorific=false WHERE (cntctsel_mrg_honorific AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_honorific=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 5) THEN
    UPDATE cntctsel SET cntctsel_mrg_first_name=false WHERE (cntctsel_mrg_first_name AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_first_name=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 6) THEN
    UPDATE cntctsel SET cntctsel_mrg_middle=false WHERE (cntctsel_mrg_middle AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_middle=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 7) THEN
    UPDATE cntctsel SET cntctsel_mrg_last_name=false WHERE (cntctsel_mrg_last_name AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_last_name=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 8) THEN
    UPDATE cntctsel SET cntctsel_mrg_suffix=false WHERE (cntctsel_mrg_suffix AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_suffix=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 9) THEN
    UPDATE cntctsel SET cntctsel_mrg_initials=false WHERE (cntctsel_mrg_initials AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_initials=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 10) THEN
    UPDATE cntctsel SET cntctsel_mrg_phone=false WHERE (cntctsel_mrg_phone AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_phone=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 11) THEN
    UPDATE cntctsel SET cntctsel_mrg_phone2=false WHERE (cntctsel_mrg_phone2 AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_phone2=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 12) THEN
    UPDATE cntctsel SET cntctsel_mrg_fax=false WHERE (cntctsel_mrg_fax AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_fax=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 13) THEN
    UPDATE cntctsel SET cntctsel_mrg_email=false WHERE (cntctsel_mrg_email AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_email=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 14) THEN
    UPDATE cntctsel SET cntctsel_mrg_webaddr=false WHERE (cntctsel_mrg_webaddr AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_webaddr=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 15) THEN
    UPDATE cntctsel SET cntctsel_mrg_title=false WHERE (cntctsel_mrg_title AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_title=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 16) THEN
    UPDATE cntctsel SET cntctsel_mrg_owner_username=false WHERE (cntctsel_mrg_owner_username AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_owner_username=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber = 17) THEN
    UPDATE cntctsel SET cntctsel_mrg_notes=false WHERE (cntctsel_mrg_notes AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_notes=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  ELSIF (pColNumber >= 18) THEN
    UPDATE cntctsel SET cntctsel_mrg_addr_id=false WHERE (cntctsel_mrg_addr_id AND cntctsel_cntct_id != pCntctId);
    UPDATE cntctsel SET cntctsel_mrg_addr_id=true WHERE (cntctsel_cntct_id = pCntctId);
    RETURN true;
  END IF;

  RETURN false;
END;
$_$;


ALTER FUNCTION public.cntctselectcol(integer, integer) OWNER TO admin;

--
-- Name: cntctused(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION cntctused(integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCntctId ALIAS FOR $1;
  _fk RECORD;
  _r RECORD;
  _seq INTEGER;
  _col TEXT;
  _qry TEXT;

BEGIN
  -- Determine where this contact is used by analyzing foreign key linkages
  -- but ignore child tables and those with impermanent relationships
  FOR _fk IN
    SELECT pg_namespace.nspname AS schemaname, con.relname AS tablename, conkey AS seq, conrelid AS class_id 
    FROM pg_constraint, pg_class f, pg_class con, pg_namespace
    WHERE confrelid=f.oid
    AND conrelid=con.oid
    AND f.relname = 'cntct'
    AND con.relnamespace=pg_namespace.oid
    AND con.relname NOT IN ('cntctaddr', 'cntctdata', 'cntcteml',
                            'cohead',    'pohead',    'quhead',   'tohead',
                            'cntctsel',  'cntctmrgd', 'mrghist',  'trgthist')
  LOOP
    -- Validate
    IF (ARRAY_UPPER(_fk.seq,1) > 1) THEN
      RAISE EXCEPTION 'Cannot check dependencies when the contact is one of multiple foreign key columns (%.%) [xtuple: fkeycheck, -1, %, %]',
        _fk.nspname, _fk.relname, _fk.nspname, _fk.relname;
    END IF;
    
    _seq := _fk.seq[1];

    -- Get the specific column name
    SELECT attname INTO _col
    FROM pg_attribute, pg_class
    WHERE ((attrelid=pg_class.oid)
    AND (pg_class.oid=_fk.class_id)
    AND (attnum=_seq));

    -- See if there are dependencies
    _qry := 'SELECT * 
            FROM ' || _fk.schemaname || '.' || _fk.tablename || '
            WHERE ('|| _col || '=' || pCntctId || ');';

    FOR _r IN 
      EXECUTE _qry
    LOOP
      RETURN true;
    END LOOP;
         
  END LOOP;

  RETURN false;

END;
$_$;


ALTER FUNCTION public.cntctused(integer) OWNER TO admin;

--
-- Name: coheadstatecolor(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION coheadstatecolor(integer) RETURNS text
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCoheadId	ALIAS FOR $1;
  _shipheadid	INTEGER;
  _result	TEXT := '';

BEGIN
  
  IF (pCoheadid IS NULL) THEN
    RAISE EXCEPTION 'Customer Id is required.';
  END IF;
  
  SELECT 
    shiphead_id INTO _shipheadid
  FROM cohead
    JOIN shiphead ON ((shiphead_order_id=cohead_id)
                  AND (shiphead_order_type='SO'))
    JOIN shipitem ON (shiphead_id=shipitem_shiphead_id)
  WHERE ((cohead_id=pCoheadId)
    AND (NOT shipitem_invoiced))
  ORDER BY shiphead_id DESC
  LIMIT 1;

  IF (FOUND) THEN
    SELECT 
      CASE 
        WHEN ((shiphead_shipped) 
         AND (COALESCE(shiphead_order_id,0) > 0) 
         AND (SUM(noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned)) <= 0)) THEN 
           'altemphasis'
        WHEN ((COALESCE(cobmisc_cohead_id,0) > 0)       
         AND (SUM(noNeg(coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned)) > 0)) THEN 
           'error' 
        WHEN (NOT shiphead_shipped) THEN 
          'emphasis' 
       END INTO _result
    FROM cohead
      JOIN coitem ON (cohead_id=coitem_cohead_id)
      JOIN shiphead ON ((shiphead_order_id=cohead_id)
                    AND (shiphead_order_type='SO'))
      JOIN shipitem ON (shiphead_id=shipitem_shiphead_id)
      LEFT OUTER JOIN (SELECT DISTINCT cobmisc_cohead_id FROM cobmisc) AS cobmisc ON (cobmisc_cohead_id=cohead_id) 
    WHERE (shiphead_id=_shipheadid)
    GROUP BY shiphead_id,shiphead_shipped,shiphead_order_id,cobmisc_cohead_id
    ORDER BY shiphead_id DESC;
  ELSE
    _result := '';
  END IF;
  
  RETURN _result;
  
END;
$_$;


ALTER FUNCTION public.coheadstatecolor(integer) OWNER TO admin;

--
-- Name: concataggsfunc(text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION concataggsfunc(text, text) RETURNS text
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  prevstate     ALIAS FOR $1;
  newval        ALIAS FOR $2;
BEGIN
  RETURN prevstate || newval;
END;
$_$;


ALTER FUNCTION public.concataggsfunc(text, text) OWNER TO admin;

--
-- Name: consolidatelocations(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION consolidatelocations(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid ALIAS FOR $1;
  _r RECORD;

BEGIN

  UPDATE itemloc
  SET itemloc_consolflag = TRUE
  WHERE (itemloc_itemsite_id=pItemsiteid);

  FOR _r IN SELECT itemloc_location_id, SUM(itemloc_qty) AS qty
            FROM itemloc
            WHERE (itemloc_itemsite_id=pItemsiteid)
            GROUP BY itemloc_location_id LOOP
    INSERT INTO itemloc
    ( itemloc_itemsite_id, itemloc_location_id,
      itemloc_expiration, itemloc_qty, itemloc_consolflag )
    VALUES
    ( pItemsiteid, _r.itemloc_location_id,
      endOfTime(), _r.qty, FALSE );
  END LOOP;

  DELETE FROM itemloc
  WHERE ( (itemloc_itemsite_id=pItemsiteid)
   AND (itemloc_consolflag) );

  RETURN 1;

END;
$_$;


ALTER FUNCTION public.consolidatelocations(integer) OWNER TO admin;

--
-- Name: convertcustomertoprospect(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION convertcustomertoprospect(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCustId     ALIAS FOR $1;
  _c          RECORD;
BEGIN
  SELECT * INTO _c
  FROM custinfo
  WHERE (cust_id=pCustId);

  INSERT INTO prospect (
        prospect_id, prospect_active, prospect_number,
        prospect_name, prospect_cntct_id, prospect_taxzone_id,
        prospect_salesrep_id, prospect_warehous_id, prospect_comments
  ) VALUES (
       _c.cust_id, _c.cust_active, _c.cust_number,
       _c.cust_name, _c.cust_cntct_id, _c.cust_taxzone_id,
       CASE WHEN(_c.cust_salesrep_id > 0) THEN _c.cust_salesrep_id
            ELSE NULL
       END,
       CASE WHEN(_c.cust_preferred_warehous_id > 0) THEN _c.cust_preferred_warehous_id
            ELSE NULL
       END,
       _c.cust_comments);

  DELETE FROM custinfo WHERE (cust_id=pCustId);

  RETURN pCustId;
END;
$_$;


ALTER FUNCTION public.convertcustomertoprospect(integer) OWNER TO admin;

--
-- Name: convertprospecttocustomer(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION convertprospecttocustomer(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  RETURN convertProspectToCustomer($1, FALSE);
END;
$_$;


ALTER FUNCTION public.convertprospecttocustomer(integer) OWNER TO admin;

--
-- Name: convertprospecttocustomer(integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION convertprospecttocustomer(integer, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pProspectId ALIAS FOR $1;
  pdoquotes   ALIAS FOR $2;
  _p          RECORD;
  _q          RECORD;

BEGIN
  SELECT * INTO _p
  FROM prospect
  WHERE (prospect_id=pProspectId);

  IF (EXISTS(SELECT cust_id FROM custinfo WHERE cust_id=pProspectId)) THEN
    RAISE EXCEPTION '[xtuple: convertProspectToCustomer, -10]';
  END IF;

  INSERT INTO custinfo (
        cust_id, cust_active, cust_number,
        cust_name, cust_cntct_id, cust_taxzone_id,
        cust_comments, cust_creditstatus,
        cust_salesrep_id, cust_preferred_warehous_id,
        cust_terms_id,
        cust_custtype_id, cust_shipform_id,
        cust_shipvia, cust_balmethod,
        cust_ffshipto, cust_backorder,
        cust_partialship, cust_creditlmt,
        cust_creditrating, cust_commprcnt,
        cust_discntprcnt, cust_blanketpos,
        cust_shipchrg_id, cust_ffbillto,
        cust_usespos, cust_emaildelivery,
        cust_autoupdatestatus,cust_autoholdorders,
        cust_soemaildelivery) 
  SELECT
      _p.prospect_id, _p.prospect_active, _p.prospect_number,
      _p.prospect_name, _p.prospect_cntct_id, _p.prospect_taxzone_id,
      _p.prospect_comments, 'G',
      COALESCE(_p.prospect_salesrep_id, salesrep_id),
      COALESCE(_p.prospect_warehous_id, -1),
      FetchMetricValue('DefaultTerms'),
      FetchMetricValue('DefaultCustType'),
      FetchMetricValue('DefaultShipFormId'),
      COALESCE(FetchMetricValue('DefaultShipViaId'),-1),
      FetchMetricText('DefaultBalanceMethod'),
      FetchMetricBool('DefaultFreeFormShiptos'),
      FetchMetricBool('DefaultBackOrders'),
      FetchMetricBool('DefaultPartialShipments'),
      FetchMetricValue('SOCreditLimit'),
      FetchMetricText('SOCreditRate'),
      salesrep_commission,
      0, false, -1,false,false,false,false,
      false, false
  FROM salesrep WHERE (salesrep_id=FetchMetricValue('DefaultSalesRep'));

  DELETE FROM prospect WHERE (prospect_id=pprospectId);

  IF (pdoquotes) THEN
    BEGIN
      FOR _q IN SELECT quhead_number, convertQuote(quhead_id) AS err
                  FROM quhead
                 WHERE ((COALESCE(quhead_expire, endOfTime()) >= CURRENT_DATE)
                    AND (quhead_cust_id=pProspectId)) LOOP
        IF (_q.err < 0) THEN
          RAISE NOTICE 'Quote % for % didn''t convert to a Sales Order [xtuple: convertQuote, %]',
                       _q.quhead_number, _p.prospect_number, _q.err;
        END IF;
      END LOOP;
    EXCEPTION WHEN OTHERS THEN
      RAISE NOTICE 'Ignored errors convering quotes: % %', SQLSTATE, SQLERRM;
    END;
  END IF;

  RETURN pProspectId;
END;
$_$;


ALTER FUNCTION public.convertprospecttocustomer(integer, boolean) OWNER TO admin;

--
-- Name: convertquote(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION convertquote(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pQuheadid ALIAS FOR $1;
  _soheadid INTEGER;
  _soitemid INTEGER;
  _orderid INTEGER;
  _ordertype CHARACTER(1);
  _creditstatus	TEXT;
  _usespos BOOLEAN := false;
  _blanketpos BOOLEAN := true;
  _showConvertedQuote BOOLEAN := false;
  _prospectid	INTEGER;
  _r RECORD;
  _soNum TEXT;

BEGIN

-- Check to make sure the quote has not expired
  IF (SELECT COALESCE(quhead_expire, endOfTime()) < CURRENT_DATE
        FROM quhead
       WHERE(quhead_id=pQuheadid)) THEN
    RETURN -6;
  END IF;

--  Check to make sure that all of the quote items have a valid itemsite
  SELECT quitem_id INTO _r
    FROM quitem LEFT OUTER JOIN itemsite ON (quitem_itemsite_id=itemsite_id)
   WHERE ((itemsite_id IS NULL)
     AND  (quitem_quhead_id=pQuheadid));
  IF (FOUND) THEN
    INSERT INTO evntlog (evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                         evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number)
    SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
           'Q', quhead_id, quhead_warehous_id, quhead_number
    FROM evntnot, evnttype, quhead
    WHERE ( (evntnot_evnttype_id=evnttype_id)
     AND (evntnot_warehous_id=quhead_warehous_id)
     AND (evnttype_name='CannotConvertQuote')
     AND (quhead_id=pQuheadid) );

    RETURN -1;
  END IF;

  SELECT cust_creditstatus, cust_usespos, cust_blanketpos
    INTO _creditstatus, _usespos, _blanketpos
  FROM quhead, custinfo
  WHERE ((quhead_cust_id=cust_id)
    AND  (quhead_id=pQuheadid));

  IF (NOT FOUND) THEN
    SELECT prospect_id INTO _prospectid
    FROM quhead, prospect
    WHERE ((quhead_cust_id=prospect_id)
      AND  (quhead_id=pQuheadid));
    IF (NOT FOUND) THEN
      RETURN -2;
    ELSE
      RETURN -3;
    END IF;
  ELSIF (_creditstatus = 'H' AND NOT checkPrivilege('CreateSOForHoldCustomer')) THEN
    RETURN -4;
  ELSIF (_creditstatus = 'W' AND NOT checkPrivilege('CreateSOForWarnCustomer')) THEN
    RETURN -5;
  END IF;

  IF ( (_usespos) AND (NOT _blanketpos) ) THEN
    PERFORM cohead_id
    FROM quhead JOIN cohead ON ( (cohead_cust_id=quhead_cust_id) AND
                                 (UPPER(cohead_custponumber)=UPPER(quhead_custponumber)) )
    WHERE (quhead_id=pQuheadid);
    IF (FOUND) THEN
      RAISE EXCEPTION 'Duplicate Customer PO';
    END IF;
  END IF;
  
  PERFORM quhead_number, cohead_id 
  FROM quhead, cohead 
  WHERE quhead_id = pQuheadid
  AND cohead_number = quhead_number;

  IF (FOUND) THEN
    SELECT fetchSoNumber() INTO _soNum;
  ELSE
    SELECT quhead_number INTO _soNum
    FROM quhead
    WHERE quhead_id = pQuheadid;
  END IF;

  SELECT NEXTVAL('cohead_cohead_id_seq') INTO _soheadid;
  INSERT INTO cohead
  ( cohead_id, cohead_number, cohead_cust_id,
    cohead_orderdate, cohead_packdate,
    cohead_custponumber, cohead_warehous_id,
    cohead_billtoname, cohead_billtoaddress1,
    cohead_billtoaddress2, cohead_billtoaddress3,
    cohead_billtocity, cohead_billtostate, cohead_billtozipcode,
    cohead_billtocountry,
    cohead_shipto_id, cohead_shiptoname, cohead_shiptoaddress1,
    cohead_shiptoaddress2, cohead_shiptoaddress3,
    cohead_shiptocity, cohead_shiptostate, cohead_shiptozipcode,
    cohead_shiptocountry,
    cohead_salesrep_id, cohead_commission,
    cohead_terms_id, cohead_shipchrg_id, cohead_shipform_id,
    cohead_fob, cohead_shipvia,
    cohead_ordercomments, cohead_shipcomments,
    cohead_freight, cohead_misc, cohead_misc_accnt_id, cohead_misc_descrip,
    cohead_holdtype, cohead_wasquote, cohead_quote_number, cohead_prj_id,
    cohead_curr_id, cohead_taxzone_id, cohead_taxtype_id,
    cohead_shipto_cntct_id, cohead_shipto_cntct_honorific, cohead_shipto_cntct_first_name,
    cohead_shipto_cntct_middle, cohead_shipto_cntct_last_name, cohead_shipto_cntct_suffix,
    cohead_shipto_cntct_phone, cohead_shipto_cntct_title, cohead_shipto_cntct_fax, 
    cohead_shipto_cntct_email,
    cohead_billto_cntct_id, cohead_billto_cntct_honorific,
    cohead_billto_cntct_first_name, cohead_billto_cntct_middle, cohead_billto_cntct_last_name, 
    cohead_billto_cntct_suffix, cohead_billto_cntct_phone, cohead_billto_cntct_title, 
    cohead_billto_cntct_fax, cohead_billto_cntct_email, cohead_ophead_id,
    cohead_calcfreight, cohead_saletype_id, cohead_shipzone_id )
  SELECT _soheadid, _soNum, quhead_cust_id,
         CURRENT_DATE, quhead_packdate,
         quhead_custponumber, quhead_warehous_id,
         quhead_billtoname, quhead_billtoaddress1,
         quhead_billtoaddress2, quhead_billtoaddress3,
         quhead_billtocity, quhead_billtostate, quhead_billtozip,
         quhead_billtocountry,
         quhead_shipto_id, quhead_shiptoname, quhead_shiptoaddress1,
         quhead_shiptoaddress2, quhead_shiptoaddress3,
         quhead_shiptocity, quhead_shiptostate, quhead_shiptozipcode,
         quhead_shiptocountry,
         quhead_salesrep_id, quhead_commission,
         quhead_terms_id, cust_shipchrg_id, cust_shipform_id,
         quhead_fob, quhead_shipvia,
         quhead_ordercomments, quhead_shipcomments,
         quhead_freight, quhead_misc, quhead_misc_accnt_id, quhead_misc_descrip,
         'N', TRUE, quhead_number, quhead_prj_id,
	 quhead_curr_id, quhead_taxzone_id, quhead_taxtype_id,
	 quhead_shipto_cntct_id, quhead_shipto_cntct_honorific,
	 quhead_shipto_cntct_first_name, quhead_shipto_cntct_middle, quhead_shipto_cntct_last_name,
	 quhead_shipto_cntct_suffix, quhead_shipto_cntct_phone, quhead_shipto_cntct_title,
	 quhead_shipto_cntct_fax, quhead_shipto_cntct_email, quhead_billto_cntct_id,
	 quhead_billto_cntct_honorific, quhead_billto_cntct_first_name, quhead_billto_cntct_middle,
	 quhead_billto_cntct_last_name, quhead_billto_cntct_suffix, quhead_billto_cntct_phone,
	 quhead_billto_cntct_title, quhead_billto_cntct_fax, quhead_billto_cntct_email, quhead_ophead_id,
         quhead_calcfreight, quhead_saletype_id, quhead_shipzone_id
  FROM quhead JOIN custinfo ON (cust_id=quhead_cust_id)
  WHERE (quhead_id=pQuheadid);

  UPDATE url SET url_source_id = _soheadid,
                 url_source = 'S'
  WHERE ((url_source='Q') AND (url_source_id = pQuheadid));

  UPDATE imageass SET imageass_source_id = _soheadid,
                      imageass_source = 'S'
  WHERE ((imageass_source='Q') AND (imageass_source_id = pQuheadid));

  UPDATE docass SET docass_source_id = _soheadid,
                    docass_source_type = 'S'
  WHERE ((docass_source_type='Q') AND (docass_source_id = pQuheadid));

  -- Copy Comments
  INSERT INTO comment
  ( comment_cmnttype_id, comment_source, comment_source_id, comment_date, comment_user, comment_text, comment_public )
  SELECT comment_cmnttype_id, 'S', _soheadid, comment_date, comment_user, ('Quote-' || comment_text), comment_public
  FROM comment
  WHERE ( (comment_source='Q')
    AND   (comment_source_id=pQuheadid) );

  FOR _r IN SELECT quitem.*,
                   quhead_number, quhead_prj_id,
                   itemsite_item_id, itemsite_leadtime,
                   itemsite_createsopo, itemsite_createsopr,
                   item_type, COALESCE(quitem_itemsrc_id, itemsrc_id, -1) AS itemsrcid
            FROM quhead JOIN quitem ON (quitem_quhead_id=quhead_id)
                        JOIN itemsite ON (itemsite_id=quitem_itemsite_id)
                        JOIN item ON (item_id=itemsite_item_id)
                        LEFT OUTER JOIN itemsrc ON ( (itemsrc_item_id=item_id) AND
                                                     (itemsrc_default) )
            WHERE (quhead_id=pQuheadid)
            ORDER BY quitem_linenumber LOOP

    SELECT NEXTVAL('coitem_coitem_id_seq') INTO _soitemid;

    INSERT INTO coitem
    ( coitem_id, coitem_cohead_id, coitem_linenumber, coitem_itemsite_id,
      coitem_status, coitem_scheddate, coitem_promdate,
      coitem_price, coitem_custprice, 
      coitem_qtyord, coitem_qtyshipped, coitem_qtyreturned,
      coitem_qty_uom_id, coitem_qty_invuomratio,
      coitem_price_uom_id, coitem_price_invuomratio,
      coitem_unitcost, coitem_prcost,
      coitem_custpn, coitem_memo, coitem_taxtype_id, coitem_order_id )
    VALUES
    ( _soitemid, _soheadid, _r.quitem_linenumber, _r.quitem_itemsite_id,
      'O', _r.quitem_scheddate, _r.quitem_promdate,
      _r.quitem_price, _r.quitem_custprice,
      _r.quitem_qtyord, 0, 0,
      _r.quitem_qty_uom_id, _r.quitem_qty_invuomratio,
      _r.quitem_price_uom_id, _r.quitem_price_invuomratio,
      stdcost(_r.itemsite_item_id), _r.quitem_prcost,
      _r.quitem_custpn, _r.quitem_memo, _r.quitem_taxtype_id, -1 );

    IF (fetchMetricBool('enablextcommissionission')) THEN
      PERFORM xtcommission.getSalesReps(quhead_cust_id, quhead_shipto_id,
                                        _r.itemsite_item_id, _r.quitem_price,
                                        _soitemid, 'SalesItem')
      FROM quhead
      WHERE (quhead_id=pQuheadid);
    END IF;

    INSERT INTO charass
          (charass_target_type, charass_target_id, charass_char_id, charass_value, charass_default, charass_price)
    SELECT 'SI', _soitemid, charass_char_id, charass_value, charass_default, charass_price
      FROM charass
     WHERE ((charass_target_type='QI')
       AND  (charass_target_id=_r.quitem_id));

    -- Copy Comments
    INSERT INTO comment
    ( comment_cmnttype_id, comment_source, comment_source_id, comment_date, comment_user, comment_text )
    SELECT comment_cmnttype_id, 'SI', _soitemid, comment_date, comment_user, ('Quote-' || comment_text)
    FROM comment
    WHERE ( (comment_source='QI')
      AND   (comment_source_id=_r.quitem_id) );

    _orderid := -1;
    _ordertype := '';
    IF (_r.quitem_createorder) THEN

      IF (_r.item_type IN ('M')) THEN
        SELECT createWo( CAST(_r.quhead_number AS INTEGER), supply.itemsite_id, 1, (_r.quitem_qtyord * _r.quitem_qty_invuomratio),
                         _r.itemsite_leadtime, _r.quitem_scheddate, _r.quitem_memo, 'S', _soitemid, _r.quhead_prj_id ) INTO _orderId
        FROM itemsite sold, itemsite supply
        WHERE ((sold.itemsite_item_id=supply.itemsite_item_id)
         AND (supply.itemsite_warehous_id=_r.quitem_order_warehous_id)
         AND (sold.itemsite_id=_r.quitem_itemsite_id) );
        _orderType := 'W';

        INSERT INTO charass
              (charass_target_type, charass_target_id, charass_char_id, charass_value)
        SELECT 'W', _orderId, charass_char_id, charass_value
          FROM charass
         WHERE ((charass_target_type='QI')
           AND  (charass_target_id=_r.quitem_id));

      ELSIF ( (_r.item_type IN ('P', 'O')) AND (_r.itemsite_createsopr) ) THEN
        SELECT createPr( CAST(_r.quhead_number AS INTEGER), _r.quitem_itemsite_id, (_r.quitem_qtyord * _r.quitem_qty_invuomratio),
                         _r.quitem_scheddate, '', 'S', _soitemid ) INTO _orderId;
        _orderType := 'R';
        UPDATE pr SET pr_prj_id=_r.quhead_prj_id WHERE pr_id=_orderId;
      ELSIF ( (_r.item_type IN ('P', 'O')) AND (_r.itemsite_createsopo) ) THEN
        IF (_r.quitem_prcost=0) THEN
          SELECT createPurchaseToSale(_soitemid, _r.itemsrcid, _r.quitem_dropship) INTO _orderId;
        ELSE
          SELECT createPurchaseToSale(_soitemid, _r.itemsrcid, _r.quitem_dropship, _r.quitem_prcost) INTO _orderId;
        END IF;
        _orderType := 'P';
      END IF;

      UPDATE coitem SET coitem_order_type=_ordertype, coitem_order_id=_orderid
      WHERE (coitem_id=_soitemid);

    END IF;

  END LOOP;

  SELECT metric_value INTO _showConvertedQuote
  FROM metric WHERE metric_name = 'ShowQuotesAfterSO';

  IF (_showConvertedQuote) THEN
    UPDATE quhead
    SET quhead_status= 'C'
    WHERE (quhead_id = pQuheadid);
  ELSE
  PERFORM deleteQuote(pQuheadid);
  END IF;

  RETURN _soheadid;

END;
$_$;


ALTER FUNCTION public.convertquote(integer) OWNER TO admin;

--
-- Name: convertquotetoinvoice(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION convertquotetoinvoice(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pQuheadid ALIAS FOR $1;
  _iheadid INTEGER;
  _iitemid INTEGER;
  _orderid INTEGER;
  _ordertype CHARACTER(1);
  _creditstatus	TEXT;
  _usespos BOOLEAN := false;
  _blanketpos BOOLEAN := true;
  _showConvertedQuote BOOLEAN := false;
  _prospectid	INTEGER;
  _r RECORD;
  _inNum TEXT;

BEGIN

-- Check to make sure the quote has not expired
  IF (SELECT COALESCE(quhead_expire, endOfTime()) < CURRENT_DATE
        FROM quhead
       WHERE(quhead_id=pQuheadid)) THEN
    RETURN -6;
  END IF;

--  Check to make sure that all of the quote items have a valid itemsite
  SELECT quitem_id INTO _r
    FROM quitem LEFT OUTER JOIN itemsite ON (quitem_itemsite_id=itemsite_id)
   WHERE ((itemsite_id IS NULL)
     AND  (quitem_quhead_id=pQuheadid));
  IF (FOUND) THEN
    INSERT INTO evntlog (evntlog_evnttime, evntlog_username, evntlog_evnttype_id,
                         evntlog_ordtype, evntlog_ord_id, evntlog_warehous_id, evntlog_number)
    SELECT CURRENT_TIMESTAMP, evntnot_username, evnttype_id,
           'Q', quhead_id, quhead_warehous_id, quhead_number
    FROM evntnot, evnttype, quhead
    WHERE ( (evntnot_evnttype_id=evnttype_id)
     AND (evntnot_warehous_id=quhead_warehous_id)
     AND (evnttype_name='CannotConvertQuote')
     AND (quhead_id=pQuheadid) );

    RETURN -1;
  END IF;

-- Get Credit Stat, Uses POs and Blanket POs

  SELECT cust_creditstatus, cust_usespos, cust_blanketpos
    INTO _creditstatus, _usespos, _blanketpos
  FROM quhead, custinfo
  WHERE ((quhead_cust_id=cust_id)
    AND  (quhead_id=pQuheadid));

-- Check to see if customer or prospect

  IF (NOT FOUND) THEN
    SELECT prospect_id INTO _prospectid
    FROM quhead, prospect
    WHERE ((quhead_cust_id=prospect_id)
      AND  (quhead_id=pQuheadid));
    IF (NOT FOUND) THEN
      RETURN -2;
    ELSE
      RETURN -3;
    END IF;
  ELSIF (_creditstatus = 'H' AND NOT hasPriv('CreateSOForHoldCustomer')) THEN
    RETURN -4;
  ELSIF (_creditstatus = 'W' AND NOT hasPriv('CreateSOForWarnCustomer')) THEN
    RETURN -5;
  END IF;

-- PO/blanket PO checks

  IF ( (_usespos) AND (NOT _blanketpos) ) THEN
    PERFORM invchead_id
    FROM quhead JOIN invchead ON ( (invchead_cust_id=quhead_cust_id) AND
                                 (UPPER(invchead_custponumber)=UPPER(quhead_custponumber)) )
    WHERE (quhead_id=pQuheadid);
    IF (FOUND) THEN
      RAISE EXCEPTION 'Duplicate Customer PO';
    END IF;
  END IF;

--Check to see if an invoice exists with the quote number
  
  PERFORM quhead_number, invchead_id 
  FROM quhead, invchead 
  WHERE quhead_id = pQuheadid
  AND invchead_invcnumber = quhead_number;

-- If it does then get a new Invoice number otherwise use the quote number as the invoice number

  IF (FOUND) THEN
    SELECT fetchinvcnumber() INTO _inNum;
  ELSE
    SELECT quhead_number INTO _inNum
    FROM quhead
    WHERE quhead_id = pQuheadid;
  END IF;

--Insert quote info into invoice tables

  SELECT NEXTVAL('invchead_invchead_id_seq') INTO _iheadid;
  INSERT INTO invchead
  ( invchead_ordernumber, invchead_shipdate, invchead_recurring,
    invchead_id, invchead_invcnumber, invchead_cust_id,
    invchead_orderdate, invchead_ponumber, 
    invchead_billto_name, invchead_billto_address1,
    invchead_billto_address2, invchead_billto_address3,
    invchead_billto_city, invchead_billto_state, invchead_billto_zipcode, invchead_billto_country,
    invchead_shipto_id, invchead_shipto_name, invchead_shipto_address1,
    invchead_shipto_address2, invchead_shipto_address3,
    invchead_shipto_city, invchead_shipto_state, invchead_shipto_zipcode, invchead_shipto_country, 
    invchead_salesrep_id, invchead_commission,
    invchead_terms_id, invchead_shipchrg_id, invchead_fob, invchead_shipvia,
    invchead_notes, invchead_freight, 
    invchead_misc_amount, invchead_misc_accnt_id, invchead_misc_descrip,
    invchead_prj_id, invchead_curr_id, invchead_taxzone_id,
    invchead_posted, invchead_printed, invchead_invcdate,
    invchead_saletype_id, invchead_shipzone_id
    --invchead_taxtype_id,
    --invchead_shipto_cntct_id, invchead_shipto_cntct_honorific, invchead_shipto_cntct_first_name,
    --invchead_shipto_cntct_middle, invchead_shipto_cntct_last_name, invchead_shipto_cntct_suffix,
    --invchead_shipto_cntct_phone, invchead_shipto_cntct_title, invchead_shipto_cntct_fax, 
    --invchead_shipto_cntct_email,
    --invchead_billto_cntct_id, invchead_billto_cntct_honorific,
    --invchead_billto_cntct_first_name, invchead_billto_cntct_middle, invchead_billto_cntct_last_name, 
    --invchead_billto_cntct_suffix, invchead_billto_cntct_phone, invchead_billto_cntct_title, 
    --invchead_billto_cntct_fax, invchead_billto_cntct_email, 
    --invchead_ophead_id,
    --invchead_calcfreight 
    )
  SELECT quhead_number, quhead_packdate, 'f',
         _iheadid, _inNum, quhead_cust_id,
         CURRENT_DATE, quhead_custponumber, 
         quhead_billtoname, quhead_billtoaddress1,
         quhead_billtoaddress2, quhead_billtoaddress3,
         quhead_billtocity, quhead_billtostate, quhead_billtozip, quhead_billtocountry,
         quhead_shipto_id, quhead_shiptoname, quhead_shiptoaddress1,
         quhead_shiptoaddress2, quhead_shiptoaddress3,
         quhead_shiptocity, quhead_shiptostate, quhead_shiptozipcode, quhead_shiptocountry,
         quhead_salesrep_id, quhead_commission,
         quhead_terms_id, cust_shipchrg_id, quhead_fob, quhead_shipvia,
         quhead_ordercomments,  quhead_freight,
         quhead_misc, quhead_misc_accnt_id, quhead_misc_descrip,
         quhead_prj_id, quhead_curr_id, quhead_taxzone_id,
         'f','f',current_date,
         quhead_saletype_id, quhead_shipzone_id
         --quhead_shipto_cntct_id, quhead_shipto_cntct_honorific,
	 --quhead_shipto_cntct_first_name, quhead_shipto_cntct_middle, quhead_shipto_cntct_last_name,
	 --quhead_shipto_cntct_suffix, quhead_shipto_cntct_phone, quhead_shipto_cntct_title,
	 --quhead_shipto_cntct_fax, quhead_shipto_cntct_email, quhead_billto_cntct_id,
	 --quhead_billto_cntct_honorific, quhead_billto_cntct_first_name, quhead_billto_cntct_middle,
	 --quhead_billto_cntct_last_name, quhead_billto_cntct_suffix, quhead_billto_cntct_phone,
	 --quhead_billto_cntct_title, quhead_billto_cntct_fax, quhead_billto_cntct_email, quhead_ophead_id,
         --quhead_calcfreight
  FROM quhead JOIN custinfo ON (cust_id=quhead_cust_id)
  WHERE (quhead_id=pQuheadid);

-- Attachments on Invoice not supported but leaving this in for future use:
/*
  UPDATE url SET url_source_id = _iheadid,
                 url_source = 'I'
  WHERE ((url_source='Q') AND (url_source_id = pQuheadid));

  UPDATE imageass SET imageass_source_id = _iheadid,
                      imageass_source = 'I'
  WHERE ((imageass_source='Q') AND (imageass_source_id = pQuheadid));

  UPDATE docass SET docass_source_id = _iheadid,
                    docass_source_type = 'I'
  WHERE ((docass_source_type='Q') AND (docass_source_id = pQuheadid));
*/


-- Comments not supported on Invoice but leaving this in for future use:

/*  
  INSERT INTO comment
  ( comment_cmnttype_id, comment_source, comment_source_id, comment_date, comment_user, comment_text, comment_public )
  SELECT comment_cmnttype_id, 'I', _iheadid, comment_date, comment_user, ('Quote-' || comment_text), comment_public
  FROM comment
  WHERE ( (comment_source='Q')
    AND   (comment_source_id=pQuheadid) );
*/

  FOR _r IN SELECT quitem.*,
                   quhead_number, quhead_prj_id,
                   itemsite_item_id, itemsite_leadtime,
                   itemsite_createsopo, itemsite_createsopr,
                   item_type, COALESCE(quitem_itemsrc_id, itemsrc_id, -1) AS itemsrcid
            FROM quhead JOIN quitem ON (quitem_quhead_id=quhead_id)
                        JOIN itemsite ON (itemsite_id=quitem_itemsite_id)
                        JOIN item ON (item_id=itemsite_item_id)
                        LEFT OUTER JOIN itemsrc ON ( (itemsrc_item_id=item_id) AND
                                                     (itemsrc_default) )
            WHERE (quhead_id=pQuheadid) LOOP

    SELECT NEXTVAL('invcitem_invcitem_id_seq') INTO _iitemid;

    INSERT INTO invcitem
    ( invcitem_id, invcitem_invchead_id, invcitem_linenumber, 
      invcitem_item_id,
      invcitem_warehous_id,
      --invcitem_status, 
      --invcitem_scheddate, invcitem_promdate,
      invcitem_price, invcitem_custprice, 
      invcitem_ordered, invcitem_billed,
      invcitem_qty_uom_id, invcitem_qty_invuomratio,
      invcitem_price_uom_id, invcitem_price_invuomratio,
      invcitem_custpn, invcitem_notes, invcitem_taxtype_id )
    VALUES
    ( _iitemid, _iheadid, _r.quitem_linenumber, 
      (SELECT itemsite_item_id FROM itemsite WHERE itemsite_id = _r.quitem_itemsite_id),
      (SELECT itemsite_warehous_id FROM itemsite WHERE itemsite_id = _r.quitem_itemsite_id),
      --'O', 
      --_r.quitem_scheddate, _r.quitem_promdate,
      _r.quitem_price, _r.quitem_custprice,
      _r.quitem_qtyord, _r.quitem_qtyord,
      _r.quitem_qty_uom_id, _r.quitem_qty_invuomratio,
      _r.quitem_price_uom_id, _r.quitem_price_invuomratio,
      _r.quitem_custpn, _r.quitem_memo, _r.quitem_taxtype_id );

    IF (fetchMetricBool('enablextcommissionission')) THEN
      PERFORM xtcommission.getSalesReps(quhead_cust_id, quhead_shipto_id,
                                        _r.itemsite_item_id, _r.quitem_price,
                                        _iitemid, 'InvoiceItem')
      FROM quhead
      WHERE (quhead_id=pQuheadid);
    END IF;

-- Chracteristics not supported on Invoice but leaving in for future use:

/*
    INSERT INTO charass
          (charass_target_type, charass_target_id, charass_char_id, charass_value, charass_default, charass_price)
    SELECT 'SI', _iitemid, charass_char_id, charass_value, charass_default, charass_price
      FROM charass
     WHERE ((charass_target_type='QI')
       AND  (charass_target_id=_r.quitem_id));
*/


-- Comments not supported but leaving in for future use

/*
    INSERT INTO comment
    ( comment_cmnttype_id, comment_source, comment_source_id, comment_date, comment_user, comment_text )
    SELECT comment_cmnttype_id, 'SI', _iitemid, comment_date, comment_user, ('Quote-' || comment_text)
    FROM comment
    WHERE ( (comment_source='QI')
      AND   (comment_source_id=_r.quitem_id) );
*/

    _orderid := -1;
    _ordertype := '';
    IF (_r.quitem_createorder) THEN

      IF (_r.item_type IN ('M')) THEN
        SELECT createWo( CAST(_r.quhead_number AS INTEGER), supply.itemsite_id, 1, (_r.quitem_qtyord * _r.quitem_qty_invuomratio),
                         _r.itemsite_leadtime, _r.quitem_scheddate, _r.quitem_memo, 'Q', _iitemid, _r.quhead_prj_id ) INTO _orderId
        FROM itemsite sold, itemsite supply
        WHERE ((sold.itemsite_item_id=supply.itemsite_item_id)
         AND (supply.itemsite_warehous_id=_r.quitem_order_warehous_id)
         AND (sold.itemsite_id=_r.quitem_itemsite_id) );
        _orderType := 'W';

        INSERT INTO charass
              (charass_target_type, charass_target_id, charass_char_id, charass_value)
        SELECT 'W', _orderId, charass_char_id, charass_value
          FROM charass
         WHERE ((charass_target_type='QI')
           AND  (charass_target_id=_r.quitem_id));

      ELSIF ( (_r.item_type IN ('P', 'O')) AND (_r.itemsite_createsopr) ) THEN
        SELECT createPr( CAST(_r.quhead_number AS INTEGER), _r.quitem_itemsite_id, (_r.quitem_qtyord * _r.quitem_qty_invuomratio),
                         _r.quitem_scheddate, '', 'S', _iitemid ) INTO _orderId;
        _orderType := 'R';
        UPDATE pr SET pr_prj_id=_r.quhead_prj_id WHERE pr_id=_orderId;
      ELSIF ( (_r.item_type IN ('P', 'O')) AND (_r.itemsite_createsopo) ) THEN
        IF (_r.quitem_prcost=0) THEN
-- For now quote to invoice/dropship will not be supported but with the creation of a createPurchaseToQuote() version of createPurchaseToSale()
-- it can be
--          SELECT createPurchaseToSale(_iitemid, _r.itemsrcid, _r.quitem_dropship) INTO _orderId;
            RAISE EXCEPTION 'Quote contains one or more dropship items that may not be converted from a Quote to an Invoice';
        ELSE
-- For now quote to invoice/dropship will not be supported but with the creation of a createPurchaseToQuote() version of createPurchaseToSale()
-- it can be
--          SELECT createPurchaseToSale(_iitemid, _r.itemsrcid, _r.quitem_dropship, _r.quitem_prcost) INTO _orderId;
            RAISE EXCEPTION 'Quote contains one or more dropship items that may not be converted from a Quote to an Invoice';
        END IF;
        _orderType := 'P';
      END IF;

--      UPDATE invcitem SET invcitem_order_type=_ordertype, invcitem_order_id=_orderid
--      WHERE (invcitem_id=_iitemid);

    END IF;

  END LOOP;

  SELECT metric_value INTO _showConvertedQuote
  FROM metric WHERE metric_name = 'ShowQuotesAfterSO';

  IF (_showConvertedQuote) THEN
    UPDATE quhead
    SET quhead_status= 'C'
    WHERE (quhead_id = pQuheadid);
  ELSE
     PERFORM deleteQuote(pQuheadid);
  END IF;

  RETURN _iheadid;

END;
$_$;


ALTER FUNCTION public.convertquotetoinvoice(integer) OWNER TO admin;

--
-- Name: copybom(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copybom(psitemid integer, ptitemid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _result INTEGER;

BEGIN

  SELECT copyBOM (pSItemid, PTItemid, FALSE) into _result;

  RETURN _result;

END;
$$;


ALTER FUNCTION public.copybom(psitemid integer, ptitemid integer) OWNER TO admin;

--
-- Name: copybom(integer, integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copybom(psitemid integer, ptitemid integer, pcopyusedat boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _bh RECORD;
  _bi RECORD;
  _bomheadid INTEGER;
  _bomitemid INTEGER;
  _bomworksetid INTEGER;
  _temp INTEGER;
  _schedatwooper BOOLEAN;
  _booitemseqid INTEGER;

BEGIN

--  Cache source bomhead
  SELECT * INTO _bh
  FROM bomhead
  WHERE ((bomhead_item_id=pSItemid)
    AND  (bomhead_rev_id=getActiveRevID('BOM', pSItemid)));

  IF (NOT FOUND) THEN
    RETURN -1;
  END IF;

--  Make sure that source bomitems exist
  SELECT bomitem_id INTO _bomitemid
  FROM bomitem
  WHERE ((bomitem_parent_item_id=_bh.bomhead_item_id)
    AND  (bomitem_rev_id=_bh.bomhead_rev_id))
  LIMIT 1;

  IF (NOT FOUND) THEN
    RETURN -2;
  END IF;

--  Make sure that target bomitems do not exist
  SELECT bomitem_id INTO _bomitemid
  FROM bomitem
  WHERE ((bomitem_parent_item_id=pTItemid)
    AND  (bomitem_rev_id= -1))
  LIMIT 1;

  IF (FOUND) THEN
    RETURN -3;
  END IF;

--  Make sure that the parent is not used in the component at some level
  IF ( SELECT (item_type IN ('M', 'F'))
       FROM item
       WHERE (item_id=pSItemid) ) THEN
    SELECT indentedWhereUsed(pTItemid) INTO _bomworksetid;
    SELECT bomwork_id INTO _temp
    FROM bomwork
    WHERE ( (bomwork_set_id=_bomworksetid)
     AND (bomwork_item_id=pSItemid) )
    LIMIT 1;
    IF (FOUND) THEN
      PERFORM deleteBOMWorkset(_bomworksetid);
      RETURN -4;
    END IF;
    PERFORM deleteBOMWorkset(_bomworksetid);
  END IF;

--  Check for existing target bomhead
  SELECT bomhead_id INTO _bomheadid
  FROM bomhead
  WHERE ((bomhead_item_id=pTItemid)
    AND  (bomhead_rev_id= -1));

  IF (NOT FOUND) THEN
    INSERT INTO bomhead
    ( bomhead_item_id, bomhead_serial, bomhead_docnum,
      bomhead_batchsize, bomhead_requiredqtyper )
    VALUES
    ( pTItemid, _bh.bomhead_serial, _bh.bomhead_docnum,
      _bh.bomhead_batchsize, _bh.bomhead_requiredqtyper );
  END IF;

  FOR _bi IN SELECT bomitem.*
             FROM bomitem(pSItemid) 
             WHERE (bomitem_expires>CURRENT_DATE) LOOP

    SELECT NEXTVAL('bomitem_bomitem_id_seq') INTO _bomitemid;

    IF (pCopyUsedAt) THEN
      _schedatwooper := _bi.bomitem_schedatwooper;
      _booitemseqid := _bi.bomitem_booitem_seq_id;
    ELSE
      _schedatwooper := FALSE;
      _booitemseqid := -1;
    END IF;

    INSERT INTO bomitem
    ( bomitem_id, bomitem_parent_item_id, bomitem_seqnumber, bomitem_item_id,
      bomitem_uom_id, bomitem_qtyfxd, bomitem_qtyper, bomitem_scrap, bomitem_schedatwooper,
      bomitem_booitem_seq_id,
      bomitem_effective, bomitem_expires, bomitem_ecn,
      bomitem_createwo, bomitem_issuemethod, bomitem_moddate, bomitem_subtype,
      bomitem_notes, bomitem_ref )
    VALUES
    ( _bomitemid, pTItemid, _bi.bomitem_seqnumber, _bi.bomitem_item_id,
      _bi.bomitem_uom_id, _bi.bomitem_qtyfxd, _bi.bomitem_qtyper, _bi.bomitem_scrap, _schedatwooper,
      _booitemseqid,
      CURRENT_DATE, _bi.bomitem_expires, _bi.bomitem_ecn,
      _bi.bomitem_createwo, _bi.bomitem_issuemethod, CURRENT_DATE, _bi.bomitem_subtype,
      _bi.bomitem_notes, _bi.bomitem_ref );

    INSERT INTO bomitemsub
    ( bomitemsub_bomitem_id, bomitemsub_item_id,
      bomitemsub_uomratio, bomitemsub_rank )
    SELECT _bomitemid, bomitemsub_item_id,
           bomitemsub_uomratio, bomitemsub_rank
    FROM bomitemsub
    WHERE (bomitemsub_bomitem_id=_bi.bomitem_id);

  END LOOP;

  RETURN pTItemid;

END;
$$;


ALTER FUNCTION public.copybom(psitemid integer, ptitemid integer, pcopyusedat boolean) OWNER TO admin;

--
-- Name: copybudget(integer, text, text, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copybudget(integer, text, text, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pBudgheadid ALIAS FOR $1;
  pName ALIAS FOR $2;
  pDescrip ALIAS FOR $3;
  pInterval ALIAS FOR $4;
  _budgheadid INTEGER;
  _periodid INTEGER;
  _result INTEGER;

BEGIN
  SELECT 1 INTO _result
    FROM budgitem
   WHERE ((budgitem_budghead_id=pBudgheadid)
     AND  (nextPeriodByInterval(budgitem_period_id, pInterval)=-1))
  LIMIT 1;
  IF (FOUND) THEN
    RETURN -1;
  END IF;

  SELECT nextval('budghead_budghead_id_seq') INTO _budgheadid;
  INSERT INTO budghead
        (budghead_id, budghead_name, budghead_descrip)
  VALUES(_budgheadid, pName, pDescrip);

  INSERT INTO budgitem (budgitem_budghead_id, budgitem_period_id,
                        budgitem_accnt_id, budgitem_amount)
  SELECT _budgheadid, nextPeriodByInterval(budgitem_period_id, pInterval),
         budgitem_accnt_id, budgitem_amount
    FROM budgitem
   WHERE (budgitem_budghead_id=pBudgheadid);

  RETURN _budgheadid;
END;
$_$;


ALTER FUNCTION public.copybudget(integer, text, text, integer) OWNER TO admin;

--
-- Name: copycmd(integer, text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copycmd(integer, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCmdId	ALIAS FOR $1;
  pModule	ALIAS FOR $2;
  pTitle	ALIAS FOR $3;
  _cmdId	INTEGER;
BEGIN
    SELECT nextval('cmd_cmd_id_seq') INTO _cmdId;

    INSERT INTO cmd 
      SELECT _cmdId, pModule, pTitle, cmd_descrip, cmd_privname, cmd_executable
      FROM cmd
      WHERE (cmd_id=pCmdId);

    INSERT INTO cmdarg (cmdarg_cmd_id, cmdarg_order, cmdarg_arg)
      SELECT _cmdId, cmdarg_order, cmdarg_arg
      FROM cmdarg
      WHERE (cmdarg_cmd_id=pCmdId);

    RETURN 1;
END;
$_$;


ALTER FUNCTION public.copycmd(integer, text, text) OWNER TO admin;

--
-- Name: copycontract(integer, text, date, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copycontract(pcontrctid integer, pnumber text, peffective date, pexpires date) RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _contrctid INTEGER;
  _itemsrcid INTEGER;
  _r RECORD;

BEGIN

  INSERT INTO contrct
  ( contrct_number,
    contrct_vend_id,
    contrct_descrip,
    contrct_effective,
    contrct_expires,
    contrct_note )
  SELECT
    pNumber,
    contrct_vend_id,
    contrct_descrip,
    pEffective,
    pExpires,
    contrct_note
  FROM contrct
  WHERE (contrct_id=pContrctid)
  RETURNING contrct_id INTO _contrctid;

  FOR _r IN
  SELECT * FROM itemsrc WHERE (itemsrc_contrct_id=pContrctid)
  LOOP
  INSERT INTO itemsrc
    ( itemsrc_item_id,
      itemsrc_vend_id,
      itemsrc_vend_item_number,
      itemsrc_vend_item_descrip,
      itemsrc_comments,
      itemsrc_vend_uom,
      itemsrc_invvendoruomratio,
      itemsrc_minordqty,
      itemsrc_multordqty,
      itemsrc_leadtime,
      itemsrc_ranking,
      itemsrc_active,
      itemsrc_manuf_name,
      itemsrc_manuf_item_number,
      itemsrc_manuf_item_descrip,
      itemsrc_default,
      itemsrc_upccode,
      itemsrc_effective,
      itemsrc_expires,
      itemsrc_contrct_id )
    VALUES
    ( _r.itemsrc_item_id,
      _r.itemsrc_vend_id,
      _r.itemsrc_vend_item_number,
      _r.itemsrc_vend_item_descrip,
      _r.itemsrc_comments,
      _r.itemsrc_vend_uom,
      _r.itemsrc_invvendoruomratio,
      _r.itemsrc_minordqty,
      _r.itemsrc_multordqty,
      _r.itemsrc_leadtime,
      _r.itemsrc_ranking,
      _r.itemsrc_active,
      _r.itemsrc_manuf_name,
      _r.itemsrc_manuf_item_number,
      _r.itemsrc_manuf_item_descrip,
      _r.itemsrc_default,
      _r.itemsrc_upccode,
      pEffective,
      pExpires,
      _contrctid )
    RETURNING itemsrc_id INTO _itemsrcid;

  INSERT INTO itemsrcp
    ( itemsrcp_itemsrc_id,
      itemsrcp_qtybreak,
      itemsrcp_price,
      itemsrcp_updated,
      itemsrcp_curr_id,
      itemsrcp_dropship,
      itemsrcp_warehous_id,
      itemsrcp_type,
      itemsrcp_discntprcnt,
      itemsrcp_fixedamtdiscount )
    SELECT
      _itemsrcid,
      itemsrcp_qtybreak,
      itemsrcp_price,
      CURRENT_DATE,
      itemsrcp_curr_id,
      itemsrcp_dropship,
      itemsrcp_warehous_id,
      itemsrcp_type,
      itemsrcp_discntprcnt,
      itemsrcp_fixedamtdiscount
    FROM itemsrcp
    WHERE (itemsrcp_itemsrc_id=_r.itemsrc_id);

  END LOOP;

  RETURN _contrctid;

END;
$$;


ALTER FUNCTION public.copycontract(pcontrctid integer, pnumber text, peffective date, pexpires date) OWNER TO admin;

--
-- Name: copyfinancialgroup(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyfinancialgroup(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSourceGroup ALIAS FOR $1;
  pFlheadid ALIAS FOR $2;
  pParentFlgrpid ALIAS FOR $3;

  _flgrpid INTEGER;

BEGIN

  SELECT nextval('flgrp_flgrp_id_seq') INTO _flgrpid;

-- Copy the group item
  INSERT INTO flgrp
         (flgrp_id, flgrp_flhead_id, flgrp_flgrp_id,
          flgrp_order, flgrp_name, flgrp_descrip,
          flgrp_subtotal, flgrp_summarize, flgrp_subtract,
          flgrp_showstart, flgrp_showend,
          flgrp_showdelta, flgrp_showbudget, flgrp_showdiff, flgrp_showcustom,
          flgrp_showstartprcnt, flgrp_showendprcnt,
          flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_showdiffprcnt, flgrp_showcustomprcnt,
          flgrp_usealtsubtotal, flgrp_altsubtotal,flgrp_prcnt_flgrp_id)
  SELECT _flgrpid, pFlheadid, pParentFlgrpid,
         flgrp_order, flgrp_name, flgrp_descrip,
         flgrp_subtotal, flgrp_summarize, flgrp_subtract,
         flgrp_showstart, flgrp_showend,
         flgrp_showdelta, flgrp_showbudget, flgrp_showdiff, flgrp_showcustom,
         flgrp_showstartprcnt, flgrp_showendprcnt,
         flgrp_showdeltaprcnt, flgrp_showbudgetprcnt, flgrp_showdiffprcnt, flgrp_showcustomprcnt,
         flgrp_usealtsubtotal, flgrp_altsubtotal,flgrp_prcnt_flgrp_id
    FROM flgrp
   WHERE (flgrp_id=pSourceGroup);

-- Store temporary cross ref info
   
   EXECUTE ' INSERT INTO tmp_flgrpxref' || getEffectiveXtUser() || ' (flgrpxref_oldid,flgrpxref_newid) VALUES (' || pSourceGroup || ',' || _flgrpid || ');';

-- Copy any children flitems
  INSERT INTO flitem
         (flitem_flhead_id, flitem_flgrp_id,
          flitem_order, flitem_accnt_id, flitem_showstart,
          flitem_showend, flitem_showdelta, flitem_showbudget, flitem_showdiff, flitem_showcustom,
          flitem_subtract, flitem_showstartprcnt,
          flitem_showendprcnt, flitem_showdeltaprcnt,
          flitem_showbudgetprcnt, flitem_showdiffprcnt, flitem_showcustomprcnt,
          flitem_custom_source, flitem_company, flitem_profit, flitem_number,
          flitem_sub, flitem_type, flitem_subaccnttype_code, flitem_prcnt_flgrp_id)
  SELECT pFlheadid, _flgrpid,
         flitem_order, flitem_accnt_id, flitem_showstart,
         flitem_showend, flitem_showdelta, flitem_showbudget, flitem_showdiff, flitem_showcustom,
         flitem_subtract, flitem_showstartprcnt,
         flitem_showendprcnt, flitem_showdeltaprcnt,
         flitem_showbudgetprcnt, flitem_showdiffprcnt, flitem_showcustomprcnt,
         flitem_custom_source, flitem_company, flitem_profit, flitem_number,
          flitem_sub, flitem_type, flitem_subaccnttype_code, flitem_prcnt_flgrp_id
    FROM flitem
   WHERE (flitem_flgrp_id=pSourceGroup);

-- Copy any children flspecs
  INSERT INTO flspec
         (flspec_flhead_id, flspec_flgrp_id,
          flspec_order, flspec_name, flspec_type, flspec_showstart,
          flspec_showend, flspec_showdelta, flspec_showbudget, flspec_showdiff, flspec_showcustom,
          flspec_subtract, flspec_showstartprcnt,
          flspec_showendprcnt, flspec_showdeltaprcnt,
          flspec_showbudgetprcnt, flspec_showdiffprcnt, flspec_showcustomprcnt,
          flspec_custom_source, flspec_prcnt_flgrp_id)
  SELECT pFlheadid, _flgrpid,
         flspec_order, flspec_name, flspec_type, flspec_showstart,
         flspec_showend, flspec_showdelta, flspec_showbudget, flspec_showdiff, flspec_showcustom,
         flspec_subtract, flspec_showstartprcnt,
         flspec_showendprcnt, flspec_showdeltaprcnt,
         flspec_showbudgetprcnt, flspec_showdiffprcnt, flspec_showcustomprcnt,
         flspec_custom_source, flspec_prcnt_flgrp_id
    FROM flspec
   WHERE (flspec_flgrp_id=pSourceGroup);

-- Copy the groups
  PERFORM copyFinancialGroup(flgrp_id, pFlheadid, _flgrpid)
     FROM flgrp
    WHERE (flgrp_flgrp_id=pSourceGroup);

  RETURN _flgrpid;
END;
$_$;


ALTER FUNCTION public.copyfinancialgroup(integer, integer, integer) OWNER TO admin;

--
-- Name: copyfinanciallayout(integer, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyfinanciallayout(integer, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSourceFlheadid ALIAS FOR $1;
  pDestName ALIAS FOR $2;

  _flheadid INTEGER;
  _tblName TEXT;

BEGIN

-- Check for the flhead to be copy that it exists
  PERFORM flhead_id
     FROM flhead
    WHERE (flhead_id=pSourceFlheadid);
  IF (NOT FOUND) THEN
    RETURN -1;
  END IF;

-- Check that the name is valid
  IF (pDestName IS NULL OR pDestName = '') THEN
    RETURN -2;
  END IF;

-- Check for the name to copy to does not exist
  PERFORM flhead_id
     FROM flhead
    WHERE (flhead_name=pDestName);
  IF (FOUND) THEN
    RETURN -3;
  END IF;

-- Copy the flhead record
  SELECT nextval('flhead_flhead_id_seq') INTO _flheadid;
  INSERT INTO flhead
         (flhead_id, flhead_name, flhead_descrip,
          flhead_showtotal, flhead_showstart,
          flhead_showend, flhead_showdelta, flhead_showbudget,
          flhead_showdiff, flhead_showcustom,
          flhead_custom_label,
          flhead_usealttotal, flhead_alttotal,
          flhead_usealtbegin, flhead_altbegin,
          flhead_usealtend, flhead_altend,
          flhead_usealtdebits, flhead_altdebits,
          flhead_usealtcredits, flhead_altcredits,
          flhead_usealtbudget, flhead_altbudget,
          flhead_usealtdiff, flhead_altdiff,
          flhead_type, flhead_active, flhead_sys
)
  SELECT _flheadid, pDestName, flhead_descrip,
         flhead_showtotal, flhead_showstart,
         flhead_showend, flhead_showdelta, flhead_showbudget,
         flhead_showdiff, flhead_showcustom,
         flhead_custom_label,
         flhead_usealttotal, flhead_alttotal,
         flhead_usealtbegin, flhead_altbegin,
         flhead_usealtend, flhead_altend,
         flhead_usealtdebits, flhead_altdebits,
         flhead_usealtcredits, flhead_altcredits,
         flhead_usealtbudget, flhead_altbudget,
         flhead_usealtdiff, flhead_altdiff,
         flhead_type, flhead_active, false
    FROM flhead
   WHERE (flhead_id=pSourceFlheadid);

-- Create temporary table so old and new group ids can be stored
 SELECT relname FROM pg_class INTO _tblName
 WHERE relname = 'tmp_flgrpxref';
 IF (_tblName IS NULL) THEN
  EXECUTE 'CREATE TEMPORARY TABLE tmp_flgrpxref' || getEffectiveXtUser() || ' 
  (
	flgrpxref_oldid int4,
	flgrpxref_newid int4
  ) ON COMMIT DROP;';
  END IF;

-- Copy the top level groups
  PERFORM copyFinancialGroup(flgrp_id, _flheadid, -1)
     FROM flgrp
    WHERE ((flgrp_flhead_id=pSourceFlheadid)
      AND  (flgrp_flgrp_id=-1));

-- Update Group Percent settings
  EXECUTE 'UPDATE flgrp
  SET flgrp_prcnt_flgrp_id=flgrpxref_newid
  FROM tmp_flgrpxref' || getEffectiveXtUser() || ' 
  WHERE ((flgrp_flhead_id=' || _flheadid || ')
  AND (flgrp_prcnt_flgrp_id=flgrpxref_oldid));';

  EXECUTE 'UPDATE flitem
  SET flitem_prcnt_flgrp_id=flgrpxref_newid
  FROM tmp_flgrpxref' || getEffectiveXtUser() || ' 
  WHERE ((flitem_flhead_id=' || _flheadid || ')
  AND (flitem_prcnt_flgrp_id=flgrpxref_oldid));';

  EXECUTE 'UPDATE flspec
  SET flspec_prcnt_flgrp_id=flgrpxref_newid
  FROM tmp_flgrpxref' || getEffectiveXtUser() || ' 
  WHERE ((flspec_flhead_id=' || _flheadid || ')
  AND (flspec_prcnt_flgrp_id=flgrpxref_oldid));';

-- Copy Column Layounts
  INSERT INTO flcol
        (flcol_flhead_id,
        flcol_name,
        flcol_descrip,
        flcol_report_id,
        flcol_month,
        flcol_quarter,
        flcol_year,
        flcol_showdb,
        flcol_prcnt,
        flcol_priortype,
        flcol_priormonth,
        flcol_priorquarter,
        flcol_prioryear,
        flcol_priorprcnt,
        flcol_priordiff,
        flcol_priordiffprcnt,
        flcol_budget,
        flcol_budgetprcnt,
        flcol_budgetdiff,
        flcol_budgetdiffprcnt
)
SELECT
        _flheadid,flcol_name,flcol_descrip,
        flcol_report_id,flcol_month,flcol_quarter,
        flcol_year,flcol_showdb,flcol_prcnt,
        flcol_priortype,flcol_priormonth,flcol_priorquarter,
        flcol_prioryear,flcol_priorprcnt,flcol_priordiff,
        flcol_priordiffprcnt,flcol_budget,flcol_budgetprcnt,
        flcol_budgetdiff,flcol_budgetdiffprcnt
FROM flcol
WHERE (flcol_flhead_id=pSourceFlheadid);

  RETURN _flheadid;
END;
$_$;


ALTER FUNCTION public.copyfinanciallayout(integer, text) OWNER TO admin;

--
-- Name: copyglseries(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyglseries(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSequence ALIAS FOR $1;
  _sequence INTEGER := fetchGLSequence();
  _journal INTEGER;	

BEGIN

  SELECT gltrans_journalnumber INTO _journal
  FROM gltrans
  WHERE ( gltrans_sequence=pSequence )
  LIMIT 1;

  IF (FOUND) THEN
    INSERT INTO glseries
    ( glseries_sequence, glseries_source, glseries_doctype, glseries_docnumber,
      glseries_notes, glseries_accnt_id, glseries_amount, glseries_distdate )
    SELECT _sequence, gltrans_source, gltrans_doctype, gltrans_docnumber,
           gltrans_notes, gltrans_accnt_id,
           gltrans_amount, gltrans_date
    FROM gltrans
    WHERE ( gltrans_sequence=pSequence );
  ELSE
    RAISE EXCEPTION 'g/l transaction sequence not found';
  END IF;

  RETURN _sequence;
END;
$_$;


ALTER FUNCTION public.copyglseries(integer) OWNER TO admin;

--
-- Name: copyincdt(integer, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyincdt(integer, timestamp with time zone) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pparentid   ALIAS FOR $1;
  ptimestamp  TIMESTAMP WITH TIME ZONE := COALESCE($2, CURRENT_TIMESTAMP);

  _alarmid    INTEGER;
  _incdtid    INTEGER;
  _todoitemid INTEGER;

BEGIN
  INSERT INTO incdt(incdt_number,          incdt_crmacct_id,
                    incdt_cntct_id,        incdt_summary,
                    incdt_descrip,         incdt_item_id,
                    incdt_timestamp,       incdt_incdtcat_id,
                    incdt_incdtseverity_id,incdt_incdtpriority_id,
                    incdt_owner_username,  incdt_recurring_incdt_id
           ) SELECT fetchIncidentNumber(), incdt_crmacct_id,
                    incdt_cntct_id,        incdt_summary,
                    incdt_descrip,         incdt_item_id,
                    ptimestamp,            incdt_incdtcat_id,
                    incdt_incdtseverity_id,incdt_incdtpriority_id,
                    incdt_owner_username,  incdt_recurring_incdt_id
               FROM incdt
              WHERE (incdt_id=pparentid)
  RETURNING incdt_id INTO _incdtid;

  IF (_incdtid IS NULL) THEN
    RETURN -10;
  END IF;

  SELECT MIN(copyTodoitem(todoitem_id, CAST(ptimestamp AS DATE), _incdtid))
            INTO _todoitemid
    FROM todoitem
   WHERE (todoitem_incdt_id=pparentid);

  IF (_todoitemid < 0) THEN
    RETURN _todoitemid;
  END IF;

  SELECT saveAlarm(NULL, NULL, CAST(ptimestamp AS DATE),
                   CAST(alarm_time - DATE_TRUNC('day',alarm_time) AS TIME),
                   alarm_time_offset,
                   alarm_time_qualifier,
                   alarm_event_recipient  IS NOT NULL, alarm_event_recipient,
                   alarm_email_recipient  IS NOT NULL, alarm_email_recipient,
                   alarm_sysmsg_recipient IS NOT NULL, alarm_sysmsg_recipient,
                   'INCDT', _incdtid, 'CHANGEONE')
    INTO _alarmid
    FROM alarm
   WHERE ((alarm_source='INCDT')
      AND (alarm_source_id=pparentid));

   IF (_alarmid < 0) THEN
     RETURN _alarmid;
   END IF;

   INSERT INTO docass (docass_source_id, docass_source_type,
                       docass_target_id, docass_target_type, docass_purpose
              ) SELECT _incdtid,       'INCDT',
                       docass_target_id, docass_target_type, docass_purpose
                  FROM docass
                 WHERE ((docass_source_id=pparentid)
                    AND (docass_source_type='INCDT'));

  RETURN _incdtid;
END;
$_$;


ALTER FUNCTION public.copyincdt(integer, timestamp with time zone) OWNER TO admin;

--
-- Name: copyinvoice(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyinvoice(integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pInvcheadid ALIAS FOR $1;
  _invcheadid INTEGER;
  _invcnumber TEXT;
  _invcdate DATE := COALESCE($2, CURRENT_DATE);
  _i RECORD;
  _l RECORD;
  _invcitemid INTEGER;

BEGIN
  SELECT *
    INTO _i
    FROM invchead
   WHERE(invchead_id=pInvcheadid);
  IF(NOT FOUND) THEN
    RETURN -1;
  END IF;

  _invcnumber := fetchInvcNumber();
  _invcheadid := nextval('invchead_invchead_id_seq');

  INSERT INTO invchead
        (invchead_id,
         invchead_cust_id, invchead_shipto_id,
         invchead_ordernumber, invchead_orderdate,
         invchead_posted, invchead_printed,
         invchead_invcnumber, invchead_invcdate, invchead_shipdate,
         invchead_ponumber, invchead_shipvia,
         invchead_fob, invchead_billto_name,
         invchead_billto_address1, invchead_billto_address2,
         invchead_billto_address3, invchead_billto_city,
         invchead_billto_state, invchead_billto_zipcode,
         invchead_billto_phone, invchead_shipto_name,
         invchead_shipto_address1, invchead_shipto_address2,
         invchead_shipto_address3, invchead_shipto_city,
         invchead_shipto_state, invchead_shipto_zipcode,
         invchead_shipto_phone, invchead_salesrep_id,
         invchead_commission,
         invchead_terms_id, invchead_freight,
         invchead_misc_amount,
         invchead_misc_descrip, invchead_misc_accnt_id,
         invchead_payment, invchead_paymentref,
         invchead_notes,
         invchead_billto_country, invchead_shipto_country,
         invchead_prj_id, invchead_curr_id,
         invchead_taxzone_id,
         invchead_recurring_invchead_id,
         invchead_saletype_id, invchead_shipzone_id)
  VALUES(_invcheadid,
         _i.invchead_cust_id, _i.invchead_shipto_id,
         _i.invchead_ordernumber, _i.invchead_orderdate,
         false, false,
         _invcnumber, _invcdate, _i.invchead_shipdate,
         _i.invchead_ponumber, _i.invchead_shipvia,
         _i.invchead_fob, _i.invchead_billto_name,
         _i.invchead_billto_address1, _i.invchead_billto_address2,
         _i.invchead_billto_address3, _i.invchead_billto_city,
         _i.invchead_billto_state, _i.invchead_billto_zipcode,
         _i.invchead_billto_phone, _i.invchead_shipto_name,
         _i.invchead_shipto_address1, _i.invchead_shipto_address2,
         _i.invchead_shipto_address3, _i.invchead_shipto_city,
         _i.invchead_shipto_state, _i.invchead_shipto_zipcode,
         _i.invchead_shipto_phone, _i.invchead_salesrep_id,
         _i.invchead_commission,
         _i.invchead_terms_id, _i.invchead_freight,
         _i.invchead_misc_amount,
         _i.invchead_misc_descrip, _i.invchead_misc_accnt_id,
         _i.invchead_payment, _i.invchead_paymentref,
         _i.invchead_notes,
         _i.invchead_billto_country, _i.invchead_shipto_country,
         _i.invchead_prj_id, _i.invchead_curr_id,
         _i.invchead_taxzone_id,
         _i.invchead_recurring_invchead_id,
         _i.invchead_saletype_id, _i.invchead_shipzone_id);

  FOR _l IN SELECT *
            FROM invcitem
            WHERE (invcitem_invchead_id=pInvcheadid) LOOP
    SELECT NEXTVAL('invcitem_invcitem_id_seq') INTO _invcitemid;

    INSERT INTO invcitem
        (invcitem_id, invcitem_invchead_id,
         invcitem_linenumber, invcitem_item_id,
         invcitem_warehous_id, invcitem_custpn,
         invcitem_number, invcitem_descrip,
         invcitem_ordered, invcitem_billed,
         invcitem_custprice, invcitem_price,
         invcitem_notes, invcitem_salescat_id,
         invcitem_taxtype_id,
         invcitem_qty_uom_id, invcitem_qty_invuomratio,
         invcitem_price_uom_id, invcitem_price_invuomratio,
         invcitem_coitem_id)
    VALUES
        (_invcitemid, _invcheadid,
         _l.invcitem_linenumber, _l.invcitem_item_id,
         _l.invcitem_warehous_id, _l.invcitem_custpn,
         _l.invcitem_number, _l.invcitem_descrip,
         _l.invcitem_ordered, _l.invcitem_billed,
         _l.invcitem_custprice, _l.invcitem_price,
         _l.invcitem_notes, _l.invcitem_salescat_id,
         _l.invcitem_taxtype_id,
         _l.invcitem_qty_uom_id, _l.invcitem_qty_invuomratio,
         _l.invcitem_price_uom_id, _l.invcitem_price_invuomratio,
         _l.invcitem_coitem_id);

  END LOOP;

  RETURN _invcheadid;
END;
$_$;


ALTER FUNCTION public.copyinvoice(integer, date) OWNER TO admin;

--
-- Name: copyitem(integer, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyitem(integer, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSItemid ALIAS FOR $1;
  pTItemNumber ALIAS FOR $2;
  _itemid INTEGER;
  _r RECORD;
  _id INTEGER;

BEGIN

  SELECT NEXTVAL('item_item_id_seq') INTO _itemid;
  INSERT INTO item
  ( item_id, item_number, item_descrip1, item_descrip2,
    item_classcode_id, item_type,
    item_active, item_picklist, item_sold, item_fractional,
    item_maxcost, item_prodweight, item_packweight,
    item_prodcat_id,item_exclusive, item_listprice, item_listcost,
    item_config, item_comments, item_extdescrip,
    item_upccode, item_inv_uom_id, item_price_uom_id )
  SELECT _itemid, pTItemNumber, item_descrip1, item_descrip2,
         item_classcode_id, item_type,
         item_active, item_picklist, item_sold, item_fractional,
         item_maxcost, item_prodweight, item_packweight,
         item_prodcat_id, item_exclusive, item_listprice, item_listcost,
         item_config, item_comments, item_extdescrip,
         item_upccode, item_inv_uom_id, item_price_uom_id
  FROM item
  WHERE (item_id=pSItemid);

  INSERT INTO imageass
  (imageass_source_id, imageass_source, imageass_image_id, imageass_purpose)
  SELECT _itemid, 'I', imageass_image_id, imageass_purpose
  FROM imageass
  WHERE ((imageass_source_id=pSItemid)
  AND (imageass_source='I'));
  
  INSERT INTO url
  (url_source_id, url_source, url_title, url_url)
  SELECT _itemid, 'I', url_title, url_url
  FROM url
  WHERE ((url_source_id=pSItemid)
  AND (url_source='I'));

  INSERT INTO itemtax
        (itemtax_item_id, itemtax_taxzone_id, itemtax_taxtype_id)
  SELECT _itemid, itemtax_taxzone_id, itemtax_taxtype_id
    FROM itemtax
   WHERE(itemtax_item_id=pSItemid);

  INSERT INTO charass
  ( charass_target_type, charass_target_id,
    charass_char_id, charass_value )
  SELECT 'I', _itemid, charass_char_id, charass_value
  FROM charass
  WHERE ( (charass_target_type='I')
   AND (charass_target_id=pSItemid) );

  FOR _r IN SELECT itemuomconv_id,
                   itemuomconv_from_uom_id,
                   itemuomconv_from_value,
                   itemuomconv_to_uom_id,
                   itemuomconv_to_value,
                   itemuomconv_fractional
              FROM itemuomconv
             WHERE(itemuomconv_item_id=pSItemid) LOOP
    SELECT nextval('itemuomconv_itemuomconv_id_seq') INTO _id;
    INSERT INTO itemuomconv
          (itemuomconv_id, itemuomconv_item_id,
           itemuomconv_from_uom_id, itemuomconv_from_value,
           itemuomconv_to_uom_id, itemuomconv_to_value,
           itemuomconv_fractional)
    VALUES(_id, _itemid,
           _r.itemuomconv_from_uom_id, _r.itemuomconv_from_value,
           _r.itemuomconv_to_uom_id, _r.itemuomconv_to_value,
           _r.itemuomconv_fractional);

    INSERT INTO itemuom
          (itemuom_itemuomconv_id, itemuom_uomtype_id)
    SELECT _id, itemuom_uomtype_id
      FROM itemuom
     WHERE(itemuom_itemuomconv_id=_r.itemuomconv_id);
  END LOOP;

  RETURN _itemid;

END;
$_$;


ALTER FUNCTION public.copyitem(integer, text) OWNER TO admin;

--
-- Name: copyitem(integer, text, boolean, boolean, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyitem(integer, text, boolean, boolean, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSItemid ALIAS FOR $1;
  pTItemNumber ALIAS FOR $2;
  pCopyBOM ALIAS FOR $3;
  pCopyBOO ALIAS FOR $4;        -- deprecated - xtmfg-specific
  pCopyCosts ALIAS FOR $5;
BEGIN
  RAISE NOTICE 'copyItem(INTEGER, TEXT, BOOLEAN, BOOLEAN, BOOLEAN) has been deprecated.  Use copyItem(INTEGER, TEXT) or copyItem(INTEGER, TEXT, BOOLEAN, BOOLEAN) or a package-specific version instead.';
  RETURN copyItem(pSItemid, pTItemNumber, pCopyBOM, pCopyCosts);
END;
$_$;


ALTER FUNCTION public.copyitem(integer, text, boolean, boolean, boolean) OWNER TO admin;

--
-- Name: copyitem(integer, text, boolean, boolean, boolean, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyitem(integer, text, boolean, boolean, boolean, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSItemid ALIAS FOR $1;
  pTItemNumber ALIAS FOR $2;
  pCopyBOM ALIAS FOR $3;
  pCopyBOO ALIAS FOR $4;        -- deprecated - xtmfg-specific
  pCopyCosts ALIAS FOR $5;
  pCopyUsedAt ALIAS FOR $6;     -- deprecated - xtmfg-specific
BEGIN
  RETURN copyItem(pSItemid, pTItemNumber, pCopyBOM, pCopyCosts);
END;
$_$;


ALTER FUNCTION public.copyitem(integer, text, boolean, boolean, boolean, boolean) OWNER TO admin;

--
-- Name: copyitem(integer, text, boolean, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyitem(integer, text, boolean, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSItemid      ALIAS FOR $1;
  pTItemNumber  ALIAS FOR $2;
  pCopyBOM      ALIAS FOR $3;
  pCopyCosts    ALIAS FOR $4;

  _itemid       INTEGER;
BEGIN

  _itemid := copyItem(pSItemid, pTItemNumber);

  IF (pCopyBOM) THEN
    PERFORM copyBOM(pSItemid, _itemid, FALSE);
  END IF;

  IF (pCopyCosts) THEN
    INSERT INTO itemcost
    ( itemcost_item_id, itemcost_costelem_id, itemcost_lowlevel,
      itemcost_stdcost, itemcost_posted,
      itemcost_actcost, itemcost_curr_id, itemcost_updated )
    SELECT _itemid, itemcost_costelem_id, itemcost_lowlevel,
      itemcost_stdcost, CURRENT_DATE,
      itemcost_actcost, itemcost_curr_id, CURRENT_DATE
    FROM itemcost
    WHERE (itemcost_item_id=pSItemid);
  END IF;

  RETURN _itemid;

END;
$_$;


ALTER FUNCTION public.copyitem(integer, text, boolean, boolean) OWNER TO admin;

--
-- Name: copyitemsite(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyitemsite(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pitemsiteid	ALIAS FOR $1;
  pdestwhsid	ALIAS FOR $2;
  _destwhs	whsinfo%ROWTYPE;
  _new		itemsite%ROWTYPE;

BEGIN
  -- make a copy of the old itemsite
  SELECT * INTO _new
  FROM itemsite
  WHERE (itemsite_id=pitemsiteid);
  IF (NOT FOUND) THEN
    RETURN -1;
  END IF;

  -- if there is no dest warehouse then perhaps the user is manually copying it
  IF (pdestwhsid IS NOT NULL) THEN
    SELECT * INTO _destwhs
    FROM whsinfo
    WHERE (warehous_id=pdestwhsid);
    IF (NOT FOUND) THEN
      RETURN -2;
    END IF;
  END IF;

  IF (NOT checkPrivilege('MaintainItemSites')) THEN
    RETURN -3;
  END IF;

  SELECT itemsite_id INTO _new.itemsite_id
  FROM itemsite
  WHERE ((itemsite_item_id=_new.itemsite_item_id)
    AND  (itemsite_warehous_id=pdestwhsid OR
	  (itemsite_warehous_id IS NULL AND pdestwhsid IS NULL)));
  IF (FOUND) THEN
    RETURN _new.itemsite_id;
  END IF;

  -- now override the things we know have to change
  _new.itemsite_id		:= NEXTVAL('itemsite_itemsite_id_seq');
  _new.itemsite_warehous_id	:= pdestwhsid;
  _new.itemsite_qtyonhand	:= 0;
  _new.itemsite_value           := 0;
  _new.itemsite_datelastcount	:= NULL;
  _new.itemsite_datelastused	:= NULL;
  _new.itemsite_nnqoh		:= 0;
  _new.itemsite_location_id    := -1;

  IF (_destwhs.warehous_transit) THEN
    _new.itemsite_reorderlevel	:= 0;
    _new.itemsite_ordertoqty	:= 0;
    _new.itemsite_soldranking	:= NULL;
    _new.itemsite_posupply	:= FALSE;
    _new.itemsite_wosupply	:= FALSE;
    _new.itemsite_loccntrl	:= FALSE;
    _new.itemsite_safetystock	:= 0;
    _new.itemsite_minordqty	:= 0;
    _new.itemsite_multordqty	:= 0;
    _new.itemsite_leadtime	:= 0;
    _new.itemsite_controlmethod	:= 'R';
    IF(_new.itemsite_costmethod='N') THEN
      _new.itemsite_costmethod := 'S';
    END IF;
    _new.itemsite_active	:= TRUE;
    -- ? _new.itemsite_plancode_id	:= -1;
    -- ? _new.itemsite_costcat_id	:= -1;
    _new.itemsite_eventfence	:= 1;
    _new.itemsite_sold		:= FALSE;
    _new.itemsite_stocked	:= FALSE;
    _new.itemsite_location_id	:= -1;
    _new.itemsite_useparams	:= FALSE;
    _new.itemsite_useparamsmanual := FALSE;
    _new.itemsite_createpr	:= FALSE;
    _new.itemsite_location	:= NULL;
    _new.itemsite_location_comments := NULL;
    _new.itemsite_notes		:= 'Transit Warehouse';
    _new.itemsite_nnqoh		:= 0;
    _new.itemsite_createwo	:= FALSE;
    _new.itemsite_costcat_id	:= _destwhs.warehous_costcat_id;
  END IF;

  INSERT INTO itemsite (
    itemsite_id,			itemsite_item_id,
    itemsite_warehous_id,		itemsite_qtyonhand,
    itemsite_costmethod,                itemsite_value,
    itemsite_reorderlevel,		itemsite_ordertoqty,
    itemsite_cyclecountfreq,		itemsite_datelastcount,
    itemsite_datelastused,
    itemsite_posupply,			itemsite_wosupply,
    itemsite_loccntrl,
    itemsite_safetystock,		itemsite_minordqty,
    itemsite_multordqty,		itemsite_leadtime,
    itemsite_abcclass,			itemsite_issuemethod,
    itemsite_controlmethod,		itemsite_active,
    itemsite_plancode_id,		itemsite_costcat_id,
    itemsite_eventfence,		itemsite_sold,
    itemsite_stocked,			itemsite_freeze,
    itemsite_location_id,
    itemsite_useparams,			itemsite_useparamsmanual,
    itemsite_soldranking,		itemsite_createpr,
    itemsite_location,			itemsite_location_comments,
    itemsite_notes,			itemsite_perishable,
    itemsite_nnqoh,			itemsite_autoabcclass,
    itemsite_ordergroup,		itemsite_disallowblankwip,
    itemsite_maxordqty,			itemsite_mps_timefence,
    itemsite_createwo,			itemsite_warrpurc,
    itemsite_autoreg,
    itemsite_planning_type,             itemsite_supply_itemsite_id
  ) VALUES (
    _new.itemsite_id,			_new.itemsite_item_id,
    _new.itemsite_warehous_id,		_new.itemsite_qtyonhand,
    _new.itemsite_costmethod,           _new.itemsite_value,
    _new.itemsite_reorderlevel,	        _new.itemsite_ordertoqty,
    _new.itemsite_cyclecountfreq,	_new.itemsite_datelastcount,
    _new.itemsite_datelastused,
    _new.itemsite_posupply,		_new.itemsite_wosupply,
    _new.itemsite_loccntrl,
    _new.itemsite_safetystock,		_new.itemsite_minordqty,
    _new.itemsite_multordqty,		_new.itemsite_leadtime,
    _new.itemsite_abcclass,		_new.itemsite_issuemethod,
    _new.itemsite_controlmethod,	_new.itemsite_active,
    _new.itemsite_plancode_id,		_new.itemsite_costcat_id,
    _new.itemsite_eventfence,		_new.itemsite_sold,
    _new.itemsite_stocked,		_new.itemsite_freeze,
    _new.itemsite_location_id,
    _new.itemsite_useparams,		_new.itemsite_useparamsmanual,
    _new.itemsite_soldranking,		_new.itemsite_createpr,
    _new.itemsite_location,		_new.itemsite_location_comments,
    _new.itemsite_notes,		_new.itemsite_perishable,
    _new.itemsite_nnqoh,		_new.itemsite_autoabcclass,
    _new.itemsite_ordergroup,		_new.itemsite_disallowblankwip,
    _new.itemsite_maxordqty,		_new.itemsite_mps_timefence,
    _new.itemsite_createwo,   	        _new.itemsite_warrpurc,
    _new.itemsite_autoreg,
    _new.itemsite_planning_type,        _new.itemsite_supply_itemsite_id
    );

  RETURN _new.itemsite_id;
END;
$_$;


ALTER FUNCTION public.copyitemsite(integer, integer) OWNER TO admin;

--
-- Name: copylocale(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copylocale(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pLocaleid ALIAS FOR $1;
  _localecode TEXT;
  _localeid INTEGER;

BEGIN

  SELECT locale_code INTO _localecode
  FROM locale
  WHERE (locale_id=pLocaleid);

  IF (NOT FOUND) THEN
    RAISE EXCEPTION 'Attempt to copy a non-existent locale-id.';
  END IF;

  IF (EXISTS(SELECT locale_id
             FROM locale
             WHERE (locale_code = (_localecode || '-COPY')))) THEN
    RAISE EXCEPTION 'Attempt to copy a Locale Code that already exists.';
  END IF;

  SELECT NEXTVAL('locale_locale_id_seq') INTO _localeid;

  INSERT INTO locale
        (locale_id, locale_code, locale_descrip,
         locale_lang_file,
         locale_dateformat,
         locale_currformat,
         locale_qtyformat,
         locale_comments,
         locale_qtyperformat,
         locale_salespriceformat,
         locale_extpriceformat,
         locale_timeformat,
         locale_timestampformat,
         local_costformat,
         locale_costformat,
         locale_purchpriceformat,
         locale_uomratioformat,
         locale_intervalformat,
         locale_lang_id,
         locale_country_id,
         locale_error_color,
         locale_warning_color,
         locale_emphasis_color,
         locale_altemphasis_color,
         locale_expired_color,
         locale_future_color,
         locale_curr_scale,
         locale_salesprice_scale,
         locale_purchprice_scale,
         locale_extprice_scale,
         locale_cost_scale,
         locale_qty_scale,
         locale_qtyper_scale,
         locale_uomratio_scale)
  SELECT _localeid, locale_code || '-COPY', '',
         locale_lang_file,
         locale_dateformat,
         locale_currformat,
         locale_qtyformat,
         locale_comments,
         locale_qtyperformat,
         locale_salespriceformat,
         locale_extpriceformat,
         locale_timeformat,
         locale_timestampformat,
         local_costformat,
         locale_costformat,
         locale_purchpriceformat,
         locale_uomratioformat,
         locale_intervalformat,
         locale_lang_id,
         locale_country_id,
         locale_error_color,
         locale_warning_color,
         locale_emphasis_color,
         locale_altemphasis_color,
         locale_expired_color,
         locale_future_color,
         locale_curr_scale,
         locale_salesprice_scale,
         locale_purchprice_scale,
         locale_extprice_scale,
         locale_cost_scale,
         locale_qty_scale,
         locale_qtyper_scale,
         locale_uomratio_scale
    FROM locale
   WHERE(locale_id=pLocaleid);

  RETURN _localeid;

END;
$_$;


ALTER FUNCTION public.copylocale(integer) OWNER TO admin;

--
-- Name: copypo(integer, integer, date, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copypo(integer, integer, date, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSrcid		ALIAS FOR $1;
  pVendid		ALIAS FOR $2;
  pOrderdate		ALIAS FOR $3;
  pRecheckVendinfo	ALIAS FOR $4;

  _tgtid		INTEGER;
  _orderdate		DATE;
  _head			RECORD;
  _itemsrc		RECORD;
  _lineitem		RECORD;
  _qty			NUMERIC;
  _unitprice		NUMERIC;
  _uomratio		NUMERIC;
  _vend_restrictpurch	BOOLEAN;

BEGIN
  SELECT * INTO _head FROM pohead WHERE pohead_id = pSrcid;
  IF (NOT FOUND) THEN
    RETURN -1;
  END IF;
  IF (_head.pohead_vend_id != pVendid) THEN
    RETURN -2;		-- not supported now but should be in the future
  END IF;		-- when enabled, set pRecheckVendinfo if vendors don't match

  IF (pOrderdate IS NULL) THEN
    _orderdate := CURRENT_DATE;
  ELSE
    _orderdate := pOrderdate;
  END IF;

  INSERT INTO pohead (pohead_status, pohead_number,
		      pohead_orderdate, pohead_vend_id,
		      pohead_fob, pohead_shipvia,
		      pohead_freight, pohead_printed,
		      pohead_terms_id, pohead_warehous_id,
		      pohead_vendaddr_id, pohead_agent_username,
		      pohead_curr_id, pohead_saved,
                      pohead_taxtype_id, pohead_taxzone_id,
                      pohead_dropship, pohead_vend_cntct_id,
                      pohead_vend_cntct_honorific, pohead_vend_cntct_first_name,
                      pohead_vend_cntct_middle, pohead_vend_cntct_last_name,
                      pohead_vend_cntct_suffix, pohead_vend_cntct_phone,
                      pohead_vend_cntct_title, pohead_vend_cntct_fax,
                      pohead_vend_cntct_email, pohead_vendaddress1,
                      pohead_vendaddress2, pohead_vendaddress3,
                      pohead_vendcity, pohead_vendstate,
                      pohead_vendzipcode, pohead_vendcountry,
                      pohead_shipto_cntct_id,
                      pohead_shipto_cntct_honorific, pohead_shipto_cntct_first_name,
                      pohead_shipto_cntct_middle, pohead_shipto_cntct_last_name,
                      pohead_shipto_cntct_suffix, pohead_shipto_cntct_phone,
                      pohead_shipto_cntct_title, pohead_shipto_cntct_fax,
                      pohead_shipto_cntct_email, pohead_shiptoaddress_id,
                      pohead_shiptoaddress1,
                      pohead_shiptoaddress2, pohead_shiptoaddress3,
                      pohead_shiptocity, pohead_shiptostate,
                      pohead_shiptozipcode, pohead_shiptocountry
	      ) VALUES (
		      'U', fetchPoNumber(),
		      _orderdate, _head.pohead_vend_id,
		      _head.pohead_fob, _head.pohead_shipvia,
		      _head.pohead_freight, false,
		      _head.pohead_terms_id, _head.pohead_warehous_id,
		      _head.pohead_vendaddr_id, _head.pohead_agent_username,
		      _head.pohead_curr_id, true,
                      _head.pohead_taxtype_id, _head.pohead_taxzone_id,
                      false, _head.pohead_vend_cntct_id,
                      _head.pohead_vend_cntct_honorific, _head.pohead_vend_cntct_first_name,
                      _head.pohead_vend_cntct_middle, _head.pohead_vend_cntct_last_name,
                      _head.pohead_vend_cntct_suffix, _head.pohead_vend_cntct_phone,
                      _head.pohead_vend_cntct_title, _head.pohead_vend_cntct_fax,
                      _head.pohead_vend_cntct_email, _head.pohead_vendaddress1,
                      _head.pohead_vendaddress2, _head.pohead_vendaddress3,
                      _head.pohead_vendcity, _head.pohead_vendstate,
                      _head.pohead_vendzipcode, _head.pohead_vendcountry,
                      _head.pohead_shipto_cntct_id,
                      _head.pohead_shipto_cntct_honorific, _head.pohead_shipto_cntct_first_name,
                      _head.pohead_shipto_cntct_middle, _head.pohead_shipto_cntct_last_name,
                      _head.pohead_shipto_cntct_suffix, _head.pohead_shipto_cntct_phone,
                      _head.pohead_shipto_cntct_title, _head.pohead_shipto_cntct_fax,
                      _head.pohead_shipto_cntct_email, _head.pohead_shiptoaddress_id,
                      _head.pohead_shiptoaddress1,
                      _head.pohead_shiptoaddress2, _head.pohead_shiptoaddress3,
                      _head.pohead_shiptocity, _head.pohead_shiptostate,
                      _head.pohead_shiptozipcode, _head.pohead_shiptocountry);

  _tgtid := CURRVAL('pohead_pohead_id_seq');

  IF (pRecheckVendinfo) THEN
    SELECT vend_restrictpurch INTO _vend_restrictpurch
      FROM vendinfo WHERE (vend_id = pVendid);

    FOR _lineitem IN SELECT *
		  FROM poitem 
		  WHERE (poitem_pohead_id = pSrcid) LOOP

      SELECT * INTO _itemsrc
      FROM itemsrc, itemsite
      WHERE (itemsrc_active
        AND  (itemsrc_id = _lineitem.poitem_itemsrc_id)
	AND  (itemsite_id = _lineitem.poitem_itemsite_id));
      IF (NOT FOUND AND _vend_restrictpurch) THEN
	RETURN -3;
      END IF;

      -- handle changes to the uom ratio and consequent qty changes
      _uomratio := COALESCE(_itemsrc.itemsrc_invvendoruomratio, _lineitem.poitem_invvenduomratio);
      IF (_itemsrc.itemsrc_invvendoruomratio IS NULL
	  OR _itemsrc.itemsrc_invvendoruomratio != _lineitem.poitem_invvenduomratio) THEN
	_qty := _lineitem.poitem_qty_ordered;

      ELSE
	_qty := _lineitem.poitem_qty_ordered * _lineitem.poitem_invvenduomratio /
					       _itemsrc.itemsrc_invvendoruomratio;
	IF (_itemsrc.itemsrc_minordqty IS NOT NULL) THEN
	  IF (_qty < _itemsrc.itemsrc_minordqty) THEN
	    _qty := _itemsrc.itemsrc_minordqty;
	  ELSIF (_itemsrc.itemsrc_multordqty > 0
		   AND _qty % _itemsrc.itemsrc_multordqty > 0) THEN
	    _qty = _qty % _itemsrc.itemsrc_multordqty + _itemsrc.itemsrc_multordqty;
	  END IF;
	END IF;
      END IF;

      IF (_itemsrc.itemsrc_id IS NULL) THEN
	_unitprice = _lineitem.poitem_unitprice;
      ELSE
        SELECT itemsrcPrice(_itemsrc.itemsrc_id, _head.pohead_warehous_id, _head.pohead_dropship,
                            _lineitem.poitem_qty_ordered, _head.pohead_curr_id, CURRENT_DATE) INTO _unitprice;
	IF (_unitprice IS NULL) THEN
	  RETURN -4;
	END IF;
      END IF;

      INSERT INTO poitem (poitem_status, poitem_pohead_id, poitem_linenumber,
			  poitem_duedate,
			  poitem_itemsite_id,
			  poitem_vend_item_descrip,
			  poitem_vend_uom,
			  poitem_invvenduomratio,
			  poitem_qty_ordered, poitem_unitprice,
			  poitem_vend_item_number,
			  poitem_comments, poitem_expcat_id,
			  poitem_itemsrc_id,
			  poitem_freight,
			  poitem_stdcost,
			  poitem_manuf_name,
			  poitem_manuf_item_number,
			  poitem_manuf_item_descrip,
                          poitem_taxtype_id
		    ) VALUES (
			  'U', _tgtid, _lineitem.poitem_linenumber,
			  _orderdate + COALESCE(_itemsrc.itemsrc_leadtime, 0),
			  _lineitem.poitem_itemsite_id,
			  COALESCE(_itemsrc.itemsrc_vend_item_descrip,
				   _lineitem.poitem_vend_item_descrip),
			  COALESCE(_itemsrc.itemsrc_vend_uom, _lineitem.poitem_vend_uom),
			  COALESCE(_itemsrc.itemsrc_invvendoruomratio,
				   _lineitem.poitem_invvenduomratio),
			  _qty, _unitprice,
			  COALESCE(_itemsrc.itemsrc_vend_item_number,
				   _lineitem.poitem_vend_item_number),
			  _lineitem.poitem_comments, _lineitem.poitem_expcat_id,
			  COALESCE(_itemsrc.itemsrc_id, -1),
			  _lineitem.poitem_freight,
			  stdcost(_itemsrc.itemsite_item_id),
			  COALESCE(_itemsrc.itemsrc_manuf_name,
				   _lineitem.poitem_manuf_name),
		          COALESCE(_itemsrc.itemsrc_manuf_item_number,
				   _lineitem.poitem_manuf_item_number),
			  COALESCE(_itemsrc.itemsrc_manuf_item_descrip,
				   _lineitem.poitem_manuf_item_descrip),
                          _lineitem.poitem_taxtype_id);

    END LOOP;
  ELSE
    INSERT INTO poitem (poitem_status, poitem_pohead_id, poitem_linenumber,
			poitem_duedate, poitem_itemsite_id,
			poitem_vend_item_descrip, poitem_vend_uom,
			poitem_invvenduomratio, poitem_qty_ordered,
			poitem_unitprice,
			poitem_vend_item_number, poitem_comments,
			poitem_expcat_id, poitem_itemsrc_id, poitem_freight,
			poitem_stdcost, poitem_manuf_name, 
			poitem_manuf_item_number, poitem_manuf_item_descrip,
                        poitem_taxtype_id
		) SELECT 'U', _tgtid, poitem_linenumber,
			_orderdate + COALESCE(itemsrc_leadtime, 0), poitem_itemsite_id,
			poitem_vend_item_descrip, poitem_vend_uom,
			poitem_invvenduomratio, poitem_qty_ordered,
			poitem_unitprice,
			poitem_vend_item_number, poitem_comments,
			poitem_expcat_id, poitem_itemsrc_id, poitem_freight,
			stdcost(itemsite_item_id), poitem_manuf_name,
			poitem_manuf_item_number, poitem_manuf_item_descrip,
                        poitem_taxtype_id
		  FROM poitem
		    LEFT OUTER JOIN itemsrc ON (itemsrc_id=poitem_itemsrc_id)
		    LEFT OUTER JOIN itemsite ON (itemsite_id=poitem_itemsite_id)
		  WHERE (poitem_pohead_id = pSrcid);
  END IF;

  -- Todo: recalculate tax?

  RETURN _tgtid;

END;
$_$;


ALTER FUNCTION public.copypo(integer, integer, date, boolean) OWNER TO admin;

--
-- Name: copypricingschedule(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copypricingschedule(pipsheadid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _ipsheadid INTEGER;
  _ipsitemid INTEGER;
  _ipsfreightid INTEGER;
  _x RECORD;

BEGIN

  _ipsheadid := nextval('ipshead_ipshead_id_seq');
  INSERT INTO ipshead 
  ( ipshead_id, ipshead_name, ipshead_descrip,
    ipshead_effective, ipshead_expires, 
    ipshead_curr_id, ipshead_updated ) 
  SELECT _ipsheadid, orig.ipshead_name || (SELECT CAST((COUNT(cnt.ipshead_id)+1) AS text)
				            FROM ipshead cnt
				            WHERE (SUBSTRING(cnt.ipshead_name FROM 0 FOR char_length(orig.ipshead_name)+1) = orig.ipshead_name)),
	 orig.ipshead_descrip, orig.ipshead_effective, orig.ipshead_expires, 
	 orig.ipshead_curr_id, CURRENT_DATE
  FROM ipshead orig
  WHERE (orig.ipshead_id=pIpsheadId);

  FOR _x IN
    SELECT ipsitem_id FROM ipsiteminfo WHERE (ipsitem_ipshead_id=pIpsheadid)
  LOOP 
      INSERT INTO ipsiteminfo 
          (ipsitem_ipshead_id, ipsitem_item_id, ipsitem_prodcat_id,
           ipsitem_qtybreak, ipsitem_price,
           ipsitem_qty_uom_id, ipsitem_price_uom_id,
           ipsitem_discntprcnt, ipsitem_fixedamtdiscount,
           ipsitem_type, ipsitem_warehous_id) 
      SELECT _ipsheadid, ipsitem_item_id, ipsitem_prodcat_id,
           ipsitem_qtybreak, ipsitem_price,
           ipsitem_qty_uom_id, ipsitem_price_uom_id,
           ipsitem_discntprcnt, ipsitem_fixedamtdiscount,
           ipsitem_type, ipsitem_warehous_id
      FROM ipsiteminfo 
      WHERE (ipsitem_id=_x.ipsitem_id)
      RETURNING ipsitem_id INTO _ipsitemid; 

      INSERT INTO ipsitemchar
        ( ipsitemchar_ipsitem_id, ipsitemchar_char_id,
          ipsitemchar_value, ipsitemchar_price)
      SELECT  _ipsitemid, ipsitemchar_char_id,
          ipsitemchar_value, ipsitemchar_price
      FROM ipsitemchar
      WHERE (ipsitemchar_ipsitem_id=_x.ipsitem_id);
  END LOOP;

  FOR _x IN
    SELECT ipsfreight_id FROM ipsfreight WHERE (ipsfreight_ipshead_id=pIpsheadid)
  LOOP 
      _ipsfreightid := nextval('ipsfreight_ipsfreight_id_seq');
      INSERT INTO ipsfreight
          (ipsfreight_id, ipsfreight_ipshead_id, 
           ipsfreight_qtybreak, ipsfreight_price,
           ipsfreight_type, ipsfreight_warehous_id,
           ipsfreight_shipzone_id,ipsfreight_freightclass_id,
           ipsfreight_shipvia) 
      SELECT _ipsfreightid, _ipsheadid, ipsfreight_qtybreak, 
           ipsfreight_price,ipsfreight_type, 
           ipsfreight_warehous_id,ipsfreight_shipzone_id,
           ipsfreight_freightclass_id,ipsfreight_shipvia
      FROM ipsfreight
      WHERE (ipsfreight_id=_x.ipsfreight_id); 

  END LOOP;

  RETURN _ipsheadid;

END;
$$;


ALTER FUNCTION public.copypricingschedule(pipsheadid integer) OWNER TO admin;

--
-- Name: copyprj(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyprj(integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pparentid   ALIAS FOR $1;
  _counter    INTEGER;
  _duedate    DATE := COALESCE($2, CURRENT_DATE);
  _alarmid    INTEGER;
  _i          INTEGER;
  _newnumber  TEXT;
  _p          RECORD;
  _prjid      INTEGER;
  _testnumber TEXT;

BEGIN
  RAISE DEBUG 'copyPrj(%, %) entered', pparentid, _duedate;

  SELECT * INTO _p
  FROM prj
  WHERE (prj_id=pparentid);

  -- new number = old number up to but not including -, followed by _duedate
  -- e.g. REPAIR-FRIDGE becomes REPAIR-2010-05-15
  --  but REPAIR_FRIDGE becomes REPAIR_FRIDGE-2010-05-15
  IF (_p.prj_recurring_prj_id IS NULL) THEN
    _newnumber := _p.prj_number;
  ELSE
    _newnumber := SUBSTRING(_p.prj_number FROM '[^-]*');
    IF (_newnumber IS NULL) THEN
      _newnumber := _p.prj_number;
    END IF;
  END IF;
  _newnumber := _newnumber || '-' || to_char(_duedate, 'YYYY-MM-DD');
  
  RAISE DEBUG 'copyPrj checking if _newnumber % exists', _newnumber;
  SELECT MAX(prj_number) INTO _testnumber
    FROM prj
   WHERE (prj_number ~ ('^' || _newnumber));
  IF (_testnumber = _newnumber) THEN
    _newnumber := _newnumber || '-001';
  ELSIF (_testnumber IS NOT NULL) THEN
    _counter := CAST(SUBSTRING(_testnumber FROM '...$') AS INTEGER);
    _counter := _counter + 1;
    _newnumber := REGEXP_REPLACE(_testnumber, '...$', to_char(_counter, 'FM009'));
  END IF;
  RAISE DEBUG 'copyPrj _newnumber is now %', _newnumber;

  INSERT INTO prj(
            prj_number,     prj_name,           prj_descrip,
            prj_status,     prj_so,             prj_wo,
            prj_po,         prj_owner_username,
            prj_due_date,   prj_username,       prj_recurring_prj_id
  ) SELECT  _newnumber,     _p.prj_name,        _p.prj_descrip,
            'P',            _p.prj_so,          _p.prj_wo,
            _p.prj_po,      _p.prj_owner_username,
            _duedate,       _p.prj_username,    _p. prj_recurring_prj_id
      FROM prj
     WHERE (prj_id=pparentid)
  RETURNING prj_id INTO _prjid;

  IF (_prjid IS NULL) THEN
    RETURN -1;
  END IF;

  SELECT saveAlarm(NULL, NULL, _duedate,
                   CAST(alarm_time - DATE_TRUNC('day',alarm_time) AS TIME),
                   alarm_time_offset,
                   alarm_time_qualifier,
                   alarm_event_recipient  IS NOT NULL, alarm_event_recipient,
                   alarm_email_recipient  IS NOT NULL, alarm_email_recipient,
                   alarm_sysmsg_recipient IS NOT NULL, alarm_sysmsg_recipient,
                   'J', _prjid, 'CHANGEONE')
    INTO _alarmid
    FROM alarm
   WHERE ((alarm_source='J')
      AND (alarm_source_id=pparentid));

   IF (_alarmid < 0) THEN
     RETURN _alarmid;
   END IF;

  RETURN _prjid;
END;
$_$;


ALTER FUNCTION public.copyprj(integer, date) OWNER TO admin;

--
-- Name: copyproject(integer, text, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyproject(integer, text, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pPrjId ALIAS FOR $1;
  pPrjNumber ALIAS FOR $2;
  pDueDateOffset ALIAS FOR $3;
  _prjid INTEGER;

BEGIN

  IF (COALESCE(pPrjNumber, '') = '') THEN
    RETURN -1;
  END IF;

  IF (EXISTS(SELECT prj_id FROM prj WHERE UPPER(prj_number)=UPPER(pPrjNumber))) THEN
    RETURN -2;
  END IF;

  IF (NOT EXISTS(SELECT prj_id FROM prj WHERE prj_id=pPrjId)) THEN
    RETURN -3;
  END IF;

  SELECT NEXTVAL('prj_prj_id_seq') INTO _prjid;

  INSERT INTO prj
  ( prj_id, prj_number, prj_name, 
    prj_descrip, prj_status,
    prj_so, prj_wo, prj_po,
    prj_owner_username, prj_start_date,
    prj_due_date, prj_assigned_date, prj_completed_date,
    prj_username, prj_recurring_prj_id,
    prj_crmacct_id, prj_cntct_id )
  SELECT _prjid, UPPER(pPrjNumber), prj_name,
         prj_descrip, 'P',
         prj_so, prj_wo, prj_po,
         prj_owner_username, NULL,
         (prj_due_date + COALESCE(pDueDateOffset, 0)),
         CASE WHEN (prj_username IS NULL) THEN NULL ELSE CURRENT_DATE END, NULL,
         prj_username, prj_recurring_prj_id,
         prj_crmacct_id, prj_cntct_id
  FROM prj
  WHERE (prj_id=pPrjId);

  INSERT INTO prjtask
  ( prjtask_number, prjtask_name, prjtask_descrip,
    prjtask_prj_id, prjtask_anyuser, prjtask_status,
    prjtask_hours_budget, prjtask_hours_actual,
    prjtask_exp_budget, prjtask_exp_actual,
    prjtask_owner_username, prjtask_start_date,
    prjtask_due_date, prjtask_assigned_date,
    prjtask_completed_date, prjtask_username )
  SELECT prjtask_number, prjtask_name, prjtask_descrip,
         _prjid, prjtask_anyuser, 'P',
         prjtask_hours_budget, 0.0,
         prjtask_exp_budget, 0.0,
         prjtask_owner_username, NULL,
         (prjtask_due_date + COALESCE(pDueDateOffset, 0)),
         CASE WHEN (prjtask_username IS NULL) THEN NULL ELSE CURRENT_DATE END,
         NULL, prjtask_username
  FROM prjtask
  WHERE (prjtask_prj_id=pPrjId);

  INSERT INTO docass
  ( docass_source_id, docass_source_type,
    docass_target_id, docass_target_type,
    docass_purpose )
  SELECT _prjid, docass_source_type,
         docass_target_id, docass_target_type,
         docass_purpose
  FROM docass
  WHERE ((docass_source_id=pPrjId)
    AND  (docass_source_type='J'));

  RETURN _prjid;

END;
$_$;


ALTER FUNCTION public.copyproject(integer, text, integer) OWNER TO admin;

--
-- Name: copyquote(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyquote(integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pQuheadid ALIAS FOR $1;
  pSchedDate ALIAS FOR $2;
  _quheadid INTEGER;
  _qunumber TEXT;

BEGIN

  SELECT NEXTVAL('quhead_quhead_id_seq') INTO _quheadid;
  IF (fetchMetricText('QUNumberGeneration') = 'S') THEN
    SELECT fetchSoNumber() INTO _qunumber;
  ELSE
    SELECT fetchQuNumber() INTO _qunumber;
  END IF;

  INSERT INTO quhead
  ( quhead_id, quhead_number, quhead_cust_id, quhead_prj_id,
    quhead_quotedate, quhead_packdate, quhead_fob,
    quhead_warehous_id, quhead_terms_id, quhead_salesrep_id,
    quhead_custponumber, quhead_shipvia,
    quhead_shipto_id, quhead_shiptoname, quhead_shiptoaddress1, quhead_shiptoaddress2, quhead_shiptoaddress3,
    quhead_shiptocity, quhead_shiptostate, quhead_shiptozipcode, quhead_shiptophone, quhead_shiptocountry,
    quhead_billtoname, quhead_billtoaddress1, quhead_billtoaddress2, quhead_billtoaddress3,
    quhead_billtocity, quhead_billtostate, quhead_billtozip,
    quhead_misc_accnt_id, quhead_misc_descrip, quhead_misc, quhead_freight, quhead_commission,
    quhead_ordercomments, quhead_shipcomments,
    quhead_imported, quhead_curr_id, quhead_taxzone_id, quhead_taxtype_id, quhead_ophead_id, quhead_status,
    quhead_shipto_cntct_id, quhead_shipto_cntct_honorific, quhead_shipto_cntct_first_name, quhead_shipto_cntct_middle,
    quhead_shipto_cntct_last_name, quhead_shipto_cntct_suffix, quhead_shipto_cntct_phone, quhead_shipto_cntct_title,
    quhead_shipto_cntct_fax, quhead_shipto_cntct_email, quhead_billto_cntct_id, quhead_billto_cntct_honorific,
    quhead_billto_cntct_first_name, quhead_billto_cntct_middle, quhead_billto_cntct_last_name, quhead_billto_cntct_suffix,
    quhead_billto_cntct_phone, quhead_billto_cntct_title, quhead_billto_cntct_fax, quhead_billto_cntct_email )
  SELECT _quheadid, _qunumber, quhead_cust_id, quhead_prj_id,
         CURRENT_DATE, COALESCE(pSchedDate, quhead_packdate), quhead_fob,
         quhead_warehous_id, quhead_terms_id, quhead_salesrep_id,
         quhead_custponumber, quhead_shipvia,
         quhead_shipto_id, quhead_shiptoname, quhead_shiptoaddress1, quhead_shiptoaddress2, quhead_shiptoaddress3,
         quhead_shiptocity, quhead_shiptostate, quhead_shiptozipcode, quhead_shiptophone, quhead_shiptocountry,
         quhead_billtoname, quhead_billtoaddress1, quhead_billtoaddress2, quhead_billtoaddress3,
         quhead_billtocity, quhead_billtostate, quhead_billtozip,
         quhead_misc_accnt_id, quhead_misc_descrip, quhead_misc, quhead_freight, quhead_commission,
         quhead_ordercomments, quhead_shipcomments,
         FALSE, quhead_curr_id, quhead_taxzone_id, quhead_taxtype_id, quhead_ophead_id, 'O',
         quhead_shipto_cntct_id, quhead_shipto_cntct_honorific, quhead_shipto_cntct_first_name, quhead_shipto_cntct_middle,
         quhead_shipto_cntct_last_name, quhead_shipto_cntct_suffix, quhead_shipto_cntct_phone, quhead_shipto_cntct_title,
         quhead_shipto_cntct_fax, quhead_shipto_cntct_email, quhead_billto_cntct_id, quhead_billto_cntct_honorific,
         quhead_billto_cntct_first_name, quhead_billto_cntct_middle, quhead_billto_cntct_last_name, quhead_billto_cntct_suffix,
         quhead_billto_cntct_phone, quhead_billto_cntct_title, quhead_billto_cntct_fax, quhead_billto_cntct_email
  FROM quhead
  WHERE (quhead_id=pQuheadid);

  INSERT INTO quitem
  ( quitem_quhead_id, quitem_linenumber, quitem_itemsite_id,
    quitem_scheddate, quitem_promdate, quitem_qtyord,
    quitem_price, quitem_custprice, quitem_unitcost,
    quitem_qty_uom_id, quitem_price_uom_id,
    quitem_qty_invuomratio, quitem_price_invuomratio,
    quitem_memo, quitem_custpn, quitem_imported, quitem_taxtype_id,
    quitem_createorder, quitem_order_warehous_id, quitem_item_id, quitem_prcost,
    quitem_dropship, quitem_itemsrc_id, quitem_pricemode )
  SELECT _quheadid, quitem_linenumber, quitem_itemsite_id,
         COALESCE(pSchedDate, quitem_scheddate),
         quitem_promdate,
         quitem_qtyord,
         quitem_price, quitem_custprice, stdCost(itemsite_item_id),
         quitem_qty_uom_id, quitem_price_uom_id,
         quitem_qty_invuomratio, quitem_price_invuomratio,
         quitem_memo, quitem_custpn, FALSE, quitem_taxtype_id,
         quitem_createorder, quitem_order_warehous_id, quitem_item_id, quitem_prcost,
         quitem_dropship, quitem_itemsrc_id, quitem_pricemode
  FROM quitem, itemsite
  WHERE ( (quitem_itemsite_id=itemsite_id)
   AND (quitem_quhead_id=pQuheadid));

  INSERT INTO charass
        (charass_target_type, charass_target_id,
         charass_char_id, charass_value)
  SELECT charass_target_type, b.quitem_id,
         charass_char_id, charass_value
    FROM quitem a, charass, quitem b
   WHERE ((charass_target_type='SI')
     AND  (charass_target_id=a.quitem_id)
     AND  (a.quitem_quhead_id=pQuheadid)
     AND  (b.quitem_quhead_id=_quheadid)
     AND  (a.quitem_linenumber=b.quitem_linenumber)
     );

  RETURN _quheadid;

END;
$_$;


ALTER FUNCTION public.copyquote(integer, date) OWNER TO admin;

--
-- Name: copyso(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyso(psoheadid integer, pscheddate date) RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _soheadid INTEGER;
  _soitemid INTEGER;
  _soitem RECORD;

BEGIN

  SELECT NEXTVAL('cohead_cohead_id_seq') INTO _soheadid;

  INSERT INTO cohead
  ( cohead_id,
    cohead_number,
    cohead_cust_id,
    cohead_custponumber,
    cohead_type,
    cohead_orderdate,
    cohead_warehous_id,
    cohead_shipto_id,
    cohead_shiptoname,
    cohead_shiptoaddress1,
    cohead_shiptoaddress2,
    cohead_shiptoaddress3,
    cohead_shiptoaddress4,
    cohead_shiptoaddress5,
    cohead_salesrep_id,
    cohead_terms_id,
    cohead_fob,
    cohead_shipvia,
    cohead_shiptocity,
    cohead_shiptostate,
    cohead_shiptozipcode,
    cohead_freight,
    cohead_misc,
    cohead_imported,
    cohead_ordercomments,
    cohead_shipcomments,
    cohead_shiptophone,
    cohead_shipchrg_id,
    cohead_shipform_id,
    cohead_billtoname,
    cohead_billtoaddress1,
    cohead_billtoaddress2,
    cohead_billtoaddress3,
    cohead_billtocity,
    cohead_billtostate,
    cohead_billtozipcode,
    cohead_misc_accnt_id,
    cohead_misc_descrip,
    cohead_commission,
    cohead_miscdate,
    cohead_holdtype,
    cohead_packdate,
    cohead_prj_id,
    cohead_wasquote,
    cohead_lastupdated,
    cohead_shipcomplete,
    cohead_created,
    cohead_creator,
    cohead_quote_number,
    cohead_billtocountry,
    cohead_shiptocountry,
    cohead_curr_id,
    cohead_calcfreight,
    cohead_shipto_cntct_id,
    cohead_shipto_cntct_honorific,
    cohead_shipto_cntct_first_name,
    cohead_shipto_cntct_middle,
    cohead_shipto_cntct_last_name,
    cohead_shipto_cntct_suffix,
    cohead_shipto_cntct_phone,
    cohead_shipto_cntct_title,
    cohead_shipto_cntct_fax,
    cohead_shipto_cntct_email,
    cohead_billto_cntct_id,
    cohead_billto_cntct_honorific,
    cohead_billto_cntct_first_name,
    cohead_billto_cntct_middle,
    cohead_billto_cntct_last_name,
    cohead_billto_cntct_suffix,
    cohead_billto_cntct_phone,
    cohead_billto_cntct_title,
    cohead_billto_cntct_fax,
    cohead_billto_cntct_email,
    cohead_taxzone_id,
    cohead_taxtype_id,
    cohead_ophead_id,
    cohead_status,
    cohead_saletype_id,
    cohead_shipzone_id )
  SELECT
    _soheadid,
    fetchSoNumber(),
    cohead_cust_id,
    cohead_custponumber,
    cohead_type,
    CURRENT_DATE,
    cohead_warehous_id,
    cohead_shipto_id,
    cohead_shiptoname,
    cohead_shiptoaddress1,
    cohead_shiptoaddress2,
    cohead_shiptoaddress3,
    cohead_shiptoaddress4,
    cohead_shiptoaddress5,
    cohead_salesrep_id,
    cohead_terms_id,
    cohead_fob,
    cohead_shipvia,
    cohead_shiptocity,
    cohead_shiptostate,
    cohead_shiptozipcode,
    cohead_freight,
    cohead_misc,
    FALSE,
    cohead_ordercomments,
    cohead_shipcomments,
    cohead_shiptophone,
    cohead_shipchrg_id,
    cohead_shipform_id,
    cohead_billtoname,
    cohead_billtoaddress1,
    cohead_billtoaddress2,
    cohead_billtoaddress3,
    cohead_billtocity,
    cohead_billtostate,
    cohead_billtozipcode,
    cohead_misc_accnt_id,
    cohead_misc_descrip,
    cohead_commission,
    cohead_miscdate,
    cohead_holdtype,
    COALESCE(pSchedDate, cohead_packdate),
    cohead_prj_id,
    FALSE,
    cohead_lastupdated,
    cohead_shipcomplete,
    NULL,
    getEffectiveXtUser(),
    NULL,
    cohead_billtocountry,
    cohead_shiptocountry,
    cohead_curr_id,
    cohead_calcfreight,
    cohead_shipto_cntct_id,
    cohead_shipto_cntct_honorific,
    cohead_shipto_cntct_first_name,
    cohead_shipto_cntct_middle,
    cohead_shipto_cntct_last_name,
    cohead_shipto_cntct_suffix,
    cohead_shipto_cntct_phone,
    cohead_shipto_cntct_title,
    cohead_shipto_cntct_fax,
    cohead_shipto_cntct_email,
    cohead_billto_cntct_id,
    cohead_billto_cntct_honorific,
    cohead_billto_cntct_first_name,
    cohead_billto_cntct_middle,
    cohead_billto_cntct_last_name,
    cohead_billto_cntct_suffix,
    cohead_billto_cntct_phone,
    cohead_billto_cntct_title,
    cohead_billto_cntct_fax,
    cohead_billto_cntct_email,
    cohead_taxzone_id,
    cohead_taxtype_id,
    cohead_ophead_id,
    cohead_status,
    cohead_saletype_id,
    cohead_shipzone_id
  FROM cohead
  WHERE (cohead_id=pSoheadid);

  FOR _soitem IN
    SELECT *
    FROM coitem JOIN itemsite ON (itemsite_id=coitem_itemsite_id)
    WHERE ( (coitem_cohead_id=pSoheadid)
      AND   (coitem_status <> 'X')
      AND   (coitem_subnumber = 0) ) LOOP

    SELECT NEXTVAL('coitem_coitem_id_seq') INTO _soitemid;

    -- insert characteristics first so they can be copied to associated supply order
    INSERT INTO charass
          (charass_target_type, charass_target_id,
           charass_char_id, charass_value)
    SELECT charass_target_type, _soitemid,
           charass_char_id, charass_value
      FROM charass
     WHERE ((charass_target_type='SI')
       AND  (charass_target_id=_soitem.coitem_id));

    INSERT INTO coitem
    ( coitem_id,
      coitem_cohead_id,
      coitem_linenumber,
      coitem_itemsite_id,
      coitem_status,
      coitem_scheddate,
      coitem_promdate,
      coitem_qtyord,
      coitem_unitcost,
      coitem_price,
      coitem_custprice,
      coitem_qtyshipped,
      coitem_order_id,
      coitem_memo,
      coitem_imported,
      coitem_qtyreturned,
      coitem_closedate,
      coitem_custpn,
      coitem_order_type,
      coitem_close_username,
--      coitem_lastupdated,
      coitem_substitute_item_id,
      coitem_created,
      coitem_creator,
      coitem_prcost,
      coitem_qty_uom_id,
      coitem_qty_invuomratio,
      coitem_price_uom_id,
      coitem_price_invuomratio,
      coitem_warranty,
      coitem_cos_accnt_id,
      coitem_qtyreserved,
      coitem_subnumber,
      coitem_firm,
      coitem_taxtype_id )
    VALUES
    ( _soitemid,
      _soheadid,
      _soitem.coitem_linenumber,
      _soitem.coitem_itemsite_id,
      'O',
      COALESCE(pSchedDate, _soitem.coitem_scheddate),
      _soitem.coitem_promdate,
      _soitem.coitem_qtyord,
      stdCost(_soitem.itemsite_item_id),
      _soitem.coitem_price,
      _soitem.coitem_custprice,
      0.0,
      -1,
      _soitem.coitem_memo,
      FALSE,
      0.0,
      NULL,
      _soitem.coitem_custpn,
      _soitem.coitem_order_type,
      NULL,
--      NULL,
      _soitem.coitem_substitute_item_id,
      NULL,
      getEffectiveXtUser(),
      _soitem.coitem_prcost,
      _soitem.coitem_qty_uom_id,
      _soitem.coitem_qty_invuomratio,
      _soitem.coitem_price_uom_id,
      _soitem.coitem_price_invuomratio,
      _soitem.coitem_warranty,
      _soitem.coitem_cos_accnt_id,
      0.0,
      _soitem.coitem_subnumber,
      _soitem.coitem_firm,
      _soitem.coitem_taxtype_id );

  END LOOP;

  RETURN _soheadid;

END;
$$;


ALTER FUNCTION public.copyso(psoheadid integer, pscheddate date) OWNER TO admin;

--
-- Name: copytodoitem(integer, date, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copytodoitem(integer, date, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pparentid   ALIAS FOR $1;
  _duedate    DATE := COALESCE($2, CURRENT_DATE);
  pincdtid    ALIAS FOR $3;
  _alarmid    INTEGER;
  _todoitemid INTEGER;

BEGIN
  INSERT INTO todoitem(
            todoitem_name,      todoitem_description,
            todoitem_incdt_id,
            todoitem_creator_username,                  todoitem_status,
            todoitem_active,    todoitem_due_date,
            todoitem_assigned_date,
            todoitem_seq,       todoitem_notes,         todoitem_crmacct_id,
            todoitem_ophead_id, todoitem_owner_username,todoitem_priority_id,
            todoitem_username,  todoitem_recurring_todoitem_id
  ) SELECT  todoitem_name,      todoitem_description,
            CASE WHEN pincdtid IS NULL THEN todoitem_incdt_id ELSE pincdtid END,
            getEffectiveXtUser(),                               'N',
            TRUE,               _duedate,
            CASE WHEN (todoitem_username IS NOT NULL) THEN CURRENT_DATE
                 ELSE NULL
            END,
            todoitem_seq,       todoitem_notes,         todoitem_crmacct_id,
            todoitem_ophead_id, todoitem_owner_username,todoitem_priority_id,
            todoitem_username,  todoitem_recurring_todoitem_id
      FROM todoitem
     WHERE (todoitem_id=pparentid)
  RETURNING todoitem_id INTO _todoitemid;

  IF (_todoitemid IS NULL) THEN
    RETURN -10;
  END IF;

  SELECT saveAlarm(NULL, NULL, _duedate,
                   CAST(alarm_time - DATE_TRUNC('day',alarm_time) AS TIME),
                   alarm_time_offset,
                   alarm_time_qualifier,
                   alarm_event, alarm_event_recipient,
                   alarm_email, alarm_email_recipient,
                   alarm_sysmsg, alarm_sysmsg_recipient,
                   'TODO', _todoitemid, 'CHANGEONE')
    INTO _alarmid
    FROM alarm
   WHERE ((alarm_source='TODO')
      AND (alarm_source_id=pparentid));

   IF (_alarmid < 0) THEN
     RETURN _alarmid;
   END IF;

  RETURN _todoitemid;
END;
$_$;


ALTER FUNCTION public.copytodoitem(integer, date, integer) OWNER TO admin;

--
-- Name: copyvoucher(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION copyvoucher(integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVoheadid ALIAS FOR $1;
  _voheadid INTEGER;
  _vonumber TEXT;
  _vodate DATE := COALESCE($2, CURRENT_DATE);
  _i RECORD;
  _l RECORD;
  _vodistid INTEGER;

BEGIN
  SELECT *
    INTO _i
    FROM vohead
   WHERE(vohead_id=pVoheadid);
  IF(NOT FOUND) THEN
    RETURN -1;
  END IF;

  _vonumber := fetchVoNumber();
  _voheadid := nextval('vohead_vohead_id_seq');

  INSERT INTO vohead
        (vohead_id,
         vohead_number, vohead_pohead_id,
         vohead_posted, vohead_duedate,
         vohead_invcnumber, vohead_amount,
         vohead_docdate, vohead_1099,
         vohead_distdate, vohead_reference,
         vohead_terms_id, vohead_vend_id,
         vohead_curr_id, vohead_adjtaxtype_id,
         vohead_freighttaxtype_id, vohead_gldistdate,
         vohead_misc, vohead_taxzone_id,
         vohead_taxtype_id, vohead_notes,
         vohead_recurring_vohead_id )
  VALUES(_voheadid,
         _vonumber, _i.vohead_pohead_id,
         false, determineDueDate(_i.vohead_terms_id, _vodate),
         _i.vohead_invcnumber, _i.vohead_amount,
         _vodate, _i.vohead_1099,
         _vodate, _i.vohead_reference,
         _i.vohead_terms_id, _i.vohead_vend_id,
         _i.vohead_curr_id, _i.vohead_adjtaxtype_id,
         _i.vohead_freighttaxtype_id, _vodate,
         _i.vohead_misc, _i.vohead_taxzone_id,
         _i.vohead_taxtype_id, _i.vohead_notes,
         _i.vohead_recurring_vohead_id);

  FOR _l IN SELECT *
            FROM vodist
            WHERE (vodist_vohead_id=pVoheadid) LOOP
    SELECT NEXTVAL('vodist_vodist_id_seq') INTO _vodistid;

    INSERT INTO vodist
        (vodist_id, vodist_poitem_id,
         vodist_vohead_id, vodist_costelem_id,
         vodist_accnt_id, vodist_amount,
         vodist_qty, vodist_expcat_id,
         vodist_tax_id, vodist_discountable,
         vodist_notes)
    VALUES
        (_vodistid, _l.vodist_poitem_id,
         _voheadid, _l.vodist_costelem_id,
         _l.vodist_accnt_id, _l.vodist_amount,
         _l.vodist_qty, _l.vodist_expcat_id,
         _l.vodist_tax_id, _l.vodist_discountable,
         _l.vodist_notes);

  END LOOP;

  RETURN _voheadid;
END;
$_$;


ALTER FUNCTION public.copyvoucher(integer, date) OWNER TO admin;

--
-- Name: correctporeceipt(integer, numeric, numeric, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION correctporeceipt(integer, numeric, numeric, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pPorecvid ALIAS FOR $1;
  pQty ALIAS FOR $2;
  pFreight ALIAS FOR $3;
  pItemlocSeries ALIAS FOR $4;

BEGIN
  RETURN correctReceipt('PO', $1, $2, $3, $4, NULL, NULL);
END;
$_$;


ALTER FUNCTION public.correctporeceipt(integer, numeric, numeric, integer) OWNER TO admin;

--
-- Name: correctporeceipt(integer, numeric, numeric, integer, integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION correctporeceipt(integer, numeric, numeric, integer, integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  RETURN correctReceipt('PO', $1, $2, $3, $4, $5, $6);
END;
$_$;


ALTER FUNCTION public.correctporeceipt(integer, numeric, numeric, integer, integer, date) OWNER TO admin;

--
-- Name: correctproduction(integer, numeric, boolean, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION correctproduction(integer, numeric, boolean, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  RAISE NOTICE 'correctProduction(INTEGER, NUMERIC, BOOLEAN, BOOLEAN) has been deprecated. Use corrrectProduction(INTEGER, NUMERIC, BOOLEAN, INTEGER) or a package-specific version instead.';
  RETURN  correctProduction($1, $2, $3, 0, now());
END;
$_$;


ALTER FUNCTION public.correctproduction(integer, numeric, boolean, boolean) OWNER TO admin;

--
-- Name: correctproduction(integer, numeric, boolean, boolean, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION correctproduction(integer, numeric, boolean, boolean, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  RAISE NOTICE 'correctProduction(INTEGER, NUMERIC, BOOLEAN, BOOLEAN, INTEGER) has been deprecated. Use corrrectProduction(INTEGER, NUMERIC, BOOLEAN, INTEGER) or a package-specific version instead.';
  RETURN correctProduction($1, $2, $3, $5, now());
END;
$_$;


ALTER FUNCTION public.correctproduction(integer, numeric, boolean, boolean, integer) OWNER TO admin;

--
-- Name: correctproduction(integer, numeric, boolean, integer, timestamp with time zone); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION correctproduction(integer, numeric, boolean, integer, timestamp with time zone) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWoid          ALIAS FOR $1;
  pQty           ALIAS FOR $2;
  pBackflush     ALIAS FOR $3;
  pItemlocSeries ALIAS FOR $4;
  pGlDistTS      ALIAS FOR $5;
BEGIN
  RETURN correctProduction($1, $2, $3, $4, $5, NULL);
END;
$_$;


ALTER FUNCTION public.correctproduction(integer, numeric, boolean, integer, timestamp with time zone) OWNER TO admin;

--
-- Name: correctproduction(integer, numeric, boolean, integer, timestamp with time zone, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION correctproduction(integer, numeric, boolean, integer, timestamp with time zone, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWoid          ALIAS FOR $1;
  pQty           ALIAS FOR $2;
  pBackflush     ALIAS FOR $3;
  pItemlocSeries ALIAS FOR $4;
  pGlDistTS      ALIAS FOR $5;
  pInvhistId     ALIAS FOR $6;
  _invhistid        INTEGER;
  _itemlocSeries    INTEGER;
  _r                RECORD;
  _parentWIPAccntid INTEGER;
  _parentQty        NUMERIC;
  _qty              NUMERIC;
  _wipPost          NUMERIC;
  _sense            TEXT;
  _status           TEXT;
  _type             TEXT;
  _qtyfxd           NUMERIC := 0;

BEGIN

  -- Qty is positive for Assembly W/O
  -- Qty is negative for Disassembly W/O
  IF (pQty = 0) THEN
    RETURN pItemlocseries;
  ELSIF (pQty > 0) THEN
    _sense := 'from';
  ELSE
    _sense := 'to';
  END IF;

  SELECT item_type, roundQty(item_fractional, pQty), wo_status
    INTO _type, _parentQty, _status
    FROM wo JOIN itemsite ON (itemsite_id=wo_itemsite_id)
            JOIN item ON (item_id=itemsite_item_id)
   WHERE (wo_id=pWoid);
  
  IF (_status != 'I') THEN
    RETURN -1;
  END IF;

  IF (_type = 'J') THEN
    RETURN -2;
  END IF;

  IF (pItemlocSeries = 0) THEN
    SELECT NEXTVAL('itemloc_series_seq') INTO _itemlocSeries;
  ELSE
    _itemlocSeries := pItemlocSeries;
  END IF;

  --  Calculate the WIP to correct 
  SELECT CASE WHEN (wo_cosmethod = 'D') THEN wo_postedvalue
              ELSE  round(((wo_postedvalue - wo_wipvalue) / wo_qtyrcv * _parentQty), 2)
         END INTO _wipPost
  FROM wo
  WHERE (wo_id=pWoid);

  --  Post the inventory transaction
  SELECT postInvTrans( itemsite_id, 'RM', (_parentQty * -1.0),
                       'W/O', 'WO', formatwonumber(pWoid), '',
                       ('Correct Receive Inventory ' || item_number || ' ' || _sense || ' Manufacturing'),
                       costcat_asset_accnt_id, getPrjAccntId(wo_prj_id, costcat_wip_accnt_id), _itemlocSeries, pGlDistTS,
                       (_wipPost * -1.0), -- only used when cost is average
                       pInvhistId) INTO _invhistid
  FROM wo JOIN itemsite ON (itemsite_id=wo_itemsite_id)
          JOIN item ON (item_id=itemsite_item_id)
          JOIN costcat ON (costcat_id=itemsite_costcat_id)
  WHERE (wo_id=pWoid);

  --  Decrease this W/O's qty. received and increase its WIP value
  UPDATE wo
  SET wo_qtyrcv = (wo_qtyrcv - _parentQty),
      wo_wipvalue = (wo_wipvalue + (CASE WHEN(itemsite_costmethod IN ('A','J'))
                                              THEN _wipPost
                                         WHEN(itemsite_costmethod='S')
                                              THEN stdcost(itemsite_item_id) * _parentQty
                                         ELSE 0.0 END))
  FROM itemsite
  WHERE ( (wo_itemsite_id=itemsite_id)
   AND (wo_id=pWoid) );

  IF (pBackflush) THEN
    FOR _r IN SELECT item_id, item_fractional,
                      itemsite_id, itemsite_warehous_id,
                      itemsite_controlmethod, itemsite_loccntrl,
                      itemsite_costmethod, 
                      wo_qtyrcv, wo_prj_id,
                      womatl_id, womatl_qtyfxd, womatl_qtyper,
                      womatl_scrap, womatl_issuemethod, womatl_uom_id
               FROM wo JOIN womatl ON (womatl_wo_id=wo_id AND womatl_issuemethod='L')
                       JOIN itemsite ON (itemsite_id=womatl_itemsite_id)
                       JOIN item ON (item_id=itemsite_item_id)
               WHERE (wo_id=pWoid) LOOP

      --  Cache the qty to be issued
      -- If going back to beginning, unissue fixed qty as well
      IF (_r.wo_qtyrcv - _parentQty > 0) THEN
        _qtyfxd := 0;
      ELSE
        _qtyfxd := _r.womatl_qtyfxd;
      END IF;
      
      _qty = roundQty(_r.item_fractional, (_qtyfxd + _parentQty * _r.womatl_qtyper) * (1 + _r.womatl_scrap));

      IF (_qty > 0) THEN
        SELECT returnWoMaterial(_r.womatl_id, _qty, _itemlocSeries, pGlDistTS) INTO _itemlocSeries;
      END IF;

    END LOOP;

  	--  BEGIN ROB Decrease this W/O's WIP value for custom costing
	  UPDATE wo
	  SET wo_wipvalue = (wo_wipvalue - (itemcost_stdcost * _parentQty)) 
	FROM costelem, itemcost, costcat, itemsite, item
	WHERE 
	  ((wo_id=pWoid) AND
	  (wo_itemsite_id=itemsite_id) AND
	  (itemsite_item_id=item_id) AND
	  (costelem_id = itemcost_costelem_id) AND
	  (itemcost_item_id = itemsite_item_id) AND
	  (itemsite_costcat_id = costcat_id) AND
	  (costelem_exp_accnt_id) IS NOT NULL  AND 
	  (costelem_sys = false));

	--  ROB Distribute to G/L - create Cost Variance, debit WIP
	  PERFORM insertGLTransaction( 'W/O', 'WO', formatwonumber(pWoid),
				       ('Correct Post Other Cost ' || item_number || ' ' || _sense || ' Manufacturing'),
				       getPrjAccntId(wo_prj_id, costelem_exp_accnt_id), 
				       getPrjAccntId(wo_prj_id, costcat_wip_accnt_id), _invhistid,
				       ((itemcost_stdcost * _parentQty)* -1),
				       CURRENT_DATE )
	FROM wo, costelem, itemcost, costcat, itemsite, item
	WHERE 
	  ((wo_id=pWoid) AND
	  (wo_itemsite_id=itemsite_id) AND
	  (itemsite_item_id=item_id) AND
	  (costelem_id = itemcost_costelem_id) AND
	  (itemcost_item_id = itemsite_item_id) AND
	  (itemsite_costcat_id = costcat_id) AND
	  (costelem_exp_accnt_id) IS NOT NULL  AND 
	  (costelem_sys = false));
	--End ROB

  END IF;

  RETURN _itemlocSeries;

END;
$_$;


ALTER FUNCTION public.correctproduction(integer, numeric, boolean, integer, timestamp with time zone, integer) OWNER TO admin;

--
-- Name: correctreceipt(integer, numeric, numeric, integer, integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION correctreceipt(integer, numeric, numeric, integer, integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
BEGIN
  RETURN correctReceipt($1, $2, $3, $4, $5, $6, NULL);
END;
$_$;


ALTER FUNCTION public.correctreceipt(integer, numeric, numeric, integer, integer, date) OWNER TO admin;

--
-- Name: correctreceipt(integer, numeric, numeric, integer, integer, date, numeric); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION correctreceipt(integer, numeric, numeric, integer, integer, date, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  precvid		ALIAS FOR $1;
  pQty			ALIAS FOR $2;
  pFreight		ALIAS FOR $3;
  _itemlocSeries	INTEGER := COALESCE($4, 0);
  _currid		INTEGER := $5;
  pEffective		ALIAS FOR $6;
  pRecvCost		ALIAS FOR $7;
  _freight		NUMERIC;
  _qty			NUMERIC;
  _invhistid		INTEGER;
  _o			RECORD;
  _r			RECORD;
  _recvcost		NUMERIC;
  _tmp        INTEGER;
  _pricevar             NUMERIC := 0.00;
  _journalNumber INTEGER := fetchJournalNumber('GL-MISC');

BEGIN
  SELECT recv_qty, recv_date::DATE AS recv_date, recv_freight_curr_id,
	 recv_orderitem_id,
	 round(currToCurr(recv_freight_curr_id,
			  COALESCE(_currid, recv_freight_curr_id),
         recv_freight, recv_date::DATE),2) AS recv_freight,
         recv_posted, recv_order_type,
         COALESCE(itemsite_id, -1) AS itemsiteid,
	 itemsite_item_id, itemsite_costmethod, itemsite_controlmethod,
	 (recv_splitfrom_id IS NOT NULL
	 OR (SELECT (count(*) > 0) 
	     FROM recv
	     WHERE (recv_splitfrom_id=recv_id))) AS split INTO _r
  FROM recv LEFT OUTER JOIN itemsite ON (recv_itemsite_id=itemsite_id)
  WHERE (recv_id=precvid);

  IF (NOT FOUND) THEN
    RETURN _itemlocSeries;
  END IF;

  IF (NOT _r.recv_order_type IN ('PO', 'RA', 'TO')) THEN
    RETURN -11;
  END IF;

  IF (_r.split) THEN
    RETURN -12;
  END IF;

  SELECT currToBase(orderitem_unitcost_curr_id, orderitem_unitcost,
		    _r.recv_date::DATE) AS unitprice_base,
	 orderhead_number, orderitem_linenumber,
	 orderhead_curr_id AS freight_curr_id,
	 orderitem_orderhead_type,
	 orderitem_qty_invuomratio INTO _o
  FROM orderhead, orderitem
  WHERE ((orderhead_id=orderitem_orderhead_id)
    AND  (orderhead_type=orderitem_orderhead_type)
    AND  (orderitem_id=_r.recv_orderitem_id)
    AND  (orderitem_orderhead_type=_r.recv_order_type));

  IF (NOT FOUND) THEN
    RETURN _itemlocSeries;
  END IF;

  -- Default to _o.orderitem_unitcost if recv_purchcost is not supplied
  -- Note: this should never happen, a value is always supplied
  if (pRecvCost IS NULL) THEN
    _recvcost := _o.orderitem_unitcost;
  ELSE
    -- Note: if the receipt has already been posted, pRecvCost will always 
    --       equal the original recv_purchcost (cannot be modified in GUI)
    _recvcost := pRecvCost; 
  END IF;

  IF (_r.recv_posted) THEN
    _qty := (pQty - _r.recv_qty);
    IF (_qty <> 0) THEN
      IF (_r.itemsiteid = -1) THEN
        PERFORM insertGLTransaction( _journalNumber,'S/R',
                                     _r.recv_order_type,
                                     _o.orderhead_number,
                                     'Receive Non-Inventory from ' || _r.recv_order_type,
                                     expcat_liability_accnt_id,
                                     getPrjAccntId(poitem_prj_id, expcat_exp_accnt_id),
                                     -1,
                                     ROUND(_o.unitprice_base * _qty, 2),
                                     pEffective )
        FROM poitem, expcat
        WHERE ((poitem_expcat_id=expcat_id)
          AND  (poitem_id=_r.recv_orderitem_id)
          AND  (_o.orderitem_orderhead_type='PO'));

        UPDATE recv
        SET recv_qty=pQty,
            recv_value=(recv_value + ROUND(_o.unitprice_base * _qty, 2)),
            recv_date = pEffective
        WHERE (recv_id=precvid);
      ELSEIF (_r.itemsite_controlmethod = 'N') THEN
        PERFORM insertGLTransaction( _journalNumber,'S/R',
                                     _r.recv_order_type,
                                     _o.orderhead_number,
                                     'Receive Non-Controlled Inventory from ' || _r.recv_order_type,
                                     costcat_liability_accnt_id,
                                     getPrjAccntId(poitem_prj_id, costcat_exp_accnt_id),
                                     -1,
                                     ROUND(_o.unitprice_base * _qty, 2),
                                     pEffective )
        FROM poitem, itemsite, costcat
        WHERE ((poitem_itemsite_id=itemsite_id)
          AND  (itemsite_costcat_id=costcat_id)
          AND  (poitem_id=_r.recv_orderitem_id)
          AND  (_o.orderitem_orderhead_type='PO'));

        UPDATE recv
        SET recv_qty=pQty,
            recv_value=(recv_value + ROUND(_o.unitprice_base * _qty, 2)),
            recv_date = pEffective
        WHERE (recv_id=precvid);
      ELSE
        IF (_itemlocSeries = 0 OR _itemlocSeries IS NULL) THEN
          _itemlocSeries := NEXTVAL('itemloc_series_seq');
        END IF;

  SELECT postInvTrans( itemsite_id, 'RP',
			     (_qty * _o.orderitem_qty_invuomratio),
			     'S/R', _r.recv_order_type,
			     _o.orderhead_number::TEXT || '-' || _o.orderitem_linenumber::TEXT, '',
			     'Receive Inventory from ' || _r.recv_order_type,
			     costcat_asset_accnt_id,
			     costcat_liability_accnt_id,
			     _itemlocSeries, pEffective,
           ROUND(_recvcost * _qty, 2) -- alway passing since it is ignored if not average costed item
                           ) INTO _tmp
	FROM itemsite, costcat
	WHERE ((itemsite_costcat_id=costcat_id)
    AND  (itemsite_id=_r.itemsiteid) );

        IF(_r.itemsite_costmethod='A') THEN
	  UPDATE recv
	     SET recv_qty=pQty,
	         recv_value=(recv_value + _recvcost * _qty * _o.orderitem_qty_invuomratio),
                 recv_date = pEffective
	   WHERE(recv_id=precvid);
        ELSE
	  UPDATE recv
	     SET recv_qty=pQty,
	         recv_value=(recv_value + stdcost(_r.itemsite_item_id) * _qty * _o.orderitem_qty_invuomratio),
                 recv_date = pEffective
	   WHERE(recv_id=precvid);
        END IF;
    END IF;

      IF (_r.recv_order_type = 'PO') THEN
	UPDATE poitem
	SET poitem_qty_received=(poitem_qty_received + _qty)
	WHERE (poitem_id=_r.recv_orderitem_id);
      ELSIF (_r.recv_order_type = 'RA' AND fetchMetricBool('EnableReturnAuth')) THEN
	UPDATE raitem
	SET raitem_qtyreceived=(raitem_qtyreceived + _qty)
	WHERE (raitem_id=_r.recv_orderitem_id);
      ELSIF (_r.recv_order_type = 'TO' AND fetchMetricBool('MultiWhs')) THEN
	UPDATE toitem
	SET toitem_qty_received=(toitem_qty_received + _qty)
	WHERE (toitem_id=_r.recv_orderitem_id);
      END IF;

    END IF;

       IF (fetchMetricBool('RecordPPVonReceipt')) THEN -- If the 'Purchase Price Variance on Receipt' option is true
         _invhistid := _tmp;
         -- Find the difference in the purchase price value expected from the P/O and the value of the transaction
         SELECT (((currToBase(pohead_curr_id,
         COALESCE(recv_purchcost, poitem_unitprice),
         recv_date::DATE)) * _qty) - (invhist_value_after - invhist_value_before)) INTO _pricevar
         FROM invhist, recv, pohead, poitem
         WHERE ((recv_orderitem_id=poitem_id)
           AND  (poitem_pohead_id=pohead_id)
           AND  (recv_id=precvid)
           AND  (invhist_id = _invhistid));

         -- If difference exists then
         IF (_pricevar <> 0.00) THEN
           -- Record an additional GL Transaction for the purchase price variance
           SELECT insertGLTransaction( _journalNumber,
                'S/R', _r.recv_order_type, _o.orderhead_number,
                                       'Purchase price variance adjusted for P/O ' || _o.orderhead_number || ' for item ' || _o.orderitem_linenumber::TEXT,
                                       costcat_liability_accnt_id,
                                       getPrjAccntId(poitem_prj_id, costcat_purchprice_accnt_id), -1,
                                       _pricevar,
                                       pEffective, false ) INTO _tmp
           FROM itemsite, costcat, poitem, recv
           WHERE ((itemsite_costcat_id=costcat_id)
              AND (recv_id=precvid)
              AND (recv_orderitem_id=poitem_id)
              AND (itemsite_id=recv_itemsite_id) );
           IF (NOT FOUND) THEN
             RAISE EXCEPTION 'Could not insert G/L transaction: no cost category found for itemsite_id %',
             _r.itemsite_id;
           ELSIF (_tmp < 0 AND _tmp != -3) THEN -- error but not 0-value transaction
             RETURN _tmp;
           ELSE
             -- Posting to trial balance is deferred to prevent locking
             INSERT INTO itemlocpost ( itemlocpost_glseq, itemlocpost_itemlocseries)
             VALUES ( _tmp, _itemlocSeries );
           END IF;
         END IF;
       END IF;

    _freight := (pFreight - _r.recv_freight);
    IF (_freight <> 0) THEN

      IF (_r.itemsiteid = -1) THEN
  PERFORM insertGLTransaction( _journalNumber,'S/R', _r.recv_order_type,
				     _o.orderhead_number,
				    'Receive Non-Inventory Freight from ' || _r.recv_order_type,
             expcat_liability_accnt_id, getPrjAccntId(poitem_prj_id, expcat_freight_accnt_id), -1,
				      ROUND(currToBase(_currid, _freight,
						    pEffective), 2),
				     pEffective )
	FROM poitem, expcat
	WHERE ((poitem_expcat_id=expcat_id)
	  AND  (poitem_id=_r.recv_orderitem_id)
	  AND  (_r.recv_order_type='PO'));
      ELSE
  PERFORM insertGLTransaction(_journalNumber,'S/R', _r.recv_order_type,
				    _o.orderhead_number, 
				    'Receive Non-Inventory Freight from ' ||
							    _r.recv_order_type,
				   costcat_liability_accnt_id,
				   costcat_freight_accnt_id, -1,
				   round(currToBase(_currid, _freight,
						    pEffective), 2),
				   pEffective )
	FROM itemsite, costcat
	WHERE ( (itemsite_costcat_id=costcat_id)
	  AND   (itemsite_id=_r.itemsiteid) );
      END IF;

      IF (_r.recv_order_type = 'PO') THEN
	UPDATE poitem
	SET poitem_freight_received=(poitem_freight_received +
				   currToCurr(_currid, _o.freight_curr_id,
					      _freight, pEffective))
	WHERE (poitem_id=_r.recv_orderitem_id);

      -- raitem does not track freight

      ELSEIF (_r.recv_order_type = 'TO' AND fetchMetricBool('MultiWhs')) THEN
	UPDATE toitem
	SET toitem_freight_received=(toitem_freight_received +
				   currToCurr(_currid, _o.freight_curr_id,
					      _freight, pEffective))
	WHERE (toitem_id=_r.recv_orderitem_id);
      END IF;

      UPDATE recv
      SET recv_freight=currToCurr(_currid, recv_freight_curr_id, pFreight,
				  pEffective),
	  recv_date = pEffective
      WHERE (recv_id=precvid);
    END IF;

  ELSE

-- Receipt not posted yet
    UPDATE recv SET recv_qty=pQty, recv_freight=pFreight, recv_purchcost=_recvcost WHERE recv_id=precvid;
  END IF;

RETURN _itemlocSeries;

END;
$_$;


ALTER FUNCTION public.correctreceipt(integer, numeric, numeric, integer, integer, date, numeric) OWNER TO admin;

--
-- Name: cosbycustomervalue(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION cosbycustomervalue(integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCustid ALIAS FOR $1;
  pPeriodid ALIAS FOR $2;
  _value NUMERIC;
  _startDate DATE;
  _endDate DATE;

BEGIN

  _startDate := findPeriodStart(pPeriodid);
  _endDate := findPeriodEnd(pPeriodid);

-- Returns value in base currency
-- ToDo: is cohist_shipdate the right DATE to use?
  SELECT SUM(cohist_qtyshipped * currToBase(cohist_curr_id, cohist_unitcost, cohist_shipdate)) INTO _value
  FROM cohist
  WHERE ( (cohist_cust_id=pCustid)
   AND (cohist_invcdate BETWEEN _startDate AND _endDate) );

  IF (_value IS NULL) THEN
    _value := 0;
  END IF;

  RETURN _value;

END;
$_$;


ALTER FUNCTION public.cosbycustomervalue(integer, integer) OWNER TO admin;

--
-- Name: costsbycustomerbyitemsite(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION costsbycustomerbyitemsite(integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCustid ALIAS FOR $1;
  pItemsiteid ALIAS FOR $2;
  pPeriodid ALIAS FOR $3;
  _value NUMERIC;
  _startDate DATE;
  _endDate DATE;

BEGIN

  _startDate := findPeriodStart(pPeriodid);
  _endDate := findPeriodEnd(pPeriodid);

-- Returns value in base currency
-- ToDo: is cohist_shipdate the right DATE to use?
  SELECT SUM(cohist_qtyshipped * currToBase(cohist_curr_id, cohist_unitcost, cohist_shipdate)) INTO _value
  FROM cohist
  WHERE ( (cohist_itemsite_id<>pItemsiteid)
   AND (cohist_cust_id=pCustid)
   AND (cohist_invcdate BETWEEN _startDate AND _endDate) );

  IF (_value IS NULL) THEN
    _value := 0;
  END IF;

  RETURN _value;

END;
$_$;


ALTER FUNCTION public.costsbycustomerbyitemsite(integer, integer, integer) OWNER TO admin;

--
-- Name: costsbycustomervalue(integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION costsbycustomervalue(integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCustid ALIAS FOR $1;
  pPeriodid ALIAS FOR $2;
  _value NUMERIC;
  _startDate DATE;
  _endDate DATE;

BEGIN

  _startDate := findPeriodStart(pPeriodid);
  _endDate := findPeriodEnd(pPeriodid);

-- Returns value in base currency
-- ToDo: is cohist_shipdate the right DATE to use?
  SELECT SUM(cohist_qtyshipped * currToBase(cohist_curr_id, cohist_unitcost, cohist_shipdate)) INTO _value
  FROM cohist
  WHERE ( (cohist_itemsite_id<>-1)
   AND (cohist_cust_id=pCustid)
   AND (cohist_invcdate BETWEEN _startDate AND _endDate) );

  IF (_value IS NULL) THEN
    _value := 0;
  END IF;

  RETURN _value;

END;
$_$;


ALTER FUNCTION public.costsbycustomervalue(integer, integer) OWNER TO admin;

--
-- Name: costsbycustomervalue(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION costsbycustomervalue(integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCustid ALIAS FOR $1;
  pPeriodid ALIAS FOR $2;
  pProdcatid ALIAS FOR $3;
  _value NUMERIC;
  _startDate DATE;
  _endDate DATE;

BEGIN

  _startDate := findPeriodStart(pPeriodid);
  _endDate := findPeriodEnd(pPeriodid);

-- Returns value in base currency
-- ToDo: is cohist_shipdate the right DATE to use?
  SELECT SUM(cohist_qtyshipped * currToBase(cohist_curr_id, cohist_unitcost, cohist_shipdate)) INTO _value
  FROM cohist, itemsite, item
  WHERE ( (cohist_cust_id=pCustid)
   AND (cohist_itemsite_id=itemsite_id)
   AND (itemsite_item_id=item_id)
   AND (item_prodcat_id=pProdcatid)
   AND (cohist_invcdate BETWEEN _startDate AND _endDate) );

  IF (_value IS NULL) THEN
    _value := 0;
  END IF;

  RETURN _value;

END;
$_$;


ALTER FUNCTION public.costsbycustomervalue(integer, integer, integer) OWNER TO admin;

--
-- Name: costsbycustomervalue(integer, integer, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION costsbycustomervalue(integer, integer, text) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCustid ALIAS FOR $1;
  pPeriodid ALIAS FOR $2;
  pProdcat ALIAS FOR $3;
  _value NUMERIC;
  _startDate DATE;
  _endDate DATE;

BEGIN

  _startDate := findPeriodStart(pPeriodid);
  _endDate := findPeriodEnd(pPeriodid);

-- Returns value in base currency
-- ToDo: is cohist_shipdate the right date to use?
  SELECT SUM(cohist_qtyshipped * currToBase(cohist_curr_id, cohist_unitcost, cohist_shipdate)) INTO _value
  FROM cohist, itemsite, item, prodcat
  WHERE ( (cohist_cust_id=pCustid)
   AND (cohist_itemsite_id=itemsite_id)
   AND (itemsite_item_id=item_id)
   AND (item_prodcat_id=prodcat_id)
   AND (prodcat_code ~ pProdcat)
   AND (cohist_invcdate BETWEEN _startDate AND _endDate) );

  IF (_value IS NULL) THEN
    _value := 0;
  END IF;

  RETURN _value;

END;
$_$;


ALTER FUNCTION public.costsbycustomervalue(integer, integer, text) OWNER TO admin;

--
-- Name: createaccountingperiod(date, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createaccountingperiod(date, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pStartDate ALIAS FOR $1;
  pEndDate ALIAS FOR $2;

BEGIN

  RETURN createAccountingPeriod(pStartDate, pEndDate, NULL, NULL);

END;
$_$;


ALTER FUNCTION public.createaccountingperiod(date, date) OWNER TO admin;

--
-- Name: createaccountingperiod(date, date, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createaccountingperiod(date, date, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pStartDate ALIAS FOR $1;
  pEndDate ALIAS FOR $2;
  pYearPeriodId ALIAS FOR $3;
  pQuarter ALIAS FOR $4;
  _periodid INTEGER;
  _check INTEGER;
  _r RECORD;
  _initial BOOLEAN;
  _number INTEGER;

BEGIN

--  Make that the passed start date doesn't fall into any existing period
  SELECT period_id INTO _check
  FROM period
  WHERE (pStartDate BETWEEN period_start AND period_end);
  IF (FOUND) THEN
    RETURN -1;
  END IF;

--  Make that the passed end date doesn't fall into any existing period
  SELECT period_id INTO _check
  FROM period
  WHERE (pEndDate BETWEEN period_start AND period_end);
  IF (FOUND) THEN
    RETURN -2;
  END IF;

--  Make that the passed start and end dates don't enclose an existing period
  SELECT period_id INTO _check
  FROM period
  WHERE ( (period_start >= pStartDate)
   AND (period_end <= pEndDate) );
  IF (FOUND) THEN
    RETURN -3;
  END IF;

-- Make sure period is inside fiscal year
  SELECT yearperiod_id INTO _check
  FROM yearperiod
  WHERE ((yearperiod_id=pYearPeriodId)
  AND (pStartDate>=yearperiod_start)
  AND (pEndDate<=yearperiod_end));
  IF NOT (FOUND) THEN
    RETURN -4;
  END IF;

--  Determine if this is the initial accounting period
  SELECT CASE WHEN(count(*) > 0) THEN FALSE
              ELSE TRUE
         END INTO _initial
  FROM period;

-- Determine the next number
  SELECT COALESCE(MAX(period_number),0) + 1 INTO _number
  FROM period
  WHERE (period_yearperiod_id=pYearPeriodId);

--  Create the new accounting period
  SELECT NEXTVAL('period_period_id_seq') INTO _periodid;
  INSERT INTO period
  ( period_id, period_start, period_end, period_closed, period_freeze, 
    period_initial, period_number, period_yearperiod_id, period_quarter )
  VALUES
  ( _periodid, pStartDate, pEndDate, FALSE, FALSE, _initial, _number, pYearPeriodId, pQuarter );

--  Post any unposted G/L Transactions into the new period
  FOR _r IN SELECT DISTINCT gltrans_sequence
            FROM gltrans
            WHERE ( (NOT gltrans_posted)
             AND (gltrans_date BETWEEN pStartDate AND pEndDate) ) LOOP
    PERFORM postIntoTrialBalance(_r.gltrans_sequence);
  END LOOP;

  RETURN _periodid;

END;
$_$;


ALTER FUNCTION public.createaccountingperiod(date, date, integer, integer) OWNER TO admin;

--
-- Name: createaccountingyearperiod(date, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createaccountingyearperiod(date, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pStartDate ALIAS FOR $1;
  pEndDate ALIAS FOR $2;
  _yearperiodid INTEGER;
  _check INTEGER;
  _checkBool BOOLEAN;
  _r RECORD;
  _initial BOOLEAN;

BEGIN

--  Make that the passed start date doesn't fall into any existing yearperiod
  SELECT yearperiod_id INTO _check
  FROM yearperiod
  WHERE (pStartDate BETWEEN yearperiod_start AND yearperiod_end);
  IF (FOUND) THEN
    RETURN -1;
  END IF;

--  Make that the passed end date doesn't fall into any existing yearperiod
  SELECT yearperiod_id INTO _check
  FROM yearperiod
  WHERE (pEndDate BETWEEN yearperiod_start AND yearperiod_end);
  IF (FOUND) THEN
    RETURN -2;
  END IF;

--  Make that the passed start and end dates don't enclose an existing yearperiod
  SELECT yearperiod_id INTO _check
  FROM yearperiod
  WHERE ( (yearperiod_start >= pStartDate)
   AND (yearperiod_end <= pEndDate) );
  IF (FOUND) THEN
    RETURN -3;
  END IF;

--  Make sure that the passed start is prior to the end date
  SELECT (pStartDate > pEndDate) INTO _checkBool;
  IF (_checkBool) THEN
    RETURN -5;
  END IF;

--  Determine if this is the initial accounting yearperiod
  SELECT CASE WHEN(count(*) > 0) THEN FALSE
              ELSE TRUE
         END INTO _initial
  FROM yearperiod;

--  Create the new accounting yearperiod
  SELECT NEXTVAL('yearperiod_yearperiod_id_seq') INTO _yearperiodid;
  INSERT INTO yearperiod
  ( yearperiod_id, yearperiod_start, yearperiod_end, yearperiod_closed )
  VALUES
  ( _yearperiodid, pStartDate, pEndDate, FALSE );

  RETURN _yearperiodid;

END;
$_$;


ALTER FUNCTION public.createaccountingyearperiod(date, date) OWNER TO admin;

--
-- Name: createapchecks(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapchecks(integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  RAISE NOTICE 'createAPChecks() is deprecated - use createChecks() instead';
  RETURN createChecks($1, $2);
END;
$_$;


ALTER FUNCTION public.createapchecks(integer, date) OWNER TO admin;

--
-- Name: createapcreditmemo(integer, text, text, date, numeric, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapcreditmemo(integer, text, text, date, numeric, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pDocNumber ALIAS FOR $2;
  pPoNumber ALIAS FOR $3;
  pDocDate ALIAS FOR $4;
  pAmount ALIAS FOR $5;
  pNotes ALIAS FOR $6;
  _result INTEGER;

BEGIN

  SELECT createAPCreditMemo( pVendid, fetchJournalNumber('AP-MISC'),
                             pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, -1, pDocDate, -1, baseCurrId() ) INTO _result;

  RETURN _result;

END;
$_$;


ALTER FUNCTION public.createapcreditmemo(integer, text, text, date, numeric, text) OWNER TO admin;

--
-- Name: createapcreditmemo(integer, integer, text, text, date, numeric, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapcreditmemo(integer, integer, text, text, date, numeric, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pJournalNumber ALIAS FOR $2;
  pDocNumber ALIAS FOR $3;
  pPoNumber ALIAS FOR $4;
  pDocDate ALIAS FOR $5;
  pAmount ALIAS FOR $6;
  pNotes ALIAS FOR $7;

BEGIN
  RETURN createAPCreditMemo(pVendid, pJournalNumber, pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, -1, pDocDate, -1, baseCurrId() );
END;
$_$;


ALTER FUNCTION public.createapcreditmemo(integer, integer, text, text, date, numeric, text) OWNER TO admin;

--
-- Name: createapcreditmemo(integer, text, text, date, numeric, text, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapcreditmemo(integer, text, text, date, numeric, text, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pDocNumber ALIAS FOR $2;
  pPoNumber ALIAS FOR $3;
  pDocDate ALIAS FOR $4;
  pAmount ALIAS FOR $5;
  pNotes ALIAS FOR $6;
  pAccntid ALIAS FOR $7;
  _result INTEGER;

BEGIN

  SELECT createAPCreditMemo( pVendid, fetchJournalNumber('AP-MISC'),
                             pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, pAccntid, pDocDate, -1, baseCurrId() ) INTO _result;

  RETURN _result;

END;
$_$;


ALTER FUNCTION public.createapcreditmemo(integer, text, text, date, numeric, text, integer) OWNER TO admin;

--
-- Name: createapcreditmemo(integer, integer, text, text, date, numeric, text, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapcreditmemo(integer, integer, text, text, date, numeric, text, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pJournalNumber ALIAS FOR $2;
  pDocNumber ALIAS FOR $3;
  pPoNumber ALIAS FOR $4;
  pDocDate ALIAS FOR $5;
  pAmount ALIAS FOR $6;
  pNotes ALIAS FOR $7;
  pAccntid ALIAS FOR $8;
BEGIN
  RETURN createAPCreditMemo( pVendid, pJournalNumber,
                             pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, pAccntid, pDocDate, -1, baseCurrId() );
END;
$_$;


ALTER FUNCTION public.createapcreditmemo(integer, integer, text, text, date, numeric, text, integer) OWNER TO admin;

--
-- Name: createapcreditmemo(integer, text, text, date, numeric, text, integer, date, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapcreditmemo(integer, text, text, date, numeric, text, integer, date, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pDocNumber ALIAS FOR $2;
  pPoNumber ALIAS FOR $3;
  pDocDate ALIAS FOR $4;
  pAmount ALIAS FOR $5;
  pNotes ALIAS FOR $6;
  pAccntid ALIAS FOR $7;
  pDueDate ALIAS FOR $8;
  pTermsid ALIAS FOR $9;
  _result INTEGER;

BEGIN

  SELECT createAPCreditMemo( pVendid, fetchJournalNumber('AP-MISC'),
                             pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, pAccntid, pDueDate, pTermsid, baseCurrId() ) INTO _result;

  RETURN _result;

END;
$_$;


ALTER FUNCTION public.createapcreditmemo(integer, text, text, date, numeric, text, integer, date, integer) OWNER TO admin;

--
-- Name: createapcreditmemo(integer, integer, text, text, date, numeric, text, integer, date, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapcreditmemo(integer, integer, text, text, date, numeric, text, integer, date, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pJournalNumber ALIAS FOR $2;
  pDocNumber ALIAS FOR $3;
  pPoNumber ALIAS FOR $4;
  pDocDate ALIAS FOR $5;
  pAmount ALIAS FOR $6;
  pNotes ALIAS FOR $7;
  pAccntid ALIAS FOR $8;
  pDueDate ALIAS FOR $9;
  pTermsid ALIAS FOR $10;
BEGIN
  RETURN createAPCreditMemo( pVendid, pJournalNumber, pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, pAccntid, pDueDate, pTermsid, baseCurrId() );
END;
$_$;


ALTER FUNCTION public.createapcreditmemo(integer, integer, text, text, date, numeric, text, integer, date, integer) OWNER TO admin;

--
-- Name: createapcreditmemo(integer, integer, text, text, date, numeric, text, integer, date, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapcreditmemo(integer, integer, text, text, date, numeric, text, integer, date, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pJournalNumber ALIAS FOR $2;
  pDocNumber ALIAS FOR $3;
  pPoNumber ALIAS FOR $4;
  pDocDate ALIAS FOR $5;
  pAmount ALIAS FOR $6;
  pNotes ALIAS FOR $7;
  pAccntid ALIAS FOR $8;
  pDueDate ALIAS FOR $9;
  pTermsid ALIAS FOR $10;
  pCurrId ALIAS FOR $11;
BEGIN
  RETURN createAPCreditMemo( NULL, pVendid, pJournalNumber, pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, pAccntid, pDueDate, pTermsid, pCurrId );
END;
$_$;


ALTER FUNCTION public.createapcreditmemo(integer, integer, text, text, date, numeric, text, integer, date, integer, integer) OWNER TO admin;

--
-- Name: createapcreditmemo(integer, integer, integer, text, text, date, numeric, text, integer, date, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapcreditmemo(integer, integer, integer, text, text, date, numeric, text, integer, date, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pId ALIAS FOR $1;
  pVendid ALIAS FOR $2;
  pJournalNumber ALIAS FOR $3;
  pDocNumber ALIAS FOR $4;
  pPoNumber ALIAS FOR $5;
  pDocDate ALIAS FOR $6;
  pAmount ALIAS FOR $7;
  pNotes ALIAS FOR $8;
  pAccntid ALIAS FOR $9;
  pDueDate ALIAS FOR $10;
  pTermsid ALIAS FOR $11;
  pCurrId ALIAS FOR $12;
  _vendName TEXT;
  _apAccntid INTEGER;
  _prepaidAccntid INTEGER;
  _accntid INTEGER;
  _glSequence INTEGER;
  _journalNumber INTEGER;
  _apopenid INTEGER;
  _baseAmount NUMERIC;
  _taxBaseValue NUMERIC;
  _test INTEGER;

BEGIN

  _apopenid := pId;

  SELECT findAPAccount(pVendid) INTO _apAccntid;
  SELECT findAPPrepaidAccount(pVendid) INTO _prepaidAccntid;

  SELECT vend_name INTO _vendName
  FROM vendinfo
  WHERE (vend_id=pVendid);
  
  _accntid := pAccntid;

  PERFORM accnt_id
     FROM accnt
    WHERE (accnt_id=_accntid);
  IF (FOUND) THEN
    _prepaidAccntid := _accntid;
  ELSE
    _accntid := -1;
  END IF;

  IF(pJournalNumber IS NULL) THEN
    SELECT fetchJournalNumber('AP-MISC') INTO _journalNumber;
  ELSE
    _journalNumber := pJournalNumber;
  END IF;

  SELECT fetchGLSequence() INTO _glSequence;

  IF (_apopenid IS NOT NULL) THEN
    UPDATE apopen SET
      apopen_username=getEffectiveXtUser(), apopen_journalnumber=_journalNumber,
      apopen_vend_id=pVendid, apopen_docnumber=pDocNumber,
      apopen_doctype='C', apopen_ponumber=pPoNumber,
      apopen_docdate=pDocDate, apopen_duedate=pDueDate,
      apopen_distdate=pDocDate, apopen_terms_id=pTermsid,
      apopen_amount=pAmount, apopen_paid=0,
      apopen_open=(pAmount <> 0), apopen_notes=pNotes,
      apopen_accnt_id=_accntid, apopen_curr_id=pCurrId,
      apopen_closedate=CASE WHEN (pAmount = 0) THEN pDocdate END
    WHERE apopen_id = _apopenid;
  ELSE
    SELECT NEXTVAL('apopen_apopen_id_seq') INTO _apopenid;
    INSERT INTO apopen
    ( apopen_id, apopen_username, apopen_journalnumber,
      apopen_vend_id, apopen_docnumber, apopen_doctype, apopen_ponumber,
      apopen_docdate, apopen_duedate, apopen_distdate, apopen_terms_id,
      apopen_amount, apopen_paid, apopen_open, apopen_notes, apopen_accnt_id, apopen_curr_id,
      apopen_closedate )
    VALUES
    ( _apopenid, getEffectiveXtUser(), _journalNumber,
      pVendid, pDocNumber, 'C', pPoNumber,
      pDocDate, pDueDate, pDocDate, pTermsid,
      pAmount, 0, (pAmount <> 0), pNotes, _accntid, pCurrId,
      CASE WHEN (pAmount = 0) THEN pDocDate END );
  END IF;

  _baseAmount := round(currToBase(pCurrId, pAmount, pDocDate), 2);

  -- Debit the A/P account for the full amount
  SELECT insertIntoGLSeries ( _glSequence, 'A/P', 'CM',
                              pDocNumber, _apAccntid,
                              (_baseAmount * -1),
                              pDocDate, (_vendName || ' ' || pNotes) ) INTO _test;

  -- Credit the Tax account for the tax amount
  _taxBaseValue := addTaxToGLSeries(_glSequence,
				      'A/P', 'CM', pDocNumber,
				      pCurrId, pDocDate, pDocDate,
                                      'apopentax', _apopenid,
                                      _vendName);

  UPDATE apopentax SET taxhist_journalnumber = _journalNumber
  WHERE taxhist_parent_id=_apopenid;

  -- Credit the Prepaid account for the basis amount
  SELECT insertIntoGLSeries ( _glSequence, 'A/P', 'CM',
                              pDocNumber, _prepaidAccntid,
                              (_baseAmount - _taxBaseValue),
                              pDocDate, (_vendName || ' ' || pNotes) ) INTO _test;

  --  Commit the GLSeries;
  SELECT postGLSeries(_glSequence, _journalNumber) INTO _test;
  IF (_test < 0) THEN
    DELETE FROM apopen WHERE (apopen_id=_apopenid);
    PERFORM deleteGLSeries(_glSequence);
    RAISE EXCEPTION 'postGLSeries commit failed with %', _test;
  END IF;

  RETURN pJournalNumber;

END;
$_$;


ALTER FUNCTION public.createapcreditmemo(integer, integer, integer, text, text, date, numeric, text, integer, date, integer, integer) OWNER TO admin;

--
-- Name: createapcreditmemoapplication(integer, integer, numeric, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapcreditmemoapplication(psourceapopenid integer, ptargetapopenid integer, pamount numeric, pcurrid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _apCreditApplyId	INTEGER;

BEGIN
  IF (pAmount > (SELECT currToCurr(apopen_curr_id, pCurrId, ROUND(apopen_amount - apopen_paid, 2), apopen_docdate)
                 FROM apopen
                 WHERE (apopen_id=pTargetApopenId))) THEN
    RETURN -1;
  END IF;

  IF (pAmount > (SELECT ROUND((apopen_amount - apopen_paid) - 
		       COALESCE(SUM(currToCurr(apcreditapply_curr_id,
						apopen_curr_id, 
						apcreditapply_amount, 
						apopen_docdate)), 0), 2)
             FROM apopen LEFT OUTER JOIN apcreditapply 
               ON ((apcreditapply_source_apopen_id=apopen_id) 
              AND (apcreditapply_target_apopen_id<>pTargetApopenId)) 
             WHERE (apopen_id=pSourceApopenId) 
             GROUP BY apopen_amount, apopen_paid)) THEN
      RETURN -2;
    END IF;

  SELECT apcreditapply_id INTO _apCreditApplyId
    FROM apcreditapply
   WHERE ((apcreditapply_source_apopen_id=pSourceApopenId)
     AND  (apcreditapply_target_apopen_id=pTargetApopenId));

  IF (FOUND) THEN
    UPDATE apcreditapply SET apcreditapply_amount=pAmount,
			     apcreditapply_curr_id=pCurrId
    WHERE (apcreditapply_id=_apCreditApplyId);
  ELSE
    INSERT INTO apcreditapply (
      apcreditapply_source_apopen_id,
      apcreditapply_target_apopen_id,
      apcreditapply_amount, apcreditapply_curr_id
    ) VALUES (
      pSourceApopenId,
      pTargetApopenId,
      pAmount, pCurrId)
    RETURNING apcreditapply_id INTO _apCreditApplyId;
  END IF;

  RETURN _apCreditApplyId;

END;
$$;


ALTER FUNCTION public.createapcreditmemoapplication(psourceapopenid integer, ptargetapopenid integer, pamount numeric, pcurrid integer) OWNER TO admin;

--
-- Name: createapdebitmemo(integer, text, text, date, numeric, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapdebitmemo(integer, text, text, date, numeric, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pDocNumber ALIAS FOR $2;
  pPoNumber ALIAS FOR $3;
  pDocDate ALIAS FOR $4;
  pAmount ALIAS FOR $5;
  pNotes ALIAS FOR $6;
  _result INTEGER;

BEGIN

  SELECT createAPDebitMemo( pVendid, fetchJournalNumber('AP-MISC'),
                            pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, -1, pDocDate, -1, baseCurrId() ) INTO _result;

  RETURN _result;

END;
$_$;


ALTER FUNCTION public.createapdebitmemo(integer, text, text, date, numeric, text) OWNER TO admin;

--
-- Name: createapdebitmemo(integer, integer, text, text, date, numeric, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapdebitmemo(integer, integer, text, text, date, numeric, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pJournalNumber ALIAS FOR $2;
  pDocNumber ALIAS FOR $3;
  pPoNumber ALIAS FOR $4;
  pDocDate ALIAS FOR $5;
  pAmount ALIAS FOR $6;
  pNotes ALIAS FOR $7;

BEGIN

  RETURN createAPDebitMemo(pVendid, pJournalNumber, pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, -1, pDocDate, -1, baseCurrId() );

END;
$_$;


ALTER FUNCTION public.createapdebitmemo(integer, integer, text, text, date, numeric, text) OWNER TO admin;

--
-- Name: createapdebitmemo(integer, text, text, date, numeric, text, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapdebitmemo(integer, text, text, date, numeric, text, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pDocNumber ALIAS FOR $2;
  pPoNumber ALIAS FOR $3;
  pDocDate ALIAS FOR $4;
  pAmount ALIAS FOR $5;
  pNotes ALIAS FOR $6;
  pAccntid ALIAS FOR $7;
  _result INTEGER;

BEGIN

  SELECT createAPDebitMemo( pVendid, fetchJournalNumber('AP-MISC'),
                            pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, pAccntid, pDocDate, -1, baseCurrId() ) INTO _result;

  RETURN _result;

END;
$_$;


ALTER FUNCTION public.createapdebitmemo(integer, text, text, date, numeric, text, integer) OWNER TO admin;

--
-- Name: createapdebitmemo(integer, integer, text, text, date, numeric, text, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapdebitmemo(integer, integer, text, text, date, numeric, text, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pJournalNumber ALIAS FOR $2;
  pDocNumber ALIAS FOR $3;
  pPoNumber ALIAS FOR $4;
  pDocDate ALIAS FOR $5;
  pAmount ALIAS FOR $6;
  pNotes ALIAS FOR $7;
  pAccntid ALIAS FOR $8;
BEGIN
  RETURN createAPDebitMemo( pVendid, pJournalNumber,
                            pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, pAccntid, pDocDate, -1, baseCurrId() );
END;
$_$;


ALTER FUNCTION public.createapdebitmemo(integer, integer, text, text, date, numeric, text, integer) OWNER TO admin;

--
-- Name: createapdebitmemo(integer, text, text, date, numeric, text, integer, date, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapdebitmemo(integer, text, text, date, numeric, text, integer, date, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pDocNumber ALIAS FOR $2;
  pPoNumber ALIAS FOR $3;
  pDocDate ALIAS FOR $4;
  pAmount ALIAS FOR $5;
  pNotes ALIAS FOR $6;
  pAccntid ALIAS FOR $7;
  pDueDate ALIAS FOR $8;
  pTermsid ALIAS FOR $9;
  _result INTEGER;

BEGIN

  SELECT createAPDebitMemo( pVendid, fetchJournalNumber('AP-MISC'),
                            pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, pAccntid, pDueDate, pTermsid, baseCurrId() ) INTO _result;

  RETURN _result;

END;
$_$;


ALTER FUNCTION public.createapdebitmemo(integer, text, text, date, numeric, text, integer, date, integer) OWNER TO admin;

--
-- Name: createapdebitmemo(integer, integer, text, text, date, numeric, text, integer, date, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapdebitmemo(integer, integer, text, text, date, numeric, text, integer, date, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pJournalNumber ALIAS FOR $2;
  pDocNumber ALIAS FOR $3;
  pPoNumber ALIAS FOR $4;
  pDocDate ALIAS FOR $5;
  pAmount ALIAS FOR $6;
  pNotes ALIAS FOR $7;
  pAccntid ALIAS FOR $8;
  pDueDate ALIAS FOR $9;
  pTermsid ALIAS FOR $10;

BEGIN
  RETURN createAPDebitMemo(pVendid, pJournalNumber, pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, pAccntid, pDueDate, pTermsid, baseCurrId() );
END;
$_$;


ALTER FUNCTION public.createapdebitmemo(integer, integer, text, text, date, numeric, text, integer, date, integer) OWNER TO admin;

--
-- Name: createapdebitmemo(integer, integer, text, text, date, numeric, text, integer, date, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapdebitmemo(integer, integer, text, text, date, numeric, text, integer, date, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pVendid ALIAS FOR $1;
  pJournalNumber ALIAS FOR $2;
  pDocNumber ALIAS FOR $3;
  pPoNumber ALIAS FOR $4;
  pDocDate ALIAS FOR $5;
  pAmount ALIAS FOR $6;
  pNotes ALIAS FOR $7;
  pAccntid ALIAS FOR $8;
  pDueDate ALIAS FOR $9;
  pTermsid ALIAS FOR $10;
  pCurrId ALIAS FOR $11;

BEGIN
  RETURN createAPDebitMemo(NULL, pVendid, pJournalNumber, pDocNumber, pPoNumber, pDocDate, pAmount, pNotes, pAccntid, pDueDate, pTermsid, pCurrId );
END;
$_$;


ALTER FUNCTION public.createapdebitmemo(integer, integer, text, text, date, numeric, text, integer, date, integer, integer) OWNER TO admin;

--
-- Name: createapdebitmemo(integer, integer, integer, text, text, date, numeric, text, integer, date, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapdebitmemo(integer, integer, integer, text, text, date, numeric, text, integer, date, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pId ALIAS FOR $1;
  pVendid ALIAS FOR $2;
  pJournalNumber ALIAS FOR $3;
  pDocNumber ALIAS FOR $4;
  pPoNumber ALIAS FOR $5;
  pDocDate ALIAS FOR $6;
  pAmount ALIAS FOR $7;
  pNotes ALIAS FOR $8;
  pAccntid ALIAS FOR $9;
  pDueDate ALIAS FOR $10;
  pTermsid ALIAS FOR $11;
  pCurrId ALIAS FOR $12;
  _vendName TEXT;
  _apAccntid INTEGER;
  _prepaidAccntid INTEGER;
  _accntid INTEGER;
  _glSequence INTEGER;
  _journalNumber INTEGER;
  _apopenid INTEGER;
  _baseAmount NUMERIC;
  _taxBaseValue NUMERIC;
  _test INTEGER;

BEGIN

  _apopenid := pId;

  SELECT findAPAccount(pVendid) INTO _apAccntid;
  SELECT findAPPrepaidAccount(pVendid) INTO _prepaidAccntid;

  SELECT vend_name INTO _vendName
  FROM vendinfo
  WHERE (vend_id=pVendid);

  _accntid := pAccntid;

  PERFORM accnt_id
     FROM accnt
    WHERE (accnt_id=_accntid);
  IF (FOUND) THEN
    _prepaidAccntid := _accntid;
  ELSE
    _accntid := -1;
  END IF;

  IF(pJournalNumber IS NULL) THEN
    SELECT fetchJournalNumber('AP-MISC') INTO _journalNumber;
  ELSE
    _journalNumber := pJournalNumber;
  END IF;

  SELECT fetchGLSequence() INTO _glSequence;

  IF (_apopenid IS NOT NULL) THEN
    UPDATE apopen SET
      apopen_username=getEffectiveXtUser(), apopen_journalnumber=_journalNumber,
      apopen_vend_id=pVendid, apopen_docnumber=pDocNumber,
      apopen_doctype='D', apopen_ponumber=pPoNumber,
      apopen_docdate=pDocDate, apopen_duedate=pDueDate,
      apopen_distdate=pDocDate, apopen_terms_id=pTermsid,
      apopen_amount=pAmount, apopen_paid=0,
      apopen_open=(pAmount <> 0), apopen_notes=pNotes,
      apopen_accnt_id=_accntid, apopen_curr_id=pCurrId,
      apopen_closedate=CASE WHEN (pAmount = 0) THEN pDocdate END
    WHERE apopen_id = _apopenid;
  ELSE
    SELECT NEXTVAL('apopen_apopen_id_seq') INTO _apopenid;
    INSERT INTO apopen
    ( apopen_id, apopen_username, apopen_journalnumber,
      apopen_vend_id, apopen_docnumber, apopen_doctype, apopen_ponumber,
      apopen_docdate, apopen_duedate, apopen_distdate, apopen_terms_id,
      apopen_amount, apopen_paid, apopen_discountable_amount, apopen_open, apopen_notes, apopen_accnt_id, apopen_curr_id,
      apopen_closedate )
    VALUES
    ( _apopenid, getEffectiveXtUser(), _journalNumber,
      pVendid, pDocNumber, 'D', pPoNumber,
      pDocDate, pDueDate, pDocDate, pTermsid,
      pAmount, 0, 0, (pAmount <> 0), pNotes, _accntid, pCurrId,
      CASE WHEN (pAmount = 0) THEN pDocDate END );
  END IF;

  _baseAmount := round(currToBase(pCurrId, pAmount, pDocDate), 2);

  -- Credit the A/P account for the full amount
  SELECT insertIntoGLSeries ( _glSequence, 'A/P', 'DM',
                              pDocNumber, _apAccntid,
                              _baseAmount,
                              pDocDate, (_vendName || ' ' || pNotes) ) INTO _test;

  -- Debit the Tax account for the tax amount
  _taxBaseValue := addTaxToGLSeries(_glSequence,
				      'A/P', 'DM', pDocNumber,
				      pCurrId, pDocDate, pDocDate,
                                      'apopentax', _apopenid,
                                      _vendName);

  UPDATE apopentax SET taxhist_journalnumber = _journalNumber
  WHERE taxhist_parent_id=_apopenid;

  -- Debit the Prepaid account for the basis amount
  -- Note, the taxBaseValue is negative so it is added
  SELECT insertIntoGLSeries ( _glSequence, 'A/P', 'DM',
                              pDocNumber, _prepaidAccntid,
                              (_baseAmount + _taxBaseValue) * -1,
                              pDocDate, (_vendName || ' ' || pNotes) ) INTO _test;

  --  Commit the GLSeries;
  SELECT postGLSeries(_glSequence, _journalNumber) INTO _test;
  IF (_test < 0) THEN
    DELETE FROM apopen WHERE (apopen_id=_apopenid);
    PERFORM deleteGLSeries(_glSequence);
    RAISE EXCEPTION 'postGLSeries commit failed with %', _test;
  END IF;

  RETURN _apopenid;

END;
$_$;


ALTER FUNCTION public.createapdebitmemo(integer, integer, integer, text, text, date, numeric, text, integer, date, integer, integer) OWNER TO admin;

--
-- Name: createapdiscount(integer, numeric); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapdiscount(integer, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pApopenid ALIAS FOR $1;
  pAmount ALIAS FOR $2;
  _result INTEGER;
  
BEGIN

  SELECT createAPDiscount(pApopenid, fetchJournalNumber('AP-MISC'), pAmount) INTO _result;

  RETURN _result;

END;
$_$;


ALTER FUNCTION public.createapdiscount(integer, numeric) OWNER TO admin;

--
-- Name: createapdiscount(integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createapdiscount(integer, integer, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pApopenid ALIAS FOR $1;
  pJournalNumber ALIAS FOR $2;
  pAmount ALIAS FOR $3;
  _ap RECORD;
  _sequence INTEGER;
  _apopenid INTEGER;
  _apcreditapplyid INTEGER;
  _result INTEGER;
  _crAccnt INTEGER;
  _dbAccnt INTEGER;
  _reference    TEXT;
  _discountDateAmt NUMERIC;

BEGIN

  SELECT NEXTVAL('apopen_apopen_id_seq') INTO _apopenid;

  SELECT * INTO _ap
  FROM apopen
  WHERE (apopen_id = pApopenid);
  IF (NOT FOUND) THEN
    RETURN -1;
  END IF;

  _crAccnt := findAPDiscountAccount(_ap.apopen_vend_id);
  _dbAccnt := findAPAccount(_ap.apopen_vend_id);
  _reference := ('Discount for ' || _ap.apopen_doctype || ' ' || _ap.apopen_docnumber);

  SELECT fetchGLSequence() INTO _sequence;

  _discountDateAmt = round(pAmount / _ap.apopen_curr_rate, 2);
  PERFORM insertIntoGLSeries( _sequence, 'A/P', 'DS', _ap.apopen_docnumber,
                              _dbAccnt,
                              _discountDateAmt * -1,
                              CURRENT_DATE,
                              _reference);
  PERFORM insertIntoGLSeries( _sequence, 'A/P', 'DS', _ap.apopen_docnumber,
                              _crAccnt,
                              _discountDateAmt,
                              CURRENT_DATE,
                              _reference);

  PERFORM postGLSeries(_sequence, pJournalNumber);

  INSERT INTO apopen
  ( apopen_id, apopen_username, apopen_journalnumber,
    apopen_vend_id, apopen_docnumber, apopen_doctype, apopen_ponumber,
    apopen_docdate, apopen_duedate, apopen_distdate, apopen_terms_id, apopen_curr_id,
    apopen_amount, apopen_paid, apopen_open, apopen_notes, apopen_discount, apopen_curr_rate )
  SELECT _apopenid, getEffectiveXtUser(), pJournalNumber,
         apopen_vend_id, apopen_docnumber, 'C', apopen_ponumber,
         CURRENT_DATE, CURRENT_DATE, CURRENT_DATE, -1, apopen_curr_id,
         pAmount, 0, TRUE, _reference, TRUE, apopen_curr_rate
    FROM apopen
   WHERE (apopen_id=pApopenid);

  SELECT apcreditapply_id INTO _apcreditapplyid
    FROM apcreditapply
   WHERE ( (apcreditapply_source_apopen_id=_apopenid)
     AND   (apcreditapply_target_apopen_id=pApopenid) );
  IF (FOUND) THEN
    UPDATE apcreditapply
       SET apcreditapply_amount=pAmount
     WHERE (apcreditapply_id=_apcreditapplyid);
  ELSE
    SELECT nextval('apcreditapply_apcreditapply_id_seq') INTO _apcreditapplyid;
    INSERT INTO apcreditapply
           ( apcreditapply_id, apcreditapply_source_apopen_id,
             apcreditapply_target_apopen_id, apcreditapply_amount,
             apcreditapply_curr_id )
    VALUES ( _apcreditapplyid, _apopenid, pApopenid, pAmount, _ap.apopen_curr_id );
  END IF;

  SELECT postAPCreditMemoApplication(_apopenid) INTO _result;

  IF (_result < 0) THEN
    RETURN _result;
  END IF;

  RETURN pJournalNumber;

END;
$_$;


ALTER FUNCTION public.createapdiscount(integer, integer, numeric) OWNER TO admin;

--
-- Name: createarcashdeposit(integer, text, text, date, numeric, text, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createarcashdeposit(integer, text, text, date, numeric, text, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCustid ALIAS FOR $1;
  pDocNumber ALIAS FOR $2;
  pOrderNumber ALIAS FOR $3;
  pDocDate ALIAS FOR $4;
  pAmount ALIAS FOR $5;
  pNotes ALIAS FOR $6;
  pJournalNumber ALIAS FOR $7;
  pCurrId ALIAS FOR $8;
  _prepaidaccntid INTEGER;
  _deferredaccntid INTEGER;
  _glSequence INTEGER;
  _aropenid INTEGER;

BEGIN

  IF (pAmount <= 0) THEN
    RETURN 0;
  END IF;

  _prepaidaccntid := findPrepaidAccount(pCustid);
  IF (_prepaidaccntid = -1) THEN
    RAISE EXCEPTION 'There was an error creating the Customer Deposit GL Transactions. No Prepaid Account is assigned.';
  END IF;

  _deferredaccntid := findDeferredAccount(pCustid);
  IF (_deferredaccntid = -1) THEN
    RAISE EXCEPTION 'There was an error creating the Customer Deposit GL Transactions. No Deferred Account is assigned.';
  END IF;

  SELECT NEXTVAL('aropen_aropen_id_seq') INTO _aropenid;

  SELECT insertGLTransaction( pJournalNumber, 'A/R', 'CD',
                              pDocNumber, pNotes, _deferredaccntid, _prepaidaccntid,
                              _aropenid,
                              round(currToBase(pCurrId, pAmount, pDocDate), 2),
                              pDocDate) INTO _glSequence;

  INSERT INTO aropen
  ( aropen_id, aropen_username, aropen_journalnumber,
    aropen_cust_id, aropen_docnumber, aropen_doctype, aropen_ordernumber,
    aropen_docdate, aropen_duedate, aropen_distdate, aropen_terms_id, aropen_salesrep_id,
    aropen_amount, aropen_paid, aropen_commission_due, aropen_commission_paid,
    aropen_applyto, aropen_ponumber, aropen_cobmisc_id,
    aropen_open, aropen_notes, aropen_rsncode_id,
    aropen_salescat_id, aropen_accnt_id, aropen_curr_id )
  VALUES
  ( _aropenid, getEffectiveXtUser(), pJournalNumber,
    pCustid, pDocNumber, 'R', pOrderNumber,
    pDocDate, pDocDate, pDocDate, -1, NULL,
    round(pAmount, 2), 0, 0.0, FALSE,
    '', '', -1,
    TRUE, pNotes, -1,
    -1, -1, pCurrId );

  RETURN _aropenid;

END;
$_$;


ALTER FUNCTION public.createarcashdeposit(integer, text, text, date, numeric, text, integer, integer) OWNER TO admin;

--
-- Name: createarcreditmemo(integer, integer, text, text, date, numeric, text, integer, integer, integer, date, integer, integer, numeric, integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createarcreditmemo(pid integer, pcustid integer, pdocnumber text, pordernumber text, pdocdate date, pamount numeric, pnotes text, prsncodeid integer, psalescatid integer, paccntid integer, pduedate date, ptermsid integer, psalesrepid integer, pcommissiondue numeric DEFAULT 0, pjournalnumber integer DEFAULT NULL::integer, pcurrid integer DEFAULT basecurrid(), paraccntid integer DEFAULT NULL::integer, pcoccpayid integer DEFAULT NULL::integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _accntid        INTEGER;
  _arAccntid      INTEGER;
  _aropenid       INTEGER;
  _cohistid       INTEGER;
  _custName       TEXT;
  _duedate        DATE    := COALESCE(pDueDate, pDocDate);
  _glSequence     INTEGER;
  _journalNumber  INTEGER;
  _prepaidAccntid INTEGER;
  _salescatid     INTEGER;
  _taxBaseValue   NUMERIC;
  _test           INTEGER;
  _tmp            INTEGER;

BEGIN

  _aropenid := pId;

  IF (pAmount <= 0) THEN
    RETURN 0;
  END IF;

  _arAccntid := COALESCE(pARAccntid, findARAccount(pCustid));
  _prepaidAccntid := findPrepaidAccount(pCustid);

  _accntid := pAccntid;
  _salescatid := pSalescatid;

  SELECT cust_name INTO _custName
  FROM custinfo
  WHERE (cust_id=pCustid);

  IF EXISTS(SELECT 1 FROM accnt WHERE (accnt_id=_accntid)) THEN
    _prepaidAccntid := _accntid;
  ELSE
    _accntid := -1;
  END IF;

  SELECT accnt_id INTO _tmp
    FROM salescat, accnt
   WHERE ((salescat_prepaid_accnt_id=accnt_id)
     AND  (salescat_id=_salescatid));
  IF (FOUND) THEN
    _accntid := -1;
    _prepaidAccntid := _tmp;
  ELSE
    _salescatid = -1;
  END IF;

  IF(pJournalNumber IS NULL) THEN
    SELECT fetchJournalNumber('AR-MISC') INTO _journalNumber;
  ELSE
    _journalNumber := pJournalNumber;
  END IF;

  _glSequence := fetchGLSequence();

  -- CreatelUpdate aropen for full amount
  IF (_aropenid IS NOT NULL) THEN
    UPDATE aropen SET
      aropen_username=getEffectiveXtUser(), aropen_journalnumber=_journalNumber,
      aropen_cust_id=pCustid, aropen_docnumber=pDocNumber, aropen_doctype='C',
      aropen_ordernumber=pOrderNumber,aropen_docdate=pDocDate, aropen_duedate=_duedate,
      aropen_distdate=pDocDate, aropen_terms_id=pTermsid,
      aropen_salesrep_id=pSalesrepid, aropen_amount=round(pAmount, 2), aropen_paid=0,
      aropen_commission_due=pCommissiondue, aropen_commission_paid=FALSE,
      aropen_applyto='', aropen_ponumber='', aropen_cobmisc_id=-1,
      aropen_open=TRUE, aropen_notes=pNotes, aropen_rsncode_id=pRsncodeid,
      aropen_salescat_id=_salescatid, aropen_accnt_id=_accntid, aropen_curr_id=pCurrId
    WHERE aropen_id = pId;
  ELSE
    SELECT NEXTVAL('aropen_aropen_id_seq') INTO _aropenid;
    INSERT INTO aropen
    ( aropen_id, aropen_username, aropen_journalnumber,
      aropen_cust_id, aropen_docnumber, aropen_doctype, aropen_ordernumber,
      aropen_docdate, aropen_duedate, aropen_distdate, aropen_terms_id, aropen_salesrep_id,
      aropen_amount, aropen_paid, aropen_commission_due, aropen_commission_paid,
      aropen_applyto, aropen_ponumber, aropen_cobmisc_id,
      aropen_open, aropen_notes, aropen_rsncode_id,
      aropen_salescat_id, aropen_accnt_id, aropen_curr_id )
    VALUES
    ( _aropenid, getEffectiveXtUser(), _journalNumber,
      pCustid, pDocNumber, 'C', pOrderNumber,
      pDocDate, _duedate, pDocDate, pTermsid, pSalesrepid,
      round(pAmount, 2), 0, pCommissiondue, FALSE,
      '', '', -1,
      TRUE, pNotes, pRsncodeid,
      _salescatid, _accntid, pCurrId );
  END IF;

  -- Credit the A/R account for the full amount
  SELECT insertIntoGLSeries ( _glSequence, 'A/R', 'CM',
                              pDocNumber, _arAccntid,
                              round(currToBase(pCurrId, pAmount, pDocDate), 2),
                              pDocDate, (_custName || ' ' || pNotes)) INTO _test;

  -- Debit the Tax account for the tax amount
  _taxBaseValue := addTaxToGLSeries(_glSequence,
				      'A/R', 'CM', pDocNumber,
				      pCurrId, pDocDate, pDocDate,
                                      'aropentax', _aropenid,
                                      (_custName || ' ' || pNotes));

  UPDATE aropentax SET taxhist_journalnumber = _journalNumber
  WHERE taxhist_parent_id=_aropenid;

  -- Debit the Prepaid account for the basis amount
  -- Note, _taxBaseValue is negative so it is added to pAmount
  SELECT insertIntoGLSeries ( _glSequence, 'A/R', 'CM',
                              pDocNumber, _prepaidAccntid,
                              round(currToBase(pCurrId, pAmount * -1, pDocDate) + _taxBaseValue * -1, 2),
                              pDocDate, (_custName || ' ' || pNotes)) INTO _test;

  --  Commit the GLSeries;
  SELECT postGLSeries(_glSequence, _journalNumber) INTO _test;
  IF (_test < 0) THEN
    DELETE FROM aropen WHERE (aropen_id=_aropenid);
    PERFORM deleteGLSeries(_glSequence);
    RAISE EXCEPTION 'postGLSeries commit failed with %', _test;
  END IF;

  --  Record Sales History
  INSERT INTO cohist
  ( cohist_cust_id,
   cohist_itemsite_id, cohist_shipto_id,
    cohist_misc_type, cohist_misc_descrip,
    cohist_shipdate, cohist_shipvia,
    cohist_ordernumber, cohist_ponumber, cohist_orderdate,
    cohist_doctype, cohist_invcnumber, cohist_invcdate,
    cohist_qtyshipped, cohist_unitprice, cohist_unitcost,
    cohist_salesrep_id,
    cohist_commission, cohist_commissionpaid,
    cohist_curr_id, cohist_sequence, cohist_cohead_ccpay_id)
  VALUES
  (CASE WHEN pCustid < 0 THEN NULL ELSE pCustid END,
   -1, -1,
    'M', 'A/R Misc Credit Memo',
    pDocDate, '',
    pOrderNumber, '', pDocDate,
    'C', pDocNumber, pDocDate,
    1, (pAmount - _taxBaseValue) * -1, 0,
    CASE WHEN pSalesrepid < 0 THEN NULL ELSE pSalesrepid END,
    (pCommissiondue * -1.0), FALSE,
    pCurrId, _glSequence, pCoCcpayId)
  RETURNING cohist_id INTO _cohistid;

  INSERT INTO cohisttax
  ( taxhist_parent_id, taxhist_taxtype_id, taxhist_tax_id,
    taxhist_basis, taxhist_basis_tax_id, taxhist_sequence,
    taxhist_percent, taxhist_amount, taxhist_tax,
    taxhist_docdate, taxhist_distdate, taxhist_curr_id, taxhist_curr_rate,
    taxhist_journalnumber )
  SELECT _cohistid, taxhist_taxtype_id, taxhist_tax_id,
         taxhist_basis, taxhist_basis_tax_id, taxhist_sequence,
         taxhist_percent, taxhist_amount, taxhist_tax,
         taxhist_docdate, taxhist_distdate, taxhist_curr_id, taxhist_curr_rate,
         taxhist_journalnumber
  FROM aropentax
  WHERE (taxhist_parent_id=_aropenid);

  RETURN _aropenid;

END;
$$;


ALTER FUNCTION public.createarcreditmemo(pid integer, pcustid integer, pdocnumber text, pordernumber text, pdocdate date, pamount numeric, pnotes text, prsncodeid integer, psalescatid integer, paccntid integer, pduedate date, ptermsid integer, psalesrepid integer, pcommissiondue numeric, pjournalnumber integer, pcurrid integer, paraccntid integer, pcoccpayid integer) OWNER TO admin;

--
-- Name: createardebitmemo(integer, integer, integer, text, text, date, numeric, text, integer, integer, integer, date, integer, integer, numeric, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createardebitmemo(integer, integer, integer, text, text, date, numeric, text, integer, integer, integer, date, integer, integer, numeric, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pId			ALIAS FOR $1;
  pCustid		ALIAS FOR $2;
  pJournalNumber	ALIAS FOR $3;
  pDocNumber		ALIAS FOR $4;
  pOrderNumber		ALIAS FOR $5;
  pDocDate		ALIAS FOR $6;
  pAmount		ALIAS FOR $7;
  pNotes		ALIAS FOR $8;
  pRsncodeid		ALIAS FOR $9;
  pSalescatid		ALIAS FOR $10;
  pAccntid		ALIAS FOR $11;
  pDueDate		ALIAS FOR $12;
  pTermsid		ALIAS FOR $13;
  pSalesrepid		ALIAS FOR $14;
  pCommissiondue	ALIAS FOR $15;
  pCurrId		ALIAS FOR $16;
  _custName TEXT;
  _journalNumber INTEGER;
  _arAccntid INTEGER;
  _prepaidAccntid INTEGER;
  _salescatid INTEGER;
  _accntid INTEGER;
  _glSequence INTEGER;
  _aropenid INTEGER;
  _cohistid INTEGER;
  _tmp INTEGER;
  _test INTEGER;
  _taxBaseValue NUMERIC;

BEGIN
  _aropenid=pId;
  
  IF (pAmount <= 0) THEN
    RETURN 0;
  END IF;

  SELECT findARAccount(pCustid) INTO _arAccntid;
  SELECT findPrepaidAccount(pCustid) INTO _prepaidAccntid;

  _accntid := pAccntid;
  _salescatid := pSalescatid;

  SELECT cust_name INTO _custName
  FROM custinfo
  WHERE (cust_id=pCustid);
  
  PERFORM accnt_id
     FROM accnt
    WHERE (accnt_id=_accntid);
  IF (FOUND) THEN
    _prepaidAccntid := _accntid;
  ELSE
    _accntid := -1;
  END IF;

  SELECT accnt_id INTO _tmp
    FROM salescat, accnt
   WHERE ((salescat_prepaid_accnt_id=accnt_id)
     AND  (salescat_id=_salescatid));
  IF (FOUND) THEN
    _accntid := -1;
    _prepaidAccntid := _tmp;
  ELSE
    _salescatid = -1;
  END IF;

  IF (pJournalNumber IS NULL) THEN
    _journalNumber := fetchJournalNumber('AR-MISC');
  ELSE
    _journalNumber := pJournalNumber;
  END IF;

  SELECT fetchGLSequence() INTO _glSequence;

  -- CreatelUpdate aropen for full amount
  IF (_aropenid IS NOT NULL) THEN
    UPDATE aropen SET
      aropen_username=getEffectiveXtUser(), aropen_journalnumber=_journalNumber,
      aropen_cust_id=pCustid, aropen_docnumber=pDocNumber, aropen_doctype='D', 
      aropen_ordernumber=pOrderNumber,aropen_docdate=pDocDate, aropen_duedate=pDueDate, 
      aropen_distdate=pDocDate, aropen_terms_id=pTermsid, 
      aropen_salesrep_id=pSalesrepid, aropen_amount=round(pAmount, 2), aropen_paid=0, 
      aropen_commission_due=pCommissiondue, aropen_commission_paid=FALSE,
      aropen_applyto='', aropen_ponumber='', aropen_cobmisc_id=-1,
      aropen_open=TRUE, aropen_notes=pNotes, aropen_rsncode_id=pRsncodeid,
      aropen_salescat_id=_salescatid, aropen_accnt_id=_accntid, aropen_curr_id=pCurrId
    WHERE aropen_id = pId;
  ELSE
    SELECT NEXTVAL('aropen_aropen_id_seq') INTO _aropenid;
    INSERT INTO aropen
    ( aropen_id, aropen_username, aropen_journalnumber,
      aropen_cust_id, aropen_docnumber, aropen_doctype, aropen_ordernumber,
      aropen_docdate, aropen_duedate, aropen_distdate, aropen_terms_id, aropen_salesrep_id,
      aropen_amount, aropen_paid, aropen_commission_due, aropen_commission_paid,
      aropen_applyto, aropen_ponumber, aropen_cobmisc_id,
      aropen_open, aropen_notes, aropen_rsncode_id,
      aropen_salescat_id, aropen_accnt_id, aropen_curr_id )
    VALUES
    ( _aropenid, getEffectiveXtUser(), _journalNumber,
      pCustid, pDocNumber, 'D', pOrderNumber,
      pDocDate, pDueDate, pDocDate, pTermsid, pSalesrepid,
      round(pAmount, 2), 0, pCommissiondue, FALSE,
      '', '', -1,
      TRUE, pNotes, pRsncodeid,
      _salescatid, _accntid, pCurrId );
  END IF;

  -- Debit the A/R account for the full amount
  SELECT insertIntoGLSeries ( _glSequence, 'A/R', 'DM',
                              pDocNumber, _arAccntid,
                              round(currToBase(pCurrId, pAmount, pDocDate) * -1, 2),
                              pDocDate, (_custName || ' ' || pNotes)) INTO _test;

  -- Credit the Tax account for the tax amount
  _taxBaseValue := addTaxToGLSeries(_glSequence,
				      'A/R', 'DM', pDocNumber,
				      pCurrId, pDocDate, pDocDate,
                                      'aropentax', _aropenid,
                                      (_custName || ' ' || pNotes));

  UPDATE aropentax SET taxhist_journalnumber = _journalNumber
  WHERE taxhist_parent_id=_aropenid;

  -- Credit the Prepaid account for the basis amount
  SELECT insertIntoGLSeries ( _glSequence, 'A/R', 'DM',
                              pDocNumber, _prepaidAccntid,
                              round(currToBase(pCurrId, (pAmount), pDocDate), 2) - _taxBaseValue,
                              pDocDate, (_custName || ' ' || pNotes)) INTO _test;

  --  Commit the GLSeries;
  SELECT postGLSeries(_glSequence, _journalNumber) INTO _test;
  IF (_test < 0) THEN
    DELETE FROM aropen WHERE (aropen_id=_aropenid);
    PERFORM deleteGLSeries(_glSequence);
    RAISE EXCEPTION 'postGLSeries commit failed with %', _test;
  END IF;

  --  Record Sales History
  SELECT nextval('cohist_cohist_id_seq') INTO _cohistid;
  INSERT INTO cohist
  ( cohist_id, cohist_cust_id, cohist_itemsite_id, cohist_shipto_id,
    cohist_misc_type, cohist_misc_descrip,
    cohist_shipdate, cohist_shipvia,
    cohist_ordernumber, cohist_ponumber, cohist_orderdate,
    cohist_doctype, cohist_invcnumber, cohist_invcdate,
    cohist_qtyshipped, cohist_unitprice, cohist_unitcost,
    cohist_salesrep_id, cohist_commission, cohist_commissionpaid,
    cohist_curr_id, cohist_sequence )
  VALUES
  ( _cohistid, pCustid, -1, -1,
    'M', 'A/R Misc Debit Memo',
    pDocDate, '',
    '', '', pDocDate,
    'D', pDocNumber, pDocDate,
    1, (pAmount - _taxBaseValue), 0,
    pSalesrepid, pCommissiondue, FALSE,
    pCurrId, _glSequence );
  INSERT INTO cohisttax
  ( taxhist_parent_id, taxhist_taxtype_id, taxhist_tax_id,
    taxhist_basis, taxhist_basis_tax_id, taxhist_sequence,
    taxhist_percent, taxhist_amount, taxhist_tax,
    taxhist_docdate, taxhist_distdate, taxhist_curr_id, taxhist_curr_rate,
    taxhist_journalnumber )
  SELECT _cohistid, taxhist_taxtype_id, taxhist_tax_id,
         taxhist_basis, taxhist_basis_tax_id, taxhist_sequence,
         taxhist_percent, taxhist_amount, taxhist_tax,
         taxhist_docdate, taxhist_distdate, taxhist_curr_id, taxhist_curr_rate,
         taxhist_journalnumber
  FROM aropentax
  WHERE (taxhist_parent_id=_aropenid);

  RETURN _aropenid;

END;
$_$;


ALTER FUNCTION public.createardebitmemo(integer, integer, integer, text, text, date, numeric, text, integer, integer, integer, date, integer, integer, numeric, integer) OWNER TO admin;

--
-- Name: createbillingheader(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createbillingheader(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pSoheadid		ALIAS FOR $1;
  _cobmiscid		INTEGER;
  _cohead		cohead%ROWTYPE;
  _miscApplied          NUMERIC := 0.0;
  _freight		NUMERIC;
  _freighttypeid        INTEGER;
  _invcDate		DATE;
  _schedDate		DATE;
  _shipDate		DATE;
  _shipVia		TEXT;
  _tax			NUMERIC;

BEGIN

  --  Fetch cohead
  SELECT * INTO _cohead
  FROM cohead
  WHERE (cohead_id=pSoheadid);

  --  Check for an existing cobmisc
  SELECT cobmisc_id INTO _cobmiscid
  FROM cobmisc
  WHERE ( (NOT cobmisc_posted)
   AND (cobmisc_cohead_id=pSoheadid) );

  IF (FOUND) THEN
  --  Find a Shipping-Entered freight charge
    SELECT SUM(currToCurr(shiphead_freight_curr_id, _cohead.cohead_curr_id,
                          shiphead_freight, CURRENT_DATE)) INTO _freight
    FROM (
    SELECT shiphead_id, shiphead_freight_curr_id, shiphead_freight
    FROM shiphead JOIN shipitem ON (shipitem_shiphead_id=shiphead_id AND NOT shipitem_invoiced)
    WHERE ((shiphead_order_type='SO')
      AND  (shiphead_order_id=pSoheadid))
    GROUP BY shiphead_id, shiphead_freight_curr_id, shiphead_freight) AS data;

    IF (_freight IS NOT NULL) THEN
      UPDATE cobmisc SET cobmisc_freight = _freight
      WHERE (cobmisc_id=_cobmiscid);
    END IF;

    RETURN _cobmiscid;
  END IF;

  --  Find misc charges that have already been applied for the S/O
  SELECT COALESCE(SUM(cobmisc_misc), 0.0) INTO _miscApplied
  FROM cobmisc
  WHERE (cobmisc_cohead_id=pSoheadid);

  SELECT NEXTVAL('cobmisc_cobmisc_id_seq') INTO _cobmiscid;

  --  Check for a valid shipdate
  SELECT MIN(shiphead_shipdate) INTO _shipDate
  FROM shiphead, shipitem
  WHERE ( (shipitem_shiphead_id=shiphead_id)
   AND (NOT shipitem_invoiced)
   AND (shiphead_shipped)
   AND (shiphead_order_type='SO')
   AND (shiphead_order_id=pSoheadid) );

  --  Schema shouldn't allow, but we'll try for now
  IF (_shipDate IS NULL) THEN
    SELECT MAX(shipitem_shipdate) INTO _shipDate
    FROM shipitem, shiphead
    WHERE ( (shipitem_shiphead_id=shiphead_id)
     AND (shiphead_order_type='SO')
     AND (shiphead_order_id=pSoheadid) );

    --  How about a transaction date
    IF (_shipDate IS NULL) THEN
      SELECT COALESCE(MAX(shipitem_transdate), CURRENT_DATE) INTO _shipDate
      FROM shipitem, shiphead
      WHERE ((shipitem_shiphead_id=shiphead_id)
        AND  (shiphead_order_type='SO')
        AND  (shiphead_order_id=pSoheadid) );
    END IF;
  END IF;

  --  Get the earliest schedule date for this order.
  SELECT MIN(coitem_scheddate) INTO _schedDate
    FROM coitem
   WHERE ((coitem_status <> 'X') AND (coitem_cohead_id=pSoheadid));

  IF (_schedDate IS NULL) THEN
    _schedDate := _shipDate;
  END IF;

  --  Find a Shipping-Entered freight charge
  SELECT SUM(currToCurr(shiphead_freight_curr_id, _cohead.cohead_curr_id,
                        shiphead_freight, CURRENT_DATE)), shiphead_shipvia
         INTO _freight, _shipVia
  FROM (
  SELECT shiphead_id, shiphead_freight_curr_id, shiphead_freight, shiphead_shipvia
  FROM shiphead JOIN shipitem ON (shipitem_shiphead_id=shiphead_id AND NOT shipitem_invoiced)
  WHERE ((shiphead_order_type='SO')
    AND  (shiphead_order_id=pSoheadid))
  GROUP BY shiphead_id, shiphead_freight_curr_id, shiphead_freight, shiphead_shipvia) AS data
  GROUP BY shiphead_shipvia;

  --  Nope, use the cohead freight charge
  IF (_freight IS NULL) THEN
    _freight	   := _cohead.cohead_freight;
  END IF;

  --  Finally, look for a Shipping-Entered Ship Via
  SELECT shiphead_shipvia INTO _shipVia
  FROM shiphead, shipitem
  WHERE ( (shipitem_shiphead_id=shiphead_id)
   AND (NOT shipitem_invoiced)
   AND (shiphead_order_type='SO')
   AND (shiphead_order_id=pSoheadid) )
  LIMIT 1;
  IF (NOT FOUND) THEN
    _shipVia := _cohead.cohead_shipvia;
  END IF;

  --Determine any tax

  SELECT 
  getFreightTaxTypeId() INTO _freighttypeid;
  SELECT SUM(COALESCE(taxdetail_tax, 0.00)) INTO _tax
  FROM calculatetaxdetail(_cohead.cohead_taxzone_id, _freighttypeid, _cohead.cohead_orderdate,_cohead.cohead_curr_id, _freight);

  --  Determine if we are using the _shipDate or _schedDate or current_date for the _invcDate
  IF( fetchMetricText('InvoiceDateSource')='scheddate') THEN
    _invcDate := _schedDate;
  ELSIF( fetchMetricText('InvoiceDateSource')='shipdate') THEN
    _invcDate := _shipDate;
  ELSE
    _invcDate := current_date;
  END IF;

   INSERT INTO cobmisc (
	cobmisc_id, cobmisc_cohead_id, cobmisc_shipvia, cobmisc_freight, cobmisc_misc, cobmisc_payment 
	,cobmisc_notes,cobmisc_shipdate ,cobmisc_invcdate,cobmisc_posted ,cobmisc_misc_accnt_id 
	,cobmisc_misc_descrip,cobmisc_closeorder,cobmisc_curr_id
	,cobmisc_taxtype_id,cobmisc_taxzone_id
	)
	SELECT
	_cobmiscid,_cohead.cohead_id,_shipVia,_freight,
        CASE WHEN (_cohead.cohead_misc - _miscApplied = 0.0) THEN 0.0
             ELSE (_cohead.cohead_misc - _miscApplied) END,0,
        _cohead.cohead_ordercomments,_shipDate,_invcDate,FALSE,_cohead.cohead_misc_accnt_id,
        _cohead.cohead_misc_descrip,NOT(cust_backorder),_cohead.cohead_curr_id,
	_cohead.cohead_taxtype_id,_cohead.cohead_taxzone_id
	FROM custinfo
	WHERE (cust_id=_cohead.cohead_cust_id);

  RETURN _cobmiscid;

END;
$_$;


ALTER FUNCTION public.createbillingheader(integer) OWNER TO admin;

--
-- Name: createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
  pBomitemid ALIAS FOR $1;
  pParentItemid ALIAS FOR $2;
  pComponentItemid ALIAS FOR $3;
  pSeqNumber ALIAS FOR $4;
  pIssueMethod ALIAS FOR $5;
  pUomId ALIAS FOR $6;
  pQtyPer ALIAS FOR $7;
  pScrap ALIAS FOR $8;
  pEffective ALIAS FOR $9;
  pExpires ALIAS FOR $10;
  pCreateWo ALIAS FOR $11;
  pBOOItemseqid ALIAS FOR $12;
  pSchedAtWooper ALIAS FOR $13;
  pECN ALIAS FOR $14;
  pSubType ALIAS FOR $15;
  pRevisionid ALIAS FOR $16;
  pCharId ALIAS FOR $17;
  pCharVal ALIAS FOR $18;
  _bomworksetid INTEGER;
  _temp INTEGER;
  _bomitemid INTEGER;

BEGIN

  SELECT createBOMItem( pBomitemid, pParentItemid, pComponentItemid,
                        pSeqNumber, pIssueMethod,
                        pUomId, pQtyPer, pScrap,
                        pEffective, pExpires,
                        pCreateWo, pBOOItemseqid, pSchedAtWooper, pECN, pSubType, pRevisionid, pCharId, pCharVal, NULL, NULL ) INTO _bomitemid;

  RETURN _bomitemid;
  
END;
$_$;


ALTER FUNCTION public.createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text) OWNER TO admin;

--
-- Name: createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
  pBomitemid ALIAS FOR $1;
  pParentItemid ALIAS FOR $2;
  pComponentItemid ALIAS FOR $3;
  pSeqNumber ALIAS FOR $4;
  pIssueMethod ALIAS FOR $5;
  pUomId ALIAS FOR $6;
  pQtyPer ALIAS FOR $7;
  pScrap ALIAS FOR $8;
  pEffective ALIAS FOR $9;
  pExpires ALIAS FOR $10;
  pCreateWo ALIAS FOR $11;
  pBOOItemseqid ALIAS FOR $12;
  pSchedAtWooper ALIAS FOR $13;
  pECN ALIAS FOR $14;
  pSubType ALIAS FOR $15;
  pRevisionid ALIAS FOR $16;
  pCharId ALIAS FOR $17;
  pCharVal ALIAS FOR $18;
  pNotes ALIAS FOR $19;
  pRef ALIAS FOR $20;
  _bomworksetid INTEGER;
  _temp INTEGER;

BEGIN

--  Make sure that the parent and component are not the same
  IF (pParentItemid = pComponentItemid) THEN
    RETURN -1;
  END IF;

--  Make sure that the parent is not used in the component at some level
  IF ( SELECT (item_type IN ('M', 'F'))
       FROM item
       WHERE (item_id=pComponentItemid) ) THEN
    SELECT indentedWhereUsed(pParentItemid) INTO _bomworksetid;
    SELECT bomwork_id INTO _temp
    FROM bomwork
    WHERE ( (bomwork_set_id=_bomworksetid)
     AND (bomwork_item_id=pComponentItemid) )
    LIMIT 1;
    IF (FOUND) THEN
      PERFORM deleteBOMWorkset(_bomworksetid);
      RETURN -2;
    END IF;
  END IF;

  PERFORM deleteBOMWorkset(_bomworksetid);

--  Create the BOM Item
  INSERT INTO bomitem
  ( bomitem_id, bomitem_parent_item_id, bomitem_item_id,
    bomitem_seqnumber, bomitem_issuemethod,
    bomitem_uom_id, bomitem_qtyper, bomitem_scrap,
    bomitem_effective, bomitem_expires,
    bomitem_createwo,
    bomitem_booitem_seq_id, bomitem_schedatwooper,
    bomitem_ecn, bomitem_subtype, bomitem_moddate, bomitem_rev_id,
    bomitem_char_id, bomitem_value, bomitem_notes, bomitem_ref )
  VALUES
  ( pBomitemid, pParentItemid, pComponentItemid,
    pSeqNumber, pIssueMethod,
    pUomId, pQtyPer, pScrap,
    pEffective, pExpires,
    pCreateWo,
    pBOOItemseqid, COALESCE(pSchedAtWooper, FALSE),
    pECN, pSubType, CURRENT_DATE, pRevisionid,
    pCharId,pCharVal,pNotes, pRef );

  RETURN pBomitemid;

END;
$_$;


ALTER FUNCTION public.createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text) OWNER TO admin;

--
-- Name: createbomitem(integer, integer, integer, character, integer, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createbomitem(integer, integer, integer, character, integer, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
  pBomitemid ALIAS FOR $1;
  pParentItemid ALIAS FOR $2;
  pComponentItemid ALIAS FOR $3;
  pIssueMethod ALIAS FOR $4;
  pUomId ALIAS FOR $5;
  pQtyPer ALIAS FOR $6;
  pScrap ALIAS FOR $7;
  pEffective ALIAS FOR $8;
  pExpires ALIAS FOR $9;
  pCreateWo ALIAS FOR $10;
  pBOOItemseqid ALIAS FOR $11;
  pSchedAtWooper ALIAS FOR $12;
  pECN ALIAS FOR $13;
  pSubType ALIAS FOR $14;
  pRevisionid ALIAS FOR $15;
  pCharId ALIAS FOR $16;
  pCharVal ALIAS FOR $17;
  pNotes ALIAS FOR $18;
  pRef ALIAS FOR $19;
  _seqNumber INTEGER;
  _bomitemid INTEGER;

BEGIN

--  Grab the next Sequence Number, if any
  SELECT MAX(bomitem_seqnumber) INTO _seqNumber
  FROM bomitem(pParentItemid,pRevisionid);

  IF (_seqNumber IS NOT NULL) THEN
   _seqNumber := (_seqNumber + 10);
  ELSE
   _seqNumber := 10;
  END IF;

  SELECT createBOMItem( pBomitemid, pParentItemid, pComponentItemid,
                        _seqNumber, pIssueMethod,
                        pUomId, pQtyPer, pScrap,
                        pEffective, pExpires,
                        pCreateWo, pBOOItemseqid, pSchedAtWooper, pECN, pSubType, pRevisionid, pCharId, pCharVal, pNotes, pRef ) INTO _bomitemid;

  RETURN _bomitemid;

END;
$_$;


ALTER FUNCTION public.createbomitem(integer, integer, integer, character, integer, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text) OWNER TO admin;

--
-- Name: createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pBomitemid ALIAS FOR $1;
  pParentItemid ALIAS FOR $2;
  pComponentItemid ALIAS FOR $3;
  pSeqNumber ALIAS FOR $4;
  pIssueMethod ALIAS FOR $5;
  pUomId ALIAS FOR $6;
  pQtyFxd ALIAS FOR $7;
  pQtyPer ALIAS FOR $8;
  pScrap ALIAS FOR $9;
  pEffective ALIAS FOR $10;
  pExpires ALIAS FOR $11;
  pCreateWo ALIAS FOR $12;
  pBOOItemseqid ALIAS FOR $13;
  pSchedAtWooper ALIAS FOR $14;
  pECN ALIAS FOR $15;
  pSubType ALIAS FOR $16;
  pRevisionid ALIAS FOR $17;
  pCharId ALIAS FOR $18;
  pCharVal ALIAS FOR $19;
  pNotes ALIAS FOR $20;
  pRef ALIAS FOR $21;
  _bomworksetid INTEGER;
  _temp INTEGER;

BEGIN

--  Make sure that the parent and component are not the same
  IF (pParentItemid = pComponentItemid) THEN
    RETURN -1;
  END IF;

--  Make sure that the parent is not used in the component at some level
  IF ( SELECT (item_type IN ('M', 'F'))
       FROM item
       WHERE (item_id=pComponentItemid) ) THEN
    SELECT indentedWhereUsed(pParentItemid) INTO _bomworksetid;
    SELECT bomwork_id INTO _temp
    FROM bomwork
    WHERE ( (bomwork_set_id=_bomworksetid)
     AND (bomwork_item_id=pComponentItemid) )
    LIMIT 1;
    IF (FOUND) THEN
      PERFORM deleteBOMWorkset(_bomworksetid);
      RETURN -2;
    END IF;
  END IF;

  PERFORM deleteBOMWorkset(_bomworksetid);

--  Create the BOM Item
  INSERT INTO bomitem
  ( bomitem_id, bomitem_parent_item_id, bomitem_item_id,
    bomitem_seqnumber, bomitem_issuemethod,
    bomitem_uom_id, bomitem_qtyfxd, bomitem_qtyper, bomitem_scrap,
    bomitem_effective, bomitem_expires,
    bomitem_createwo,
    bomitem_booitem_seq_id, bomitem_schedatwooper,
    bomitem_ecn, bomitem_subtype, bomitem_moddate, bomitem_rev_id,
    bomitem_char_id, bomitem_value, bomitem_notes, bomitem_ref )
  VALUES
  ( pBomitemid, pParentItemid, pComponentItemid,
    pSeqNumber, pIssueMethod,
    pUomId, pQtyFxd, pQtyPer, pScrap,
    pEffective, pExpires,
    pCreateWo,
    pBOOItemseqid, COALESCE(pSchedAtWooper, FALSE),
    pECN, pSubType, CURRENT_DATE, pRevisionid,
    pCharId,pCharVal,pNotes, pRef );

  RETURN pBomitemid;

END;
$_$;


ALTER FUNCTION public.createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text) OWNER TO admin;

--
-- Name: createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pBomitemid ALIAS FOR $1;
  pParentItemid ALIAS FOR $2;
  pComponentItemid ALIAS FOR $3;
  pSeqNumber ALIAS FOR $4;
  pIssueMethod ALIAS FOR $5;
  pUomId ALIAS FOR $6;
  pQtyFxd ALIAS FOR $7;
  pQtyPer ALIAS FOR $8;
  pScrap ALIAS FOR $9;
  pEffective ALIAS FOR $10;
  pExpires ALIAS FOR $11;
  pCreateWo ALIAS FOR $12;
  pBOOItemseqid ALIAS FOR $13;
  pSchedAtWooper ALIAS FOR $14;
  pECN ALIAS FOR $15;
  pSubType ALIAS FOR $16;
  pRevisionid ALIAS FOR $17;
  pCharId ALIAS FOR $18;
  pCharVal ALIAS FOR $19;
  _bomworksetid INTEGER;
  _temp INTEGER;
  _bomitemid INTEGER;

BEGIN

  SELECT createBOMItem( pBomitemid, pParentItemid, pComponentItemid,
                        pSeqNumber, pIssueMethod,
                        pUomId, pQtyFxd, pQtyPer, pScrap,
                        pEffective, pExpires,
                        pCreateWo, pBOOItemseqid, pSchedAtWooper, pECN, pSubType, pRevisionid, pCharId, pCharVal, NULL, NULL ) INTO _bomitemid;

  RETURN _bomitemid;
  
END;
$_$;


ALTER FUNCTION public.createbomitem(integer, integer, integer, integer, character, integer, numeric, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text) OWNER TO admin;

--
-- Name: createbomitem(integer, integer, integer, character, integer, numeric, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createbomitem(integer, integer, integer, character, integer, numeric, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pBomitemid ALIAS FOR $1;
  pParentItemid ALIAS FOR $2;
  pComponentItemid ALIAS FOR $3;
  pIssueMethod ALIAS FOR $4;
  pUomId ALIAS FOR $5;
  pQtyFxd ALIAS FOR $6;
  pQtyPer ALIAS FOR $7;
  pScrap ALIAS FOR $8;
  pEffective ALIAS FOR $9;
  pExpires ALIAS FOR $10;
  pCreateWo ALIAS FOR $11;
  pBOOItemseqid ALIAS FOR $12;
  pSchedAtWooper ALIAS FOR $13;
  pECN ALIAS FOR $14;
  pSubType ALIAS FOR $15;
  pRevisionid ALIAS FOR $16;
  pCharId ALIAS FOR $17;
  pCharVal ALIAS FOR $18;
  pNotes ALIAS FOR $19;
  pRef ALIAS FOR $20;
  _seqNumber INTEGER;
  _bomitemid INTEGER;

BEGIN

--  Grab the next Sequence Number, if any
  SELECT MAX(bomitem_seqnumber) INTO _seqNumber
  FROM bomitem(pParentItemid,pRevisionid);

  IF (_seqNumber IS NOT NULL) THEN
   _seqNumber := (_seqNumber + 10);
  ELSE
   _seqNumber := 10;
  END IF;

  SELECT createBOMItem( pBomitemid, pParentItemid, pComponentItemid,
                        _seqNumber, pIssueMethod,
                        pUomId, pQtyFxd, pQtyPer, pScrap,
                        pEffective, pExpires,
                        pCreateWo, pBOOItemseqid, pSchedAtWooper, pECN, pSubType, pRevisionid, pCharId, pCharVal, pNotes, pRef ) INTO _bomitemid;

  RETURN _bomitemid;

END;
$_$;


ALTER FUNCTION public.createbomitem(integer, integer, integer, character, integer, numeric, numeric, numeric, date, date, boolean, integer, boolean, text, character, integer, integer, text, text, text) OWNER TO admin;

--
-- Name: createcheck(integer, text, integer, date, numeric, integer, integer, integer, text, text, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcheck(integer, text, integer, date, numeric, integer, integer, integer, text, text, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pBankaccntid		ALIAS FOR  $1;
  pRecipType		ALIAS FOR  $2;
  pRecipId		ALIAS FOR  $3;
  pCheckDate		ALIAS FOR  $4;
  pAmount		ALIAS FOR  $5;
  pCurrid		ALIAS FOR  $6;
  pExpcatid		ALIAS FOR  $7;
  _journalNumber	INTEGER := $8;
  pFor			ALIAS FOR  $9;
  pNotes		ALIAS FOR $10;
  pMisc			ALIAS FOR $11;
  _checkid INTEGER;
BEGIN

  SELECT createCheck(pBankaccntid,pRecipType,pRecipId,pCheckDate,pAmount,pCurrid,pExpcatid,_journalNumber,pFor,pNotes,pMisc,NULL) INTO _checkid;
  RETURN _checkid;

END;
$_$;


ALTER FUNCTION public.createcheck(integer, text, integer, date, numeric, integer, integer, integer, text, text, boolean) OWNER TO admin;

--
-- Name: createcheck(integer, text, integer, date, numeric, integer, integer, integer, text, text, boolean, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcheck(integer, text, integer, date, numeric, integer, integer, integer, text, text, boolean, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pBankaccntid		ALIAS FOR  $1;
  pRecipType		ALIAS FOR  $2;
  pRecipId		ALIAS FOR  $3;
  pCheckDate		ALIAS FOR  $4;
  pAmount		ALIAS FOR  $5;
  pCurrid		ALIAS FOR  $6;
  pExpcatid		ALIAS FOR  $7;
  _journalNumber	INTEGER := $8;
  pFor			ALIAS FOR  $9;
  pNotes		ALIAS FOR $10;
  pMisc			ALIAS FOR $11;
  pAropenid             ALIAS FOR $12;
  _checkid		INTEGER;
  _check_curr_rate      NUMERIC;
  _bankaccnt_currid	INTEGER;

BEGIN
  SELECT bankaccnt_curr_id,currRate(bankaccnt_curr_id,pCheckDate) INTO _bankaccnt_currid, _check_curr_rate
  FROM bankaccnt
  WHERE bankaccnt_id = pBankaccntid;
  IF (NOT FOUND) THEN
    RETURN -1;
  END IF;

  IF (pRecipType NOT IN ('C', 'T', 'V')) THEN
    RETURN -2;
  END IF;

  IF (pCheckDate IS NULL) THEN
    RETURN -3;
  END IF;

  IF (pAmount <= 0) THEN
    RETURN -4;
  END IF;

  IF (pCurrid IS NULL
      OR NOT EXISTS(SELECT * FROM curr_symbol WHERE (curr_id=pCurrid))) THEN
    RETURN -5;
  END IF;

  IF (pExpcatid IS NOT NULL
      AND NOT EXISTS(SELECT * FROM expcat WHERE (expcat_id=pExpcatid))) THEN
    RETURN -6;
  END IF;

-- Do not assign Journal Number until check is posted
--  if (_journalNumber IS NULL) THEN
--    _journalNumber := fetchJournalNumber('AP-CK');
--  END IF;

  _checkid := NEXTVAL('checkhead_checkhead_id_seq');

  INSERT INTO checkhead
  ( checkhead_id,		checkhead_recip_type,	checkhead_recip_id,
    checkhead_bankaccnt_id,	checkhead_number,
    checkhead_amount,
    checkhead_checkdate,	checkhead_misc,		checkhead_expcat_id,
    checkhead_journalnumber,	checkhead_for,		checkhead_notes,
    checkhead_curr_id )
  VALUES
  ( _checkid,			pRecipType,		pRecipId,
    pBankaccntid,		-1, --fetchNextCheckNumber(pBankaccntid),
    currToCurr(pCurrid, _bankaccnt_currid, pAmount, pCheckDate),
    pCheckDate,			COALESCE(pMisc, FALSE),	pExpcatid,
    _journalNumber,		pFor,			pNotes,
    _bankaccnt_currid );

  IF (pAropenid IS NOT NULL AND fetchmetricbool('EnableReturnAuth')) THEN
    INSERT INTO checkitem (checkitem_checkhead_id,checkitem_amount,checkitem_discount,checkitem_ponumber,
                           checkitem_aropen_id,checkitem_docdate,checkitem_curr_id,checkitem_cmnumber,
                           checkitem_ranumber, checkitem_curr_rate)
    SELECT _checkid, currToCurr(checkhead_curr_id, aropen_curr_id, pAmount, checkhead_checkdate),
      0,cmhead_custponumber,pAropenid,aropen_docdate,aropen_curr_id,cmhead_number,rahead_number,
      1 / (_check_curr_rate / aropen_curr_rate)
    FROM checkhead, aropen
      LEFT OUTER JOIN cmhead ON (aropen_docnumber=cmhead_number)
      LEFT OUTER JOIN rahead ON (cmhead_rahead_id=rahead_id)
    WHERE ((aropen_id=pAropenid)
     AND (checkhead_id=_checkid));
  ELSIF (pAropenid IS NOT NULL) THEN
    INSERT INTO checkitem (checkitem_checkhead_id,checkitem_amount,checkitem_discount,checkitem_ponumber,
                           checkitem_aropen_id,checkitem_docdate,checkitem_curr_id,checkitem_cmnumber,
                           checkitem_ranumber, checkitem_curr_rate)
    SELECT _checkid,currToCurr(checkhead_curr_id, aropen_curr_id, pAmount, checkhead_checkdate),
      0,cmhead_custponumber,pAropenid,aropen_docdate,aropen_curr_id,cmhead_number,NULL,
      1 / (_check_curr_rate / aropen_curr_rate)
    FROM checkhead, aropen
      LEFT OUTER JOIN cmhead ON (aropen_docnumber=cmhead_number)
    WHERE ((aropen_id=pAropenid)
     AND (checkhead_id=_checkid));
  END IF;
  

  RETURN _checkid;

END;
$_$;


ALTER FUNCTION public.createcheck(integer, text, integer, date, numeric, integer, integer, integer, text, text, boolean, integer) OWNER TO admin;

--
-- Name: createchecks(integer, date); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createchecks(integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pBankaccntid ALIAS FOR $1;
  pCheckDate ALIAS FOR $2;
  _v RECORD;
  _r RECORD;
  _c RECORD;
  _checkid		INTEGER;
  _counter		INTEGER := 0;
  _check_curr_id	INTEGER;
  _check_curr_rate      NUMERIC;

BEGIN

  SELECT bankaccnt_curr_id, currRate(bankaccnt_curr_id, pCheckDate) 
    INTO _check_curr_id, _check_curr_rate
    FROM bankaccnt
    WHERE ( bankaccnt_id = pBankaccntid );
  FOR _v IN SELECT DISTINCT vend_id, vend_number, vend_name
              FROM apselect
              JOIN apopen   ON (apselect_apopen_id=apopen_id)
              JOIN vendinfo ON (apopen_vend_id=vend_id)
            WHERE ((apselect_bankaccnt_id=pBankaccntid)
               AND (apselect_date <= pCheckDate)) LOOP

    -- if we owe this vendor anything (we might not) then create a check
    IF ((SELECT 
                SUM(apselect_amount * _check_curr_rate / apopen_curr_rate)          
	 FROM apselect, apopen
	 WHERE ((apselect_apopen_id=apopen_id)
	   AND  (apopen_vend_id=_v.vend_id)
	   AND  (apselect_bankaccnt_id=pBankaccntid)) ) > 0) THEN
      -- 0.01 is a temporary amount; we''ll update the check amount later
      _checkid := createCheck(pBankaccntid,	'V',	_v.vend_id,
			      pCheckDate,		0.01,	_check_curr_id,
			      NULL,		NULL, '',	'',	FALSE);

      FOR _r IN SELECT apopen_id, apselect_id,
		       apopen_docnumber, apopen_invcnumber, apopen_ponumber,
		       apopen_docdate, apselect_curr_id,
		       apselect_amount, apselect_discount
		FROM apselect, apopen
		WHERE ( (apselect_apopen_id=apopen_id)
		 AND (apopen_vend_id=_v.vend_id)
		 AND (apselect_bankaccnt_id=pBankaccntid) ) LOOP
	INSERT INTO checkitem
	( checkitem_checkhead_id, checkitem_apopen_id,
	  checkitem_vouchernumber, checkitem_invcnumber, checkitem_ponumber,
	  checkitem_amount, checkitem_discount, checkitem_docdate,
          checkitem_curr_id, checkitem_curr_rate )
	VALUES
	( _checkid, _r.apopen_id,
	  _r.apopen_docnumber, _r.apopen_invcnumber, _r.apopen_ponumber,
	  _r.apselect_amount, _r.apselect_discount, _r.apopen_docdate,
	  _r.apselect_curr_id, 
          1 / (_check_curr_rate / currRate(_r.apselect_curr_id, pCheckdate))  );

	DELETE FROM apselect
	WHERE (apselect_id=_r.apselect_id);

      END LOOP;

      -- one check can pay for purchases on multiple dates in multiple currencies
      UPDATE checkhead
      SET checkhead_amount = (SELECT SUM(checkitem_amount / checkitem_curr_rate)
			      FROM checkitem
			      WHERE (checkitem_checkhead_id=checkhead_id))
      WHERE (checkhead_id=_checkid);

      _counter := (_counter + 1);
    END IF;

  END LOOP;

  RETURN _counter;

END;
$_$;


ALTER FUNCTION public.createchecks(integer, date) OWNER TO admin;

--
-- Name: createcounttag(integer, text, boolean, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcounttag(integer, text, boolean, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid ALIAS FOR $1;
  pComments ALIAS FOR $2;
  pPriority ALIAS FOR $3;
  pFreeze ALIAS FOR $4;
BEGIN
  RETURN createCountTag(pItemsiteid, pComments, pPriority, pFreeze, NULL);
END;
$_$;


ALTER FUNCTION public.createcounttag(integer, text, boolean, boolean) OWNER TO admin;

--
-- Name: createcounttag(integer, text, boolean, boolean, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcounttag(integer, text, boolean, boolean, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$

-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pItemsiteid ALIAS FOR $1;
  pComments ALIAS FOR $2;
  pPriority ALIAS FOR $3;
  pFreeze ALIAS FOR $4;
  pLocationid ALIAS FOR $5;
  _invcntid INTEGER;
  _whs		RECORD;
  _type CHARACTER;
  _controlmethod        CHARACTER;

BEGIN

  SELECT item_type, itemsite_controlmethod INTO _type, _controlmethod
    FROM itemsite, item
   WHERE ((itemsite_item_id=item_id)
     AND  (itemsite_id=pItemsiteid));

  IF (NOT FOUND OR _type IN ('F', 'R', 'L','J') OR _controlmethod = 'N') THEN
    RETURN 0; -- We simply do not do these item types.
  END IF;

  -- Test for existing tags
   IF (pLocationid IS NULL) THEN
       SELECT invcnt_id INTO _invcntid
       FROM invcnt
       WHERE ((NOT invcnt_posted)
       AND (invcnt_location_id IS NULL)
       AND (invcnt_itemsite_id=pItemsiteid));
  
  ELSE

    SELECT invcnt_id INTO _invcntid
     FROM invcnt
     WHERE ((NOT invcnt_posted)
     AND (invcnt_itemsite_id=pItemsiteid)
     AND (invcnt_location_id=pLocationid));
  END IF;

  IF (NOT FOUND) THEN
    SELECT NEXTVAL('invcnt_invcnt_id_seq') INTO _invcntid;

    SELECT whsinfo.* INTO _whs
      FROM whsinfo, itemsite
     WHERE ((warehous_id=itemsite_warehous_id)
       AND  (itemsite_id=pItemsiteid));

    INSERT INTO invcnt (
      invcnt_id, invcnt_itemsite_id, invcnt_tagdate,
      invcnt_tagnumber,
      invcnt_tag_username, invcnt_posted,
      invcnt_priority, invcnt_comments, invcnt_location_id
    ) VALUES (
      _invcntid, pItemsiteid, CURRENT_TIMESTAMP,
      (_whs.warehous_counttag_prefix || _whs.warehous_counttag_number::TEXT),
      getEffectiveXtUser(), FALSE,
      pPriority, pComments, pLocationid
    );

    UPDATE whsinfo
    SET warehous_counttag_number=(warehous_counttag_number + 1)
    WHERE (warehous_id=_whs.warehous_id);

    IF (pFreeze) THEN
      UPDATE itemsite
      SET itemsite_freeze=TRUE
      WHERE (itemsite_id=pItemsiteid);
    END IF;

  END IF;

  RETURN _invcntid;
END;
$_$;


ALTER FUNCTION public.createcounttag(integer, text, boolean, boolean, integer) OWNER TO admin;

--
-- Name: createcustomer(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcustomer(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
  DECLARE
    pcrmacctId  ALIAS FOR $1;
    _custId     INTEGER := 0;
  BEGIN
    IF (pcrmacctId < 0 OR pcrmacctId IS NULL) THEN
      RETURN -1;
    END IF;

    SELECT crmacct_cust_id INTO _custId
    FROM crmacct WHERE crmacct_id = pcrmacctId;

    IF (_custId IS NOT NULL AND _custId <= 0) THEN
      RETURN -2;
    END IF;

    INSERT INTO _customer (active, customer_number, customer_name)
      SELECT crmacct_active, crmacct_number, crmacct_name
      FROM crmacct
      WHERE crmacct_id = pcrmacctId;
    _custId := CURRVAL('cust_cust_id_seq');

    UPDATE crmacct SET crmacct_prospect_id = NULL, crmacct_cust_id = _custId
    WHERE crmacct_id = pcrmacctId;

    RETURN _custId;
  END;
$_$;


ALTER FUNCTION public.createcustomer(integer) OWNER TO admin;

--
-- Name: createcyclecountsbywarehouse(integer, integer, text, boolean, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcyclecountsbywarehouse(integer, integer, text, boolean, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWarehousid ALIAS FOR $1;
  pMaxNumber ALIAS FOR $2;
  pComments ALIAS FOR $3;
  pPriority ALIAS FOR $4;
  pFreeze ALIAS FOR $5;

BEGIN
  RETURN createCycleCountsByWarehouse(pWarehousid, pMaxNumber, pComments, pPriority, pFreeze, NULL, FALSE);
END;
$_$;


ALTER FUNCTION public.createcyclecountsbywarehouse(integer, integer, text, boolean, boolean) OWNER TO admin;

--
-- Name: createcyclecountsbywarehouse(integer, integer, integer, text, boolean, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcyclecountsbywarehouse(integer, integer, integer, text, boolean, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWarehousid ALIAS FOR $1;
  pClasscodeid ALIAS FOR $2;
  pMaxNumber ALIAS FOR $3;
  pComments ALIAS FOR $4;
  pPriority ALIAS FOR $5;
  pFreeze ALIAS FOR $6;
BEGIN
  RETURN createCycleCountsByWarehouseByClassCode(pWarehousid, pClasscodeid, pMaxNumber, pComments, pPriority, pFreeze, NULL, FALSE);
END;
$_$;


ALTER FUNCTION public.createcyclecountsbywarehouse(integer, integer, integer, text, boolean, boolean) OWNER TO admin;

--
-- Name: createcyclecountsbywarehouse(integer, text, integer, text, boolean, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcyclecountsbywarehouse(integer, text, integer, text, boolean, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWarehousid ALIAS FOR $1;
  pClasscodePattern ALIAS FOR $2;
  pMaxNumber ALIAS FOR $3;
  pComments ALIAS FOR $4;
  pPriority ALIAS FOR $5;
  pFreeze ALIAS FOR $6;
BEGIN
  RETURN createCycleCountsByWarehouseByClassCode(pWarehousid, pClasscodePattern, pMaxNumber, pComments, pPriority, pFreeze, NULL, FALSE);
END;
$_$;


ALTER FUNCTION public.createcyclecountsbywarehouse(integer, text, integer, text, boolean, boolean) OWNER TO admin;

--
-- Name: createcyclecountsbywarehouse(integer, integer, text, boolean, boolean, integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcyclecountsbywarehouse(integer, integer, text, boolean, boolean, integer, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWarehousid ALIAS FOR $1;
  pMaxNumber ALIAS FOR $2;
  pComments ALIAS FOR $3;
  pPriority ALIAS FOR $4;
  pFreeze ALIAS FOR $5;
  pLocationid ALIAS FOR $6;
  pIgnoreZeroBalance ALIAS FOR $7;
  _itemsites RECORD;
  _returnVal	INTEGER;
  
BEGIN

IF (pLocationid IS NULL) THEN
  FOR _itemsites IN SELECT itemsite_id, itemsite_warehous_id, itemsite_qtyonhand
                    FROM itemsite, item
                    WHERE ( (itemsite_active)
                     AND (itemsite_item_id=item_id)
                     AND (itemsite_cyclecountfreq > 0)
                     AND ((COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq) < CURRENT_DATE)
                     AND (itemsite_id NOT IN ( SELECT invcnt_itemsite_id
                                               FROM invcnt, itemsite
                                               WHERE ( (invcnt_itemsite_id=itemsite_id)
                                                AND (itemsite_warehous_id=pWarehousid)
						AND (invcnt_location_id IS NULL)
                                                AND (NOT invcnt_posted) ) ) )
                     AND ((NOT pIgnoreZeroBalance) OR (itemsite_qtyonhand <> 0))
                     AND ((pLocationid IS NULL) OR (validLocation(pLocationid, itemsite_id)))
                     AND (itemsite_warehous_id=pWarehousid) )
                    ORDER BY (COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq), itemsite_abcclass, item_number

LIMIT pMaxNumber LOOP
    _returnVal := createCountTag(_itemsites.itemsite_id, pComments,
				    pPriority, pFreeze, pLocationid);
    IF (_returnVal < 0) THEN
      RETURN _returnVal;
    END IF;
  END LOOP;            

ELSE
  FOR _itemsites IN SELECT itemsite_id, itemsite_warehous_id, SUM(itemloc_qty)
                    FROM itemsite, itemloc
                    WHERE ( (itemsite_active)
                     AND (itemsite_cyclecountfreq > 0)
                     AND ((COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq) < CURRENT_DATE)
                     AND ((NOT pIgnoreZeroBalance) OR (itemsite_qtyonhand <> 0))
                     AND (pLocationid = itemloc_location_id)
                     AND (itemloc_itemsite_id = itemsite_id)
                     AND (itemsite_warehous_id=pWarehousid) )
		    GROUP BY itemsite_id, itemsite_warehous_id,
			     itemsite_datelastcount, itemsite_cyclecountfreq,
			     itemsite_abcclass
                    ORDER BY (COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq), itemsite_abcclass

LIMIT pMaxNumber LOOP
    _returnVal := createCountTag(_itemsites.itemsite_id, pComments,
				    pPriority, pFreeze, pLocationid);
    IF (_returnVal < 0) THEN
      RETURN _returnVal;
    END IF;
  END LOOP;  
                   
END IF;

  RETURN 0;
END;
$_$;


ALTER FUNCTION public.createcyclecountsbywarehouse(integer, integer, text, boolean, boolean, integer, boolean) OWNER TO admin;

--
-- Name: createcyclecountsbywarehousebyclasscode(integer, integer, integer, text, boolean, boolean, integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcyclecountsbywarehousebyclasscode(integer, integer, integer, text, boolean, boolean, integer, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWarehousid ALIAS FOR $1;
  pClasscodeid ALIAS FOR $2;
  pMaxNumber ALIAS FOR $3;
  pComments ALIAS FOR $4;
  pPriority ALIAS FOR $5;
  pFreeze ALIAS FOR $6;
  pLocationid ALIAS FOR $7;
  pIgnoreZeroBalance ALIAS FOR $8;
  _itemsites RECORD;
  _returnVal	INTEGER;
  
BEGIN

IF (pLocationid IS NULL) THEN
  FOR _itemsites IN SELECT itemsite_id, itemsite_warehous_id, itemsite_qtyonhand
                    FROM itemsite, item
                    WHERE ( (itemsite_active)
                     AND (itemsite_item_id=item_id)
                     AND (itemsite_cyclecountfreq > 0)
                     AND ((COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq) < CURRENT_DATE)
                     AND (itemsite_id NOT IN ( SELECT invcnt_itemsite_id
                                               FROM invcnt, itemsite
                                               WHERE ( (invcnt_itemsite_id=itemsite_id)
                                                AND (itemsite_warehous_id=pWarehousid)
						AND (invcnt_location_id IS NULL)
                                                AND (NOT invcnt_posted) ) ) )
                     AND ((NOT pIgnoreZeroBalance) OR (itemsite_qtyonhand <> 0))
                     AND ((pLocationid IS NULL) OR (validLocation(pLocationid, itemsite_id)))
                     AND (itemsite_warehous_id=pWarehousid)
                     AND (item_classcode_id=pClasscodeid) )
                    ORDER BY (COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq), itemsite_abcclass, item_number
                    LIMIT pMaxNumber LOOP
    _returnVal := createCountTag(_itemsites.itemsite_id, pComments,
				    pPriority, pFreeze, pLocationid);
    IF (_returnVal < 0) THEN
      RETURN _returnVal;
    END IF;
  END LOOP;

ELSE
  FOR _itemsites IN SELECT itemsite_id, itemsite_warehous_id, SUM(itemloc_qty)
                    FROM itemsite, item, itemloc
                    WHERE ( (itemsite_active)
                     AND (itemsite_item_id=item_id)
                     AND (itemsite_cyclecountfreq > 0)
                     AND ((COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq) < CURRENT_DATE)
                     AND ((NOT pIgnoreZeroBalance) OR (itemsite_qtyonhand <> 0))
                     AND (pLocationid = itemloc_location_id)
                     AND (itemloc_itemsite_id = itemsite_id)
                     AND (itemsite_warehous_id=pWarehousid) 
                     AND (item_classcode_id=pClasscodeid) )
		    GROUP BY itemsite_id, itemsite_warehous_id,
			     itemsite_datelastcount, itemsite_cyclecountfreq,
			     itemsite_abcclass
                    ORDER BY (COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq), itemsite_abcclass
                    LIMIT pMaxNumber LOOP
    _returnVal := createCountTag(_itemsites.itemsite_id, pComments,
				    pPriority, pFreeze, pLocationid);
    IF (_returnVal < 0) THEN
      RETURN _returnVal;
    END IF;
  END LOOP;

END IF;

  RETURN 0;
END;
$_$;


ALTER FUNCTION public.createcyclecountsbywarehousebyclasscode(integer, integer, integer, text, boolean, boolean, integer, boolean) OWNER TO admin;

--
-- Name: createcyclecountsbywarehousebyclasscode(integer, text, integer, text, boolean, boolean, integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcyclecountsbywarehousebyclasscode(integer, text, integer, text, boolean, boolean, integer, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWarehousid ALIAS FOR $1;
  pClasscodePattern ALIAS FOR $2;
  pMaxNumber ALIAS FOR $3;
  pComments ALIAS FOR $4;
  pPriority ALIAS FOR $5;
  pFreeze ALIAS FOR $6;
  pLocationid ALIAS FOR $7;
  pIgnoreZeroBalance ALIAS FOR $8;
  _itemsites RECORD;
  _returnVal	INTEGER;
  
BEGIN

IF (pLocationid IS NULL) THEN
  FOR _itemsites IN SELECT itemsite_id, itemsite_warehous_id, itemsite_qtyonhand
                    FROM itemsite, item, classcode
                    WHERE ( (itemsite_active)
                     AND (itemsite_item_id=item_id)
                     AND (item_classcode_id=classcode_id)
                     AND (itemsite_cyclecountfreq > 0)
                     AND ((COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq) < CURRENT_DATE)
                     AND (itemsite_id NOT IN ( SELECT invcnt_itemsite_id
                                               FROM invcnt, itemsite
                                               WHERE ( (invcnt_itemsite_id=itemsite_id)
                                                AND (itemsite_warehous_id=pWarehousid)
						AND (invcnt_location_id IS NULL)
                                                AND (NOT invcnt_posted) ) ) )
                     AND ((NOT pIgnoreZeroBalance) OR (itemsite_qtyonhand <> 0))
                     AND ((pLocationid IS NULL) OR (validLocation(pLocationid, itemsite_id)))
                     AND (itemsite_warehous_id=pWarehousid)
                     AND (classcode_code ~ pClasscodePattern) )
                    ORDER BY (COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq), itemsite_abcclass, item_number
                    LIMIT pMaxNumber LOOP
    _returnVal := createCountTag(_itemsites.itemsite_id, pComments,
				    pPriority, pFreeze, pLocationid);
    IF (_returnVal < 0) THEN
      RETURN _returnVal;
    END IF;
  END LOOP;

ELSE
  FOR _itemsites IN SELECT itemsite_id, itemsite_warehous_id, SUM(itemloc_qty)
                    FROM itemsite, item, classcode, itemloc
                    WHERE ( (itemsite_active)
                     AND (itemsite_item_id=item_id)
                     AND (item_classcode_id=classcode_id)
                     AND (itemsite_cyclecountfreq > 0)
                     AND ((COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq) < CURRENT_DATE)
                     AND ((NOT pIgnoreZeroBalance) OR (itemsite_qtyonhand <> 0))
                     AND (pLocationid = itemloc_location_id)
                     AND (itemloc_itemsite_id = itemsite_id)
                     AND (itemsite_warehous_id=pWarehousid)
                     AND (classcode_code ~ pClasscodePattern) )
		    GROUP BY itemsite_id, itemsite_warehous_id,
			     itemsite_datelastcount, itemsite_cyclecountfreq,
			     itemsite_abcclass
                    ORDER BY (COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq), itemsite_abcclass
                    LIMIT pMaxNumber LOOP
    _returnVal := createCountTag(_itemsites.itemsite_id, pComments,
				    pPriority, pFreeze, pLocationid);
    IF (_returnVal < 0) THEN
      RETURN _returnVal;
    END IF;
  END LOOP;

END IF;

  RETURN 0;
END;
$_$;


ALTER FUNCTION public.createcyclecountsbywarehousebyclasscode(integer, text, integer, text, boolean, boolean, integer, boolean) OWNER TO admin;

--
-- Name: createcyclecountsbywarehousebyplannercode(integer, text, integer, text, boolean, boolean, integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcyclecountsbywarehousebyplannercode(integer, text, integer, text, boolean, boolean, integer, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWarehousid ALIAS FOR $1;
  pPlancodePattern ALIAS FOR $2;
  pMaxNumber ALIAS FOR $3;
  pComments ALIAS FOR $4;
  pPriority ALIAS FOR $5;
  pFreeze ALIAS FOR $6;
  pLocationid ALIAS FOR $7;
  pIgnoreZeroBalance ALIAS FOR $8;
  _itemsites RECORD;
  _returnVal	INTEGER;
  
BEGIN

IF (pLocationid IS NULL) THEN
  FOR _itemsites IN SELECT itemsite_id, itemsite_warehous_id, itemsite_qtyonhand
                    FROM itemsite, item, plancode
                    WHERE ( (itemsite_active)
                     AND (itemsite_item_id=item_id)
                     AND (itemsite_plancode_id=plancode_id)
                     AND (itemsite_cyclecountfreq > 0)
                     AND ((COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq) < CURRENT_DATE)
                     AND (itemsite_id NOT IN ( SELECT invcnt_itemsite_id
                                               FROM invcnt, itemsite
                                               WHERE ( (invcnt_itemsite_id=itemsite_id)
                                                AND (itemsite_warehous_id=pWarehousid)
						AND (invcnt_location_id IS NULL)
                                                AND (NOT invcnt_posted) ) ) )
                     AND ((NOT pIgnoreZeroBalance) OR (itemsite_qtyonhand <> 0))
                     AND ((pLocationid IS NULL) OR (validLocation(pLocationid, itemsite_id)))
                     AND (itemsite_warehous_id=pWarehousid)
                     AND (plancode_code ~ pPlancodePattern) )
                    ORDER BY (COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq), itemsite_abcclass, item_number
                    LIMIT pMaxNumber LOOP
    _returnVal := createCountTag(_itemsites.itemsite_id, pComments,
				    pPriority, pFreeze, pLocationid);
    IF (_returnVal < 0) THEN
      RETURN _returnVal;
    END IF;
  END LOOP;

ELSE
  FOR _itemsites IN SELECT itemsite_id, itemsite_warehous_id, SUM(itemloc_qty)
                    FROM itemsite, plancode, itemloc
                    WHERE ( (itemsite_active)
                     AND (itemsite_plancode_id=plancode_id)
                     AND (itemsite_cyclecountfreq > 0)
                     AND ((COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq) < CURRENT_DATE)
                     AND ((NOT pIgnoreZeroBalance) OR (itemsite_qtyonhand <> 0))
                     AND (pLocationid = itemloc_location_id)
                     AND (itemloc_itemsite_id = itemsite_id)
                     AND (itemsite_warehous_id=pWarehousid)
                     AND (plancode_code ~ pPlancodePattern) )
		    GROUP BY itemsite_id, itemsite_warehous_id,
			     itemsite_datelastcount, itemsite_cyclecountfreq,
			     itemsite_abcclass
                    ORDER BY (COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq), itemsite_abcclass
                    LIMIT pMaxNumber LOOP
    _returnVal := createCountTag(_itemsites.itemsite_id, pComments,
				    pPriority, pFreeze, pLocationid);
    IF (_returnVal < 0) THEN
      RETURN _returnVal;
    END IF;
  END LOOP;

END IF;

  RETURN 0;
END;
$_$;


ALTER FUNCTION public.createcyclecountsbywarehousebyplannercode(integer, text, integer, text, boolean, boolean, integer, boolean) OWNER TO admin;

--
-- Name: createcyclecountsbywarehousebyplannercode(integer, integer, integer, text, boolean, boolean, integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createcyclecountsbywarehousebyplannercode(integer, integer, integer, text, boolean, boolean, integer, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pWarehousid ALIAS FOR $1;
  pPlancodeid ALIAS FOR $2;
  pMaxNumber ALIAS FOR $3;
  pComments ALIAS FOR $4;
  pPriority ALIAS FOR $5;
  pFreeze ALIAS FOR $6;
  pLocationid ALIAS FOR $7;
  pIgnoreZeroBalance ALIAS FOR $8;
  _itemsites RECORD;
  _returnVal	INTEGER;
  
BEGIN

IF (pLocationid IS NULL) THEN
  FOR _itemsites IN SELECT itemsite_id, itemsite_warehous_id, itemsite_qtyonhand
                    FROM itemsite, item
                    WHERE ( (itemsite_active)
                     AND (itemsite_item_id=item_id)
                     AND (itemsite_cyclecountfreq > 0)
                     AND ((COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq) < CURRENT_DATE)
                     AND (itemsite_id NOT IN ( SELECT invcnt_itemsite_id
                                               FROM invcnt, itemsite
                                               WHERE ( (invcnt_itemsite_id=itemsite_id)
                                                AND (itemsite_warehous_id=pWarehousid)
						AND (invcnt_location_id IS NULL)
                                                AND (NOT invcnt_posted) ) ) )
                     AND ((NOT pIgnoreZeroBalance) OR (itemsite_qtyonhand <> 0))
                     AND ((pLocationid IS NULL) OR (validLocation(pLocationid, itemsite_id)))
                     AND (itemsite_warehous_id=pWarehousid)
                     AND (itemsite_plancode_id=pPlancodeid) )
                    ORDER BY (COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq), itemsite_abcclass, item_number
                    LIMIT pMaxNumber LOOP
    _returnVal := createCountTag(_itemsites.itemsite_id, pComments,
				    pPriority, pFreeze, pLocationid);
    IF (_returnVal < 0) THEN
      RETURN _returnVal;
    END IF;
  END LOOP;

ELSE
  FOR _itemsites IN SELECT itemsite_id, itemsite_warehous_id, SUM(itemloc_qty)
                    FROM itemsite, itemloc
                    WHERE ( (itemsite_active)
                     AND (itemsite_cyclecountfreq > 0)
                     AND ((COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq) < CURRENT_DATE)
                     AND ((NOT pIgnoreZeroBalance) OR (itemsite_qtyonhand <> 0))
                     AND (itemloc_itemsite_id = itemsite_id)
                     AND (itemsite_warehous_id=pWarehousid)
                     AND (pLocationid = itemloc_location_id)
                     AND (itemsite_plancode_id=pPlancodeid) )
		    GROUP BY itemsite_id, itemsite_warehous_id,
			     itemsite_datelastcount, itemsite_cyclecountfreq,
			     itemsite_abcclass
                    ORDER BY (COALESCE(itemsite_datelastcount, startOfTime()) + itemsite_cyclecountfreq), itemsite_abcclass
                    LIMIT pMaxNumber LOOP
    _returnVal := createCountTag(_itemsites.itemsite_id, pComments,
				    pPriority, pFreeze, pLocationid);
    IF (_returnVal < 0) THEN
      RETURN _returnVal;
    END IF;
  END LOOP;

END IF;

  RETURN 0;
END;
$_$;


ALTER FUNCTION public.createcyclecountsbywarehousebyplannercode(integer, integer, integer, text, boolean, boolean, integer, boolean) OWNER TO admin;

--
-- Name: createfile(text, text, bytea); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createfile(text, text, bytea) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
  pTitle ALIAS FOR $1;
  pDescription ALIAS FOR $2;
  pStream ALIAS FOR $3;
  _id integer;
begin
  _id := nextval('file_file_id_seq');
  insert into file (file_id, file_title, file_descrip, file_stream) values (_id, pTitle, pDescription, pStream);
  return _id;
end;
$_$;


ALTER FUNCTION public.createfile(text, text, bytea) OWNER TO admin;

--
-- Name: createinvoice(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createinvoice(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCobmiscid ALIAS FOR $1;
  _invcheadid INTEGER;
  _invcitemid INTEGER;
  _qtyToInvoice	NUMERIC;
  _r		RECORD;
  _s		RECORD;
  _lastlinenumber INTEGER := 1;
  
BEGIN

  IF ( ( SELECT cobmisc_posted
         FROM cobmisc
         WHERE (cobmisc_id=pCobmiscid) ) ) THEN
    RETURN -1;
  END IF;

  SELECT NEXTVAL('invchead_invchead_id_seq') INTO _invcheadid;

--  Give this selection a number if it has not been assigned one
  UPDATE cobmisc
  SET cobmisc_invcnumber=fetchInvcNumber()
  WHERE ( (cobmisc_invcnumber IS NULL)
   AND (cobmisc_id=pCobmiscid) );

--  Create the Invoice header
  INSERT INTO invchead
  ( 
	invchead_id,invchead_cust_id,invchead_shipto_id,invchead_ordernumber,invchead_orderdate,
	invchead_posted,invchead_printed,invchead_invcnumber,invchead_invcdate,invchead_shipdate,
	invchead_ponumber,invchead_shipvia,invchead_fob,invchead_billto_name,invchead_billto_address1,
	invchead_billto_address2,invchead_billto_address3,invchead_billto_city,invchead_billto_state,invchead_billto_zipcode,
	invchead_billto_phone,invchead_billto_country,invchead_shipto_name,invchead_shipto_address1,invchead_shipto_address2,
	invchead_shipto_address3,invchead_shipto_city,invchead_shipto_state,invchead_shipto_zipcode,invchead_shipto_phone,
	invchead_shipto_country,invchead_salesrep_id,invchead_commission,invchead_terms_id,invchead_freight,
	invchead_misc_amount,invchead_misc_descrip,invchead_misc_accnt_id,invchead_payment,
	invchead_paymentref,invchead_notes,invchead_prj_id,invchead_curr_id,
	invchead_taxzone_id, invchead_shipchrg_id,
        invchead_saletype_id, invchead_shipzone_id
   )
  SELECT 
	_invcheadid,cohead_cust_id,cohead_shipto_id,cohead_number,cohead_orderdate,
	FALSE,FALSE,cobmisc_invcnumber,cobmisc_invcdate,cobmisc_shipdate,
	cohead_custponumber,cobmisc_shipvia,cohead_fob,cohead_billtoname,cohead_billtoaddress1,
	cohead_billtoaddress2,cohead_billtoaddress3,cohead_billtocity,cohead_billtostate,cohead_billtozipcode,
	cntct_phone AS cust_phone,cohead_billtocountry,cohead_shiptoname,cohead_shiptoaddress1,cohead_shiptoaddress2,
	cohead_shiptoaddress3,cohead_shiptocity,cohead_shiptostate,cohead_shiptozipcode,cohead_shipto_cntct_phone,
	cohead_shiptocountry,cohead_salesrep_id,COALESCE(cohead_commission,0),cohead_terms_id,cobmisc_freight,
	COALESCE(cobmisc_misc, 0.00),cobmisc_misc_descrip,cobmisc_misc_accnt_id,cobmisc_payment,
	cobmisc_paymentref,cobmisc_notes,cohead_prj_id,cobmisc_curr_id,
	cobmisc_taxzone_id, cohead_shipchrg_id,
        cohead_saletype_id, cohead_shipzone_id
    FROM cobmisc, cohead, custinfo
    LEFT OUTER JOIN cntct ON (cust_cntct_id=cntct_id)
  WHERE ( (cobmisc_cohead_id=cohead_id)
   AND (cohead_cust_id=cust_id)
   AND (cobmisc_id=pCobmiscid) );

	INSERT INTO invcheadtax(taxhist_parent_id, taxhist_taxtype_id, taxhist_tax_id, taxhist_basis, 
			taxhist_basis_tax_id, taxhist_sequence, taxhist_percent, taxhist_amount, taxhist_tax, taxhist_docdate)
        SELECT _invcheadid,taxhist_taxtype_id, taxhist_tax_id, taxhist_basis, 
			taxhist_basis_tax_id, taxhist_sequence, taxhist_percent, taxhist_amount, taxhist_tax, taxhist_docdate
        FROM cobmisctax 
	WHERE taxhist_parent_id = pCobmiscid 
	AND taxhist_taxtype_id = getadjustmenttaxtypeid();

--  Create the Invoice items
  FOR _r IN SELECT coitem_id, coitem_linenumber, coitem_subnumber, coitem_custpn,
                   coitem_qtyord, cobill_qty,
                   coitem_qty_uom_id, coitem_qty_invuomratio,
                   coitem_custprice, coitem_price,
                   coitem_price_uom_id, coitem_price_invuomratio,
                   coitem_memo, coitem_rev_accnt_id,
                   itemsite_item_id, itemsite_warehous_id,
                   cobill_taxtype_id,
                   formatSoItemNumber(coitem_id) AS ordnumber
            FROM coitem, cobill, itemsite
            WHERE ( (cobill_coitem_id=coitem_id)
             AND (coitem_itemsite_id=itemsite_id)
             AND (cobill_cobmisc_id=pCobmiscid) )
            ORDER BY coitem_linenumber, coitem_subnumber LOOP

    SELECT NEXTVAL('invcitem_invcitem_id_seq') INTO _invcitemid;
    INSERT INTO invcitem
    ( invcitem_id, invcitem_invchead_id,
      invcitem_linenumber, invcitem_item_id, invcitem_warehous_id,
      invcitem_custpn, invcitem_number, invcitem_descrip,
      invcitem_ordered, invcitem_billed,
      invcitem_qty_uom_id, invcitem_qty_invuomratio,
      invcitem_custprice, invcitem_price,
      invcitem_price_uom_id, invcitem_price_invuomratio,
      invcitem_notes, invcitem_taxtype_id,
      invcitem_coitem_id, invcitem_rev_accnt_id )
    VALUES
    ( _invcitemid, _invcheadid,
      _lastlinenumber,
      _r.itemsite_item_id, _r.itemsite_warehous_id,
      _r.coitem_custpn, '', '',
      _r.coitem_qtyord, _r.cobill_qty,
      _r.coitem_qty_uom_id, _r.coitem_qty_invuomratio,
      _r.coitem_custprice, _r.coitem_price,
      _r.coitem_price_uom_id, _r.coitem_price_invuomratio,
      _r.coitem_memo, _r.cobill_taxtype_id,
      _r.coitem_id, _r.coitem_rev_accnt_id );

--  Find and mark any Lot/Serial invdetail records associated with this bill
    UPDATE invdetail SET invdetail_invcitem_id = _invcitemid
     WHERE (invdetail_id IN (SELECT invdetail_id
                               FROM invhist JOIN invdetail ON (invdetail_invhist_id=invhist_id)
                              WHERE ( (invhist_ordnumber = _r.ordnumber)
                                AND   (invhist_ordtype = 'SO')
                                AND   (invhist_transtype = 'SH')
                                AND   (invdetail_invcitem_id IS NULL) ) ));

--  Mark any shipped, uninvoiced shipitems for the current coitem as invoiced
    _qtyToInvoice :=  _r.cobill_qty;
    FOR _s IN SELECT shipitem.*, shipitem_qty = _r.cobill_qty AS matched
	      FROM shipitem, shiphead
	      WHERE ((shipitem_shiphead_id=shiphead_id)
	        AND  (shipitem_orderitem_id=_r.coitem_id)
	        AND  (shiphead_shipped)
		AND  (shiphead_order_type='SO')
	        AND  (NOT shipitem_invoiced))
	      ORDER BY matched DESC, shipitem_qty DESC FOR UPDATE LOOP
      IF (_qtyToInvoice >= _s.shipitem_qty) THEN
	UPDATE shipitem
	SET shipitem_invoiced=TRUE, shipitem_invcitem_id=_invcitemid
	WHERE (shipitem_id=_s.shipitem_id);
	_qtyToInvoice := _qtyToInvoice - _s.shipitem_qty;
      END IF;
      IF (_qtyToInvoice <= 0) THEN
	EXIT;
      END IF;
    END LOOP;

    UPDATE cobill SET cobill_invcnum=cobmisc_invcnumber,
		      cobill_invcitem_id=invcitem_id
    FROM invcitem, coitem, cobmisc
    WHERE ((invcitem_linenumber=_lastlinenumber)
      AND  (coitem_id=cobill_coitem_id)
      AND  (cobmisc_id=cobill_cobmisc_id)
      AND  (cobill_cobmisc_id=pCobmiscid)
      AND  (invcitem_invchead_id=_invcheadid));
    
    _lastlinenumber := _lastlinenumber + 1;

  END LOOP;

--  Close all requested coitem's
  IF ( ( SELECT cobmisc_closeorder
         FROM cobmisc
         WHERE (cobmisc_id=pCobmiscid) ) ) THEN
    UPDATE coitem
    SET coitem_status='C'
    FROM cobmisc
    WHERE ( (coitem_status NOT IN ('C', 'X'))
     AND (coitem_cohead_id=cobmisc_cohead_id)
     AND (cobmisc_id=pCobmiscid) );
  ELSE
    UPDATE coitem
    SET coitem_status='C'
    FROM cobill
    WHERE ( (cobill_coitem_id=coitem_id)
     AND (coitem_status <> 'X')
     AND (cobill_toclose)
     AND (cobill_cobmisc_id=pCobmiscid) );
  END IF;

--  Mark the cobmisc as posted
  UPDATE cobmisc
  SET cobmisc_posted=TRUE, cobmisc_invchead_id=_invcheadid
  WHERE (cobmisc_id=pCobmiscid);

--  All done
  RETURN _invcheadid;

END;
$_$;


ALTER FUNCTION public.createinvoice(integer) OWNER TO admin;

--
-- Name: createinvoiceconsolidated(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createinvoiceconsolidated(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCustid ALIAS FOR $1;
  _invcheadid INTEGER;
  _invcitemid INTEGER;
  _qtyToInvoice	NUMERIC;
  _r		RECORD;
  _s		RECORD;
  _c		RECORD;
  _i		RECORD;
  _count      INTEGER;
  _invcnumber INTEGER;
  _lastlinenumber INTEGER;

BEGIN
  _count := 0;

  FOR _c IN SELECT min(cobmisc_id) AS cobmisc_id, count(*) AS cnt,
-- there are the key values for consolidation
                   cohead_billtoname, cohead_billtoaddress1,
                   cohead_billtoaddress2, cohead_billtoaddress3,
                   cohead_billtocity, cohead_billtostate,
                   cohead_billtozipcode, cntct_phone AS cust_phone,
                   cohead_billtocountry,
                   cohead_salesrep_id, cohead_commission,
                   cohead_terms_id,
                   cobmisc_misc_accnt_id,
                   cohead_prj_id, cobmisc_curr_id,
                   cobmisc_taxzone_id,
                   cohead_shipchrg_id,
                   cohead_saletype_id,
                   cohead_shipzone_id,
                   
		-- the following are consolidated values to use in creating the header
                   MIN(cohead_number) AS cohead_number,
                   MIN(cohead_orderdate) AS cohead_orderdate,
                   MIN(cobmisc_invcdate) AS cobmisc_invcdate,
                   MIN(cobmisc_shipdate) AS cobmisc_shipdate,
                   SUM(cobmisc_freight) AS cobmisc_freight,
                   SUM(cobmisc_misc) AS cobmisc_misc,
                   SUM(cobmisc_payment) AS cobmisc_payment
                   
              FROM cobmisc
              JOIN cohead   ON (cobmisc_cohead_id=cohead_id)
              JOIN custinfo ON (cohead_cust_id=cust_id)
              LEFT OUTER JOIN cntct ON (cust_cntct_id=cntct_id)
             WHERE(NOT cobmisc_posted
               AND (cohead_cust_id=pCustid)
               )
          GROUP BY cohead_billtoname, cohead_billtoaddress1,
                   cohead_billtoaddress2, cohead_billtoaddress3,
                   cohead_billtocity, cohead_billtostate,
                   cohead_billtozipcode, cust_phone,
                   cohead_billtocountry,
                   cohead_salesrep_id, cohead_commission,
                   cohead_terms_id,
                   cobmisc_misc_accnt_id,
                   cohead_prj_id, cobmisc_curr_id,
                   cobmisc_taxzone_id,
                   cohead_shipchrg_id,
                   cohead_saletype_id,
                   cohead_shipzone_id
		LOOP

    IF(_c.cnt = 1) THEN
      PERFORM createInvoice(_c.cobmisc_id);
      _count := (_count + 1);
    ELSE
      SELECT NEXTVAL('invchead_invchead_id_seq'), fetchInvcNumber() INTO _invcheadid, _invcnumber;
  
  --  Create the Invoice header
      INSERT INTO invchead
      ( invchead_id, invchead_cust_id, invchead_shipto_id,
        invchead_ordernumber, invchead_orderdate,
        invchead_posted, invchead_printed,
        invchead_invcnumber, invchead_invcdate, invchead_shipdate,
        invchead_ponumber, invchead_shipvia, invchead_fob,
        invchead_billto_name, invchead_billto_address1,
        invchead_billto_address2, invchead_billto_address3,
        invchead_billto_city, invchead_billto_state,
        invchead_billto_zipcode, invchead_billto_phone,
        invchead_billto_country,
        invchead_shipto_name, invchead_shipto_address1,
        invchead_shipto_address2, invchead_shipto_address3,
        invchead_shipto_city, invchead_shipto_state,
        invchead_shipto_zipcode, invchead_shipto_phone,
        invchead_shipto_country,
        invchead_salesrep_id, invchead_commission,
        invchead_terms_id,
        invchead_freight,
        invchead_misc_amount, invchead_misc_descrip, invchead_misc_accnt_id,
        invchead_payment, invchead_paymentref,
        invchead_notes, invchead_prj_id, invchead_curr_id,
        invchead_taxzone_id,
        invchead_shipchrg_id,
        invchead_saletype_id, invchead_shipzone_id )
      VALUES(_invcheadid,
             pCustid, -1,
             NULL, _c.cohead_orderdate,
             FALSE, FALSE,
             _invcnumber, _c.cobmisc_invcdate, _c.cobmisc_shipdate,
             'MULTIPLE', '', '',
             _c.cohead_billtoname, _c.cohead_billtoaddress1,
             _c.cohead_billtoaddress2, _c.cohead_billtoaddress3,
             _c.cohead_billtocity, _c.cohead_billtostate,
             _c.cohead_billtozipcode, _c.cust_phone,
             _c.cohead_billtocountry,
             '', '', '', '', '', '', '', '', '',
             _c.cohead_salesrep_id, COALESCE(_c.cohead_commission, 0),
             _c.cohead_terms_id,
             _c.cobmisc_freight,
             _c.cobmisc_misc, CASE WHEN(_c.cobmisc_misc <> 0) THEN 'Multiple' ELSE '' END,
             _c.cobmisc_misc_accnt_id,
             _c.cobmisc_payment, '',
             'Multiple Sales Order # Invoice', _c.cohead_prj_id, _c.cobmisc_curr_id,
             _c.cobmisc_taxzone_id,
             _c.cohead_shipchrg_id,
             _c.cohead_saletype_id, _c.cohead_shipzone_id
             );
 
    _lastlinenumber := 1;
    FOR _i IN SELECT cobmisc_id
                FROM cobmisc
                JOIN cohead   ON (cobmisc_cohead_id=cohead_id)
                JOIN custinfo ON (cohead_cust_id=cust_id)
                LEFT OUTER JOIN cntct ON (cust_cntct_id=cntct_id)
               WHERE(NOT cobmisc_posted
                 AND (cohead_cust_id=pCustid)
                 AND (COALESCE(cohead_billtoname,'')         = COALESCE(_c.cohead_billtoname,''))
                 AND (COALESCE(cohead_billtoaddress1,'')     = COALESCE(_c.cohead_billtoaddress1,''))
                 AND (COALESCE(cohead_billtoaddress2,'')     = COALESCE(_c.cohead_billtoaddress2,''))
                 AND (COALESCE(cohead_billtoaddress3,'')     = COALESCE(_c.cohead_billtoaddress3,''))
                 AND (COALESCE(cohead_billtocity,'')         = COALESCE(_c.cohead_billtocity,''))
                 AND (COALESCE(cohead_billtostate,'')        = COALESCE(_c.cohead_billtostate,''))
                 AND (COALESCE(cohead_billtozipcode,'')      = COALESCE(_c.cohead_billtozipcode,''))
                 AND (COALESCE(cntct_phone,'')               = COALESCE(_c.cust_phone,''))
                 AND (COALESCE(cohead_billtocountry,'')      = COALESCE(_c.cohead_billtocountry,''))
                 AND (COALESCE(cohead_salesrep_id, 0)        = COALESCE(_c.cohead_salesrep_id, 0))
                 AND (COALESCE(cohead_commission, 0)         = COALESCE(_c.cohead_commission, 0))
                 AND (COALESCE(cohead_terms_id, 0)           = COALESCE(_c.cohead_terms_id, 0))
                 AND (COALESCE(cobmisc_misc_accnt_id, 0)     = COALESCE(_c.cobmisc_misc_accnt_id, 0))
                 AND (COALESCE(cohead_prj_id, 0)             = COALESCE(_c.cohead_prj_id, 0))
                 AND (COALESCE(cobmisc_curr_id, 0)           = COALESCE(_c.cobmisc_curr_id, 0))
                 AND (COALESCE(cobmisc_taxzone_id, 0)        = COALESCE(_c.cobmisc_taxzone_id, 0))
                 AND (COALESCE(cohead_saletype_id, 0)        = COALESCE(_c.cohead_saletype_id, 0))
                 AND (COALESCE(cohead_shipzone_id, 0)        = COALESCE(_c.cohead_shipzone_id, 0))
                ) LOOP

    --  Create the Invoice Head tax
        INSERT INTO invcheadtax(taxhist_parent_id, taxhist_taxtype_id, taxhist_tax_id, taxhist_basis, 
                                taxhist_basis_tax_id, taxhist_sequence, taxhist_percent, taxhist_amount, taxhist_tax, taxhist_docdate)
        SELECT _invcheadid,taxhist_taxtype_id, taxhist_tax_id, taxhist_basis, 
               taxhist_basis_tax_id, taxhist_sequence, taxhist_percent, taxhist_amount, taxhist_tax, taxhist_docdate
        FROM cobmisctax 
        WHERE taxhist_parent_id = _i.cobmisc_id
          AND taxhist_taxtype_id = getadjustmenttaxtypeid();

    --  Give this selection a number if it has not been assigned one
        UPDATE cobmisc
           SET cobmisc_invcnumber=_invcnumber
         WHERE(cobmisc_id=_i.cobmisc_id);
      
    --  Create the Invoice items
        FOR _r IN SELECT coitem_id, coitem_linenumber, coitem_subnumber, coitem_custpn,
                         coitem_qtyord, cobill_qty,
                         coitem_qty_uom_id, coitem_qty_invuomratio,
                         coitem_custprice, coitem_price,
                         coitem_price_uom_id, coitem_price_invuomratio,
                         coitem_memo,
                         itemsite_item_id, itemsite_warehous_id,
                         cobill_taxtype_id
                    FROM cohead, coitem, cobill, itemsite
                   WHERE((cobill_coitem_id=coitem_id)
                     AND (cohead_id=coitem_cohead_id)
                     AND (coitem_itemsite_id=itemsite_id)
                     AND (cobill_cobmisc_id=_i.cobmisc_id) ) 
                   ORDER BY cohead_number, coitem_linenumber, coitem_subnumber LOOP
      
          SELECT NEXTVAL('invcitem_invcitem_id_seq') INTO _invcitemid;
          INSERT INTO invcitem
          ( invcitem_id, invcitem_invchead_id,
            invcitem_linenumber, invcitem_item_id, invcitem_warehous_id,
            invcitem_custpn, invcitem_number, invcitem_descrip,
            invcitem_ordered, invcitem_billed,
            invcitem_qty_uom_id, invcitem_qty_invuomratio,
            invcitem_custprice, invcitem_price,
            invcitem_price_uom_id, invcitem_price_invuomratio,
            invcitem_notes,
            invcitem_taxtype_id,
            invcitem_coitem_id )
          VALUES
          ( _invcitemid, _invcheadid,
            _lastlinenumber,
            _r.itemsite_item_id, _r.itemsite_warehous_id,
            _r.coitem_custpn, '', '',
            _r.coitem_qtyord, _r.cobill_qty,
            _r.coitem_qty_uom_id, _r.coitem_qty_invuomratio,
            _r.coitem_custprice, _r.coitem_price,
            _r.coitem_price_uom_id, _r.coitem_price_invuomratio,
            _r.coitem_memo,
            _r.cobill_taxtype_id,
            _r.coitem_id );
          
      --  Find and mark any Lot/Serial invdetail records associated with this bill
          UPDATE invdetail SET invdetail_invcitem_id = _invcitemid
           WHERE (invdetail_id IN (SELECT invdetail_id
                                     FROM coitem, cohead, invhist, invdetail
                                    WHERE ((coitem_cohead_id=cohead_id)
                                      AND  (invdetail_invhist_id=invhist_id)
                                      AND  (invhist_ordnumber = text(cohead_number||'-'||formatSoLineNumber(coitem_id)))
                                      AND  (invdetail_invcitem_id IS NULL)
                                      AND  (coitem_id=_r.coitem_id)) ) );
      
      --  Mark any shipped, uninvoiced shipitems for the current coitem as invoiced
          _qtyToInvoice :=  _r.cobill_qty;
          FOR _s IN SELECT shipitem.*, shipitem_qty = _r.cobill_qty AS matched
	            FROM shipitem, shiphead
	            WHERE ((shipitem_shiphead_id=shiphead_id)
	              AND  (shipitem_orderitem_id=_r.coitem_id)
	              AND  (shiphead_shipped)
		      AND  (shiphead_order_type='SO')
	              AND  (NOT shipitem_invoiced))
	            ORDER BY matched DESC, shipitem_qty DESC FOR UPDATE LOOP
            IF (_qtyToInvoice >= _s.shipitem_qty) THEN
	      UPDATE shipitem
	      SET shipitem_invoiced=TRUE, shipitem_invcitem_id=_invcitemid
	      WHERE (shipitem_id=_s.shipitem_id);
	      _qtyToInvoice := _qtyToInvoice - _s.shipitem_qty;
            END IF;
            IF (_qtyToInvoice <= 0) THEN
	      EXIT;
            END IF;
          END LOOP;

          UPDATE cobill SET cobill_invcnum=cobmisc_invcnumber,
		          cobill_invcitem_id=invcitem_id
          FROM invcitem, coitem, cobmisc
          WHERE ((invcitem_linenumber=_lastlinenumber )
            AND  (coitem_id=cobill_coitem_id)
            AND  (cobmisc_id=cobill_cobmisc_id)
            AND  (cobill_cobmisc_id=_i.cobmisc_id)
            AND  (invcitem_invchead_id=_invcheadid));


          _lastlinenumber := _lastlinenumber + 1;
          
        END LOOP;
  
      --  Close all requested coitem's
        IF ( ( SELECT cobmisc_closeorder
               FROM cobmisc
               WHERE (cobmisc_id=_i.cobmisc_id) ) ) THEN
          UPDATE coitem
          SET coitem_status='C'
          FROM cobmisc
          WHERE ( (coitem_status NOT IN ('C', 'X'))
           AND (coitem_cohead_id=cobmisc_cohead_id)
           AND (cobmisc_id=_i.cobmisc_id) );
        ELSE
          UPDATE coitem
          SET coitem_status='C'
          FROM cobill
          WHERE ( (cobill_coitem_id=coitem_id)
           AND (coitem_status <> 'X')
           AND (cobill_toclose)
           AND (cobill_cobmisc_id=_i.cobmisc_id) );
        END IF;
      
      --  Mark the cobmisc as posted
        UPDATE cobmisc
        SET cobmisc_posted=TRUE, cobmisc_invchead_id=_invcheadid
        WHERE (cobmisc_id=_i.cobmisc_id);
    
      --  All done
        _count := (_count + 1);
      END LOOP;
    END IF;
  END LOOP;
  RETURN _count;
END;
$_$;


ALTER FUNCTION public.createinvoiceconsolidated(integer) OWNER TO admin;

--
-- Name: createinvoices(); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createinvoices() RETURNS integer
    LANGUAGE plpgsql
    AS $$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  _counter INTEGER;
  _cobmisc RECORD;

BEGIN

  _counter := 0;

  FOR _cobmisc IN SELECT cobmisc_id
                  FROM cobmisc
                  WHERE (NOT cobmisc_posted) LOOP

    PERFORM createinvoice(_cobmisc.cobmisc_id);
    _counter := (_counter + 1);

  END LOOP;

  RETURN _counter;
END;
$$;


ALTER FUNCTION public.createinvoices() OWNER TO admin;

--
-- Name: createinvoices(integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createinvoices(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  RETURN createinvoices($1, false);
END;
$_$;


ALTER FUNCTION public.createinvoices(integer) OWNER TO admin;

--
-- Name: createinvoices(integer, boolean); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createinvoices(integer, boolean) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pCustTypeId ALIAS FOR $1;
  pConsolidate ALIAS FOR $2;
  _counter INTEGER;
  _tcounter INTEGER;
  _cobmisc RECORD;

BEGIN

  _counter := 0;

  IF (pConsolidate) THEN
    FOR _cobmisc IN SELECT DISTINCT cust_id
                      FROM cobmisc, cohead, custinfo
                     WHERE((NOT cobmisc_posted)
                       AND (cohead_id=cobmisc_cohead_id)
                       AND (cust_id=cohead_cust_id)
                       AND (cust_custtype_id=pCustTypeId)) LOOP

      SELECT createinvoiceConsolidated(_cobmisc.cust_id)
        INTO _tcounter;
      _counter := (_counter + _tcounter);
    END LOOP;
  ELSE
    FOR _cobmisc IN SELECT cobmisc_id
                      FROM cobmisc, cohead, custinfo
                     WHERE((NOT cobmisc_posted)
                       AND (cohead_id=cobmisc_cohead_id)
                       AND (cust_id=cohead_cust_id)
                       AND (cust_custtype_id=pCustTypeId)) LOOP
  
      PERFORM createinvoice(_cobmisc.cobmisc_id);
      _counter := (_counter + 1);

    END LOOP;
  END IF;

  RETURN _counter;
END;
$_$;


ALTER FUNCTION public.createinvoices(integer, boolean) OWNER TO admin;

--
-- Name: createmiscapcheck(integer, integer, date, numeric, integer, text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createmiscapcheck(integer, integer, date, numeric, integer, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  RAISE NOTICE 'createMiscAPCheck() is deprecated - use createCheck() instead';
  RETURN createCheck($1, 'V', $2, $3, $4, baseCurrId(), $5, NULL, $6, $7, FALSE);
END;
$_$;


ALTER FUNCTION public.createmiscapcheck(integer, integer, date, numeric, integer, text, text) OWNER TO admin;

--
-- Name: createmiscapcheck(integer, integer, date, numeric, integer, integer, text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createmiscapcheck(integer, integer, date, numeric, integer, integer, text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
BEGIN
  RAISE NOTICE 'createMiscAPCheck() is deprecated - use createCheck() instead';
  RETURN createCheck($1, 'V', $2, $3, pAmount, $5, $6, NULL, $7, $8, FALSE);
END;
$_$;


ALTER FUNCTION public.createmiscapcheck(integer, integer, date, numeric, integer, integer, text, text) OWNER TO admin;

--
-- Name: createpkgschema(text, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createpkgschema(text, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pname         ALIAS FOR $1;
  pcomment      ALIAS FOR $2;
  _createtable  TEXT;
  _debug        BOOL    := true;
  _namespaceoid INTEGER := -1;
  _tabs         TEXT[] := ARRAY['cmd',  'cmdarg', 'image',  'metasql',
                                'priv', 'report', 'script', 'uiform'] ;
  _pkgtab       TEXT;

BEGIN
  IF (LENGTH(COALESCE(pname, '')) <= 0) THEN
    RAISE EXCEPTION 'Cannot create a schema for this package without a name.';
  END IF;

  SELECT oid INTO _namespaceoid
  FROM pg_namespace
  WHERE (LOWER(nspname)=LOWER(pname));
  IF (NOT FOUND) THEN
    EXECUTE 'CREATE SCHEMA ' || LOWER(pname);
    EXECUTE 'GRANT ALL ON SCHEMA ' || LOWER(pname) || ' TO GROUP xtrole;';

    SELECT oid INTO _namespaceoid
    FROM pg_namespace
    WHERE (LOWER(nspname)=LOWER(pname));
  END IF;

  FOR i IN ARRAY_LOWER(_tabs,1)..ARRAY_UPPER(_tabs,1) LOOP
    _pkgtab := pname || '.pkg' || _tabs[i];

    IF NOT EXISTS(SELECT oid
                  FROM pg_class
                  WHERE ((relname=_pkgtab)
                     AND (relnamespace=_namespaceoid))) THEN
      _createtable := 'CREATE TABLE ' || _pkgtab || ' () INHERITS (' || _tabs[i] || ');';
      IF (_debug) THEN RAISE NOTICE '%', _createtable; END IF;
      EXECUTE _createtable;

      EXECUTE 'ALTER TABLE ' || _pkgtab ||
              ' ALTER ' || _tabs[i] || '_id SET NOT NULL,' ||
              ' ADD PRIMARY KEY (' || _tabs[i] || '_id),' ||
              ' ALTER ' || _tabs[i] || '_id SET DEFAULT NEXTVAL(''' ||
              _tabs[i] || '_' || _tabs[i] || '_id_seq'');';

      EXECUTE 'REVOKE ALL ON ' || _pkgtab || ' FROM PUBLIC;';
      EXECUTE 'GRANT  ALL ON ' || _pkgtab || ' TO GROUP xtrole;';

      IF (_tabs[i] = 'cmdarg') THEN
        EXECUTE 'ALTER TABLE ' || _pkgtab ||
                ' ADD FOREIGN KEY (cmdarg_cmd_id) REFERENCES ' ||
                pname || '.pkgcmd(cmd_id);';
      END IF;

      EXECUTE 'SELECT dropIfExists(''TRIGGER'', ''pkg' ||
                                   _tabs[i] || 'beforetrigger'', ''' ||
                                   pname || ''');' ;
      EXECUTE 'CREATE TRIGGER pkg' || _tabs[i] || 'beforetrigger ' ||
              'BEFORE INSERT OR UPDATE OR DELETE ON ' || _pkgtab ||
              ' FOR EACH ROW EXECUTE PROCEDURE _pkg' || _tabs[i] || 'beforetrigger();';

      EXECUTE 'SELECT dropIfExists(''TRIGGER'', ''pkg' ||
                                   _tabs[i] || 'altertrigger'', ''' ||
                                   pname || ''');' ;
      EXECUTE 'CREATE TRIGGER pkg' || _tabs[i] || 'altertrigger ' ||
              'BEFORE INSERT OR UPDATE OR DELETE ON ' || _pkgtab ||
              ' FOR EACH ROW EXECUTE PROCEDURE _pkg' || _tabs[i] || 'altertrigger();';

      EXECUTE 'SELECT dropIfExists(''TRIGGER'', ''pkg' ||
                                   _tabs[i] || 'aftertrigger'', ''' ||
                                   pname || ''');' ;
      EXECUTE 'CREATE TRIGGER pkg' || _tabs[i] || 'aftertrigger ' ||
              'AFTER INSERT OR UPDATE OR DELETE ON ' || _pkgtab ||
              ' FOR EACH ROW EXECUTE PROCEDURE _pkg' || _tabs[i] || 'aftertrigger();';

    END IF;
  END LOOP;

  EXECUTE 'COMMENT ON SCHEMA ' || quote_ident(pname) || ' IS ' ||
           quote_literal(pcomment) || ';';

  RETURN _namespaceoid;
END;
$_$;


ALTER FUNCTION public.createpkgschema(text, text) OWNER TO admin;

--
-- Name: createpr(integer, integer, numeric, date, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createpr(integer, integer, numeric, date, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pOrderNumber ALIAS FOR $1;
  pItemsiteid ALIAS FOR $2;
  pQty ALIAS FOR $3;
  pDueDate ALIAS FOR $4;
  pNotes ALIAS FOR $5;
  _prid INTEGER;

BEGIN

  SELECT NEXTVAL('pr_pr_id_seq') INTO _prid;
  INSERT INTO pr
  ( pr_id, pr_number, pr_subnumber, pr_status,
    pr_order_type, pr_order_id,
    pr_itemsite_id, pr_qtyreq, pr_duedate, pr_releasenote )
  VALUES
  ( _prid, pOrderNumber, nextPrSubnumber(pOrderNumber), 'O',
    'M', -1,
    pItemsiteid, pQty, pDuedate, pNotes);

  RETURN _prid;

END;
$_$;


ALTER FUNCTION public.createpr(integer, integer, numeric, date, text) OWNER TO admin;

--
-- Name: createpr(integer, character, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createpr(integer, character, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pOrderNumber ALIAS FOR $1;
  pParentType ALIAS FOR $2;
  pParentId ALIAS FOR $3;
  _parent RECORD;
  _prid INTEGER;
  _orderNumber INTEGER;

BEGIN

  IF (pOrderNumber = -1) THEN
    SELECT fetchPrNumber() INTO _orderNumber;
  ELSE
    _orderNumber := pOrderNumber;
  END IF;

  IF (pParentType = 'W') THEN
    SELECT womatl_itemsite_id AS itemsiteid,
           itemuomtouom(itemsite_item_id, womatl_uom_id, NULL, womatl_qtyreq) AS qty,
           womatl_duedate AS duedate, wo_prj_id AS prjid,
           womatl_notes AS notes INTO _parent
    FROM wo, womatl, itemsite
    WHERE ((womatl_wo_id=wo_id)
     AND (womatl_itemsite_id=itemsite_id)
     AND (womatl_id=pParentId));

  ELSIF (pParentType = 'S') THEN
    SELECT coitem_itemsite_id AS itemsiteid,
           (coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) AS qty,
           coitem_scheddate AS duedate, cohead_prj_id AS prjid,
           coitem_memo AS notes INTO _parent
    FROM coitem, cohead
    WHERE ((cohead_id=coitem_cohead_id)
     AND (coitem_id=pParentId));

  ELSIF (pParentType = 'F') THEN
    SELECT planord_itemsite_id AS itemsiteid,
           planord_qty AS qty,
           planord_duedate AS duedate, NULL::INTEGER AS prjid,
           planord_comments AS notes INTO _parent
    FROM planord
    WHERE (planord_id=pParentId);

  ELSE
    RETURN -2;
  END IF;

  IF (NOT FOUND) THEN
    RETURN -1;
  END IF;

  SELECT NEXTVAL('pr_pr_id_seq') INTO _prid;
  INSERT INTO pr
  ( pr_id, pr_number, pr_subnumber, pr_status,
    pr_order_type, pr_order_id, pr_prj_id,
    pr_itemsite_id, pr_qtyreq,
    pr_duedate, pr_releasenote )
  VALUES
  ( _prid, _orderNumber, nextPrSubnumber(_orderNumber), 'O',
    pParentType, pParentId, _parent.prjid,
    _parent.itemsiteid, validateOrderQty(_parent.itemsiteid, _parent.qty, TRUE),
    _parent.duedate, _parent.notes );

  RETURN _prid;

END;
$_$;


ALTER FUNCTION public.createpr(integer, character, integer) OWNER TO admin;

--
-- Name: createpr(character, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createpr(character, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pParentType ALIAS FOR $1;
  pParentId ALIAS FOR $2;
  _orderNumber INTEGER;
  _prid INTEGER;

BEGIN

  IF (pParentType = 'W') THEN
    SELECT wo_number INTO _orderNumber
    FROM wo, womatl
    WHERE ((womatl_wo_id=wo_id)
     AND (womatl_id=pParentId));

  ELSIF (pParentType = 'S') THEN
    SELECT CAST(cohead_number AS INTEGER) INTO _orderNumber
    FROM cohead, coitem
    WHERE ((coitem_cohead_id=cohead_id)
     AND (coitem_id=pParentId));

  ELSIF (pParentType = 'F') THEN
    SELECT fetchPrNumber() INTO _orderNumber;

  ELSE
    RETURN -2;
  END IF;

  IF (NOT FOUND) THEN
    RETURN -1;
  END IF;

  SELECT createPr(_orderNumber, pParentType, pParentId) INTO _prid;

  RETURN _prid;

END;
$_$;


ALTER FUNCTION public.createpr(character, integer) OWNER TO admin;

--
-- Name: createpr(integer, integer, numeric, date, text, character, integer); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createpr(integer, integer, numeric, date, text, character, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pOrderNumber ALIAS FOR $1;
  pItemsiteid ALIAS FOR $2;
  pQty ALIAS FOR $3;
  pDueDate ALIAS FOR $4;
  pNotes ALIAS FOR $5;
  pOrderType ALIAS FOR $6;
  pOrderId ALIAS FOR $7;
  _prid INTEGER;

BEGIN

  SELECT NEXTVAL('pr_pr_id_seq') INTO _prid;
  INSERT INTO pr
  ( pr_id, pr_number, pr_subnumber, pr_status,
    pr_order_type, pr_order_id,
    pr_itemsite_id, pr_qtyreq, pr_duedate, pr_releasenote )
  VALUES
  ( _prid, pOrderNumber, nextPrSubnumber(pOrderNumber), 'O',
    pOrderType, pOrderId,
    pItemsiteid, pQty, pDuedate, pNotes );

  RETURN _prid;

END;
$_$;


ALTER FUNCTION public.createpr(integer, integer, numeric, date, text, character, integer) OWNER TO admin;

--
-- Name: createpr(integer, character, integer, text); Type: FUNCTION; Schema: public; Owner: admin
--

CREATE FUNCTION createpr(integer, character, integer, text) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
-- Copyright (c) 1999-2012 by OpenMFG LLC, d/b/a xTuple. 
-- See www.xtuple.com/CPAL for the full text of the software license.
DECLARE
  pOrderNumber ALIAS FOR $1;
  pParentType ALIAS FOR $2;
  pParentId ALIAS FOR $3;
  pParentNotes ALIAS FOR $4;
  _parent RECORD;
  _prid INTEGER;
  _orderNumber INTEGER;

BEGIN

  IF (pOrderNumber = -1) THEN
    SELECT fetchPrNumber() INTO _orderNumber;
  ELSE
    _orderNumber := pOrderNumber;
  END IF;

  IF (pParentType = 'W') THEN
    SELECT womatl_itemsite_id AS itemsiteid,
           itemuomtouom(itemsite_item_id, womatl_uom_id, NULL, womatl_qtyreq) AS qty,
           womatl_duedate AS duedate, wo_prj_id AS prjid INTO _parent
    FROM wo, womatl, itemsite
    WHERE ((womatl_wo_id=wo_id)
     AND (womatl_itemsite_id=itemsite_id)
     AND (womatl_id=pParentId));

  ELSIF (pParentType = 'S') THEN
    SELECT coitem_itemsite_id AS itemsiteid,
           (coitem_qtyord - coitem_qtyshipped + coitem_qtyreturned) AS qty,
           coitem_scheddate AS duedate, cohead_prj_id AS prjid INTO _parent
    FROM coitem, cohead
    WHERE ((cohead_id=coitem_cohead_id)
     AND (coitem_id=pParentId));

  ELSIF (pParentType = 'F') THEN
    SELECT planord_itemsite_id AS itemsiteid,
           planord_qty AS qty,
           planord_duedate AS duedate, NULL::INTEGER AS prjid 
           INTO _pare