/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "aide.h"

Resultat aide_aide(TRAVAIL(General) general)
{
	/* Donne sur la sortie d'erreur le texte de l'aide, dans la
	 * langue et le jeu de caractres choisi.
	 * Renvoie RESULTAT_ERREUR si general est NULL.
	 * Renvoie RESULTAT_ERREUR si general->environnement est NULL.
	 */
	TRAVAIL_SCALAIRE(DescripteurFichier) erreur;
	STOCKAGE(MessageParametres) parametres;
	DEBUTZONESECURISEE
	if(S_T(general)==NULL)
		return RESULTAT_ERREUR;
	if(CHAMP(general , environnement)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(messageparametres_initialisation(T_S(parametres)));
	SECURISE(environnement_lecture_erreur(CHAMP_TRAVAIL(general , environnement),R_T_(erreur)));
	SECURISE(messages_message(general,erreur,T_S_(MESSAGE_AIDE),T_S(parametres)));
	SECURISE(messageparametres_destruction(T_S(parametres)));
	FINZONESECURISEE
	return RESULTAT_OK;
}

