static pme_sparc_entry_t ultra4plus_pe[] = {
	/* These two must always be first.  */
	{	.pme_name = "Cycle_cnt",
		.pme_desc = "Accumulated cycles",
		.pme_ctrl = PME_CTRL_S0 | PME_CTRL_S1,
		.pme_val = 0x0,
	},
	{	.pme_name = "Instr_cnt",
		.pme_desc = "Number of instructions completed",
		.pme_ctrl = PME_CTRL_S0 | PME_CTRL_S1,
		.pme_val = 0x1,
	},

	/* PIC0 UltraSPARC-IV+ events */
	{
		.pme_name = "Dispatch0_IC_miss",
		.pme_desc = "I-buffer is empty from I-Cache miss",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x2,
	},
	{
		.pme_name = "IU_stat_jmp_correct_pred",
		.pme_desc = "Retired non-annulled register indirect jumps predicted correctly",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x3,
	},
	{
		.pme_name = "Dispatch0_2nd_br",
		.pme_desc = "Stall cycles due to having two branch instructions line-up in one 4-instruction group causing the second branch in the group to be re-fetched, delaying it's entrance into the I-buffer",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x4,
	},
	{
		.pme_name = "Rstall_storeQ",
		.pme_desc = "R-stage stall for a store instruction which is the next instruction to be executed, but it stailled due to the store queue being full",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x5,
	},
	{
		.pme_name = "Rstall_IU_use",
		.pme_desc = "R-stage stall for an event that the next instruction to be executed depends on the result of a preceeding integer instruction in the pipeline that is not yet available",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x6,
	},
	{
		.pme_name = "IU_stat_ret_correct_pred",
		.pme_desc = "Retired non-annulled returns predicted correctly",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x7,
	},
	{
		.pme_name = "IC_ref",
		.pme_desc = "I-cache refrences",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x8,
	},
	{
		.pme_name = "DC_rd",
		.pme_desc = "D-cache read references (including accesses that subsequently trap)",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x9,
	},
	{
		.pme_name = "Rstall_FP_use",
		.pme_desc = "R-stage stall for an event that the next instruction to be executed depends on the result of a preceeding floating-point instruction in the pipeline that is not yet available",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0xa,
	},
	{
		.pme_name = "SW_pf_instr",
		.pme_desc = "Retired SW prefetch instructions",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0xb,
	},
	{
		.pme_name = "L2_ref",
		.pme_desc = "L2-cache references",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0xc,
	},
	{
		.pme_name = "L2_write_hit_RTO",
		.pme_desc = "L2-cache exclusive requests that hit L2-cache in S, O, or Os state and thus, do a read-to-own bus transaction",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0xd,
	},
	{
		.pme_name = "L2_snoop_inv_sh",
		.pme_desc = "L2 cache lines that were written back to the L3 cache due to requests from both cores",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0xe,
	},
	{
		.pme_name = "L2_rd_miss",
		.pme_desc = "L2-cache miss events (including atomics) from D-cache events",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0xf,
	},
	{
		.pme_name = "PC_rd",
		.pme_desc = "P-cache cacheable loads",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x10,
	},
	{
		.pme_name = "SI_snoop_sh",
		.pme_desc = "Counts snoops from remote processor(s) including RTS, RTSR, RTO, RTOR, RS, RSR, RTSM, and WS",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x11,
	},
	{
		.pme_name = "SI_ciq_flow_sh",
		.pme_desc = "Counts system clock cycles when the flow control (PauseOut) signal is asserted",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x12,
	},
	{
		.pme_name = "Re_DC_miss",
		.pme_desc = "Stall due to loads that miss D-cache and get recirculated",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x13,
	},
	{
		.pme_name = "SW_count_NOP0",
		.pme_desc = "Retired, non-annulled special software NOP instructions (which is equivalent to 'sethi %hi(0xfc000), %g0' instruction)",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x14,
	},
	{	.pme_name = "IU_Stat_Br_miss_taken",
		.pme_desc = "Retired branches that were predicted to be taken, but in fact were not taken",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x15,
	},
	{	.pme_name = "IU_Stat_Br_Count_taken",
		.pme_desc = "Retired taken branches",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x16,
	},
	{	.pme_name = "HW_pf_exec",
		.pme_desc = "Hardware prefetches enqueued in the prefetch queue",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x17,
	},
	{
		.pme_name = "FA_pipe_completion",
		.pme_desc = "Instructions that complete execution on the FPG ALU pipelines",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x18,
	},
	{
		.pme_name = "SSM_L3_wb_remote",
		.pme_desc = "L3 cache line victimizations from this core which generate R_WB transactions to non-LPA (remote physical address) regions",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x19,
	},
	{
		.pme_name = "SSM_L3_miss_local",
		.pme_desc = "L3 cache misses to LPA (local physical address) from this core which generate an RTS, RTO, or RS transaction",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x1a,
	},
	{
		.pme_name = "SSM_L3_miss_mtag_remote",
		.pme_desc = "L3 cache misses to LPA (local physical address) from this core which generate retry (R_*) transactions including R_RTS, R_RTO, and R_RS",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x1b,
	},
	{
		.pme_name = "SW_pf_str_trapped",
		.pme_desc = "Strong software prefetch instructions trapping due to TLB miss",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x1c,
	},
	{
		.pme_name = "SW_pf_PC_installed",
		.pme_desc = "Software prefetch instructions that installed lines in the P-cache",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x1d,
	},
	{
		.pme_name = "IPB_to_IC_fill",
		.pme_desc = "I-cache filles from the instruction prefetch buffer",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x1e,
	},
	{
		.pme_name = "L2_write_miss",
		.pme_desc = "L2-cache misses from this core by cacheable store requests",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x1f,
	},
	{
		.pme_name = "MC_reads_0_sh",
		.pme_desc = "Read requests completed to memory bank 0",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x20,
	},
	{
		.pme_name = "MC_reads_1_sh",
		.pme_desc = "Read requests completed to memory bank 1",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x21,
	},
	{
		.pme_name = "MC_reads_2_sh",
		.pme_desc = "Read requests completed to memory bank 2",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x22,
	},
	{
		.pme_name = "MC_reads_3_sh",
		.pme_desc = "Read requests completed to memory bank 3",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x23,
	},
	{
		.pme_name = "MC_stalls_0_sh",
		.pme_desc = "Clock cycles that requests were stalled in the MCU queues because bank 0 was busy with a previous request",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x24,
	},
	{
		.pme_name = "MC_stalls_2_sh",
		.pme_desc = "Clock cycles that requests were stalled in the MCU queues because bank 2 was busy with a previous request",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x25,
	},
	{
		.pme_name = "L2_hit_other_half",
		.pme_desc = "L2 cache hits from this core to the ways filled by the other core when the cache is in the pseudo-split mode",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x26,
	},
	{
		.pme_name = "L3_rd_miss",
		.pme_desc = "L3 cache misses sent out to SIU from this code by cacheable I-cache, D-cache, PO-cache, and W-cache (excluding block store) requests",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x28,
	},
	{
		.pme_name = "Re_L2_miss",
		.pme_desc = "Stall cycles due to recirculation of cacheable loads that miss both D-cache and L2 cache",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x29,
	},
	{
		.pme_name = "IC_miss_cancelled",
		.pme_desc = "I-cache miss requests cancelled due to new fetch stream",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x2a,
	},
	{
		.pme_name = "DC_wr_miss",
		.pme_desc = "D-cache store accesses that miss D-cache",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x2b,
	},
	{
		.pme_name = "L3_hit_I_state_sh",
		.pme_desc = "Tag hits in L3 cache when the line is in I state",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x2c,
	},
	{
		.pme_name = "SI_RTS_src_data",
		.pme_desc = "Local RTS transactions due to I-cache, D-cache, or P-cache requests from this core where data is from the cache of another processor on the system, not from memory",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x2d,
	},
	{
		.pme_name = "L2_IC_miss",
		.pme_desc = "L2 cache misses from this code by cacheable I-cache requests",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x2e,
	},
	{
		.pme_name = "SSM_new_transaction_sh",
		.pme_desc = "New SSM transactions (RTSU, RTOU, UGM) observed by this processor on the Fireplane Interconnect",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x2f,
	},
	{
		.pme_name = "L2_SW_pf_miss",
		.pme_desc = "L2 cache misses by software prefetch requests from this core",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x30,
	},
	{
		.pme_name = "L2_wb",
		.pme_desc = "L2 cache lines that were written back to the L3 cache because of requests from this core",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x31,
	},
	{
		.pme_name = "L2_wb_sh",
		.pme_desc = "L2 cache lines that were written back to the L3 cache because of requests from both cores",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x32,
	},
	{
		.pme_name = "L2_snoop_cb_sh",
		.pme_desc = "L2 cache lines that were copied back due to other processors",
		.pme_ctrl = PME_CTRL_S0,
		.pme_val = 0x33,
	},

	/* PIC1 UltraSPARC-IV+ events */
	{
		.pme_name = "Dispatch0_other",
		.pme_desc = "Stall cycles due to the event that no instructions are dispatched because the I-queue is empty due to various other events, including branch target address fetch and various events which cause an instruction to be refetched",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x2,
	},
	{
		.pme_name = "DC_wr",
		.pme_desc = "D-cache write references by cacheable stores (excluding block stores)",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x3,
	},
	{
		.pme_name = "Re_DC_missovhd",
		.pme_desc = "Stall cycles due to D-cache load miss",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x4,
	},
	{
		.pme_name = "Re_FPU_bypass",
		.pme_desc = "Stall due to recirculation when an FPU bypass condition that does not have a direct bypass path occurs",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x5,
	},
	{
		.pme_name = "L3_write_hit_RTO",
		.pme_desc = "L3 cache hits in O, Os, or S state by cacheable store requests from this core that do a read-to-own (RTO) bus transaction",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x6,
	},
	{
		.pme_name = "L2L3_snoop_inv_sh",
		.pme_desc = "L2 and L3 cache lines that were invalidated due to other processors doing RTO, RTOR, RTOU, or WS transactions",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x7,
	},
	{
		.pme_name = "IC_L2_req",
		.pme_desc = "I-cache requests sent to L2 cache",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x8,
	},
	{
		.pme_name = "DC_rd_miss",
		.pme_desc = "Cacheable loads (excluding atomics and block loads) that miss D-cache as well as P-cache (for FP loads)",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x9,
	},
	{
		.pme_name = "L2_hit_I_state_sh",
		.pme_desc = "Tag hits in L2 cache when the line is in I state",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0xa,
	},
	{
		.pme_name = "L3_write_miss_RTO",
		.pme_desc = "L3 cache misses from this core by cacheable store requests that do a read-to-own (RTO) bus transaction.  This count does not include RTO requests for prefetch (fcn=2,3/22,23) instructions",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0xb,
	},
	{
		.pme_name = "L2_miss",
		.pme_desc = "L2 cache misses from this core by cacheable I-cache, D-cache, P-cache, and W-cache (excluding block stores) requests",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0xc,
	},
	{
		.pme_name = "SI_owned_sh",
		.pme_desc = "Number of times owned_in is asserted on bus requests from the local processor",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0xd,
	},
	{
		.pme_name = "SI_RTO_src_data",
		.pme_desc = "Number of local RTO transactions due to W-cache or P-cache requests from this core where data is from the cache of another processor on the system, not from memory",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0xe,
	},
	{
		.pme_name = "SW_pf_duplicate",
		.pme_desc = "Number of software prefetch instructions that were dropped because the prefetch request matched an outstanding requests in the prefetch queue or the request hit the P-cache",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0xf,
	},
	{
		.pme_name = "IU_stat_jmp_mispred",
		.pme_desc = "Number of retired non-annulled register indirect jumps mispredicted",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x10,
	},
	{
		.pme_name = "ITLB_miss",
		.pme_desc = "I-TLB misses",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x11,
	},
	{
		.pme_name = "DTLB_miss",
		.pme_desc = "D-TLB misses",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x12,
	},
	{
		.pme_name = "WC_miss",
		.pme_desc = "W-cache misses",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x13,
	},
	{
		.pme_name = "IC_fill",
		.pme_desc = "Number of I-cache fills excluding fills from the instruction prefetch buffer.  This is the best approximation of the number of I-cache misses for instructions that were actually executed",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x14,
	},
	{
		.pme_name = "IU_stat_ret_mispred",
		.pme_desc = "Number of retired non-annulled returns mispredicted",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x15,
	},
	{
		.pme_name = "Re_L3_miss",
		.pme_desc = "Stall cycles due to recirculation of cacheable loads that miss D-cache, L2, and L3 cache",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x16,
	},
	{
		.pme_name = "Re_PFQ_full",
		.pme_desc = "Stall cycles due to recirculation of prefetch instructions because the prefetch queue (PFQ) was full",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x17,
	},
	{
		.pme_name = "PC_soft_hit",
		.pme_desc = "Number of cacheable FP loads that hit a P-cache line that was prefetched by a software prefetch instruction",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x18,
	},
	{
		.pme_name = "PC_inv",
		.pme_desc = "Number of P-cache lines that were invalidated due to external snoops, internal stores, and L2 evictions",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x19,
	},
	{
		.pme_name = "PC_hard_hit",
		.pme_desc = "Number of FP loads that hit a P-cache line that was fetched by a FP load or a hardware prefetch, irrespective of whether the loads hit or miss the D-cache",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x1a,
	},
	{
		.pme_name = "IC_pf",
		.pme_desc = "Number of I-cache prefetch requests sent to L2 cache",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x1b,
	},
	{
		.pme_name = "SW_count_NOP1",
		.pme_desc = "Retired, non-annulled special software NOP instructions (which is equivalent to 'sethi %hi(0xfc000), %g0' instruction)",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x1c,
	},
	{
		.pme_name = "IU_stat_br_miss_untaken",
		.pme_desc = "Number of retired non-annulled conditional branches that were predicted to be not taken, but in fact were taken",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x1d,
	},
	{
		.pme_name = "IU_stat_br_count_taken",
		.pme_desc = "Number of retired non-annulled conditional branches that were taken",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x1e,
	},
	{
		.pme_name = "PC_miss",
		.pme_desc = "Number of cacheable FP loads that miss P-cache, irrespective of whether the loads hit or miss the D-cache",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x1f,
	},
	{
		.pme_name = "MC_writes_0_sh",
		.pme_desc = "Number of write requests complete to memory bank 0",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x20,
	},
	{
		.pme_name = "MC_writes_1_sh",
		.pme_desc = "Number of write requests complete to memory bank 1",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x21,
	},
	{
		.pme_name = "MC_writes_2_sh",
		.pme_desc = "Number of write requests complete to memory bank 2",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x22,
	},
	{
		.pme_name = "MC_writes_3_sh",
		.pme_desc = "Number of write requests complete to memory bank 3",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x23,
	},
	{
		.pme_name = "MC_stalls_1_sh",
		.pme_desc = "Number of processor cycles that requests were stalled in the MCU queues because bank 0 was busy with a previous requests",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x24,
	},
	{
		.pme_name = "MC_stalls_3_sh",
		.pme_desc = "Number of processor cycles that requests were stalled in the MCU queues because bank 3 was busy with a previous requests",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x25,
	},
	{
		.pme_name = "Re_RAW_miss",
		.pme_desc = "Stall cycles due to recirculation when there is a load instruction in the E-stage of the pipeline which has a non-bypassable read-after-write (RAW) hazard with an earlier store instruction",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x26,
	},
	{
		.pme_name = "FM_pipe_completion",
		.pme_desc = "Number of retired instructions that complete execution on the FLoat-Point/Graphics Multiply pipeline",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x27,
	},
	{
		.pme_name = "SSM_L3_miss_mtag_remote",
		.pme_desc = "Number of L3 cache misses to LPA (local physical address) from this core which generate retry (R_*) transactions including R_RTS, R_RTO, and R_RS",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x28,
	},
	{
		.pme_name = "SSM_L3_miss_remote",
		.pme_desc = "Number of L3 cache misses from this core which generate retry (R_*) transactions to non-LPA (non-local physical address) address space, or R_WS transactions due to block store (BST) / block store commit (BSTC) to any address space (LPA or non-LPA), or R_RTO due to atomic request on Os state to LPA space.",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x29,
	},
	{
		.pme_name = "SW_pf_exec",
		.pme_desc = "Number of retired, non-trapping software prefetch instructions that completed, i.e. number of retired prefetch instructions that were not dropped due to the prefecth queue being full",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x2a,
	},
	{
		.pme_name = "SW_pf_str_exec",
		.pme_desc = "Number of retired, non-trapping strong prefetch instructions that completed",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x2b,
	},
	{
		.pme_name = "SW_pf_dropped",
		.pme_desc = "Number of software prefetch instructions dropped due to TLB miss or due to the prefetch queue being full",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x2c,
	},
	{
		.pme_name = "SW_pf_L2_installed",
		.pme_desc = "Number of software prefetch instructions that installed lines in the L2 cache",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x2d,
	},
	{
		.pme_name = "L2_HW_pf_miss",
		.pme_desc = "Number of L2 cache misses by hardware prefetch requests from this core",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x2f,
	},
	{
		.pme_name = "L3_miss",
		.pme_desc = "Number of L3 cache misses sent out to SIU from this core by cacheable I-cache, D-cache, P-cache, and W-cache (exclusing block stores) requests",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x31,
	},
	{
		.pme_name = "L3_IC_miss",
		.pme_desc = "Number of L3 cache misses by cacheable I-cache requests from this core",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x32,
	},
	{
		.pme_name = "L3_SW_pf_miss",
		.pme_desc = "Number of L3 cache misses by software prefetch requests from this core",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x33,
	},
	{
		.pme_name = "L3_hit_other_half",
		.pme_desc = "Number of L3 cache hits from this core to the ways filled by the other core when the cache is in pseudo-split mode",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x34,
	},
	{
		.pme_name = "L3_wb",
		.pme_desc = "Number of L3 cache lines that were written back because of requests from this core",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x35,
	},
	{
		.pme_name = "L3_wb_sh",
		.pme_desc = "Number of L3 cache lines that were written back because of requests from both cores",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x36,
	},
	{
		.pme_name = "L2L3_snoop_cb_sh",
		.pme_desc = "Total number of L2 and L3 cache lines that were copied back due to other processors",
		.pme_ctrl = PME_CTRL_S1,
		.pme_val = 0x37,
	},
};
#define PME_ULTRA4PLUS_EVENT_COUNT	   (sizeof(ultra4plus_pe)/sizeof(pme_sparc_entry_t))
