# -*- autoconf -*-
#
# Copyright (c) 2011-2015 The University of Tennessee and The University
#                         of Tennessee Research Foundation.  All rights
#                         reserved.
# Copyright (c) 2011-2015 INRIA.  All rights reserved.
# Copyright (c) 2011-2015 Universite Bordeaux 1
# Copyright (c) 2015      Cisco Systems, Inc.  All rights reserved.
# Copyright (c) 2015      Intel, Inc. All rights reserved.
# Copyright (c) 2019      Research Organization for Information Science
#                         and Technology (RIST).  All rights reserved.
# Copyright (c) 2020-2022 Amazon.com, Inc. or its affiliates.  All Rights reserved.
# Copyright (c) 2021      Google, LLC. All rights reserved.
# $COPYRIGHT$
#
# Additional copyrights may follow
#
# $HEADER$
#

AC_DEFUN([OPAL_CONFIG_TREEMATCH], [
    OPAL_VAR_SCOPE_PUSH(treematch_builddir)

    AC_ARG_WITH([treematch],
                [AS_HELP_STRING([--with-treematch],
                                [Build TreeMatch topology support.  Building against an external TreeMatch is no longer supported, so valid values are "yes" or "no".])],
		    [], [with_treematch=yes])

    AS_IF([test "$with_treematch" != "yes" -a "$with_treematch" != "no"],
          [AC_MSG_ERROR([Valid values for --with-treematch are yes or no.])])

    treematch_builddir="${OMPI_TOP_BUILDDIR}/3rd-party/treematch"

    AS_IF([test "${opal_config_treematch_run_once}" != "yes"],
          [AS_IF([! test -d ${treematch_builddir}],
                 [mkdir -p ${treematch_builddir}])

           cat > ${treematch_builddir}/config.h << EOF
/*
 * This file is automatically generated by configure.  Edits will be lost
 *
 * This is an dummy config.h in order to prevent the embedded treematch from using
 * the config.h from the embedded hwloc
 *
 * see https://github.com/open-mpi/ompi/pull/6185#issuecomment-458807930
 */
EOF

           AC_CONFIG_FILES([3rd-party/treematch/Makefile])
           OPAL_3RDPARTY_DIST_SUBDIRS="$OPAL_3RDPARTY_DIST_SUBDIRS treematch"

           AS_IF([test "${with_treematch}" = "yes"],
                 [OPAL_3RDPARTY_SUBDIRS="$OPAL_3RDPARTY_SUBDIRS treematch"])

           opal_config_treematch_run_once=yes])

    $1_CPPFLAGS="-I$OMPI_TOP_SRCDIR/3rd-party/treematch"
    $1_LIBS="${OMPI_TOP_BUILDDIR}/3rd-party/treematch/libtreematch.la"

    AS_IF([test "${with_treematch}" = "yes"],
          [$2],
          [AC_MSG_NOTICE([Treematch explicitly disabled via --with-treematch=no])
           $3])

    OPAL_VAR_SCOPE_POP
])
