/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_AssociatedProcessorCoreCacheMemory.h"

CMPIObjectPath* CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_AssociatedProcessorCoreCacheMemory& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_AssociatedProcessorCoreCacheMemory_classnames[0], OpenDRIM_AssociatedProcessorCoreCacheMemory_NAMESPACE);

	if (!instance.Antecedent_isNULL)
		op.addKey("Antecedent", instance.Antecedent);

	if (!instance.Dependent_isNULL)
		op.addKey("Dependent", instance.Dependent);

	_L_;
	return op.getHdl();
}

CMPIInstance* CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_AssociatedProcessorCoreCacheMemory& instance) {
	_E_;
	Objectpath op(broker, CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Level_isNULL)
		ci.setProperty("Level", instance.Level);

	if (!instance.OtherLevelDescription_isNULL)
		ci.setProperty("OtherLevelDescription", instance.OtherLevelDescription);

	if (!instance.WritePolicy_isNULL)
		ci.setProperty("WritePolicy", instance.WritePolicy);

	if (!instance.OtherWritePolicyDescription_isNULL)
		ci.setProperty("OtherWritePolicyDescription", instance.OtherWritePolicyDescription);

	if (!instance.CacheType_isNULL)
		ci.setProperty("CacheType", instance.CacheType);

	if (!instance.OtherCacheTypeDescription_isNULL)
		ci.setProperty("OtherCacheTypeDescription", instance.OtherCacheTypeDescription);

	if (!instance.LineSize_isNULL)
		ci.setProperty("LineSize", instance.LineSize);

	if (!instance.ReplacementPolicy_isNULL)
		ci.setProperty("ReplacementPolicy", instance.ReplacementPolicy);

	if (!instance.OtherReplacementPolicyDescription_isNULL)
		ci.setProperty("OtherReplacementPolicyDescription", instance.OtherReplacementPolicyDescription);

	if (!instance.ReadPolicy_isNULL)
		ci.setProperty("ReadPolicy", instance.ReadPolicy);

	if (!instance.OtherReadPolicyDescription_isNULL)
		ci.setProperty("OtherReadPolicyDescription", instance.OtherReadPolicyDescription);

	if (!instance.FlushTimer_isNULL)
		ci.setProperty("FlushTimer", instance.FlushTimer);

	if (!instance.Associativity_isNULL)
		ci.setProperty("Associativity", instance.Associativity);

	if (!instance.OtherAssociativityDescription_isNULL)
		ci.setProperty("OtherAssociativityDescription", instance.OtherAssociativityDescription);

	_L_;
	return ci.getHdl();
}

void CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_AssociatedProcessorCoreCacheMemory& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Antecedent", instance.Antecedent) == OK)
		instance.Antecedent_isNULL = false;

	if (op.getKey("Dependent", instance.Dependent) == OK)
		instance.Dependent_isNULL = false;

	_L_;
}

void CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_AssociatedProcessorCoreCacheMemory& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Antecedent", instance.Antecedent) == OK)
		instance.Antecedent_isNULL = false;

	if (inst.getProperty("Dependent", instance.Dependent) == OK)
		instance.Dependent_isNULL = false;

	if (inst.getProperty("Level", instance.Level) == OK)
		instance.Level_isNULL = false;

	if (inst.getProperty("OtherLevelDescription", instance.OtherLevelDescription) == OK)
		instance.OtherLevelDescription_isNULL = false;

	if (inst.getProperty("WritePolicy", instance.WritePolicy) == OK)
		instance.WritePolicy_isNULL = false;

	if (inst.getProperty("OtherWritePolicyDescription", instance.OtherWritePolicyDescription) == OK)
		instance.OtherWritePolicyDescription_isNULL = false;

	if (inst.getProperty("CacheType", instance.CacheType) == OK)
		instance.CacheType_isNULL = false;

	if (inst.getProperty("OtherCacheTypeDescription", instance.OtherCacheTypeDescription) == OK)
		instance.OtherCacheTypeDescription_isNULL = false;

	if (inst.getProperty("LineSize", instance.LineSize) == OK)
		instance.LineSize_isNULL = false;

	if (inst.getProperty("ReplacementPolicy", instance.ReplacementPolicy) == OK)
		instance.ReplacementPolicy_isNULL = false;

	if (inst.getProperty("OtherReplacementPolicyDescription", instance.OtherReplacementPolicyDescription) == OK)
		instance.OtherReplacementPolicyDescription_isNULL = false;

	if (inst.getProperty("ReadPolicy", instance.ReadPolicy) == OK)
		instance.ReadPolicy_isNULL = false;

	if (inst.getProperty("OtherReadPolicyDescription", instance.OtherReadPolicyDescription) == OK)
		instance.OtherReadPolicyDescription_isNULL = false;

	if (inst.getProperty("FlushTimer", instance.FlushTimer) == OK)
		instance.FlushTimer_isNULL = false;

	if (inst.getProperty("Associativity", instance.Associativity) == OK)
		instance.Associativity_isNULL = false;

	if (inst.getProperty("OtherAssociativityDescription", instance.OtherAssociativityDescription) == OK)
		instance.OtherAssociativityDescription_isNULL = false;

	_L_;
}

