/* key_data.c
 *
 * Copyright (C) 2006-2021 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

#include "key_data.h"

/*-------------------------------------------------------------------------
      TSIP v1.09 or later
--------------------------------------------------------------------------*/
#if defined(WOLFSSL_RENESAS_TSIP_TLS) && (WOLFSSL_RENESAS_TSIP_VER >=109)

const st_key_block_data_t g_key_block_data =
{
    /* uint8_t encrypted_provisioning_key[R_TSIP_AES_CBC_IV_BYTE_SIZE * 2]; */
    {
        0xE9, 0x67, 0x79, 0xF7, 0x38, 0x73, 0xC8, 0x59, 0x94, 0x62, 0x7D, 0xB9,
        0x83, 0xDE, 0x59, 0x4A, 0x92, 0x53, 0x6B, 0x14, 0x1B, 0x2A, 0x99, 0xDF,
        0x95, 0xFD, 0x35, 0x84, 0x93, 0xCE, 0xDB, 0x10
    },
    /* uint8_t iv[R_TSIP_AES_CBC_IV_BYTE_SIZE]; */
    {
        0xF6, 0xA9, 0x83, 0x5A, 0xA1, 0x65, 0x1D, 0x28, 0xC8, 0x1A, 0xA6, 0x9D, 
        0x34, 0xB2, 0x4D, 0x92
    },
    /* 
     * uint8_t 
     * encrypted_user_rsa2048_ne_key[R_TSIP_RSA2048_NE_KEY_BYTE_SIZE + 16];
     */
    {
        0x34, 0x59, 0xFF, 0xFE, 0xAA, 0xE9, 0x26, 0x60, 0x8C, 0xB8, 0x76, 0xD2, 
        0x98, 0x65, 0x72, 0x3B, 0x19, 0x78, 0xB8, 0x9B, 0x0D, 0xD4, 0xFC, 0x2A, 
        0xF8, 0x54, 0x3B, 0x75, 0x0E, 0x40, 0x21, 0xF5, 0xF2, 0x6D, 0x3F, 0x60, 
        0xD2, 0xDF, 0xE7, 0xDB, 0x67, 0xF1, 0xC7, 0x66, 0x5F, 0x37, 0xAF, 0x9D,
        0x08, 0xE7, 0xFD, 0xEF, 0x63, 0xA9, 0x78, 0x73, 0x1A, 0xE2, 0x47, 0x91,
        0xB5, 0xA0, 0xCE, 0xA2, 0xC7, 0x4F, 0x8A, 0xE5, 0x03, 0x6F, 0xC5, 0xB8, 
        0xC4, 0x40, 0x12, 0x2D, 0x37, 0x2F, 0xF2, 0xC5, 0x73, 0x2D, 0xF8, 0xBF, 
        0x4A, 0xDC, 0xB7, 0x98, 0xDF, 0xE8, 0xED, 0xF8, 0x3B, 0x24, 0x8A, 0x01,
        0xAE, 0x64, 0x89, 0x9C, 0x79, 0x66, 0x99, 0xE4, 0xF8, 0xC1, 0x3E, 0x04, 
        0x56, 0x1E, 0x6E, 0xBA, 0x2D, 0xAA, 0xB9, 0xE8, 0xA0, 0xC2, 0x27, 0xCF, 
        0x7C, 0x0F, 0xAD, 0x0A, 0x22, 0xEE, 0x61, 0xA8, 0x32, 0xBE, 0xEE, 0xE7, 
        0x3F, 0x5D, 0xE5, 0xBD, 0x75, 0x6B, 0x35, 0xC1, 0x77, 0xCC, 0x7D, 0x0E,
        0x2E, 0x26, 0x67, 0xC4, 0x0E, 0x84, 0x34, 0xBD, 0x33, 0xB3, 0x0C, 0xD9,
        0x07, 0xE5, 0x8E, 0x3E, 0x7E, 0xCC, 0x56, 0x5D, 0x23, 0x5A, 0x96, 0x83, 
        0x0C, 0xD9, 0x7F, 0xB0, 0xF7, 0x53, 0xD9, 0x5C, 0xE2, 0x1B, 0xDA, 0x63, 
        0x62, 0x19, 0x16, 0x9D, 0x75, 0x7B, 0xBB, 0x7E, 0xC9, 0xB5, 0xAD, 0x7D,
        0xBB, 0x5A, 0xFA, 0xA5, 0x5B, 0x54, 0xA1, 0x93, 0x6D, 0x53, 0x3C, 0x85, 
        0x69, 0x00, 0x15, 0x40, 0x0E, 0x54, 0xD2, 0xBA, 0xB5, 0x80, 0x1C, 0x25, 
        0x85, 0x0E, 0x60, 0x87, 0x2A, 0x1A, 0xE7, 0x60, 0xCB, 0x6A, 0xF5, 0xAF, 
        0x84, 0x4B, 0xB7, 0x0D, 0x0C, 0xC0, 0xB5, 0x02, 0xB2, 0x38, 0x9D, 0x7C,
        0xFA, 0x31, 0xF3, 0x50, 0xB3, 0x32, 0x69, 0x3A, 0x3C, 0x7A, 0xA5, 0x67, 
        0x19, 0x66, 0xD5, 0x62, 0xA3, 0xF2, 0xF7, 0x77, 0x73, 0xF6, 0xE7, 0x8D, 
        0x51, 0x0C, 0x19, 0xA3, 0x0F, 0x8C, 0x79, 0xE0, 0x7C, 0xCF, 0x8A, 0x03, 
        0x70, 0xC7, 0x25, 0x9D, 0xCE, 0x89, 0x77, 0x8E, 0x4C, 0xE6, 0x97, 0xC8
    },
    /* uint8_t encrypted_user_update_key[R_TSIP_AES256_KEY_BYTE_SIZE + 16]; */
    {
        0x69, 0xDB, 0xC6, 0x86, 0xA5, 0x06, 0x22, 0x59, 0x11, 0x14, 0x73, 0x56,
        0x3A, 0x9E, 0x44, 0xC3, 0x9C, 0xA8, 0x76, 0xC6, 0xF6, 0xE8, 0xD8, 0xE2,
        0x17, 0x66, 0x90, 0x65, 0x08, 0xB5, 0x39, 0x7F, 0xD5, 0xC5, 0x6F, 0xD1,
        0xCB, 0xFB, 0xB2, 0x76, 0x33, 0xA1, 0x22, 0x0F, 0xBE, 0x83, 0x91, 0x24
    },

};

/* Public key type of CA root cert: 0: RSA-2048 2: ECDSA-P256*/
#if defined(USE_ECC_CERT)
const uint32_t              encrypted_user_key_type =
                                    R_TSIP_TLS_PUBLIC_KEY_TYPE_ECDSA_P256;
#else
const uint32_t              encrypted_user_key_type =
                                    R_TSIP_TLS_PUBLIC_KEY_TYPE_RSA2048;
#endif

const unsigned char ca_ecc_cert_der_sig[] =
{
    0x81, 0x87, 0x55, 0x02, 0x9c, 0xf8, 0x0b, 0x5c, 0x69, 0xba, 0x4b, 0xe9, 
    0x51, 0x19, 0x7b, 0x3c,	0x22, 0xaf, 0x6b, 0xd5, 0x23, 0x80, 0x64, 0xb8,
    0x1e, 0xe7, 0x99, 0xab, 0x89, 0x6d, 0xff, 0x93,	0xe1, 0xb5, 0xd8, 0x8d,
    0x7f, 0x53, 0xe7, 0x74, 0x8a, 0xd6, 0x06, 0x6a, 0x61, 0x2a, 0xab, 0x4a,
	0x65, 0x0d, 0x28, 0xbd, 0xc7, 0x92, 0x70, 0xd8, 0x79, 0xdc, 0xf7, 0xd2,
    0xf7, 0xf9, 0xa9, 0x13,	0x16, 0x5f, 0x4d, 0x4b, 0xae, 0x12, 0x5b, 0xfe,
    0x08, 0x09, 0x26, 0x1f, 0xae, 0x15, 0xd9, 0x16,	0x51, 0x4a, 0x92, 0xfe, 
    0x61, 0xeb, 0x6a, 0x82, 0x8c, 0xf8, 0xa8, 0x94, 0x26, 0x81, 0x9b, 0xb8,
	0x74, 0xd6, 0x32, 0x2b, 0x6f, 0xa6, 0xad, 0x9a, 0x91, 0x63, 0xe6, 0x03,
    0x5f, 0x25, 0xee, 0xc2,	0xfd, 0x54, 0x58, 0x13, 0xee, 0x53, 0xae, 0xe3, 
    0xda, 0x6b, 0xb5, 0x08, 0x45, 0xbe, 0xf2, 0xa8,	0x22, 0x92, 0x53, 0x8c,
    0xa4, 0xd9, 0xb6, 0x4e, 0xb9, 0xbf, 0x76, 0xb0, 0x96, 0x9f, 0xd7, 0xf6,
	0x53, 0xf3, 0x65, 0xf0, 0xe7, 0xff, 0xe8, 0x93, 0x2d, 0xc2, 0x08, 0x91,
    0xf8, 0x27, 0x33, 0x92,	0x95, 0x23, 0x1e, 0x6e, 0xd1, 0x91, 0x50, 0xc6,
    0x06, 0xb1, 0x16, 0x69, 0xee, 0xcf, 0xad, 0xc9,	0x4b, 0xf2, 0x38, 0x65,
    0x1d, 0xa9, 0xff, 0xd3, 0xf4, 0xd5, 0x84, 0xa9, 0xdd, 0xa7, 0x04, 0x77,
	0x64, 0xb5, 0xed, 0xe8, 0x0c, 0x15, 0x77, 0x7e, 0xfc, 0x02, 0xdd, 0x4e,
    0xf1, 0xd1, 0x36, 0xfe,	0xac, 0x3f, 0x5c, 0xd3, 0xdf, 0x51, 0xa3, 0x5c,
    0x8d, 0xed, 0x9f, 0x8d, 0xc8, 0xa7, 0xff, 0x46,	0xbc, 0x1d, 0x83, 0x12,
    0x4f, 0x49, 0xaa, 0xf5, 0xd1, 0x04, 0xc8, 0xee, 0x95, 0xda, 0xa0, 0x61,
	0x28, 0xff, 0x25, 0x8c, 0xfc, 0x35, 0x8f, 0xdc, 0x00, 0x47, 0x01, 0xfd,
    0x7c, 0xed, 0x05, 0xff
};
const int sizeof_ca_ecc_cert_sig = sizeof(ca_ecc_cert_der_sig);

/* ./ca-cert.der.sign,  */
const unsigned char ca_cert_der_sig[] =
{
	0x0E, 0xC3, 0x9B, 0x77, 0xF8, 0x58, 0x08, 0x9E, 0x5D, 0x1E, 0x03, 0x8D,
    0x60, 0xD1, 0xF6, 0x3E, 0x3D, 0xFF, 0x89, 0x4C, 0x91, 0x5C, 0x00, 0xEB,
    0x05, 0xE5, 0x65, 0x62, 0x17, 0xFB, 0xD4, 0x52,	0x69, 0x9D, 0xB8, 0x07,
    0xAF, 0xA9, 0x4C, 0xA5, 0xB9, 0x8D, 0x52, 0xC0, 0xF3, 0x34, 0x13, 0x67,
	0x40, 0xAA, 0xE1, 0xA3, 0x9E, 0x5D, 0x0F, 0xCE, 0x87, 0xB0, 0x10, 0xB4,
    0x79, 0x8F, 0x84, 0x21,	0x81, 0xC2, 0xF9, 0xF7, 0xDB, 0xCB, 0x8F, 0xE4,
    0x9B, 0xF5, 0x85, 0x9D, 0x11, 0x04, 0xFB, 0xA7,	0xFD, 0x13, 0x6F, 0x02,
    0xA5, 0xBF, 0xE0, 0x89, 0x62, 0x5E, 0x24, 0x95, 0xF6, 0x01, 0x7D, 0x7F,
	0xB5, 0xD1, 0xDD, 0xF3, 0x3B, 0xD5, 0x04, 0x54, 0xE1, 0x8E, 0xA8, 0x3D,
    0x30, 0xB3, 0x35, 0x76,	0xAF, 0xA7, 0x94, 0xD7, 0x59, 0x82, 0x38, 0x2C,
    0xD6, 0x95, 0x57, 0xD1, 0xD5, 0x62, 0xB1, 0x69,	0x60, 0xCD, 0x3F, 0x7D,
    0x0E, 0x9F, 0x00, 0x21, 0x04, 0xFE, 0x43, 0xBD, 0x7D, 0x3D, 0xA7, 0x6B,
	0xC5, 0x82, 0x92, 0xDE, 0xB7, 0xA3, 0xD4, 0x7D, 0x3C, 0x14, 0x46, 0x28,
    0x50, 0xCA, 0x86, 0x9F,	0x66, 0x4C, 0xB0, 0x46, 0x46, 0x4D, 0x31, 0xD6,
    0x7B, 0xEC, 0xBA, 0xED, 0xA1, 0xF9, 0x88, 0x68,	0xB9, 0xA9, 0xDA, 0x88,
    0x63, 0x01, 0x95, 0x5B, 0x78, 0x38, 0x03, 0xD6, 0xDF, 0x86, 0xC4, 0x3E,
	0x3B, 0xCF, 0xED, 0x8B, 0x2A, 0x41, 0x49, 0x65, 0x3E, 0x2F, 0x45, 0x71,
    0xD8, 0x0B, 0xF1, 0xF0,	0xC7, 0xB5, 0x2E, 0xBE, 0xF0, 0x71, 0xDE, 0x40,
    0xB0, 0x54, 0x25, 0xD7, 0x4A, 0x86, 0xF1, 0xB9,	0xF6, 0xAB, 0x07, 0x07,
    0x21, 0x7C, 0x15, 0x7B, 0x1F, 0xCF, 0xE4, 0x1F, 0x0B, 0xEB, 0x0E, 0x96,
	0xE5, 0x59, 0x34, 0xC6, 0x4B, 0x1B, 0xF6, 0xC7, 0x6C, 0x4C, 0x16, 0x43,
    0x72, 0xAF, 0x82, 0x1E
};
const int sizeof_ca_cert_sig = sizeof(ca_cert_der_sig);
/* ./client-cert.der.sign,  */
const unsigned char client_cert_der_sign[] =
{
        0x5D, 0x1F, 0x89, 0x41, 0xEC, 0x47, 0xC8, 0x90, 0x61, 0x79,
        0x8A, 0x16, 0x1F, 0x31, 0x96, 0x67, 0xD9, 0x3C, 0xEC, 0x6B,
        0x58, 0xC6, 0x5A, 0xED, 0x99, 0xB3, 0xEF, 0x27, 0x6F, 0x04,
        0x8C, 0xD9, 0x68, 0xB1, 0xD6, 0x23, 0x15, 0x84, 0x00, 0xE1,
        0x27, 0xD1, 0x1F, 0x68, 0xB7, 0x3F, 0x13, 0x53, 0x8A, 0x95,
        0x5A, 0x20, 0x7C, 0xB2, 0x76, 0x5B, 0xDC, 0xE0, 0xA6, 0x21,
        0x7C, 0x49, 0xCF, 0x93, 0xBA, 0xD5, 0x12, 0x9F, 0xEE, 0x90,
        0x5B, 0x3F, 0xA3, 0x9D, 0x13, 0x72, 0xAC, 0x72, 0x16, 0xFE,
        0x1D, 0xBE, 0xEB, 0x8E, 0xC7, 0xDC, 0xC4, 0xF8, 0x1A, 0xD8,
        0xA0, 0xA4, 0xF6, 0x04, 0x30, 0xF6, 0x7E, 0xB6, 0xC8, 0xE1,
        0xAB, 0x88, 0x37, 0x08, 0x63, 0x72, 0xAA, 0x46, 0xCC, 0xCA,
        0xF0, 0x9E, 0x02, 0x1E, 0x65, 0x67, 0xFF, 0x2C, 0x9D, 0x81,
        0x6C, 0x1E, 0xF1, 0x54, 0x05, 0x68, 0x68, 0x18, 0x72, 0x26,
        0x55, 0xB6, 0x2C, 0x95, 0xC0, 0xC9, 0xB2, 0xA7, 0x0B, 0x60,
        0xD7, 0xEB, 0x1D, 0x08, 0x1A, 0xA2, 0x54, 0x15, 0x89, 0xCB,
        0x83, 0x21, 0x5D, 0x15, 0x9B, 0x38, 0xAC, 0x89, 0x63, 0xD5,
        0x4B, 0xF4, 0x8B, 0x47, 0x93, 0x78, 0x43, 0xCB, 0x9B, 0x71,
        0xBF, 0x94, 0x76, 0xB5, 0xCE, 0x35, 0xA9, 0x1A, 0xD5, 0xA5,
        0xD8, 0x19, 0xA6, 0x04, 0x39, 0xB1, 0x09, 0x8C, 0x65, 0x02,
        0x58, 0x3A, 0x95, 0xEF, 0xA2, 0xC3, 0x85, 0x18, 0x61, 0x23,
        0x2D, 0xC5, 0xCD, 0x62, 0xC1, 0x19, 0x31, 0xE5, 0x36, 0x95,
        0x22, 0xDB, 0x3E, 0x1A, 0x3C, 0xE8, 0xC6, 0x2E, 0xDF, 0xD9,
        0x2F, 0x84, 0xC1, 0xF0, 0x38, 0x2B, 0xE5, 0x73, 0x35, 0x4F,
        0x05, 0xE2, 0xA5, 0x60, 0x79, 0xB0, 0x23, 0xDC, 0x56, 0x4C,
        0xE7, 0xD9, 0x1F, 0xCF, 0x6A, 0xFC, 0x55, 0xEB, 0xAA, 0x48,
        0x3E, 0x95, 0x2A, 0x10, 0x01, 0x05
};
const int sizeof_client_cert_der_sign = sizeof(client_cert_der_sign);

uint32_t s_inst1[R_TSIP_SINST_WORD_SIZE] = { 0 };
uint32_t s_inst2[R_TSIP_SINST2_WORD_SIZE]= { 0 };
#endif
