/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.sql.SQLException;
import org.postgresql.Driver;
import org.postgresql.core.BaseConnection;
import org.postgresql.jdbc.AbstractBlobClob;

public class PgClob
extends AbstractBlobClob
implements Clob {
    public PgClob(BaseConnection conn, long oid) throws SQLException {
        super(conn, oid);
    }

    public synchronized Reader getCharacterStream(long pos, long length) throws SQLException {
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "getCharacterStream(long, long)");
    }

    public synchronized int setString(long pos, String str) throws SQLException {
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "setString(long,str)");
    }

    public synchronized int setString(long pos, String str, int offset, int len) throws SQLException {
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "setString(long,String,int,int)");
    }

    public synchronized OutputStream setAsciiStream(long pos) throws SQLException {
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "setAsciiStream(long)");
    }

    public synchronized Writer setCharacterStream(long pos) throws SQLException {
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "setCharacteStream(long)");
    }

    public synchronized InputStream getAsciiStream() throws SQLException {
        return this.getBinaryStream();
    }

    public synchronized Reader getCharacterStream() throws SQLException {
        Charset connectionCharset = Charset.forName(this.conn.getEncoding().name());
        return new InputStreamReader(this.getBinaryStream(), connectionCharset);
    }

    public synchronized String getSubString(long i2, int j2) throws SQLException {
        this.assertPosition(i2, j2);
        this.getLo(false).seek((int)i2 - 1);
        return new String(this.getLo(false).read(j2));
    }

    public synchronized long position(String pattern, long start) throws SQLException {
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "position(String,long)");
    }

    public synchronized long position(Clob pattern, long start) throws SQLException {
        this.checkFreed();
        throw Driver.notImplemented(this.getClass(), "position(Clob,start)");
    }
}

