package org.jboss.cache.profiling;

import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.testng.annotations.Test;

/**
 * Profile LOCAL mode operation
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.2.0
 */
@Test(groups = "profiling")
public class ConstructionTest
{
   Cache cache;
   private static final int WARMUP = 1000;
   private static final int LOOPS = 5000;

   public void testConstruction() throws InterruptedException
   {
      for (int i = 0; i < WARMUP; i++) new DefaultCacheFactory().createCache();
      System.out.println("Finished warmup.");
      System.gc();
      Thread.sleep(1000);
      System.out.println("Starting test");
      doConstructionTest();
   }

   public void doConstructionTest()
   {
      for (int i = 0; i < LOOPS; i++)
      {
         new DefaultCacheFactory().createCache();
         if (i % 100 == 0) System.out.println("In loop num " + i);
      }
   }
}
