package org.jboss.cache.commands;

import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestCacheConfigurationFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

import javax.transaction.TransactionManager;

/**
 * @author Mircea.Markus@jboss.com
 * @since 2.2
 */
@Test(groups = "functional")
public class RollbackOnNoOpTest
{
   private CacheSPI<Object, Object> cache;
   private TransactionManager txMgr;

   @BeforeMethod(alwaysRun = true)
   public void setUp()
   {
      Configuration cacheConfig = UnitTestCacheConfigurationFactory.createConfiguration(Configuration.CacheMode.LOCAL, false);
      cache = (CacheSPI<Object, Object>) new DefaultCacheFactory().createCache(cacheConfig, false);
      cache.start();
      txMgr = cache.getTransactionManager();
   }

   @AfterMethod(alwaysRun = true)
   public void tearDown()
   {
      cache.stop();
      cache.destroy();
   }

   public void testRollbackOnRemoveNodeDoesNotFail() throws Exception
   {
      txMgr.begin();
      cache.remove("/blah/blah", "non-exist");
      txMgr.rollback();
   }

   public void testRollbackOnClearData() throws Exception
   {
      txMgr.begin();
      cache.clearData("/blah/blah");
      txMgr.rollback();
   }

   public void testCreateNodeCommand() throws Exception
   {
      cache.put("/blah/blah", "key", "value");
      txMgr.begin();
      cache.clearData("/blah/blah");
      txMgr.rollback();
      assert cache.get("/blah/blah", "key") != null;
   }

   public void testRemoveKeyCommand() throws Exception
   {
      txMgr.begin();
      cache.remove("/blah/blah", "key");
      txMgr.rollback();
   }

   public void testRemoveNodeCommand() throws Exception
   {
      cache.put("/blah/blah", "key", "value");
      txMgr.begin();
      cache.removeNode("/blah");
      txMgr.rollback();
   }
}
