package org.jboss.cache.factories;

import org.jboss.cache.cluster.ReplicationQueue;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.annotations.DefaultFactoryFor;

/**
 * RPCManager factory
 *
 * @author Manik Surtani (<a href="mailto:manik@jboss.org">manik@jboss.org</a>)
 * @since 2.1.0
 */
@DefaultFactoryFor(classes = ReplicationQueue.class)
public class ReplicationQueueFactory extends EmptyConstructorFactory
{
   @Override
   public <T> T construct(Class<T> componentType)
   {
      if ((configuration.getCacheMode() == Configuration.CacheMode.REPL_ASYNC || configuration.getCacheMode() == Configuration.CacheMode.INVALIDATION_ASYNC)
            && configuration.isUseReplQueue())
      {
         return super.construct(componentType);
      }
      else
      {
         return null;
      }
   }
}