/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.config.ConfigurationException;

/**
 * Configuration for {@link MRUPolicy}.
 * <p/>
 * If configured via XML, expects the following:
 * <p/>
 * <pre>
 * <region name="abc">
 *   <attribute name="maxNodes">1000</attribute>
 * </region>
 * </pre>
 * <p/>
 * Requires a "maxNodes" attribute otherwise a ConfigurationException is thrown.
 *
 * @author Daniel Huang (dhuang@jboss.org)
 * @version $Revision: 6120 $
 */
public class MRUConfiguration extends EvictionPolicyConfigBase
{
   /**
    * The serialVersionUID
    */
   private static final long serialVersionUID = -8734577898966155218L;

   public MRUConfiguration()
   {
      super();
      // We require that maxNodes is set
      setMaxNodes(-1);
   }

   @Override
   protected void setEvictionPolicyClassName()
   {
      setEvictionPolicyClass(MRUPolicy.class.getName());
   }


   /**
    * Requires a positive maxNodes value or ConfigurationException
    * is thrown.
    */
   @Override
   public void validate() throws ConfigurationException
   {
      if (getMaxNodes() < 0)
         throw new ConfigurationException("maxNodes not configured");
   }

   @Override
   public String toString()
   {
      StringBuilder str = new StringBuilder();
      str.append("MRUConfiguration: ").
            append(" maxNodes =").append(getMaxNodes());
      return str.toString();
   }

   @Override
   public void reset()
   {
      setMaxNodes(-1);
   }

   @Override
   public MRUConfiguration clone() throws CloneNotSupportedException
   {
      return (MRUConfiguration) super.clone();
   }

}
