package org.jboss.cache.commands.read;

import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;

/**
 * Implements functionality defined by {@link org.jboss.cache.Cache#getKeys(org.jboss.cache.Fqn)}
 * <p/>
 * This is the equivalent of the old MethodCallDefinitions.getKeysMethodLocal method call from 2.1.x.
 * <p/>
 *
 * @author Mircea.Markus@jboss.com
 * @since 2.2.0
 */
public class GetKeysCommand extends AbstractDataCommand
{
   public static final int METHOD_ID = 25;

   public GetKeysCommand(Fqn fqn)
   {
      this.fqn = fqn;
   }

   public GetKeysCommand()
   {
   }

   /**
    * Retrieves Set of keys for all the data stored in a node referenced by the specified Fqn.
    *
    * @param ctx invocation context
    * @return a Set<K> of data keys contained in a node for a given Fqn, or null if the Fqn refers to a node that does not exist.
    */
   @SuppressWarnings("unchecked")
   public Object perform(InvocationContext ctx)
   {
      NodeSPI n = dataContainer.peek(fqn);
      if (n == null) return null;
      return n.getKeysDirect();
   }

   public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable
   {
      return visitor.visitGetKeysCommand(ctx, this);
   }

   public int getCommandId()
   {
      return METHOD_ID;
   }
}
