; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc  -O0 -mtriple=mipsel-linux-gnu -global-isel  -verify-machineinstrs %s -o -| FileCheck %s -check-prefixes=MIPS32

define i32 @outgoing_gpr(i32* %i32_ptr) {
; MIPS32-LABEL: outgoing_gpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $2, 0($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = load i32, i32* %i32_ptr
  ret i32 %0
}

define float @outgoing_fpr(float* %float_ptr) {
; MIPS32-LABEL: outgoing_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lwc1 $f0, 0($4)
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = load float, float* %float_ptr
  ret float %0
}

define i32 @outgoing_gpr_instr(i32* %i32_ptr1, i32* %i32_ptr2) {
; MIPS32-LABEL: outgoing_gpr_instr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $1, 0($4)
; MIPS32-NEXT:    lw $2, 0($5)
; MIPS32-NEXT:    addu $2, $2, $1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = load i32, i32* %i32_ptr1
  %1 = load i32, i32* %i32_ptr2
  %outgoing_instr = add i32 %1, %0
  ret i32 %outgoing_instr
}

define float @outgoing_fpr_instr(float* %float_ptr1, float* %float_ptr2) {
; MIPS32-LABEL: outgoing_fpr_instr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lwc1 $f0, 0($4)
; MIPS32-NEXT:    lwc1 $f1, 0($5)
; MIPS32-NEXT:    add.s $f0, $f0, $f1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = load float, float* %float_ptr1
  %1 = load float, float* %float_ptr2
  %outgoing_instr = fadd float %0, %1
  ret float %outgoing_instr
}

define i32 @incoming_gpr(i32 %incoming_phys_reg, i1 %test, i32* %a) {
; MIPS32-LABEL: incoming_gpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $1, 0($6)
; MIPS32-NEXT:    andi $2, $5, 1
; MIPS32-NEXT:    movn $4, $1, $2
; MIPS32-NEXT:    move $2, $4
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = load i32, i32* %a
  %cond = select i1 %test, i32 %0, i32 %incoming_phys_reg
  ret i32 %cond
}

define float @incoming_fpr(float %incoming_phys_reg, i1 %test, float* %a) {
; MIPS32-LABEL: incoming_fpr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lwc1 $f0, 0($6)
; MIPS32-NEXT:    andi $1, $5, 1
; MIPS32-NEXT:    movn.s $f12, $f0, $1
; MIPS32-NEXT:    mov.s $f0, $f12
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = load float, float* %a
  %cond = select i1 %test, float %0, float %incoming_phys_reg
  ret float %cond
}


define i32 @incoming_i32_instr(i32 %val1, i32 %val2, i32* %i32_ptr, i1 %test) {
; MIPS32-LABEL: incoming_i32_instr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lw $1, 0($6)
; MIPS32-NEXT:    addu $2, $5, $4
; MIPS32-NEXT:    andi $3, $7, 1
; MIPS32-NEXT:    movn $2, $1, $3
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = load i32, i32* %i32_ptr
  %incoming_instr = add i32 %val2, %val1
  %cond = select i1 %test, i32 %0, i32 %incoming_instr
  ret i32 %cond
}

define float @incoming_float_instr(float %val1, float %val2, float* %float_ptr, i1 %test) {
; MIPS32-LABEL: incoming_float_instr:
; MIPS32:       # %bb.0: # %entry
; MIPS32-NEXT:    lwc1 $f0, 0($6)
; MIPS32-NEXT:    add.s $f1, $f14, $f12
; MIPS32-NEXT:    andi $1, $7, 1
; MIPS32-NEXT:    movn.s $f1, $f0, $1
; MIPS32-NEXT:    mov.s $f0, $f1
; MIPS32-NEXT:    jr $ra
; MIPS32-NEXT:    nop
entry:
  %0 = load float, float* %float_ptr
  %incoming_instr = fadd float %val2, %val1
  %cond = select i1 %test, float %0, float %incoming_instr
  ret float %cond
}

