# ANGLE Development

ANGLE provides OpenGL ES 2.0 and EGL 1.4 libraries and dlls.  You can use these to build and run OpenGL ES 2.0 applications on Windows.

## Development setup

### Version Control
ANGLE uses git for version control. If you are not familiar with git, helpful documentation can be found at [http://git-scm.com/documentation](http://git-scm.com/documentation).

### Required Tools
On all platforms:

 * [depot_tools](http://dev.chromium.org/developers/how-tos/install-depot-tools)
   * Required to generate projects and build files, contribute patches, run the unit tests or build the shader compiler on non-Windows systems.

On Windows:

 * [Visual Studio Community 2015 Update 2](http://www.visualstudio.com/downloads/download-visual-studio-vs)
     Required to build ANGLE on Windows and for the packaged Windows 8.1 SDK.
 * [Cygwin's Bison, flex, and patch](https://cygwin.com/setup-x86_64.exe) (optional)
     This is only required if you need to modify GLSL ES grammar files (`glslang.l` and `glslang.y` under `src/compiler/translator`, or `ExpressionParser.y` and `Tokenizer.l` in `src/compiler/preprocessor`).
     Use the latest versions of bison, flex and patch from the 64-bit cygwin distribution.

On Linux:

 * The GCC or Clang compilers
 * Development packages for OpenGL, X11 and libpci
 * Bison and flex are not needed as we only support generating the translator grammar on Windows.

On MacOS:

 * [XCode](https://developer.apple.com/xcode/) for Clang and development files.
 * Bison and flex are not needed as we only support generating the translator grammar on Windows.

### Getting the source
Set the following environment variables as needed:

On Windows:

 * `GYP_GENERATORS` to `msvs` (other options include `ninja` and `make`)
 * `GYP_DEFINES` to `windows_sdk_path=YOUR_WIN_SDK_INSTALL_DIR` if you did not install the Windows 8.1 SDK in the default location.
 * `GYP_MSVS_VERSION` to `2015`

On Linux and MacOS:

 * `GYP_GENERATORS` to `ninja` (defaults to 'make' that pollutes your source directory)

Download the ANGLE source by running the following commands:

```
git clone https://chromium.googlesource.com/angle/angle
cd angle
python scripts/bootstrap.py
gclient sync
git checkout master
```

GYP will generate the project files, if you update ANGLE or make a change to the projects, they can be regenerated by executing `gclient runhooks`.

On Windows GYP will generate the main VS2015 solution file as gyp/ANGLE.sln. For generating a Windows Store version of ANGLE view the [Windows Store instructions](doc/BuildingAngleForWindowsStore.md).

On Linux and MacOS, GYP will generate the `out/Debug` and `out/Release` directories.

### Building ANGLE on Windows
 1. Open one of the ANGLE Visual Studio solution files (see [Getting the source](DevSetup.md#Development-setup-Getting-the-source)).
 2. Select Build -> Configuration Manager
 3. In the "Active solution configuration:" drop down, select the desired configuration (eg. Release), and close the Configuration Manager.
 4. Select Build -> Build Solution.
Once the build completes, the output directory for your selected configuration (eg. `Release_Win32`, located next to the solution file) will contain the required libraries and dlls to build and run an OpenGL ES 2.0 application.

### Building ANGLE on Linux and MacOS
Run `ninja -C out/Debug` or `ninja -C out/Release`. Ninja is provided by `depot_tools` so make sure you set up your `PATH` correctly.
Once the build completes, the `out/Debug` or `out/Release` directories will contain the .so or .dylib libraries and test binaries.

### Building ANGLE for Android
Presently, it is not possible to build standalone ANGLE for Android.
But, ANGLE for Android can be built within a Chromium checkout.
The reason for that is a dependency on Chromium for Android toolchain and that it only supports GN.
Also, it can only be built on Linux, as this is the only platfrom that Chromium for Android supports.
In theory, once ANGLE supports standalone GN build, it may be possible to put Chromium for Android toolchain in `third_party` or `buildtools` to build standalone ANGLE for Android.

But, for now, the steps in [Checking out and building Chromium for Android](https://chromium.googlesource.com/chromium/src/+/master/docs/android_build_instructions.md) should be followed to check out Chromium for Android and set up build environment.
Name your output directories `out/Debug` and `out/Release`, because Chromium GPU tests look for browser binaries in these folders. Replacing `out` with other names seems to be OK when working with multiple build configurations.
It's best to use a build configuration of some Android bot on [GPU.FYI waterfall](https://build.chromium.org/p/chromium.gpu.fyi/waterfall). Look for `generate_build_files` step output of that bot. Remove `goma_dir` flag.
For example, these are the build flags from Nexus 5X bot:
```
build_angle_deqp_tests = true
dcheck_always_on = true
ffmpeg_branding = "Chrome"
is_component_build = false
is_debug = false
proprietary_codecs = true
symbol_level = 1
target_cpu = "arm64"          # Nexus 5X is 64 bit, remove this on 32 bit devices
target_os = "android"
use_goma = true               # Remove this if you don't have goma
```

These ANGLE targets are supported:
`ninja -C out/Release translator libEGL libGLESv2 angle_unittests angle_end2end_tests angle_deqp_gles2_tests angle_deqp_gles3_tests angle_deqp_egl_tests`
In order to run ANGLE tests, prepend `bin/run_` to the test name, for example: `./out/Release/bin/run_angle_unittests`.
Additional details are in [Android Test Instructions](https://chromium.googlesource.com/chromium/src/+/master/docs/android_test_instructions.md).

In order to run GPU telemetry tests, build `chrome_public_apk` target. Then follow [GPU Testing](http://www.chromium.org/developers/testing/gpu-testing#TOC-Running-the-GPU-Tests-Locally) doc, using `--browser=android-chromium` argument. Make sure to set your `CHROMIUM_OUT_DIR` environment variable, so that your browser is found, otherwise the stock one will run.

Also, follow [How to build ANGLE in Chromium for dev](doc/BuildingAngleForChromiumDevelopment.md) to work with Top of Tree ANGLE in Chromium.

## Application Development with ANGLE
This sections describes how to use ANGLE to build an OpenGL ES application.

### Choosing a D3D Backend
ANGLE can use either a backing renderer which uses D3D11 on systems where it is available, or a D3D9-only renderer.

ANGLE provides an EGL extension called `EGL_ANGLE_platform_angle` which allows uers to select which renderer to use at EGL initialization time by calling eglGetPlatformDisplayEXT with special enums. Details of the extension can be found in it's specification in `extensions/ANGLE_platform_angle.txt` and `extensions/ANGLE_platform_angle_d3d.txt` and examples of it's use can be seen in the ANGLE samples and tests, particularly `util/EGLWindow.cpp`.

By default, ANGLE will use a D3D11 renderer. To change the default:

 1. Open `src/libANGLE/renderer/d3d/DisplayD3D.cpp`
 2. Locate the definition of `ANGLE_DEFAULT_D3D11` near the head of the file, and set it to your preference.

### To Use ANGLE in Your Application
On Windows:

 1. Configure your build environment to have access to the `include` folder to provide access to the standard Khronos EGL and GLES2 header files.
  * For Visual C++
     * Right-click your project in the _Solution Explorer_, and select _Properties_.
     * Under the _Configuration Properties_ branch, click _C/C++_.
     * Add the relative path to the Khronos EGL and GLES2 header files to _Additional Include Directories_.
 2. Configure your build environment to have access to `libEGL.lib` and `libGLESv2.lib` found in the build output directory (see [Building ANGLE](DevSteup.md#Building-ANGLE)).
   * For Visual C++
     * Right-click your project in the _Solution Explorer_, and select _Properties_.
     * Under the _Configuration Properties_ branch, open the _Linker_ branch and click _Input_.
     * Add the relative paths to both the `libEGL.lib` file and `libGLESv2.lib` file to _Additional Dependencies_, separated by a semicolon.
 3. Copy `libEGL.dll` and `libGLESv2.dll` from the build output directory (see [Building ANGLE](DevSetup.md#Building-ANGLE)) into your application folder.
 4. Code your application to the Khronos [OpenGL ES 2.0](http://www.khronos.org/registry/gles/) and [EGL 1.4](http://www.khronos.org/registry/egl/) APIs.

On Linux and MacOS, either:

 - Link you application against `libGLESv2` and `libEGL`
 - Use `dlopen` to load the OpenGL ES and EGL entry points at runtime.

## GLSL ES to GLSL Translator
In addition to OpenGL ES 2.0 and EGL 1.4 libraries, ANGLE also provides a GLSL ES to GLSL translator. This is useful for implementing OpenGL ES emulators on top of desktop OpenGL.

### Getting the source
The translator code is fully independent of the rest of ANGLE code and resides in `src/compiler`.  It is cross-platform and build files for operating systems other than Windows can be generated by following the `Generating project files` steps above.

### Usage
The basic usage is shown in `essl_to_glsl` sample under `samples/translator`. To translate a GLSL ES shader, following functions need to be called in the same order:

 * `ShInitialize()` initializes the translator library and must be called only once from each process using the translator.
 * `ShContructCompiler()` creates a translator object for vertex or fragment shader.
 * `ShCompile()` translates the given shader.
 * `ShDestruct()` destroys the given translator.
 * `ShFinalize()` shuts down the translator library and must be called only once from each process using the translator.
