#!/usr/bin/perl
use strict;
use warnings;
use Config::Tiny;
use WWW::Marvel::Client;

my ($conf_file) = @ARGV;
my $cfg = Config::Tiny->read($conf_file);

my $client = WWW::Marvel::Client->new({
		public_key  => $cfg->{auth}->{public_key},
		private_key => $cfg->{auth}->{private_key},
	});

my $res = $client->characters({ name => 'daredevil' });

my $data = $res->{data};
print_hash($data);
print "-" x 20,"\n";

my $results = $data->{results};
for my $r (@$results) {
	print $r->{name}, "\n";
	print_hash($r);
	last;
}

sub print_hash {
	my ($h) = @_;
	while (my ($k, $v) = each %$h) {
		print "$k : $v\n";
	}
}

