# Generated by default/object.tt
package Paws::NetworkManager::AWSLocation;
  use Moose;
  has SubnetArn => (is => 'ro', isa => 'Str');
  has Zone => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkManager::AWSLocation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkManager::AWSLocation object:

  $service_obj->Method(Att1 => { SubnetArn => $value, ..., Zone => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkManager::AWSLocation object:

  $result = $service_obj->Method(...);
  $result->Att1->SubnetArn

=head1 DESCRIPTION

Specifies a location in AWS.

=head1 ATTRIBUTES


=head2 SubnetArn => Str

The Amazon Resource Name (ARN) of the subnet the device is located in.


=head2 Zone => Str

The Zone the device is located in. This can be the ID of an
Availability Zone, Local Zone, Wavelength Zone, or an Outpost.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

