#!/usr/bin/perl

package eBay::API::XML::DataType::UnitOfMeasurementType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. UnitOfMeasurementType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::UnitOfMeasurementType

=head1 DESCRIPTION

Provides a mapping between suggested unit of measure strings and
other, less popular strings.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::UnitOfMeasurementType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'AlternateText', 'xs:string', '1', '', '' ]
	, [ 'SuggestedText', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAlternateText()

A synonym for the unit of measure (such as a fully spelled out name
like "inches" instead of the standard abbreviation).
This can be used to help a seller map unit names they use in their
own catalog to unit names that are more popular on eBay.

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setAlternateText {
  my $self = shift;
  $self->{'AlternateText'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getAlternateText()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getAlternateText {
  my $self = shift;
  return $self->_getDataTypeArray('AlternateText');
}


=head2 setSuggestedText()

The preferred way to specify a given unit of measure name, such as
"in." (instead of "inches" or the " (double quote) symbol).

#    Argument: 'xs:string'

=cut

sub setSuggestedText {
  my $self = shift;
  $self->{'SuggestedText'} = shift
}

=head2 getSuggestedText()

  Calls: GeteBayDetails
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getSuggestedText {
  my $self = shift;
  return $self->{'SuggestedText'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
