# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20251210153523;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '000',
                  'pattern' => '(\\d{8,10})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            3|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )|
            6[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3(?:
                [045]|
                9(?:
                  [0-58]|
                  6[4-9]|
                  7[0-35689]
                )
              )|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9[0169]
              )|
              3(?:
                [29]|
                60|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[2-57-9]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                7(?:
                  2[2-468]|
                  3[78]
                )|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              8294|
              96
            )[1-3]|
            2(?:
              57|
              93
            )[015-9]|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              8292|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[25-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '
          (?:
            601[0-4]0|
            [7-9]0[1-9]\\d\\d
          )\\d{5}
        ',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"818547", "掛合",
"818846", "丹生谷",
"81925", "福岡",
"817967", "八鹿",
"811655", "名寄",
"815987", "三瀬谷",
"812697", "飯山",
"81423", "国分寺",
"811752", "むつ",
"81797", "西宮",
"818295", "廿日市",
"812484", "白河",
"814996", "八丈島",
"819957", "加治木",
"81726", "茨木",
"812387", "長井",
"812675", "佐久",
"811974", "水沢",
"8161", "大阪",
"812787", "沼田",
"817997", "津名",
"815754", "関",
"811352", "余市",
"815972", "尾鷲",
"8188091", "窪川",
"818654", "鴨方",
"812588", "長岡",
"814289", "青梅",
"818265", "安芸吉田",
"81729", "八尾",
"818975", "新居浜",
"818208", "久賀",
"819784", "豊後高田",
"817618", "加賀",
"812372", "村山",
"811238", "栗山",
"819664", "人吉",
"81252", "新潟",
"819973", "種子島",
"81581", "高富",
"812676", "佐久",
"812743", "藤岡",
"814701", "鴨川",
"818296", "広島",
"81958", "長崎",
"81427", "相模原",
"81744", "大和高田",
"81893", "大洲",
"819592", "大瀬戸",
"819727", "臼杵",
"819824", "延岡",
"817904", "福崎",
"815999", "津",
"81793", "姫路",
"818845", "丹生谷",
"811934", "釜石",
"819678", "矢部",
"8112399", "栗山",
"811656", "美深",
"81555", "吉田",
"817459", "大和榛原",
"818552", "浜田",
"815563", "鰍沢青柳",
"818583", "倉吉",
"818266", "千代田",
"818976", "新居浜",
"819432", "八女",
"8182920", "廿日市",
"8198295", "日向",
"8112396", "栗山",
"812799", "長野原",
"819942", "大根占",
"812613", "大町",
"819933", "指宿",
"814297", "飯能",
"81263", "松本",
"811548", "弟子屈",
"811559", "帯広",
"815757", "郡上八幡",
"812551", "上越",
"812586", "長岡",
"817994", "洲本",
"811452", "早来",
"812784", "沼田",
"818657", "笠岡",
"81199", "盛岡",
"811545", "釧路",
"812973", "水海道",
"81952", "佐賀",
"811953", "二戸",
"817616", "小松",
"819787", "国東",
"811236", "千歳",
"8188097", "土佐清水",
"811982", "花巻",
"812472", "石川",
"819667", "水俣",
"818206", "柳井",
"812579", "小出",
"815984", "松阪",
"818673", "福渡",
"817964", "豊岡",
"817673", "羽咋",
"812957", "大子",
"818544", "木次",
"8153977", "天竜",
"812872", "大田原",
"81196", "盛岡",
"819675", "熊本一の宮",
"818848", "牟岐",
"812694", "中野",
"8162", "大阪",
"812384", "米沢",
"81225", "石巻",
"819809", "八重山",
"819954", "加治木",
"811852", "男鹿",
"812487", "須賀川",
"811977", "北上",
"8188098", "土佐清水",
"814998", "小笠原",
"8175", "京都",
"812562", "三条",
"818268", "千代田",
"8144", "川崎",
"81465", "小田原",
"818978", "伯方",
"818205", "柳井",
"812933", "高萩",
"817615", "小松",
"812930", "水戸",
"811235", "夕張",
"8186993", "備前",
"81963", "熊本",
"81531", "田原",
"81564", "岡崎",
"811546", "釧路",
"812899", "鹿沼",
"81774", "宇治",
"812585", "長岡",
"817712", "亀岡",
"815742", "美濃加茂",
"818298", "廿日市",
"8198290", "延岡",
"81834", "徳山",
"812678", "佐久",
"814229", "武蔵野三鷹",
"812832", "佐野",
"815733", "恵那",
"81734", "和歌山",
"814752", "茂原",
"819676", "高森",
"811658", "上川",
"819743", "三重",
"817907", "播磨山崎",
"819827", "高千穂",
"819724", "佐伯",
"819732", "日田",
"811937", "宮古",
"812555", "糸魚川",
"811536", "厚岸",
"81563", "西尾",
"818376", "美祢",
"814777", "船橋",
"811734", "五所川原",
"817713", "亀岡",
"81439", "木更津",
"817704", "敦賀",
"818478", "東城",
"818807", "宿毛",
"812549", "津川",
"811541", "弟子屈",
"81476", "成田",
"812932", "高萩",
"814795", "銚子",
"81468", "横須賀",
"812563", "三条",
"81964", "松橋",
"812560", "糸魚川",
"81922", "福岡",
"8188090", "窪川",
"811466", "えりも",
"819733", "日田",
"818669", "総社",
"81436", "市原",
"812999", "潮来",
"814753", "茂原",
"811947", "久慈",
"812415", "柳津",
"811866", "鷹巣",
"817735", "福知山",
"819742", "三重",
"811567", "十勝清水",
"815769", "荘川",
"815732", "恵那",
"818244", "三次",
"812830", "宇都宮",
"814708", "大原",
"811398", "熊石",
"812833", "宇都宮",
"815399", "天竜",
"818878", "嶺北",
"81162", "稚内",
"815743", "美濃加茂",
"81281", "宇都宮",
"8165", "大阪",
"81157", "北見",
"81124", "芦別",
"81833", "下松",
"819558", "唐津",
"81552", "甲府",
"81480", "久喜",
"8198298", "日向",
"812473", "石川",
"811465", "静内",
"8125486", "津川",
"81567", "津島",
"811877", "大曲",
"818397", "小郡",
"817494", "彦根",
"811952", "二戸",
"814796", "八日市場",
"812239", "仙台",
"811983", "花巻",
"81877", "丸亀",
"818568", "津和野",
"817687", "能都",
"815588", "修善寺大仁",
"817948", "三木",
"818948", "宇和",
"812972", "水海道",
"818687", "美作",
"811535", "厚岸",
"812556", "糸魚川",
"818375", "美祢",
"812857", "真岡",
"811453", "早来",
"811589", "興部",
"812911", "鉾田",
"817464", "吉野",
"818367", "宇部",
"8125489", "津川",
"8198297", "日向",
"81228", "築館",
"817367", "岩出",
"811853", "男鹿",
"818464", "竹原",
"812873", "大田原",
"8186992", "備前",
"818598", "根雨",
"811374", "森",
"812416", "田島",
"817736", "舞鶴",
"811865", "大館",
"818672", "福渡",
"812648", "長野",
"815954", "上野",
"81737", "湯浅",
"818894", "須崎",
"818838", "阿波池田",
"817672", "羽咋",
"818797", "土庄",
"818595", "米子",
"811868", "鷹巣",
"812659", "伊那",
"817912", "相生",
"811564", "上士幌",
"819593", "大瀬戸",
"812645", "木曾福島",
"818835", "脇町",
"811944", "岩泉",
"811337", "石狩",
"818876", "土佐山田",
"818247", "庄原",
"8188095", "土佐清水",
"8124196", "柳津",
"81489", "草加",
"81743", "奈良",
"814706", "大原",
"811396", "江差",
"812742", "藤岡",
"815585", "下田",
"818476", "府中",
"819932", "指宿",
"817945", "加古川",
"818565", "益田",
"811737", "鰺ケ沢",
"818945", "八幡浜",
"817476", "下市",
"811538", "根室標津",
"818804", "土佐中村",
"818378", "下関",
"817959", "三田",
"812612", "大町",
"819940", "志布志",
"81222", "仙台",
"817707", "小浜",
"819943", "鹿屋",
"819555", "唐津",
"81486", "浦和",
"819433", "八女",
"819969", "中甑",
"818553", "浜田",
"811366", "寿都",
"818582", "倉吉",
"81591", "津",
"815562", "鰍沢青柳",
"814705", "館山",
"811395", "江差",
"818467", "木江",
"817364", "和歌山橋本",
"811753", "むつ",
"818875", "土佐山田",
"818364", "宇部",
"81179", "三戸",
"8198291", "延岡",
"812646", "長野",
"811377", "八雲",
"818836", "脇町",
"818794", "三本松",
"815957", "上野",
"81462", "厚木",
"818596", "米子",
"817738", "舞鶴",
"81424", "武蔵野三鷹",
"811639", "利尻礼文",
"812418", "会津山口",
"81928", "福岡",
"811874", "角館",
"814798", "八日市場",
"812373", "村山",
"811365", "倶知安",
"819972", "種子島",
"819556", "唐津",
"817497", "長浜",
"818684", "津山",
"81176", "十和田",
"812558", "新井",
"815973", "尾鷲",
"817684", "輪島",
"815586", "下田",
"818475", "府中",
"817946", "三木",
"811353", "余市",
"812854", "小山",
"818946", "宇和",
"817475", "下市",
"815746", "美濃加茂",
"812794", "渋川",
"812897", "鹿沼",
"812836", "佐野",
"811855", "能代",
"814756", "東金",
"81937", "北九州",
"8188093", "窪川",
"817454", "大和高田",
"819672", "熊本一の宮",
"812875", "大田原",
"817357", "串本",
"811863", "鹿角",
"819598", "福江",
"81950", "平戸",
"812475", "石川",
"812566", "三条",
"811463", "浦河",
"815994", "阿児",
"81977", "別府",
"819438", "田主丸",
"818558", "川本",
"811939", "宮古",
"81492", "川越",
"811542", "釧路",
"814227", "武蔵野三鷹",
"818514", "海士",
"818373", "長門",
"811533", "根室",
"819687", "玉名",
"817716", "園部",
"819948", "志布志",
"811455", "鵡川",
"819735", "日田",
"81243", "二本松",
"8186698", "倉敷",
"819789", "杵築",
"814755", "東金",
"81561", "瀬戸",
"812577", "六日町",
"8183767", "下関",
"812876", "黒磯",
"812247", "大河原",
"81534", "浜松",
"817733", "福知山",
"8186997", "岡山瀬戸",
"812413", "喜多方",
"811856", "能代",
"812835", "佐野",
"811557", "十勝池田",
"8198292", "延岡",
"81933", "北九州",
"8147957", "八日市場",
"815745", "美濃加茂",
"814284", "立川",
"81294", "常陸太田",
"819574", "諫早",
"812550", "安塚",
"815978", "熊野",
"8183768", "下関",
"812489", "須賀川",
"812553", "上越",
"817715", "亀岡",
"812582", "長岡",
"8186998", "岡山瀬戸",
"811456", "門別富川",
"819807", "沖縄宮古",
"8186697", "倉敷",
"81864", "倉敷",
"814793", "銚子",
"81722", "堺",
"811232", "千歳",
"817612", "小松",
"812378", "寒河江",
"81822", "広島",
"811986", "遠野",
"81764", "富山",
"812476", "三春",
"81259", "佐渡",
"811644", "留萌",
"812565", "三条",
"818202", "柳井",
"818556", "江津",
"812375", "村山",
"815997", "阿児",
"81987", "日南",
"811363", "倶知安",
"812568", "巻",
"818262", "加計",
"818972", "新居浜",
"819946", "鹿屋",
"817239", "寝屋川",
"81277", "桐生",
"817718", "園部",
"819684", "山鹿",
"818473", "甲山",
"817473", "五条",
"814224", "武蔵野三鷹",
"814240", "国分寺",
"812672", "小諸",
"814700", "鴨川",
"812894", "宇都宮",
"812838", "佐野",
"811393", "松前",
"812797", "渋川",
"814703", "館山",
"818873", "安芸",
"818292", "広島",
"8112394", "夕張",
"815748", "美濃白川",
"81250", "新津",
"819596", "福江",
"81947", "田川",
"819738", "玖珠",
"81728", "寝屋川",
"817354", "新宮",
"81828", "広島",
"817457", "大和高田",
"814758", "東金",
"811652", "士別",
"819804", "名護",
"817940", "加古川",
"818563", "益田",
"812389", "米沢",
"817943", "加古川",
"815583", "下田",
"818943", "八幡浜",
"81983", "高鍋",
"811356", "岩内",
"819945", "鹿屋",
"81485", "熊谷",
"81192", "大船渡",
"819553", "伊万里",
"81273", "高崎",
"812478", "三春",
"818549", "石見大田",
"819435", "八女",
"817969", "浜坂",
"8186691", "倉敷",
"818555", "江津",
"812376", "寒河江",
"811647", "羽幌",
"81584", "大垣",
"818593", "米子",
"818842", "阿南",
"812878", "烏山",
"81233", "新庄",
"812643", "木曾福島",
"819595", "有川",
"812640", "長野",
"81956", "佐世保",
"819912", "中之島",
"812244", "白石",
"81544", "富士宮",
"812574", "柏崎",
"818833", "鴨島",
"814992", "伊豆大島",
"811756", "野辺地",
"811554", "帯広",
"81593", "四日市",
"812789", "前橋",
"819577", "島原",
"814287", "青梅",
"811858", "能代",
"811958", "岩手",
"81142", "伊達",
"818585", "倉吉",
"81559", "沼津",
"815565", "鰍沢青柳",
"819976", "名瀬",
"819552", "伊万里",
"81583", "岐阜",
"811637", "北見枝幸",
"815959", "亀山",
"81984", "小林",
"81488", "浦和",
"812615", "大町",
"817942", "加古川",
"819935", "加世田",
"815582", "下田",
"818562", "益田",
"812978", "竜ケ崎",
"818942", "八幡浜",
"81594", "桑名",
"81944", "瀬高",
"812745", "藤岡",
"811584", "遠軽",
"81234", "酒田",
"81495", "本庄",
"81182", "横手",
"819913", "硫黄島",
"812642", "木曾福島",
"818678", "新見",
"817678", "七尾",
"818832", "鴨島",
"81543", "静岡",
"812234", "仙台",
"818592", "米子",
"818843", "阿南",
"81220", "迫",
"817727", "峰山",
"817915", "相生",
"818472", "甲山",
"819936", "加世田",
"81432", "千葉",
"817472", "五条",
"818249", "東広島",
"8186995", "岡山瀬戸",
"81460", "小田原",
"815394", "浜松",
"811527", "美幌",
"81587", "一宮",
"812616", "大町",
"818263", "加計",
"812657", "伊那",
"81178", "八戸",
"818664", "高梁",
"818973", "新居浜",
"812938", "水戸",
"81929", "福岡",
"812994", "石岡",
"818586", "倉吉",
"811362", "倶知安",
"815764", "下呂",
"815566", "身延",
"819975", "名瀬",
"8147955", "八日市場",
"819208", "対馬佐賀",
"81166", "旭川",
"81138", "函館",
"811653", "士別",
"817916", "竜野",
"818384", "萩",
"81825", "広島",
"817487", "水口",
"819547", "鹿島",
"819967", "出水",
"81725", "和泉",
"818290", "広島",
"818872", "室戸",
"818293", "廿日市",
"818694", "岡山",
"81926", "福岡",
"817957", "丹波柏原",
"812673", "小諸",
"812964", "下館",
"811392", "木古内",
"812746", "富岡",
"814702", "館山",
"818957", "御荘",
"812544", "新発田",
"815738", "中津川",
"81547", "島田",
"81438", "木更津",
"818689", "岡山",
"81934", "北九州",
"812913", "鉾田",
"811587", "中湧別",
"8199331", "鹿児島",
"812859", "小山",
"815735", "恵那",
"81244", "原町",
"81172", "弘前",
"812412", "喜多方",
"817732", "福知山",
"818676", "久世",
"81533", "豊橋",
"817724", "宮津",
"8125484", "村上",
"812237", "仙台",
"817676", "七尾",
"81763", "福野",
"81284", "足利",
"818203", "柳井",
"81863", "玉野",
"811233", "千歳",
"817613", "小松",
"814792", "銚子",
"811956", "岩手",
"812935", "水戸",
"811634", "浜頓別",
"819978", "徳之島",
"819205", "厳原",
"8188092", "窪川",
"812976", "竜ケ崎",
"81478", "佐原",
"812552", "上越",
"818369", "宇部",
"812580", "十日町",
"81466", "藤沢",
"812583", "長岡",
"818675", "久世",
"817675", "七尾",
"819673", "熊本一の宮",
"819964", "川内",
"81226", "気仙沼",
"819544", "武雄",
"815367", "設楽",
"819746", "竹田",
"817484", "八日市",
"818387", "田万川",
"811862", "鹿角",
"818697", "備前",
"81482", "川口",
"81550", "御殿場",
"815736", "中津川",
"812748", "富岡",
"8147950", "八日市場",
"812547", "村上",
"818954", "宇和島",
"812967", "笠間",
"817954", "西脇",
"81537", "掛川",
"818372", "長門",
"811532", "根室",
"81852", "松江",
"812618", "大町",
"8198293", "延岡",
"81577", "高山",
"81229", "古川",
"819938", "加世田",
"811524", "網走",
"812975", "水海道",
"815397", "浜松",
"811543", "釧路",
"818667", "井原",
"8152", "名古屋",
"81188", "秋田",
"812936", "水戸",
"811955", "二戸",
"812654", "飯田",
"818588", "郡家",
"815767", "下呂",
"811462", "浦河",
"812997", "潮来",
"81426", "八王子",
"812584", "長岡",
"817996", "津名",
"812786", "沼田",
"815758", "郡上八幡",
"817614", "小松",
"811234", "千歳",
"819668", "水俣",
"811642", "石狩深川",
"81134", "小樽",
"81823", "呉",
"81282", "栃木",
"8198299", "日向",
"81723", "堺",
"8125487", "津川",
"818204", "柳井",
"819788", "国東",
"81429", "所沢",
"815986", "松阪",
"817723", "宮津",
"8126177", "長野",
"817966", "八鹿",
"818847", "牟岐",
"818546", "掛合",
"81242", "会津若松",
"8112395", "栗山",
"81174", "蟹田",
"819725", "佐伯",
"812696", "飯山",
"819233", "前原",
"812386", "長井",
"8198296", "日向",
"819956", "加治木",
"811978", "北上",
"8125488", "津川",
"812914", "鉾田",
"8153961", "天竜",
"815979", "熊野",
"812488", "須賀川",
"81932", "北九州",
"814282", "青梅",
"819572", "諫早",
"81493", "東松山",
"819599", "大瀬戸",
"815992", "鳥羽",
"81545", "富士",
"818977", "伯方",
"818267", "千代田",
"812653", "飯田",
"811544", "釧路",
"811523", "斜里",
"81948", "飯塚",
"81896", "伊予三島",
"818512", "隠岐の島",
"81727", "池田",
"817995", "洲本",
"81827", "岩国",
"812785", "沼田",
"812792", "渋川",
"818953", "宇和島",
"817953", "西脇",
"819949", "大根占",
"81551", "韮崎",
"812677", "佐久",
"817950", "三田",
"812385", "米沢",
"81484", "川口",
"819955", "加治木",
"81988", "那覇",
"818297", "廿日市",
"819963", "川内",
"818559", "川本",
"817452", "大和高田",
"811938", "宮古",
"819674", "熊本一の宮",
"817483", "八日市",
"81266", "諏訪",
"819543", "武雄",
"819726", "臼杵",
"812695", "中野",
"819828", "高千穂",
"817908", "播磨山崎",
"81585", "揖斐川",
"815985", "松阪",
"81899", "松山",
"817965", "豊岡",
"818545", "木次",
"812230", "仙台",
"812956", "常陸大宮",
"8186552", "倉敷",
"818844", "阿南",
"811935", "釜石",
"812233", "岩沼",
"81260", "阿南町",
"812698", "飯山",
"81184", "本荘",
"817905", "福崎",
"8199347", "鹿児島",
"819825", "日向",
"815988", "三瀬谷",
"812572", "柏崎",
"812242", "白石",
"818548", "石見大田",
"817968", "浜坂",
"812486", "須賀川",
"814994", "三宅",
"811552", "帯広",
"811583", "紋別",
"81592", "津",
"81942", "久留米",
"812388", "長井",
"811976", "北上",
"812917", "水戸",
"819802", "南大東",
"812587", "長岡",
"8112390", "夕張",
"8125481", "村上",
"815756", "郡上八幡",
"818656", "笠岡",
"812788", "前橋",
"817998", "津名",
"818391", "小郡",
"811237", "栗山",
"817617", "加賀",
"819786", "杵築",
"818207", "久賀",
"812879", "烏山",
"81144", "苫小牧",
"819666", "水俣",
"8182942", "広島",
"81272", "前橋",
"812963", "下館",
"812674", "小諸",
"812543", "新発田",
"812892", "宇都宮",
"811975", "水沢",
"818294", "廿日市",
"812485", "白河",
"818693", "邑久",
"81474", "船橋",
"817238", "寝屋川",
"8124197", "柳津",
"818690", "岡山",
"81765", "魚津",
"812569", "巻",
"815363", "新城",
"819826", "日向",
"817352", "新宮",
"817906", "播磨山崎",
"818383", "萩",
"819677", "矢部",
"8145", "横浜",
"811936", "宮古",
"81288", "今市",
"812955", "常陸大宮",
"819728", "臼杵",
"811654", "名寄",
"81126", "岩見沢",
"812993", "石岡",
"819665", "人吉",
"8178", "神戸",
"8169", "大阪",
"81969", "天草",
"815763", "下呂",
"818264", "安芸吉田",
"81535", "浜松",
"818974", "新居浜",
"819785", "豊後高田",
"818663", "総社",
"818660", "岡山瀬戸",
"815393", "浜松",
"814298", "飯能",
"811547", "白糠",
"813", "東京",
"818655", "鴨方",
"81420", "所沢",
"81938", "北九州",
"81434", "千葉",
"819682", "山鹿",
"812839", "佐野",
"814771", "市川",
"814222", "武蔵野三鷹",
"815755", "関",
"818795", "三本松",
"8182943", "広島",
"81578", "神岡",
"812939", "水戸",
"8112398", "栗山",
"81776", "福井",
"811566", "十勝清水",
"817353", "新宮",
"811867", "鷹巣",
"818382", "萩",
"81566", "刈谷",
"815362", "新城",
"811946", "久慈",
"8153960", "天竜",
"817365", "和歌山橋本",
"81975", "大分",
"818874", "安芸",
"81739", "田辺",
"81839", "山口",
"8111", "札幌",
"818692", "邑久",
"818365", "宇部",
"8125485", "津川",
"81473", "市川",
"8168", "大阪",
"812962", "下館",
"812890", "宇都宮",
"814704", "館山",
"811394", "松前",
"818248", "庄原",
"812542", "新発田",
"812893", "宇都宮",
"818474", "府中",
"819683", "山鹿",
"81779", "大野",
"81935", "北九州",
"814223", "武蔵野三鷹",
"814776", "船橋",
"818377", "下関",
"81298", "土浦",
"812855", "小山",
"817474", "五条",
"811537", "中標津",
"814220", "国分寺",
"818685", "津山",
"81569", "半田",
"811738", "鰺ケ沢",
"8164", "大阪",
"815392", "浜松",
"818806", "宿毛",
"8112397", "栗山",
"81433", "千葉",
"817685", "輪島",
"81245", "福島",
"818662", "高梁",
"81538", "磐田",
"811875", "角館",
"812992", "石岡",
"811364", "倶知安",
"8186553", "倉敷",
"815762", "下呂",
"817468", "上北山",
"812979", "竜ケ崎",
"817366", "岩出",
"811553", "帯広",
"818366", "宇部",
"811582", "紋別",
"817737", "舞鶴",
"812644", "木曾福島",
"812417", "会津山口",
"812570", "小出",
"818834", "鴨島",
"811945", "久慈",
"81542", "静岡",
"81992", "鹿児島",
"812573", "柏崎",
"812243", "白石",
"815958", "亀山",
"818796", "土庄",
"812232", "岩沼",
"811378", "今金",
"818594", "米子",
"81183", "湯沢",
"811876", "大曲",
"817498", "長浜",
"81740", "今津",
"81582", "岐阜",
"819554", "伊万里",
"818679", "新見",
"814797", "八日市場",
"81143", "室蘭",
"818686", "津山",
"818805", "土佐中村",
"817686", "能都",
"815584", "下田",
"817944", "加古川",
"818564", "益田",
"819803", "名護",
"814775", "船橋",
"812856", "真岡",
"818944", "八幡浜",
"812557", "新井",
"814291", "飯能",
"811534", "中標津",
"818808", "土佐清水",
"818374", "長門",
"811736", "五所川原",
"818477", "東城",
"8163", "大阪",
"817706", "小浜",
"81853", "出雲",
"8199345", "鹿児島",
"811522", "斜里",
"8125480", "村上",
"817495", "長浜",
"8112391", "夕張",
"81998", "鹿児島",
"812652", "飯田",
"81548", "榛原",
"81494", "秩父",
"81235", "鶴岡",
"811367", "寿都",
"815993", "鳥羽",
"811464", "静内",
"818895", "須崎",
"815955", "上野",
"81886", "徳島",
"819962", "川内",
"817453", "大和高田",
"811375", "八雲",
"819542", "武雄",
"811864", "大館",
"817482", "八日市",
"817465", "吉野",
"818246", "三次",
"811336", "石狩",
"818877", "嶺北",
"81849", "福山",
"81985", "宮崎",
"818952", "宇和島",
"811397", "奥尻",
"814707", "大原",
"812793", "渋川",
"8167", "大阪",
"817952", "西脇",
"81177", "青森",
"812619", "大町",
"81572", "多治見",
"811643", "石狩深川",
"818398", "小郡",
"81724", "岸和田貝塚",
"817496", "長浜",
"81862", "岡山",
"811878", "大曲",
"8188096", "土佐清水",
"814794", "銚子",
"811632", "天塩",
"819557", "唐津",
"8186994", "岡山瀬戸",
"81762", "金沢",
"81857", "鳥取",
"817705", "小浜",
"812858", "真岡",
"812554", "上越",
"818947", "宇和",
"818688", "美作",
"811735", "五所川原",
"817688", "能都",
"818567", "津和野",
"817947", "三木",
"815587", "修善寺大仁",
"817368", "岩出",
"819573", "諫早",
"8188099", "土佐清水",
"818368", "宇部",
"81292", "水戸",
"814280", "立川",
"814283", "青梅",
"817466", "十津川",
"819232", "前原",
"818245", "三次",
"818466", "木江",
"818798", "土庄",
"811376", "八雲",
"818837", "阿波池田",
"812414", "柳津",
"812647", "長野",
"819979", "徳之島",
"81532", "豊橋",
"817734", "福知山",
"81487", "浦和",
"817722", "宮津",
"818597", "根雨",
"815956", "上野",
"818896", "須崎",
"818554", "浜田",
"819679", "高森",
"8153963", "天竜",
"812567", "巻",
"81940", "宗像",
"8199343", "鹿児島",
"815998", "阿児",
"819434", "八女",
"81262", "長野",
"818803", "土佐中村",
"8112392", "夕張",
"819944", "鹿屋",
"819805", "名護",
"817717", "園部",
"819686", "玉名",
"814770", "市川",
"814226", "武蔵野三鷹",
"812896", "鹿沼",
"815747", "美濃白川",
"811549", "釧路",
"811555", "帯広",
"812798", "長野原",
"812837", "佐野",
"81270", "伊勢崎",
"819594", "有川",
"819822", "延岡",
"811563", "本別",
"817356", "串本",
"817902", "福崎",
"812245", "大河原",
"812575", "十日町",
"814757", "東金",
"811943", "岩泉",
"817458", "大和榛原",
"811932", "釜石",
"81792", "姫路",
"819737", "玖珠",
"81892", "久万",
"819806", "沖縄宮古",
"811457", "門別富川",
"819685", "玉名",
"812853", "小山",
"815752", "関",
"811354", "余市",
"814225", "武蔵野三鷹",
"815974", "尾鷲",
"81979", "中津",
"818680", "岡山",
"818683", "津山",
"817683", "輪島",
"81246", "いわき",
"818652", "倉敷",
"81835", "防府",
"811987", "遠野",
"81253", "新潟",
"81471", "柏",
"811648", "焼尻",
"819782", "豊後高田",
"812374", "村山",
"811873", "角館",
"819662", "人吉",
"812477", "三春",
"81936", "北九州",
"818793", "三本松",
"81464", "厚木",
"817355", "新宮",
"812246", "大河原",
"812877", "黒磯",
"81249", "郡山",
"812576", "十日町",
"812482", "白河",
"811754", "むつ",
"817363", "和歌山橋本",
"811556", "帯広",
"81565", "豊田",
"811857", "能代",
"819578", "島原",
"818363", "宇部",
"814288", "青梅",
"812589", "長岡",
"818360", "小郡",
"81875", "観音寺",
"812895", "宇都宮",
"81939", "北九州",
"811972", "水沢",
"81775", "大津",
"81286", "宇都宮",
"815744", "美濃加茂",
"812796", "渋川",
"814285", "相模原",
"819575", "諫早",
"81280", "古河",
"812834", "宇都宮",
"818240", "東広島",
"818243", "東広島",
"812898", "鹿沼",
"811333", "当別",
"814754", "茂原",
"817456", "大和高田",
"819722", "佐伯",
"819597", "福江",
"819734", "日田",
"8125483", "村上",
"811645", "留萌",
"812564", "三条",
"81962", "熊本",
"81924", "福岡",
"815996", "阿児",
"818557", "川本",
"81930", "行橋",
"819437", "田主丸",
"819688", "玉名",
"812679", "佐久",
"817703", "敦賀",
"819947", "志布志",
"814228", "武蔵野三鷹",
"811733", "五所川原",
"818299", "広島",
"81240", "磐城富岡",
"817714", "亀岡",
"815982", "松阪",
"817962", "豊岡",
"818542", "安来",
"815953", "上野",
"812248", "大河原",
"818893", "佐川",
"812578", "六日町",
"817455", "大和高田",
"812874", "大田原",
"81986", "都城",
"812692", "中野",
"812382", "米沢",
"819952", "大口",
"81268", "上田",
"817463", "吉野",
"811854", "男鹿",
"818463", "竹原",
"811757", "野辺地",
"812795", "渋川",
"811558", "広尾",
"81276", "太田",
"814286", "相模原",
"81885", "小松島",
"81949", "直方",
"819576", "島原",
"811357", "岩内",
"817992", "洲本",
"812782", "沼田",
"811454", "鵡川",
"819808", "八重山",
"8198294", "延岡",
"81989", "那覇",
"81236", "山形",
"81845", "因島",
"815977", "熊野",
"817493", "彦根",
"818493", "尾道",
"811984", "花巻",
"818490", "尾道",
"812474", "石川",
"81554", "大月",
"81798", "西宮",
"811646", "羽幌",
"81596", "伊勢",
"81946", "甘木",
"81898", "今治",
"815995", "阿児",
"812377", "寒河江",
"81888", "高知",
"818955", "宇和島",
"81586", "一宮",
"811588", "興部",
"817955", "三田",
"814281", "相模原",
"819953", "大口",
"815589", "修善寺大仁",
"817949", "加古川",
"812383", "米沢",
"818949", "宇和",
"818462", "竹原",
"81167", "富良野",
"8166", "大阪",
"819965", "川内",
"81549", "静岡",
"8183766", "下関",
"811372", "鹿部",
"812238", "仙台",
"8188094", "窪川",
"812693", "中野",
"817485", "八日市",
"8186996", "岡山瀬戸",
"818674", "久世",
"815983", "松阪",
"817726", "峰山",
"815952", "上野",
"818543", "安来",
"818892", "佐川",
"817960", "八鹿",
"817674", "羽咋",
"817963", "豊岡",
"8125482", "村上",
"819977", "瀬戸内",
"812649", "長野",
"8153974", "天竜",
"817492", "彦根",
"811954", "二戸",
"811636", "北見枝幸",
"812655", "飯田",
"81553", "山梨",
"81546", "静岡",
"81848", "尾道",
"812974", "水海道",
"811525", "網走",
"81927", "福岡",
"8186999", "岡山瀬戸",
"8182941", "広島",
"812783", "沼田",
"817993", "洲本",
"812780", "前橋",
"815368", "設楽",
"817917", "竜野",
"817725", "宮津",
"818388", "田万川",
"819966", "出水",
"819723", "佐伯",
"819546", "鹿島",
"819744", "三重",
"817486", "水口",
"81832", "下関",
"812968", "笠間",
"818479", "東城",
"815734", "恵那",
"818242", "東広島",
"811332", "当別",
"81721", "富田林",
"818956", "宇和島",
"812747", "富岡",
"818698", "備前",
"817956", "三田",
"817230", "寝屋川",
"818879", "室戸",
"815398", "浜松",
"811732", "五所川原",
"819937", "加世田",
"817702", "敦賀",
"81557", "伊東",
"812617", "大町",
"811526", "網走",
"81562", "尾張横須賀",
"814709", "鴨川",
"81923", "福岡",
"812998", "潮来",
"812934", "高萩",
"812656", "伊那",
"811635", "浜頓別",
"819204", "郷ノ浦",
"815768", "下呂",
"818587", "郡家",
"81425", "立川",
"818668", "井原",
"812995", "石岡",
"815765", "下呂",
"81227", "仙台",
"811638", "利尻礼文",
"812419", "田島",
"819974", "屋久島",
"819663", "人吉",
"811957", "岩手",
"818665", "高梁",
"819783", "豊後高田",
"818682", "津山",
"815395", "浜松",
"812977", "竜ケ崎",
"81738", "御坊",
"817682", "輪島",
"81125", "滝川",
"815753", "関",
"812852", "小山",
"812965", "下館",
"81778", "武生",
"81878", "高松",
"811973", "水沢",
"812545", "村上",
"817362", "和歌山橋本",
"811551", "十勝池田",
"8112393", "夕張",
"812483", "白河",
"81766", "高岡",
"812559", "安塚",
"811586", "中湧別",
"81568", "春日井",
"818695", "岡山瀬戸",
"818362", "宇部",
"818385", "萩",
"817728", "峰山",
"81463", "平塚",
"812571", "六日町",
"818792", "三本松",
"817677", "七尾",
"812236", "仙台",
"81965", "八代",
"818677", "新見",
"8153962", "天竜",
"819934", "指宿",
"814772", "市川",
"811528", "美幌",
"815396", "浜松",
"818802", "窪川",
"812614", "大町",
"812937", "水戸",
"818666", "井原",
"8128798", "大田原",
"812996", "潮来",
"818584", "倉吉",
"811869", "大館",
"815766", "下呂",
"815564", "鰍沢青柳",
"812658", "伊那",
"812235", "仙台",
"811933", "釜石",
"819968", "出水",
"817488", "水口",
"817914", "相生",
"819823", "延岡",
"81191", "一関",
"811562", "本別",
"819747", "竹田",
"817903", "福崎",
"815366", "設楽",
"811942", "岩泉",
"81467", "藤沢",
"815737", "中津川",
"811539", "根室標津",
"818958", "御荘",
"817958", "丹波柏原",
"811585", "遠軽",
"818696", "備前",
"81742", "奈良",
"812744", "藤岡",
"812546", "村上",};
$areanames{en} = {"8153975", "Hamamatsu\,\ Shizuoka",
"817945", "Kakogawa\,\ Hyogo",
"819932", "Ibusuki\,\ Kagoshima",
"818476", "Fuchu\,\ Hiroshima",
"815585", "Shimoda\,\ Shizuoka",
"818565", "Masuda\,\ Shimane",
"818895", "Susaki\,\ Kochi",
"81886", "Tokushima\,\ Tokushima",
"817476", "Shimonoseki\,\ Yamaguchi",
"818945", "Yawatahama\,\ Ehime",
"817453", "Yamatotakada\,\ Nara",
"819962", "Satsumasendai\,\ Kagoshima",
"818378", "Shimonoseki\,\ Yamaguchi",
"811375", "Yakumo\,\ Hokkaido",
"819940", "Shibushi\,\ Kagoshima",
"819542", "Takeo\,\ Saga",
"812612", "Omachi\,\ Nagano",
"817959", "Sanda\,\ Hyogo",
"819943", "Kanoya\,\ Kagoshima",
"8126170", "Omachi\,\ Nagano",
"817707", "Obama\,\ Fukui",
"817482", "Yokaichi\,\ Shiga",
"811864", "Odate\,\ Akita",
"81222", "Sendai\,\ Miyagi",
"817465", "Yoshino\,\ Nara",
"819555", "Karatsu\,\ Saga",
"81849", "Fukuyama\,\ Hiroshima",
"811336", "Ishikari\,\ Hokkaido",
"81486", "Urawa\,\ Saitama",
"818246", "Miyoshi\,\ Hiroshima",
"81985", "Miyazaki\,\ Miyazaki",
"819433", "Yame\,\ Fukuoka",
"818952", "Uwajima\,\ Ehime",
"818553", "Hamada\,\ Shimane",
"812793", "Shibukawa\,\ Gunma",
"811397", "Okushiri\,\ Hokkaido",
"818582", "Kurayoshi\,\ Tottori",
"811366", "Suttsu\,\ Hokkaido",
"81591", "Tsu\,\ Mie",
"817952", "Nishiwaki\,\ Hyogo",
"8167", "Osaka\,\ Osaka",
"81177", "Aomori\,\ Aomori",
"812619", "Omachi\,\ Nagano",
"818374", "Nagato\,\ Yamaguchi",
"811534", "Nakashibetsu\,\ Hokkaido",
"818808", "Tosashimizu\,\ Kochi",
"814291", "Hanno\,\ Saitama",
"818595", "Yonago\,\ Tottori",
"811736", "Goshogawara\,\ Aomori",
"811868", "Takanosu\,\ Akita",
"818477", "Tojo\,\ Hiroshima",
"8153965", "Hamamatsu\,\ Shizuoka",
"817912", "Aioi\,\ Hyogo",
"812659", "Ina\,\ Nagano",
"81853", "Izumo\,\ Shimane",
"817706", "Obama\,\ Fukui",
"8163", "Osaka\,\ Osaka",
"811564", "Kamishihoro\,\ Hokkaido",
"819593", "Oseto\,\ Nagasaki",
"811522", "Shari\,\ Hokkaido",
"811944", "Iwaizumi\,\ Iwate",
"818835", "Mima\,\ Tokushima",
"8199345", "Kagoshima\,\ Kagoshima",
"817495", "Nagahama\,\ Shiga",
"8125480", "Murakami\,\ Niigata",
"818247", "Shobara\,\ Hiroshima",
"811337", "Ishikari\,\ Hokkaido",
"8112391", "Yubari\,\ Hokkaido",
"81489", "Soka\,\ Saitama",
"812652", "Iida\,\ Nagano",
"8188095", "Tosashimizu\,\ Kochi",
"8124196", "Yanaizu\,\ Fukushima",
"81998", "Kagoshima\,\ Kagoshima",
"81235", "Tsuruoka\,\ Yamagata",
"81494", "Chichibu\,\ Saitama",
"81548", "Haibara\,\ Shizuoka",
"811367", "Suttsu\,\ Hokkaido",
"81743", "Nara\,\ Nara",
"815993", "Toba\,\ Mie",
"811464", "Shizunai\,\ Hokkaido",
"812742", "Fujioka\,\ Gunma",
"811396", "Esashi\,\ Hokkaido",
"814798", "Yokaichiba\,\ Chiba",
"811874", "Kakunodate\,\ Akita",
"817368", "Iwade\,\ Wakayama",
"812373", "Murayama\,\ Yamagata",
"814280", "Tachikawa\,\ Tokyo",
"81292", "Mito\,\ Ibaraki",
"811365", "Kutchan\,\ Hokkaido",
"819573", "Isahaya\,\ Nagasaki",
"818368", "Ube\,\ Yamaguchi",
"8188099", "Tosashimizu\,\ Kochi",
"814283", "Ome\,\ Tokyo",
"817466", "Totsukawa\,\ Nara",
"819556", "Karatsu\,\ Saga",
"819232", "Maebaru\,\ Fukuoka",
"818245", "Miyoshi\,\ Hiroshima",
"818466", "Mima\,\ Tokushima",
"817497", "Nagahama\,\ Shiga",
"81176", "Towada\,\ Aomori",
"818684", "Tsuyama\,\ Okayama",
"811376", "Yakumo\,\ Hokkaido",
"815973", "Owase\,\ Mie",
"818798", "Tonosho\,\ Kagawa",
"81532", "Toyohashi\,\ Aichi",
"819979", "Tokunoshima\,\ Kagoshima",
"812647", "Nagano\,\ Nagano",
"812414", "Yanaizu\,\ Fukushima",
"8153969", "Hamamatsu\,\ Shizuoka",
"817684", "Wajima\,\ Ishikawa",
"817734", "Fukuchiyama\,\ Kyoto",
"817946", "Miki\,\ Hyogo",
"815586", "Shimoda\,\ Shizuoka",
"818475", "Fuchu\,\ Hiroshima",
"817722", "Miyazu\,\ Kyoto",
"81487", "Urawa\,\ Saitama",
"811353", "Yoichi\,\ Hokkaido",
"818896", "Susaki\,\ Kochi",
"817475", "Shimonoseki\,\ Yamaguchi",
"8153976", "Hamamatsu\,\ Shizuoka",
"818946", "Uwajima\,\ Ehime",
"812854", "Oyama\,\ Tochigi",
"81572", "Tajimi\,\ Gifu",
"811395", "Esashi\,\ Hokkaido",
"818398", "Ogori\,\ Yamaguchi",
"814705", "Tateyama\,\ Chiba",
"817496", "Nagahama\,\ Shiga",
"81862", "Okayama\,\ Okayama",
"818467", "Mima\,\ Tokushima",
"8188096", "Tosashimizu\,\ Kochi",
"814794", "Choshi\,\ Chiba",
"811878", "Omagari\,\ Akita",
"811753", "Mutsu\,\ Aomori",
"819557", "Karatsu\,\ Saga",
"811632", "Teshio\,\ Hokkaido",
"8186994", "Seto\,\ Okayama",
"81857", "Tottori\,\ Tottori",
"81762", "Kanazawa\,\ Ishikawa",
"818364", "Ube\,\ Yamaguchi",
"81179", "Sannohe\,\ Aomori",
"817705", "Obama\,\ Fukui",
"8153979", "Hamamatsu\,\ Shizuoka",
"8198291", "Nobeoka\,\ Miyazaki",
"812646", "Nagano\,\ Nagano",
"818836", "Mima\,\ Tokushima",
"812858", "Mooka\,\ Tochigi",
"811377", "Yakumo\,\ Hokkaido",
"818947", "Uwajima\,\ Ehime",
"812554", "Joetsu\,\ Niigata",
"8153966", "Hamamatsu\,\ Shizuoka",
"811735", "Goshogawara\,\ Aomori",
"818596", "Yonago\,\ Tottori",
"81462", "Atsugi\,\ Kanagawa",
"818688", "Mimasaka\,\ Okayama",
"818567", "Tsuwano\,\ Shimane",
"817688", "Noto\,\ Ishikawa",
"817738", "Maizuru\,\ Kyoto",
"81928", "Fukuoka\,\ Fukuoka",
"817947", "Miki\,\ Hyogo",
"819683", "Yamaga\,\ Kumamoto",
"819733", "Hita\,\ Oita",
"818474", "Fuchu\,\ Hiroshima",
"814776", "Funabashi\,\ Chiba",
"81935", "Kitakyushu\,\ Fukuoka",
"81779", "Ono\,\ Gifu",
"818669", "Soja\,\ Okayama",
"814220", "Kokubunji\,\ Tokyo",
"811537", "Nakashibetsu\,\ Hokkaido",
"8126175", "Omachi\,\ Nagano",
"812855", "Oyama\,\ Tochigi",
"81298", "Tsuchiura\,\ Ibaraki",
"818377", "Shimonoseki\,\ Yamaguchi",
"81436", "Ichihara\,\ Chiba",
"8153970", "Hamamatsu\,\ Shizuoka",
"8164", "Osaka\,\ Osaka",
"818685", "Tsuyama\,\ Okayama",
"812999", "Itako\,\ Ibaraki",
"81569", "Handa\,\ Aichi",
"814753", "Mobara\,\ Chiba",
"811947", "Kuji\,\ Iwate",
"8112397", "Kuriyama\,\ Hokkaido",
"818806", "Sukumo\,\ Kochi",
"815392", "Hamamatsu\,\ Shizuoka",
"812415", "Yanaizu\,\ Fukushima",
"817685", "Wajima\,\ Ishikawa",
"815769", "Shokawa\,\ Gifu",
"819742", "Mie\,\ Oita",
"811866", "Takanosu\,\ Akita",
"817735", "Fukuchiyama\,\ Kyoto",
"81433", "Chiba\,\ Chiba",
"812830", "Utsunomiya\,\ Tochigi",
"815732", "Ena\,\ Gifu",
"818244", "Miyoshi\,\ Hiroshima",
"81538", "Iwata\,\ Shizuoka",
"818662", "Takahashi\,\ Okayama",
"812833", "Utsunomiya\,\ Tochigi",
"811398", "Kumaishi\,\ Hokkaido",
"81245", "Fukushima\,\ Fukushima",
"811875", "Kakunodate\,\ Akita",
"812992", "Ishioka\,\ Ibaraki",
"815743", "Minokamo\,\ Gifu",
"81162", "Wakkanai\,\ Hokkaido",
"81833", "Kudamatsu\,\ Yamaguchi",
"81124", "Ashibetsu\,\ Hokkaido",
"8165", "Osaka\,\ Osaka",
"8186553", "Kurashiki\,\ Okayama",
"81157", "Kitami\,\ Hokkaido",
"815762", "Gero\,\ Gifu",
"81281", "Utsunomiya\,\ Tochigi",
"811364", "Kutchan\,\ Hokkaido",
"818376", "Mine\,\ Yamaguchi",
"81563", "Nishio\,\ Aichi",
"812939", "Mito\,\ Ibaraki",
"811536", "Akkeshi\,\ Hokkaido",
"8182943", "Hiroshima\,\ Hiroshima",
"812555", "Itoigawa\,\ Niigata",
"81578", "Kamioka\,\ Akita",
"811734", "Goshogawara\,\ Aomori",
"8112398", "Kuriyama\,\ Hokkaido",
"814777", "Funabashi\,\ Chiba",
"81776", "Fukui\,\ Fukui",
"81439", "Kisarazu\,\ Chiba",
"817713", "Kameoka\,\ Kyoto",
"818382", "Hagi\,\ Yamaguchi",
"81566", "Kariya\,\ Aichi",
"811867", "Takanosu\,\ Akita",
"817704", "Tsuruga\,\ Fukui",
"817353", "Shingu\,\ Fukuoka",
"815362", "Shinshiro\,\ Aichi",
"818478", "Tojo\,\ Hiroshima",
"812549", "Tsugawa\,\ Niigata",
"818807", "Sukumo\,\ Kochi",
"811946", "Kuji\,\ Iwate",
"811541", "Teshikaga\,\ Hokkaido",
"81476", "Narita\,\ Chiba",
"81739", "Tanabe\,\ Wakayama",
"818874", "Aki\,\ Kochi",
"814795", "Choshi\,\ Chiba",
"81975", "Oita\,\ Oita",
"812932", "Takahagi\,\ Ibaraki",
"8111", "Sapporo\,\ Hokkaido",
"81839", "Yamaguchi\,\ Yamaguchi",
"818692", "Oku\,\ Okayama",
"818365", "Ube\,\ Yamaguchi",
"812563", "Sanjo\,\ Niigata",
"81473", "Ichikawa\,\ Chiba",
"8125485", "Tsugawa\,\ Niigata",
"81468", "Yokosuka\,\ Kanagawa",
"812560", "Itoigawa\,\ Niigata",
"812962", "Shimodate\,\ Ibaraki",
"8168", "Osaka\,\ Osaka",
"811466", "Erimo\,\ Hokkaido",
"811394", "Matsumae\,\ Hokkaido",
"814704", "Tateyama\,\ Chiba",
"81922", "Fukuoka\,\ Fukuoka",
"812890", "Utsunomiya\,\ Tochigi",
"812893", "Utsunomiya\,\ Tochigi",
"812542", "Shibata\,\ Niigata",
"818248", "Shobara\,\ Hiroshima",
"811876", "Omagari\,\ Akita",
"817498", "Nagahama\,\ Shiga",
"812911", "Hokota\,\ Ibaraki",
"81740", "Imazu\,\ Shiga",
"81582", "Gifu\,\ Gifu",
"818367", "Ube\,\ Yamaguchi",
"8125489", "Tsugawa\,\ Niigata",
"817464", "Yoshino\,\ Nara",
"8198297", "Hyuga\,\ Miyazaki",
"818679", "Niimi\,\ Okayama",
"819554", "Imari\,\ Saga",
"814797", "Yokaichiba\,\ Chiba",
"818464", "Takehara\,\ Hiroshima",
"811853", "Oga\,\ Akita",
"817367", "Iwade\,\ Wakayama",
"81143", "Muroran\,\ Hokkaido",
"8186992", "Bizen\,\ Okayama",
"818686", "Tsuyama\,\ Okayama",
"812873", "Otawara\,\ Tochigi",
"811374", "Mori\,\ Hokkaido",
"812416", "Tajima\,\ Fukushima",
"817686", "Noto\,\ Ishikawa",
"817736", "Maizuru\,\ Kyoto",
"811865", "Odate\,\ Akita",
"812648", "Nagano\,\ Nagano",
"817944", "Kakogawa\,\ Hyogo",
"8126176", "Omachi\,\ Nagano",
"815584", "Shimoda\,\ Shizuoka",
"819803", "Nago\,\ Okinawa",
"818564", "Masuda\,\ Shimane",
"814775", "Funabashi\,\ Chiba",
"818894", "Susaki\,\ Kochi",
"81737", "Yuasa\,\ Wakayama",
"818797", "Tonosho\,\ Kagawa",
"817672", "Hakui\,\ Ishikawa",
"818944", "Yawatahama\,\ Ehime",
"812856", "Mooka\,\ Tochigi",
"81552", "Kofu\,\ Yamanashi",
"819558", "Karatsu\,\ Saga",
"812473", "Ishikawa\,\ Fukushima",
"8198298", "Hyuga\,\ Miyazaki",
"81480", "Kuki\,\ Saitama",
"817468", "Kamikitayama\,\ Nara",
"811465", "Shizunai\,\ Hokkaido",
"811877", "Omagari\,\ Akita",
"81567", "Tsushima\,\ Aichi",
"8125486", "Tsugawa\,\ Niigata",
"817494", "Hikone\,\ Shiga",
"811553", "Obihiro\,\ Hokkaido",
"817366", "Iwade\,\ Wakayama",
"818397", "Ogori\,\ Yamaguchi",
"812239", "Sendai\,\ Miyagi",
"814796", "Yokaichiba\,\ Chiba",
"811952", "Ninohe\,\ Iwate",
"81877", "Marugame\,\ Kagawa",
"811983", "Hanamaki\,\ Iwate",
"811582", "Monbetsu\,\ Hokkaido",
"818366", "Ube\,\ Yamaguchi",
"817737", "Maizuru\,\ Kyoto",
"817687", "Noto\,\ Ishikawa",
"818568", "Tsuwano\,\ Shimane",
"817948", "Miki\,\ Hyogo",
"81542", "Shizuoka\,\ Shizuoka",
"818948", "Uwajima\,\ Ehime",
"818834", "Kamojima\,\ Tokushima",
"811945", "Kuji\,\ Iwate",
"818687", "Mimasaka\,\ Okayama",
"812243", "Shiroishi\,\ Miyagi",
"815958", "Kameyama\,\ Mie",
"812573", "Kashiwazaki\,\ Niigata",
"81992", "Kagoshima\,\ Kagoshima",
"8126179", "Omachi\,\ Nagano",
"812857", "Mooka\,\ Tochigi",
"811378", "Imakane\,\ Hokkaido",
"818375", "Mine\,\ Yamaguchi",
"818796", "Tonosho\,\ Kagawa",
"812232", "Iwanuma\,\ Miyagi",
"812556", "Itoigawa\,\ Niigata",
"811535", "Akkeshi\,\ Hokkaido",
"818594", "Yonago\,\ Tottori",
"81183", "Yuzawa\,\ Akita",
"811589", "Okoppe\,\ Hokkaido",
"811453", "Hayakita\,\ Hokkaido",
"815984", "Matsusaka\,\ Mie",
"819802", "Minamidaito\,\ Okinawa",
"812587", "Nagaoka\,\ Niigata",
"817673", "Hakui\,\ Ishikawa",
"817964", "Toyooka\,\ Hyogo",
"8112390", "Yubari\,\ Hokkaido",
"818544", "Kisuki\,\ Shimane",
"8125481", "Murakami\,\ Niigata",
"812957", "Daigo\,\ Ibaraki",
"8153968", "Hamamatsu\,\ Shizuoka",
"81196", "Morioka\,\ Iwate",
"812872", "Otawara\,\ Tochigi",
"812788", "Maebashi\,\ Gunma",
"818656", "Kasaoka\,\ Okayama",
"812694", "Nakano\,\ Nagano",
"817998", "Tsuna\,\ Hyogo",
"8162", "Osaka\,\ Osaka",
"812384", "Yonezawa\,\ Yamagata",
"81225", "Ishinomaki\,\ Miyagi",
"819954", "Kajiki\,\ Kagoshima",
"819809", "Yaeyama\ District\,\ Okinawa",
"819786", "Kitsuki\,\ Oita",
"817617", "Kaga\,\ Ishikawa",
"811852", "Oga\,\ Akita",
"811237", "Kuriyama\,\ Hokkaido",
"818391", "Ogori\,\ Yamaguchi",
"812487", "Sukagawa\,\ Fukushima",
"811977", "Kitakami\,\ Iwate",
"812879", "Nasukarasuyama\,\ Tochigi",
"8188098", "Tosashimizu\,\ Kochi",
"814998", "Ogasawara\,\ Tokyo",
"81144", "Tomakomai\,\ Hokkaido",
"8182942", "Hiroshima\,\ Hiroshima",
"819666", "Minamata\,\ Kumamoto",
"81272", "Maebashi\,\ Gunma",
"818844", "Anan\,\ Tokushima",
"811935", "Kamaishi\,\ Iwate",
"8186552", "Kurashiki\,\ Okayama",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"811559", "Obihiro\,\ Hokkaido",
"812230", "Sendai\,\ Miyagi",
"8153967", "Hamamatsu\,\ Shizuoka",
"81260", "Anan\,\ Nagano",
"812551", "Joetsu\,\ Niigata",
"812233", "Iwanuma\,\ Miyagi",
"812698", "Iiyama\,\ Nagano",
"817994", "Sumoto\,\ Hyogo",
"812586", "Nagaoka\,\ Niigata",
"812784", "Numata\,\ Gunma",
"811452", "Hayakita\,\ Hokkaido",
"81184", "Yurihonjo\,\ Akita",
"81199", "Morioka\,\ Iwate",
"818657", "Kasaoka\,\ Okayama",
"819825", "Hyuga\,\ Miyazaki",
"8199347", "Kagoshima\,\ Kagoshima",
"817905", "Fukusaki\,\ Hyogo",
"811545", "Kushiro\,\ Hokkaido",
"812242", "Shiroishi\,\ Miyagi",
"812572", "Kashiwazaki\,\ Niigata",
"81952", "Saga\,\ Saga",
"8153978", "Hamamatsu\,\ Shizuoka",
"817968", "Hamasaka\,\ Hyogo",
"812486", "Sukagawa\,\ Fukushima",
"811953", "Ninohe\,\ Iwate",
"8188097", "Tosashimizu\,\ Kochi",
"811236", "Chitose\,\ Hokkaido",
"811552", "Obihiro\,\ Hokkaido",
"819787", "Kunisaki\,\ Oita",
"817616", "Komatsu\,\ Ishikawa",
"811583", "Monbetsu\,\ Hokkaido",
"811982", "Hanamaki\,\ Iwate",
"8126171", "Omachi\,\ Nagano",
"812472", "Ishikawa\,\ Fukushima",
"81592", "Tsu\,\ Mie",
"819667", "Minamata\,\ Kumamoto",
"812388", "Nagai\,\ Yamagata",
"81942", "Kurume\,\ Fukuoka",
"812917", "Mito\,\ Ibaraki",
"818206", "Yanai\,\ Yamaguchi",
"811976", "Kitakami\,\ Iwate",
"815742", "Minokamo\,\ Gifu",
"812993", "Ishioka\,\ Ibaraki",
"81126", "Iwamizawa\,\ Hokkaido",
"818298", "Hatsukaichi\,\ Hiroshima",
"8198290", "Nobeoka\,\ Miyazaki",
"8169", "Osaka\,\ Osaka",
"819665", "Hitoyoshi\,\ Kumamoto",
"8178", "Kobe\,\ Hyogo",
"815763", "Gero\,\ Gifu",
"81969", "Amakusa\,\ Kumamoto",
"81834", "Tokuyama\,\ Yamaguchi",
"81535", "Hamamatsu\,\ Shizuoka",
"812678", "Saku\,\ Nagano",
"818663", "Soja\,\ Okayama",
"819785", "Bungotakada\,\ Oita",
"812832", "Sano\,\ Tochigi",
"818974", "Niihama\,\ Ehime",
"818660", "Seto\,\ Okayama",
"81734", "Wakayama\,\ Wakayama",
"815733", "Ena\,\ Gifu",
"814752", "Mobara\,\ Chiba",
"814298", "Hanno\,\ Saitama",
"815393", "Hamamatsu\,\ Shizuoka",
"819676", "Takamori\,\ Kumamoto",
"813", "Tokyo",
"811547", "Shiranuka\,\ Hokkaido",
"819827", "Takachiho\,\ Miyazaki",
"819743", "Mie\,\ Oita",
"818655", "Kamogata\,\ Okayama",
"811658", "Kamikawa\,\ Hokkaido",
"81420", "Tokorozawa\,\ Saitama",
"819724", "Saiki\,\ Oita",
"81938", "Kitakyushu\,\ Fukuoka",
"819682", "Yamaga\,\ Kumamoto",
"81434", "Chiba\,\ Chiba",
"819732", "Hita\,\ Oita",
"815755", "Sekigahara\,\ Gifu",
"811937", "Miyako\,\ Iwate",
"812839", "Sano\,\ Tochigi",
"814771", "Ichikawa\,\ Chiba",
"812674", "Komoro\,\ Nagano",
"812963", "Shimodate\,\ Ibaraki",
"8144", "Kawasaki\,\ Kanagawa",
"812562", "Sanjo\,\ Niigata",
"8175", "Kyoto\,\ Kyoto",
"812892", "Utsunomiya\,\ Tochigi",
"81465", "Odawara\,\ Kanagawa",
"812543", "Shibata\,\ Niigata",
"818205", "Yanai\,\ Yamaguchi",
"811975", "Mizusawa\,\ Iwate",
"818978", "Hakata\,\ Ehime",
"812485", "Shirakawa\,\ Fukushima",
"812933", "Takahagi\,\ Ibaraki",
"818294", "Hatsukaichi\,\ Hiroshima",
"811235", "Yubari\,\ Hokkaido",
"812930", "Mito\,\ Ibaraki",
"817615", "Komatsu\,\ Ishikawa",
"8186993", "Bizen\,\ Okayama",
"8124197", "Yanaizu\,\ Fukushima",
"81474", "Funabashi\,\ Chiba",
"818693", "Oku\,\ Okayama",
"817238", "Neyagawa\,\ Osaka",
"81963", "Kumamoto\,\ Kumamoto",
"818690", "Okayama\,\ Okayama",
"815363", "Shinshiro\,\ Aichi",
"81765", "Uozu\,\ Toyama",
"818383", "Hagi\,\ Yamaguchi",
"81531", "Tahara\,\ Aichi",
"817352", "Shingu\,\ Fukuoka",
"819826", "Hyuga\,\ Miyazaki",
"811546", "Kushiro\,\ Hokkaido",
"81564", "Okazaki\,\ Aichi",
"812899", "Kanuma\,\ Tochigi",
"8145", "Yokohama\,\ Kanagawa",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"811936", "Miyako\,\ Iwate",
"81288", "Imabari\,\ Ehime",
"81774", "Uji\,\ Kyoto",
"819728", "Usuki\,\ Oita",
"817712", "Kameoka\,\ Kyoto",
"812585", "Nagaoka\,\ Niigata",
"811654", "Nayoro\,\ Hokkaido",
"817723", "Miyazu\,\ Kyoto",
"815986", "Matsusaka\,\ Mie",
"812787", "Numata\,\ Gunma",
"81429", "Tokorozawa\,\ Saitama",
"817997", "Tsuna\,\ Hyogo",
"811352", "Yoichi\,\ Hokkaido",
"818546", "Kakeya\,\ Shimane",
"815754", "Sekigahara\,\ Gifu",
"815972", "Owase\,\ Mie",
"81242", "Aizuwakamatsu\,\ Fukushima",
"81174", "Kanita\,\ Aomori",
"8112395", "Kuriyama\,\ Hokkaido",
"818654", "Kamogata\,\ Okayama",
"812696", "Iiyama\,\ Nagano",
"819725", "Saiki\,\ Oita",
"814289", "Ome\,\ Tokyo",
"812588", "Nagaoka\,\ Niigata",
"812386", "Nagai\,\ Yamagata",
"819233", "Maebaru\,\ Fukuoka",
"819956", "Kajiki\,\ Kagoshima",
"8198296", "Hyuga\,\ Miyazaki",
"819784", "Bungotakada\,\ Oita",
"818975", "Niihama\,\ Ehime",
"81729", "Yao\,\ Osaka",
"811978", "Kitakami\,\ Iwate",
"8125488", "Tsugawa\,\ Niigata",
"811238", "Kuriyama\,\ Hokkaido",
"812372", "Murayama\,\ Yamagata",
"812914", "Hokota\,\ Ibaraki",
"817618", "Kaga\,\ Ishikawa",
"81932", "Kitakyushu\,\ Fukuoka",
"812488", "Sukagawa\,\ Fukushima",
"815979", "Kumano\,\ Mie",
"814282", "Ome\,\ Tokyo",
"81252", "Niigata\,\ Niigata",
"819664", "Hitoyoshi\,\ Kumamoto",
"819572", "Isahaya\,\ Nagasaki",
"81426", "Hachioji\,\ Tokyo",
"818547", "Kakeya\,\ Shimane",
"81925", "Fukuoka\,\ Fukuoka",
"817996", "Tsuna\,\ Hyogo",
"812584", "Nagaoka\,\ Niigata",
"812786", "Numata\,\ Gunma",
"811655", "Nayoro\,\ Hokkaido",
"81423", "Kokubunji\,\ Tokyo",
"8126178", "Omachi\,\ Nagano",
"812697", "Iiyama\,\ Nagano",
"812484", "Shirakawa\,\ Fukushima",
"818295", "Hatsukaichi\,\ Hiroshima",
"811752", "Mutsu\,\ Aomori",
"81797", "Nishinomiya\,\ Hyogo",
"811234", "Chitose\,\ Hokkaido",
"817614", "Komatsu\,\ Ishikawa",
"81726", "Ibaraki\,\ Osaka",
"819957", "Kajiki\,\ Kagoshima",
"812387", "Nagai\,\ Yamagata",
"819668", "Minamata\,\ Kumamoto",
"812675", "Saku\,\ Nagano",
"81282", "Tochigi\,\ Tochigi",
"81823", "Kure\,\ Hiroshima",
"81134", "Otaru\,\ Hokkaido",
"81723", "Sakai\,\ Osaka",
"8198299", "Hyuga\,\ Miyazaki",
"819788", "Kunisaki\,\ Oita",
"8153971", "Hamamatsu\,\ Shizuoka",
"818204", "Yanai\,\ Yamaguchi",
"8161", "Osaka\,\ Osaka",
"8125487", "Tsugawa\,\ Niigata",
"811974", "Mizusawa\,\ Iwate",
"812792", "Shibukawa\,\ Gunma",
"818552", "Hamada\,\ Shimane",
"818953", "Uwajima\,\ Ehime",
"817953", "Nishiwaki\,\ Hyogo",
"817950", "Sanda\,\ Hyogo",
"818583", "Kurayoshi\,\ Tottori",
"812677", "Saku\,\ Nagano",
"81551", "Nirasaki\,\ Yamanashi",
"81484", "Kawaguchi\,\ Saitama",
"812385", "Yonezawa\,\ Yamagata",
"81988", "Naha\,\ Okinawa",
"819955", "Kajiki\,\ Kagoshima",
"8198295", "Hyuga\,\ Miyazaki",
"8182920", "Hatsukaichi\,\ Hiroshima",
"819432", "Yame\,\ Fukuoka",
"818976", "Niihama\,\ Ehime",
"818297", "Hatsukaichi\,\ Hiroshima",
"811938", "Miyako\,\ Iwate",
"817452", "Yamatotakada\,\ Nara",
"818559", "Kawamoto\,\ Shimane",
"812799", "Naganohara\,\ Gunma",
"8112396", "Kuriyama\,\ Hokkaido",
"819963", "Satsumasendai\,\ Kagoshima",
"81266", "Suwa\,\ Nagano",
"817483", "Yokaichi\,\ Shiga",
"819726", "Usuki\,\ Oita",
"812695", "Nakano\,\ Nagano",
"819543", "Takeo\,\ Saga",
"812613", "Omachi\,\ Nagano",
"815985", "Matsusaka\,\ Mie",
"81899", "Matsuyama\,\ Ehime",
"81585", "Ibigawa\,\ Gifu",
"819828", "Takachiho\,\ Miyazaki",
"819933", "Ibusuki\,\ Kagoshima",
"81263", "Matsumoto\,\ Nagano",
"814297", "Hanno\,\ Saitama",
"817965", "Toyooka\,\ Hyogo",
"818545", "Kisuki\,\ Shimane",
"811548", "Teshikaga\,\ Hokkaido",
"812676", "Saku\,\ Nagano",
"819599", "Oseto\,\ Nagasaki",
"81493", "Higashimatsuyama\,\ Saitama",
"815992", "Toba\,\ Mie",
"812743", "Fujioka\,\ Gunma",
"814701", "Kamogawa\,\ Chiba",
"818296", "Hiroshima\,\ Hiroshima",
"818977", "Hakata\,\ Ehime",
"81545", "Fuji\,\ Shizuoka",
"81958", "Nagasaki\,\ Nagasaki",
"812653", "Iida\,\ Nagano",
"81744", "Yamatotakada\,\ Nara",
"81427", "Sagamihara\,\ Kanagawa",
"819727", "Usuki\,\ Oita",
"819592", "Oseto\,\ Nagasaki",
"81893", "Ozu\,\ Ehime",
"817904", "Fukusaki\,\ Hyogo",
"819824", "Nobeoka\,\ Miyazaki",
"811544", "Kushiro\,\ Hokkaido",
"815999", "Tsu\,\ Mie",
"81793", "Himeji\,\ Hyogo",
"811523", "Shari\,\ Hokkaido",
"811934", "Kamaishi\,\ Iwate",
"81948", "Iizuka\,\ Fukuoka",
"81896", "Iyomishima\,\ Ehime",
"818512", "Okinoshima\,\ Shimane",
"81727", "Ikeda\,\ Osaka",
"81827", "Iwakuni\,\ Yamaguchi",
"8112399", "Kuriyama\,\ Hokkaido",
"817995", "Sumoto\,\ Hyogo",
"81555", "Fujiyoshida\,\ Yamanashi",
"812785", "Numata\,\ Gunma",
"811656", "Bifuka\,\ Hokkaido",
"8126174", "Omachi\,\ Nagano",
"81778", "Takefu\,\ Fukui",
"812965", "Shimodate\,\ Ibaraki",
"81284", "Ashikaga\,\ Tochigi",
"81763", "Fukuno\,\ Toyama",
"81863", "Tamano\,\ Okayama",
"811973", "Mizusawa\,\ Iwate",
"81878", "Takamatsu\,\ Kagawa",
"818203", "Yanai\,\ Yamaguchi",
"812545", "Murakami\,\ Niigata",
"8112393", "Yubari\,\ Hokkaido",
"817613", "Komatsu\,\ Ishikawa",
"811233", "Chitose\,\ Hokkaido",
"812935", "Mito\,\ Ibaraki",
"811956", "Iwate\,\ Iwate",
"812559", "Yasuzuka\,\ Niigata",
"81766", "Takaoka\,\ Toyama",
"814792", "Choshi\,\ Chiba",
"812483", "Shirakawa\,\ Fukushima",
"819978", "Tokunoshima\,\ Kagoshima",
"811634", "Hamatonbetsu\,\ Hokkaido",
"818695", "Seto\,\ Okayama",
"81568", "Kasugai\,\ Aichi",
"818362", "Ube\,\ Yamaguchi",
"811586", "Nakayubetsu\,\ Hokkaido",
"818385", "Hagi\,\ Yamaguchi",
"81478", "Sawara\,\ Chiba",
"812571", "Muika\,\ Niigata",
"81463", "Hiratsuka\,\ Kanagawa",
"817677", "Nanao\,\ Ishikawa",
"812552", "Joetsu\,\ Niigata",
"812236", "Sendai\,\ Miyagi",
"81965", "Yatsushiro\,\ Kumamoto",
"812580", "Tokamachi\,\ Niigata",
"818369", "Ube\,\ Yamaguchi",
"812583", "Nagaoka\,\ Niigata",
"81466", "Fujisawa\,\ Kanagawa",
"818677", "Niimi\,\ Okayama",
"81438", "Kisarazu\,\ Chiba",
"812913", "Hokota\,\ Ibaraki",
"81934", "Kitakyushu\,\ Fukuoka",
"812995", "Ishioka\,\ Ibaraki",
"818689", "Okayama\,\ Okayama",
"81227", "Sendai\,\ Miyagi",
"815765", "Gero\,\ Gifu",
"819663", "Hitoyoshi\,\ Kumamoto",
"819974", "Yakushima\,\ Kagoshima",
"812419", "Tajima\,\ Fukushima",
"811587", "Nakayubetsu\,\ Hokkaido",
"8199331", "Kagoshima\,\ Kagoshima",
"815735", "Ena\,\ Gifu",
"811957", "Iwate\,\ Iwate",
"812859", "Oyama\,\ Tochigi",
"819783", "Bungotakada\,\ Oita",
"818665", "Takahashi\,\ Okayama",
"81244", "Hobara\,\ Fukushima",
"818682", "Tsuyama\,\ Okayama",
"815395", "Hamamatsu\,\ Shizuoka",
"812412", "Kitakata\,\ Fukushima",
"81738", "Gobo\,\ Wakayama",
"81172", "Hirosaki\,\ Aomori",
"817732", "Fukuchiyama\,\ Kyoto",
"817682", "Wajima\,\ Ishikawa",
"81533", "Toyohashi\,\ Aichi",
"818676", "Kuse\,\ Okayama",
"8153972", "Hamamatsu\,\ Shizuoka",
"81125", "Takikawa\,\ Hokkaido",
"817724", "Miyazu\,\ Kyoto",
"815753", "Sekigahara\,\ Gifu",
"812852", "Oyama\,\ Tochigi",
"812237", "Sendai\,\ Miyagi",
"817676", "Nanao\,\ Ishikawa",
"8125484", "Murakami\,\ Niigata",
"811532", "Nemuro\,\ Hokkaido",
"812235", "Sendai\,\ Miyagi",
"818372", "Nagato\,\ Yamaguchi",
"819968", "Izumi\,\ Kagoshima",
"811933", "Kamaishi\,\ Iwate",
"81852", "Matsue\,\ Shimane",
"817488", "Minakuchi\,\ Shiga",
"817914", "Aioi\,\ Hyogo",
"812618", "Omachi\,\ Nagano",
"817903", "Fukusaki\,\ Hyogo",
"819747", "Taketa\,\ Oita",
"819823", "Nobeoka\,\ Miyazaki",
"811562", "Honbetsu\,\ Hokkaido",
"81191", "Ichinoseki\,\ Iwate",
"81577", "Takayama\,\ Gifu",
"8198293", "Nobeoka\,\ Miyazaki",
"819938", "Kaseda\,\ Kagoshima",
"815366", "Shitara\,\ Aichi",
"811942", "Iwaizumi\,\ Iwate",
"811524", "Abashiri\,\ Hokkaido",
"811543", "Kushiro\,\ Hokkaido",
"81467", "Fujisawa\,\ Kanagawa",
"818667", "Ibara\,\ Okayama",
"811955", "Ninohe\,\ Iwate",
"818958", "Misho\,\ Ehime",
"812936", "Mito\,\ Ibaraki",
"81188", "Akita\,\ Akita",
"815737", "Nakatsugawa\,\ Gifu",
"8152", "Nagoya\,\ Aichi",
"812654", "Iida\,\ Nagano",
"81742", "Nara\,\ Nara",
"818696", "Bizen\,\ Okayama",
"818588", "Koge\,\ Tottori",
"811585", "Engaru\,\ Hokkaido",
"815767", "Gero\,\ Gifu",
"812997", "Itako\,\ Ibaraki",
"811462", "Urakawa\,\ Hokkaido",
"812744", "Fujioka\,\ Gunma",
"812546", "Murakami\,\ Niigata",
"819934", "Ibusuki\,\ Kagoshima",
"818675", "Kuse\,\ Okayama",
"814772", "Ichikawa\,\ Chiba",
"817675", "Nanao\,\ Ishikawa",
"811528", "Bihoro\,\ Hokkaido",
"819964", "Satsumasendai\,\ Kagoshima",
"81226", "Kesennuma\,\ Miyagi",
"815367", "Shitara\,\ Aichi",
"819544", "Takeo\,\ Saga",
"812614", "Omachi\,\ Nagano",
"811862", "Kazuno\,\ Akita",
"818387", "Tamagawa\,\ Yamaguchi",
"819746", "Taketa\,\ Oita",
"817484", "Yokaichi\,\ Shiga",
"81482", "Kawaguchi\,\ Saitama",
"818697", "Bizen\,\ Okayama",
"81550", "Gotenba\,\ Shizuoka",
"815736", "Nakatsugawa\,\ Gifu",
"812937", "Mito\,\ Ibaraki",
"818666", "Ibara\,\ Okayama",
"8147950", "Yokaichiba\,\ Chiba",
"812748", "Tomioka\,\ Gunma",
"818954", "Uwajima\,\ Ehime",
"812547", "Murakami\,\ Niigata",
"812996", "Itako\,\ Ibaraki",
"8128798", "Otawara\,\ Tochigi",
"815766", "Gero\,\ Gifu",
"811869", "Odate\,\ Akita",
"818584", "Kurayoshi\,\ Tottori",
"812967", "Kasama\,\ Ibaraki",
"81537", "Kakegawa\,\ Shizuoka",
"817954", "Nishiwaki\,\ Hyogo",
"812658", "Ina\,\ Nagano",
"812649", "Nagano\,\ Nagano",
"81594", "Kuwana\,\ Mie",
"819977", "Setouchi\,\ Kagoshima",
"8125482", "Murakami\,\ Niigata",
"81944", "Setaka\,\ Fukuoka",
"812745", "Fujioka\,\ Gunma",
"817492", "Hikone\,\ Shiga",
"811954", "Ninohe\,\ Iwate",
"81553", "Yamanashi\,\ Yamanashi",
"812655", "Iida\,\ Nagano",
"811584", "Engaru\,\ Hokkaido",
"81182", "Yokote\,\ Akita",
"81495", "Honjo\,\ Saitama",
"81546", "Shizuoka\,\ Shizuoka",
"81234", "Sakata\,\ Yamagata",
"818678", "Niimi\,\ Okayama",
"81848", "Onomichi\,\ Hiroshima",
"818832", "Kamojima\,\ Tokushima",
"811525", "Abashiri\,\ Hokkaido",
"817678", "Nanao\,\ Ishikawa",
"81927", "Fukuoka\,\ Fukuoka",
"812234", "Sendai\,\ Miyagi",
"8186999", "Seto\,\ Okayama",
"81543", "Shizuoka\,\ Shizuoka",
"8182941", "Hiroshima\,\ Hiroshima",
"818843", "Anan\,\ Tokushima",
"818592", "Yonago\,\ Tottori",
"812783", "Numata\,\ Gunma",
"817915", "Aioi\,\ Hyogo",
"812780", "Maebashi\,\ Gunma",
"817993", "Sumoto\,\ Hyogo",
"818955", "Uwajima\,\ Ehime",
"81888", "Kochi\,\ Kochi",
"811958", "Iwate\,\ Iwate",
"8153964", "Hamamatsu\,\ Shizuoka",
"81586", "Ichinomiya\,\ Aichi",
"81142", "Date\,\ Hokkaido",
"811588", "Okoppe\,\ Hokkaido",
"818585", "Kurayoshi\,\ Tottori",
"81559", "Numazu\,\ Shizuoka",
"814281", "Sagamihara\,\ Kanagawa",
"817955", "Sanda\,\ Hyogo",
"819976", "Naze\,\ Kagoshima",
"819953", "Okuchi\,\ Kagoshima",
"817949", "Kakogawa\,\ Hyogo",
"812383", "Yonezawa\,\ Yamagata",
"819552", "Imari\,\ Saga",
"81583", "Gifu\,\ Gifu",
"818949", "Uwajima\,\ Ehime",
"815959", "Kameyama\,\ Mie",
"818462", "Takehara\,\ Hiroshima",
"819965", "Satsumasendai\,\ Kagoshima",
"81549", "Shizuoka\,\ Shizuoka",
"8166", "Osaka\,\ Osaka",
"81984", "Kobayashi\,\ Miyazaki",
"81167", "Furano\,\ Hokkaido",
"812238", "Sendai\,\ Miyagi",
"8183766", "Shimonoseki\,\ Yamaguchi",
"811372", "Shikabe\,\ Hokkaido",
"81488", "Urawa\,\ Saitama",
"812615", "Omachi\,\ Nagano",
"812693", "Nakano\,\ Nagano",
"8186996", "Seto\,\ Okayama",
"817485", "Yokaichi\,\ Shiga",
"815582", "Shimoda\,\ Shizuoka",
"819935", "Kaseda\,\ Kagoshima",
"818674", "Kuse\,\ Okayama",
"817942", "Kakogawa\,\ Hyogo",
"818562", "Masuda\,\ Shimane",
"815983", "Matsusaka\,\ Mie",
"818892", "Sakawa\,\ Kochi",
"818543", "Yasugi\,\ Shimane",
"818942", "Yawatahama\,\ Ehime",
"817963", "Toyooka\,\ Hyogo",
"8126172", "Omachi\,\ Nagano",
"817674", "Hakui\,\ Ishikawa",
"81138", "Hakodate\,\ Hokkaido",
"815398", "Hamamatsu\,\ Shizuoka",
"818879", "Muroto\,\ Kochi",
"811732", "Goshogawara\,\ Aomori",
"811653", "Shibetsu\,\ Hokkaido",
"819937", "Kaseda\,\ Kagoshima",
"817702", "Tsuruga\,\ Fukui",
"817487", "Minakuchi\,\ Shiga",
"81825", "Hiroshima\,\ Hiroshima",
"818384", "Hagi\,\ Yamaguchi",
"81557", "Ito\,\ Shizuoka",
"819547", "Kashima\,\ Saga",
"811526", "Abashiri\,\ Hokkaido",
"81725", "Izumi\,\ Osaka",
"814709", "Kamogawa\,\ Chiba",
"819967", "Izumi\,\ Kagoshima",
"818290", "Hiroshima\,\ Hiroshima",
"812998", "Itako\,\ Ibaraki",
"81923", "Fukuoka\,\ Fukuoka",
"818293", "Hatsukaichi\,\ Hiroshima",
"812934", "Takahagi\,\ Ibaraki",
"818872", "Muroto\,\ Kochi",
"811635", "Hamatonbetsu\,\ Hokkaido",
"812656", "Ina\,\ Nagano",
"815768", "Gero\,\ Gifu",
"818694", "Okayama\,\ Okayama",
"81926", "Fukuoka\,\ Fukuoka",
"81425", "Tachikawa\,\ Tokyo",
"812964", "Shimodate\,\ Ibaraki",
"818587", "Koge\,\ Tottori",
"812673", "Komoro\,\ Nagano",
"814702", "Tateyama\,\ Chiba",
"812746", "Tomioka\,\ Gunma",
"818668", "Ibara\,\ Okayama",
"811392", "Kikonai\,\ Hokkaido",
"812544", "Shibata\,\ Niigata",
"81547", "Shimada\,\ Shizuoka",
"815738", "Nakatsugawa\,\ Gifu",
"818957", "Misho\,\ Ehime",
"819936", "Kaseda\,\ Kagoshima",
"815368", "Shitara\,\ Aichi",
"818388", "Tamagawa\,\ Yamaguchi",
"817725", "Miyazu\,\ Kyoto",
"81432", "Chiba\,\ Chiba",
"818249", "Higashi\-ku\,\ Hiroshima",
"819966", "Izumi\,\ Kagoshima",
"81460", "Odawara\,\ Kanagawa",
"8186995", "Seto\,\ Okayama",
"811527", "Bihoro\,\ Hokkaido",
"815394", "Hamamatsu\,\ Shizuoka",
"819546", "Kashima\,\ Saga",
"812616", "Omachi\,\ Nagano",
"819723", "Saiki\,\ Oita",
"81587", "Ichinomiya\,\ Aichi",
"819744", "Mie\,\ Oita",
"817486", "Minakuchi\,\ Shiga",
"812968", "Kasama\,\ Ibaraki",
"81832", "Shimonoseki\,\ Yamaguchi",
"812657", "Ina\,\ Nagano",
"818263", "Kake\,\ Hiroshima",
"818479", "Tojo\,\ Hiroshima",
"811332", "Tobetsu\,\ Hokkaido",
"818242", "Higashi\-ku\,\ Hiroshima",
"815734", "Ena\,\ Gifu",
"818973", "Niihama\,\ Ehime",
"818664", "Takahashi\,\ Okayama",
"81721", "Tondabayashi\,\ Osaka",
"81178", "Hachinohe\,\ Aomori",
"81929", "Fukuoka\,\ Fukuoka",
"818956", "Uwajima\,\ Ehime",
"812938", "Mito\,\ Ibaraki",
"812747", "Tomioka\,\ Gunma",
"812994", "Ishioka\,\ Ibaraki",
"818698", "Bizen\,\ Okayama",
"815764", "Gero\,\ Gifu",
"811362", "Kutchan\,\ Hokkaido",
"818586", "Kurayoshi\,\ Tottori",
"81166", "Asahikawa\,\ Hokkaido",
"817230", "Neyagawa\,\ Osaka",
"8147955", "Yokaichiba\,\ Chiba",
"817956", "Sanda\,\ Hyogo",
"819975", "Naze\,\ Kagoshima",
"815566", "Minobu\,\ Yamanashi",
"811645", "Rumoi\,\ Hokkaido",
"812672", "Komoro\,\ Nagano",
"81962", "Kumamoto\,\ Kumamoto",
"8126173", "Omachi\,\ Nagano",
"812564", "Sanjo\,\ Niigata",
"81924", "Fukuoka\,\ Fukuoka",
"812894", "Utsunomiya\,\ Tochigi",
"814700", "Kamogawa\,\ Chiba",
"814703", "Tateyama\,\ Chiba",
"818557", "Kawamoto\,\ Shimane",
"812797", "Shibukawa\,\ Gunma",
"815996", "Ago\,\ Mie",
"812838", "Sano\,\ Tochigi",
"811393", "Matsumae\,\ Hokkaido",
"81930", "Yukuhashi\,\ Fukuoka",
"818292", "Hiroshima\,\ Hiroshima",
"818873", "Aki\,\ Kochi",
"8112394", "Yubari\,\ Hokkaido",
"819437", "Tanushimaru\,\ Fukuoka",
"81250", "Niitsu\,\ Niigata",
"819738", "Kusu\,\ Oita",
"81947", "Tagawa\,\ Fukuoka",
"819596", "Fukue\,\ Nagasaki",
"819688", "Tamana\,\ Kumamoto",
"817703", "Tsuruga\,\ Fukui",
"819947", "Shibushi\,\ Kagoshima",
"817354", "Shingu\,\ Fukuoka",
"81728", "Neyagawa\,\ Osaka",
"812679", "Saku\,\ Nagano",
"817457", "Yamatotakada\,\ Nara",
"81828", "Hiroshima\,\ Hiroshima",
"811733", "Goshogawara\,\ Aomori",
"818299", "Hiroshima\,\ Hiroshima",
"814758", "Togane\,\ Chiba",
"817714", "Kameoka\,\ Kyoto",
"811652", "Shibetsu\,\ Hokkaido",
"812375", "Murayama\,\ Yamagata",
"815997", "Ago\,\ Mie",
"818556", "Gotsu\,\ Shimane",
"812796", "Shibukawa\,\ Gunma",
"815744", "Minokamo\,\ Gifu",
"81987", "Nichinan\,\ Miyazaki",
"814285", "Sagamihara\,\ Kanagawa",
"819575", "Isahaya\,\ Nagasaki",
"811363", "Kutchan\,\ Hokkaido",
"81280", "Koga\,\ Ibaraki",
"818262", "Kake\,\ Hiroshima",
"818240", "Higashi\-ku\,\ Hiroshima",
"818972", "Niihama\,\ Ehime",
"812834", "Utsunomiya\,\ Tochigi",
"812898", "Kanuma\,\ Tochigi",
"811333", "Tobetsu\,\ Hokkaido",
"818243", "Higashi\-ku\,\ Hiroshima",
"814754", "Mobara\,\ Chiba",
"817456", "Yamatotakada\,\ Nara",
"81277", "Kiryu\,\ Gunma",
"817239", "Neyagawa\,\ Osaka",
"819946", "Kanoya\,\ Kagoshima",
"817718", "Sonobe\,\ Kyoto",
"819597", "Fukue\,\ Nagasaki",
"819722", "Saiki\,\ Oita",
"819734", "Hita\,\ Oita",
"819684", "Yamaga\,\ Kumamoto",
"8125483", "Murakami\,\ Niigata",
"814240", "Kokubunji\,\ Tokyo",
"811357", "Iwanai\,\ Hokkaido",
"812878", "Nasukarasuyama\,\ Tochigi",
"818842", "Anan\,\ Tokushima",
"818593", "Yonago\,\ Tottori",
"81233", "Shinjo\,\ Yamagata",
"817992", "Sumoto\,\ Hyogo",
"811454", "Mukawa\,\ Hokkaido",
"812782", "Numata\,\ Gunma",
"81956", "Sasebo\,\ Nagasaki",
"8198294", "Nobeoka\,\ Miyazaki",
"812640", "Nagano\,\ Nagano",
"819808", "Yaeyama\ District\,\ Okinawa",
"812574", "Kashiwazaki\,\ Niigata",
"81544", "Fujinomiya\,\ Shizuoka",
"81236", "Yamagata\,\ Yamagata",
"812244", "Shiroishi\,\ Miyagi",
"81989", "Naha\,\ Okinawa",
"815977", "Kumano\,\ Mie",
"818833", "Kamojima\,\ Tokushima",
"81845", "Innoshima\,\ Hiroshima",
"811756", "Noheji\,\ Aomori",
"811554", "Obihiro\,\ Hokkaido",
"817493", "Hikone\,\ Shiga",
"818493", "Onomichi\,\ Hiroshima",
"812789", "Maebashi\,\ Gunma",
"81593", "Yokkaichi\,\ Mie",
"818490", "Onomichi\,\ Hiroshima",
"811984", "Hanamaki\,\ Iwate",
"811646", "Haboro\,\ Hokkaido",
"81798", "Nishinomiya\,\ Hyogo",
"819577", "Shimabara\,\ Nagasaki",
"81554", "Otsuki\,\ Yamanashi",
"812474", "Ishikawa\,\ Fukushima",
"814287", "Ome\,\ Tokyo",
"81596", "Ise\,\ Mie",
"81898", "Imabari\,\ Ehime",
"81946", "Amagi\,\ Fukuoka",
"812377", "Sagae\,\ Yamagata",
"811858", "Noshiro\,\ Akita",
"815995", "Ago\,\ Mie",
"818563", "Masuda\,\ Shimane",
"817940", "Kakogawa\,\ Hyogo",
"819804", "Nago\,\ Okinawa",
"815982", "Matsusaka\,\ Mie",
"815583", "Shimoda\,\ Shizuoka",
"812389", "Yonezawa\,\ Yamagata",
"817943", "Kakogawa\,\ Hyogo",
"818943", "Yawatahama\,\ Ehime",
"81983", "Takanabe\,\ Miyazaki",
"817962", "Toyooka\,\ Hyogo",
"812578", "Muika\,\ Niigata",
"818893", "Sakawa\,\ Kochi",
"811356", "Iwanai\,\ Hokkaido",
"812248", "Ogawara\,\ Miyagi",
"818542", "Yasugi\,\ Shimane",
"812874", "Otawara\,\ Tochigi",
"817455", "Yamatotakada\,\ Nara",
"81986", "Miyakonojo\,\ Miyazaki",
"819945", "Kanoya\,\ Kagoshima",
"812692", "Nakano\,\ Nagano",
"81192", "Ofunato\,\ Iwate",
"81485", "Kumagaya\,\ Saitama",
"812382", "Yonezawa\,\ Yamagata",
"819553", "Imari\,\ Saga",
"817463", "Yoshino\,\ Nara",
"81268", "Ueda\,\ Nagano",
"819952", "Okuchi\,\ Kagoshima",
"812478", "Miharu\,\ Fukushima",
"81273", "Takasaki\,\ Gunma",
"819435", "Yame\,\ Fukuoka",
"818463", "Takehara\,\ Hiroshima",
"811854", "Oga\,\ Akita",
"8186691", "Kurashiki\,\ Okayama",
"811757", "Noheji\,\ Aomori",
"817969", "Hamasaka\,\ Hyogo",
"812376", "Sagae\,\ Yamagata",
"811558", "Hiroo\,\ Hokkaido",
"818555", "Gotsu\,\ Shimane",
"812795", "Shibukawa\,\ Gunma",
"81276", "Ota\,\ Gunma",
"81885", "Komatsushima\,\ Tokushima",
"814286", "Sagamihara\,\ Kanagawa",
"81949", "Nogata\,\ Fukuoka",
"819576", "Shimabara\,\ Nagasaki",
"81584", "Ogaki\,\ Gifu",
"811647", "Haboro\,\ Hokkaido",
"812475", "Ishikawa\,\ Fukushima",
"812566", "Sanjo\,\ Niigata",
"812896", "Kanuma\,\ Tochigi",
"8153973", "Hamamatsu\,\ Shizuoka",
"81977", "Beppu\,\ Oita",
"819438", "Tanushimaru\,\ Fukuoka",
"811549", "Kushiro\,\ Hokkaido",
"815994", "Ago\,\ Mie",
"811463", "Urakawa\,\ Hokkaido",
"812837", "Sano\,\ Tochigi",
"811939", "Miyako\,\ Iwate",
"818558", "Kawamoto\,\ Shimane",
"812798", "Naganohara\,\ Gunma",
"811555", "Obihiro\,\ Hokkaido",
"81270", "Isesaki\,\ Gunma",
"81492", "Kawagoe\,\ Saitama",
"817356", "Kushimoto\,\ Wakayama",
"817902", "Fukusaki\,\ Hyogo",
"811563", "Honbetsu\,\ Hokkaido",
"819822", "Nobeoka\,\ Miyazaki",
"812575", "Tokamachi\,\ Niigata",
"812245", "Ogawara\,\ Miyagi",
"811542", "Kushiro\,\ Hokkaido",
"811943", "Iwaizumi\,\ Iwate",
"814757", "Togane\,\ Chiba",
"818514", "Ama\,\ Shimane",
"811932", "Kamaishi\,\ Iwate",
"81792", "Himeji\,\ Hyogo",
"811533", "Nemuro\,\ Hokkaido",
"818373", "Nagato\,\ Yamaguchi",
"819687", "Tamana\,\ Kumamoto",
"817716", "Sonobe\,\ Kyoto",
"81892", "Kumakogen\,\ Ehime",
"819737", "Kusu\,\ Oita",
"811455", "Mukawa\,\ Hokkaido",
"819948", "Shibushi\,\ Kagoshima",
"819679", "Takamori\,\ Kumamoto",
"818554", "Hamada\,\ Shimane",
"815746", "Minokamo\,\ Gifu",
"812794", "Shibukawa\,\ Gunma",
"812897", "Kanuma\,\ Tochigi",
"8199343", "Kagoshima\,\ Kagoshima",
"81940", "Munakata\,\ Fukuoka",
"819434", "Yame\,\ Fukuoka",
"815998", "Ago\,\ Mie",
"811855", "Noshiro\,\ Akita",
"812836", "Sano\,\ Tochigi",
"81262", "Nagano\,\ Nagano",
"814756", "Togane\,\ Chiba",
"81937", "Kitakyushu\,\ Fukuoka",
"812875", "Otawara\,\ Tochigi",
"817454", "Yamatotakada\,\ Nara",
"811863", "Kazuno\,\ Akita",
"817357", "Kushimoto\,\ Wakayama",
"819944", "Kanoya\,\ Kagoshima",
"8112392", "Yubari\,\ Hokkaido",
"819805", "Nago\,\ Okinawa",
"819598", "Fukue\,\ Nagasaki",
"819686", "Tamana\,\ Kumamoto",
"817717", "Sonobe\,\ Kyoto",
"81950", "Hirado\,\ Nagasaki",
"814770", "Ichikawa\,\ Chiba",
"812550", "Yasuzuka\,\ Niigata",
"81464", "Atsugi\,\ Kanagawa",
"812553", "Joetsu\,\ Niigata",
"812489", "Sukagawa\,\ Fukushima",
"8183768", "Shimonoseki\,\ Yamaguchi",
"815978", "Kumano\,\ Mie",
"817715", "Kameoka\,\ Kyoto",
"812582", "Nagaoka\,\ Niigata",
"8186998", "Seto\,\ Okayama",
"817355", "Shingu\,\ Fukuoka",
"812576", "Tokamachi\,\ Niigata",
"81249", "Koriyama\,\ Fukushima",
"812877", "Kuroiso\,\ Tochigi",
"812246", "Ogawara\,\ Miyagi",
"8186697", "Kurashiki\,\ Okayama",
"81722", "Sakai\,\ Osaka",
"811754", "Mutsu\,\ Aomori",
"814793", "Choshi\,\ Chiba",
"81864", "Kurashiki\,\ Okayama",
"812482", "Shirakawa\,\ Fukushima",
"812378", "Sagae\,\ Yamagata",
"811857", "Noshiro\,\ Akita",
"817612", "Komatsu\,\ Ishikawa",
"81565", "Toyota\,\ Aichi",
"811556", "Obihiro\,\ Hokkaido",
"811232", "Chitose\,\ Hokkaido",
"819578", "Shimabara\,\ Nagasaki",
"818363", "Ube\,\ Yamaguchi",
"81764", "Toyama\,\ Toyama",
"818360", "Ogori\,\ Yamaguchi",
"811986", "Tono\,\ Iwate",
"814288", "Ome\,\ Tokyo",
"812589", "Nagaoka\,\ Niigata",
"81822", "Hiroshima\,\ Hiroshima",
"811644", "Rumoi\,\ Hokkaido",
"812476", "Miharu\,\ Fukushima",
"81875", "Kan\'onji\,\ Kagawa",
"81259", "Sado\,\ Niigata",
"812565", "Sanjo\,\ Niigata",
"812895", "Utsunomiya\,\ Tochigi",
"81286", "Utsunomiya\,\ Tochigi",
"81775", "Otsu\,\ Shiga",
"811972", "Mizusawa\,\ Iwate",
"81939", "Kitakyushu\,\ Fukuoka",
"818202", "Yanai\,\ Yamaguchi",
"819735", "Hita\,\ Oita",
"819685", "Tamana\,\ Kumamoto",
"812853", "Oyama\,\ Tochigi",
"81243", "Nihonmatsu\,\ Fukushima",
"8186698", "Kurashiki\,\ Okayama",
"819789", "Kitsuki\,\ Oita",
"811354", "Yoichi\,\ Hokkaido",
"815752", "Sekigahara\,\ Gifu",
"818680", "Okayama\,\ Okayama",
"81979", "Nakatsu\,\ Oita",
"814755", "Togane\,\ Chiba",
"815974", "Owase\,\ Mie",
"812247", "Ogawara\,\ Miyagi",
"812876", "Kuroiso\,\ Tochigi",
"818683", "Tsuyama\,\ Okayama",
"8183767", "Shimonoseki\,\ Yamaguchi",
"812577", "Muika\,\ Niigata",
"81561", "Seto\,\ Aichi",
"817733", "Fukuchiyama\,\ Kyoto",
"818652", "Kurashiki\,\ Okayama",
"81246", "Iwaki\,\ Fukushima",
"817683", "Wajima\,\ Ishikawa",
"81534", "Hamamatsu\,\ Shizuoka",
"81835", "Hofu\,\ Yamaguchi",
"812413", "Kitakata\,\ Fukushima",
"8186997", "Seto\,\ Okayama",
"81253", "Niigata\,\ Niigata",
"811987", "Tono\,\ Iwate",
"81471", "Kashiwa\,\ Chiba",
"8198292", "Nobeoka\,\ Miyazaki",
"812835", "Sano\,\ Tochigi",
"819782", "Bungotakada\,\ Oita",
"811856", "Noshiro\,\ Akita",
"81933", "Kitakyushu\,\ Fukuoka",
"812374", "Murayama\,\ Yamagata",
"815745", "Minokamo\,\ Gifu",
"8147957", "Yokaichiba\,\ Chiba",
"811873", "Kakunodate\,\ Akita",
"81294", "Hitachiota\,\ Ibaraki",
"819662", "Hitoyoshi\,\ Kumamoto",
"814284", "Tachikawa\,\ Tokyo",
"81936", "Kitakyushu\,\ Fukuoka",
"812477", "Miharu\,\ Fukushima",
"819574", "Isahaya\,\ Nagasaki",};
my $timezones = {
               '' => [
                       'Asia/Tokyo'
                     ],
               '70859' => [
                            'Asia/Tokyo'
                          ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(000[2569]\d{4,6})$|(?:(?:003768)0?)|0)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;