package Net::Amazon::EMR::SupportedProductConfig;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;

has 'Args' => ( is => 'ro',
                isa => 'Net::Amazon::EMR::Type::ArrayRefofLongConstrainedStr',
                coerce => 1,
            );

has 'Name' => ( is => 'ro', 
                isa => 'Net::Amazon::EMR::Type::ConstrainedStr',
                coerce => 1,
            );

__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::SupportedProductConfig

=head1 DESCRIPTION

Implements the SupportedProductConfig data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_SupportedProductConfig.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
