# Generated by default/object.tt
package Paws::SecurityHub::AwsCertificateManagerCertificateRenewalSummary;
  use Moose;
  has DomainValidationOptions => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsCertificateManagerCertificateDomainValidationOption]');
  has RenewalStatus => (is => 'ro', isa => 'Str');
  has RenewalStatusReason => (is => 'ro', isa => 'Str');
  has UpdatedAt => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsCertificateManagerCertificateRenewalSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsCertificateManagerCertificateRenewalSummary object:

  $service_obj->Method(Att1 => { DomainValidationOptions => $value, ..., UpdatedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsCertificateManagerCertificateRenewalSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->DomainValidationOptions

=head1 DESCRIPTION

Contains information about the AWS Certificate Manager managed renewal
for an C<AMAZON_ISSUED> certificate.

=head1 ATTRIBUTES


=head2 DomainValidationOptions => ArrayRef[L<Paws::SecurityHub::AwsCertificateManagerCertificateDomainValidationOption>]

Information about the validation of each domain name in the
certificate, as it pertains to AWS Certificate Manager managed renewal.
Provided only when the certificate type is C<AMAZON_ISSUED>.


=head2 RenewalStatus => Str

The status of the AWS Certificate Manager managed renewal of the
certificate.

Valid values: C<PENDING_AUTO_RENEWAL> | C<PENDING_VALIDATION> |
C<SUCCESS> | C<FAILED>


=head2 RenewalStatusReason => Str

The reason that a renewal request was unsuccessful.

Valid values: C<NO_AVAILABLE_CONTACTS> |
C<ADDITIONAL_VERIFICATION_REQUIRED> | C<DOMAIN_NOT_ALLOWED> |
C<INVALID_PUBLIC_DOMAIN> | C<DOMAIN_VALIDATION_DENIED> | C<CAA_ERROR> |
C<PCA_LIMIT_EXCEEDED> | C<PCA_INVALID_ARN> | C<PCA_INVALID_STATE> |
C<PCA_REQUEST_FAILED> | C<PCA_NAME_CONSTRAINTS_VALIDATION> |
C<PCA_RESOURCE_NOT_FOUND> | C<PCA_INVALID_ARGS> |
C<PCA_INVALID_DURATION> | C<PCA_ACCESS_DENIED> | C<SLR_NOT_FOUND> |
C<OTHER>


=head2 UpdatedAt => Str

Indicates when the renewal summary was last updated.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

