package Acme::MetaSyntactic::hhgg;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::hhgg - The Hitch Hiker's Guide to the Galaxy theme

=head1 DESCRIPTION

Characters and other names from Douglas Adams's "Hitch Hiker's Guide to
the Galaxy" book series.

The list is very incomplete (it should contain at least 42 items).

After glancing at
L<http://en.wikisource.org/wiki/The_Ultra-Complete_Index_to_the_Hitch_Hiker%27s_Guide_to_the_Galaxy>,
I wonder if I should include all the entries...

=head1 CONTRIBUTORS

Aldo Calpini, Philippe Bruhat, Jean Forget.


=head1 CHANGES

=over 4

=item *

2012-05-07 - v1.000

Received its own version number in Acme-MetaSyntactic-Themes version 1.000.

=item *

2006-04-10

Link updated in Acme-MetaSyntactic version 0.69.

=item *

2005-06-27

Link to I<The Ultra-Complete Index to the Hitch Hiker's Guide to the Galaxy>
(written and entirely copyrighted 1992-94 by Mathias Maul)
entry on Wikipedia provided by Jean Forget in time for
Acme-MetaSyntactic version 0.28.

=item *

2005-03-21

Updated by Philippe "BooK" Bruhat (item C<fortytwo>)
in Acme-MetaSyntactic version 0.14.

=item *

2005-02-28

Introduced in Acme-MetaSyntactic version 0.11.

=item *

2005-02-22

Submitted by Aldo Calpini.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
answer arthur babelfish beeblebrox bugblatter_beast eccentrica_gallumbits 
fenchurch ford heartofgold jeltz kwaltz magrathea marvin milliways 
pan_galactic_gargle_blaster slartibartfast trillian vogon wonko zaphod
fortytwo
