package Microsoft::AdCenter::V7::CampaignManagementService::AdComponent;
# Copyright (C) 2012 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V7::CampaignManagementService::AdComponent - Represents "AdComponent" in Microsoft AdCenter Campaign Management Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    Ad
    AdDescription
    AdTitle
    AdTitleDescription
    AltText
    Asset
    Association
    Audio
    BiddingKeyword
    BusinessName
    CashbackTextParam
    CAsset
    Destination
    DestinationUrl
    DisplayUrl
    Flash
    Image
    Keyword
    KeywordParam1
    KeywordParam2
    KeywordParam3
    LandingUrl
    Order
    PhoneNumber
    Script
    SiteDomain
    Unknown
    Video

=cut

sub Ad {
    return 'Ad';
}

sub AdDescription {
    return 'AdDescription';
}

sub AdTitle {
    return 'AdTitle';
}

sub AdTitleDescription {
    return 'AdTitleDescription';
}

sub AltText {
    return 'AltText';
}

sub Asset {
    return 'Asset';
}

sub Association {
    return 'Association';
}

sub Audio {
    return 'Audio';
}

sub BiddingKeyword {
    return 'BiddingKeyword';
}

sub BusinessName {
    return 'BusinessName';
}

sub CashbackTextParam {
    return 'CashbackTextParam';
}

sub CAsset {
    return 'CAsset';
}

sub Destination {
    return 'Destination';
}

sub DestinationUrl {
    return 'DestinationUrl';
}

sub DisplayUrl {
    return 'DisplayUrl';
}

sub Flash {
    return 'Flash';
}

sub Image {
    return 'Image';
}

sub Keyword {
    return 'Keyword';
}

sub KeywordParam1 {
    return 'KeywordParam1';
}

sub KeywordParam2 {
    return 'KeywordParam2';
}

sub KeywordParam3 {
    return 'KeywordParam3';
}

sub LandingUrl {
    return 'LandingUrl';
}

sub Order {
    return 'Order';
}

sub PhoneNumber {
    return 'PhoneNumber';
}

sub Script {
    return 'Script';
}

sub SiteDomain {
    return 'SiteDomain';
}

sub Unknown {
    return 'Unknown';
}

sub Video {
    return 'Video';
}

1;
