package App::Toodledo::Context;
use strict;
use warnings;

our $VERSION = '1.00';

use Carp;
use Moose;
use MooseX::Method::Signatures;
use App::Toodledo::ContextInternal;

use Moose::Util::TypeConstraints;
BEGIN { class_type 'App::Toodledo' };

extends 'App::Toodledo::InternalWrapper';

has object => ( is => 'ro', isa => 'App::Toodledo::ContextInternal',
	        default => sub { App::Toodledo::ContextInternal->new },
	        handles => sub { __PACKAGE__->internal_attributes( $_[1] ) } );


method add ( App::Toodledo $todo! ) {
  my $added_ref = $todo->call_func( context => add => { name => $self->name } );
  $added_ref->[0]{id};
}


1;

__END__

=head1 NAME

App::Toodledo::Context - class encapsulating a Toodledo context

=head1 SYNOPSIS

  $context = App::Toodledo::Context->new;
  $context->name( 'Uraguay' )
  $todo = App::Toodledo->new;
  $todo->add_context( $context );

=head1 DESCRIPTION

This class provides accessors for the properties of a Toodledo context.
The attributes of a context are defined in the L<App::Toodledo::ContextRole>
module.

=head1 AUTHOR

Peter J. Scott, C<< <cpan at psdt.com> >>

=head1 SEE ALSO

Toodledo: L<http://www.toodledo.com/>.

Toodledo API documentation: L<http://www.toodledo.com/info/api_doc.php>.

=head1 COPYRIGHT & LICENSE

Copyright 2009-2011 Peter J. Scott, all rights reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut
