#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 xmobar
version:              0.50
visibility:           public
id:                   xmobar-0.50-cHoryGRH2XYh6rlopYrC
key:                  xmobar-0.50-cHoryGRH2XYh6rlopYrC
license:              BSD-3-Clause
maintainer:           Jose A. Ortega Ruiz <jao@gnu.org>
author:               Andrea Rossato and Jose A. Ortega Ruiz
homepage:             https://codeberg.org/xmobar/xmobar
synopsis:             A Minimalistic Text Based Status Bar
description:
    Xmobar is a minimalistic text based status bar.

    Inspired by the Ion3 status bar, it supports similar
    features, like dynamic color management, output templates,
    and extensibility through plugins.

category:             System
abi:                  0b68629b1c2168e26ab20276f4fc5b75
exposed:              True
exposed-modules:
    Xmobar Xmobar.Plugins.Accordion Xmobar.Plugins.Monitors.Common
    Xmobar.Plugins.Monitors.Common.Run
    Xmobar.Plugins.Monitors.Common.Types Xmobar.Plugins.Monitors.Cpu

hidden-modules:
    Paths_xmobar Xmobar.Config.Types Xmobar.Config.Parse
    Xmobar.Config.Template Xmobar.Run.Types Xmobar.Run.Timer
    Xmobar.Run.Template Xmobar.Run.Exec Xmobar.Run.Runnable
    Xmobar.Run.Actions Xmobar.Run.Loop Xmobar.Draw.Boxes
    Xmobar.Draw.Cairo Xmobar.Draw.Types Xmobar.App.Config
    Xmobar.App.Main Xmobar.App.Opts Xmobar.App.Compile
    Xmobar.System.Utils Xmobar.System.StatFS Xmobar.System.Environment
    Xmobar.System.Localize Xmobar.System.Signal Xmobar.System.Kbd
    Xmobar.Text.Ansi Xmobar.Text.Loop Xmobar.Text.Pango
    Xmobar.Text.Swaybar Xmobar.Text.SwaybarClicks Xmobar.Text.Output
    Xmobar.X11.Bitmap Xmobar.X11.CairoSurface Xmobar.X11.ColorCache
    Xmobar.X11.Draw Xmobar.X11.Events Xmobar.X11.Loop Xmobar.X11.Text
    Xmobar.X11.Types Xmobar.X11.Window Xmobar.Plugins.ArchUpdates
    Xmobar.Plugins.Command Xmobar.Plugins.BufferedPipeReader
    Xmobar.Plugins.CommandReader Xmobar.Plugins.Date
    Xmobar.Plugins.EWMH Xmobar.Plugins.HandleReader
    Xmobar.Plugins.QueueReader Xmobar.Plugins.PacmanUpdates
    Xmobar.Plugins.PipeReader Xmobar.Plugins.MarqueePipeReader
    Xmobar.Plugins.StdinReader Xmobar.Plugins.XMonadLog
    Xmobar.Plugins.Kbd Xmobar.Plugins.Locks Xmobar.Plugins.NotmuchMail
    Xmobar.Plugins.Monitors Xmobar.Plugins.Monitors.Batt
    Xmobar.Plugins.Monitors.Batt.Common
    Xmobar.Plugins.Monitors.Common.Output
    Xmobar.Plugins.Monitors.Common.Parsers
    Xmobar.Plugins.Monitors.Common.Files
    Xmobar.Plugins.Monitors.CoreTemp Xmobar.Plugins.Monitors.K10Temp
    Xmobar.Plugins.Monitors.Cpu.Common Xmobar.Plugins.Monitors.CpuFreq
    Xmobar.Plugins.Monitors.Disk Xmobar.Plugins.Monitors.Disk.Common
    Xmobar.Plugins.Monitors.Load Xmobar.Plugins.Monitors.Load.Common
    Xmobar.Plugins.Monitors.Mem Xmobar.Plugins.Monitors.MultiCoreTemp
    Xmobar.Plugins.Monitors.MultiCpu Xmobar.Plugins.Monitors.Net
    Xmobar.Plugins.Monitors.Net.Common Xmobar.Plugins.Monitors.Swap
    Xmobar.Plugins.Monitors.Thermal Xmobar.Plugins.Monitors.ThermalZone
    Xmobar.Plugins.Monitors.Top Xmobar.Plugins.Monitors.Top.Common
    Xmobar.Plugins.Monitors.Uptime Xmobar.Plugins.Monitors.Bright
    Xmobar.Plugins.Monitors.CatInt Xmobar.X11.XRender
    Xmobar.Plugins.Mail Xmobar.Plugins.MBox
    Xmobar.Plugins.Monitors.Wireless Xmobar.Plugins.Monitors.MPD
    Xmobar.Plugins.Monitors.Volume Xmobar.Plugins.Monitors.Alsa
    Xmobar.Plugins.DateZone Xmobar.Plugins.Monitors.Mpris
    Xmobar.System.DBus Xmobar.X11.XPMFile
    Xmobar.Plugins.Monitors.Weather Xmobar.Plugins.Monitors.Batt.Linux
    Xmobar.Plugins.Monitors.Cpu.Linux
    Xmobar.Plugins.Monitors.Disk.Linux
    Xmobar.Plugins.Monitors.Load.Linux
    Xmobar.Plugins.Monitors.Mem.Linux Xmobar.Plugins.Monitors.Net.Linux
    Xmobar.Plugins.Monitors.Swap.Linux
    Xmobar.Plugins.Monitors.Top.Linux
    Xmobar.Plugins.Monitors.Uptime.Linux

import-dirs:          /usr/lib/ghc-9.4.8/site-local/xmobar-0.50
library-dirs:         /usr/lib/ghc-9.4.8/site-local/xmobar-0.50
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/xmobar-0.50
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.4.8/xmobar-0.50
hs-libraries:         HSxmobar-0.50-cHoryGRH2XYh6rlopYrC
extra-libraries:      Xrandr Xrender Xpm
depends:
    X11-1.10.3-296FmCDygJo4Xo4fAuEwJZ
    X11-xft-0.3.4-8OK8Ht2L4wb8S4Grtm3d8O
    aeson-2.1.2.1-6h5MFvBT17H5yplsTy4ABm
    alsa-core-0.5.0.1-JLPmRcHiZRx1HOkmXNRClE
    alsa-mixer-0.3.0.1-64d7bL5FCNwLOsX9HNe40u
    async-2.2.5-J9xl5BKgt0u6YsIOuQfrTS base-4.17.2.1
    bytestring-0.11.5.3 cairo-0.13.12.0-9vlMj7BP3Ls92x1K4PqaCH
    cereal-0.5.8.3-H9MXf6i1TMkEAfnsx4oYbT
    colour-2.3.6-E5mZpOYwmYuGGXOrGjeX2u containers-0.6.7
    dbus-1.3.3-25TffrbC7l92KQE1rFUt8z directory-1.3.7.1
    extensible-exceptions-0.1.1.4-AGheGT2ZUDiCzp52FHEfjQ
    extra-1.7.16-4PSPnwgFT0S5iaiPzXfiD0 filepath-1.4.2.2
    hinotify-0.4.2-1UU66XmEQFrKarMyyyXmjn
    http-client-tls-0.3.6.4-26jJPqfpxqfJih66sxENJC
    http-conduit-2.3.9.1-I3hg1t6yVVq736m77Erhv1
    http-types-0.12.4-8KsSLLTB3zVcsjL7f3kez
    libmpd-0.10.0.1-CRvYZ5Rfshh6ydc2xx3ItP mtl-2.2.2
    netlink-1.1.1.0-EtwuQcOdMkCK92FWbMUZBF
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    pango-0.13.11.0-9BSQjDfoc6f35vScY3pzli parsec-3.1.16.1
    parsec-numbers-0.1.0-IKvzIVbeZPOFD4DHi1QStS process-1.6.18.0
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8 stm-2.5.1.0 time-1.12.2
    timezone-olson-0.2.1-BTp5R7q1AJdEnV7pV8RSLq
    timezone-series-0.1.13-21o0dMYZobR86i3h6j9FWj transformers-0.5.6.2
    unix-2.7.3 utf8-string-1.0.2-Kx3GnjsHBwcIRYSetT14kb

haddock-interfaces:
    /usr/share/doc/x86_64-linux-ghc-9.4.8/xmobar-0.50/html/xmobar.haddock

haddock-html:         /usr/share/doc/x86_64-linux-ghc-9.4.8/xmobar-0.50/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

