/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.catalina.Group;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Role;
import org.apache.catalina.Server;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class GlobalResourcesLifecycleListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(GlobalResourcesLifecycleListener.class);
    protected static final StringManager sm = StringManager.getManager(GlobalResourcesLifecycleListener.class);
    protected Lifecycle component = null;

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        if ("start".equals(lifecycleEvent.getType())) {
            if (!(lifecycleEvent.getLifecycle() instanceof Server)) {
                log.warn((Object)sm.getString("listener.notServer", new Object[]{lifecycleEvent.getLifecycle().getClass().getSimpleName()}));
            }
            this.component = lifecycleEvent.getLifecycle();
            this.createMBeans();
        } else if ("stop".equals(lifecycleEvent.getType())) {
            this.destroyMBeans();
            this.component = null;
        }
    }

    protected void createMBeans() {
        Context context;
        try {
            context = (Context)new InitialContext().lookup("java:/");
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("globalResources.noNamingContext"));
            return;
        }
        try {
            this.createMBeans("", context);
        }
        catch (NamingException namingException) {
            log.error((Object)sm.getString("globalResources.createError"), (Throwable)namingException);
        }
    }

    protected void createMBeans(String string, Context context) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("globalResources.create", new Object[]{string}));
        }
        try {
            NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
            while (namingEnumeration.hasMore()) {
                Binding binding = namingEnumeration.next();
                String string2 = string + binding.getName();
                Object object = context.lookup(binding.getName());
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Checking resource " + string2));
                }
                if (object instanceof Context) {
                    this.createMBeans(string2 + "/", (Context)object);
                    continue;
                }
                if (!(object instanceof UserDatabase)) continue;
                try {
                    this.createMBeans(string2, (UserDatabase)object);
                }
                catch (Exception exception) {
                    log.error((Object)sm.getString("globalResources.userDatabaseCreateError", new Object[]{string2}), (Throwable)exception);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            log.error((Object)sm.getString("globalResources.createError.runtime"), (Throwable)runtimeException);
        }
        catch (OperationNotSupportedException operationNotSupportedException) {
            log.error((Object)sm.getString("globalResources.createError.operation"), (Throwable)operationNotSupportedException);
        }
    }

    protected void createMBeans(String string, UserDatabase userDatabase) throws Exception {
        Object object;
        Object object2;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating UserDatabase MBeans for resource " + string));
            log.trace((Object)("Database=" + userDatabase));
        }
        try {
            MBeanUtils.createMBean(userDatabase);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(sm.getString("globalResources.createError.userDatabase", new Object[]{string}), exception);
        }
        if (userDatabase.isSparse()) {
            return;
        }
        Iterator<Role> iterator = userDatabase.getRoles();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (log.isTraceEnabled()) {
                log.trace((Object)("  Creating Role MBean for role " + object2));
            }
            try {
                MBeanUtils.createMBean((Role)object2);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(sm.getString("globalResources.createError.userDatabase.role", new Object[]{object2}), exception);
            }
        }
        object2 = userDatabase.getGroups();
        while (object2.hasNext()) {
            object = (Group)object2.next();
            if (log.isTraceEnabled()) {
                log.trace((Object)("  Creating Group MBean for group " + object));
            }
            try {
                MBeanUtils.createMBean((Group)object);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(sm.getString("globalResources.createError.userDatabase.group", new Object[]{object}), exception);
            }
        }
        object = userDatabase.getUsers();
        while (object.hasNext()) {
            User user = (User)object.next();
            if (log.isTraceEnabled()) {
                log.trace((Object)("  Creating User MBean for user " + user));
            }
            try {
                MBeanUtils.createMBean(user);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(sm.getString("globalResources.createError.userDatabase.user", new Object[]{user}), exception);
            }
        }
    }

    protected void destroyMBeans() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Destroying MBeans for Global JNDI Resources");
        }
    }
}

