/*
 * Decompiled with CFR 0.152.
 */
package hughai.utils;

import com.springrts.ai.oo.AIFloat3;
import com.springrts.ai.oo.CallbackAIException;
import com.springrts.ai.oo.clb.Map;
import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.TerrainPos;
import hughai.mapping.HeightMap;
import hughai.ui.MainUI;
import hughai.unitdata.BuildTable;
import hughai.utils.Config;
import hughai.utils.LogFile;
import java.util.Stack;

public class DrawingUtils {
    CSAI csai;
    OOAICallback aicallback;
    BuildTable buildTable;
    LogFile logfile;
    Config config;
    PlayerObjects playerObjects;
    final int maxlines;
    int linesDrawn = 0;
    Stack<Boolean> cheatingStack = new Stack();

    public DrawingUtils(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.aicallback = playerObjects.getAicallback();
        this.buildTable = playerObjects.getBuildTable();
        this.logfile = playerObjects.getLogFile();
        this.config = playerObjects.getConfig();
        this.playerObjects = playerObjects;
        this.maxlines = this.config.getMaxLinesOnMap();
        this.csai.registerGameListener(new GameListener());
        this.csai.RegisterVoiceCommand("drawpoint", new VoiceDrawPoint());
        playerObjects.getMainUI().registerButton("Clean map lines", new CleanMapButton());
    }

    public void CleanDrawing() {
        this.csai.sendTextMessage("cleaning map...");
        this.pushCheating();
        this.setCheating(false);
        int n = this.playerObjects.getMaps().getMovementMaps().SQUARE_SIZE;
        int n2 = this.aicallback.getMap().getWidth() * n;
        int n3 = this.aicallback.getMap().getHeight() * n;
        this.logfile.WriteLine("cleandrawing, " + n2 + " x " + n3);
        for (int i = 0; i < n3; i += 100) {
            for (int j = 0; j < n2; j += 100) {
                float f = this.aicallback.getMap().getElevationAt((float)j, (float)i);
                try {
                    this.aicallback.getMap().getDrawer().deletePointsAndLines(new AIFloat3((float)j, f, (float)i));
                    continue;
                }
                catch (CallbackAIException callbackAIException) {
                    this.logfile.writeStackTrace((Exception)((Object)callbackAIException));
                }
            }
        }
        this.popCheating();
        this.csai.sendTextMessage(" ... done");
        this.linesDrawn = 0;
    }

    public void setFigureColor(float f, float f2, float f3) {
    }

    public void AddLine(TerrainPos terrainPos, TerrainPos terrainPos2) {
        if (this.linesDrawn >= this.maxlines) {
            this.csai.sendTextMessage("DrawingUtils.AddLine: too many lines drawn.  drawing more would crash Spring...");
            return;
        }
        this.pushCheating();
        this.setCheating(false);
        try {
            this.aicallback.getMap().getDrawer().addLine(terrainPos.toAIFloat3(), terrainPos2.toAIFloat3());
        }
        catch (CallbackAIException callbackAIException) {
            this.logfile.writeStackTrace((Exception)((Object)callbackAIException));
        }
        ++this.linesDrawn;
        this.popCheating();
    }

    void pushCheating() {
        this.cheatingStack.push(this.isCheating());
    }

    boolean isCheating() {
        return this.playerObjects.getAicallback().getCheats().isEnabled();
    }

    void setCheating(boolean bl) {
        if (this.isCheating() != bl) {
            this.playerObjects.getAicallback().getCheats().setEnabled(bl);
        }
    }

    void popCheating() {
        boolean bl = this.cheatingStack.pop();
        this.setCheating(bl);
    }

    public void DrawUnit(UnitDef unitDef, TerrainPos terrainPos, float f, int n, int n2, boolean bl, boolean bl2, int n3) {
        try {
            this.aicallback.getMap().getDrawer().drawUnit(unitDef, terrainPos.toAIFloat3(), f, n, n2, bl, bl2, n3);
        }
        catch (CallbackAIException callbackAIException) {
            this.logfile.writeStackTrace((Exception)((Object)callbackAIException));
        }
    }

    public void DrawUnit(String string, TerrainPos terrainPos) {
        this.DrawUnit(string, terrainPos, 0.0f, 200, this.aicallback.getSkirmishAI().getTeamId(), true, false);
    }

    public void DrawUnit(String string, TerrainPos terrainPos, float f, int n, int n2, boolean bl, boolean bl2) {
        if (terrainPos == null) {
            throw new RuntimeException("drawunit: pos was null");
        }
        UnitDef unitDef = this.buildTable.getUnitDefByName(string.toLowerCase());
        if (unitDef == null) {
            throw new RuntimeException("unit " + string + " doesn't exist.");
        }
        n = 200;
        try {
            this.aicallback.getMap().getDrawer().drawUnit(unitDef, terrainPos.toAIFloat3(), f, n, n2, bl, bl2, 0);
        }
        catch (CallbackAIException callbackAIException) {
            this.logfile.writeStackTrace((Exception)((Object)callbackAIException));
        }
    }

    public void drawText(TerrainPos terrainPos, String string) {
        this.pushCheating();
        this.setCheating(false);
        try {
            this.aicallback.getMap().getDrawer().addPoint(terrainPos.toAIFloat3(), string);
        }
        catch (CallbackAIException callbackAIException) {
            this.logfile.writeStackTrace((Exception)((Object)callbackAIException));
        }
        this.popCheating();
    }

    public void DrawRectangle(TerrainPos terrainPos, int n, int n2) {
        float f = this.aicallback.getMap().getElevationAt(terrainPos.x, terrainPos.z) + 10.0f;
        this.AddLine(terrainPos.add(new TerrainPos(0.0f, f, 0.0f)), terrainPos.add(new TerrainPos(n, f, 0.0f)));
        this.AddLine(terrainPos.add(new TerrainPos(n, f, 0.0f)), terrainPos.add(new TerrainPos(n, f, n2)));
        this.AddLine(terrainPos.add(new TerrainPos(n, f, n2)), terrainPos.add(new TerrainPos(0.0f, f, n2)));
        this.AddLine(terrainPos.add(new TerrainPos(0.0f, f, n2)), terrainPos.add(new TerrainPos(0.0f, f, 0.0f)));
    }

    public void DrawCircle(TerrainPos terrainPos, double d) {
        TerrainPos terrainPos2 = null;
        for (int i = 0; i <= 360; i += 20) {
            int n = (int)(d * Math.cos((double)i * Math.PI / 180.0));
            int n2 = (int)(d * Math.sin((double)i * Math.PI / 180.0));
            TerrainPos terrainPos3 = new TerrainPos(n, 0.0f, n2).add(terrainPos);
            if (terrainPos2 != null) {
                this.AddLine(terrainPos3, terrainPos2);
            }
            terrainPos2 = terrainPos3;
        }
    }

    public void DrawMap(int[][] nArray) {
        Map map = this.aicallback.getMap();
        int n = nArray.length;
        int n2 = nArray[0].length;
        int n3 = map.getWidth();
        int n4 = map.getHeight();
        int n5 = n3 / n * 8;
        boolean bl = false;
        int n6 = this.config.getMapDrawGranularity();
        int n7 = n6 * n / n3;
        this.logfile.WriteLine("drawingUtils.drawmap granularity: " + n6 + " skip: " + n7 + " mapwidth: " + n + " / " + n3 + " x " + n2 + " / " + n4);
        if (n7 < 1) {
            n7 = 1;
        }
        HeightMap heightMap = this.playerObjects.getMaps().getHeightMap();
        for (int i = 0; i < n2; i += n7) {
            for (int j = 0; j < n; j += n7) {
                float f = heightMap.getElevationAt(new HeightMap.HeightMapPos(j, i));
                if (j < n - n7 && nArray[j][i] != nArray[j + n7][i]) {
                    this.AddLine(new TerrainPos((j + n7) * n5, f, i * n5), new TerrainPos((j + n7) * n5, f, (i + n7) * n5));
                }
                if (i >= n2 - n7 || nArray[j][i] == nArray[j][i + n7]) continue;
                this.AddLine(new TerrainPos(j * n5, f, (i + n7) * n5), new TerrainPos((j + n7) * n5, f, (i + n7) * n5));
            }
        }
    }

    public void DrawMap(boolean[][] blArray) {
        Map map = this.aicallback.getMap();
        int n = blArray.length;
        int n2 = blArray[0].length;
        int n3 = map.getWidth() / n * 8;
        boolean bl = false;
        for (int i = 1; i < n2 - 1; ++i) {
            for (int j = 1; j < n - 1; ++j) {
                float f;
                if (j < n - 2 && blArray[j][i] != blArray[j + 1][i]) {
                    f = map.getElevationAt((float)(j * n3), (float)(i * n3)) + 10.0f;
                    this.AddLine(new TerrainPos((j + 1) * n3, f, i * n3), new TerrainPos((j + 1) * n3, f, (i + 1) * n3));
                }
                if (i >= n2 - 2 || blArray[j][i] == blArray[j][i + 1]) continue;
                f = map.getElevationAt((float)(j * n3), (float)(i * n3)) + 10.0f;
                this.AddLine(new TerrainPos(j * n3, f, (i + 1) * n3), new TerrainPos((j + 1) * n3, f, (i + 1) * n3));
            }
        }
    }

    class GameListener
    extends GameAdapter {
        GameListener() {
        }
    }

    class VoiceCleanMap
    implements VoiceCommandHandler {
        VoiceCleanMap() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            DrawingUtils.this.CleanDrawing();
        }
    }

    class VoiceDrawPoint
    implements VoiceCommandHandler {
        VoiceDrawPoint() {
        }

        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            float f = Float.parseFloat(stringArray[2]);
            float f2 = Float.parseFloat(stringArray[3]);
            DrawingUtils.this.drawText(new TerrainPos(f, 0.0f, f2), "(" + f + ", " + f2 + ")");
        }
    }

    class CleanMapButton
    implements MainUI.ButtonHandler {
        CleanMapButton() {
        }

        @Override
        public void go() {
            DrawingUtils.this.CleanDrawing();
        }
    }
}

