/*
 * Decompiled with CFR 0.152.
 */
package hughai.utils;

import hughai.PlayerObjects;
import hughai.utils.ConfigSourceReadWriter;
import hughai.utils.ReflectionHelper;
import java.io.File;

public class ConfigFileReadWriter<T>
implements ConfigSourceReadWriter<T> {
    PlayerObjects playerObjects;
    ReflectionHelper reflectionHelper;

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    public ConfigFileReadWriter(PlayerObjects playerObjects) {
        this.playerObjects = playerObjects;
        this.reflectionHelper = new ReflectionHelper(playerObjects);
    }

    void debug(Object object) {
        this.playerObjects.getLogFile().writeLine("ConfigFileReadWrite: " + object);
    }

    @Override
    public void loadConfig(T t) {
        String string = this.getConfigPath();
        if (new File(string).exists()) {
            this.reflectionHelper.loadObjectFromFile(string, t);
            this.validate();
        }
        this.reflectionHelper.saveObjectToFile(string, t);
    }

    void validate() {
    }

    @Override
    public void saveConfig(T t) {
        this.reflectionHelper.saveObjectToFile(this.getConfigPath(), t);
    }

    String getConfigPath() {
        this.debug("getconfigpath()");
        String string = this.playerObjects.getCSAI().getAIDirectoryPath() + this.playerObjects.getAicallback().getMod().getShortName() + ".xml";
        this.debug("Config path: " + string);
        return string;
    }
}

