#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 ShellCheck
version:              0.11.0
visibility:           public
id:                   ShellCheck-0.11.0-IGhFNe5w4bKaPUpfjeDoO
key:                  ShellCheck-0.11.0-IGhFNe5w4bKaPUpfjeDoO
license:              GPL-3.0-only
maintainer:           vidar@vidarholen.net
author:               Vidar Holen
homepage:             https://www.shellcheck.net/
synopsis:             Shell script analysis tool
description:
    The goals of ShellCheck are:

    * To point out and clarify typical beginner'\''s syntax issues,
    that causes a shell to give cryptic error messages.

    * To point out and clarify typical intermediate level semantic problems,
    that causes a shell to behave strangely and counter-intuitively.

    * To point out subtle caveats, corner cases and pitfalls, that may cause an
    advanced user'\''s otherwise working script to fail under future circumstances.

category:             Static Analysis
abi:                  5df9425abf76d2e282f442505e3c6df5
exposed:              True
exposed-modules:
    ShellCheck.AST ShellCheck.ASTLib ShellCheck.Analytics
    ShellCheck.Analyzer ShellCheck.AnalyzerLib ShellCheck.CFG
    ShellCheck.CFGAnalysis ShellCheck.Checker
    ShellCheck.Checks.Commands ShellCheck.Checks.ControlFlow
    ShellCheck.Checks.Custom ShellCheck.Checks.ShellSupport
    ShellCheck.Data ShellCheck.Debug ShellCheck.Fixer
    ShellCheck.Formatter.CheckStyle ShellCheck.Formatter.Diff
    ShellCheck.Formatter.Format ShellCheck.Formatter.GCC
    ShellCheck.Formatter.JSON ShellCheck.Formatter.JSON1
    ShellCheck.Formatter.Quiet ShellCheck.Formatter.TTY
    ShellCheck.Interface ShellCheck.Parser ShellCheck.Prelude
    ShellCheck.Regex

hidden-modules:       Paths_ShellCheck
import-dirs:          /usr/lib/ghc-9.4.8/site-local/ShellCheck-0.11.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/ShellCheck-0.11.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/ShellCheck-0.11.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/shellcheck
hs-libraries:         HSShellCheck-0.11.0-IGhFNe5w4bKaPUpfjeDoO
depends:
    Diff-0.5-DfgrTjzmKsXIKxa4pCXDt2
    QuickCheck-2.15.0.1-59GGzHy0g7bISHsBJt3oMz
    aeson-2.1.2.1-4RB85zdNr5p3whZ1np3a31 array-0.5.4.0 base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7 deepseq-1.4.8.0
    directory-1.3.7.1 fgl-5.8.3.0-7EHjvOEhpwGLToGv19JT5o
    filepath-1.4.2.2 mtl-2.2.2 parsec-3.1.16.1 process-1.6.18.0
    regex-tdfa-1.3.2.4-8SMpKQokk9j1XbuNe0lCm6 transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/shellcheck/html/ShellCheck.haddock
haddock-html:         /usr/share/doc/shellcheck/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

