\name{MorphologicalWatershedImageFilter}
\alias{MorphologicalWatershedImageFilter}
\title{MorphologicalWatershedImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Watershed segmentation implementation with morphological operators.
MorphologicalWatershedImageFilter}
\details{
Watershed pixel are labeled 0. TOutputImage should be an integer type.
Labels of output image are in no particular order. You can reorder the
labels such that object labels are consecutive and sorted based on
object size by passing the output of this filter to a RelabelComponentImageFilter .
The morphological watershed transform algorithm is described in
Chapter 9.2 of Pierre Soille's book "Morphological Image Analysis:
Principles and Applications", Second Edition, Springer, 2003.
This code was contributed in the Insight Journal paper: "The
watershed transform in ITK - discussion and new developments" by
Beare R., Lehmann G. https://www.insight-journal.org/browse/publication/92
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
WatershedImageFilter , MorphologicalWatershedFromMarkersImageFilter
MorphologicalWatershed for the procedural interface
itk::MorphologicalWatershedImageFilter for the Doxygen on the original ITK class.
MorphologicalWatershedImageFilter}
%C++ includes: sitkMorphologicalWatershedImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{double GetLevel() const:}{}
\item{bool GetMarkWatershedLine() const:}{
Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self MarkWatershedLineOff():}{}
\item{Self MarkWatershedLineOn():}{
Set the value of MarkWatershedLine to true or false respectfully.
}
\item{ MorphologicalWatershedImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{Self SetLevel(double Level):}{}
\item{Self SetMarkWatershedLine(bool MarkWatershedLine):}{
Set/Get whether the watershed pixel must be marked or not. Default is
true. Set it to false do not only avoid writing watershed pixels, it
also decrease algorithm complexity.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~MorphologicalWatershedImageFilter():}{
Destructor
}
}
}
