# The PEP 484 type hints stub file for the _server module.
#
# Generated by SIP 6.15.0


import collections, re, typing

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt5.sip

from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5 import QtXml
from PyQt5 import QtNetwork
from PyQt5 import QtWidgets
from PyQt5 import QtSql
from PyQt5 import QtPrintSupport
from PyQt5 import QtPositioning
from PyQt5 import QtSerialPort
from qgis import _core

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., Any], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class QgsCapabilitiesCache(QtCore.QObject):

    def __init__(self, size: int) -> None: ...

    def removeCapabilitiesDocument(self, path: str|None) -> None: ...
    def insertCapabilitiesDocument(self, configFilePath: str|None, key: str|None, doc: QtXml.QDomDocument|None) -> None: ...
    def searchCapabilitiesDocument(self, configFilePath: str|None, key: str|None) -> QtXml.QDomDocument|None: ...


class QgsConfigCache(QtCore.QObject):

    def __init__(self, settings: 'QgsServerSettings|None') -> None: ...

    def removeChangedEntries(self) -> None: ...
    def removeChangedEntry(self, path: str|None) -> None: ...
    projectRemovedFromCache: typing.ClassVar[QtCore.pyqtSignal]
    def projects(self) -> list[_core.QgsProject]: ...
    def strategyName(self) -> str: ...
    def project(self, path: str|None, settings: 'QgsServerSettings|None' = ...) -> _core.QgsProject|None: ...
    def removeEntry(self, path: str|None) -> None: ...
    @staticmethod
    def instance() -> 'QgsConfigCache|None': ...
    @staticmethod
    def initialize(settings: 'QgsServerSettings|None') -> None: ...


class QgsServerApi(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, serverIface: 'QgsServerInterface|None') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerApi') -> None: ...

    def serverIface(self) -> 'QgsServerInterface|None': ...
    def executeRequest(self, context: 'QgsServerApiContext') -> None: ...
    def accept(self, url: QtCore.QUrl) -> bool: ...
    def rootPath(self) -> str: ...
    def version(self) -> str: ...
    def description(self) -> str: ...
    def name(self) -> str: ...


class QgsServerApiContext(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, apiRootPath: str|None, request: 'QgsServerRequest|None', response: 'QgsServerResponse|None', project: _core.QgsProject|None, serverInterface: 'QgsServerInterface|None') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerApiContext') -> None: ...

    def handlerPath(self) -> str: ...
    def setRequest(self, request: 'QgsServerRequest|None') -> None: ...
    def apiRootPath(self) -> str: ...
    def matchedPath(self) -> str: ...
    def serverInterface(self) -> 'QgsServerInterface|None': ...
    def setProject(self, project: _core.QgsProject|None) -> None: ...
    def project(self) -> _core.QgsProject|None: ...
    def response(self) -> 'QgsServerResponse|None': ...
    def request(self) -> 'QgsServerRequest|None': ...


class QgsServerLogger(_core.QgsMessageLogConsole):

    def __init__(self) -> None: ...

    def logMessage(self, message: str|None, tag: str|None, level: _core.Qgis.MessageLevel) -> None: ...
    def setLogStderr(self) -> None: ...
    def setLogFile(self, filename: str|None = ...) -> None: ...
    def setLogLevel(self, level: _core.Qgis.MessageLevel) -> None: ...
    def logLevel(self) -> _core.Qgis.MessageLevel: ...
    @staticmethod
    def instance() -> 'QgsServerLogger|None': ...


class QgsServerOgcApi(QgsServerApi):

    class ContentType(int):
        GEOJSON = ... # type: QgsServerOgcApi.ContentType
        OPENAPI3 = ... # type: QgsServerOgcApi.ContentType
        JSON = ... # type: QgsServerOgcApi.ContentType
        HTML = ... # type: QgsServerOgcApi.ContentType
        XML = ... # type: QgsServerOgcApi.ContentType

    class Rel(int):
        alternate = ... # type: QgsServerOgcApi.Rel
        describedBy = ... # type: QgsServerOgcApi.Rel
        collection = ... # type: QgsServerOgcApi.Rel
        item = ... # type: QgsServerOgcApi.Rel
        self = ... # type: QgsServerOgcApi.Rel
        service_desc = ... # type: QgsServerOgcApi.Rel
        service_doc = ... # type: QgsServerOgcApi.Rel
        prev = ... # type: QgsServerOgcApi.Rel
        next = ... # type: QgsServerOgcApi.Rel
        license = ... # type: QgsServerOgcApi.Rel
        items = ... # type: QgsServerOgcApi.Rel
        conformance = ... # type: QgsServerOgcApi.Rel
        data = ... # type: QgsServerOgcApi.Rel

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, serverIface: 'QgsServerInterface|None', rootPath: str|None, name: str|None, description: str|None = ..., version: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerOgcApi') -> None: ...

    @staticmethod
    def mimeType(contentType: 'QgsServerOgcApi.ContentType') -> typing.Any: ...
    @staticmethod
    def contentTypeFromExtension(extension: typing.Any) -> 'QgsServerOgcApi.ContentType': ...
    @staticmethod
    @deprecated("""""")
    def contenTypeFromExtension(extension: typing.Any) -> 'QgsServerOgcApi.ContentType': ...
    @staticmethod
    def contentTypeToExtension(ct: 'QgsServerOgcApi.ContentType') -> str: ...
    @staticmethod
    def contentTypeToStdString(ct: 'QgsServerOgcApi.ContentType') -> typing.Any: ...
    @staticmethod
    def contentTypeToString(ct: 'QgsServerOgcApi.ContentType') -> str: ...
    @staticmethod
    def relToString(rel: 'QgsServerOgcApi.Rel') -> typing.Any: ...
    @staticmethod
    def sanitizeUrl(url: QtCore.QUrl) -> QtCore.QUrl: ...
    def registerHandler(self, handler: 'QgsServerOgcApiHandler|None') -> None: ...
    def executeRequest(self, context: QgsServerApiContext) -> None: ...
    def rootPath(self) -> str: ...
    def version(self) -> str: ...
    def description(self) -> str: ...
    def name(self) -> str: ...


class QgsServerOgcApiHandler(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerOgcApiHandler') -> None: ...

    def setContentTypes(self, contentTypes: collections.abc.Iterable[int]) -> None: ...
    @staticmethod
    def layerFromCollectionId(context: QgsServerApiContext, collectionId: str|None) -> _core.QgsVectorLayer|None: ...
    @staticmethod
    def parentLink(url: QtCore.QUrl, levels: int = ...) -> str: ...
    def contentTypeFromRequest(self, request: 'QgsServerRequest|None') -> QgsServerOgcApi.ContentType: ...
    def staticPath(self, context: QgsServerApiContext) -> str: ...
    def templatePath(self, context: QgsServerApiContext) -> str: ...
    def href(self, context: QgsServerApiContext, extraPath: str|None = ..., extension: str|None = ...) -> typing.Any: ...
    def write(self, data: typing.Any, context: QgsServerApiContext, htmlMetadata: dict[str, typing.Any] = ...) -> None: ...
    def contentTypeForAccept(self, accept: str|None) -> str: ...
    def values(self, context: QgsServerApiContext) -> dict[str, typing.Any]: ...
    def handleRequest(self, context: QgsServerApiContext) -> None: ...
    def defaultContentType(self) -> QgsServerOgcApi.ContentType: ...
    def tags(self) -> list[str]: ...
    def linkType(self) -> QgsServerOgcApi.Rel: ...
    def linkTitle(self) -> typing.Any: ...
    def description(self) -> typing.Any: ...
    def summary(self) -> typing.Any: ...
    def parameters(self, context: QgsServerApiContext) -> list['QgsServerQueryStringParameter']: ...
    def operationId(self) -> typing.Any: ...
    def path(self) -> QtCore.QRegularExpression: ...


class QgsServerStaticHandler(QgsServerOgcApiHandler):

    @typing.overload
    def __init__(self, pathRegExp: str|None = ..., staticPathSuffix: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerStaticHandler') -> None: ...

    def linkType(self) -> QgsServerOgcApi.Rel: ...
    def linkTitle(self) -> typing.Any: ...
    def description(self) -> typing.Any: ...
    def summary(self) -> typing.Any: ...
    def operationId(self) -> typing.Any: ...
    def path(self) -> QtCore.QRegularExpression: ...
    def handleRequest(self, context: QgsServerApiContext) -> None: ...


class QgsServerParameterDefinition(PyQt5.sip.wrapper):

    mDefaultValue = ... # type: typing.Any
    mType = ... # type: QtCore.QMetaType.Type
    mValue = ... # type: typing.Any

    @typing.overload
    def __init__(self, type: QtCore.QMetaType.Type = ..., defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    @deprecated("""""")
    def __init__(self, type: QtCore.QVariant.Type, defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerParameterDefinition') -> None: ...

    @staticmethod
    def raiseError(msg: str|None) -> None: ...
    def loadUrl(self) -> typing.Tuple[str, bool]: ...
    def toUrl(self) -> typing.Tuple[QtCore.QUrl, bool]: ...
    def toColor(self) -> typing.Tuple[QtGui.QColor, bool]: ...
    def toBool(self) -> bool: ...
    def toDouble(self) -> typing.Tuple[float, bool]: ...
    def toInt(self) -> typing.Tuple[int, bool]: ...
    def toRectangle(self) -> typing.Tuple[_core.QgsRectangle, bool]: ...
    def toExpressionList(self) -> list[str]: ...
    def toOgcFilterList(self) -> list[str]: ...
    def toGeomList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> typing.Tuple[list[_core.QgsGeometry], bool]: ...
    def toColorList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> typing.Tuple[list[QtGui.QColor], bool]: ...
    def toDoubleList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> typing.Tuple[list[float], bool]: ...
    def toIntList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> typing.Tuple[list[int], bool]: ...
    def toStringList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> list[str]: ...
    def toString(self, defaultValue: bool = ...) -> str: ...
    def isValid(self) -> bool: ...
    def typeName(self) -> str: ...


class QgsServerParameter(QgsServerParameterDefinition):

    class Name(int):
        UNKNOWN = ... # type: QgsServerParameter.Name
        SERVICE = ... # type: QgsServerParameter.Name
        VERSION_SERVICE = ... # type: QgsServerParameter.Name
        REQUEST = ... # type: QgsServerParameter.Name
        MAP = ... # type: QgsServerParameter.Name
        FILE_NAME = ... # type: QgsServerParameter.Name

    mName = ... # type: 'QgsServerParameter.Name'
    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, name: 'QgsServerParameter.Name' = ..., type: QtCore.QMetaType.Type = ..., defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    @deprecated("""""")
    def __init__(self, name: 'QgsServerParameter.Name', type: QtCore.QVariant.Type, defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerParameter') -> None: ...

    @typing.overload
    @staticmethod
    def name(name: 'QgsServerParameter.Name') -> str: ...
    @typing.overload
    @staticmethod
    def name(name: str|None) -> 'QgsServerParameter.Name': ...
    def raiseError(self) -> None: ...


class QgsServerParameters(PyQt5.sip.wrapper):

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, query: QtCore.QUrlQuery) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerParameters') -> None: ...

    def loadParameter(self, name: str|None, value: str|None) -> bool: ...
    def version(self) -> str: ...
    def fileName(self) -> str: ...
    def map(self) -> str: ...
    def request(self) -> str: ...
    def service(self) -> str: ...
    def toMap(self) -> dict[str, str]: ...
    def urlQuery(self) -> QtCore.QUrlQuery: ...
    def value(self, key: str|None) -> str: ...
    @typing.overload
    def remove(self, key: str|None) -> None: ...
    @typing.overload
    def remove(self, name: QgsServerParameter.Name) -> None: ...
    def add(self, key: str|None, value: str|None) -> None: ...
    def clear(self) -> None: ...
    def load(self, query: QtCore.QUrlQuery) -> None: ...


class QgsServerFeatureId(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerFeatureId') -> None: ...

    @staticmethod
    def pkSeparator() -> str: ...
    @staticmethod
    def getExpressionFromServerFid(serverFid: str|None, provider: _core.QgsVectorDataProvider|None) -> str: ...
    @staticmethod
    def updateFeatureRequestFromServerFids(featureRequest: _core.QgsFeatureRequest, serverFids: collections.abc.Iterable[str|None], provider: _core.QgsVectorDataProvider|None) -> _core.QgsFeatureRequest: ...
    @staticmethod
    def getServerFid(feature: _core.QgsFeature, pkAttributes: collections.abc.Iterable[int]) -> str: ...


class QgsServerQueryStringParameter(PyQt5.sip.wrapper):

    class Type(int):
        String = ... # type: QgsServerQueryStringParameter.Type
        Integer = ... # type: QgsServerQueryStringParameter.Type
        Double = ... # type: QgsServerQueryStringParameter.Type
        Boolean = ... # type: QgsServerQueryStringParameter.Type
        List = ... # type: QgsServerQueryStringParameter.Type

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self, name: str|None, required: bool = ..., type: 'QgsServerQueryStringParameter.Type' = ..., description: str|None = ..., defaultValue: typing.Any = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerQueryStringParameter') -> None: ...

    def setHidden(self, hidden: bool) -> None: ...
    def hidden(self) -> bool: ...
    def setDescription(self, description: str|None) -> None: ...
    def name(self) -> str: ...
    @staticmethod
    def typeName(type: 'QgsServerQueryStringParameter.Type') -> str: ...
    def description(self) -> str: ...
    def value(self, context: QgsServerApiContext) -> typing.Any: ...


class QgsServerSettingsEnv(QtCore.QObject):

    class EnvVar(int):
        QGIS_OPTIONS_PATH = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_PARALLEL_RENDERING = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_MAX_THREADS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_LEVEL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_FILE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_STDERR = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_PROJECT_FILE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_IGNORE_BAD_LAYERS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_CACHE_DIRECTORY = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_CACHE_SIZE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_SHOW_GROUP_SEPARATOR = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_OVERRIDE_SYSTEM_LOCALE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMS_MAX_HEIGHT = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMS_MAX_WIDTH = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_API_RESOURCES_DIRECTORY = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_API_WFS3_MAX_LIMIT = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_TRUST_LAYER_METADATA = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_FORCE_READONLY_LAYERS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_DISABLE_GETPRINT = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LANDING_PAGE_PROJECTS_DIRECTORIES = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LANDING_PAGE_PROJECTS_PG_CONNECTIONS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LOG_PROFILE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WFS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WCS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_WMTS_SERVICE_URL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_LANDING_PAGE_PREFIX = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_PROJECT_CACHE_CHECK_INTERVAL = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_PROJECT_CACHE_STRATEGY = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_PROJECT_CACHE_SIZE = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_ALLOWED_EXTRA_SQL_TOKENS = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_APPLICATION_NAME = ... # type: QgsServerSettingsEnv.EnvVar
        QGIS_SERVER_CAPABILITIES_CACHE_SIZE = ... # type: QgsServerSettingsEnv.EnvVar

    class Source(int):
        DEFAULT_VALUE = ... # type: QgsServerSettingsEnv.Source
        ENVIRONMENT_VARIABLE = ... # type: QgsServerSettingsEnv.Source
        INI_FILE = ... # type: QgsServerSettingsEnv.Source

    def __init__(self) -> None: ...


class QgsServerSettings(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerSettings') -> None: ...

    def capabilitiesCacheSize(self) -> int: ...
    @staticmethod
    def name(env: QgsServerSettingsEnv.EnvVar) -> str: ...
    def applicationName(self) -> str: ...
    def allowedExtraSqlTokens(self) -> list[str]: ...
    def projectCacheSize(self) -> int: ...
    def projectCacheStrategy(self) -> str: ...
    def projectCacheCheckInterval(self) -> int: ...
    def serviceUrl(self, service: str|None) -> str: ...
    def getPrintDisabled(self) -> bool: ...
    def forceReadOnlyLayers(self) -> bool: ...
    def trustLayerMetadata(self) -> bool: ...
    def ignoreBadLayers(self) -> bool: ...
    def apiWfs3MaxLimit(self) -> int: ...
    def apiResourcesDirectory(self) -> str: ...
    def landingPageBaseUrlPrefix(self) -> str: ...
    def landingPageProjectsPgConnections(self) -> str: ...
    def landingPageProjectsDirectories(self) -> str: ...
    def wmsMaxWidth(self) -> int: ...
    def wmsMaxHeight(self) -> int: ...
    def showGroupSeparator(self) -> bool: ...
    def overrideSystemLocale(self) -> str: ...
    def cacheDirectory(self) -> str: ...
    def cacheSize(self) -> int: ...
    def logStderr(self) -> bool: ...
    def logFile(self) -> str: ...
    def projectFile(self) -> str: ...
    def logProfile(self) -> bool: ...
    def logLevel(self) -> _core.Qgis.MessageLevel: ...
    def maxThreads(self) -> int: ...
    def parallelRendering(self) -> bool: ...
    def iniFile(self) -> str: ...
    def logSummary(self) -> None: ...
    @typing.overload
    def load(self) -> None: ...
    @typing.overload
    def load(self, envVarName: str|None) -> bool: ...


class QgsServiceModule(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServiceModule') -> None: ...

    def registerSelf(self, registry: 'QgsServiceRegistry', serverIface: 'QgsServerInterface|None' = ...) -> None: ...


class QgsServerRequest(PyQt5.sip.wrapper):

    class RequestHeader(int):
        HOST = ... # type: QgsServerRequest.RequestHeader
        FORWARDED = ... # type: QgsServerRequest.RequestHeader
        X_FORWARDED_FOR = ... # type: QgsServerRequest.RequestHeader
        X_FORWARDED_HOST = ... # type: QgsServerRequest.RequestHeader
        X_FORWARDED_PROTO = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WMS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WFS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WCS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        X_QGIS_WMTS_SERVICE_URL = ... # type: QgsServerRequest.RequestHeader
        ACCEPT = ... # type: QgsServerRequest.RequestHeader
        USER_AGENT = ... # type: QgsServerRequest.RequestHeader
        AUTHORIZATION = ... # type: QgsServerRequest.RequestHeader

    class Method(int):
        HeadMethod = ... # type: QgsServerRequest.Method
        PutMethod = ... # type: QgsServerRequest.Method
        GetMethod = ... # type: QgsServerRequest.Method
        PostMethod = ... # type: QgsServerRequest.Method
        DeleteMethod = ... # type: QgsServerRequest.Method
        PatchMethod = ... # type: QgsServerRequest.Method

    staticMetaObject = ... # type: QtCore.QMetaObject

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, url: str|None, method: 'QgsServerRequest.Method' = ..., headers: dict[str|None, str|None] = ...) -> None: ...
    @typing.overload
    def __init__(self, url: QtCore.QUrl, method: 'QgsServerRequest.Method' = ..., headers: dict[str|None, str|None] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QgsServerRequest') -> None: ...

    def setBaseUrl(self, url: QtCore.QUrl) -> None: ...
    def setOriginalUrl(self, url: QtCore.QUrl) -> None: ...
    def queryParameter(self, name: str|None, defaultValue: str|None = ...) -> str: ...
    def setMethod(self, method: 'QgsServerRequest.Method') -> None: ...
    def baseUrl(self) -> QtCore.QUrl: ...
    def originalUrl(self) -> QtCore.QUrl: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def removeHeader(self, name: str|None) -> None: ...
    def headers(self) -> dict[str, str]: ...
    def setHeader(self, name: str|None, value: str|None) -> None: ...
    @typing.overload
    def header(self, name: str|None) -> str: ...
    @typing.overload
    def header(self, headerEnum: 'QgsServerRequest.RequestHeader') -> str: ...
    def removeParameter(self, key: str|None) -> None: ...
    def parameter(self, key: str|None, defaultValue: str|None = ...) -> str: ...
    def setParameter(self, key: str|None, value: str|None) -> None: ...
    def serverParameters(self) -> QgsServerParameters: ...
    def parameters(self) -> dict[str, str]: ...
    def method(self) -> 'QgsServerRequest.Method': ...
    def url(self) -> QtCore.QUrl: ...
    @staticmethod
    def methodToString(method: 'QgsServerRequest.Method') -> str: ...


class QgsBufferServerRequest(QgsServerRequest):

    @typing.overload
    def __init__(self, url: str|None, method: QgsServerRequest.Method = ..., headers: dict[str|None, str|None] = ..., data: QtCore.QByteArray|bytes|bytearray = ...) -> None: ...
    @typing.overload
    def __init__(self, url: QtCore.QUrl, method: QgsServerRequest.Method = ..., headers: dict[str|None, str|None] = ..., data: QtCore.QByteArray|bytes|bytearray = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsBufferServerRequest') -> None: ...

    def data(self) -> QtCore.QByteArray: ...


class QgsServerResponse(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerResponse') -> None: ...

    def feedback(self) -> _core.QgsFeedback|None: ...
    def truncate(self) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def clear(self) -> None: ...
    def flush(self) -> None: ...
    def finish(self) -> None: ...
    def io(self) -> QtCore.QIODevice|None: ...
    @typing.overload
    def write(self, data: str|None) -> None: ...
    @typing.overload
    def write(self, byteArray: QtCore.QByteArray|bytes|bytearray) -> int: ...
    @typing.overload
    def write(self, ex: 'QgsServerException') -> None: ...
    def sendError(self, code: int, message: str|None) -> None: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def headersSent(self) -> bool: ...
    def headers(self) -> dict[str, str]: ...
    def header(self, key: str|None) -> str: ...
    def removeHeader(self, key: str|None) -> None: ...
    def setHeader(self, key: str|None, value: str|None) -> None: ...


class QgsBufferServerResponse(QgsServerResponse):

    def __init__(self) -> None: ...

    def body(self) -> QtCore.QByteArray: ...
    def truncate(self) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def clear(self) -> None: ...
    def flush(self) -> None: ...
    def finish(self) -> None: ...
    def io(self) -> QtCore.QIODevice|None: ...
    def sendError(self, code: int, message: str|None) -> None: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def headersSent(self) -> bool: ...
    def headers(self) -> dict[str, str]: ...
    def header(self, key: str|None) -> str: ...
    def removeHeader(self, key: str|None) -> None: ...
    def setHeader(self, key: str|None, value: str|None) -> None: ...


class QgsFcgiServerRequest(QgsServerRequest):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFcgiServerRequest') -> None: ...

    def header(self, name: str|None) -> str: ...
    def hasError(self) -> bool: ...
    def data(self) -> QtCore.QByteArray: ...


class QgsRequestHandler(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, request: QgsServerRequest, response: QgsServerResponse) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsRequestHandler') -> None: ...

    def headersSent(self) -> bool: ...
    def format(self) -> str: ...
    def removeParameter(self, key: str|None) -> None: ...
    def parameter(self, key: str|None) -> str: ...
    def setParameter(self, key: str|None, value: str|None) -> None: ...
    def parameterMap(self) -> dict[str, str]: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def path(self) -> str: ...
    def url(self) -> str: ...
    def data(self) -> QtCore.QByteArray: ...
    def body(self) -> QtCore.QByteArray: ...
    def clearBody(self) -> None: ...
    def exceptionRaised(self) -> bool: ...
    def appendBody(self, body: QtCore.QByteArray|bytes|bytearray) -> None: ...
    def clear(self) -> None: ...
    def requestHeaders(self) -> dict[str, str]: ...
    def requestHeader(self, name: str|None) -> str: ...
    def removeRequestHeader(self, name: str|None) -> None: ...
    def setRequestHeader(self, name: str|None, value: str|None) -> None: ...
    def responseHeaders(self) -> dict[str, str]: ...
    def responseHeader(self, name: str|None) -> str: ...
    def removeResponseHeader(self, name: str|None) -> None: ...
    def setResponseHeader(self, name: str|None, value: str|None) -> None: ...
    def sendResponse(self) -> None: ...
    def setServiceException(self, ex: 'QgsServerException') -> None: ...


class QgsServer(PyQt5.sip.wrapper):

    def __init__(self) -> None: ...

    def initPython(self) -> None: ...
    def serverInterface(self) -> 'QgsServerInterface|None': ...
    def handleRequest(self, request: QgsServerRequest, response: QgsServerResponse, project: _core.QgsProject|None = ...) -> None: ...
    def putenv(self, var: str|None, val: str|None) -> None: ...


class QgsServerApiUtils(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerApiUtils') -> None: ...

    @staticmethod
    def appendMapParameter(path: str|None, requestUrl: QtCore.QUrl) -> str: ...
    @staticmethod
    @deprecated("""""")
    def crsToOgcUri(crs: _core.QgsCoordinateReferenceSystem) -> str: ...
    @staticmethod
    def publishedCrsList(project: _core.QgsProject|None) -> list[str]: ...
    @staticmethod
    def sanitizedFieldValue(value: str|None) -> str: ...
    @staticmethod
    def publishedWfsLayers(context: QgsServerApiContext) -> list[_core.QgsVectorLayer]: ...
    @staticmethod
    def parseCrs(bboxCrs: str|None) -> _core.QgsCoordinateReferenceSystem: ...
    @staticmethod
    def temporalExtent(layer: _core.QgsVectorLayer|None) -> list[typing.Any]: ...
    @staticmethod
    def temporalFilterExpression(layer: _core.QgsVectorLayer|None, interval: str|None) -> _core.QgsExpression: ...
    @staticmethod
    def fieldName(name: str|None, layer: _core.QgsVectorLayer|None) -> str: ...
    @staticmethod
    def parseTemporalDateTimeInterval(interval: str|None) -> _core.QgsDateTimeRange: ...
    @staticmethod
    def parseTemporalDateInterval(interval: str|None) -> _core.QgsDateRange: ...
    @staticmethod
    def temporalDimensions(layer: _core.QgsVectorLayer|None) -> list[_core.QgsServerWmsDimensionProperties.WmsDimensionInfo]: ...
    @staticmethod
    def parseBbox(bbox: str|None) -> _core.QgsRectangle: ...


class QgsServerException(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, message: str|None, responseCode: int = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerException') -> None: ...

    def formatResponse(self) -> typing.Tuple[QtCore.QByteArray, str]: ...
    def responseCode(self) -> int: ...


class QgsOgcServiceException(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, code: str|None, message: str|None, locator: str|None = ..., responseCode: int = ..., version: str|None = ...) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsOgcServiceException') -> None: ...

    def formatResponse(self) -> typing.Tuple[QtCore.QByteArray, str]: ...
    def version(self) -> str: ...
    def locator(self) -> str: ...
    def code(self) -> str: ...
    def message(self) -> str: ...


class QgsServerFilter(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, serverInterface: 'QgsServerInterface|None') -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerFilter') -> None: ...

    def onSendResponse(self) -> bool: ...
    def onResponseComplete(self) -> bool: ...
    def onProjectReady(self) -> bool: ...
    def onRequestReady(self) -> bool: ...
    @deprecated("""""")
    def sendResponse(self) -> None: ...
    @deprecated("""""")
    def responseComplete(self) -> None: ...
    @deprecated("""""")
    def requestReady(self) -> None: ...
    def serverInterface(self) -> 'QgsServerInterface|None': ...


class QgsServerInterface(PyQt5.sip.wrapper):

    def __init__(self, a0: 'QgsServerInterface') -> None: ...

    def reloadSettings(self) -> None: ...
    def serviceRegistry(self) -> 'QgsServiceRegistry|None': ...
    def removeConfigCacheEntry(self, path: str|None) -> None: ...
    def setConfigFilePath(self, configFilePath: str|None) -> None: ...
    def configFilePath(self) -> str: ...
    def getEnv(self, name: str|None) -> str: ...
    def cacheManager(self) -> 'QgsServerCacheManager|None': ...
    def registerServerCache(self, serverCache: 'QgsServerCacheFilter|None', priority: int = ...) -> None: ...
    def accessControls(self) -> 'QgsAccessControl|None': ...
    def registerAccessControl(self, accessControl: 'QgsAccessControlFilter|None', priority: int = ...) -> None: ...
    def filters(self) -> typing.Any: ...
    def setFilters(self, filters: typing.Any) -> None: ...
    def registerFilter(self, filter: QgsServerFilter|None, priority: int = ...) -> None: ...
    def requestHandler(self) -> QgsRequestHandler|None: ...
    def capabilitiesCache(self) -> QgsCapabilitiesCache|None: ...


class QgsServerProjectUtils(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerProjectUtils') -> None: ...

    @staticmethod
    def serviceUrl(service: str|None, request: QgsServerRequest, settings: QgsServerSettings) -> str: ...
    @staticmethod
    def wmtsServiceUrl(project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    @staticmethod
    def wcsLayerIds(project: _core.QgsProject) -> list[str]: ...
    @staticmethod
    def wcsServiceUrl(project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    @staticmethod
    def wfstDeleteLayerIds(project: _core.QgsProject) -> list[str]: ...
    @staticmethod
    def wfstInsertLayerIds(project: _core.QgsProject) -> list[str]: ...
    @staticmethod
    def wfstUpdateLayerIds(project: _core.QgsProject) -> list[str]: ...
    @staticmethod
    def wfsLayerPrecision(project: _core.QgsProject, layerId: str|None) -> int: ...
    @staticmethod
    def wfsLayerIds(project: _core.QgsProject) -> list[str]: ...
    @staticmethod
    def wfsServiceUrl(project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    @staticmethod
    def wmsExtent(project: _core.QgsProject) -> _core.QgsRectangle: ...
    @staticmethod
    def wmsOutputCrsList(project: _core.QgsProject) -> list[str]: ...
    @staticmethod
    def wmsRestrictedLayers(project: _core.QgsProject) -> list[str]: ...
    @staticmethod
    def wmsRootName(project: _core.QgsProject) -> str: ...
    @staticmethod
    def wmsServiceUrl(project: _core.QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    @staticmethod
    def wmsRestrictedComposers(project: _core.QgsProject) -> list[str]: ...
    @staticmethod
    def wmsInspireMetadataDate(project: _core.QgsProject) -> str: ...
    @staticmethod
    def wmsInspireTemporalReference(project: _core.QgsProject) -> str: ...
    @staticmethod
    def wmsInspireMetadataUrlType(project: _core.QgsProject) -> str: ...
    @staticmethod
    def wmsInspireMetadataUrl(project: _core.QgsProject) -> str: ...
    @staticmethod
    def wmsInspireLanguage(project: _core.QgsProject) -> str: ...
    @staticmethod
    def wmsInspireActivate(project: _core.QgsProject) -> bool: ...
    @staticmethod
    def wmsFeatureInfoLayerAliasMap(project: _core.QgsProject) -> dict[str, str]: ...
    @staticmethod
    def wmsFeatureInfoSchema(project: _core.QgsProject) -> str: ...
    @staticmethod
    def wmsFeatureInfoDocumentElementNs(project: _core.QgsProject) -> str: ...
    @staticmethod
    def wmsFeatureInfoDocumentElement(project: _core.QgsProject) -> str: ...
    @staticmethod
    def wmsFeatureInfoPrecision(project: _core.QgsProject) -> int: ...
    @staticmethod
    def wmsSkipNameForGroup(project: _core.QgsProject) -> bool: ...
    @staticmethod
    def wmsAddLegendGroupsLegendGraphic(project: _core.QgsProject) -> bool: ...
    @staticmethod
    def wmsFeatureInfoSegmentizeWktGeometry(project: _core.QgsProject) -> bool: ...
    @staticmethod
    def wmsFeatureInfoUseAttributeFormSettings(project: _core.QgsProject) -> bool: ...
    @staticmethod
    def wmsFeatureInfoAddWktGeometry(project: _core.QgsProject) -> bool: ...
    @staticmethod
    def wmsInfoFormatSia2045(project: _core.QgsProject) -> bool: ...
    @staticmethod
    def wmsUseLayerIds(project: _core.QgsProject) -> bool: ...
    @staticmethod
    def wmsDefaultMapUnitsPerMm(project: _core.QgsProject) -> float: ...
    @staticmethod
    def wmsMaxAtlasFeatures(project: _core.QgsProject) -> int: ...
    @staticmethod
    def wmsRenderMapTiles(project: _core.QgsProject) -> bool: ...
    @staticmethod
    def wmsTileBuffer(project: _core.QgsProject) -> int: ...
    @staticmethod
    def wmsImageQuality(project: _core.QgsProject) -> int: ...
    @staticmethod
    def wmsMaxHeight(project: _core.QgsProject) -> int: ...
    @staticmethod
    def wmsMaxWidth(project: _core.QgsProject) -> int: ...
    @staticmethod
    def owsServiceAccessConstraints(project: _core.QgsProject) -> str: ...
    @staticmethod
    def owsServiceFees(project: _core.QgsProject) -> str: ...
    @staticmethod
    def owsServiceContactPhone(project: _core.QgsProject) -> str: ...
    @staticmethod
    def owsServiceContactMail(project: _core.QgsProject) -> str: ...
    @staticmethod
    def owsServiceContactPerson(project: _core.QgsProject) -> str: ...
    @staticmethod
    def owsServiceContactPosition(project: _core.QgsProject) -> str: ...
    @staticmethod
    def owsServiceContactOrganization(project: _core.QgsProject) -> str: ...
    @staticmethod
    def owsServiceOnlineResource(project: _core.QgsProject) -> str: ...
    @staticmethod
    def owsServiceKeywords(project: _core.QgsProject) -> list[str]: ...
    @staticmethod
    def owsServiceAbstract(project: _core.QgsProject) -> str: ...
    @staticmethod
    def owsServiceTitle(project: _core.QgsProject) -> str: ...
    @staticmethod
    def owsServiceCapabilities(project: _core.QgsProject) -> bool: ...


class QgsService(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsService') -> None: ...

    def executeRequest(self, request: QgsServerRequest, response: QgsServerResponse, project: _core.QgsProject|None) -> None: ...
    def version(self) -> str: ...
    def name(self) -> str: ...


class QgsServiceRegistry(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServiceRegistry') -> None: ...

    def cleanUp(self) -> None: ...
    def init(self, nativeModulepath: str|None, serverIface: QgsServerInterface|None = ...) -> None: ...
    def unregisterService(self, name: str|None, version: str|None = ...) -> int: ...
    def getApi(self, name: str|None, version: str|None = ...) -> QgsServerApi|None: ...
    def unregisterApi(self, name: str|None, version: str|None = ...) -> int: ...
    def registerApi(self, api: QgsServerApi|None) -> bool: ...
    def registerService(self, service: QgsService|None) -> None: ...
    def getService(self, name: str|None, version: str|None = ...) -> QgsService|None: ...


class QgsFeatureFilterProviderGroup(_core.QgsFeatureFilterProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFeatureFilterProviderGroup') -> None: ...

    def addProvider(self, provider: _core.QgsFeatureFilterProvider|None) -> 'QgsFeatureFilterProviderGroup': ...
    def clone(self) -> _core.QgsFeatureFilterProvider|None: ...
    def layerAttributes(self, layer: _core.QgsVectorLayer|None, attributes: collections.abc.Iterable[str|None]) -> list[str]: ...
    def filterFeatures(self, layer: _core.QgsVectorLayer|None, filterFeatures: _core.QgsFeatureRequest) -> None: ...


class QgsFeatureFilter(_core.QgsFeatureFilterProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsFeatureFilter') -> None: ...

    def setFilter(self, layer: _core.QgsVectorLayer|None, expression: _core.QgsExpression) -> None: ...
    def clone(self) -> _core.QgsFeatureFilterProvider|None: ...
    def layerAttributes(self, layer: _core.QgsVectorLayer|None, attributes: collections.abc.Iterable[str|None]) -> list[str]: ...
    def filterFeatures(self, layer: _core.QgsVectorLayer|None, filterFeatures: _core.QgsFeatureRequest) -> None: ...


class QgsStoreBadLayerInfo(_core.QgsProjectBadLayerHandler):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsStoreBadLayerInfo') -> None: ...

    def badLayerNames(self) -> dict[str, str]: ...
    def badLayers(self) -> list[str]: ...
    def handleBadLayers(self, layers: collections.abc.Iterable[QtXml.QDomNode]) -> None: ...


class QgsAccessControlFilter(PyQt5.sip.wrapper):

    class LayerPermissions(PyQt5.sip.wrapper):

        canDelete = ... # type: bool
        canInsert = ... # type: bool
        canRead = ... # type: bool
        canUpdate = ... # type: bool

        @typing.overload
        def __init__(self) -> None: ...
        @typing.overload
        def __init__(self, a0: 'QgsAccessControlFilter.LayerPermissions') -> None: ...

    @typing.overload
    def __init__(self, serverInterface: QgsServerInterface|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsAccessControlFilter') -> None: ...

    def cacheKey(self) -> str: ...
    def allowToEdit(self, layer: _core.QgsVectorLayer|None, feature: _core.QgsFeature) -> bool: ...
    def authorizedLayerAttributes(self, layer: _core.QgsVectorLayer|None, attributes: collections.abc.Iterable[str|None]) -> list[str]: ...
    def layerPermissions(self, layer: _core.QgsMapLayer|None) -> 'QgsAccessControlFilter.LayerPermissions': ...
    def layerFilterSubsetString(self, layer: _core.QgsVectorLayer|None) -> str: ...
    def layerFilterExpression(self, layer: _core.QgsVectorLayer|None) -> str: ...
    def serverInterface(self) -> QgsServerInterface|None: ...


class QgsAccessControl(_core.QgsFeatureFilterProvider):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, copy: 'QgsAccessControl') -> None: ...

    def registerAccessControl(self, accessControl: QgsAccessControlFilter|None, priority: int = ...) -> None: ...
    def fillCacheKey(self, cacheKey: collections.abc.Iterable[str|None]) -> bool: ...
    def allowToEdit(self, layer: _core.QgsVectorLayer|None, feature: _core.QgsFeature) -> bool: ...
    def layerAttributes(self, layer: _core.QgsVectorLayer|None, attributes: collections.abc.Iterable[str|None]) -> list[str]: ...
    def layerDeletePermission(self, layer: _core.QgsVectorLayer|None) -> bool: ...
    def layerUpdatePermission(self, layer: _core.QgsVectorLayer|None) -> bool: ...
    def layerInsertPermission(self, layer: _core.QgsVectorLayer|None) -> bool: ...
    def layerReadPermission(self, layer: _core.QgsMapLayer|None) -> bool: ...
    def extraSubsetString(self, layer: _core.QgsVectorLayer|None) -> str: ...
    def clone(self) -> _core.QgsFeatureFilterProvider|None: ...
    def filterFeatures(self, layer: _core.QgsVectorLayer|None, filterFeatures: _core.QgsFeatureRequest) -> None: ...
    def unresolveFilterFeatures(self) -> None: ...
    def resolveFilterFeatures(self, layers: collections.abc.Iterable[_core.QgsMapLayer]) -> None: ...


class QgsServerCacheFilter(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, serverInterface: QgsServerInterface|None) -> None: ...
    @typing.overload
    def __init__(self, a0: 'QgsServerCacheFilter') -> None: ...

    def deleteCachedImages(self, project: _core.QgsProject|None) -> bool: ...
    def deleteCachedImage(self, project: _core.QgsProject|None, request: QgsServerRequest, key: str|None) -> bool: ...
    def setCachedImage(self, img: QtCore.QByteArray|bytes|bytearray, project: _core.QgsProject|None, request: QgsServerRequest, key: str|None) -> bool: ...
    def getCachedImage(self, project: _core.QgsProject|None, request: QgsServerRequest, key: str|None) -> QtCore.QByteArray: ...
    def deleteCachedDocuments(self, project: _core.QgsProject|None) -> bool: ...
    def deleteCachedDocument(self, project: _core.QgsProject|None, request: QgsServerRequest, key: str|None) -> bool: ...
    def setCachedDocument(self, doc: QtXml.QDomDocument|None, project: _core.QgsProject|None, request: QgsServerRequest, key: str|None) -> bool: ...
    def getCachedDocument(self, project: _core.QgsProject|None, request: QgsServerRequest, key: str|None) -> QtCore.QByteArray: ...


class QgsServerCacheManager(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self, settings: QgsServerSettings = ...) -> None: ...
    @typing.overload
    def __init__(self, copy: 'QgsServerCacheManager') -> None: ...

    def registerServerCache(self, serverCache: QgsServerCacheFilter|None, priority: int = ...) -> None: ...
    def deleteCachedImages(self, project: _core.QgsProject|None) -> bool: ...
    def deleteCachedImage(self, project: _core.QgsProject|None, request: QgsServerRequest, accessControl: QgsAccessControl|None) -> bool: ...
    def setCachedImage(self, img: QtCore.QByteArray|bytes|bytearray, project: _core.QgsProject|None, request: QgsServerRequest, accessControl: QgsAccessControl|None) -> bool: ...
    def getCachedImage(self, project: _core.QgsProject|None, request: QgsServerRequest, accessControl: QgsAccessControl|None) -> QtCore.QByteArray: ...
    def deleteCachedDocuments(self, project: _core.QgsProject|None) -> bool: ...
    def deleteCachedDocument(self, project: _core.QgsProject|None, request: QgsServerRequest, accessControl: QgsAccessControl|None) -> bool: ...
    def setCachedDocument(self, doc: QtXml.QDomDocument|None, project: _core.QgsProject|None, request: QgsServerRequest, accessControl: QgsAccessControl|None) -> bool: ...
    def getCachedDocument(self, doc: QtXml.QDomDocument|None, project: _core.QgsProject|None, request: QgsServerRequest, accessControl: QgsAccessControl|None) -> bool: ...
