from collections.abc import Iterator, Mapping, Sequence
from typing import Any, Protocol, type_check_only

from django.core.checks.messages import CheckMessage
from django.http.request import HttpRequest
from django.utils.functional import cached_property

class BaseEngine:
    name: str
    dirs: list[str]
    app_dirs: bool
    def __init__(self, params: Mapping[str, Any]) -> None: ...
    def check(self, **kwargs: Any) -> Sequence[CheckMessage]: ...
    @property
    def app_dirname(self) -> str: ...
    def from_string(self, template_code: str) -> _EngineTemplate: ...
    def get_template(self, template_name: str) -> _EngineTemplate: ...
    @cached_property
    def template_dirs(self) -> tuple[str, ...]: ...
    def iter_template_filenames(self, template_name: str) -> Iterator[str]: ...

@type_check_only
class _EngineTemplate(Protocol):
    def render(
        self,
        context: dict[str, Any] | None = ...,
        request: HttpRequest | None = ...,
    ) -> str: ...
