/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.editor.Editor;
import com.intellij.terminal.frontend.TerminalInput;
import com.intellij.terminal.frontend.TerminalOutputScrollingModel;
import com.intellij.terminal.frontend.action.TerminalFrontendDataContextUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.block.TerminalPromotedDumbAwareAction;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/terminal/frontend/action/TerminalPasteSelectionAction;", "Lorg/jetbrains/plugins/terminal/block/TerminalPromotedDumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.terminal.frontend"})
public final class TerminalPasteSelectionAction
extends TerminalPromotedDumbAwareAction
implements ActionRemoteBehaviorSpecification.Frontend {
    public void actionPerformed(@NotNull AnActionEvent e) {
        block2: {
            TerminalOutputScrollingModel scrollingModel;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            TerminalInput terminalInput = TerminalFrontendDataContextUtils.INSTANCE.getTerminalInput(e);
            if (terminalInput == null) {
                throw new IllegalStateException("TerminalInput is missing in terminal editor".toString());
            }
            TerminalInput terminalInput2 = terminalInput;
            String text = TerminalUiUtilsKt.getClipboardText(true);
            if (text != null) {
                String sanitizedText = TerminalUiUtilsKt.sanitizeLineSeparators(text);
                terminalInput2.sendBracketedString(sanitizedText);
            }
            Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
            TerminalOutputScrollingModel terminalOutputScrollingModel = scrollingModel = editor != null ? (TerminalOutputScrollingModel)editor.getUserData(TerminalOutputScrollingModel.Companion.getKEY()) : null;
            if (terminalOutputScrollingModel == null) break block2;
            terminalOutputScrollingModel.scrollToCursor(true);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        e.getPresentation().setEnabledAndVisible(editor != null && TerminalDataContextUtils.INSTANCE.isReworkedTerminalEditor(editor) && TerminalOptionsProvider.Companion.getInstance().getPasteOnMiddleMouseButton());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }
}

