/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.data.types.BaseDataTypeConversion;
import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridHelper;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridMutator;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.IdentityDataProducerImpl;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.dump.BaseGridHandler;
import com.intellij.database.dump.DumpHandler;
import com.intellij.database.dump.ExtractionHelper;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.run.actions.DumpSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridHelperImpl
implements GridHelper {
    public static final String LIMIT_DEFAULT_PAGE_SIZE_PROP = "datagrid.limit.default.page.size";
    public static final String DEFAULT_PAGE_SIZE_PROP = "datagrid.default.page.size";
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final String LIMIT_DEFAULT_PAGE_SIZE_BIG_PROP = "datagrid.limit.default.page.size.big";
    public static final String DEFAULT_PAGE_SIZE_BIG_PROP = "datagrid.default.page.size.big";
    public static final int DEFAULT_PAGE_SIZE_BIG = 100;
    private final String myPageSizeKey;
    private final String myLimitPageSizeKey;
    private final int myDefaultPageSize;
    private final boolean myDefaultLimitPageSize;

    public GridHelperImpl() {
        this(true);
    }

    public GridHelperImpl(boolean insideNotebook) {
        this(insideNotebook, true);
    }

    public GridHelperImpl(boolean insideNotebook, boolean limitDefaultPageSizeBig) {
        this(insideNotebook ? DEFAULT_PAGE_SIZE_PROP : DEFAULT_PAGE_SIZE_BIG_PROP, insideNotebook ? LIMIT_DEFAULT_PAGE_SIZE_PROP : LIMIT_DEFAULT_PAGE_SIZE_BIG_PROP, insideNotebook ? 10 : 100, insideNotebook || limitDefaultPageSizeBig);
    }

    public GridHelperImpl(@NotNull String pageSizeKey, @NotNull String limitPageSizeKey, int defaultPageSize, boolean defaultLimitPageSize) {
        if (pageSizeKey == null) {
            GridHelperImpl.$$$reportNull$$$0(0);
        }
        if (limitPageSizeKey == null) {
            GridHelperImpl.$$$reportNull$$$0(1);
        }
        this.myPageSizeKey = pageSizeKey;
        this.myLimitPageSizeKey = limitPageSizeKey;
        this.myDefaultPageSize = defaultPageSize;
        this.myDefaultLimitPageSize = defaultLimitPageSize;
    }

    @Override
    @NotNull
    public DataTypeConversion.Builder createDataTypeConversionBuilder() {
        return new BaseDataTypeConversion.Builder();
    }

    @Override
    @NotNull
    public ObjectFormatterMode getDefaultMode() {
        ObjectFormatterMode objectFormatterMode = ObjectFormatterMode.SQL_SCRIPT;
        if (objectFormatterMode == null) {
            GridHelperImpl.$$$reportNull$$$0(2);
        }
        return objectFormatterMode;
    }

    @Override
    public boolean canEditTogether(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull List<GridColumn> columns) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(3);
        }
        if (columns == null) {
            GridHelperImpl.$$$reportNull$$$0(4);
        }
        return true;
    }

    @Override
    @Nullable
    public GridColumn findUniqueColumn(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull List<GridColumn> columns) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(5);
        }
        if (columns == null) {
            GridHelperImpl.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Override
    @Nullable
    public Icon getColumnIcon(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull GridColumn column, boolean forDisplay) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(7);
        }
        if (column == null) {
            GridHelperImpl.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(9);
        }
        return GridUtil.getVirtualFile(grid);
    }

    @Override
    public void applyFix(@NotNull Project project, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull ErrorInfo.Fix fix, @Nullable Object editor) {
        if (project == null) {
            GridHelperImpl.$$$reportNull$$$0(10);
        }
        if (fix == null) {
            GridHelperImpl.$$$reportNull$$$0(11);
        }
    }

    @Override
    @NotNull
    public List<String> getUnambiguousColumnNames(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(12);
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            GridHelperImpl.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    public boolean canAddRow(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(14);
        }
        return true;
    }

    @Override
    @Nullable
    public String getTableName(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(15);
        }
        return null;
    }

    @Override
    @Nullable
    public String getNameForDump(@NotNull DataGrid source) {
        if (source == null) {
            GridHelperImpl.$$$reportNull$$$0(16);
        }
        return GridUtil.getEditorTabName(source);
    }

    @Override
    @NotNull
    public String getQueryText(@NotNull DataGrid source) {
        if (source == null) {
            GridHelperImpl.$$$reportNull$$$0(17);
        }
        return "";
    }

    @Override
    public boolean isDatabaseHookUp(@NotNull DataGrid grid) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(18);
        }
        return false;
    }

    @Override
    public int getDefaultPageSize() {
        return PropertiesComponent.getInstance().getInt(this.myPageSizeKey, this.myDefaultPageSize);
    }

    @Override
    public void setDefaultPageSize(int value) {
        PropertiesComponent.getInstance().setValue(this.myPageSizeKey, value, this.myDefaultPageSize);
    }

    @Override
    public boolean isLimitDefaultPageSize() {
        return PropertiesComponent.getInstance().getBoolean(this.myLimitPageSizeKey, this.myDefaultLimitPageSize);
    }

    @Override
    public void setLimitDefaultPageSize(boolean value) {
        PropertiesComponent.getInstance().setValue(this.myLimitPageSizeKey, value, this.myDefaultLimitPageSize);
    }

    @Override
    @Nullable
    public DumpSource<?> createDumpSource(@NotNull DataGrid grid, @NotNull AnActionEvent e) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(19);
        }
        if (e == null) {
            GridHelperImpl.$$$reportNull$$$0(20);
        }
        return new DumpSource.DataGridSource(grid);
    }

    @Override
    @NotNull
    public DumpHandler<?> createDumpHandler(@NotNull DumpSource<?> source, @NotNull ExtractionHelper manager, @NotNull DataExtractorFactory factory, @NotNull ExtractionConfig config) {
        if (source == null) {
            GridHelperImpl.$$$reportNull$$$0(21);
        }
        if (manager == null) {
            GridHelperImpl.$$$reportNull$$$0(22);
        }
        if (factory == null) {
            GridHelperImpl.$$$reportNull$$$0(23);
        }
        if (config == null) {
            GridHelperImpl.$$$reportNull$$$0(24);
        }
        DumpSource.DataGridSource gridSource = (DumpSource.DataGridSource)source;
        DataGrid grid = gridSource.getGrid();
        return new BaseGridHandler(grid.getProject(), grid, gridSource.getNameProvider(), manager, factory, config){

            @Override
            protected DataProducer createProducer(@NotNull DataGrid grid, int index) {
                if (grid == null) {
                    1.$$$reportNull$$$0(0);
                }
                GridModel model2 = grid.getDataModel(DataAccessType.DATABASE_DATA);
                return new IdentityDataProducerImpl((DataConsumer)new DataConsumer.Composite(new DataConsumer[0]), model2.getColumns(), new ArrayList(model2.getRows()), 0, 0);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/datagrid/GridHelperImpl$1", "createProducer"));
            }
        };
    }

    public boolean isMixedTypeColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(25);
        }
        return true;
    }

    public boolean isSortingApplicable() {
        return true;
    }

    @Override
    public boolean hasTargetForEditing(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(26);
        }
        return true;
    }

    public boolean canMutateColumns(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(27);
        }
        return grid.isEditable() && grid.isReady() && grid.getDataHookup() instanceof DocumentDataHookUp && grid.getDataHookup().getMutator() instanceof GridMutator.ColumnsMutator && grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getRowCount() != 0;
    }

    @Override
    public boolean isEditable(@NotNull CoreGrid<GridRow, GridColumn> grid) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(28);
        }
        return true;
    }

    public void setFilterText(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull String text, int caretPosition) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(29);
        }
        if (text == null) {
            GridHelperImpl.$$$reportNull$$$0(30);
        }
        grid.setFilterText(text, caretPosition);
    }

    @Nullable
    public Language getCellLanguage(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(31);
        }
        if (row == null) {
            GridHelperImpl.$$$reportNull$$$0(32);
        }
        if (column == null) {
            GridHelperImpl.$$$reportNull$$$0(33);
        }
        return null;
    }

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String text, @NotNull Project project, @NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (text == null) {
            GridHelperImpl.$$$reportNull$$$0(34);
        }
        if (project == null) {
            GridHelperImpl.$$$reportNull$$$0(35);
        }
        if (grid == null) {
            GridHelperImpl.$$$reportNull$$$0(36);
        }
        if (row == null) {
            GridHelperImpl.$$$reportNull$$$0(37);
        }
        if (column == null) {
            GridHelperImpl.$$$reportNull$$$0(38);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageSizeKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "limitPageSizeKey";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridHelperImpl";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 8: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 10: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 16: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridHelperImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultMode";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnambiguousColumnNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canEditTogether";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findUniqueColumn";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getColumnIcon";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUnambiguousColumnNames";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canAddRow";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTableName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNameForDump";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getQueryText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDatabaseHookUp";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createDumpSource";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createDumpHandler";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isMixedTypeColumns";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasTargetForEditing";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canMutateColumns";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isEditable";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setFilterText";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getCellLanguage";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createCellCodeFragment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 13 -> new IllegalStateException(string);
        };
    }
}

