#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-BEQ1i2n1Z61KeskGnIp0Fc
key:                  postgrest-10.0.0-BEQ1i2n1Z61KeskGnIp0Fc
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  b16b93400dda32f846ac93d6edbf75e3
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-BEQ1i2n1Z61KeskGnIp0Fc
depends:
    HTTP-4000.4.1-AXvRMOB6nIVHxhElsSBX4P
    Ranged-sets-0.5.0-CCA7DxjciqnLDKbOUO2Xho
    aeson-2.1.2.1-9rGsBPhyshTKvPzkopJx8r
    auto-update-0.1.6-5YcQmNPei3VAkx9JIA7w6z base-4.17.2.1
    base64-bytestring-1.2.1.0-IO7W4nLtABNJGIN4Jp2MEQ
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4HYxnyEi2mnBK2ectdARDN
    cassava-0.5.4.1-8MiMed7uhrUX64t2hDlhC
    configurator-pg-0.2.10-C7pV0KwUGI85uWtvXSHjkB containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-DCNfc6qHyhWGj2ztUjRUWC
    gitrev-1.3.1-EAQEu0I0MYZ3NOvBCjPIAO
    hasql-1.5.0.5-Fci8wJskVqq6Cp61LB0MKh
    hasql-dynamic-statements-0.3.1.1-7ufIMvXXm2ZFAVLMQFymbE
    hasql-notifications-0.2.0.5-Fj6XbOLuoLk19fgpC6E4d0
    hasql-pool-0.5.2.2-Ly1CQlZLiUzDVDj1cadAFg
    hasql-transaction-1.0.1.1-DypsHOBrPKGIS2g0zrdWHF
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-5kbj0Cv0rp8HNRwQfelhRA
    insert-ordered-containers-0.2.5.3-JDHqq2LphlOHj1DFqpGDxW
    interpolatedstring-perl6-1.0.2-7ncxlzRTMmcJJatezd00Vb
    jose-0.10-24iGCV5NQsg8WdHmTFtaCI lens-5.3.3-6oW8YfnpumtF66FcI0BTsr
    lens-aeson-1.2.3-M20AFUs7BR504PDQxE3kN mtl-2.2.2
    network-3.1.4.0-7fNpNYdJiSEL43akp61gqU
    network-uri-2.6.4.2-FfZCDPDUWea9JZl5JGUmKF
    optparse-applicative-0.18.1.0-DIJ4MbtGu3QDLh3tqkvHS0
    parsec-3.1.16.1 protolude-0.3.5-7KXKMcA13OGB4MCKHRGU1b
    regex-tdfa-1.3.2.4-5lZgJt0yJqSDd9oY2H08fk
    retry-0.9.3.1-FmQSiKBZd2x4AICzMlJlKY
    scientific-0.3.8.0-GtjUIC3j80u95XeMq22yYk
    swagger2-2.8.10-HBvxO5aTY4RHiizT25F52D text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20.1-LlrDkEbe6ka5Vid8Nf7fMl
    vault-0.3.1.5-3IzrwhxRuPjKoW7XW0Zg3M
    vector-0.13.2.0-9W9rHKyBrY08EKASla5WO0
    wai-3.2.4-HbGzj3ODjKy9gf24pBgAvG
    wai-cors-0.2.7-2pvUJWvkRs5CQhPr7rIv7F
    wai-extra-3.1.18-EcRX4hxSfOt7Zv8HDVZhj
    wai-logger-2.5.0-ANAQhc3yFGcGP9at49apsN
    warp-3.3.31-EuVFpHL4tC8B6O3zETiGa1

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

