#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-J4mfVtaQGH7ACD7PJzW4AI
key:                  postgrest-10.0.0-J4mfVtaQGH7ACD7PJzW4AI
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  5e00cc878dc278b385da915c6d598ff3
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-J4mfVtaQGH7ACD7PJzW4AI
depends:
    HTTP-4000.4.1-3oxJ1RSj23XDnw6p6DMxYq
    Ranged-sets-0.5.0-CulgzeWk1OOKjSyX4vbiLo
    aeson-2.1.2.1-AErwMfn2r5g1Pc6FekWoJb
    auto-update-0.1.6-Dp1M4VAJCBmHvrc1Djoexd base-4.17.2.1
    base64-bytestring-1.2.1.0-JNpFHiqgYkrlFIHcalimL bytestring-0.11.5.3
    case-insensitive-1.2.1.0-AMgBCf5fDYf4pbGdLaLtss
    cassava-0.5.4.1-Dci0KQW30v4LGgPCF1urcs
    configurator-pg-0.2.10-4zHg0mWdH36AW6Q6TnyupK containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-KZxQ1sg7XnkCEJj7wMAPBx
    gitrev-1.3.1-EAQEu0I0MYZ3NOvBCjPIAO
    hasql-1.5.0.5-5PzZtNH6B3N8mbnoybYf7Q
    hasql-dynamic-statements-0.3.1.1-HFZa8DHrvtWAumM9Qf0K1d
    hasql-notifications-0.2.0.5-48ZckYQd5l8DZXN6buDz1v
    hasql-pool-0.5.2.2-E7pdphBLj5t7BENqzH9a3A
    hasql-transaction-1.0.1.1-DcEqGyD6BbIL8pK7nf45gZ
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-8EgajALSM5xB8GFkN9ClFd
    insert-ordered-containers-0.2.5.3-HRzzwqplikYDFaoIQnA13c
    interpolatedstring-perl6-1.0.2-6Sdf8D6t8lvi1nSYQ0Hrb
    jose-0.10-IY8Aif0U2tV4lQc6hFQacl lens-5.3.2-DlnMzXp6T2vRa3tLj6rdI
    lens-aeson-1.2.3-LqwjIAm9TcAJhxuxC96v0g mtl-2.2.2
    network-3.1.4.0-Ez30o8Wyt6m7hXZSCgqaWo
    network-uri-2.6.4.2-Db65q7JXyy8EWWIZuTCsbL
    optparse-applicative-0.18.1.0-4C3xA04o7PTLcTJxkr1Svw
    parsec-3.1.16.1 protolude-0.3.5-BvyeYrbThGk44kJ4wmFVOp
    regex-tdfa-1.3.2.4-E9frbDbU8Sy5RrbyJsGucy
    retry-0.9.3.1-49rJZhppzu48UQjT7hcIxD
    scientific-0.3.8.0-Hcx0Ig8vfV6K9QIlykOJmr
    swagger2-2.8.10-FeXXwdwiuLWHqHSwwyJyu2 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-2t1vPVJZrFoJrApu3o7oBM
    vault-0.3.1.5-9YBRcGF9Dh8CfGGCNLyqwk
    vector-0.13.2.0-ALyKXv7XVpOIl9EVBdgwIc
    wai-3.2.4-6pK67aQEgpK6NKWKR3cfH5
    wai-cors-0.2.7-EmPlOjwcMnr3hQO51Y9zqs
    wai-extra-3.1.18-KpHf8AUlYLPIEFgZyWs1rJ
    wai-logger-2.5.0-4Ien54QDhwZEiyqBD9LBN5
    warp-3.3.31-9CiJqzzc20r1rKr911Mo33

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

