#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-HWKCJsXtifmB3oZ0f8wFbc
key:                  postgrest-10.0.0-HWKCJsXtifmB3oZ0f8wFbc
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  bbd8a30067dfaeb93d5b5dc812f2a981
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-HWKCJsXtifmB3oZ0f8wFbc
depends:
    HTTP-4000.4.1-GGIoqdJ2gt4HkjOtIyENkn
    Ranged-sets-0.5.0-23ij1RRBFr36kOTrwkctLk
    aeson-2.1.2.1-Kx5U0b11hXDAcrJPuBeHuf
    auto-update-0.1.6-E5Hf4yxUkLaAr1Mq4seJoW base-4.17.2.1
    base64-bytestring-1.2.1.0-GswEt3eOHYLA64palw0j2S
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4NRudSZIbdgEwzMbC5HpSf
    cassava-0.5.4.1-FHspvIkWdyT7zkFCJDprCL
    configurator-pg-0.2.10-IXo4I63xtH16PHX4UHg9zU containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-6Yv9aYC5RunDrOwefPnrne
    gitrev-1.3.1-EAQEu0I0MYZ3NOvBCjPIAO
    hasql-1.5.0.5-LrObgbnxz1ZCMgCrvPShsG
    hasql-dynamic-statements-0.3.1.1-HYc1VozsqIK1nrMgYhZVuq
    hasql-notifications-0.2.0.5-1eDhxYyafkJrsMO5OkBWn
    hasql-pool-0.5.2.2-JNHZxNZ6cvp1ukdCNONbLQ
    hasql-transaction-1.0.1.1-4VW0qOInXPn6SsLlHSxC1G
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-AnyveerSvWp9fcmJ7pBmmy
    insert-ordered-containers-0.2.5.3-JANjemKPnyn42ojV6ZuIBG
    interpolatedstring-perl6-1.0.2-5KgStOfhExhLTQJ6YGlbjQ
    jose-0.10-ACV5NS4SnqaHT1jDDTiByY lens-5.3.2-LURSnBuXCqTHeh00mrfrRc
    lens-aeson-1.2.3-Lk9aAGEdvs15QLK9qN40vX mtl-2.2.2
    network-3.1.4.0-4cEUA9pnnvEEvGlZk2FqT
    network-uri-2.6.4.2-JKWvmQYUpUN61cz8IfYdaz
    optparse-applicative-0.18.1.0-1Ar9aW9o69J8KQyhUKGEja
    parsec-3.1.16.1 protolude-0.3.5-2AXppB1p4EhGtiSHtQK1ly
    regex-tdfa-1.3.2.4-3bXJ0Bke15qHYrwaAbKD98
    retry-0.9.3.1-K0RdV2RD6UbA5DPqJXHTae
    scientific-0.3.8.0-EkghYeMOx113vCMjgUsNh4
    swagger2-2.8.10-7oyfZlT0V1N4OGviam3fX1 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-Jnp6Xrk1NDm4qrPXFyeyaF
    vault-0.3.1.5-Kyx3ctxvUVf1IygSqtcXs
    vector-0.13.2.0-HGgKaKiJszd4ty04a0OkB8
    wai-3.2.4-6yvNKQ0UUswJzjrPe1tuVO
    wai-cors-0.2.7-HkVPPTsL7PB6pDVarJy8pI
    wai-extra-3.1.18-7zPMyPLasumKA48lmOr4vP
    wai-logger-2.5.0-JyqLkRnrpReOLoa4DPsbr
    warp-3.3.31-LNQyGmUrjCg6zDV5km21Oc

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

