#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-5x772evCo03F7Ufu9IcVkn
key:                  postgrest-10.0.0-5x772evCo03F7Ufu9IcVkn
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  bc787a5c0af7891c2290e1dae4cee831
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-5x772evCo03F7Ufu9IcVkn
depends:
    HTTP-4000.4.1-FKjfj7wq9MB29oVTPue5Dw
    Ranged-sets-0.5.0-1zSzx81AfbjLUyJhNEc2wN
    aeson-2.1.2.1-nTcMAwSjFOFbKrX5mWkol
    auto-update-0.1.6-9mHapqHqTl55svYss2XsP9 base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-Dv0qc5eM6SdL4nJsx4bnK
    cassava-0.5.4.1-Jv84qeS9QpmLbBtFRgwi7C
    configurator-pg-0.2.10-EEotNKeOYHq6QphOQfHh1l containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-69ARLzwUZZrDFCBHrk7QZt
    gitrev-1.3.1-8E5RCJBqIGg8ne6UzHEH7k
    hasql-1.5.0.5-H8aVp4oNb8e1PIJBPMTraC
    hasql-dynamic-statements-0.3.1.1-JhAQHEHDILbFqliu8hFzTf
    hasql-notifications-0.2.0.5-Fjnwxz0Iyyg4KaMiCdf9Tj
    hasql-pool-0.5.2.2-LWwb42igvp54D6gzENSxLX
    hasql-transaction-1.0.1.1-G9pbIWWxNgj5QF2jHfrdY7
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-1OQw2FrAjtsGCePB2Q8s8s
    insert-ordered-containers-0.2.5.3-17vkClHiVom4ZogPYabWMD
    interpolatedstring-perl6-1.0.2-9O3FSZW7VLeI7O10eIQdRb
    jose-0.10-C11RXZ9gnxkIWHM6jIdI6p lens-5.3.2-fiszOW9VlT8rCDJtY0rRn
    lens-aeson-1.2.3-CCNhaOV43Z0Gh5KmTBUo6E mtl-2.2.2
    network-3.1.4.0-9SQkdFTpEbMLQxc4pkijnN
    network-uri-2.6.4.2-IgEz3CB1YIOEy0roDjtsJm
    optparse-applicative-0.18.1.0-3BM2XfGPAi84FVPqRQY5AK
    parsec-3.1.16.1 protolude-0.3.5-BIXpcm5dHYbHfSI82WUsUX
    regex-tdfa-1.3.2.4-F8VKcYSaovZCBcCO9TwdYz
    retry-0.9.3.1-8Jd8kQKXcB144l8qucL3T0
    scientific-0.3.8.0-K9UnBgGB9Y7F763TSfYqCQ
    swagger2-2.8.10-17emN7G2he3A5GBtixv3AL text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-KDi8IgRcOV5HCm7hBAqDWV
    vault-0.3.1.5-CmQhd5cSbnqDz2nRd7Yf8X
    vector-0.13.2.0-FDZBPFjQhmHDghUn2Zh3lL
    wai-3.2.4-F2VJAE8OhtyI4jBCcdCBBc
    wai-cors-0.2.7-HVYfud8TfdM4olvwWlro7Y
    wai-extra-3.1.18-A8mI1ZW6fiMCkT3EnkiIQn
    wai-logger-2.5.0-5DuaAIuaoVxKvofahzySuE
    warp-3.3.31-2xKr7NKtFfPIy8QpWTlEw2

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

