#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-9F6rruRu5eK23Z1zLUlURX
key:                  postgrest-10.0.0-9F6rruRu5eK23Z1zLUlURX
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  5a5f366f43bafe73b87a0022704b7fbd
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-9F6rruRu5eK23Z1zLUlURX
depends:
    HTTP-4000.4.1-9tyVpS4yTJaKO3RlPJnV6e
    Ranged-sets-0.5.0-2KqqIOWmCy0mJLrrfBOiz
    aeson-2.1.2.1-7VTFzNaeQhH4xougawMBap
    auto-update-0.1.6-2BD8s0lAA1IBThsZ7EGRHT base-4.17.2.1
    base64-bytestring-1.2.1.0-9QDpxC30hpD5AXVFvRXqVM
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4P9iCjJMWMIHxNOvyaASZG
    cassava-0.5.4.1-LwcM7gX8eiWC51505zDOUq
    configurator-pg-0.2.10-1S3XujsMuGS2r863MZEidU containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-7e09p0bwk1dC0sXKvTRSQ2
    gitrev-1.3.1-8E5RCJBqIGg8ne6UzHEH7k
    hasql-1.5.0.5-22GlCAFASR56zPpYJQaDKy
    hasql-dynamic-statements-0.3.1.1-LGk6dLNGNF26DtBYY22LKQ
    hasql-notifications-0.2.0.5-Ap1qftNBFbzfDpY4Rsv36
    hasql-pool-0.5.2.2-7CPp7OXsBGB2VcJEzMFVPG
    hasql-transaction-1.0.1.1-A2Hko8XrsQPLD9tIue0vKC
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-3DQiCH8RwXkLA2zexb7ibB
    insert-ordered-containers-0.2.5.3-JtrdBmxMqrI9BdRarwxElG
    interpolatedstring-perl6-1.0.2-1ZqUOs6zRNp3hJrY1pXrXR
    jose-0.10-HnBPWOo95h5dw3CNi5wrk lens-5.3.2-2XqN7dz4nG34Xtk8WfM3fs
    lens-aeson-1.2.3-5n1xJfaXoOvDRIGTNiWjWi mtl-2.2.2
    network-3.1.4.0-9G0x2c0R6cS5Adtb7MLWUj
    network-uri-2.6.4.2-3JXfaFN99ue5xMdSDFu2sO
    optparse-applicative-0.18.1.0-G3Jl5lNMtd03bbRRexh6Dm
    parsec-3.1.16.1 protolude-0.3.5-CplwHQOYqkZDDJfA6J4Dz8
    regex-tdfa-1.3.2.4-Fuwr2ihnaho7XtY5yWf5G3
    retry-0.9.3.1-AVrah1dPRs4HX7FEeiWDy1
    scientific-0.3.8.0-5k7RkjOpOBv4OfSmUBfqB5
    swagger2-2.8.10-14Z8VetEVk0E5ALAzEUuao text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-Iia3zhz8DVL3Efh3E6ja96
    vault-0.3.1.5-K2HokICQlCw6h6YqRFCEwJ
    vector-0.13.2.0-89nHvRrlFmk5zBBEvFgHzR
    wai-3.2.4-7gPy4vrA6McEXoAULdTry7
    wai-cors-0.2.7-Ieobycre1ca3E8RweOFVWM
    wai-extra-3.1.18-2SLQ20ZlWOTEyHLpicnMTC
    wai-logger-2.5.0-JkvdTHXeVRPDb7hxQMb6Lk
    warp-3.3.31-BWp9L2zAoW4JruynxSXs04

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

