#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-D46htLUMn3a8U2GuTZXcny
key:                  postgrest-10.0.0-D46htLUMn3a8U2GuTZXcny
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  0d860dee51a0c52e0b3ff46c240ae0e4
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-D46htLUMn3a8U2GuTZXcny
depends:
    HTTP-4000.4.1-5kdkKw0IJSY3CDLJxbc1mu
    Ranged-sets-0.5.0-8GY32unNlzzGQZjsZ1JGxX
    aeson-2.1.2.1-7cfkxE9Bq2x7khGuVuQDC7
    auto-update-0.1.6-7bnT7tvLNzg2ZpOOSaqwau base-4.17.2.1
    base64-bytestring-1.2.1.0-E08AvuQpBHn2sZGuvrNhQw
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-GQeAlR2AZ5qKSa6EskqV7j
    cassava-0.5.4.1-7azZ5j0A8NKIuK8600Ra7S
    configurator-pg-0.2.10-8W6hob3nx9L92hfK3VjsQP containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-JA8EZxBfxlZ8ZEK30QRc1B
    gitrev-1.3.1-8E5RCJBqIGg8ne6UzHEH7k
    hasql-1.5.0.5-5UHF65ZCdM62cpJ68M1pzF
    hasql-dynamic-statements-0.3.1.1-5kPzy0HKFyQDPQPhk1Iqbl
    hasql-notifications-0.2.0.5-GLSd59tOFnmIKKgKDxAULX
    hasql-pool-0.5.2.2-2B5MfiAg4BHF6Lqxqa0pC7
    hasql-transaction-1.0.1.1-Fu1044w70GEHpQoVwCBlVI
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-1rtZtKDzV5obVFgF5aFTX
    insert-ordered-containers-0.2.5.3-9wOOGtwA66fI1Pvu9gITL1
    interpolatedstring-perl6-1.0.2-7Jv5bjh4JfcJue90KEJ5sH
    jose-0.10-3fgMlMMmJPm3IH4gpLrNYE lens-5.3.2-3x6i1OAeQ2c8gg8RvgTRSW
    lens-aeson-1.2.3-ASI1QkFlH6v7ikiBaettkV mtl-2.2.2
    network-3.1.4.0-GdpHxCm9XS6F665gL00mHk
    network-uri-2.6.4.2-EJq2qAYdDkaFqs6P7Upy96
    optparse-applicative-0.18.1.0-AUOg1zQqVBXHiykDTBb1RQ
    parsec-3.1.16.1 protolude-0.3.5-IpqIfzpnk1j8WUPNm25RLI
    regex-tdfa-1.3.2.4-AhpOdFU5juh7boEnS9Ka1y
    retry-0.9.3.1-AgDoyHRHk8GH87kR6D22ud
    scientific-0.3.8.0-AOW264DwDbwGkouhllMUCK
    swagger2-2.8.10-27d5f9FxdJ4AJuz2dPHUmt text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-7E9U8fDCyyE7V5F5vC663n
    vault-0.3.1.5-3EFjaxoiS89FPHLBY4dLfQ
    vector-0.13.2.0-62lZRWkkFegAYWIszJUA7I
    wai-3.2.4-8esVLXywzhH5CPpOFjxVlw
    wai-cors-0.2.7-L9mxBS0BmyDL0TA4qmVlDz
    wai-extra-3.1.18-FAjQJKzopf826jCtGU97E2
    wai-logger-2.5.0-EmmSvivkQihETBbw83oMdi
    warp-3.3.31-8lNbNvFc0wV2wm0UGkm1dD

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

