#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-E1LfdXpP12eKm6G1OiQGYG
key:                  postgrest-10.0.0-E1LfdXpP12eKm6G1OiQGYG
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  2409957db08ed7a7d8a9d269516b83df
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-E1LfdXpP12eKm6G1OiQGYG
depends:
    HTTP-4000.4.1-A4NZ39ytjSeCQl1hnehYzf
    Ranged-sets-0.5.0-Dk4foQtWIZeBfyyH2OQmCd
    aeson-2.1.2.1-IUt8ms8F4mK1p5ihNOaPfT
    auto-update-0.1.6-rKBQkm8QkfKrmkqspqtnP base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-EZuETxE1IO9HODmjZlC6xu
    cassava-0.5.4.1-5z9Vp8GAkaaxSJ4U9oabD
    configurator-pg-0.2.10-KNYw5Jb0fd8aTvQlFxotq containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.5.0-Khxmud11aHE2bTuo1AKBzI directory-1.3.7.1
    either-5.0.3-2v2p6nG6yhOIfbQFppbYdR
    gitrev-1.3.1-8E5RCJBqIGg8ne6UzHEH7k
    hasql-1.5.0.5-IscqlqgQeIz6AG2dRDAJmj
    hasql-dynamic-statements-0.3.1.1-GAUjh7fzoVoDKw7cQtLkF1
    hasql-notifications-0.2.0.5-BCPp0iIQ2tvAAlgKzQs5NR
    hasql-pool-0.5.2.2-GYBTMLiZa2zCIk1zXC61QF
    hasql-transaction-1.0.1.1-Hqy4K4ljC0h2I2H5esRftQ
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-8dp7TKfAiJvJDE5Kav0jk0
    insert-ordered-containers-0.2.5.3-GYRewSvrGQF4OgkjgxfZVX
    interpolatedstring-perl6-1.0.2-GDFVXUnM87HEIQqhrFAlpb
    jose-0.10-5LevLULEuJG3okE0KROTso lens-5.3.2-2jnRf5jwH3ZB3yflks8aAl
    lens-aeson-1.2.3-20aC0aFDZeyGca2SYTvngZ mtl-2.2.2
    network-3.1.4.0-3FUQiZBqCiD6JAPkelGiT0
    network-uri-2.6.4.2-FdqTTZWnFNX96ukBHXQ0ED
    optparse-applicative-0.18.1.0-5pRc89gLzX8JqTyOujyDZt
    parsec-3.1.16.1 protolude-0.3.5-5zzhZH5ll1zCXDBalrcNSB
    regex-tdfa-1.3.2.4-HNpewnjjvU3IRU9BMm5w9q
    retry-0.9.3.1-LfXtHp1Ll8n6QgR53LcWUy
    scientific-0.3.8.0-Csy6naPBtz6IxA0BF8lmor
    swagger2-2.8.10-KSJVllCcudn7Lk2RaJJVUl text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-8z8yrOH3Dwd8Gc78vZRE2k
    vault-0.3.1.5-3F24psscbS2IIYfNq4kakU
    vector-0.13.2.0-C8nzmtHpFSiD5klMFr8FFK
    wai-3.2.4-94AIQdArDsBJuJKIXDdJBx
    wai-cors-0.2.7-32aoyQQ2XY16vvldbCh62h
    wai-extra-3.1.18-A7p0ii28XJXLevHog476Fc
    wai-logger-2.5.0-C5LoL0Te8sw5rkctshffh7
    warp-3.3.31-JYKRwmEU2qg7pazB9v4eTW

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

