#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-JyYyLJwD81XIQU08wktmPU
key:                  postgrest-10.0.0-JyYyLJwD81XIQU08wktmPU
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  43bc066a8b2804ccc1b99c95030c3a0d
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-JyYyLJwD81XIQU08wktmPU
depends:
    HTTP-4000.4.1-DJui1O7FYhH8BanfTpPqXU
    Ranged-sets-0.5.0-9CW6UnoeKla6xh15yjJW13
    aeson-2.1.2.1-CoFGCad0PesDH4XC5ctCv4
    auto-update-0.1.6-A7ynHRoH6vfC4VChUsT6sg base-4.17.2.1
    base64-bytestring-1.2.1.0-H7PD9x3a1R75H5UmP3m5CT
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-761P1jvxXU26pNc4Eb30SJ
    cassava-0.5.4.1-8r492bYlKNjDW3rnabaOuW
    configurator-pg-0.2.10-6mgWKRdzLl68PzRicDmZnV containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-DVRV7MwX651AHF1w4Fai0a
    gitrev-1.3.1-8E5RCJBqIGg8ne6UzHEH7k
    hasql-1.5.0.5-9DBvlkrLeHz6kq9IpKeOv2
    hasql-dynamic-statements-0.3.1.1-55KbClEhv5C9co2Nk6MM7Z
    hasql-notifications-0.2.0.5-6u2DtpwLufS41XcYZ5FmNn
    hasql-pool-0.5.2.2-6xQfhXWoPJhCJEfktn6LdT
    hasql-transaction-1.0.1.1-87H1ZNOu0myCYZwhoBM45U
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-BqXeLjMsy2zE8Q8bHBFhrt
    insert-ordered-containers-0.2.5.3-FTBhBNSmilSIuTh1JrKPHE
    interpolatedstring-perl6-1.0.2-EPzMFpxaYrSGCAgXDXHvUs
    jose-0.10-7ch8pC5NRig9vI7GLXGOLJ lens-5.3.1-Ga5POsfLznm5CIw6bCU9JL
    lens-aeson-1.2.3-1wPcoYH5KEaEX29BZ1PdSK mtl-2.2.2
    network-3.1.4.0-K2TPJT2eLM87X4awxEjMbA
    network-uri-2.6.4.2-4IxerK0JG7wGRLJekUQEdr
    optparse-applicative-0.18.1.0-CZp2uWBrZhVKrqP7dbntdc
    parsec-3.1.16.1 protolude-0.3.5-6Z3YMUCOqBtCSBnGBCFx7w
    regex-tdfa-1.3.2.4-EAViH0SVePPGm2eZt2I5vM
    retry-0.9.3.1-BRnka5AbRj2FGu82uKxK2a
    scientific-0.3.8.0-3ah0qUGLDw61YSMhCVhWLa
    swagger2-2.8.10-6YtevK1DBNLKpWHfVzEoD4 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-9wNMaDmysQKAAHkxxaXhUB
    vault-0.3.1.5-1OAob7odeEe5fwF0V06wDe
    vector-0.13.2.0-7UWGIXxclbLLOjGg0s2qXt
    wai-3.2.4-CKkA8Aq5NeD7z1ZAcTjQU2
    wai-cors-0.2.7-2JyU87X2T3n2cpb6MUI29L
    wai-extra-3.1.18-6Aov02FlO4HFa4yGPQ7Etl
    wai-logger-2.5.0-Ae197zJzkBP1D7TmwDmgop
    warp-3.3.30-5Xxjf4prHCUHufvr7WpoCO

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

