#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-LDzYeHCeFlQAIc7ml0HNU0
key:                  postgrest-10.0.0-LDzYeHCeFlQAIc7ml0HNU0
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  c51ca4390ecef9f946d1a9d493390fd0
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-LDzYeHCeFlQAIc7ml0HNU0
depends:
    HTTP-4000.4.1-LAknsGHYwqqLLOLJ1JbSy9
    Ranged-sets-0.5.0-L0ugTrR7NXSmLNifWFz0Y
    aeson-2.1.2.1-4RB85zdNr5p3whZ1np3a31
    auto-update-0.1.6-HHkMBznrGW1B28kdhiGh82 base-4.17.2.1
    base64-bytestring-1.2.1.0-ILHMKKXOF5jJ5iWlSCcrHn
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-LYFsGNYxHzcJNUKypl8Xr7
    cassava-0.5.4.1-CA078skmoukJc2G96jmiZd
    configurator-pg-0.2.10-DEOhZp86IxBJvdZKe6nDKN containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-Ofj8z9dcLGLwajoO9mRz5
    gitrev-1.3.1-8E5RCJBqIGg8ne6UzHEH7k
    hasql-1.5.0.5-3bFTDbbuS6l6utsa5wlD1r
    hasql-dynamic-statements-0.3.1.1-DnJTIYGeNJWE6uqgc9C1IN
    hasql-notifications-0.2.0.5-E0Z1TaPBoYADSOLaTTNMSg
    hasql-pool-0.5.2.2-DMMfZLFthZN5ZdflX8uk6r
    hasql-transaction-1.0.1.1-Goiy4fMV9Xj83aENe6bGdw
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-Jx04LytKDQxAS6dwQTH9Cw
    insert-ordered-containers-0.2.5.3-HcpLZQEjWFC3EdqCkAk7SP
    interpolatedstring-perl6-1.0.2-1j67WNygKw3DOpSdpMFsyu
    jose-0.10-FaC1dkbrS0hIqXW5f2S4U3 lens-5.3.1-ph5gK6GMHDK3KRhjZ6UP9
    lens-aeson-1.2.3-85yZcq80B5x64lmzp596Ii mtl-2.2.2
    network-3.1.4.0-KCu1LDB4kGQHeeCsiSLoOZ
    network-uri-2.6.4.2-yi3MP3fDM2AtnMkY6gtjY
    optparse-applicative-0.18.1.0-LLjVXIIvCj2EgCMfmpm2Bg
    parsec-3.1.16.1 protolude-0.3.5-5rT7UHzRwoch2duozaFcM
    regex-tdfa-1.3.2.4-8SMpKQokk9j1XbuNe0lCm6
    retry-0.9.3.1-KpFTY8caq0CE20jjCRmjHa
    scientific-0.3.8.0-75VbuY3tmfA8QFAgCCeEHk
    swagger2-2.8.10-1NKUfoW7tz2LWM8PS2kEzz text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-L410VxfvorQ5RMb8wocThG
    vault-0.3.1.5-R7HfyqchkWC0uGpaDAfNd
    vector-0.13.2.0-B3Rnif6nhJNLHPAZlzHp2g
    wai-3.2.4-HB9yxc5cWSY3PjQANbUXrV
    wai-cors-0.2.7-BlE3AcTFdbgAlSW54A6BER
    wai-extra-3.1.18-HGqKFbiDRfyJOYUe4j6hWW
    wai-logger-2.5.0-HqGMyOwmquC1JjWqy4t496
    warp-3.3.30-6NKX59beJQBK1qUf1zNclk

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

