#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-J4RElwLR1JEBhL3iUAT3DM
key:                  postgrest-10.0.0-J4RElwLR1JEBhL3iUAT3DM
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  aa8c64d63966c7e1f935abc0a2d649c0
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-J4RElwLR1JEBhL3iUAT3DM
depends:
    HTTP-4000.4.1-5YaMsB4upvr2tr0e2Yr4Lc
    Ranged-sets-0.5.0-5GahelDk3SBsojAEh8j78
    aeson-2.1.2.1-30WJrKK1Pbc1pP0H7Lz8HG
    auto-update-0.1.6-2xVbKAqLCut9YvbaOiZBdZ base-4.17.2.1
    base64-bytestring-1.2.1.0-Lbg95oHQaiJ5WTZ2yAUrqi
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-3u1lhibUOI39diOsp8dwhN
    cassava-0.5.4.1-CicJsilY50C1FseCaLojor
    configurator-pg-0.2.10-KnfxE6rWy9s5HwXZKOqSpO containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-rHAnuiMvw5AWNhhfsw0ES
    gitrev-1.3.1-8E5RCJBqIGg8ne6UzHEH7k
    hasql-1.5.0.5-9ahhK6AgBpKEv14Lr6q9Bh
    hasql-dynamic-statements-0.3.1.1-6GVGqLvdIFq7coG4d3fbws
    hasql-notifications-0.2.0.5-62D3VG5pdWtD1wRRKlnOcc
    hasql-pool-0.5.2.2-3swtFiMSjSQ5x3GVqQhhpK
    hasql-transaction-1.0.1.1-AH7XgcaKrJf2v2Dig932a3
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-HAGemqHxPpJ61NPMOsJY37
    insert-ordered-containers-0.2.5.3-a6ntEZLrJ5Gbc59i1uMM1
    interpolatedstring-perl6-1.0.2-JzwFOnY29dT6p2kuAFzkBF
    jose-0.10-KnDO5DUKAFLKeTGJFG8seh lens-5.3.1-JQiC8s3SxPvAYItR1bILVE
    lens-aeson-1.2.3-7CIur4Lm3ui7C43UjDgo3O mtl-2.2.2
    network-3.1.4.0-1eoJcyQnoY08famP5jSKP3
    network-uri-2.6.4.2-4dyZiFqUsAXDJ8mS3jtc8B
    optparse-applicative-0.18.1.0-K3CbF5FSqXbBKh39LN9JOE
    parsec-3.1.16.1 protolude-0.3.5-ImWisO7Z9e97vV10Q4n8H
    regex-tdfa-1.3.2.4-39wzU5wyj0sDqy1lsVXDTa
    retry-0.9.3.1-2NxlmoaGujH9j0piBnEoiz
    scientific-0.3.8.0-Ksazu1q4lbv7nBtRDhz1zC
    swagger2-2.8.10-JzLEX74nmudAhg23yYtDpF text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-JDDg5JU7nYP5ffg7vR2UZh
    vault-0.3.1.5-DnQp297eUTF7TPYlrAlANV
    vector-0.13.2.0-LerqRcvS8LMBGXOi8GqDsa
    wai-3.2.4-35VOG5Vf7yXFyy7nrz2acQ
    wai-cors-0.2.7-2griqhSiEafFS7VSmWAECL
    wai-extra-3.1.18-HlqHrdQso8z7Wm60bU53Wo
    wai-logger-2.5.0-LdZLkMeVgdABZfB465zHdK
    warp-3.3.30-6Z9eNkEsJzZ2YILrOaNZWf

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

