#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-3jVzhlcAmEr8a6llXkgXSJ
key:                  postgrest-10.0.0-3jVzhlcAmEr8a6llXkgXSJ
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  da76395773799709d9bf4ac11bac1226
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-3jVzhlcAmEr8a6llXkgXSJ
depends:
    HTTP-4000.4.1-KnVy0Z4vKymGLqCAUlrW4k
    Ranged-sets-0.5.0-2rR5hic30OHCGLuJfsoQWb
    aeson-2.1.2.1-IZ8jLcnEISD7S5Vyf2Tehm
    auto-update-0.1.6-8aKRAgo5kkJHZJe8fglL0B base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-3FuXchFPXBfLVJKu7fam1O
    cassava-0.5.4.1-6q0OLorsNaxKS3RilElHfN
    configurator-pg-0.2.10-5eOmBBfx2DRF12FbuUsSDW containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-GCeYud6YZTH1jjBgRKWFzJ
    gitrev-1.3.1-8E5RCJBqIGg8ne6UzHEH7k
    hasql-1.5.0.5-DNocgxwrvUb2GZxJPVIla2
    hasql-dynamic-statements-0.3.1.1-EIoMTPILQL4DHBcuswA57P
    hasql-notifications-0.2.0.5-CZC2KiL1t4RrqNU29zua2
    hasql-pool-0.5.2.2-E3Y3kVkrTZ7GOyjtfErSa6
    hasql-transaction-1.0.1.1-5ghznFnSeFcLLd3WOj1wnA
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-9GhteoJuOlZ3ATAYoIbhkU
    insert-ordered-containers-0.2.5.3-3MXOPQNmWps3CYyecxg2su
    interpolatedstring-perl6-1.0.2-H5HvJEwGKK81ueLvclR0WK
    jose-0.10-AMwKmjpuMVx1UKhkM57jhK lens-5.3.1-K6M28KdwyDFInfMmFpBOSR
    lens-aeson-1.2.3-KSE2QpSBo4W3iylcjguK8 mtl-2.2.2
    network-3.1.4.0-KAEk2uZxmO9GA8hoXz0jL7
    network-uri-2.6.4.2-BPG1Yj05GAIIauIotQ4jTb
    optparse-applicative-0.18.1.0-BfpmqtzGsjUFBu8SCUDd7D
    parsec-3.1.16.1 protolude-0.3.5-5ORCvsOq35n56lg71OqRG8
    regex-tdfa-1.3.2.4-4BRmOkLS3ql2wqEC5AAoF9
    retry-0.9.3.1-mWs1rYY0do5eaKecxaidi
    scientific-0.3.8.0-JtTPeMck4RoCJw8PpYbrMQ
    swagger2-2.8.10-Eb1U9rV3j4fBmIXovOncZA text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-79maJZZuZDu8bRI1CHuoJG
    vault-0.3.1.5-6IncVOQOIZY1OTTZhdmRxQ
    vector-0.13.2.0-9TreTxHfwqF7cSCfMWPj9u
    wai-3.2.4-LSet4Oo8Svc8BhPeth6Bg
    wai-cors-0.2.7-6sJ9NG6FxSf39GGBez1izz
    wai-extra-3.1.18-8HxunqLdteJHaAGy67mBaK
    wai-logger-2.5.0-8jkNTdYkzCP5zUgFiaHeA8
    warp-3.3.30-JYRa6G4TpFBCfP4ZSgWbtY

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

