#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-I8a11o8Amja9S9qbhM4fRR
key:                  postgrest-10.0.0-I8a11o8Amja9S9qbhM4fRR
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  da2d11ca208ee33cd0151ee9f2dbfc90
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-I8a11o8Amja9S9qbhM4fRR
depends:
    HTTP-4000.4.1-1FFMZEMNJyrFBpbnP6nXRV
    Ranged-sets-0.5.0-Asi6QdGcpRA4CKU7B1k0JZ
    aeson-2.1.2.1-F8ZePgr6g4xL6kF4wsQx0x
    auto-update-0.1.6-3vlNh2K3DYF7mZ2IR1Gyly base-4.17.2.1
    base64-bytestring-1.2.1.0-BuaE7coGml7AORbY2RxXh2
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-B227KtiOix4GTDgvxk3FBB
    cassava-0.5.4.1-Fa5MhephXv32XsZlJqWK0h
    configurator-pg-0.2.10-9lRpZZUUKYRDFnWl3LKzUi containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-3cPrFbwGcfbEVnuEdslVHx
    gitrev-1.3.1-KhpMNofwsxABRoyEGWB0ci
    hasql-1.5.0.5-3HN4HoFaYQc2yrfiFT8mgm
    hasql-dynamic-statements-0.3.1.1-CwnG6yAdtTz46wHb7fWmLr
    hasql-notifications-0.2.0.5-IBTxNIiVFK2A57gCWgsUcK
    hasql-pool-0.5.2.2-AZPrSgnkXvvKrLZo6NA13v
    hasql-transaction-1.0.1.1-G5lNiRO1M9UEkuNpGAvrul
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-Hsb6Y5xUgLKEUlBrgYk3WM
    insert-ordered-containers-0.2.5.3-aV927UxxNKGkIQ6PVKesc
    interpolatedstring-perl6-1.0.2-cwakeSqqCQ1w0NNedEqZn
    jose-0.10-9QJQ2U40YG0U23rRejWZy lens-5.3.1-FP95Rv35No71PYJue58Hxp
    lens-aeson-1.2.3-8s94Awm3usjEcZrN2XSxNE mtl-2.2.2
    network-3.1.4.0-7GxbLibXQB6BN49yptQL65
    network-uri-2.6.4.2-8swvJWOy75N7pbfI8WzbN
    optparse-applicative-0.18.1.0-2IPYcrIwIO6ByK20WziUUn
    parsec-3.1.16.1 protolude-0.3.5-BIzGL4BVFbT9CI767aD4fD
    regex-tdfa-1.3.2.4-KR4bJeAvhxe7xzLSY8hs1u
    retry-0.9.3.1-EAfvvx73dx91MIUnhmmiuB
    scientific-0.3.8.0-IrrbGrT9lim10QS5UtlqtE
    swagger2-2.8.10-BxwgNKVS7e3CnCdyI3YQIQ text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-I3GOf8berWn8tol6ImoSEe
    vault-0.3.1.5-IVkO043ANT2A8k5qB0IpqA
    vector-0.13.2.0-7bZcynEBhMGLMgNICkU4Wg
    wai-3.2.4-4xRq7ogBaZ8Gldz3i6sILu
    wai-cors-0.2.7-F8VdQYTSkofSbAOBRo2E2
    wai-extra-3.1.17-8YgjU15N6oKKg25qYeS49N
    wai-logger-2.5.0-LGHK8YVG51EAqGzYQj5bEc
    warp-3.3.30-AhKrB9wwsoN3qw8940l6Mi

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

