#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-B6DrnIBzeQpFG2xn4bzM5Q
key:                  postgrest-10.0.0-B6DrnIBzeQpFG2xn4bzM5Q
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  1b0cc3480920ccc088a7b4a29cf8be3f
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-B6DrnIBzeQpFG2xn4bzM5Q
depends:
    HTTP-4000.4.1-793eRan35SGkAenvkBqFG
    Ranged-sets-0.5.0-F4br6HHqG4eEvXBGgHorqx
    aeson-2.1.2.1-CM1TyKExMgH6p2KQqrdDHD
    auto-update-0.1.6-HpB1uwRefCP55Heyz7TFOv base-4.17.2.1
    base64-bytestring-1.2.1.0-Ag5zZV14qgS6mSqDcHZ0fu
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-9KyZd02Y5otGRG4cekIJFk
    cassava-0.5.4.1-85BYivkrrco2s9aI1yuhGZ
    configurator-pg-0.2.10-FxeFTmmtOvvBrxT1VnPS93 containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-5I6ATpayUCHZDT7SQ31C
    gitrev-1.3.1-KhpMNofwsxABRoyEGWB0ci
    hasql-1.5.0.5-DyAOKtq0NMk4sJQvmpOeua
    hasql-dynamic-statements-0.3.1.1-IIk6jApODjY81HXwGvW0KX
    hasql-notifications-0.2.0.5-DA9hMKqIBebCFp3UePkBkb
    hasql-pool-0.5.2.2-DXBCWJD4jtsKfvLGbK4KJv
    hasql-transaction-1.0.1.1-1VIMHxB6LYqDEMmhcObUgL
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-9tb655S6p8NAIcFLCK3aeD
    insert-ordered-containers-0.2.5.3-DOuUchnAwQD9Un7w7dBNpo
    interpolatedstring-perl6-1.0.2-Go8nB3b0Cnv9R3Tpb72oKW
    jose-0.10-FiEk5o1KJ1xFyAIsOWizHg lens-5.3.1-2VSC1EMe0UsGg1l2wcItEv
    lens-aeson-1.2.3-8EMmHdTPCjvKIylGCAABsH mtl-2.2.2
    network-3.1.4.0-BeHm9PhAGW35QMcXomVSuT
    network-uri-2.6.4.2-FpQrzNLQnEFHV7gxKif8bC
    optparse-applicative-0.18.1.0-EjA2kXCQRKtFyUz1duz30L
    parsec-3.1.16.1 protolude-0.3.5-JzkFnbE7gLw10eMySmsS3l
    regex-tdfa-1.3.2.4-H7zmkJvyPWEApzv9Yii17i
    retry-0.9.3.1-99LFa14dRkeAMufvu3olKW
    scientific-0.3.8.0-BCRNugtxiDS8UMOiZ0ZEsF
    swagger2-2.8.10-CBzRjwrZOC7B1A7TKBtZJ0 text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-FLM1pZb3BI5FpyNo5sVXNv
    vault-0.3.1.5-D02ECX3FHZ05Fytzff3TqC
    vector-0.13.2.0-LmFi28PTaN7DJJszRwFTiC
    wai-3.2.4-3rYyRDQ9fFM4U5H5e4fgc9
    wai-cors-0.2.7-9gtFnXcUPQMEas1FEQ3lY8
    wai-extra-3.1.17-5wguenEtMHG266p7AZdQP3
    wai-logger-2.5.0-7Rhi66tVpAKBot8PtHZ4sW
    warp-3.3.30-HPCf6dkLAlC8bCsy9YDsw

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

