#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-HQrwDRIoyY2DKFKRPRAojP
key:                  postgrest-10.0.0-HQrwDRIoyY2DKFKRPRAojP
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  c0fcb9b89a5fe60cae2f83378194cedd
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-HQrwDRIoyY2DKFKRPRAojP
depends:
    HTTP-4000.4.1-G35bzMbK85w6vAXEygxvmz
    Ranged-sets-0.5.0-9uslaFWMpEhJ48nAmweCZt
    aeson-2.1.2.1-LvJWrHbVhNW5j5NGQeCpIT
    auto-update-0.1.6-C6GoYiMMydQP3ieM5Lp9M base-4.17.2.1
    base64-bytestring-1.2.1.0-2WioaI2OOHv6enJjm95P5G
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-3W7hj1sdmUw2Fh1p1ue6cC
    cassava-0.5.4.1-HJqyjfVKtuG1yvRL0vph1C
    configurator-pg-0.2.10-6PNpRnmOleRAKzN37iRwbU containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4shfaVKBFn0Hnep1ZY6FZw directory-1.3.7.1
    either-5.0.3-BsEEiS8qvcZFl2xdEdw9HV
    gitrev-1.3.1-KhpMNofwsxABRoyEGWB0ci
    hasql-1.5.0.5-Gia3T42BUYiJT8Q3QOVtl5
    hasql-dynamic-statements-0.3.1.1-6fzhe2xF0jfCj8ZllCAREB
    hasql-notifications-0.2.0.5-7ta6pSACRPq6H30PKstA7G
    hasql-pool-0.5.2.2-2NkMqT1bPDK25Et5efzf0V
    hasql-transaction-1.0.1.1-68o8FddkQ7E53rN67THeyi
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-Lh5dVrkMNHmKdCH2kircer
    insert-ordered-containers-0.2.5.3-7hEOrvaqkoAHx2kFAN1oGm
    interpolatedstring-perl6-1.0.2-LBuZ9TjXV5J7i6LvxfF3DI
    jose-0.10-BjSaHKTJZSSGab7Q9Wn87i lens-5.3.1-1aYkBqtQBz47fMfVuyOc0c
    lens-aeson-1.2.3-Aaxs90kSZWE69X0KLLFavq mtl-2.2.2
    network-3.1.4.0-FZePtqluqyjFxAKIHdZ8Kd
    network-uri-2.6.4.2-U3v26HNy1l6rJ9sPiQ7eG
    optparse-applicative-0.18.1.0-GVqQIL9hvMpE39aQEaYXCj
    parsec-3.1.16.1 protolude-0.3.5-1M0L6LjUMFM5ztteSKjHp4
    regex-tdfa-1.3.2.4-4LZGUZ7xgnyFCAWQSNJRO0
    retry-0.9.3.1-ETQWgcSWcrWKH2E9s02iJ7
    scientific-0.3.8.0-Gqd1cbGsXroAPismtSLItY
    swagger2-2.8.10-7I6yP8y8p3Go2XxcMrR2D text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-Kt9XOM1GYdv4KClqugAe9a
    vault-0.3.1.5-8ISelB4zlnQDYJdWXjMWV8
    vector-0.13.2.0-7jLyylqham1Ij3AknS5IxU
    wai-3.2.4-FetgZkW1yF462S5B7261uz
    wai-cors-0.2.7-4VHQVm2OJ4NDQgkgYoT22y
    wai-extra-3.1.17-9o2GRbE7yL71upqB3T2Qcu
    wai-logger-2.5.0-4lW15dUloAfHUZ4V9U8ISL
    warp-3.3.30-EGgrKY5YvdGDHspHAqLxrS

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

